/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.DimensionStringValuesCopier;
import software.amazon.awssdk.services.iot.model.DimensionType;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateDimensionResponse
extends IotResponse
implements ToCopyableBuilder<Builder, UpdateDimensionResponse> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(UpdateDimensionResponse.getter(UpdateDimensionResponse::name)).setter(UpdateDimensionResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(UpdateDimensionResponse.getter(UpdateDimensionResponse::arn)).setter(UpdateDimensionResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(UpdateDimensionResponse.getter(UpdateDimensionResponse::typeAsString)).setter(UpdateDimensionResponse.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<List<String>> STRING_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("stringValues").getter(UpdateDimensionResponse.getter(UpdateDimensionResponse::stringValues)).setter(UpdateDimensionResponse.setter(Builder::stringValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stringValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationDate").getter(UpdateDimensionResponse.getter(UpdateDimensionResponse::creationDate)).setter(UpdateDimensionResponse.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastModifiedDate").getter(UpdateDimensionResponse.getter(UpdateDimensionResponse::lastModifiedDate)).setter(UpdateDimensionResponse.setter(Builder::lastModifiedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARN_FIELD, TYPE_FIELD, STRING_VALUES_FIELD, CREATION_DATE_FIELD, LAST_MODIFIED_DATE_FIELD));
    private final String name;
    private final String arn;
    private final String type;
    private final List<String> stringValues;
    private final Instant creationDate;
    private final Instant lastModifiedDate;

    private UpdateDimensionResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.arn = builder.arn;
        this.type = builder.type;
        this.stringValues = builder.stringValues;
        this.creationDate = builder.creationDate;
        this.lastModifiedDate = builder.lastModifiedDate;
    }

    public final String name() {
        return this.name;
    }

    public final String arn() {
        return this.arn;
    }

    public final DimensionType type() {
        return DimensionType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final boolean hasStringValues() {
        return this.stringValues != null && !(this.stringValues instanceof SdkAutoConstructList);
    }

    public final List<String> stringValues() {
        return this.stringValues;
    }

    public final Instant creationDate() {
        return this.creationDate;
    }

    public final Instant lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStringValues() ? this.stringValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDimensionResponse)) {
            return false;
        }
        UpdateDimensionResponse other = (UpdateDimensionResponse)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.typeAsString(), other.typeAsString()) && this.hasStringValues() == other.hasStringValues() && Objects.equals(this.stringValues(), other.stringValues()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.lastModifiedDate(), other.lastModifiedDate());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateDimensionResponse").add("Name", (Object)this.name()).add("Arn", (Object)this.arn()).add("Type", (Object)this.typeAsString()).add("StringValues", this.hasStringValues() ? this.stringValues() : null).add("CreationDate", (Object)this.creationDate()).add("LastModifiedDate", (Object)this.lastModifiedDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "stringValues": {
                return Optional.ofNullable(clazz.cast(this.stringValues()));
            }
            case "creationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "lastModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDimensionResponse, T> g) {
        return obj -> g.apply((UpdateDimensionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private String name;
        private String arn;
        private String type;
        private List<String> stringValues = DefaultSdkAutoConstructList.getInstance();
        private Instant creationDate;
        private Instant lastModifiedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDimensionResponse model) {
            super(model);
            this.name(model.name);
            this.arn(model.arn);
            this.type(model.type);
            this.stringValues(model.stringValues);
            this.creationDate(model.creationDate);
            this.lastModifiedDate(model.lastModifiedDate);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        @Transient
        public final Builder type(DimensionType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Collection<String> getStringValues() {
            if (this.stringValues instanceof SdkAutoConstructList) {
                return null;
            }
            return this.stringValues;
        }

        public final void setStringValues(Collection<String> stringValues) {
            this.stringValues = DimensionStringValuesCopier.copy(stringValues);
        }

        @Override
        @Transient
        public final Builder stringValues(Collection<String> stringValues) {
            this.stringValues = DimensionStringValuesCopier.copy(stringValues);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder stringValues(String ... stringValues) {
            this.stringValues(Arrays.asList(stringValues));
            return this;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        @Transient
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final Instant getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        @Transient
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        @Override
        public UpdateDimensionResponse build() {
            return new UpdateDimensionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateDimensionResponse> {
        public Builder name(String var1);

        public Builder arn(String var1);

        public Builder type(String var1);

        public Builder type(DimensionType var1);

        public Builder stringValues(Collection<String> var1);

        public Builder stringValues(String ... var1);

        public Builder creationDate(Instant var1);

        public Builder lastModifiedDate(Instant var1);
    }
}

