/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RemoveThingFromBillingGroupRequest extends IotRequest implements
        ToCopyableBuilder<RemoveThingFromBillingGroupRequest.Builder, RemoveThingFromBillingGroupRequest> {
    private static final SdkField<String> BILLING_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("billingGroupName").getter(getter(RemoveThingFromBillingGroupRequest::billingGroupName))
            .setter(setter(Builder::billingGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("billingGroupName").build()).build();

    private static final SdkField<String> BILLING_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("billingGroupArn").getter(getter(RemoveThingFromBillingGroupRequest::billingGroupArn))
            .setter(setter(Builder::billingGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("billingGroupArn").build()).build();

    private static final SdkField<String> THING_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("thingName").getter(getter(RemoveThingFromBillingGroupRequest::thingName))
            .setter(setter(Builder::thingName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingName").build()).build();

    private static final SdkField<String> THING_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("thingArn").getter(getter(RemoveThingFromBillingGroupRequest::thingArn))
            .setter(setter(Builder::thingArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BILLING_GROUP_NAME_FIELD,
            BILLING_GROUP_ARN_FIELD, THING_NAME_FIELD, THING_ARN_FIELD));

    private final String billingGroupName;

    private final String billingGroupArn;

    private final String thingName;

    private final String thingArn;

    private RemoveThingFromBillingGroupRequest(BuilderImpl builder) {
        super(builder);
        this.billingGroupName = builder.billingGroupName;
        this.billingGroupArn = builder.billingGroupArn;
        this.thingName = builder.thingName;
        this.thingArn = builder.thingArn;
    }

    /**
     * <p>
     * The name of the billing group.
     * </p>
     * 
     * @return The name of the billing group.
     */
    public final String billingGroupName() {
        return billingGroupName;
    }

    /**
     * <p>
     * The ARN of the billing group.
     * </p>
     * 
     * @return The ARN of the billing group.
     */
    public final String billingGroupArn() {
        return billingGroupArn;
    }

    /**
     * <p>
     * The name of the thing to be removed from the billing group.
     * </p>
     * 
     * @return The name of the thing to be removed from the billing group.
     */
    public final String thingName() {
        return thingName;
    }

    /**
     * <p>
     * The ARN of the thing to be removed from the billing group.
     * </p>
     * 
     * @return The ARN of the thing to be removed from the billing group.
     */
    public final String thingArn() {
        return thingArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(billingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(billingGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(thingName());
        hashCode = 31 * hashCode + Objects.hashCode(thingArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemoveThingFromBillingGroupRequest)) {
            return false;
        }
        RemoveThingFromBillingGroupRequest other = (RemoveThingFromBillingGroupRequest) obj;
        return Objects.equals(billingGroupName(), other.billingGroupName())
                && Objects.equals(billingGroupArn(), other.billingGroupArn()) && Objects.equals(thingName(), other.thingName())
                && Objects.equals(thingArn(), other.thingArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RemoveThingFromBillingGroupRequest").add("BillingGroupName", billingGroupName())
                .add("BillingGroupArn", billingGroupArn()).add("ThingName", thingName()).add("ThingArn", thingArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "billingGroupName":
            return Optional.ofNullable(clazz.cast(billingGroupName()));
        case "billingGroupArn":
            return Optional.ofNullable(clazz.cast(billingGroupArn()));
        case "thingName":
            return Optional.ofNullable(clazz.cast(thingName()));
        case "thingArn":
            return Optional.ofNullable(clazz.cast(thingArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RemoveThingFromBillingGroupRequest, T> g) {
        return obj -> g.apply((RemoveThingFromBillingGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotRequest.Builder, SdkPojo, CopyableBuilder<Builder, RemoveThingFromBillingGroupRequest> {
        /**
         * <p>
         * The name of the billing group.
         * </p>
         * 
         * @param billingGroupName
         *        The name of the billing group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billingGroupName(String billingGroupName);

        /**
         * <p>
         * The ARN of the billing group.
         * </p>
         * 
         * @param billingGroupArn
         *        The ARN of the billing group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billingGroupArn(String billingGroupArn);

        /**
         * <p>
         * The name of the thing to be removed from the billing group.
         * </p>
         * 
         * @param thingName
         *        The name of the thing to be removed from the billing group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingName(String thingName);

        /**
         * <p>
         * The ARN of the thing to be removed from the billing group.
         * </p>
         * 
         * @param thingArn
         *        The ARN of the thing to be removed from the billing group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingArn(String thingArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String billingGroupName;

        private String billingGroupArn;

        private String thingName;

        private String thingArn;

        private BuilderImpl() {
        }

        private BuilderImpl(RemoveThingFromBillingGroupRequest model) {
            super(model);
            billingGroupName(model.billingGroupName);
            billingGroupArn(model.billingGroupArn);
            thingName(model.thingName);
            thingArn(model.thingArn);
        }

        public final String getBillingGroupName() {
            return billingGroupName;
        }

        public final void setBillingGroupName(String billingGroupName) {
            this.billingGroupName = billingGroupName;
        }

        @Override
        @Transient
        public final Builder billingGroupName(String billingGroupName) {
            this.billingGroupName = billingGroupName;
            return this;
        }

        public final String getBillingGroupArn() {
            return billingGroupArn;
        }

        public final void setBillingGroupArn(String billingGroupArn) {
            this.billingGroupArn = billingGroupArn;
        }

        @Override
        @Transient
        public final Builder billingGroupArn(String billingGroupArn) {
            this.billingGroupArn = billingGroupArn;
            return this;
        }

        public final String getThingName() {
            return thingName;
        }

        public final void setThingName(String thingName) {
            this.thingName = thingName;
        }

        @Override
        @Transient
        public final Builder thingName(String thingName) {
            this.thingName = thingName;
            return this;
        }

        public final String getThingArn() {
            return thingArn;
        }

        public final void setThingArn(String thingArn) {
            this.thingArn = thingArn;
        }

        @Override
        @Transient
        public final Builder thingArn(String thingArn) {
            this.thingArn = thingArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RemoveThingFromBillingGroupRequest build() {
            return new RemoveThingFromBillingGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
