/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.BillingGroupProperties;
import software.amazon.awssdk.services.iot.model.IotRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateBillingGroupRequest
extends IotRequest
implements ToCopyableBuilder<Builder, UpdateBillingGroupRequest> {
    private static final SdkField<String> BILLING_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("billingGroupName").getter(UpdateBillingGroupRequest.getter(UpdateBillingGroupRequest::billingGroupName)).setter(UpdateBillingGroupRequest.setter(Builder::billingGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("billingGroupName").build()}).build();
    private static final SdkField<BillingGroupProperties> BILLING_GROUP_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("billingGroupProperties").getter(UpdateBillingGroupRequest.getter(UpdateBillingGroupRequest::billingGroupProperties)).setter(UpdateBillingGroupRequest.setter(Builder::billingGroupProperties)).constructor(BillingGroupProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("billingGroupProperties").build()}).build();
    private static final SdkField<Long> EXPECTED_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("expectedVersion").getter(UpdateBillingGroupRequest.getter(UpdateBillingGroupRequest::expectedVersion)).setter(UpdateBillingGroupRequest.setter(Builder::expectedVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expectedVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BILLING_GROUP_NAME_FIELD, BILLING_GROUP_PROPERTIES_FIELD, EXPECTED_VERSION_FIELD));
    private final String billingGroupName;
    private final BillingGroupProperties billingGroupProperties;
    private final Long expectedVersion;

    private UpdateBillingGroupRequest(BuilderImpl builder) {
        super(builder);
        this.billingGroupName = builder.billingGroupName;
        this.billingGroupProperties = builder.billingGroupProperties;
        this.expectedVersion = builder.expectedVersion;
    }

    public final String billingGroupName() {
        return this.billingGroupName;
    }

    public final BillingGroupProperties billingGroupProperties() {
        return this.billingGroupProperties;
    }

    public final Long expectedVersion() {
        return this.expectedVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.billingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.billingGroupProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.expectedVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBillingGroupRequest)) {
            return false;
        }
        UpdateBillingGroupRequest other = (UpdateBillingGroupRequest)((Object)obj);
        return Objects.equals(this.billingGroupName(), other.billingGroupName()) && Objects.equals(this.billingGroupProperties(), other.billingGroupProperties()) && Objects.equals(this.expectedVersion(), other.expectedVersion());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateBillingGroupRequest").add("BillingGroupName", (Object)this.billingGroupName()).add("BillingGroupProperties", (Object)this.billingGroupProperties()).add("ExpectedVersion", (Object)this.expectedVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "billingGroupName": {
                return Optional.ofNullable(clazz.cast(this.billingGroupName()));
            }
            case "billingGroupProperties": {
                return Optional.ofNullable(clazz.cast(this.billingGroupProperties()));
            }
            case "expectedVersion": {
                return Optional.ofNullable(clazz.cast(this.expectedVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateBillingGroupRequest, T> g) {
        return obj -> g.apply((UpdateBillingGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotRequest.BuilderImpl
    implements Builder {
        private String billingGroupName;
        private BillingGroupProperties billingGroupProperties;
        private Long expectedVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBillingGroupRequest model) {
            super(model);
            this.billingGroupName(model.billingGroupName);
            this.billingGroupProperties(model.billingGroupProperties);
            this.expectedVersion(model.expectedVersion);
        }

        public final String getBillingGroupName() {
            return this.billingGroupName;
        }

        public final void setBillingGroupName(String billingGroupName) {
            this.billingGroupName = billingGroupName;
        }

        @Override
        @Transient
        public final Builder billingGroupName(String billingGroupName) {
            this.billingGroupName = billingGroupName;
            return this;
        }

        public final BillingGroupProperties.Builder getBillingGroupProperties() {
            return this.billingGroupProperties != null ? this.billingGroupProperties.toBuilder() : null;
        }

        public final void setBillingGroupProperties(BillingGroupProperties.BuilderImpl billingGroupProperties) {
            this.billingGroupProperties = billingGroupProperties != null ? billingGroupProperties.build() : null;
        }

        @Override
        @Transient
        public final Builder billingGroupProperties(BillingGroupProperties billingGroupProperties) {
            this.billingGroupProperties = billingGroupProperties;
            return this;
        }

        public final Long getExpectedVersion() {
            return this.expectedVersion;
        }

        public final void setExpectedVersion(Long expectedVersion) {
            this.expectedVersion = expectedVersion;
        }

        @Override
        @Transient
        public final Builder expectedVersion(Long expectedVersion) {
            this.expectedVersion = expectedVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateBillingGroupRequest build() {
            return new UpdateBillingGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateBillingGroupRequest> {
        public Builder billingGroupName(String var1);

        public Builder billingGroupProperties(BillingGroupProperties var1);

        default public Builder billingGroupProperties(Consumer<BillingGroupProperties.Builder> billingGroupProperties) {
            return this.billingGroupProperties((BillingGroupProperties)((BillingGroupProperties.Builder)BillingGroupProperties.builder().applyMutation(billingGroupProperties)).build());
        }

        public Builder expectedVersion(Long var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

