/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateJobRequest extends IotRequest implements ToCopyableBuilder<CreateJobRequest.Builder, CreateJobRequest> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("jobId")
            .getter(getter(CreateJobRequest::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("jobId").build()).build();

    private static final SdkField<List<String>> TARGETS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("targets")
            .getter(getter(CreateJobRequest::targets))
            .setter(setter(Builder::targets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DOCUMENT_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("documentSource").getter(getter(CreateJobRequest::documentSource))
            .setter(setter(Builder::documentSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documentSource").build()).build();

    private static final SdkField<String> DOCUMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("document").getter(getter(CreateJobRequest::document)).setter(setter(Builder::document))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("document").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateJobRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<PresignedUrlConfig> PRESIGNED_URL_CONFIG_FIELD = SdkField
            .<PresignedUrlConfig> builder(MarshallingType.SDK_POJO).memberName("presignedUrlConfig")
            .getter(getter(CreateJobRequest::presignedUrlConfig)).setter(setter(Builder::presignedUrlConfig))
            .constructor(PresignedUrlConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("presignedUrlConfig").build())
            .build();

    private static final SdkField<String> TARGET_SELECTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetSelection").getter(getter(CreateJobRequest::targetSelectionAsString))
            .setter(setter(Builder::targetSelection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetSelection").build()).build();

    private static final SdkField<JobExecutionsRolloutConfig> JOB_EXECUTIONS_ROLLOUT_CONFIG_FIELD = SdkField
            .<JobExecutionsRolloutConfig> builder(MarshallingType.SDK_POJO)
            .memberName("jobExecutionsRolloutConfig")
            .getter(getter(CreateJobRequest::jobExecutionsRolloutConfig))
            .setter(setter(Builder::jobExecutionsRolloutConfig))
            .constructor(JobExecutionsRolloutConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobExecutionsRolloutConfig").build())
            .build();

    private static final SdkField<AbortConfig> ABORT_CONFIG_FIELD = SdkField.<AbortConfig> builder(MarshallingType.SDK_POJO)
            .memberName("abortConfig").getter(getter(CreateJobRequest::abortConfig)).setter(setter(Builder::abortConfig))
            .constructor(AbortConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("abortConfig").build()).build();

    private static final SdkField<TimeoutConfig> TIMEOUT_CONFIG_FIELD = SdkField
            .<TimeoutConfig> builder(MarshallingType.SDK_POJO).memberName("timeoutConfig")
            .getter(getter(CreateJobRequest::timeoutConfig)).setter(setter(Builder::timeoutConfig))
            .constructor(TimeoutConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutConfig").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(CreateJobRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NAMESPACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("namespaceId").getter(getter(CreateJobRequest::namespaceId)).setter(setter(Builder::namespaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespaceId").build()).build();

    private static final SdkField<String> JOB_TEMPLATE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobTemplateArn").getter(getter(CreateJobRequest::jobTemplateArn))
            .setter(setter(Builder::jobTemplateArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobTemplateArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD, TARGETS_FIELD,
            DOCUMENT_SOURCE_FIELD, DOCUMENT_FIELD, DESCRIPTION_FIELD, PRESIGNED_URL_CONFIG_FIELD, TARGET_SELECTION_FIELD,
            JOB_EXECUTIONS_ROLLOUT_CONFIG_FIELD, ABORT_CONFIG_FIELD, TIMEOUT_CONFIG_FIELD, TAGS_FIELD, NAMESPACE_ID_FIELD,
            JOB_TEMPLATE_ARN_FIELD));

    private final String jobId;

    private final List<String> targets;

    private final String documentSource;

    private final String document;

    private final String description;

    private final PresignedUrlConfig presignedUrlConfig;

    private final String targetSelection;

    private final JobExecutionsRolloutConfig jobExecutionsRolloutConfig;

    private final AbortConfig abortConfig;

    private final TimeoutConfig timeoutConfig;

    private final List<Tag> tags;

    private final String namespaceId;

    private final String jobTemplateArn;

    private CreateJobRequest(BuilderImpl builder) {
        super(builder);
        this.jobId = builder.jobId;
        this.targets = builder.targets;
        this.documentSource = builder.documentSource;
        this.document = builder.document;
        this.description = builder.description;
        this.presignedUrlConfig = builder.presignedUrlConfig;
        this.targetSelection = builder.targetSelection;
        this.jobExecutionsRolloutConfig = builder.jobExecutionsRolloutConfig;
        this.abortConfig = builder.abortConfig;
        this.timeoutConfig = builder.timeoutConfig;
        this.tags = builder.tags;
        this.namespaceId = builder.namespaceId;
        this.jobTemplateArn = builder.jobTemplateArn;
    }

    /**
     * <p>
     * A job identifier which must be unique for your Amazon Web Services account. We recommend using a UUID.
     * Alpha-numeric characters, "-" and "_" are valid for use here.
     * </p>
     * 
     * @return A job identifier which must be unique for your Amazon Web Services account. We recommend using a UUID.
     *         Alpha-numeric characters, "-" and "_" are valid for use here.
     */
    public final String jobId() {
        return jobId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Targets property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTargets() {
        return targets != null && !(targets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of things and thing groups to which the job should be sent.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargets} method.
     * </p>
     * 
     * @return A list of things and thing groups to which the job should be sent.
     */
    public final List<String> targets() {
        return targets;
    }

    /**
     * <p>
     * An S3 link to the job document. Required if you don't specify a value for <code>document</code>.
     * </p>
     * <note>
     * <p>
     * If the job document resides in an S3 bucket, you must use a placeholder link when specifying the document.
     * </p>
     * <p>
     * The placeholder link is of the following form:
     * </p>
     * <p>
     * <code>${aws:iot:s3-presigned-url:https://s3.amazonaws.com/<i>bucket</i>/<i>key</i>}</code>
     * </p>
     * <p>
     * where <i>bucket</i> is your bucket name and <i>key</i> is the object in the bucket to which you are linking.
     * </p>
     * </note>
     * 
     * @return An S3 link to the job document. Required if you don't specify a value for <code>document</code>.</p>
     *         <note>
     *         <p>
     *         If the job document resides in an S3 bucket, you must use a placeholder link when specifying the
     *         document.
     *         </p>
     *         <p>
     *         The placeholder link is of the following form:
     *         </p>
     *         <p>
     *         <code>${aws:iot:s3-presigned-url:https://s3.amazonaws.com/<i>bucket</i>/<i>key</i>}</code>
     *         </p>
     *         <p>
     *         where <i>bucket</i> is your bucket name and <i>key</i> is the object in the bucket to which you are
     *         linking.
     *         </p>
     */
    public final String documentSource() {
        return documentSource;
    }

    /**
     * <p>
     * The job document. Required if you don't specify a value for <code>documentSource</code>.
     * </p>
     * 
     * @return The job document. Required if you don't specify a value for <code>documentSource</code>.
     */
    public final String document() {
        return document;
    }

    /**
     * <p>
     * A short text description of the job.
     * </p>
     * 
     * @return A short text description of the job.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Configuration information for pre-signed S3 URLs.
     * </p>
     * 
     * @return Configuration information for pre-signed S3 URLs.
     */
    public final PresignedUrlConfig presignedUrlConfig() {
        return presignedUrlConfig;
    }

    /**
     * <p>
     * Specifies whether the job will continue to run (CONTINUOUS), or will be complete after all those things specified
     * as targets have completed the job (SNAPSHOT). If continuous, the job may also be run on a thing when a change is
     * detected in a target. For example, a job will run on a thing when the thing is added to a target group, even
     * after the job was completed by all things originally in the group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetSelection}
     * will return {@link TargetSelection#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #targetSelectionAsString}.
     * </p>
     * 
     * @return Specifies whether the job will continue to run (CONTINUOUS), or will be complete after all those things
     *         specified as targets have completed the job (SNAPSHOT). If continuous, the job may also be run on a thing
     *         when a change is detected in a target. For example, a job will run on a thing when the thing is added to
     *         a target group, even after the job was completed by all things originally in the group.
     * @see TargetSelection
     */
    public final TargetSelection targetSelection() {
        return TargetSelection.fromValue(targetSelection);
    }

    /**
     * <p>
     * Specifies whether the job will continue to run (CONTINUOUS), or will be complete after all those things specified
     * as targets have completed the job (SNAPSHOT). If continuous, the job may also be run on a thing when a change is
     * detected in a target. For example, a job will run on a thing when the thing is added to a target group, even
     * after the job was completed by all things originally in the group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetSelection}
     * will return {@link TargetSelection#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #targetSelectionAsString}.
     * </p>
     * 
     * @return Specifies whether the job will continue to run (CONTINUOUS), or will be complete after all those things
     *         specified as targets have completed the job (SNAPSHOT). If continuous, the job may also be run on a thing
     *         when a change is detected in a target. For example, a job will run on a thing when the thing is added to
     *         a target group, even after the job was completed by all things originally in the group.
     * @see TargetSelection
     */
    public final String targetSelectionAsString() {
        return targetSelection;
    }

    /**
     * <p>
     * Allows you to create a staged rollout of the job.
     * </p>
     * 
     * @return Allows you to create a staged rollout of the job.
     */
    public final JobExecutionsRolloutConfig jobExecutionsRolloutConfig() {
        return jobExecutionsRolloutConfig;
    }

    /**
     * <p>
     * Allows you to create criteria to abort a job.
     * </p>
     * 
     * @return Allows you to create criteria to abort a job.
     */
    public final AbortConfig abortConfig() {
        return abortConfig;
    }

    /**
     * <p>
     * Specifies the amount of time each device has to finish its execution of the job. The timer is started when the
     * job execution status is set to <code>IN_PROGRESS</code>. If the job execution status is not set to another
     * terminal state before the time expires, it will be automatically set to <code>TIMED_OUT</code>.
     * </p>
     * 
     * @return Specifies the amount of time each device has to finish its execution of the job. The timer is started
     *         when the job execution status is set to <code>IN_PROGRESS</code>. If the job execution status is not set
     *         to another terminal state before the time expires, it will be automatically set to <code>TIMED_OUT</code>
     *         .
     */
    public final TimeoutConfig timeoutConfig() {
        return timeoutConfig;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Metadata which can be used to manage the job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Metadata which can be used to manage the job.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The namespace used to indicate that a job is a customer-managed job.
     * </p>
     * <p>
     * When you specify a value for this parameter, Amazon Web Services IoT Core sends jobs notifications to MQTT topics
     * that contain the value in the following format.
     * </p>
     * <p>
     * <code>$aws/things/<i>THING_NAME</i>/jobs/<i>JOB_ID</i>/notify-namespace-<i>NAMESPACE_ID</i>/</code>
     * </p>
     * <note>
     * <p>
     * The <code>namespaceId</code> feature is in public preview.
     * </p>
     * </note>
     * 
     * @return The namespace used to indicate that a job is a customer-managed job.</p>
     *         <p>
     *         When you specify a value for this parameter, Amazon Web Services IoT Core sends jobs notifications to
     *         MQTT topics that contain the value in the following format.
     *         </p>
     *         <p>
     *         <code>$aws/things/<i>THING_NAME</i>/jobs/<i>JOB_ID</i>/notify-namespace-<i>NAMESPACE_ID</i>/</code>
     *         </p>
     *         <note>
     *         <p>
     *         The <code>namespaceId</code> feature is in public preview.
     *         </p>
     */
    public final String namespaceId() {
        return namespaceId;
    }

    /**
     * <p>
     * The ARN of the job template used to create the job.
     * </p>
     * 
     * @return The ARN of the job template used to create the job.
     */
    public final String jobTemplateArn() {
        return jobTemplateArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTargets() ? targets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(documentSource());
        hashCode = 31 * hashCode + Objects.hashCode(document());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(presignedUrlConfig());
        hashCode = 31 * hashCode + Objects.hashCode(targetSelectionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(jobExecutionsRolloutConfig());
        hashCode = 31 * hashCode + Objects.hashCode(abortConfig());
        hashCode = 31 * hashCode + Objects.hashCode(timeoutConfig());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(namespaceId());
        hashCode = 31 * hashCode + Objects.hashCode(jobTemplateArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateJobRequest)) {
            return false;
        }
        CreateJobRequest other = (CreateJobRequest) obj;
        return Objects.equals(jobId(), other.jobId()) && hasTargets() == other.hasTargets()
                && Objects.equals(targets(), other.targets()) && Objects.equals(documentSource(), other.documentSource())
                && Objects.equals(document(), other.document()) && Objects.equals(description(), other.description())
                && Objects.equals(presignedUrlConfig(), other.presignedUrlConfig())
                && Objects.equals(targetSelectionAsString(), other.targetSelectionAsString())
                && Objects.equals(jobExecutionsRolloutConfig(), other.jobExecutionsRolloutConfig())
                && Objects.equals(abortConfig(), other.abortConfig()) && Objects.equals(timeoutConfig(), other.timeoutConfig())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(namespaceId(), other.namespaceId()) && Objects.equals(jobTemplateArn(), other.jobTemplateArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateJobRequest").add("JobId", jobId()).add("Targets", hasTargets() ? targets() : null)
                .add("DocumentSource", documentSource()).add("Document", document()).add("Description", description())
                .add("PresignedUrlConfig", presignedUrlConfig()).add("TargetSelection", targetSelectionAsString())
                .add("JobExecutionsRolloutConfig", jobExecutionsRolloutConfig()).add("AbortConfig", abortConfig())
                .add("TimeoutConfig", timeoutConfig()).add("Tags", hasTags() ? tags() : null).add("NamespaceId", namespaceId())
                .add("JobTemplateArn", jobTemplateArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "targets":
            return Optional.ofNullable(clazz.cast(targets()));
        case "documentSource":
            return Optional.ofNullable(clazz.cast(documentSource()));
        case "document":
            return Optional.ofNullable(clazz.cast(document()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "presignedUrlConfig":
            return Optional.ofNullable(clazz.cast(presignedUrlConfig()));
        case "targetSelection":
            return Optional.ofNullable(clazz.cast(targetSelectionAsString()));
        case "jobExecutionsRolloutConfig":
            return Optional.ofNullable(clazz.cast(jobExecutionsRolloutConfig()));
        case "abortConfig":
            return Optional.ofNullable(clazz.cast(abortConfig()));
        case "timeoutConfig":
            return Optional.ofNullable(clazz.cast(timeoutConfig()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "namespaceId":
            return Optional.ofNullable(clazz.cast(namespaceId()));
        case "jobTemplateArn":
            return Optional.ofNullable(clazz.cast(jobTemplateArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateJobRequest, T> g) {
        return obj -> g.apply((CreateJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateJobRequest> {
        /**
         * <p>
         * A job identifier which must be unique for your Amazon Web Services account. We recommend using a UUID.
         * Alpha-numeric characters, "-" and "_" are valid for use here.
         * </p>
         * 
         * @param jobId
         *        A job identifier which must be unique for your Amazon Web Services account. We recommend using a UUID.
         *        Alpha-numeric characters, "-" and "_" are valid for use here.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * A list of things and thing groups to which the job should be sent.
         * </p>
         * 
         * @param targets
         *        A list of things and thing groups to which the job should be sent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(Collection<String> targets);

        /**
         * <p>
         * A list of things and thing groups to which the job should be sent.
         * </p>
         * 
         * @param targets
         *        A list of things and thing groups to which the job should be sent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(String... targets);

        /**
         * <p>
         * An S3 link to the job document. Required if you don't specify a value for <code>document</code>.
         * </p>
         * <note>
         * <p>
         * If the job document resides in an S3 bucket, you must use a placeholder link when specifying the document.
         * </p>
         * <p>
         * The placeholder link is of the following form:
         * </p>
         * <p>
         * <code>${aws:iot:s3-presigned-url:https://s3.amazonaws.com/<i>bucket</i>/<i>key</i>}</code>
         * </p>
         * <p>
         * where <i>bucket</i> is your bucket name and <i>key</i> is the object in the bucket to which you are linking.
         * </p>
         * </note>
         * 
         * @param documentSource
         *        An S3 link to the job document. Required if you don't specify a value for <code>document</code>.</p>
         *        <note>
         *        <p>
         *        If the job document resides in an S3 bucket, you must use a placeholder link when specifying the
         *        document.
         *        </p>
         *        <p>
         *        The placeholder link is of the following form:
         *        </p>
         *        <p>
         *        <code>${aws:iot:s3-presigned-url:https://s3.amazonaws.com/<i>bucket</i>/<i>key</i>}</code>
         *        </p>
         *        <p>
         *        where <i>bucket</i> is your bucket name and <i>key</i> is the object in the bucket to which you are
         *        linking.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentSource(String documentSource);

        /**
         * <p>
         * The job document. Required if you don't specify a value for <code>documentSource</code>.
         * </p>
         * 
         * @param document
         *        The job document. Required if you don't specify a value for <code>documentSource</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder document(String document);

        /**
         * <p>
         * A short text description of the job.
         * </p>
         * 
         * @param description
         *        A short text description of the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Configuration information for pre-signed S3 URLs.
         * </p>
         * 
         * @param presignedUrlConfig
         *        Configuration information for pre-signed S3 URLs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder presignedUrlConfig(PresignedUrlConfig presignedUrlConfig);

        /**
         * <p>
         * Configuration information for pre-signed S3 URLs.
         * </p>
         * This is a convenience that creates an instance of the {@link PresignedUrlConfig.Builder} avoiding the need to
         * create one manually via {@link PresignedUrlConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link PresignedUrlConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #presignedUrlConfig(PresignedUrlConfig)}.
         * 
         * @param presignedUrlConfig
         *        a consumer that will call methods on {@link PresignedUrlConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #presignedUrlConfig(PresignedUrlConfig)
         */
        default Builder presignedUrlConfig(Consumer<PresignedUrlConfig.Builder> presignedUrlConfig) {
            return presignedUrlConfig(PresignedUrlConfig.builder().applyMutation(presignedUrlConfig).build());
        }

        /**
         * <p>
         * Specifies whether the job will continue to run (CONTINUOUS), or will be complete after all those things
         * specified as targets have completed the job (SNAPSHOT). If continuous, the job may also be run on a thing
         * when a change is detected in a target. For example, a job will run on a thing when the thing is added to a
         * target group, even after the job was completed by all things originally in the group.
         * </p>
         * 
         * @param targetSelection
         *        Specifies whether the job will continue to run (CONTINUOUS), or will be complete after all those
         *        things specified as targets have completed the job (SNAPSHOT). If continuous, the job may also be run
         *        on a thing when a change is detected in a target. For example, a job will run on a thing when the
         *        thing is added to a target group, even after the job was completed by all things originally in the
         *        group.
         * @see TargetSelection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetSelection
         */
        Builder targetSelection(String targetSelection);

        /**
         * <p>
         * Specifies whether the job will continue to run (CONTINUOUS), or will be complete after all those things
         * specified as targets have completed the job (SNAPSHOT). If continuous, the job may also be run on a thing
         * when a change is detected in a target. For example, a job will run on a thing when the thing is added to a
         * target group, even after the job was completed by all things originally in the group.
         * </p>
         * 
         * @param targetSelection
         *        Specifies whether the job will continue to run (CONTINUOUS), or will be complete after all those
         *        things specified as targets have completed the job (SNAPSHOT). If continuous, the job may also be run
         *        on a thing when a change is detected in a target. For example, a job will run on a thing when the
         *        thing is added to a target group, even after the job was completed by all things originally in the
         *        group.
         * @see TargetSelection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetSelection
         */
        Builder targetSelection(TargetSelection targetSelection);

        /**
         * <p>
         * Allows you to create a staged rollout of the job.
         * </p>
         * 
         * @param jobExecutionsRolloutConfig
         *        Allows you to create a staged rollout of the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobExecutionsRolloutConfig(JobExecutionsRolloutConfig jobExecutionsRolloutConfig);

        /**
         * <p>
         * Allows you to create a staged rollout of the job.
         * </p>
         * This is a convenience that creates an instance of the {@link JobExecutionsRolloutConfig.Builder} avoiding the
         * need to create one manually via {@link JobExecutionsRolloutConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link JobExecutionsRolloutConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #jobExecutionsRolloutConfig(JobExecutionsRolloutConfig)}.
         * 
         * @param jobExecutionsRolloutConfig
         *        a consumer that will call methods on {@link JobExecutionsRolloutConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobExecutionsRolloutConfig(JobExecutionsRolloutConfig)
         */
        default Builder jobExecutionsRolloutConfig(Consumer<JobExecutionsRolloutConfig.Builder> jobExecutionsRolloutConfig) {
            return jobExecutionsRolloutConfig(JobExecutionsRolloutConfig.builder().applyMutation(jobExecutionsRolloutConfig)
                    .build());
        }

        /**
         * <p>
         * Allows you to create criteria to abort a job.
         * </p>
         * 
         * @param abortConfig
         *        Allows you to create criteria to abort a job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder abortConfig(AbortConfig abortConfig);

        /**
         * <p>
         * Allows you to create criteria to abort a job.
         * </p>
         * This is a convenience that creates an instance of the {@link AbortConfig.Builder} avoiding the need to create
         * one manually via {@link AbortConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link AbortConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #abortConfig(AbortConfig)}.
         * 
         * @param abortConfig
         *        a consumer that will call methods on {@link AbortConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #abortConfig(AbortConfig)
         */
        default Builder abortConfig(Consumer<AbortConfig.Builder> abortConfig) {
            return abortConfig(AbortConfig.builder().applyMutation(abortConfig).build());
        }

        /**
         * <p>
         * Specifies the amount of time each device has to finish its execution of the job. The timer is started when
         * the job execution status is set to <code>IN_PROGRESS</code>. If the job execution status is not set to
         * another terminal state before the time expires, it will be automatically set to <code>TIMED_OUT</code>.
         * </p>
         * 
         * @param timeoutConfig
         *        Specifies the amount of time each device has to finish its execution of the job. The timer is started
         *        when the job execution status is set to <code>IN_PROGRESS</code>. If the job execution status is not
         *        set to another terminal state before the time expires, it will be automatically set to
         *        <code>TIMED_OUT</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeoutConfig(TimeoutConfig timeoutConfig);

        /**
         * <p>
         * Specifies the amount of time each device has to finish its execution of the job. The timer is started when
         * the job execution status is set to <code>IN_PROGRESS</code>. If the job execution status is not set to
         * another terminal state before the time expires, it will be automatically set to <code>TIMED_OUT</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link TimeoutConfig.Builder} avoiding the need to
         * create one manually via {@link TimeoutConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link TimeoutConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #timeoutConfig(TimeoutConfig)}.
         * 
         * @param timeoutConfig
         *        a consumer that will call methods on {@link TimeoutConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timeoutConfig(TimeoutConfig)
         */
        default Builder timeoutConfig(Consumer<TimeoutConfig.Builder> timeoutConfig) {
            return timeoutConfig(TimeoutConfig.builder().applyMutation(timeoutConfig).build());
        }

        /**
         * <p>
         * Metadata which can be used to manage the job.
         * </p>
         * 
         * @param tags
         *        Metadata which can be used to manage the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Metadata which can be used to manage the job.
         * </p>
         * 
         * @param tags
         *        Metadata which can be used to manage the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Metadata which can be used to manage the job.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The namespace used to indicate that a job is a customer-managed job.
         * </p>
         * <p>
         * When you specify a value for this parameter, Amazon Web Services IoT Core sends jobs notifications to MQTT
         * topics that contain the value in the following format.
         * </p>
         * <p>
         * <code>$aws/things/<i>THING_NAME</i>/jobs/<i>JOB_ID</i>/notify-namespace-<i>NAMESPACE_ID</i>/</code>
         * </p>
         * <note>
         * <p>
         * The <code>namespaceId</code> feature is in public preview.
         * </p>
         * </note>
         * 
         * @param namespaceId
         *        The namespace used to indicate that a job is a customer-managed job.</p>
         *        <p>
         *        When you specify a value for this parameter, Amazon Web Services IoT Core sends jobs notifications to
         *        MQTT topics that contain the value in the following format.
         *        </p>
         *        <p>
         *        <code>$aws/things/<i>THING_NAME</i>/jobs/<i>JOB_ID</i>/notify-namespace-<i>NAMESPACE_ID</i>/</code>
         *        </p>
         *        <note>
         *        <p>
         *        The <code>namespaceId</code> feature is in public preview.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespaceId(String namespaceId);

        /**
         * <p>
         * The ARN of the job template used to create the job.
         * </p>
         * 
         * @param jobTemplateArn
         *        The ARN of the job template used to create the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobTemplateArn(String jobTemplateArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String jobId;

        private List<String> targets = DefaultSdkAutoConstructList.getInstance();

        private String documentSource;

        private String document;

        private String description;

        private PresignedUrlConfig presignedUrlConfig;

        private String targetSelection;

        private JobExecutionsRolloutConfig jobExecutionsRolloutConfig;

        private AbortConfig abortConfig;

        private TimeoutConfig timeoutConfig;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String namespaceId;

        private String jobTemplateArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateJobRequest model) {
            super(model);
            jobId(model.jobId);
            targets(model.targets);
            documentSource(model.documentSource);
            document(model.document);
            description(model.description);
            presignedUrlConfig(model.presignedUrlConfig);
            targetSelection(model.targetSelection);
            jobExecutionsRolloutConfig(model.jobExecutionsRolloutConfig);
            abortConfig(model.abortConfig);
            timeoutConfig(model.timeoutConfig);
            tags(model.tags);
            namespaceId(model.namespaceId);
            jobTemplateArn(model.jobTemplateArn);
        }

        public final String getJobId() {
            return jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        @Transient
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final Collection<String> getTargets() {
            if (targets instanceof SdkAutoConstructList) {
                return null;
            }
            return targets;
        }

        public final void setTargets(Collection<String> targets) {
            this.targets = JobTargetsCopier.copy(targets);
        }

        @Override
        @Transient
        public final Builder targets(Collection<String> targets) {
            this.targets = JobTargetsCopier.copy(targets);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder targets(String... targets) {
            targets(Arrays.asList(targets));
            return this;
        }

        public final String getDocumentSource() {
            return documentSource;
        }

        public final void setDocumentSource(String documentSource) {
            this.documentSource = documentSource;
        }

        @Override
        @Transient
        public final Builder documentSource(String documentSource) {
            this.documentSource = documentSource;
            return this;
        }

        public final String getDocument() {
            return document;
        }

        public final void setDocument(String document) {
            this.document = document;
        }

        @Override
        @Transient
        public final Builder document(String document) {
            this.document = document;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final PresignedUrlConfig.Builder getPresignedUrlConfig() {
            return presignedUrlConfig != null ? presignedUrlConfig.toBuilder() : null;
        }

        public final void setPresignedUrlConfig(PresignedUrlConfig.BuilderImpl presignedUrlConfig) {
            this.presignedUrlConfig = presignedUrlConfig != null ? presignedUrlConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder presignedUrlConfig(PresignedUrlConfig presignedUrlConfig) {
            this.presignedUrlConfig = presignedUrlConfig;
            return this;
        }

        public final String getTargetSelection() {
            return targetSelection;
        }

        public final void setTargetSelection(String targetSelection) {
            this.targetSelection = targetSelection;
        }

        @Override
        @Transient
        public final Builder targetSelection(String targetSelection) {
            this.targetSelection = targetSelection;
            return this;
        }

        @Override
        @Transient
        public final Builder targetSelection(TargetSelection targetSelection) {
            this.targetSelection(targetSelection == null ? null : targetSelection.toString());
            return this;
        }

        public final JobExecutionsRolloutConfig.Builder getJobExecutionsRolloutConfig() {
            return jobExecutionsRolloutConfig != null ? jobExecutionsRolloutConfig.toBuilder() : null;
        }

        public final void setJobExecutionsRolloutConfig(JobExecutionsRolloutConfig.BuilderImpl jobExecutionsRolloutConfig) {
            this.jobExecutionsRolloutConfig = jobExecutionsRolloutConfig != null ? jobExecutionsRolloutConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder jobExecutionsRolloutConfig(JobExecutionsRolloutConfig jobExecutionsRolloutConfig) {
            this.jobExecutionsRolloutConfig = jobExecutionsRolloutConfig;
            return this;
        }

        public final AbortConfig.Builder getAbortConfig() {
            return abortConfig != null ? abortConfig.toBuilder() : null;
        }

        public final void setAbortConfig(AbortConfig.BuilderImpl abortConfig) {
            this.abortConfig = abortConfig != null ? abortConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder abortConfig(AbortConfig abortConfig) {
            this.abortConfig = abortConfig;
            return this;
        }

        public final TimeoutConfig.Builder getTimeoutConfig() {
            return timeoutConfig != null ? timeoutConfig.toBuilder() : null;
        }

        public final void setTimeoutConfig(TimeoutConfig.BuilderImpl timeoutConfig) {
            this.timeoutConfig = timeoutConfig != null ? timeoutConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder timeoutConfig(TimeoutConfig timeoutConfig) {
            this.timeoutConfig = timeoutConfig;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNamespaceId() {
            return namespaceId;
        }

        public final void setNamespaceId(String namespaceId) {
            this.namespaceId = namespaceId;
        }

        @Override
        @Transient
        public final Builder namespaceId(String namespaceId) {
            this.namespaceId = namespaceId;
            return this;
        }

        public final String getJobTemplateArn() {
            return jobTemplateArn;
        }

        public final void setJobTemplateArn(String jobTemplateArn) {
            this.jobTemplateArn = jobTemplateArn;
        }

        @Override
        @Transient
        public final Builder jobTemplateArn(String jobTemplateArn) {
            this.jobTemplateArn = jobTemplateArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateJobRequest build() {
            return new CreateJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
