/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotAsyncClient;
import software.amazon.awssdk.services.iot.model.ListScheduledAuditsRequest;
import software.amazon.awssdk.services.iot.model.ListScheduledAuditsResponse;
import software.amazon.awssdk.services.iot.model.ScheduledAuditMetadata;

public class ListScheduledAuditsPublisher
implements SdkPublisher<ListScheduledAuditsResponse> {
    private final IotAsyncClient client;
    private final ListScheduledAuditsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListScheduledAuditsPublisher(IotAsyncClient client, ListScheduledAuditsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListScheduledAuditsPublisher(IotAsyncClient client, ListScheduledAuditsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListScheduledAuditsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListScheduledAuditsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ScheduledAuditMetadata> scheduledAudits() {
        Function<ListScheduledAuditsResponse, Iterator> getIterator = response -> {
            if (response != null && response.scheduledAudits() != null) {
                return response.scheduledAudits().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListScheduledAuditsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListScheduledAuditsResponseFetcher
    implements AsyncPageFetcher<ListScheduledAuditsResponse> {
        private ListScheduledAuditsResponseFetcher() {
        }

        public boolean hasNextPage(ListScheduledAuditsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListScheduledAuditsResponse> nextPage(ListScheduledAuditsResponse previousPage) {
            if (previousPage == null) {
                return ListScheduledAuditsPublisher.this.client.listScheduledAudits(ListScheduledAuditsPublisher.this.firstRequest);
            }
            return ListScheduledAuditsPublisher.this.client.listScheduledAudits((ListScheduledAuditsRequest)((Object)ListScheduledAuditsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

