/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotClient;
import software.amazon.awssdk.services.iot.model.ListTargetsForSecurityProfileRequest;
import software.amazon.awssdk.services.iot.model.ListTargetsForSecurityProfileResponse;
import software.amazon.awssdk.services.iot.model.SecurityProfileTarget;

public class ListTargetsForSecurityProfileIterable
implements SdkIterable<ListTargetsForSecurityProfileResponse> {
    private final IotClient client;
    private final ListTargetsForSecurityProfileRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTargetsForSecurityProfileIterable(IotClient client, ListTargetsForSecurityProfileRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListTargetsForSecurityProfileResponseFetcher();
    }

    public Iterator<ListTargetsForSecurityProfileResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SecurityProfileTarget> securityProfileTargets() {
        Function<ListTargetsForSecurityProfileResponse, Iterator> getIterator = response -> {
            if (response != null && response.securityProfileTargets() != null) {
                return response.securityProfileTargets().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListTargetsForSecurityProfileResponseFetcher
    implements SyncPageFetcher<ListTargetsForSecurityProfileResponse> {
        private ListTargetsForSecurityProfileResponseFetcher() {
        }

        public boolean hasNextPage(ListTargetsForSecurityProfileResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTargetsForSecurityProfileResponse nextPage(ListTargetsForSecurityProfileResponse previousPage) {
            if (previousPage == null) {
                return ListTargetsForSecurityProfileIterable.this.client.listTargetsForSecurityProfile(ListTargetsForSecurityProfileIterable.this.firstRequest);
            }
            return ListTargetsForSecurityProfileIterable.this.client.listTargetsForSecurityProfile((ListTargetsForSecurityProfileRequest)((Object)ListTargetsForSecurityProfileIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

