/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotAsyncClient;
import software.amazon.awssdk.services.iot.model.ListProvisioningTemplatesRequest;
import software.amazon.awssdk.services.iot.model.ListProvisioningTemplatesResponse;
import software.amazon.awssdk.services.iot.model.ProvisioningTemplateSummary;

public class ListProvisioningTemplatesPublisher
implements SdkPublisher<ListProvisioningTemplatesResponse> {
    private final IotAsyncClient client;
    private final ListProvisioningTemplatesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListProvisioningTemplatesPublisher(IotAsyncClient client, ListProvisioningTemplatesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListProvisioningTemplatesPublisher(IotAsyncClient client, ListProvisioningTemplatesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListProvisioningTemplatesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListProvisioningTemplatesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ProvisioningTemplateSummary> templates() {
        Function<ListProvisioningTemplatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.templates() != null) {
                return response.templates().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListProvisioningTemplatesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListProvisioningTemplatesResponseFetcher
    implements AsyncPageFetcher<ListProvisioningTemplatesResponse> {
        private ListProvisioningTemplatesResponseFetcher() {
        }

        public boolean hasNextPage(ListProvisioningTemplatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListProvisioningTemplatesResponse> nextPage(ListProvisioningTemplatesResponse previousPage) {
            if (previousPage == null) {
                return ListProvisioningTemplatesPublisher.this.client.listProvisioningTemplates(ListProvisioningTemplatesPublisher.this.firstRequest);
            }
            return ListProvisioningTemplatesPublisher.this.client.listProvisioningTemplates((ListProvisioningTemplatesRequest)((Object)ListProvisioningTemplatesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

