/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iot.model.IotResponse;
import software.amazon.awssdk.services.iot.model.PolicyDocumentsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TestInvokeAuthorizerResponse
extends IotResponse
implements ToCopyableBuilder<Builder, TestInvokeAuthorizerResponse> {
    private static final SdkField<Boolean> IS_AUTHENTICATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isAuthenticated").getter(TestInvokeAuthorizerResponse.getter(TestInvokeAuthorizerResponse::isAuthenticated)).setter(TestInvokeAuthorizerResponse.setter(Builder::isAuthenticated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isAuthenticated").build()}).build();
    private static final SdkField<String> PRINCIPAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("principalId").getter(TestInvokeAuthorizerResponse.getter(TestInvokeAuthorizerResponse::principalId)).setter(TestInvokeAuthorizerResponse.setter(Builder::principalId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principalId").build()}).build();
    private static final SdkField<List<String>> POLICY_DOCUMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("policyDocuments").getter(TestInvokeAuthorizerResponse.getter(TestInvokeAuthorizerResponse::policyDocuments)).setter(TestInvokeAuthorizerResponse.setter(Builder::policyDocuments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyDocuments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> REFRESH_AFTER_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("refreshAfterInSeconds").getter(TestInvokeAuthorizerResponse.getter(TestInvokeAuthorizerResponse::refreshAfterInSeconds)).setter(TestInvokeAuthorizerResponse.setter(Builder::refreshAfterInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("refreshAfterInSeconds").build()}).build();
    private static final SdkField<Integer> DISCONNECT_AFTER_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("disconnectAfterInSeconds").getter(TestInvokeAuthorizerResponse.getter(TestInvokeAuthorizerResponse::disconnectAfterInSeconds)).setter(TestInvokeAuthorizerResponse.setter(Builder::disconnectAfterInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("disconnectAfterInSeconds").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IS_AUTHENTICATED_FIELD, PRINCIPAL_ID_FIELD, POLICY_DOCUMENTS_FIELD, REFRESH_AFTER_IN_SECONDS_FIELD, DISCONNECT_AFTER_IN_SECONDS_FIELD));
    private final Boolean isAuthenticated;
    private final String principalId;
    private final List<String> policyDocuments;
    private final Integer refreshAfterInSeconds;
    private final Integer disconnectAfterInSeconds;

    private TestInvokeAuthorizerResponse(BuilderImpl builder) {
        super(builder);
        this.isAuthenticated = builder.isAuthenticated;
        this.principalId = builder.principalId;
        this.policyDocuments = builder.policyDocuments;
        this.refreshAfterInSeconds = builder.refreshAfterInSeconds;
        this.disconnectAfterInSeconds = builder.disconnectAfterInSeconds;
    }

    public final Boolean isAuthenticated() {
        return this.isAuthenticated;
    }

    public final String principalId() {
        return this.principalId;
    }

    public final boolean hasPolicyDocuments() {
        return this.policyDocuments != null && !(this.policyDocuments instanceof SdkAutoConstructList);
    }

    public final List<String> policyDocuments() {
        return this.policyDocuments;
    }

    public final Integer refreshAfterInSeconds() {
        return this.refreshAfterInSeconds;
    }

    public final Integer disconnectAfterInSeconds() {
        return this.disconnectAfterInSeconds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.isAuthenticated());
        hashCode = 31 * hashCode + Objects.hashCode(this.principalId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPolicyDocuments() ? this.policyDocuments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.refreshAfterInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.disconnectAfterInSeconds());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestInvokeAuthorizerResponse)) {
            return false;
        }
        TestInvokeAuthorizerResponse other = (TestInvokeAuthorizerResponse)((Object)obj);
        return Objects.equals(this.isAuthenticated(), other.isAuthenticated()) && Objects.equals(this.principalId(), other.principalId()) && this.hasPolicyDocuments() == other.hasPolicyDocuments() && Objects.equals(this.policyDocuments(), other.policyDocuments()) && Objects.equals(this.refreshAfterInSeconds(), other.refreshAfterInSeconds()) && Objects.equals(this.disconnectAfterInSeconds(), other.disconnectAfterInSeconds());
    }

    public final String toString() {
        return ToString.builder((String)"TestInvokeAuthorizerResponse").add("IsAuthenticated", (Object)this.isAuthenticated()).add("PrincipalId", (Object)this.principalId()).add("PolicyDocuments", this.hasPolicyDocuments() ? this.policyDocuments() : null).add("RefreshAfterInSeconds", (Object)this.refreshAfterInSeconds()).add("DisconnectAfterInSeconds", (Object)this.disconnectAfterInSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "isAuthenticated": {
                return Optional.ofNullable(clazz.cast(this.isAuthenticated()));
            }
            case "principalId": {
                return Optional.ofNullable(clazz.cast(this.principalId()));
            }
            case "policyDocuments": {
                return Optional.ofNullable(clazz.cast(this.policyDocuments()));
            }
            case "refreshAfterInSeconds": {
                return Optional.ofNullable(clazz.cast(this.refreshAfterInSeconds()));
            }
            case "disconnectAfterInSeconds": {
                return Optional.ofNullable(clazz.cast(this.disconnectAfterInSeconds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TestInvokeAuthorizerResponse, T> g) {
        return obj -> g.apply((TestInvokeAuthorizerResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotResponse.BuilderImpl
    implements Builder {
        private Boolean isAuthenticated;
        private String principalId;
        private List<String> policyDocuments = DefaultSdkAutoConstructList.getInstance();
        private Integer refreshAfterInSeconds;
        private Integer disconnectAfterInSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(TestInvokeAuthorizerResponse model) {
            super(model);
            this.isAuthenticated(model.isAuthenticated);
            this.principalId(model.principalId);
            this.policyDocuments(model.policyDocuments);
            this.refreshAfterInSeconds(model.refreshAfterInSeconds);
            this.disconnectAfterInSeconds(model.disconnectAfterInSeconds);
        }

        public final Boolean getIsAuthenticated() {
            return this.isAuthenticated;
        }

        public final void setIsAuthenticated(Boolean isAuthenticated) {
            this.isAuthenticated = isAuthenticated;
        }

        @Override
        public final Builder isAuthenticated(Boolean isAuthenticated) {
            this.isAuthenticated = isAuthenticated;
            return this;
        }

        public final String getPrincipalId() {
            return this.principalId;
        }

        public final void setPrincipalId(String principalId) {
            this.principalId = principalId;
        }

        @Override
        public final Builder principalId(String principalId) {
            this.principalId = principalId;
            return this;
        }

        public final Collection<String> getPolicyDocuments() {
            if (this.policyDocuments instanceof SdkAutoConstructList) {
                return null;
            }
            return this.policyDocuments;
        }

        public final void setPolicyDocuments(Collection<String> policyDocuments) {
            this.policyDocuments = PolicyDocumentsCopier.copy(policyDocuments);
        }

        @Override
        public final Builder policyDocuments(Collection<String> policyDocuments) {
            this.policyDocuments = PolicyDocumentsCopier.copy(policyDocuments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyDocuments(String ... policyDocuments) {
            this.policyDocuments(Arrays.asList(policyDocuments));
            return this;
        }

        public final Integer getRefreshAfterInSeconds() {
            return this.refreshAfterInSeconds;
        }

        public final void setRefreshAfterInSeconds(Integer refreshAfterInSeconds) {
            this.refreshAfterInSeconds = refreshAfterInSeconds;
        }

        @Override
        public final Builder refreshAfterInSeconds(Integer refreshAfterInSeconds) {
            this.refreshAfterInSeconds = refreshAfterInSeconds;
            return this;
        }

        public final Integer getDisconnectAfterInSeconds() {
            return this.disconnectAfterInSeconds;
        }

        public final void setDisconnectAfterInSeconds(Integer disconnectAfterInSeconds) {
            this.disconnectAfterInSeconds = disconnectAfterInSeconds;
        }

        @Override
        public final Builder disconnectAfterInSeconds(Integer disconnectAfterInSeconds) {
            this.disconnectAfterInSeconds = disconnectAfterInSeconds;
            return this;
        }

        @Override
        public TestInvokeAuthorizerResponse build() {
            return new TestInvokeAuthorizerResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, TestInvokeAuthorizerResponse> {
        public Builder isAuthenticated(Boolean var1);

        public Builder principalId(String var1);

        public Builder policyDocuments(Collection<String> var1);

        public Builder policyDocuments(String ... var1);

        public Builder refreshAfterInSeconds(Integer var1);

        public Builder disconnectAfterInSeconds(Integer var1);
    }
}

