/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.ServiceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DomainConfigurationSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DomainConfigurationSummary> {
    private static final SdkField<String> DOMAIN_CONFIGURATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainConfigurationName").getter(DomainConfigurationSummary.getter(DomainConfigurationSummary::domainConfigurationName)).setter(DomainConfigurationSummary.setter(Builder::domainConfigurationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainConfigurationName").build()}).build();
    private static final SdkField<String> DOMAIN_CONFIGURATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainConfigurationArn").getter(DomainConfigurationSummary.getter(DomainConfigurationSummary::domainConfigurationArn)).setter(DomainConfigurationSummary.setter(Builder::domainConfigurationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainConfigurationArn").build()}).build();
    private static final SdkField<String> SERVICE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceType").getter(DomainConfigurationSummary.getter(DomainConfigurationSummary::serviceTypeAsString)).setter(DomainConfigurationSummary.setter(Builder::serviceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_CONFIGURATION_NAME_FIELD, DOMAIN_CONFIGURATION_ARN_FIELD, SERVICE_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String domainConfigurationName;
    private final String domainConfigurationArn;
    private final String serviceType;

    private DomainConfigurationSummary(BuilderImpl builder) {
        this.domainConfigurationName = builder.domainConfigurationName;
        this.domainConfigurationArn = builder.domainConfigurationArn;
        this.serviceType = builder.serviceType;
    }

    public final String domainConfigurationName() {
        return this.domainConfigurationName;
    }

    public final String domainConfigurationArn() {
        return this.domainConfigurationArn;
    }

    public final ServiceType serviceType() {
        return ServiceType.fromValue(this.serviceType);
    }

    public final String serviceTypeAsString() {
        return this.serviceType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domainConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainConfigurationSummary)) {
            return false;
        }
        DomainConfigurationSummary other = (DomainConfigurationSummary)obj;
        return Objects.equals(this.domainConfigurationName(), other.domainConfigurationName()) && Objects.equals(this.domainConfigurationArn(), other.domainConfigurationArn()) && Objects.equals(this.serviceTypeAsString(), other.serviceTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DomainConfigurationSummary").add("DomainConfigurationName", (Object)this.domainConfigurationName()).add("DomainConfigurationArn", (Object)this.domainConfigurationArn()).add("ServiceType", (Object)this.serviceTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "domainConfigurationName": {
                return Optional.ofNullable(clazz.cast(this.domainConfigurationName()));
            }
            case "domainConfigurationArn": {
                return Optional.ofNullable(clazz.cast(this.domainConfigurationArn()));
            }
            case "serviceType": {
                return Optional.ofNullable(clazz.cast(this.serviceTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DomainConfigurationSummary, T> g) {
        return obj -> g.apply((DomainConfigurationSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String domainConfigurationName;
        private String domainConfigurationArn;
        private String serviceType;

        private BuilderImpl() {
        }

        private BuilderImpl(DomainConfigurationSummary model) {
            this.domainConfigurationName(model.domainConfigurationName);
            this.domainConfigurationArn(model.domainConfigurationArn);
            this.serviceType(model.serviceType);
        }

        public final String getDomainConfigurationName() {
            return this.domainConfigurationName;
        }

        public final void setDomainConfigurationName(String domainConfigurationName) {
            this.domainConfigurationName = domainConfigurationName;
        }

        @Override
        public final Builder domainConfigurationName(String domainConfigurationName) {
            this.domainConfigurationName = domainConfigurationName;
            return this;
        }

        public final String getDomainConfigurationArn() {
            return this.domainConfigurationArn;
        }

        public final void setDomainConfigurationArn(String domainConfigurationArn) {
            this.domainConfigurationArn = domainConfigurationArn;
        }

        @Override
        public final Builder domainConfigurationArn(String domainConfigurationArn) {
            this.domainConfigurationArn = domainConfigurationArn;
            return this;
        }

        public final String getServiceType() {
            return this.serviceType;
        }

        public final void setServiceType(String serviceType) {
            this.serviceType = serviceType;
        }

        @Override
        public final Builder serviceType(String serviceType) {
            this.serviceType = serviceType;
            return this;
        }

        @Override
        public final Builder serviceType(ServiceType serviceType) {
            this.serviceType(serviceType == null ? null : serviceType.toString());
            return this;
        }

        public DomainConfigurationSummary build() {
            return new DomainConfigurationSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DomainConfigurationSummary> {
        public Builder domainConfigurationName(String var1);

        public Builder domainConfigurationArn(String var1);

        public Builder serviceType(String var1);

        public Builder serviceType(ServiceType var1);
    }
}

