/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum LogTargetType {
    DEFAULT("DEFAULT"),
    THING_GROUP("THING_GROUP"),
    CLIENT_ID("CLIENT_ID"),
    SOURCE_IP("SOURCE_IP"),
    PRINCIPAL_ID("PRINCIPAL_ID"),
    EVENT_TYPE("EVENT_TYPE"),
    DEVICE_DEFENDER("DEVICE_DEFENDER"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, LogTargetType> VALUE_MAP;
    private final String value;

    private LogTargetType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static LogTargetType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<LogTargetType> knownValues() {
        EnumSet<LogTargetType> knownValues = EnumSet.allOf(LogTargetType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(LogTargetType.class, LogTargetType::toString);
    }
}

