/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot;

import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.iot.internal.IotServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.iot.model.AcceptCertificateTransferRequest;
import software.amazon.awssdk.services.iot.model.AcceptCertificateTransferResponse;
import software.amazon.awssdk.services.iot.model.AddThingToBillingGroupRequest;
import software.amazon.awssdk.services.iot.model.AddThingToBillingGroupResponse;
import software.amazon.awssdk.services.iot.model.AddThingToThingGroupRequest;
import software.amazon.awssdk.services.iot.model.AddThingToThingGroupResponse;
import software.amazon.awssdk.services.iot.model.AssociateTargetsWithJobRequest;
import software.amazon.awssdk.services.iot.model.AssociateTargetsWithJobResponse;
import software.amazon.awssdk.services.iot.model.AttachPolicyRequest;
import software.amazon.awssdk.services.iot.model.AttachPolicyResponse;
import software.amazon.awssdk.services.iot.model.AttachSecurityProfileRequest;
import software.amazon.awssdk.services.iot.model.AttachSecurityProfileResponse;
import software.amazon.awssdk.services.iot.model.AttachThingPrincipalRequest;
import software.amazon.awssdk.services.iot.model.AttachThingPrincipalResponse;
import software.amazon.awssdk.services.iot.model.CancelAuditMitigationActionsTaskRequest;
import software.amazon.awssdk.services.iot.model.CancelAuditMitigationActionsTaskResponse;
import software.amazon.awssdk.services.iot.model.CancelAuditTaskRequest;
import software.amazon.awssdk.services.iot.model.CancelAuditTaskResponse;
import software.amazon.awssdk.services.iot.model.CancelCertificateTransferRequest;
import software.amazon.awssdk.services.iot.model.CancelCertificateTransferResponse;
import software.amazon.awssdk.services.iot.model.CancelDetectMitigationActionsTaskRequest;
import software.amazon.awssdk.services.iot.model.CancelDetectMitigationActionsTaskResponse;
import software.amazon.awssdk.services.iot.model.CancelJobExecutionRequest;
import software.amazon.awssdk.services.iot.model.CancelJobExecutionResponse;
import software.amazon.awssdk.services.iot.model.CancelJobRequest;
import software.amazon.awssdk.services.iot.model.CancelJobResponse;
import software.amazon.awssdk.services.iot.model.CertificateConflictException;
import software.amazon.awssdk.services.iot.model.CertificateStateException;
import software.amazon.awssdk.services.iot.model.CertificateValidationException;
import software.amazon.awssdk.services.iot.model.ClearDefaultAuthorizerRequest;
import software.amazon.awssdk.services.iot.model.ClearDefaultAuthorizerResponse;
import software.amazon.awssdk.services.iot.model.ConfirmTopicRuleDestinationRequest;
import software.amazon.awssdk.services.iot.model.ConfirmTopicRuleDestinationResponse;
import software.amazon.awssdk.services.iot.model.ConflictException;
import software.amazon.awssdk.services.iot.model.ConflictingResourceUpdateException;
import software.amazon.awssdk.services.iot.model.CreateAuditSuppressionRequest;
import software.amazon.awssdk.services.iot.model.CreateAuditSuppressionResponse;
import software.amazon.awssdk.services.iot.model.CreateAuthorizerRequest;
import software.amazon.awssdk.services.iot.model.CreateAuthorizerResponse;
import software.amazon.awssdk.services.iot.model.CreateBillingGroupRequest;
import software.amazon.awssdk.services.iot.model.CreateBillingGroupResponse;
import software.amazon.awssdk.services.iot.model.CreateCertificateFromCsrRequest;
import software.amazon.awssdk.services.iot.model.CreateCertificateFromCsrResponse;
import software.amazon.awssdk.services.iot.model.CreateCustomMetricRequest;
import software.amazon.awssdk.services.iot.model.CreateCustomMetricResponse;
import software.amazon.awssdk.services.iot.model.CreateDimensionRequest;
import software.amazon.awssdk.services.iot.model.CreateDimensionResponse;
import software.amazon.awssdk.services.iot.model.CreateDomainConfigurationRequest;
import software.amazon.awssdk.services.iot.model.CreateDomainConfigurationResponse;
import software.amazon.awssdk.services.iot.model.CreateDynamicThingGroupRequest;
import software.amazon.awssdk.services.iot.model.CreateDynamicThingGroupResponse;
import software.amazon.awssdk.services.iot.model.CreateFleetMetricRequest;
import software.amazon.awssdk.services.iot.model.CreateFleetMetricResponse;
import software.amazon.awssdk.services.iot.model.CreateJobRequest;
import software.amazon.awssdk.services.iot.model.CreateJobResponse;
import software.amazon.awssdk.services.iot.model.CreateJobTemplateRequest;
import software.amazon.awssdk.services.iot.model.CreateJobTemplateResponse;
import software.amazon.awssdk.services.iot.model.CreateKeysAndCertificateRequest;
import software.amazon.awssdk.services.iot.model.CreateKeysAndCertificateResponse;
import software.amazon.awssdk.services.iot.model.CreateMitigationActionRequest;
import software.amazon.awssdk.services.iot.model.CreateMitigationActionResponse;
import software.amazon.awssdk.services.iot.model.CreateOtaUpdateRequest;
import software.amazon.awssdk.services.iot.model.CreateOtaUpdateResponse;
import software.amazon.awssdk.services.iot.model.CreatePackageRequest;
import software.amazon.awssdk.services.iot.model.CreatePackageResponse;
import software.amazon.awssdk.services.iot.model.CreatePackageVersionRequest;
import software.amazon.awssdk.services.iot.model.CreatePackageVersionResponse;
import software.amazon.awssdk.services.iot.model.CreatePolicyRequest;
import software.amazon.awssdk.services.iot.model.CreatePolicyResponse;
import software.amazon.awssdk.services.iot.model.CreatePolicyVersionRequest;
import software.amazon.awssdk.services.iot.model.CreatePolicyVersionResponse;
import software.amazon.awssdk.services.iot.model.CreateProvisioningClaimRequest;
import software.amazon.awssdk.services.iot.model.CreateProvisioningClaimResponse;
import software.amazon.awssdk.services.iot.model.CreateProvisioningTemplateRequest;
import software.amazon.awssdk.services.iot.model.CreateProvisioningTemplateResponse;
import software.amazon.awssdk.services.iot.model.CreateProvisioningTemplateVersionRequest;
import software.amazon.awssdk.services.iot.model.CreateProvisioningTemplateVersionResponse;
import software.amazon.awssdk.services.iot.model.CreateRoleAliasRequest;
import software.amazon.awssdk.services.iot.model.CreateRoleAliasResponse;
import software.amazon.awssdk.services.iot.model.CreateScheduledAuditRequest;
import software.amazon.awssdk.services.iot.model.CreateScheduledAuditResponse;
import software.amazon.awssdk.services.iot.model.CreateSecurityProfileRequest;
import software.amazon.awssdk.services.iot.model.CreateSecurityProfileResponse;
import software.amazon.awssdk.services.iot.model.CreateStreamRequest;
import software.amazon.awssdk.services.iot.model.CreateStreamResponse;
import software.amazon.awssdk.services.iot.model.CreateThingGroupRequest;
import software.amazon.awssdk.services.iot.model.CreateThingGroupResponse;
import software.amazon.awssdk.services.iot.model.CreateThingRequest;
import software.amazon.awssdk.services.iot.model.CreateThingResponse;
import software.amazon.awssdk.services.iot.model.CreateThingTypeRequest;
import software.amazon.awssdk.services.iot.model.CreateThingTypeResponse;
import software.amazon.awssdk.services.iot.model.CreateTopicRuleDestinationRequest;
import software.amazon.awssdk.services.iot.model.CreateTopicRuleDestinationResponse;
import software.amazon.awssdk.services.iot.model.CreateTopicRuleRequest;
import software.amazon.awssdk.services.iot.model.CreateTopicRuleResponse;
import software.amazon.awssdk.services.iot.model.DeleteAccountAuditConfigurationRequest;
import software.amazon.awssdk.services.iot.model.DeleteAccountAuditConfigurationResponse;
import software.amazon.awssdk.services.iot.model.DeleteAuditSuppressionRequest;
import software.amazon.awssdk.services.iot.model.DeleteAuditSuppressionResponse;
import software.amazon.awssdk.services.iot.model.DeleteAuthorizerRequest;
import software.amazon.awssdk.services.iot.model.DeleteAuthorizerResponse;
import software.amazon.awssdk.services.iot.model.DeleteBillingGroupRequest;
import software.amazon.awssdk.services.iot.model.DeleteBillingGroupResponse;
import software.amazon.awssdk.services.iot.model.DeleteCaCertificateRequest;
import software.amazon.awssdk.services.iot.model.DeleteCaCertificateResponse;
import software.amazon.awssdk.services.iot.model.DeleteCertificateRequest;
import software.amazon.awssdk.services.iot.model.DeleteCertificateResponse;
import software.amazon.awssdk.services.iot.model.DeleteConflictException;
import software.amazon.awssdk.services.iot.model.DeleteCustomMetricRequest;
import software.amazon.awssdk.services.iot.model.DeleteCustomMetricResponse;
import software.amazon.awssdk.services.iot.model.DeleteDimensionRequest;
import software.amazon.awssdk.services.iot.model.DeleteDimensionResponse;
import software.amazon.awssdk.services.iot.model.DeleteDomainConfigurationRequest;
import software.amazon.awssdk.services.iot.model.DeleteDomainConfigurationResponse;
import software.amazon.awssdk.services.iot.model.DeleteDynamicThingGroupRequest;
import software.amazon.awssdk.services.iot.model.DeleteDynamicThingGroupResponse;
import software.amazon.awssdk.services.iot.model.DeleteFleetMetricRequest;
import software.amazon.awssdk.services.iot.model.DeleteFleetMetricResponse;
import software.amazon.awssdk.services.iot.model.DeleteJobExecutionRequest;
import software.amazon.awssdk.services.iot.model.DeleteJobExecutionResponse;
import software.amazon.awssdk.services.iot.model.DeleteJobRequest;
import software.amazon.awssdk.services.iot.model.DeleteJobResponse;
import software.amazon.awssdk.services.iot.model.DeleteJobTemplateRequest;
import software.amazon.awssdk.services.iot.model.DeleteJobTemplateResponse;
import software.amazon.awssdk.services.iot.model.DeleteMitigationActionRequest;
import software.amazon.awssdk.services.iot.model.DeleteMitigationActionResponse;
import software.amazon.awssdk.services.iot.model.DeleteOtaUpdateRequest;
import software.amazon.awssdk.services.iot.model.DeleteOtaUpdateResponse;
import software.amazon.awssdk.services.iot.model.DeletePackageRequest;
import software.amazon.awssdk.services.iot.model.DeletePackageResponse;
import software.amazon.awssdk.services.iot.model.DeletePackageVersionRequest;
import software.amazon.awssdk.services.iot.model.DeletePackageVersionResponse;
import software.amazon.awssdk.services.iot.model.DeletePolicyRequest;
import software.amazon.awssdk.services.iot.model.DeletePolicyResponse;
import software.amazon.awssdk.services.iot.model.DeletePolicyVersionRequest;
import software.amazon.awssdk.services.iot.model.DeletePolicyVersionResponse;
import software.amazon.awssdk.services.iot.model.DeleteProvisioningTemplateRequest;
import software.amazon.awssdk.services.iot.model.DeleteProvisioningTemplateResponse;
import software.amazon.awssdk.services.iot.model.DeleteProvisioningTemplateVersionRequest;
import software.amazon.awssdk.services.iot.model.DeleteProvisioningTemplateVersionResponse;
import software.amazon.awssdk.services.iot.model.DeleteRegistrationCodeRequest;
import software.amazon.awssdk.services.iot.model.DeleteRegistrationCodeResponse;
import software.amazon.awssdk.services.iot.model.DeleteRoleAliasRequest;
import software.amazon.awssdk.services.iot.model.DeleteRoleAliasResponse;
import software.amazon.awssdk.services.iot.model.DeleteScheduledAuditRequest;
import software.amazon.awssdk.services.iot.model.DeleteScheduledAuditResponse;
import software.amazon.awssdk.services.iot.model.DeleteSecurityProfileRequest;
import software.amazon.awssdk.services.iot.model.DeleteSecurityProfileResponse;
import software.amazon.awssdk.services.iot.model.DeleteStreamRequest;
import software.amazon.awssdk.services.iot.model.DeleteStreamResponse;
import software.amazon.awssdk.services.iot.model.DeleteThingGroupRequest;
import software.amazon.awssdk.services.iot.model.DeleteThingGroupResponse;
import software.amazon.awssdk.services.iot.model.DeleteThingRequest;
import software.amazon.awssdk.services.iot.model.DeleteThingResponse;
import software.amazon.awssdk.services.iot.model.DeleteThingTypeRequest;
import software.amazon.awssdk.services.iot.model.DeleteThingTypeResponse;
import software.amazon.awssdk.services.iot.model.DeleteTopicRuleDestinationRequest;
import software.amazon.awssdk.services.iot.model.DeleteTopicRuleDestinationResponse;
import software.amazon.awssdk.services.iot.model.DeleteTopicRuleRequest;
import software.amazon.awssdk.services.iot.model.DeleteTopicRuleResponse;
import software.amazon.awssdk.services.iot.model.DeleteV2LoggingLevelRequest;
import software.amazon.awssdk.services.iot.model.DeleteV2LoggingLevelResponse;
import software.amazon.awssdk.services.iot.model.DeprecateThingTypeRequest;
import software.amazon.awssdk.services.iot.model.DeprecateThingTypeResponse;
import software.amazon.awssdk.services.iot.model.DescribeAccountAuditConfigurationRequest;
import software.amazon.awssdk.services.iot.model.DescribeAccountAuditConfigurationResponse;
import software.amazon.awssdk.services.iot.model.DescribeAuditFindingRequest;
import software.amazon.awssdk.services.iot.model.DescribeAuditFindingResponse;
import software.amazon.awssdk.services.iot.model.DescribeAuditMitigationActionsTaskRequest;
import software.amazon.awssdk.services.iot.model.DescribeAuditMitigationActionsTaskResponse;
import software.amazon.awssdk.services.iot.model.DescribeAuditSuppressionRequest;
import software.amazon.awssdk.services.iot.model.DescribeAuditSuppressionResponse;
import software.amazon.awssdk.services.iot.model.DescribeAuditTaskRequest;
import software.amazon.awssdk.services.iot.model.DescribeAuditTaskResponse;
import software.amazon.awssdk.services.iot.model.DescribeAuthorizerRequest;
import software.amazon.awssdk.services.iot.model.DescribeAuthorizerResponse;
import software.amazon.awssdk.services.iot.model.DescribeBillingGroupRequest;
import software.amazon.awssdk.services.iot.model.DescribeBillingGroupResponse;
import software.amazon.awssdk.services.iot.model.DescribeCaCertificateRequest;
import software.amazon.awssdk.services.iot.model.DescribeCaCertificateResponse;
import software.amazon.awssdk.services.iot.model.DescribeCertificateRequest;
import software.amazon.awssdk.services.iot.model.DescribeCertificateResponse;
import software.amazon.awssdk.services.iot.model.DescribeCustomMetricRequest;
import software.amazon.awssdk.services.iot.model.DescribeCustomMetricResponse;
import software.amazon.awssdk.services.iot.model.DescribeDefaultAuthorizerRequest;
import software.amazon.awssdk.services.iot.model.DescribeDefaultAuthorizerResponse;
import software.amazon.awssdk.services.iot.model.DescribeDetectMitigationActionsTaskRequest;
import software.amazon.awssdk.services.iot.model.DescribeDetectMitigationActionsTaskResponse;
import software.amazon.awssdk.services.iot.model.DescribeDimensionRequest;
import software.amazon.awssdk.services.iot.model.DescribeDimensionResponse;
import software.amazon.awssdk.services.iot.model.DescribeDomainConfigurationRequest;
import software.amazon.awssdk.services.iot.model.DescribeDomainConfigurationResponse;
import software.amazon.awssdk.services.iot.model.DescribeEndpointRequest;
import software.amazon.awssdk.services.iot.model.DescribeEndpointResponse;
import software.amazon.awssdk.services.iot.model.DescribeEventConfigurationsRequest;
import software.amazon.awssdk.services.iot.model.DescribeEventConfigurationsResponse;
import software.amazon.awssdk.services.iot.model.DescribeFleetMetricRequest;
import software.amazon.awssdk.services.iot.model.DescribeFleetMetricResponse;
import software.amazon.awssdk.services.iot.model.DescribeIndexRequest;
import software.amazon.awssdk.services.iot.model.DescribeIndexResponse;
import software.amazon.awssdk.services.iot.model.DescribeJobExecutionRequest;
import software.amazon.awssdk.services.iot.model.DescribeJobExecutionResponse;
import software.amazon.awssdk.services.iot.model.DescribeJobRequest;
import software.amazon.awssdk.services.iot.model.DescribeJobResponse;
import software.amazon.awssdk.services.iot.model.DescribeJobTemplateRequest;
import software.amazon.awssdk.services.iot.model.DescribeJobTemplateResponse;
import software.amazon.awssdk.services.iot.model.DescribeManagedJobTemplateRequest;
import software.amazon.awssdk.services.iot.model.DescribeManagedJobTemplateResponse;
import software.amazon.awssdk.services.iot.model.DescribeMitigationActionRequest;
import software.amazon.awssdk.services.iot.model.DescribeMitigationActionResponse;
import software.amazon.awssdk.services.iot.model.DescribeProvisioningTemplateRequest;
import software.amazon.awssdk.services.iot.model.DescribeProvisioningTemplateResponse;
import software.amazon.awssdk.services.iot.model.DescribeProvisioningTemplateVersionRequest;
import software.amazon.awssdk.services.iot.model.DescribeProvisioningTemplateVersionResponse;
import software.amazon.awssdk.services.iot.model.DescribeRoleAliasRequest;
import software.amazon.awssdk.services.iot.model.DescribeRoleAliasResponse;
import software.amazon.awssdk.services.iot.model.DescribeScheduledAuditRequest;
import software.amazon.awssdk.services.iot.model.DescribeScheduledAuditResponse;
import software.amazon.awssdk.services.iot.model.DescribeSecurityProfileRequest;
import software.amazon.awssdk.services.iot.model.DescribeSecurityProfileResponse;
import software.amazon.awssdk.services.iot.model.DescribeStreamRequest;
import software.amazon.awssdk.services.iot.model.DescribeStreamResponse;
import software.amazon.awssdk.services.iot.model.DescribeThingGroupRequest;
import software.amazon.awssdk.services.iot.model.DescribeThingGroupResponse;
import software.amazon.awssdk.services.iot.model.DescribeThingRegistrationTaskRequest;
import software.amazon.awssdk.services.iot.model.DescribeThingRegistrationTaskResponse;
import software.amazon.awssdk.services.iot.model.DescribeThingRequest;
import software.amazon.awssdk.services.iot.model.DescribeThingResponse;
import software.amazon.awssdk.services.iot.model.DescribeThingTypeRequest;
import software.amazon.awssdk.services.iot.model.DescribeThingTypeResponse;
import software.amazon.awssdk.services.iot.model.DetachPolicyRequest;
import software.amazon.awssdk.services.iot.model.DetachPolicyResponse;
import software.amazon.awssdk.services.iot.model.DetachSecurityProfileRequest;
import software.amazon.awssdk.services.iot.model.DetachSecurityProfileResponse;
import software.amazon.awssdk.services.iot.model.DetachThingPrincipalRequest;
import software.amazon.awssdk.services.iot.model.DetachThingPrincipalResponse;
import software.amazon.awssdk.services.iot.model.DisableTopicRuleRequest;
import software.amazon.awssdk.services.iot.model.DisableTopicRuleResponse;
import software.amazon.awssdk.services.iot.model.EnableTopicRuleRequest;
import software.amazon.awssdk.services.iot.model.EnableTopicRuleResponse;
import software.amazon.awssdk.services.iot.model.GetBehaviorModelTrainingSummariesRequest;
import software.amazon.awssdk.services.iot.model.GetBehaviorModelTrainingSummariesResponse;
import software.amazon.awssdk.services.iot.model.GetBucketsAggregationRequest;
import software.amazon.awssdk.services.iot.model.GetBucketsAggregationResponse;
import software.amazon.awssdk.services.iot.model.GetCardinalityRequest;
import software.amazon.awssdk.services.iot.model.GetCardinalityResponse;
import software.amazon.awssdk.services.iot.model.GetEffectivePoliciesRequest;
import software.amazon.awssdk.services.iot.model.GetEffectivePoliciesResponse;
import software.amazon.awssdk.services.iot.model.GetIndexingConfigurationRequest;
import software.amazon.awssdk.services.iot.model.GetIndexingConfigurationResponse;
import software.amazon.awssdk.services.iot.model.GetJobDocumentRequest;
import software.amazon.awssdk.services.iot.model.GetJobDocumentResponse;
import software.amazon.awssdk.services.iot.model.GetLoggingOptionsRequest;
import software.amazon.awssdk.services.iot.model.GetLoggingOptionsResponse;
import software.amazon.awssdk.services.iot.model.GetOtaUpdateRequest;
import software.amazon.awssdk.services.iot.model.GetOtaUpdateResponse;
import software.amazon.awssdk.services.iot.model.GetPackageConfigurationRequest;
import software.amazon.awssdk.services.iot.model.GetPackageConfigurationResponse;
import software.amazon.awssdk.services.iot.model.GetPackageRequest;
import software.amazon.awssdk.services.iot.model.GetPackageResponse;
import software.amazon.awssdk.services.iot.model.GetPackageVersionRequest;
import software.amazon.awssdk.services.iot.model.GetPackageVersionResponse;
import software.amazon.awssdk.services.iot.model.GetPercentilesRequest;
import software.amazon.awssdk.services.iot.model.GetPercentilesResponse;
import software.amazon.awssdk.services.iot.model.GetPolicyRequest;
import software.amazon.awssdk.services.iot.model.GetPolicyResponse;
import software.amazon.awssdk.services.iot.model.GetPolicyVersionRequest;
import software.amazon.awssdk.services.iot.model.GetPolicyVersionResponse;
import software.amazon.awssdk.services.iot.model.GetRegistrationCodeRequest;
import software.amazon.awssdk.services.iot.model.GetRegistrationCodeResponse;
import software.amazon.awssdk.services.iot.model.GetStatisticsRequest;
import software.amazon.awssdk.services.iot.model.GetStatisticsResponse;
import software.amazon.awssdk.services.iot.model.GetTopicRuleDestinationRequest;
import software.amazon.awssdk.services.iot.model.GetTopicRuleDestinationResponse;
import software.amazon.awssdk.services.iot.model.GetTopicRuleRequest;
import software.amazon.awssdk.services.iot.model.GetTopicRuleResponse;
import software.amazon.awssdk.services.iot.model.GetV2LoggingOptionsRequest;
import software.amazon.awssdk.services.iot.model.GetV2LoggingOptionsResponse;
import software.amazon.awssdk.services.iot.model.IndexNotReadyException;
import software.amazon.awssdk.services.iot.model.InternalException;
import software.amazon.awssdk.services.iot.model.InternalFailureException;
import software.amazon.awssdk.services.iot.model.InternalServerException;
import software.amazon.awssdk.services.iot.model.InvalidAggregationException;
import software.amazon.awssdk.services.iot.model.InvalidQueryException;
import software.amazon.awssdk.services.iot.model.InvalidRequestException;
import software.amazon.awssdk.services.iot.model.InvalidResponseException;
import software.amazon.awssdk.services.iot.model.InvalidStateTransitionException;
import software.amazon.awssdk.services.iot.model.IotException;
import software.amazon.awssdk.services.iot.model.LimitExceededException;
import software.amazon.awssdk.services.iot.model.ListActiveViolationsRequest;
import software.amazon.awssdk.services.iot.model.ListActiveViolationsResponse;
import software.amazon.awssdk.services.iot.model.ListAttachedPoliciesRequest;
import software.amazon.awssdk.services.iot.model.ListAttachedPoliciesResponse;
import software.amazon.awssdk.services.iot.model.ListAuditFindingsRequest;
import software.amazon.awssdk.services.iot.model.ListAuditFindingsResponse;
import software.amazon.awssdk.services.iot.model.ListAuditMitigationActionsExecutionsRequest;
import software.amazon.awssdk.services.iot.model.ListAuditMitigationActionsExecutionsResponse;
import software.amazon.awssdk.services.iot.model.ListAuditMitigationActionsTasksRequest;
import software.amazon.awssdk.services.iot.model.ListAuditMitigationActionsTasksResponse;
import software.amazon.awssdk.services.iot.model.ListAuditSuppressionsRequest;
import software.amazon.awssdk.services.iot.model.ListAuditSuppressionsResponse;
import software.amazon.awssdk.services.iot.model.ListAuditTasksRequest;
import software.amazon.awssdk.services.iot.model.ListAuditTasksResponse;
import software.amazon.awssdk.services.iot.model.ListAuthorizersRequest;
import software.amazon.awssdk.services.iot.model.ListAuthorizersResponse;
import software.amazon.awssdk.services.iot.model.ListBillingGroupsRequest;
import software.amazon.awssdk.services.iot.model.ListBillingGroupsResponse;
import software.amazon.awssdk.services.iot.model.ListCaCertificatesRequest;
import software.amazon.awssdk.services.iot.model.ListCaCertificatesResponse;
import software.amazon.awssdk.services.iot.model.ListCertificatesByCaRequest;
import software.amazon.awssdk.services.iot.model.ListCertificatesByCaResponse;
import software.amazon.awssdk.services.iot.model.ListCertificatesRequest;
import software.amazon.awssdk.services.iot.model.ListCertificatesResponse;
import software.amazon.awssdk.services.iot.model.ListCustomMetricsRequest;
import software.amazon.awssdk.services.iot.model.ListCustomMetricsResponse;
import software.amazon.awssdk.services.iot.model.ListDetectMitigationActionsExecutionsRequest;
import software.amazon.awssdk.services.iot.model.ListDetectMitigationActionsExecutionsResponse;
import software.amazon.awssdk.services.iot.model.ListDetectMitigationActionsTasksRequest;
import software.amazon.awssdk.services.iot.model.ListDetectMitigationActionsTasksResponse;
import software.amazon.awssdk.services.iot.model.ListDimensionsRequest;
import software.amazon.awssdk.services.iot.model.ListDimensionsResponse;
import software.amazon.awssdk.services.iot.model.ListDomainConfigurationsRequest;
import software.amazon.awssdk.services.iot.model.ListDomainConfigurationsResponse;
import software.amazon.awssdk.services.iot.model.ListFleetMetricsRequest;
import software.amazon.awssdk.services.iot.model.ListFleetMetricsResponse;
import software.amazon.awssdk.services.iot.model.ListIndicesRequest;
import software.amazon.awssdk.services.iot.model.ListIndicesResponse;
import software.amazon.awssdk.services.iot.model.ListJobExecutionsForJobRequest;
import software.amazon.awssdk.services.iot.model.ListJobExecutionsForJobResponse;
import software.amazon.awssdk.services.iot.model.ListJobExecutionsForThingRequest;
import software.amazon.awssdk.services.iot.model.ListJobExecutionsForThingResponse;
import software.amazon.awssdk.services.iot.model.ListJobTemplatesRequest;
import software.amazon.awssdk.services.iot.model.ListJobTemplatesResponse;
import software.amazon.awssdk.services.iot.model.ListJobsRequest;
import software.amazon.awssdk.services.iot.model.ListJobsResponse;
import software.amazon.awssdk.services.iot.model.ListManagedJobTemplatesRequest;
import software.amazon.awssdk.services.iot.model.ListManagedJobTemplatesResponse;
import software.amazon.awssdk.services.iot.model.ListMetricValuesRequest;
import software.amazon.awssdk.services.iot.model.ListMetricValuesResponse;
import software.amazon.awssdk.services.iot.model.ListMitigationActionsRequest;
import software.amazon.awssdk.services.iot.model.ListMitigationActionsResponse;
import software.amazon.awssdk.services.iot.model.ListOtaUpdatesRequest;
import software.amazon.awssdk.services.iot.model.ListOtaUpdatesResponse;
import software.amazon.awssdk.services.iot.model.ListOutgoingCertificatesRequest;
import software.amazon.awssdk.services.iot.model.ListOutgoingCertificatesResponse;
import software.amazon.awssdk.services.iot.model.ListPackageVersionsRequest;
import software.amazon.awssdk.services.iot.model.ListPackageVersionsResponse;
import software.amazon.awssdk.services.iot.model.ListPackagesRequest;
import software.amazon.awssdk.services.iot.model.ListPackagesResponse;
import software.amazon.awssdk.services.iot.model.ListPoliciesRequest;
import software.amazon.awssdk.services.iot.model.ListPoliciesResponse;
import software.amazon.awssdk.services.iot.model.ListPolicyVersionsRequest;
import software.amazon.awssdk.services.iot.model.ListPolicyVersionsResponse;
import software.amazon.awssdk.services.iot.model.ListPrincipalThingsRequest;
import software.amazon.awssdk.services.iot.model.ListPrincipalThingsResponse;
import software.amazon.awssdk.services.iot.model.ListProvisioningTemplateVersionsRequest;
import software.amazon.awssdk.services.iot.model.ListProvisioningTemplateVersionsResponse;
import software.amazon.awssdk.services.iot.model.ListProvisioningTemplatesRequest;
import software.amazon.awssdk.services.iot.model.ListProvisioningTemplatesResponse;
import software.amazon.awssdk.services.iot.model.ListRelatedResourcesForAuditFindingRequest;
import software.amazon.awssdk.services.iot.model.ListRelatedResourcesForAuditFindingResponse;
import software.amazon.awssdk.services.iot.model.ListRoleAliasesRequest;
import software.amazon.awssdk.services.iot.model.ListRoleAliasesResponse;
import software.amazon.awssdk.services.iot.model.ListScheduledAuditsRequest;
import software.amazon.awssdk.services.iot.model.ListScheduledAuditsResponse;
import software.amazon.awssdk.services.iot.model.ListSecurityProfilesForTargetRequest;
import software.amazon.awssdk.services.iot.model.ListSecurityProfilesForTargetResponse;
import software.amazon.awssdk.services.iot.model.ListSecurityProfilesRequest;
import software.amazon.awssdk.services.iot.model.ListSecurityProfilesResponse;
import software.amazon.awssdk.services.iot.model.ListStreamsRequest;
import software.amazon.awssdk.services.iot.model.ListStreamsResponse;
import software.amazon.awssdk.services.iot.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.iot.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.iot.model.ListTargetsForPolicyRequest;
import software.amazon.awssdk.services.iot.model.ListTargetsForPolicyResponse;
import software.amazon.awssdk.services.iot.model.ListTargetsForSecurityProfileRequest;
import software.amazon.awssdk.services.iot.model.ListTargetsForSecurityProfileResponse;
import software.amazon.awssdk.services.iot.model.ListThingGroupsForThingRequest;
import software.amazon.awssdk.services.iot.model.ListThingGroupsForThingResponse;
import software.amazon.awssdk.services.iot.model.ListThingGroupsRequest;
import software.amazon.awssdk.services.iot.model.ListThingGroupsResponse;
import software.amazon.awssdk.services.iot.model.ListThingPrincipalsRequest;
import software.amazon.awssdk.services.iot.model.ListThingPrincipalsResponse;
import software.amazon.awssdk.services.iot.model.ListThingRegistrationTaskReportsRequest;
import software.amazon.awssdk.services.iot.model.ListThingRegistrationTaskReportsResponse;
import software.amazon.awssdk.services.iot.model.ListThingRegistrationTasksRequest;
import software.amazon.awssdk.services.iot.model.ListThingRegistrationTasksResponse;
import software.amazon.awssdk.services.iot.model.ListThingTypesRequest;
import software.amazon.awssdk.services.iot.model.ListThingTypesResponse;
import software.amazon.awssdk.services.iot.model.ListThingsInBillingGroupRequest;
import software.amazon.awssdk.services.iot.model.ListThingsInBillingGroupResponse;
import software.amazon.awssdk.services.iot.model.ListThingsInThingGroupRequest;
import software.amazon.awssdk.services.iot.model.ListThingsInThingGroupResponse;
import software.amazon.awssdk.services.iot.model.ListThingsRequest;
import software.amazon.awssdk.services.iot.model.ListThingsResponse;
import software.amazon.awssdk.services.iot.model.ListTopicRuleDestinationsRequest;
import software.amazon.awssdk.services.iot.model.ListTopicRuleDestinationsResponse;
import software.amazon.awssdk.services.iot.model.ListTopicRulesRequest;
import software.amazon.awssdk.services.iot.model.ListTopicRulesResponse;
import software.amazon.awssdk.services.iot.model.ListV2LoggingLevelsRequest;
import software.amazon.awssdk.services.iot.model.ListV2LoggingLevelsResponse;
import software.amazon.awssdk.services.iot.model.ListViolationEventsRequest;
import software.amazon.awssdk.services.iot.model.ListViolationEventsResponse;
import software.amazon.awssdk.services.iot.model.MalformedPolicyException;
import software.amazon.awssdk.services.iot.model.NotConfiguredException;
import software.amazon.awssdk.services.iot.model.PutVerificationStateOnViolationRequest;
import software.amazon.awssdk.services.iot.model.PutVerificationStateOnViolationResponse;
import software.amazon.awssdk.services.iot.model.RegisterCaCertificateRequest;
import software.amazon.awssdk.services.iot.model.RegisterCaCertificateResponse;
import software.amazon.awssdk.services.iot.model.RegisterCertificateRequest;
import software.amazon.awssdk.services.iot.model.RegisterCertificateResponse;
import software.amazon.awssdk.services.iot.model.RegisterCertificateWithoutCaRequest;
import software.amazon.awssdk.services.iot.model.RegisterCertificateWithoutCaResponse;
import software.amazon.awssdk.services.iot.model.RegisterThingRequest;
import software.amazon.awssdk.services.iot.model.RegisterThingResponse;
import software.amazon.awssdk.services.iot.model.RegistrationCodeValidationException;
import software.amazon.awssdk.services.iot.model.RejectCertificateTransferRequest;
import software.amazon.awssdk.services.iot.model.RejectCertificateTransferResponse;
import software.amazon.awssdk.services.iot.model.RemoveThingFromBillingGroupRequest;
import software.amazon.awssdk.services.iot.model.RemoveThingFromBillingGroupResponse;
import software.amazon.awssdk.services.iot.model.RemoveThingFromThingGroupRequest;
import software.amazon.awssdk.services.iot.model.RemoveThingFromThingGroupResponse;
import software.amazon.awssdk.services.iot.model.ReplaceTopicRuleRequest;
import software.amazon.awssdk.services.iot.model.ReplaceTopicRuleResponse;
import software.amazon.awssdk.services.iot.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.iot.model.ResourceNotFoundException;
import software.amazon.awssdk.services.iot.model.ResourceRegistrationFailureException;
import software.amazon.awssdk.services.iot.model.SearchIndexRequest;
import software.amazon.awssdk.services.iot.model.SearchIndexResponse;
import software.amazon.awssdk.services.iot.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.iot.model.ServiceUnavailableException;
import software.amazon.awssdk.services.iot.model.SetDefaultAuthorizerRequest;
import software.amazon.awssdk.services.iot.model.SetDefaultAuthorizerResponse;
import software.amazon.awssdk.services.iot.model.SetDefaultPolicyVersionRequest;
import software.amazon.awssdk.services.iot.model.SetDefaultPolicyVersionResponse;
import software.amazon.awssdk.services.iot.model.SetLoggingOptionsRequest;
import software.amazon.awssdk.services.iot.model.SetLoggingOptionsResponse;
import software.amazon.awssdk.services.iot.model.SetV2LoggingLevelRequest;
import software.amazon.awssdk.services.iot.model.SetV2LoggingLevelResponse;
import software.amazon.awssdk.services.iot.model.SetV2LoggingOptionsRequest;
import software.amazon.awssdk.services.iot.model.SetV2LoggingOptionsResponse;
import software.amazon.awssdk.services.iot.model.SqlParseException;
import software.amazon.awssdk.services.iot.model.StartAuditMitigationActionsTaskRequest;
import software.amazon.awssdk.services.iot.model.StartAuditMitigationActionsTaskResponse;
import software.amazon.awssdk.services.iot.model.StartDetectMitigationActionsTaskRequest;
import software.amazon.awssdk.services.iot.model.StartDetectMitigationActionsTaskResponse;
import software.amazon.awssdk.services.iot.model.StartOnDemandAuditTaskRequest;
import software.amazon.awssdk.services.iot.model.StartOnDemandAuditTaskResponse;
import software.amazon.awssdk.services.iot.model.StartThingRegistrationTaskRequest;
import software.amazon.awssdk.services.iot.model.StartThingRegistrationTaskResponse;
import software.amazon.awssdk.services.iot.model.StopThingRegistrationTaskRequest;
import software.amazon.awssdk.services.iot.model.StopThingRegistrationTaskResponse;
import software.amazon.awssdk.services.iot.model.TagResourceRequest;
import software.amazon.awssdk.services.iot.model.TagResourceResponse;
import software.amazon.awssdk.services.iot.model.TaskAlreadyExistsException;
import software.amazon.awssdk.services.iot.model.TestAuthorizationRequest;
import software.amazon.awssdk.services.iot.model.TestAuthorizationResponse;
import software.amazon.awssdk.services.iot.model.TestInvokeAuthorizerRequest;
import software.amazon.awssdk.services.iot.model.TestInvokeAuthorizerResponse;
import software.amazon.awssdk.services.iot.model.ThrottlingException;
import software.amazon.awssdk.services.iot.model.TransferAlreadyCompletedException;
import software.amazon.awssdk.services.iot.model.TransferCertificateRequest;
import software.amazon.awssdk.services.iot.model.TransferCertificateResponse;
import software.amazon.awssdk.services.iot.model.TransferConflictException;
import software.amazon.awssdk.services.iot.model.UnauthorizedException;
import software.amazon.awssdk.services.iot.model.UntagResourceRequest;
import software.amazon.awssdk.services.iot.model.UntagResourceResponse;
import software.amazon.awssdk.services.iot.model.UpdateAccountAuditConfigurationRequest;
import software.amazon.awssdk.services.iot.model.UpdateAccountAuditConfigurationResponse;
import software.amazon.awssdk.services.iot.model.UpdateAuditSuppressionRequest;
import software.amazon.awssdk.services.iot.model.UpdateAuditSuppressionResponse;
import software.amazon.awssdk.services.iot.model.UpdateAuthorizerRequest;
import software.amazon.awssdk.services.iot.model.UpdateAuthorizerResponse;
import software.amazon.awssdk.services.iot.model.UpdateBillingGroupRequest;
import software.amazon.awssdk.services.iot.model.UpdateBillingGroupResponse;
import software.amazon.awssdk.services.iot.model.UpdateCaCertificateRequest;
import software.amazon.awssdk.services.iot.model.UpdateCaCertificateResponse;
import software.amazon.awssdk.services.iot.model.UpdateCertificateRequest;
import software.amazon.awssdk.services.iot.model.UpdateCertificateResponse;
import software.amazon.awssdk.services.iot.model.UpdateCustomMetricRequest;
import software.amazon.awssdk.services.iot.model.UpdateCustomMetricResponse;
import software.amazon.awssdk.services.iot.model.UpdateDimensionRequest;
import software.amazon.awssdk.services.iot.model.UpdateDimensionResponse;
import software.amazon.awssdk.services.iot.model.UpdateDomainConfigurationRequest;
import software.amazon.awssdk.services.iot.model.UpdateDomainConfigurationResponse;
import software.amazon.awssdk.services.iot.model.UpdateDynamicThingGroupRequest;
import software.amazon.awssdk.services.iot.model.UpdateDynamicThingGroupResponse;
import software.amazon.awssdk.services.iot.model.UpdateEventConfigurationsRequest;
import software.amazon.awssdk.services.iot.model.UpdateEventConfigurationsResponse;
import software.amazon.awssdk.services.iot.model.UpdateFleetMetricRequest;
import software.amazon.awssdk.services.iot.model.UpdateFleetMetricResponse;
import software.amazon.awssdk.services.iot.model.UpdateIndexingConfigurationRequest;
import software.amazon.awssdk.services.iot.model.UpdateIndexingConfigurationResponse;
import software.amazon.awssdk.services.iot.model.UpdateJobRequest;
import software.amazon.awssdk.services.iot.model.UpdateJobResponse;
import software.amazon.awssdk.services.iot.model.UpdateMitigationActionRequest;
import software.amazon.awssdk.services.iot.model.UpdateMitigationActionResponse;
import software.amazon.awssdk.services.iot.model.UpdatePackageConfigurationRequest;
import software.amazon.awssdk.services.iot.model.UpdatePackageConfigurationResponse;
import software.amazon.awssdk.services.iot.model.UpdatePackageRequest;
import software.amazon.awssdk.services.iot.model.UpdatePackageResponse;
import software.amazon.awssdk.services.iot.model.UpdatePackageVersionRequest;
import software.amazon.awssdk.services.iot.model.UpdatePackageVersionResponse;
import software.amazon.awssdk.services.iot.model.UpdateProvisioningTemplateRequest;
import software.amazon.awssdk.services.iot.model.UpdateProvisioningTemplateResponse;
import software.amazon.awssdk.services.iot.model.UpdateRoleAliasRequest;
import software.amazon.awssdk.services.iot.model.UpdateRoleAliasResponse;
import software.amazon.awssdk.services.iot.model.UpdateScheduledAuditRequest;
import software.amazon.awssdk.services.iot.model.UpdateScheduledAuditResponse;
import software.amazon.awssdk.services.iot.model.UpdateSecurityProfileRequest;
import software.amazon.awssdk.services.iot.model.UpdateSecurityProfileResponse;
import software.amazon.awssdk.services.iot.model.UpdateStreamRequest;
import software.amazon.awssdk.services.iot.model.UpdateStreamResponse;
import software.amazon.awssdk.services.iot.model.UpdateThingGroupRequest;
import software.amazon.awssdk.services.iot.model.UpdateThingGroupResponse;
import software.amazon.awssdk.services.iot.model.UpdateThingGroupsForThingRequest;
import software.amazon.awssdk.services.iot.model.UpdateThingGroupsForThingResponse;
import software.amazon.awssdk.services.iot.model.UpdateThingRequest;
import software.amazon.awssdk.services.iot.model.UpdateThingResponse;
import software.amazon.awssdk.services.iot.model.UpdateTopicRuleDestinationRequest;
import software.amazon.awssdk.services.iot.model.UpdateTopicRuleDestinationResponse;
import software.amazon.awssdk.services.iot.model.ValidateSecurityProfileBehaviorsRequest;
import software.amazon.awssdk.services.iot.model.ValidateSecurityProfileBehaviorsResponse;
import software.amazon.awssdk.services.iot.model.ValidationException;
import software.amazon.awssdk.services.iot.model.VersionConflictException;
import software.amazon.awssdk.services.iot.model.VersionsLimitExceededException;
import software.amazon.awssdk.services.iot.transform.AcceptCertificateTransferRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.AddThingToBillingGroupRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.AddThingToThingGroupRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.AssociateTargetsWithJobRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.AttachPolicyRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.AttachSecurityProfileRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.AttachThingPrincipalRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CancelAuditMitigationActionsTaskRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CancelAuditTaskRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CancelCertificateTransferRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CancelDetectMitigationActionsTaskRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CancelJobExecutionRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CancelJobRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ClearDefaultAuthorizerRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ConfirmTopicRuleDestinationRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CreateAuditSuppressionRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CreateAuthorizerRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CreateBillingGroupRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CreateCertificateFromCsrRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CreateCustomMetricRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CreateDimensionRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CreateDomainConfigurationRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CreateDynamicThingGroupRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CreateFleetMetricRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CreateJobRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CreateJobTemplateRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CreateKeysAndCertificateRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CreateMitigationActionRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CreateOtaUpdateRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CreatePackageRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CreatePackageVersionRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CreatePolicyRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CreatePolicyVersionRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CreateProvisioningClaimRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CreateProvisioningTemplateRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CreateProvisioningTemplateVersionRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CreateRoleAliasRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CreateScheduledAuditRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CreateSecurityProfileRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CreateStreamRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CreateThingGroupRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CreateThingRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CreateThingTypeRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CreateTopicRuleDestinationRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.CreateTopicRuleRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteAccountAuditConfigurationRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteAuditSuppressionRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteAuthorizerRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteBillingGroupRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteCaCertificateRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteCertificateRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteCustomMetricRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteDimensionRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteDomainConfigurationRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteDynamicThingGroupRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteFleetMetricRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteJobExecutionRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteJobRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteJobTemplateRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteMitigationActionRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteOtaUpdateRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeletePackageRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeletePackageVersionRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeletePolicyRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeletePolicyVersionRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteProvisioningTemplateRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteProvisioningTemplateVersionRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteRegistrationCodeRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteRoleAliasRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteScheduledAuditRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteSecurityProfileRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteStreamRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteThingGroupRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteThingRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteThingTypeRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteTopicRuleDestinationRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteTopicRuleRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeleteV2LoggingLevelRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DeprecateThingTypeRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeAccountAuditConfigurationRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeAuditFindingRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeAuditMitigationActionsTaskRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeAuditSuppressionRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeAuditTaskRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeAuthorizerRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeBillingGroupRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeCaCertificateRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeCertificateRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeCustomMetricRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeDefaultAuthorizerRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeDetectMitigationActionsTaskRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeDimensionRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeDomainConfigurationRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeEndpointRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeEventConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeFleetMetricRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeIndexRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeJobExecutionRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeJobRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeJobTemplateRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeManagedJobTemplateRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeMitigationActionRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeProvisioningTemplateRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeProvisioningTemplateVersionRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeRoleAliasRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeScheduledAuditRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeSecurityProfileRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeStreamRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeThingGroupRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeThingRegistrationTaskRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeThingRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DescribeThingTypeRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DetachPolicyRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DetachSecurityProfileRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DetachThingPrincipalRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.DisableTopicRuleRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.EnableTopicRuleRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.GetBehaviorModelTrainingSummariesRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.GetBucketsAggregationRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.GetCardinalityRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.GetEffectivePoliciesRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.GetIndexingConfigurationRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.GetJobDocumentRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.GetLoggingOptionsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.GetOtaUpdateRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.GetPackageConfigurationRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.GetPackageRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.GetPackageVersionRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.GetPercentilesRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.GetPolicyRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.GetPolicyVersionRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.GetRegistrationCodeRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.GetStatisticsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.GetTopicRuleDestinationRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.GetTopicRuleRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.GetV2LoggingOptionsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListActiveViolationsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListAttachedPoliciesRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListAuditFindingsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListAuditMitigationActionsExecutionsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListAuditMitigationActionsTasksRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListAuditSuppressionsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListAuditTasksRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListAuthorizersRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListBillingGroupsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListCaCertificatesRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListCertificatesByCaRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListCertificatesRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListCustomMetricsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListDetectMitigationActionsExecutionsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListDetectMitigationActionsTasksRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListDimensionsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListDomainConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListFleetMetricsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListIndicesRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListJobExecutionsForJobRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListJobExecutionsForThingRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListJobTemplatesRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListJobsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListManagedJobTemplatesRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListMetricValuesRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListMitigationActionsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListOtaUpdatesRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListOutgoingCertificatesRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListPackageVersionsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListPackagesRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListPoliciesRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListPolicyVersionsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListPrincipalThingsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListProvisioningTemplateVersionsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListProvisioningTemplatesRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListRelatedResourcesForAuditFindingRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListRoleAliasesRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListScheduledAuditsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListSecurityProfilesForTargetRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListSecurityProfilesRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListStreamsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListTargetsForPolicyRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListTargetsForSecurityProfileRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListThingGroupsForThingRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListThingGroupsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListThingPrincipalsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListThingRegistrationTaskReportsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListThingRegistrationTasksRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListThingTypesRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListThingsInBillingGroupRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListThingsInThingGroupRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListThingsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListTopicRuleDestinationsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListTopicRulesRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListV2LoggingLevelsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ListViolationEventsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.PutVerificationStateOnViolationRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.RegisterCaCertificateRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.RegisterCertificateRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.RegisterCertificateWithoutCaRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.RegisterThingRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.RejectCertificateTransferRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.RemoveThingFromBillingGroupRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.RemoveThingFromThingGroupRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ReplaceTopicRuleRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.SearchIndexRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.SetDefaultAuthorizerRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.SetDefaultPolicyVersionRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.SetLoggingOptionsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.SetV2LoggingLevelRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.SetV2LoggingOptionsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.StartAuditMitigationActionsTaskRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.StartDetectMitigationActionsTaskRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.StartOnDemandAuditTaskRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.StartThingRegistrationTaskRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.StopThingRegistrationTaskRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.TestAuthorizationRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.TestInvokeAuthorizerRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.TransferCertificateRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.UpdateAccountAuditConfigurationRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.UpdateAuditSuppressionRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.UpdateAuthorizerRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.UpdateBillingGroupRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.UpdateCaCertificateRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.UpdateCertificateRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.UpdateCustomMetricRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.UpdateDimensionRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.UpdateDomainConfigurationRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.UpdateDynamicThingGroupRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.UpdateEventConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.UpdateFleetMetricRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.UpdateIndexingConfigurationRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.UpdateJobRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.UpdateMitigationActionRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.UpdatePackageConfigurationRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.UpdatePackageRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.UpdatePackageVersionRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.UpdateProvisioningTemplateRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.UpdateRoleAliasRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.UpdateScheduledAuditRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.UpdateSecurityProfileRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.UpdateStreamRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.UpdateThingGroupRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.UpdateThingGroupsForThingRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.UpdateThingRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.UpdateTopicRuleDestinationRequestMarshaller;
import software.amazon.awssdk.services.iot.transform.ValidateSecurityProfileBehaviorsRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link IotClient}.
 *
 * @see IotClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultIotClient implements IotClient {
    private static final Logger log = Logger.loggerFor(DefaultIotClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.REST_JSON).build();

    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    private final IotServiceClientConfiguration serviceClientConfiguration;

    protected DefaultIotClient(IotServiceClientConfiguration serviceClientConfiguration,
            SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.serviceClientConfiguration = serviceClientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Accepts a pending certificate transfer. The default state of the certificate is INACTIVE.
     * </p>
     * <p>
     * To check for pending certificate transfers, call <a>ListCertificates</a> to enumerate your certificates.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >AcceptCertificateTransfer</a> action.
     * </p>
     *
     * @param acceptCertificateTransferRequest
     *        The input for the AcceptCertificateTransfer operation.
     * @return Result of the AcceptCertificateTransfer operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws TransferAlreadyCompletedException
     *         You can't revert the certificate transfer because the transfer is already complete.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.AcceptCertificateTransfer
     */
    @Override
    public AcceptCertificateTransferResponse acceptCertificateTransfer(
            AcceptCertificateTransferRequest acceptCertificateTransferRequest) throws ResourceNotFoundException,
            TransferAlreadyCompletedException, InvalidRequestException, ThrottlingException, UnauthorizedException,
            ServiceUnavailableException, InternalFailureException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AcceptCertificateTransferResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AcceptCertificateTransferResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(acceptCertificateTransferRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, acceptCertificateTransferRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AcceptCertificateTransfer");

            return clientHandler
                    .execute(new ClientExecutionParams<AcceptCertificateTransferRequest, AcceptCertificateTransferResponse>()
                            .withOperationName("AcceptCertificateTransfer").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(acceptCertificateTransferRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AcceptCertificateTransferRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Adds a thing to a billing group.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >AddThingToBillingGroup</a> action.
     * </p>
     *
     * @param addThingToBillingGroupRequest
     * @return Result of the AddThingToBillingGroup operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.AddThingToBillingGroup
     */
    @Override
    public AddThingToBillingGroupResponse addThingToBillingGroup(AddThingToBillingGroupRequest addThingToBillingGroupRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AddThingToBillingGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AddThingToBillingGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(addThingToBillingGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, addThingToBillingGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddThingToBillingGroup");

            return clientHandler
                    .execute(new ClientExecutionParams<AddThingToBillingGroupRequest, AddThingToBillingGroupResponse>()
                            .withOperationName("AddThingToBillingGroup").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(addThingToBillingGroupRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AddThingToBillingGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Adds a thing to a thing group.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >AddThingToThingGroup</a> action.
     * </p>
     *
     * @param addThingToThingGroupRequest
     * @return Result of the AddThingToThingGroup operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.AddThingToThingGroup
     */
    @Override
    public AddThingToThingGroupResponse addThingToThingGroup(AddThingToThingGroupRequest addThingToThingGroupRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AddThingToThingGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AddThingToThingGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(addThingToThingGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, addThingToThingGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddThingToThingGroup");

            return clientHandler.execute(new ClientExecutionParams<AddThingToThingGroupRequest, AddThingToThingGroupResponse>()
                    .withOperationName("AddThingToThingGroup").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(addThingToThingGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AddThingToThingGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associates a group with a continuous job. The following criteria must be met:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The job must have been created with the <code>targetSelection</code> field set to "CONTINUOUS".
     * </p>
     * </li>
     * <li>
     * <p>
     * The job status must currently be "IN_PROGRESS".
     * </p>
     * </li>
     * <li>
     * <p>
     * The total number of targets associated with a job must not exceed 100.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >AssociateTargetsWithJob</a> action.
     * </p>
     *
     * @param associateTargetsWithJobRequest
     * @return Result of the AssociateTargetsWithJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.AssociateTargetsWithJob
     */
    @Override
    public AssociateTargetsWithJobResponse associateTargetsWithJob(AssociateTargetsWithJobRequest associateTargetsWithJobRequest)
            throws InvalidRequestException, ResourceNotFoundException, LimitExceededException, ThrottlingException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociateTargetsWithJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AssociateTargetsWithJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateTargetsWithJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateTargetsWithJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateTargetsWithJob");

            return clientHandler
                    .execute(new ClientExecutionParams<AssociateTargetsWithJobRequest, AssociateTargetsWithJobResponse>()
                            .withOperationName("AssociateTargetsWithJob").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(associateTargetsWithJobRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AssociateTargetsWithJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Attaches the specified policy to the specified principal (certificate or other credential).
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >AttachPolicy</a> action.
     * </p>
     *
     * @param attachPolicyRequest
     * @return Result of the AttachPolicy operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.AttachPolicy
     */
    @Override
    public AttachPolicyResponse attachPolicy(AttachPolicyRequest attachPolicyRequest) throws ResourceNotFoundException,
            InvalidRequestException, ThrottlingException, UnauthorizedException, ServiceUnavailableException,
            InternalFailureException, LimitExceededException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AttachPolicyResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                AttachPolicyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(attachPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, attachPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AttachPolicy");

            return clientHandler.execute(new ClientExecutionParams<AttachPolicyRequest, AttachPolicyResponse>()
                    .withOperationName("AttachPolicy").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(attachPolicyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AttachPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associates a Device Defender security profile with a thing group or this account. Each thing group or account can
     * have up to five security profiles associated with it.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >AttachSecurityProfile</a> action.
     * </p>
     *
     * @param attachSecurityProfileRequest
     * @return Result of the AttachSecurityProfile operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws VersionConflictException
     *         An exception thrown when the version of an entity specified with the <code>expectedVersion</code>
     *         parameter does not match the latest version in the system.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.AttachSecurityProfile
     */
    @Override
    public AttachSecurityProfileResponse attachSecurityProfile(AttachSecurityProfileRequest attachSecurityProfileRequest)
            throws InvalidRequestException, ResourceNotFoundException, LimitExceededException, VersionConflictException,
            ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AttachSecurityProfileResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AttachSecurityProfileResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(attachSecurityProfileRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, attachSecurityProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AttachSecurityProfile");

            return clientHandler.execute(new ClientExecutionParams<AttachSecurityProfileRequest, AttachSecurityProfileResponse>()
                    .withOperationName("AttachSecurityProfile").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(attachSecurityProfileRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AttachSecurityProfileRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Attaches the specified principal to the specified thing. A principal can be X.509 certificates, Amazon Cognito
     * identities or federated identities.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >AttachThingPrincipal</a> action.
     * </p>
     *
     * @param attachThingPrincipalRequest
     *        The input for the AttachThingPrincipal operation.
     * @return Result of the AttachThingPrincipal operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.AttachThingPrincipal
     */
    @Override
    public AttachThingPrincipalResponse attachThingPrincipal(AttachThingPrincipalRequest attachThingPrincipalRequest)
            throws ResourceNotFoundException, InvalidRequestException, ThrottlingException, UnauthorizedException,
            ServiceUnavailableException, InternalFailureException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AttachThingPrincipalResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AttachThingPrincipalResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(attachThingPrincipalRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, attachThingPrincipalRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AttachThingPrincipal");

            return clientHandler.execute(new ClientExecutionParams<AttachThingPrincipalRequest, AttachThingPrincipalResponse>()
                    .withOperationName("AttachThingPrincipal").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(attachThingPrincipalRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AttachThingPrincipalRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Cancels a mitigation action task that is in progress. If the task is not in progress, an InvalidRequestException
     * occurs.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CancelAuditMitigationActionsTask</a> action.
     * </p>
     *
     * @param cancelAuditMitigationActionsTaskRequest
     * @return Result of the CancelAuditMitigationActionsTask operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CancelAuditMitigationActionsTask
     */
    @Override
    public CancelAuditMitigationActionsTaskResponse cancelAuditMitigationActionsTask(
            CancelAuditMitigationActionsTaskRequest cancelAuditMitigationActionsTaskRequest) throws ResourceNotFoundException,
            InvalidRequestException, ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException,
            IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CancelAuditMitigationActionsTaskResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CancelAuditMitigationActionsTaskResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelAuditMitigationActionsTaskRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                cancelAuditMitigationActionsTaskRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelAuditMitigationActionsTask");

            return clientHandler
                    .execute(new ClientExecutionParams<CancelAuditMitigationActionsTaskRequest, CancelAuditMitigationActionsTaskResponse>()
                            .withOperationName("CancelAuditMitigationActionsTask").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(cancelAuditMitigationActionsTaskRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CancelAuditMitigationActionsTaskRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Cancels an audit that is in progress. The audit can be either scheduled or on demand. If the audit isn't in
     * progress, an "InvalidRequestException" occurs.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CancelAuditTask</a> action.
     * </p>
     *
     * @param cancelAuditTaskRequest
     * @return Result of the CancelAuditTask operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CancelAuditTask
     */
    @Override
    public CancelAuditTaskResponse cancelAuditTask(CancelAuditTaskRequest cancelAuditTaskRequest)
            throws ResourceNotFoundException, InvalidRequestException, ThrottlingException, InternalFailureException,
            AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CancelAuditTaskResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CancelAuditTaskResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelAuditTaskRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelAuditTaskRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelAuditTask");

            return clientHandler.execute(new ClientExecutionParams<CancelAuditTaskRequest, CancelAuditTaskResponse>()
                    .withOperationName("CancelAuditTask").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(cancelAuditTaskRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CancelAuditTaskRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Cancels a pending transfer for the specified certificate.
     * </p>
     * <p>
     * <b>Note</b> Only the transfer source account can use this operation to cancel a transfer. (Transfer destinations
     * can use <a>RejectCertificateTransfer</a> instead.) After transfer, IoT returns the certificate to the source
     * account in the INACTIVE state. After the destination account has accepted the transfer, the transfer cannot be
     * cancelled.
     * </p>
     * <p>
     * After a certificate transfer is cancelled, the status of the certificate changes from PENDING_TRANSFER to
     * INACTIVE.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CancelCertificateTransfer</a> action.
     * </p>
     *
     * @param cancelCertificateTransferRequest
     *        The input for the CancelCertificateTransfer operation.
     * @return Result of the CancelCertificateTransfer operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws TransferAlreadyCompletedException
     *         You can't revert the certificate transfer because the transfer is already complete.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CancelCertificateTransfer
     */
    @Override
    public CancelCertificateTransferResponse cancelCertificateTransfer(
            CancelCertificateTransferRequest cancelCertificateTransferRequest) throws ResourceNotFoundException,
            TransferAlreadyCompletedException, InvalidRequestException, ThrottlingException, UnauthorizedException,
            ServiceUnavailableException, InternalFailureException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CancelCertificateTransferResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CancelCertificateTransferResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelCertificateTransferRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelCertificateTransferRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelCertificateTransfer");

            return clientHandler
                    .execute(new ClientExecutionParams<CancelCertificateTransferRequest, CancelCertificateTransferResponse>()
                            .withOperationName("CancelCertificateTransfer").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(cancelCertificateTransferRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CancelCertificateTransferRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Cancels a Device Defender ML Detect mitigation action.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CancelDetectMitigationActionsTask</a> action.
     * </p>
     *
     * @param cancelDetectMitigationActionsTaskRequest
     * @return Result of the CancelDetectMitigationActionsTask operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CancelDetectMitigationActionsTask
     */
    @Override
    public CancelDetectMitigationActionsTaskResponse cancelDetectMitigationActionsTask(
            CancelDetectMitigationActionsTaskRequest cancelDetectMitigationActionsTaskRequest) throws ResourceNotFoundException,
            InvalidRequestException, ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException,
            IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CancelDetectMitigationActionsTaskResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CancelDetectMitigationActionsTaskResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelDetectMitigationActionsTaskRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                cancelDetectMitigationActionsTaskRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelDetectMitigationActionsTask");

            return clientHandler
                    .execute(new ClientExecutionParams<CancelDetectMitigationActionsTaskRequest, CancelDetectMitigationActionsTaskResponse>()
                            .withOperationName("CancelDetectMitigationActionsTask").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(cancelDetectMitigationActionsTaskRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CancelDetectMitigationActionsTaskRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Cancels a job.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CancelJob</a> action.
     * </p>
     *
     * @param cancelJobRequest
     * @return Result of the CancelJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CancelJob
     */
    @Override
    public CancelJobResponse cancelJob(CancelJobRequest cancelJobRequest) throws InvalidRequestException,
            ResourceNotFoundException, ThrottlingException, ServiceUnavailableException, LimitExceededException,
            AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CancelJobResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CancelJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelJob");

            return clientHandler.execute(new ClientExecutionParams<CancelJobRequest, CancelJobResponse>()
                    .withOperationName("CancelJob").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(cancelJobRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CancelJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Cancels the execution of a job for a given thing.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CancelJobExecution</a> action.
     * </p>
     *
     * @param cancelJobExecutionRequest
     * @return Result of the CancelJobExecution operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidStateTransitionException
     *         An attempt was made to change to an invalid state, for example by deleting a job or a job execution which
     *         is "IN_PROGRESS" without setting the <code>force</code> parameter.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws VersionConflictException
     *         An exception thrown when the version of an entity specified with the <code>expectedVersion</code>
     *         parameter does not match the latest version in the system.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CancelJobExecution
     */
    @Override
    public CancelJobExecutionResponse cancelJobExecution(CancelJobExecutionRequest cancelJobExecutionRequest)
            throws InvalidRequestException, InvalidStateTransitionException, ResourceNotFoundException, ThrottlingException,
            ServiceUnavailableException, VersionConflictException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CancelJobExecutionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CancelJobExecutionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelJobExecutionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelJobExecutionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelJobExecution");

            return clientHandler.execute(new ClientExecutionParams<CancelJobExecutionRequest, CancelJobExecutionResponse>()
                    .withOperationName("CancelJobExecution").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(cancelJobExecutionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CancelJobExecutionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Clears the default authorizer.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ClearDefaultAuthorizer</a> action.
     * </p>
     *
     * @param clearDefaultAuthorizerRequest
     * @return Result of the ClearDefaultAuthorizer operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ClearDefaultAuthorizer
     */
    @Override
    public ClearDefaultAuthorizerResponse clearDefaultAuthorizer(ClearDefaultAuthorizerRequest clearDefaultAuthorizerRequest)
            throws ResourceNotFoundException, InvalidRequestException, ThrottlingException, UnauthorizedException,
            ServiceUnavailableException, InternalFailureException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ClearDefaultAuthorizerResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ClearDefaultAuthorizerResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(clearDefaultAuthorizerRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, clearDefaultAuthorizerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ClearDefaultAuthorizer");

            return clientHandler
                    .execute(new ClientExecutionParams<ClearDefaultAuthorizerRequest, ClearDefaultAuthorizerResponse>()
                            .withOperationName("ClearDefaultAuthorizer").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(clearDefaultAuthorizerRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ClearDefaultAuthorizerRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Confirms a topic rule destination. When you create a rule requiring a destination, IoT sends a confirmation
     * message to the endpoint or base address you specify. The message includes a token which you pass back when
     * calling <code>ConfirmTopicRuleDestination</code> to confirm that you own or have access to the endpoint.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ConfirmTopicRuleDestination</a> action.
     * </p>
     *
     * @param confirmTopicRuleDestinationRequest
     * @return Result of the ConfirmTopicRuleDestination operation returned by the service.
     * @throws InternalException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ConflictingResourceUpdateException
     *         A conflicting resource update exception. This exception is thrown when two pending updates cause a
     *         conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ConfirmTopicRuleDestination
     */
    @Override
    public ConfirmTopicRuleDestinationResponse confirmTopicRuleDestination(
            ConfirmTopicRuleDestinationRequest confirmTopicRuleDestinationRequest) throws InternalException,
            InvalidRequestException, ServiceUnavailableException, UnauthorizedException, ConflictingResourceUpdateException,
            AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ConfirmTopicRuleDestinationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ConfirmTopicRuleDestinationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(confirmTopicRuleDestinationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, confirmTopicRuleDestinationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ConfirmTopicRuleDestination");

            return clientHandler
                    .execute(new ClientExecutionParams<ConfirmTopicRuleDestinationRequest, ConfirmTopicRuleDestinationResponse>()
                            .withOperationName("ConfirmTopicRuleDestination").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(confirmTopicRuleDestinationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ConfirmTopicRuleDestinationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a Device Defender audit suppression.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateAuditSuppression</a> action.
     * </p>
     *
     * @param createAuditSuppressionRequest
     * @return Result of the CreateAuditSuppression operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateAuditSuppression
     */
    @Override
    public CreateAuditSuppressionResponse createAuditSuppression(CreateAuditSuppressionRequest createAuditSuppressionRequest)
            throws InvalidRequestException, ResourceAlreadyExistsException, ThrottlingException, InternalFailureException,
            LimitExceededException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateAuditSuppressionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateAuditSuppressionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createAuditSuppressionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAuditSuppressionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAuditSuppression");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateAuditSuppressionRequest, CreateAuditSuppressionResponse>()
                            .withOperationName("CreateAuditSuppression").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createAuditSuppressionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateAuditSuppressionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an authorizer.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateAuthorizer</a> action.
     * </p>
     *
     * @param createAuthorizerRequest
     * @return Result of the CreateAuthorizer operation returned by the service.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateAuthorizer
     */
    @Override
    public CreateAuthorizerResponse createAuthorizer(CreateAuthorizerRequest createAuthorizerRequest)
            throws ResourceAlreadyExistsException, InvalidRequestException, LimitExceededException, ThrottlingException,
            UnauthorizedException, ServiceUnavailableException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateAuthorizerResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateAuthorizerResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createAuthorizerRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAuthorizerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAuthorizer");

            return clientHandler.execute(new ClientExecutionParams<CreateAuthorizerRequest, CreateAuthorizerResponse>()
                    .withOperationName("CreateAuthorizer").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createAuthorizerRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateAuthorizerRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a billing group.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateBillingGroup</a> action.
     * </p>
     *
     * @param createBillingGroupRequest
     * @return Result of the CreateBillingGroup operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateBillingGroup
     */
    @Override
    public CreateBillingGroupResponse createBillingGroup(CreateBillingGroupRequest createBillingGroupRequest)
            throws InvalidRequestException, ResourceAlreadyExistsException, ThrottlingException, InternalFailureException,
            AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateBillingGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateBillingGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createBillingGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createBillingGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateBillingGroup");

            return clientHandler.execute(new ClientExecutionParams<CreateBillingGroupRequest, CreateBillingGroupResponse>()
                    .withOperationName("CreateBillingGroup").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createBillingGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateBillingGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an X.509 certificate using the specified certificate signing request.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateCertificateFromCsr</a> action.
     * </p>
     * <note>
     * <p>
     * The CSR must include a public key that is either an RSA key with a length of at least 2048 bits or an ECC key
     * from NIST P-256, NIST P-384, or NIST P-521 curves. For supported certificates, consult <a
     * href="https://docs.aws.amazon.com/iot/latest/developerguide/x509-client-certs.html#x509-cert-algorithms">
     * Certificate signing algorithms supported by IoT</a>.
     * </p>
     * </note> <note>
     * <p>
     * Reusing the same certificate signing request (CSR) results in a distinct certificate.
     * </p>
     * </note>
     * <p>
     * You can create multiple certificates in a batch by creating a directory, copying multiple <code>.csr</code> files
     * into that directory, and then specifying that directory on the command line. The following commands show how to
     * create a batch of certificates given a batch of CSRs. In the following commands, we assume that a set of CSRs are
     * located inside of the directory my-csr-directory:
     * </p>
     * <p>
     * On Linux and OS X, the command is:
     * </p>
     * <p>
     * <code>&#36 ls my-csr-directory/ | xargs -I {} aws iot create-certificate-from-csr --certificate-signing-request file://my-csr-directory/{}</code>
     * </p>
     * <p>
     * This command lists all of the CSRs in my-csr-directory and pipes each CSR file name to the
     * <code>aws iot create-certificate-from-csr</code> Amazon Web Services CLI command to create a certificate for the
     * corresponding CSR.
     * </p>
     * <p>
     * You can also run the <code>aws iot create-certificate-from-csr</code> part of the command in parallel to speed up
     * the certificate creation process:
     * </p>
     * <p>
     * <code>&#36 ls my-csr-directory/ | xargs -P 10 -I {} aws iot create-certificate-from-csr --certificate-signing-request file://my-csr-directory/{} </code>
     * </p>
     * <p>
     * On Windows PowerShell, the command to create certificates for all CSRs in my-csr-directory is:
     * </p>
     * <p>
     * <code>&gt; ls -Name my-csr-directory | %{aws iot create-certificate-from-csr --certificate-signing-request file://my-csr-directory/&#36_} </code>
     * </p>
     * <p>
     * On a Windows command prompt, the command to create certificates for all CSRs in my-csr-directory is:
     * </p>
     * <p>
     * <code>&gt; forfiles /p my-csr-directory /c "cmd /c aws iot create-certificate-from-csr --certificate-signing-request file://@path" </code>
     * </p>
     *
     * @param createCertificateFromCsrRequest
     *        The input for the CreateCertificateFromCsr operation.
     * @return Result of the CreateCertificateFromCsr operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateCertificateFromCsr
     */
    @Override
    public CreateCertificateFromCsrResponse createCertificateFromCsr(
            CreateCertificateFromCsrRequest createCertificateFromCsrRequest) throws InvalidRequestException, ThrottlingException,
            UnauthorizedException, ServiceUnavailableException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateCertificateFromCsrResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateCertificateFromCsrResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createCertificateFromCsrRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createCertificateFromCsrRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCertificateFromCsr");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateCertificateFromCsrRequest, CreateCertificateFromCsrResponse>()
                            .withOperationName("CreateCertificateFromCsr").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createCertificateFromCsrRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateCertificateFromCsrRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Use this API to define a Custom Metric published by your devices to Device Defender.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateCustomMetric</a> action.
     * </p>
     *
     * @param createCustomMetricRequest
     * @return Result of the CreateCustomMetric operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateCustomMetric
     */
    @Override
    public CreateCustomMetricResponse createCustomMetric(CreateCustomMetricRequest createCustomMetricRequest)
            throws InvalidRequestException, LimitExceededException, ResourceAlreadyExistsException, ThrottlingException,
            InternalFailureException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateCustomMetricResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateCustomMetricResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createCustomMetricRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createCustomMetricRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCustomMetric");

            return clientHandler.execute(new ClientExecutionParams<CreateCustomMetricRequest, CreateCustomMetricResponse>()
                    .withOperationName("CreateCustomMetric").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createCustomMetricRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateCustomMetricRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Create a dimension that you can use to limit the scope of a metric used in a security profile for IoT Device
     * Defender. For example, using a <code>TOPIC_FILTER</code> dimension, you can narrow down the scope of the metric
     * only to MQTT topics whose name match the pattern specified in the dimension.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateDimension</a> action.
     * </p>
     *
     * @param createDimensionRequest
     * @return Result of the CreateDimension operation returned by the service.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateDimension
     */
    @Override
    public CreateDimensionResponse createDimension(CreateDimensionRequest createDimensionRequest)
            throws InternalFailureException, InvalidRequestException, LimitExceededException, ResourceAlreadyExistsException,
            ThrottlingException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateDimensionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateDimensionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createDimensionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDimensionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDimension");

            return clientHandler.execute(new ClientExecutionParams<CreateDimensionRequest, CreateDimensionResponse>()
                    .withOperationName("CreateDimension").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createDimensionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateDimensionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a domain configuration.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateDomainConfiguration</a> action.
     * </p>
     *
     * @param createDomainConfigurationRequest
     * @return Result of the CreateDomainConfiguration operation returned by the service.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws CertificateValidationException
     *         The certificate is invalid.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateDomainConfiguration
     */
    @Override
    public CreateDomainConfigurationResponse createDomainConfiguration(
            CreateDomainConfigurationRequest createDomainConfigurationRequest) throws LimitExceededException,
            CertificateValidationException, ResourceAlreadyExistsException, ServiceUnavailableException,
            InternalFailureException, InvalidRequestException, UnauthorizedException, ThrottlingException, AwsServiceException,
            SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateDomainConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateDomainConfigurationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createDomainConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDomainConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDomainConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateDomainConfigurationRequest, CreateDomainConfigurationResponse>()
                            .withOperationName("CreateDomainConfiguration").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createDomainConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateDomainConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a dynamic thing group.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateDynamicThingGroup</a> action.
     * </p>
     *
     * @param createDynamicThingGroupRequest
     * @return Result of the CreateDynamicThingGroup operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws InvalidQueryException
     *         The query is invalid.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateDynamicThingGroup
     */
    @Override
    public CreateDynamicThingGroupResponse createDynamicThingGroup(CreateDynamicThingGroupRequest createDynamicThingGroupRequest)
            throws InvalidRequestException, ResourceAlreadyExistsException, ResourceNotFoundException, ThrottlingException,
            InternalFailureException, InvalidQueryException, LimitExceededException, AwsServiceException, SdkClientException,
            IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateDynamicThingGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateDynamicThingGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createDynamicThingGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDynamicThingGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDynamicThingGroup");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateDynamicThingGroupRequest, CreateDynamicThingGroupResponse>()
                            .withOperationName("CreateDynamicThingGroup").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createDynamicThingGroupRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateDynamicThingGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a fleet metric.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateFleetMetric</a> action.
     * </p>
     *
     * @param createFleetMetricRequest
     * @return Result of the CreateFleetMetric operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidQueryException
     *         The query is invalid.
     * @throws InvalidAggregationException
     *         The aggregation is invalid.
     * @throws IndexNotReadyException
     *         The index is not ready.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateFleetMetric
     */
    @Override
    public CreateFleetMetricResponse createFleetMetric(CreateFleetMetricRequest createFleetMetricRequest)
            throws InvalidRequestException, ThrottlingException, UnauthorizedException, ServiceUnavailableException,
            InternalFailureException, LimitExceededException, ResourceAlreadyExistsException, ResourceNotFoundException,
            InvalidQueryException, InvalidAggregationException, IndexNotReadyException, AwsServiceException, SdkClientException,
            IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateFleetMetricResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateFleetMetricResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createFleetMetricRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createFleetMetricRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateFleetMetric");

            return clientHandler.execute(new ClientExecutionParams<CreateFleetMetricRequest, CreateFleetMetricResponse>()
                    .withOperationName("CreateFleetMetric").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createFleetMetricRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateFleetMetricRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a job.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateJob</a> action.
     * </p>
     *
     * @param createJobRequest
     * @return Result of the CreateJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateJob
     */
    @Override
    public CreateJobResponse createJob(CreateJobRequest createJobRequest) throws InvalidRequestException,
            ResourceNotFoundException, ResourceAlreadyExistsException, LimitExceededException, ThrottlingException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateJobResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateJob");

            return clientHandler.execute(new ClientExecutionParams<CreateJobRequest, CreateJobResponse>()
                    .withOperationName("CreateJob").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(createJobRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a job template.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateJobTemplate</a> action.
     * </p>
     *
     * @param createJobTemplateRequest
     * @return Result of the CreateJobTemplate operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ConflictException
     *         A resource with the same name already exists.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateJobTemplate
     */
    @Override
    public CreateJobTemplateResponse createJobTemplate(CreateJobTemplateRequest createJobTemplateRequest)
            throws InvalidRequestException, ResourceNotFoundException, ConflictException, LimitExceededException,
            ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateJobTemplateResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateJobTemplateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createJobTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createJobTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateJobTemplate");

            return clientHandler.execute(new ClientExecutionParams<CreateJobTemplateRequest, CreateJobTemplateResponse>()
                    .withOperationName("CreateJobTemplate").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createJobTemplateRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateJobTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a 2048-bit RSA key pair and issues an X.509 certificate using the issued public key. You can also call
     * <code>CreateKeysAndCertificate</code> over MQTT from a device, for more information, see <a
     * href="https://docs.aws.amazon.com/iot/latest/developerguide/provision-wo-cert.html#provision-mqtt-api"
     * >Provisioning MQTT API</a>.
     * </p>
     * <p>
     * <b>Note</b> This is the only time IoT issues the private key for this certificate, so it is important to keep it
     * in a secure location.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateKeysAndCertificate</a> action.
     * </p>
     *
     * @param createKeysAndCertificateRequest
     *        The input for the CreateKeysAndCertificate operation.</p>
     *        <p>
     *        Requires permission to access the <a href=
     *        "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     *        >CreateKeysAndCertificateRequest</a> action.
     * @return Result of the CreateKeysAndCertificate operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateKeysAndCertificate
     */
    @Override
    public CreateKeysAndCertificateResponse createKeysAndCertificate(
            CreateKeysAndCertificateRequest createKeysAndCertificateRequest) throws InvalidRequestException, ThrottlingException,
            UnauthorizedException, ServiceUnavailableException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateKeysAndCertificateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateKeysAndCertificateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createKeysAndCertificateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createKeysAndCertificateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateKeysAndCertificate");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateKeysAndCertificateRequest, CreateKeysAndCertificateResponse>()
                            .withOperationName("CreateKeysAndCertificate").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createKeysAndCertificateRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateKeysAndCertificateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Defines an action that can be applied to audit findings by using StartAuditMitigationActionsTask. Only certain
     * types of mitigation actions can be applied to specific check names. For more information, see <a
     * href="https://docs.aws.amazon.com/iot/latest/developerguide/device-defender-mitigation-actions.html">Mitigation
     * actions</a>. Each mitigation action can apply only one type of change.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateMitigationAction</a> action.
     * </p>
     *
     * @param createMitigationActionRequest
     * @return Result of the CreateMitigationAction operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateMitigationAction
     */
    @Override
    public CreateMitigationActionResponse createMitigationAction(CreateMitigationActionRequest createMitigationActionRequest)
            throws InvalidRequestException, ResourceAlreadyExistsException, LimitExceededException, ThrottlingException,
            InternalFailureException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateMitigationActionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateMitigationActionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createMitigationActionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createMitigationActionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateMitigationAction");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateMitigationActionRequest, CreateMitigationActionResponse>()
                            .withOperationName("CreateMitigationAction").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createMitigationActionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateMitigationActionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an IoT OTA update on a target group of things or groups.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateOTAUpdate</a> action.
     * </p>
     *
     * @param createOtaUpdateRequest
     * @return Result of the CreateOTAUpdate operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateOTAUpdate
     */
    @Override
    public CreateOtaUpdateResponse createOTAUpdate(CreateOtaUpdateRequest createOtaUpdateRequest) throws InvalidRequestException,
            LimitExceededException, ResourceNotFoundException, ResourceAlreadyExistsException, ThrottlingException,
            UnauthorizedException, InternalFailureException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateOtaUpdateResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateOtaUpdateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createOtaUpdateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createOtaUpdateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateOTAUpdate");

            return clientHandler.execute(new ClientExecutionParams<CreateOtaUpdateRequest, CreateOtaUpdateResponse>()
                    .withOperationName("CreateOTAUpdate").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createOtaUpdateRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateOtaUpdateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an IoT software package that can be deployed to your fleet.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreatePackage</a> and <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >GetIndexingConfiguration</a> actions.
     * </p>
     *
     * @param createPackageRequest
     * @return Result of the CreatePackage operation returned by the service.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ConflictException
     *         A resource with the same name already exists.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ValidationException
     *         The request is not valid.
     * @throws ServiceQuotaExceededException
     *         A limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreatePackage
     */
    @Override
    public CreatePackageResponse createPackage(CreatePackageRequest createPackageRequest) throws ThrottlingException,
            ConflictException, InternalServerException, ValidationException, ServiceQuotaExceededException, AwsServiceException,
            SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreatePackageResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreatePackageResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createPackageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createPackageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreatePackage");

            return clientHandler.execute(new ClientExecutionParams<CreatePackageRequest, CreatePackageResponse>()
                    .withOperationName("CreatePackage").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createPackageRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreatePackageRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new version for an existing IoT software package.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreatePackageVersion</a> and <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >GetIndexingConfiguration</a> actions.
     * </p>
     *
     * @param createPackageVersionRequest
     * @return Result of the CreatePackageVersion operation returned by the service.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ConflictException
     *         A resource with the same name already exists.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ValidationException
     *         The request is not valid.
     * @throws ServiceQuotaExceededException
     *         A limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreatePackageVersion
     */
    @Override
    public CreatePackageVersionResponse createPackageVersion(CreatePackageVersionRequest createPackageVersionRequest)
            throws ThrottlingException, ConflictException, InternalServerException, ValidationException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreatePackageVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreatePackageVersionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createPackageVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createPackageVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreatePackageVersion");

            return clientHandler.execute(new ClientExecutionParams<CreatePackageVersionRequest, CreatePackageVersionResponse>()
                    .withOperationName("CreatePackageVersion").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createPackageVersionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreatePackageVersionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an IoT policy.
     * </p>
     * <p>
     * The created policy is the default version for the policy. This operation creates a policy version with a version
     * identifier of <b>1</b> and sets <b>1</b> as the policy's default version.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreatePolicy</a> action.
     * </p>
     *
     * @param createPolicyRequest
     *        The input for the CreatePolicy operation.
     * @return Result of the CreatePolicy operation returned by the service.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws MalformedPolicyException
     *         The policy documentation is not valid.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreatePolicy
     */
    @Override
    public CreatePolicyResponse createPolicy(CreatePolicyRequest createPolicyRequest) throws ResourceAlreadyExistsException,
            MalformedPolicyException, InvalidRequestException, ThrottlingException, UnauthorizedException,
            ServiceUnavailableException, InternalFailureException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreatePolicyResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreatePolicyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreatePolicy");

            return clientHandler.execute(new ClientExecutionParams<CreatePolicyRequest, CreatePolicyResponse>()
                    .withOperationName("CreatePolicy").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createPolicyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreatePolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new version of the specified IoT policy. To update a policy, create a new policy version. A managed
     * policy can have up to five versions. If the policy has five versions, you must use <a>DeletePolicyVersion</a> to
     * delete an existing version before you create a new one.
     * </p>
     * <p>
     * Optionally, you can set the new version as the policy's default version. The default version is the operative
     * version (that is, the version that is in effect for the certificates to which the policy is attached).
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreatePolicyVersion</a> action.
     * </p>
     *
     * @param createPolicyVersionRequest
     *        The input for the CreatePolicyVersion operation.
     * @return Result of the CreatePolicyVersion operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws MalformedPolicyException
     *         The policy documentation is not valid.
     * @throws VersionsLimitExceededException
     *         The number of policy versions exceeds the limit.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreatePolicyVersion
     */
    @Override
    public CreatePolicyVersionResponse createPolicyVersion(CreatePolicyVersionRequest createPolicyVersionRequest)
            throws ResourceNotFoundException, MalformedPolicyException, VersionsLimitExceededException, InvalidRequestException,
            ThrottlingException, UnauthorizedException, ServiceUnavailableException, InternalFailureException,
            AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreatePolicyVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreatePolicyVersionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createPolicyVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createPolicyVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreatePolicyVersion");

            return clientHandler.execute(new ClientExecutionParams<CreatePolicyVersionRequest, CreatePolicyVersionResponse>()
                    .withOperationName("CreatePolicyVersion").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createPolicyVersionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreatePolicyVersionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a provisioning claim.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateProvisioningClaim</a> action.
     * </p>
     *
     * @param createProvisioningClaimRequest
     * @return Result of the CreateProvisioningClaim operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateProvisioningClaim
     */
    @Override
    public CreateProvisioningClaimResponse createProvisioningClaim(CreateProvisioningClaimRequest createProvisioningClaimRequest)
            throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, UnauthorizedException,
            ServiceUnavailableException, InternalFailureException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateProvisioningClaimResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateProvisioningClaimResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createProvisioningClaimRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createProvisioningClaimRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateProvisioningClaim");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateProvisioningClaimRequest, CreateProvisioningClaimResponse>()
                            .withOperationName("CreateProvisioningClaim").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createProvisioningClaimRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateProvisioningClaimRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a provisioning template.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateProvisioningTemplate</a> action.
     * </p>
     *
     * @param createProvisioningTemplateRequest
     * @return Result of the CreateProvisioningTemplate operation returned by the service.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateProvisioningTemplate
     */
    @Override
    public CreateProvisioningTemplateResponse createProvisioningTemplate(
            CreateProvisioningTemplateRequest createProvisioningTemplateRequest) throws InternalFailureException,
            InvalidRequestException, LimitExceededException, ThrottlingException, UnauthorizedException,
            ResourceAlreadyExistsException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateProvisioningTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateProvisioningTemplateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createProvisioningTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createProvisioningTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateProvisioningTemplate");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateProvisioningTemplateRequest, CreateProvisioningTemplateResponse>()
                            .withOperationName("CreateProvisioningTemplate").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createProvisioningTemplateRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateProvisioningTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new version of a provisioning template.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateProvisioningTemplateVersion</a> action.
     * </p>
     *
     * @param createProvisioningTemplateVersionRequest
     * @return Result of the CreateProvisioningTemplateVersion operation returned by the service.
     * @throws VersionsLimitExceededException
     *         The number of policy versions exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ConflictingResourceUpdateException
     *         A conflicting resource update exception. This exception is thrown when two pending updates cause a
     *         conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateProvisioningTemplateVersion
     */
    @Override
    public CreateProvisioningTemplateVersionResponse createProvisioningTemplateVersion(
            CreateProvisioningTemplateVersionRequest createProvisioningTemplateVersionRequest)
            throws VersionsLimitExceededException, InternalFailureException, InvalidRequestException, ThrottlingException,
            ResourceNotFoundException, UnauthorizedException, ConflictingResourceUpdateException, AwsServiceException,
            SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateProvisioningTemplateVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateProvisioningTemplateVersionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createProvisioningTemplateVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createProvisioningTemplateVersionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateProvisioningTemplateVersion");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateProvisioningTemplateVersionRequest, CreateProvisioningTemplateVersionResponse>()
                            .withOperationName("CreateProvisioningTemplateVersion").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createProvisioningTemplateVersionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateProvisioningTemplateVersionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a role alias.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateRoleAlias</a> action.
     * </p>
     *
     * @param createRoleAliasRequest
     * @return Result of the CreateRoleAlias operation returned by the service.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateRoleAlias
     */
    @Override
    public CreateRoleAliasResponse createRoleAlias(CreateRoleAliasRequest createRoleAliasRequest)
            throws ResourceAlreadyExistsException, InvalidRequestException, LimitExceededException, ThrottlingException,
            UnauthorizedException, ServiceUnavailableException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateRoleAliasResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateRoleAliasResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createRoleAliasRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createRoleAliasRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateRoleAlias");

            return clientHandler.execute(new ClientExecutionParams<CreateRoleAliasRequest, CreateRoleAliasResponse>()
                    .withOperationName("CreateRoleAlias").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createRoleAliasRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateRoleAliasRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a scheduled audit that is run at a specified time interval.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateScheduledAudit</a> action.
     * </p>
     *
     * @param createScheduledAuditRequest
     * @return Result of the CreateScheduledAudit operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateScheduledAudit
     */
    @Override
    public CreateScheduledAuditResponse createScheduledAudit(CreateScheduledAuditRequest createScheduledAuditRequest)
            throws InvalidRequestException, ResourceAlreadyExistsException, ThrottlingException, InternalFailureException,
            LimitExceededException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateScheduledAuditResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateScheduledAuditResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createScheduledAuditRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createScheduledAuditRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateScheduledAudit");

            return clientHandler.execute(new ClientExecutionParams<CreateScheduledAuditRequest, CreateScheduledAuditResponse>()
                    .withOperationName("CreateScheduledAudit").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createScheduledAuditRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateScheduledAuditRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a Device Defender security profile.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateSecurityProfile</a> action.
     * </p>
     *
     * @param createSecurityProfileRequest
     * @return Result of the CreateSecurityProfile operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateSecurityProfile
     */
    @Override
    public CreateSecurityProfileResponse createSecurityProfile(CreateSecurityProfileRequest createSecurityProfileRequest)
            throws InvalidRequestException, ResourceAlreadyExistsException, ThrottlingException, InternalFailureException,
            AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateSecurityProfileResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateSecurityProfileResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createSecurityProfileRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createSecurityProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateSecurityProfile");

            return clientHandler.execute(new ClientExecutionParams<CreateSecurityProfileRequest, CreateSecurityProfileResponse>()
                    .withOperationName("CreateSecurityProfile").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createSecurityProfileRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateSecurityProfileRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a stream for delivering one or more large files in chunks over MQTT. A stream transports data bytes in
     * chunks or blocks packaged as MQTT messages from a source like S3. You can have one or more files associated with
     * a stream.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateStream</a> action.
     * </p>
     *
     * @param createStreamRequest
     * @return Result of the CreateStream operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateStream
     */
    @Override
    public CreateStreamResponse createStream(CreateStreamRequest createStreamRequest) throws InvalidRequestException,
            LimitExceededException, ResourceNotFoundException, ResourceAlreadyExistsException, ThrottlingException,
            UnauthorizedException, ServiceUnavailableException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateStreamResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateStreamResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createStreamRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createStreamRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateStream");

            return clientHandler.execute(new ClientExecutionParams<CreateStreamRequest, CreateStreamResponse>()
                    .withOperationName("CreateStream").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createStreamRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateStreamRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a thing record in the registry. If this call is made multiple times using the same thing name and
     * configuration, the call will succeed. If this call is made with the same thing name but different configuration a
     * <code>ResourceAlreadyExistsException</code> is thrown.
     * </p>
     * <note>
     * <p>
     * This is a control plane operation. See <a
     * href="https://docs.aws.amazon.com/iot/latest/developerguide/iot-authorization.html">Authorization</a> for
     * information about authorizing control plane actions.
     * </p>
     * </note>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateThing</a> action.
     * </p>
     *
     * @param createThingRequest
     *        The input for the CreateThing operation.
     * @return Result of the CreateThing operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateThing
     */
    @Override
    public CreateThingResponse createThing(CreateThingRequest createThingRequest) throws InvalidRequestException,
            ThrottlingException, UnauthorizedException, ServiceUnavailableException, InternalFailureException,
            ResourceAlreadyExistsException, ResourceNotFoundException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateThingResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateThingResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createThingRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createThingRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateThing");

            return clientHandler.execute(new ClientExecutionParams<CreateThingRequest, CreateThingResponse>()
                    .withOperationName("CreateThing").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(createThingRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateThingRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Create a thing group.
     * </p>
     * <note>
     * <p>
     * This is a control plane operation. See <a
     * href="https://docs.aws.amazon.com/iot/latest/developerguide/iot-authorization.html">Authorization</a> for
     * information about authorizing control plane actions.
     * </p>
     * </note>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateThingGroup</a> action.
     * </p>
     *
     * @param createThingGroupRequest
     * @return Result of the CreateThingGroup operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateThingGroup
     */
    @Override
    public CreateThingGroupResponse createThingGroup(CreateThingGroupRequest createThingGroupRequest)
            throws InvalidRequestException, ResourceAlreadyExistsException, ThrottlingException, InternalFailureException,
            AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateThingGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateThingGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createThingGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createThingGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateThingGroup");

            return clientHandler.execute(new ClientExecutionParams<CreateThingGroupRequest, CreateThingGroupResponse>()
                    .withOperationName("CreateThingGroup").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createThingGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateThingGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new thing type.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateThingType</a> action.
     * </p>
     *
     * @param createThingTypeRequest
     *        The input for the CreateThingType operation.
     * @return Result of the CreateThingType operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateThingType
     */
    @Override
    public CreateThingTypeResponse createThingType(CreateThingTypeRequest createThingTypeRequest) throws InvalidRequestException,
            ThrottlingException, UnauthorizedException, ServiceUnavailableException, InternalFailureException,
            ResourceAlreadyExistsException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateThingTypeResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateThingTypeResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createThingTypeRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createThingTypeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateThingType");

            return clientHandler.execute(new ClientExecutionParams<CreateThingTypeRequest, CreateThingTypeResponse>()
                    .withOperationName("CreateThingType").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createThingTypeRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateThingTypeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a rule. Creating rules is an administrator-level action. Any user who has permission to create rules will
     * be able to access data processed by the rule.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateTopicRule</a> action.
     * </p>
     *
     * @param createTopicRuleRequest
     *        The input for the CreateTopicRule operation.
     * @return Result of the CreateTopicRule operation returned by the service.
     * @throws SqlParseException
     *         The Rule-SQL expression can't be parsed correctly.
     * @throws InternalException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ConflictingResourceUpdateException
     *         A conflicting resource update exception. This exception is thrown when two pending updates cause a
     *         conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateTopicRule
     */
    @Override
    public CreateTopicRuleResponse createTopicRule(CreateTopicRuleRequest createTopicRuleRequest) throws SqlParseException,
            InternalException, InvalidRequestException, ResourceAlreadyExistsException, ServiceUnavailableException,
            ConflictingResourceUpdateException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateTopicRuleResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateTopicRuleResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createTopicRuleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createTopicRuleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTopicRule");

            return clientHandler.execute(new ClientExecutionParams<CreateTopicRuleRequest, CreateTopicRuleResponse>()
                    .withOperationName("CreateTopicRule").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createTopicRuleRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateTopicRuleRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a topic rule destination. The destination must be confirmed prior to use.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateTopicRuleDestination</a> action.
     * </p>
     *
     * @param createTopicRuleDestinationRequest
     * @return Result of the CreateTopicRuleDestination operation returned by the service.
     * @throws InternalException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ConflictingResourceUpdateException
     *         A conflicting resource update exception. This exception is thrown when two pending updates cause a
     *         conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateTopicRuleDestination
     */
    @Override
    public CreateTopicRuleDestinationResponse createTopicRuleDestination(
            CreateTopicRuleDestinationRequest createTopicRuleDestinationRequest) throws InternalException,
            InvalidRequestException, ResourceAlreadyExistsException, ServiceUnavailableException,
            ConflictingResourceUpdateException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateTopicRuleDestinationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateTopicRuleDestinationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createTopicRuleDestinationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createTopicRuleDestinationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTopicRuleDestination");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateTopicRuleDestinationRequest, CreateTopicRuleDestinationResponse>()
                            .withOperationName("CreateTopicRuleDestination").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createTopicRuleDestinationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateTopicRuleDestinationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Restores the default settings for Device Defender audits for this account. Any configuration data you entered is
     * deleted and all audit checks are reset to disabled.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteAccountAuditConfiguration</a> action.
     * </p>
     *
     * @param deleteAccountAuditConfigurationRequest
     * @return Result of the DeleteAccountAuditConfiguration operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteAccountAuditConfiguration
     */
    @Override
    public DeleteAccountAuditConfigurationResponse deleteAccountAuditConfiguration(
            DeleteAccountAuditConfigurationRequest deleteAccountAuditConfigurationRequest) throws InvalidRequestException,
            ResourceNotFoundException, ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException,
            IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteAccountAuditConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteAccountAuditConfigurationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAccountAuditConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteAccountAuditConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAccountAuditConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteAccountAuditConfigurationRequest, DeleteAccountAuditConfigurationResponse>()
                            .withOperationName("DeleteAccountAuditConfiguration").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteAccountAuditConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteAccountAuditConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a Device Defender audit suppression.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteAuditSuppression</a> action.
     * </p>
     *
     * @param deleteAuditSuppressionRequest
     * @return Result of the DeleteAuditSuppression operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteAuditSuppression
     */
    @Override
    public DeleteAuditSuppressionResponse deleteAuditSuppression(DeleteAuditSuppressionRequest deleteAuditSuppressionRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteAuditSuppressionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteAuditSuppressionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAuditSuppressionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAuditSuppressionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAuditSuppression");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteAuditSuppressionRequest, DeleteAuditSuppressionResponse>()
                            .withOperationName("DeleteAuditSuppression").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteAuditSuppressionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteAuditSuppressionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an authorizer.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteAuthorizer</a> action.
     * </p>
     *
     * @param deleteAuthorizerRequest
     * @return Result of the DeleteAuthorizer operation returned by the service.
     * @throws DeleteConflictException
     *         You can't delete the resource because it is attached to one or more resources.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteAuthorizer
     */
    @Override
    public DeleteAuthorizerResponse deleteAuthorizer(DeleteAuthorizerRequest deleteAuthorizerRequest)
            throws DeleteConflictException, ResourceNotFoundException, InvalidRequestException, ThrottlingException,
            UnauthorizedException, ServiceUnavailableException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteAuthorizerResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteAuthorizerResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAuthorizerRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAuthorizerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAuthorizer");

            return clientHandler.execute(new ClientExecutionParams<DeleteAuthorizerRequest, DeleteAuthorizerResponse>()
                    .withOperationName("DeleteAuthorizer").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteAuthorizerRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteAuthorizerRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the billing group.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteBillingGroup</a> action.
     * </p>
     *
     * @param deleteBillingGroupRequest
     * @return Result of the DeleteBillingGroup operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws VersionConflictException
     *         An exception thrown when the version of an entity specified with the <code>expectedVersion</code>
     *         parameter does not match the latest version in the system.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteBillingGroup
     */
    @Override
    public DeleteBillingGroupResponse deleteBillingGroup(DeleteBillingGroupRequest deleteBillingGroupRequest)
            throws InvalidRequestException, VersionConflictException, ThrottlingException, InternalFailureException,
            AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteBillingGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteBillingGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteBillingGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteBillingGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteBillingGroup");

            return clientHandler.execute(new ClientExecutionParams<DeleteBillingGroupRequest, DeleteBillingGroupResponse>()
                    .withOperationName("DeleteBillingGroup").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteBillingGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteBillingGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a registered CA certificate.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteCACertificate</a> action.
     * </p>
     *
     * @param deleteCaCertificateRequest
     *        Input for the DeleteCACertificate operation.
     * @return Result of the DeleteCACertificate operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws CertificateStateException
     *         The certificate operation is not allowed.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteCACertificate
     */
    @Override
    public DeleteCaCertificateResponse deleteCACertificate(DeleteCaCertificateRequest deleteCaCertificateRequest)
            throws InvalidRequestException, CertificateStateException, ThrottlingException, UnauthorizedException,
            ServiceUnavailableException, InternalFailureException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteCaCertificateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteCaCertificateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteCaCertificateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteCaCertificateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCACertificate");

            return clientHandler.execute(new ClientExecutionParams<DeleteCaCertificateRequest, DeleteCaCertificateResponse>()
                    .withOperationName("DeleteCACertificate").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteCaCertificateRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteCaCertificateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified certificate.
     * </p>
     * <p>
     * A certificate cannot be deleted if it has a policy or IoT thing attached to it or if its status is set to ACTIVE.
     * To delete a certificate, first use the <a>DetachPolicy</a> action to detach all policies. Next, use the
     * <a>UpdateCertificate</a> action to set the certificate to the INACTIVE status.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteCertificate</a> action.
     * </p>
     *
     * @param deleteCertificateRequest
     *        The input for the DeleteCertificate operation.
     * @return Result of the DeleteCertificate operation returned by the service.
     * @throws CertificateStateException
     *         The certificate operation is not allowed.
     * @throws DeleteConflictException
     *         You can't delete the resource because it is attached to one or more resources.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteCertificate
     */
    @Override
    public DeleteCertificateResponse deleteCertificate(DeleteCertificateRequest deleteCertificateRequest)
            throws CertificateStateException, DeleteConflictException, InvalidRequestException, ThrottlingException,
            UnauthorizedException, ServiceUnavailableException, InternalFailureException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteCertificateResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteCertificateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteCertificateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteCertificateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCertificate");

            return clientHandler.execute(new ClientExecutionParams<DeleteCertificateRequest, DeleteCertificateResponse>()
                    .withOperationName("DeleteCertificate").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteCertificateRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteCertificateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a Device Defender detect custom metric.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteCustomMetric</a> action.
     * </p>
     * <note>
     * <p>
     * Before you can delete a custom metric, you must first remove the custom metric from all security profiles it's a
     * part of. The security profile associated with the custom metric can be found using the <a
     * href="https://docs.aws.amazon.com/iot/latest/apireference/API_ListSecurityProfiles.html">ListSecurityProfiles</a>
     * API with <code>metricName</code> set to your custom metric name.
     * </p>
     * </note>
     *
     * @param deleteCustomMetricRequest
     * @return Result of the DeleteCustomMetric operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteCustomMetric
     */
    @Override
    public DeleteCustomMetricResponse deleteCustomMetric(DeleteCustomMetricRequest deleteCustomMetricRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteCustomMetricResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteCustomMetricResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteCustomMetricRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteCustomMetricRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCustomMetric");

            return clientHandler.execute(new ClientExecutionParams<DeleteCustomMetricRequest, DeleteCustomMetricResponse>()
                    .withOperationName("DeleteCustomMetric").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteCustomMetricRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteCustomMetricRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes the specified dimension from your Amazon Web Services accounts.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteDimension</a> action.
     * </p>
     *
     * @param deleteDimensionRequest
     * @return Result of the DeleteDimension operation returned by the service.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteDimension
     */
    @Override
    public DeleteDimensionResponse deleteDimension(DeleteDimensionRequest deleteDimensionRequest)
            throws InternalFailureException, InvalidRequestException, ThrottlingException, AwsServiceException,
            SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteDimensionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteDimensionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteDimensionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDimensionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDimension");

            return clientHandler.execute(new ClientExecutionParams<DeleteDimensionRequest, DeleteDimensionResponse>()
                    .withOperationName("DeleteDimension").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteDimensionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteDimensionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified domain configuration.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteDomainConfiguration</a> action.
     * </p>
     *
     * @param deleteDomainConfigurationRequest
     * @return Result of the DeleteDomainConfiguration operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteDomainConfiguration
     */
    @Override
    public DeleteDomainConfigurationResponse deleteDomainConfiguration(
            DeleteDomainConfigurationRequest deleteDomainConfigurationRequest) throws ResourceNotFoundException,
            ThrottlingException, UnauthorizedException, ServiceUnavailableException, InternalFailureException,
            InvalidRequestException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteDomainConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteDomainConfigurationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteDomainConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDomainConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDomainConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteDomainConfigurationRequest, DeleteDomainConfigurationResponse>()
                            .withOperationName("DeleteDomainConfiguration").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteDomainConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteDomainConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a dynamic thing group.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteDynamicThingGroup</a> action.
     * </p>
     *
     * @param deleteDynamicThingGroupRequest
     * @return Result of the DeleteDynamicThingGroup operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws VersionConflictException
     *         An exception thrown when the version of an entity specified with the <code>expectedVersion</code>
     *         parameter does not match the latest version in the system.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteDynamicThingGroup
     */
    @Override
    public DeleteDynamicThingGroupResponse deleteDynamicThingGroup(DeleteDynamicThingGroupRequest deleteDynamicThingGroupRequest)
            throws InvalidRequestException, VersionConflictException, ThrottlingException, InternalFailureException,
            AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteDynamicThingGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteDynamicThingGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteDynamicThingGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDynamicThingGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDynamicThingGroup");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteDynamicThingGroupRequest, DeleteDynamicThingGroupResponse>()
                            .withOperationName("DeleteDynamicThingGroup").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteDynamicThingGroupRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteDynamicThingGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified fleet metric. Returns successfully with no error if the deletion is successful or you
     * specify a fleet metric that doesn't exist.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteFleetMetric</a> action.
     * </p>
     *
     * @param deleteFleetMetricRequest
     * @return Result of the DeleteFleetMetric operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws VersionConflictException
     *         An exception thrown when the version of an entity specified with the <code>expectedVersion</code>
     *         parameter does not match the latest version in the system.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteFleetMetric
     */
    @Override
    public DeleteFleetMetricResponse deleteFleetMetric(DeleteFleetMetricRequest deleteFleetMetricRequest)
            throws InvalidRequestException, ThrottlingException, UnauthorizedException, ServiceUnavailableException,
            InternalFailureException, VersionConflictException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteFleetMetricResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteFleetMetricResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteFleetMetricRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteFleetMetricRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteFleetMetric");

            return clientHandler.execute(new ClientExecutionParams<DeleteFleetMetricRequest, DeleteFleetMetricResponse>()
                    .withOperationName("DeleteFleetMetric").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteFleetMetricRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteFleetMetricRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a job and its related job executions.
     * </p>
     * <p>
     * Deleting a job may take time, depending on the number of job executions created for the job and various other
     * factors. While the job is being deleted, the status of the job will be shown as "DELETION_IN_PROGRESS".
     * Attempting to delete or cancel a job whose status is already "DELETION_IN_PROGRESS" will result in an error.
     * </p>
     * <p>
     * Only 10 jobs may have status "DELETION_IN_PROGRESS" at the same time, or a LimitExceededException will occur.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteJob</a> action.
     * </p>
     *
     * @param deleteJobRequest
     * @return Result of the DeleteJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidStateTransitionException
     *         An attempt was made to change to an invalid state, for example by deleting a job or a job execution which
     *         is "IN_PROGRESS" without setting the <code>force</code> parameter.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteJob
     */
    @Override
    public DeleteJobResponse deleteJob(DeleteJobRequest deleteJobRequest) throws InvalidRequestException,
            InvalidStateTransitionException, ResourceNotFoundException, LimitExceededException, ThrottlingException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteJobResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteJob");

            return clientHandler.execute(new ClientExecutionParams<DeleteJobRequest, DeleteJobResponse>()
                    .withOperationName("DeleteJob").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteJobRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a job execution.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteJobExecution</a> action.
     * </p>
     *
     * @param deleteJobExecutionRequest
     * @return Result of the DeleteJobExecution operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidStateTransitionException
     *         An attempt was made to change to an invalid state, for example by deleting a job or a job execution which
     *         is "IN_PROGRESS" without setting the <code>force</code> parameter.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteJobExecution
     */
    @Override
    public DeleteJobExecutionResponse deleteJobExecution(DeleteJobExecutionRequest deleteJobExecutionRequest)
            throws InvalidRequestException, InvalidStateTransitionException, ResourceNotFoundException, ThrottlingException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteJobExecutionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteJobExecutionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteJobExecutionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteJobExecutionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteJobExecution");

            return clientHandler.execute(new ClientExecutionParams<DeleteJobExecutionRequest, DeleteJobExecutionResponse>()
                    .withOperationName("DeleteJobExecution").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteJobExecutionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteJobExecutionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified job template.
     * </p>
     *
     * @param deleteJobTemplateRequest
     * @return Result of the DeleteJobTemplate operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteJobTemplate
     */
    @Override
    public DeleteJobTemplateResponse deleteJobTemplate(DeleteJobTemplateRequest deleteJobTemplateRequest)
            throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, InternalFailureException,
            AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteJobTemplateResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteJobTemplateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteJobTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteJobTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteJobTemplate");

            return clientHandler.execute(new ClientExecutionParams<DeleteJobTemplateRequest, DeleteJobTemplateResponse>()
                    .withOperationName("DeleteJobTemplate").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteJobTemplateRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteJobTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a defined mitigation action from your Amazon Web Services accounts.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteMitigationAction</a> action.
     * </p>
     *
     * @param deleteMitigationActionRequest
     * @return Result of the DeleteMitigationAction operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteMitigationAction
     */
    @Override
    public DeleteMitigationActionResponse deleteMitigationAction(DeleteMitigationActionRequest deleteMitigationActionRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteMitigationActionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteMitigationActionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteMitigationActionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteMitigationActionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteMitigationAction");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteMitigationActionRequest, DeleteMitigationActionResponse>()
                            .withOperationName("DeleteMitigationAction").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteMitigationActionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteMitigationActionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Delete an OTA update.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteOTAUpdate</a> action.
     * </p>
     *
     * @param deleteOtaUpdateRequest
     * @return Result of the DeleteOTAUpdate operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws VersionConflictException
     *         An exception thrown when the version of an entity specified with the <code>expectedVersion</code>
     *         parameter does not match the latest version in the system.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteOTAUpdate
     */
    @Override
    public DeleteOtaUpdateResponse deleteOTAUpdate(DeleteOtaUpdateRequest deleteOtaUpdateRequest) throws InvalidRequestException,
            ResourceNotFoundException, ThrottlingException, UnauthorizedException, InternalFailureException,
            ServiceUnavailableException, VersionConflictException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteOtaUpdateResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteOtaUpdateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteOtaUpdateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteOtaUpdateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteOTAUpdate");

            return clientHandler.execute(new ClientExecutionParams<DeleteOtaUpdateRequest, DeleteOtaUpdateResponse>()
                    .withOperationName("DeleteOTAUpdate").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteOtaUpdateRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteOtaUpdateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a specific version from a software package.
     * </p>
     * <p>
     * <b>Note:</b> All package versions must be deleted before deleting the software package.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeletePackageVersion</a> action.
     * </p>
     *
     * @param deletePackageRequest
     * @return Result of the DeletePackage operation returned by the service.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ValidationException
     *         The request is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeletePackage
     */
    @Override
    public DeletePackageResponse deletePackage(DeletePackageRequest deletePackageRequest) throws ThrottlingException,
            InternalServerException, ValidationException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeletePackageResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeletePackageResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deletePackageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deletePackageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeletePackage");

            return clientHandler.execute(new ClientExecutionParams<DeletePackageRequest, DeletePackageResponse>()
                    .withOperationName("DeletePackage").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deletePackageRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeletePackageRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a specific version from a software package.
     * </p>
     * <p>
     * <b>Note:</b> If a package version is designated as default, you must remove the designation from the software
     * package using the <a>UpdatePackage</a> action.
     * </p>
     *
     * @param deletePackageVersionRequest
     * @return Result of the DeletePackageVersion operation returned by the service.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ValidationException
     *         The request is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeletePackageVersion
     */
    @Override
    public DeletePackageVersionResponse deletePackageVersion(DeletePackageVersionRequest deletePackageVersionRequest)
            throws ThrottlingException, InternalServerException, ValidationException, AwsServiceException, SdkClientException,
            IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeletePackageVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeletePackageVersionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deletePackageVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deletePackageVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeletePackageVersion");

            return clientHandler.execute(new ClientExecutionParams<DeletePackageVersionRequest, DeletePackageVersionResponse>()
                    .withOperationName("DeletePackageVersion").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deletePackageVersionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeletePackageVersionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified policy.
     * </p>
     * <p>
     * A policy cannot be deleted if it has non-default versions or it is attached to any certificate.
     * </p>
     * <p>
     * To delete a policy, use the <a>DeletePolicyVersion</a> action to delete all non-default versions of the policy;
     * use the <a>DetachPolicy</a> action to detach the policy from any certificate; and then use the DeletePolicy
     * action to delete the policy.
     * </p>
     * <p>
     * When a policy is deleted using DeletePolicy, its default version is deleted with it.
     * </p>
     * <note>
     * <p>
     * Because of the distributed nature of Amazon Web Services, it can take up to five minutes after a policy is
     * detached before it's ready to be deleted.
     * </p>
     * </note>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeletePolicy</a> action.
     * </p>
     *
     * @param deletePolicyRequest
     *        The input for the DeletePolicy operation.
     * @return Result of the DeletePolicy operation returned by the service.
     * @throws DeleteConflictException
     *         You can't delete the resource because it is attached to one or more resources.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeletePolicy
     */
    @Override
    public DeletePolicyResponse deletePolicy(DeletePolicyRequest deletePolicyRequest) throws DeleteConflictException,
            ResourceNotFoundException, InvalidRequestException, ThrottlingException, UnauthorizedException,
            ServiceUnavailableException, InternalFailureException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeletePolicyResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeletePolicyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deletePolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deletePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeletePolicy");

            return clientHandler.execute(new ClientExecutionParams<DeletePolicyRequest, DeletePolicyResponse>()
                    .withOperationName("DeletePolicy").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deletePolicyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeletePolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified version of the specified policy. You cannot delete the default version of a policy using
     * this action. To delete the default version of a policy, use <a>DeletePolicy</a>. To find out which version of a
     * policy is marked as the default version, use ListPolicyVersions.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeletePolicyVersion</a> action.
     * </p>
     *
     * @param deletePolicyVersionRequest
     *        The input for the DeletePolicyVersion operation.
     * @return Result of the DeletePolicyVersion operation returned by the service.
     * @throws DeleteConflictException
     *         You can't delete the resource because it is attached to one or more resources.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeletePolicyVersion
     */
    @Override
    public DeletePolicyVersionResponse deletePolicyVersion(DeletePolicyVersionRequest deletePolicyVersionRequest)
            throws DeleteConflictException, ResourceNotFoundException, InvalidRequestException, ThrottlingException,
            UnauthorizedException, ServiceUnavailableException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeletePolicyVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeletePolicyVersionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deletePolicyVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deletePolicyVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeletePolicyVersion");

            return clientHandler.execute(new ClientExecutionParams<DeletePolicyVersionRequest, DeletePolicyVersionResponse>()
                    .withOperationName("DeletePolicyVersion").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deletePolicyVersionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeletePolicyVersionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a provisioning template.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteProvisioningTemplate</a> action.
     * </p>
     *
     * @param deleteProvisioningTemplateRequest
     * @return Result of the DeleteProvisioningTemplate operation returned by the service.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws DeleteConflictException
     *         You can't delete the resource because it is attached to one or more resources.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ConflictingResourceUpdateException
     *         A conflicting resource update exception. This exception is thrown when two pending updates cause a
     *         conflict.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteProvisioningTemplate
     */
    @Override
    public DeleteProvisioningTemplateResponse deleteProvisioningTemplate(
            DeleteProvisioningTemplateRequest deleteProvisioningTemplateRequest) throws InternalFailureException,
            InvalidRequestException, ResourceNotFoundException, DeleteConflictException, ThrottlingException,
            ConflictingResourceUpdateException, UnauthorizedException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteProvisioningTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteProvisioningTemplateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteProvisioningTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteProvisioningTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteProvisioningTemplate");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteProvisioningTemplateRequest, DeleteProvisioningTemplateResponse>()
                            .withOperationName("DeleteProvisioningTemplate").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteProvisioningTemplateRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteProvisioningTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a provisioning template version.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteProvisioningTemplateVersion</a> action.
     * </p>
     *
     * @param deleteProvisioningTemplateVersionRequest
     * @return Result of the DeleteProvisioningTemplateVersion operation returned by the service.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ConflictingResourceUpdateException
     *         A conflicting resource update exception. This exception is thrown when two pending updates cause a
     *         conflict.
     * @throws DeleteConflictException
     *         You can't delete the resource because it is attached to one or more resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteProvisioningTemplateVersion
     */
    @Override
    public DeleteProvisioningTemplateVersionResponse deleteProvisioningTemplateVersion(
            DeleteProvisioningTemplateVersionRequest deleteProvisioningTemplateVersionRequest) throws InternalFailureException,
            InvalidRequestException, ThrottlingException, ResourceNotFoundException, UnauthorizedException,
            ConflictingResourceUpdateException, DeleteConflictException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteProvisioningTemplateVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteProvisioningTemplateVersionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteProvisioningTemplateVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteProvisioningTemplateVersionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteProvisioningTemplateVersion");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteProvisioningTemplateVersionRequest, DeleteProvisioningTemplateVersionResponse>()
                            .withOperationName("DeleteProvisioningTemplateVersion").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteProvisioningTemplateVersionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteProvisioningTemplateVersionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a CA certificate registration code.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteRegistrationCode</a> action.
     * </p>
     *
     * @param deleteRegistrationCodeRequest
     *        The input for the DeleteRegistrationCode operation.
     * @return Result of the DeleteRegistrationCode operation returned by the service.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteRegistrationCode
     */
    @Override
    public DeleteRegistrationCodeResponse deleteRegistrationCode(DeleteRegistrationCodeRequest deleteRegistrationCodeRequest)
            throws ThrottlingException, ResourceNotFoundException, UnauthorizedException, ServiceUnavailableException,
            InternalFailureException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteRegistrationCodeResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteRegistrationCodeResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteRegistrationCodeRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteRegistrationCodeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteRegistrationCode");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteRegistrationCodeRequest, DeleteRegistrationCodeResponse>()
                            .withOperationName("DeleteRegistrationCode").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteRegistrationCodeRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteRegistrationCodeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a role alias
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteRoleAlias</a> action.
     * </p>
     *
     * @param deleteRoleAliasRequest
     * @return Result of the DeleteRoleAlias operation returned by the service.
     * @throws DeleteConflictException
     *         You can't delete the resource because it is attached to one or more resources.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteRoleAlias
     */
    @Override
    public DeleteRoleAliasResponse deleteRoleAlias(DeleteRoleAliasRequest deleteRoleAliasRequest) throws DeleteConflictException,
            InvalidRequestException, ThrottlingException, UnauthorizedException, ServiceUnavailableException,
            InternalFailureException, ResourceNotFoundException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteRoleAliasResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteRoleAliasResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteRoleAliasRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteRoleAliasRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteRoleAlias");

            return clientHandler.execute(new ClientExecutionParams<DeleteRoleAliasRequest, DeleteRoleAliasResponse>()
                    .withOperationName("DeleteRoleAlias").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteRoleAliasRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteRoleAliasRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a scheduled audit.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteScheduledAudit</a> action.
     * </p>
     *
     * @param deleteScheduledAuditRequest
     * @return Result of the DeleteScheduledAudit operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteScheduledAudit
     */
    @Override
    public DeleteScheduledAuditResponse deleteScheduledAudit(DeleteScheduledAuditRequest deleteScheduledAuditRequest)
            throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, InternalFailureException,
            AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteScheduledAuditResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteScheduledAuditResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteScheduledAuditRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteScheduledAuditRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteScheduledAudit");

            return clientHandler.execute(new ClientExecutionParams<DeleteScheduledAuditRequest, DeleteScheduledAuditResponse>()
                    .withOperationName("DeleteScheduledAudit").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteScheduledAuditRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteScheduledAuditRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a Device Defender security profile.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteSecurityProfile</a> action.
     * </p>
     *
     * @param deleteSecurityProfileRequest
     * @return Result of the DeleteSecurityProfile operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws VersionConflictException
     *         An exception thrown when the version of an entity specified with the <code>expectedVersion</code>
     *         parameter does not match the latest version in the system.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteSecurityProfile
     */
    @Override
    public DeleteSecurityProfileResponse deleteSecurityProfile(DeleteSecurityProfileRequest deleteSecurityProfileRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, VersionConflictException,
            AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteSecurityProfileResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteSecurityProfileResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteSecurityProfileRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteSecurityProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteSecurityProfile");

            return clientHandler.execute(new ClientExecutionParams<DeleteSecurityProfileRequest, DeleteSecurityProfileResponse>()
                    .withOperationName("DeleteSecurityProfile").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteSecurityProfileRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteSecurityProfileRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a stream.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteStream</a> action.
     * </p>
     *
     * @param deleteStreamRequest
     * @return Result of the DeleteStream operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws DeleteConflictException
     *         You can't delete the resource because it is attached to one or more resources.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteStream
     */
    @Override
    public DeleteStreamResponse deleteStream(DeleteStreamRequest deleteStreamRequest) throws ResourceNotFoundException,
            DeleteConflictException, InvalidRequestException, ThrottlingException, UnauthorizedException,
            ServiceUnavailableException, InternalFailureException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteStreamResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteStreamResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteStreamRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteStreamRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteStream");

            return clientHandler.execute(new ClientExecutionParams<DeleteStreamRequest, DeleteStreamResponse>()
                    .withOperationName("DeleteStream").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteStreamRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteStreamRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified thing. Returns successfully with no error if the deletion is successful or you specify a
     * thing that doesn't exist.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteThing</a> action.
     * </p>
     *
     * @param deleteThingRequest
     *        The input for the DeleteThing operation.
     * @return Result of the DeleteThing operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws VersionConflictException
     *         An exception thrown when the version of an entity specified with the <code>expectedVersion</code>
     *         parameter does not match the latest version in the system.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteThing
     */
    @Override
    public DeleteThingResponse deleteThing(DeleteThingRequest deleteThingRequest) throws ResourceNotFoundException,
            VersionConflictException, InvalidRequestException, ThrottlingException, UnauthorizedException,
            ServiceUnavailableException, InternalFailureException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteThingResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteThingResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteThingRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteThingRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteThing");

            return clientHandler.execute(new ClientExecutionParams<DeleteThingRequest, DeleteThingResponse>()
                    .withOperationName("DeleteThing").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteThingRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteThingRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a thing group.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteThingGroup</a> action.
     * </p>
     *
     * @param deleteThingGroupRequest
     * @return Result of the DeleteThingGroup operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws VersionConflictException
     *         An exception thrown when the version of an entity specified with the <code>expectedVersion</code>
     *         parameter does not match the latest version in the system.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteThingGroup
     */
    @Override
    public DeleteThingGroupResponse deleteThingGroup(DeleteThingGroupRequest deleteThingGroupRequest)
            throws InvalidRequestException, VersionConflictException, ThrottlingException, InternalFailureException,
            AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteThingGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteThingGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteThingGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteThingGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteThingGroup");

            return clientHandler.execute(new ClientExecutionParams<DeleteThingGroupRequest, DeleteThingGroupResponse>()
                    .withOperationName("DeleteThingGroup").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteThingGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteThingGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified thing type. You cannot delete a thing type if it has things associated with it. To delete a
     * thing type, first mark it as deprecated by calling <a>DeprecateThingType</a>, then remove any associated things
     * by calling <a>UpdateThing</a> to change the thing type on any associated thing, and finally use
     * <a>DeleteThingType</a> to delete the thing type.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteThingType</a> action.
     * </p>
     *
     * @param deleteThingTypeRequest
     *        The input for the DeleteThingType operation.
     * @return Result of the DeleteThingType operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteThingType
     */
    @Override
    public DeleteThingTypeResponse deleteThingType(DeleteThingTypeRequest deleteThingTypeRequest)
            throws ResourceNotFoundException, InvalidRequestException, ThrottlingException, UnauthorizedException,
            ServiceUnavailableException, InternalFailureException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteThingTypeResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteThingTypeResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteThingTypeRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteThingTypeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteThingType");

            return clientHandler.execute(new ClientExecutionParams<DeleteThingTypeRequest, DeleteThingTypeResponse>()
                    .withOperationName("DeleteThingType").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteThingTypeRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteThingTypeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the rule.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteTopicRule</a> action.
     * </p>
     *
     * @param deleteTopicRuleRequest
     *        The input for the DeleteTopicRule operation.
     * @return Result of the DeleteTopicRule operation returned by the service.
     * @throws InternalException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ConflictingResourceUpdateException
     *         A conflicting resource update exception. This exception is thrown when two pending updates cause a
     *         conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteTopicRule
     */
    @Override
    public DeleteTopicRuleResponse deleteTopicRule(DeleteTopicRuleRequest deleteTopicRuleRequest) throws InternalException,
            InvalidRequestException, ServiceUnavailableException, UnauthorizedException, ConflictingResourceUpdateException,
            AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteTopicRuleResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteTopicRuleResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteTopicRuleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteTopicRuleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTopicRule");

            return clientHandler.execute(new ClientExecutionParams<DeleteTopicRuleRequest, DeleteTopicRuleResponse>()
                    .withOperationName("DeleteTopicRule").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteTopicRuleRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteTopicRuleRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a topic rule destination.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteTopicRuleDestination</a> action.
     * </p>
     *
     * @param deleteTopicRuleDestinationRequest
     * @return Result of the DeleteTopicRuleDestination operation returned by the service.
     * @throws InternalException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ConflictingResourceUpdateException
     *         A conflicting resource update exception. This exception is thrown when two pending updates cause a
     *         conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteTopicRuleDestination
     */
    @Override
    public DeleteTopicRuleDestinationResponse deleteTopicRuleDestination(
            DeleteTopicRuleDestinationRequest deleteTopicRuleDestinationRequest) throws InternalException,
            InvalidRequestException, ServiceUnavailableException, UnauthorizedException, ConflictingResourceUpdateException,
            AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteTopicRuleDestinationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteTopicRuleDestinationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteTopicRuleDestinationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteTopicRuleDestinationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTopicRuleDestination");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteTopicRuleDestinationRequest, DeleteTopicRuleDestinationResponse>()
                            .withOperationName("DeleteTopicRuleDestination").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteTopicRuleDestinationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteTopicRuleDestinationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a logging level.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteV2LoggingLevel</a> action.
     * </p>
     *
     * @param deleteV2LoggingLevelRequest
     * @return Result of the DeleteV2LoggingLevel operation returned by the service.
     * @throws InternalException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteV2LoggingLevel
     */
    @Override
    public DeleteV2LoggingLevelResponse deleteV2LoggingLevel(DeleteV2LoggingLevelRequest deleteV2LoggingLevelRequest)
            throws InternalException, InvalidRequestException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteV2LoggingLevelResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteV2LoggingLevelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteV2LoggingLevelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteV2LoggingLevelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteV2LoggingLevel");

            return clientHandler.execute(new ClientExecutionParams<DeleteV2LoggingLevelRequest, DeleteV2LoggingLevelResponse>()
                    .withOperationName("DeleteV2LoggingLevel").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteV2LoggingLevelRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteV2LoggingLevelRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deprecates a thing type. You can not associate new things with deprecated thing type.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeprecateThingType</a> action.
     * </p>
     *
     * @param deprecateThingTypeRequest
     *        The input for the DeprecateThingType operation.
     * @return Result of the DeprecateThingType operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeprecateThingType
     */
    @Override
    public DeprecateThingTypeResponse deprecateThingType(DeprecateThingTypeRequest deprecateThingTypeRequest)
            throws ResourceNotFoundException, InvalidRequestException, ThrottlingException, UnauthorizedException,
            ServiceUnavailableException, InternalFailureException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeprecateThingTypeResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeprecateThingTypeResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deprecateThingTypeRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deprecateThingTypeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeprecateThingType");

            return clientHandler.execute(new ClientExecutionParams<DeprecateThingTypeRequest, DeprecateThingTypeResponse>()
                    .withOperationName("DeprecateThingType").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deprecateThingTypeRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeprecateThingTypeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about the Device Defender audit settings for this account. Settings include how audit
     * notifications are sent and which audit checks are enabled or disabled.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeAccountAuditConfiguration</a> action.
     * </p>
     *
     * @param describeAccountAuditConfigurationRequest
     * @return Result of the DescribeAccountAuditConfiguration operation returned by the service.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeAccountAuditConfiguration
     */
    @Override
    public DescribeAccountAuditConfigurationResponse describeAccountAuditConfiguration(
            DescribeAccountAuditConfigurationRequest describeAccountAuditConfigurationRequest) throws ThrottlingException,
            InternalFailureException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeAccountAuditConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeAccountAuditConfigurationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeAccountAuditConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeAccountAuditConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAccountAuditConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeAccountAuditConfigurationRequest, DescribeAccountAuditConfigurationResponse>()
                            .withOperationName("DescribeAccountAuditConfiguration").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeAccountAuditConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeAccountAuditConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about a single audit finding. Properties include the reason for noncompliance, the severity of
     * the issue, and the start time when the audit that returned the finding.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeAuditFinding</a> action.
     * </p>
     *
     * @param describeAuditFindingRequest
     * @return Result of the DescribeAuditFinding operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeAuditFinding
     */
    @Override
    public DescribeAuditFindingResponse describeAuditFinding(DescribeAuditFindingRequest describeAuditFindingRequest)
            throws ResourceNotFoundException, InvalidRequestException, ThrottlingException, InternalFailureException,
            AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeAuditFindingResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeAuditFindingResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeAuditFindingRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAuditFindingRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAuditFinding");

            return clientHandler.execute(new ClientExecutionParams<DescribeAuditFindingRequest, DescribeAuditFindingResponse>()
                    .withOperationName("DescribeAuditFinding").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeAuditFindingRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeAuditFindingRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about an audit mitigation task that is used to apply mitigation actions to a set of audit
     * findings. Properties include the actions being applied, the audit checks to which they're being applied, the task
     * status, and aggregated task statistics.
     * </p>
     *
     * @param describeAuditMitigationActionsTaskRequest
     * @return Result of the DescribeAuditMitigationActionsTask operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeAuditMitigationActionsTask
     */
    @Override
    public DescribeAuditMitigationActionsTaskResponse describeAuditMitigationActionsTask(
            DescribeAuditMitigationActionsTaskRequest describeAuditMitigationActionsTaskRequest) throws InvalidRequestException,
            ResourceNotFoundException, ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException,
            IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeAuditMitigationActionsTaskResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeAuditMitigationActionsTaskResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeAuditMitigationActionsTaskRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeAuditMitigationActionsTaskRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAuditMitigationActionsTask");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeAuditMitigationActionsTaskRequest, DescribeAuditMitigationActionsTaskResponse>()
                            .withOperationName("DescribeAuditMitigationActionsTask").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeAuditMitigationActionsTaskRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeAuditMitigationActionsTaskRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about a Device Defender audit suppression.
     * </p>
     *
     * @param describeAuditSuppressionRequest
     * @return Result of the DescribeAuditSuppression operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeAuditSuppression
     */
    @Override
    public DescribeAuditSuppressionResponse describeAuditSuppression(
            DescribeAuditSuppressionRequest describeAuditSuppressionRequest) throws InvalidRequestException,
            ResourceNotFoundException, ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException,
            IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeAuditSuppressionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeAuditSuppressionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeAuditSuppressionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAuditSuppressionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAuditSuppression");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeAuditSuppressionRequest, DescribeAuditSuppressionResponse>()
                            .withOperationName("DescribeAuditSuppression").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeAuditSuppressionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeAuditSuppressionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about a Device Defender audit.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeAuditTask</a> action.
     * </p>
     *
     * @param describeAuditTaskRequest
     * @return Result of the DescribeAuditTask operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeAuditTask
     */
    @Override
    public DescribeAuditTaskResponse describeAuditTask(DescribeAuditTaskRequest describeAuditTaskRequest)
            throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, InternalFailureException,
            AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeAuditTaskResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeAuditTaskResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeAuditTaskRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAuditTaskRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAuditTask");

            return clientHandler.execute(new ClientExecutionParams<DescribeAuditTaskRequest, DescribeAuditTaskResponse>()
                    .withOperationName("DescribeAuditTask").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeAuditTaskRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeAuditTaskRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes an authorizer.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeAuthorizer</a> action.
     * </p>
     *
     * @param describeAuthorizerRequest
     * @return Result of the DescribeAuthorizer operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeAuthorizer
     */
    @Override
    public DescribeAuthorizerResponse describeAuthorizer(DescribeAuthorizerRequest describeAuthorizerRequest)
            throws ResourceNotFoundException, InvalidRequestException, ThrottlingException, UnauthorizedException,
            ServiceUnavailableException, InternalFailureException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeAuthorizerResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeAuthorizerResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeAuthorizerRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAuthorizerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAuthorizer");

            return clientHandler.execute(new ClientExecutionParams<DescribeAuthorizerRequest, DescribeAuthorizerResponse>()
                    .withOperationName("DescribeAuthorizer").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeAuthorizerRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeAuthorizerRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about a billing group.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeBillingGroup</a> action.
     * </p>
     *
     * @param describeBillingGroupRequest
     * @return Result of the DescribeBillingGroup operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeBillingGroup
     */
    @Override
    public DescribeBillingGroupResponse describeBillingGroup(DescribeBillingGroupRequest describeBillingGroupRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeBillingGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeBillingGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeBillingGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeBillingGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeBillingGroup");

            return clientHandler.execute(new ClientExecutionParams<DescribeBillingGroupRequest, DescribeBillingGroupResponse>()
                    .withOperationName("DescribeBillingGroup").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeBillingGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeBillingGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes a registered CA certificate.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeCACertificate</a> action.
     * </p>
     *
     * @param describeCaCertificateRequest
     *        The input for the DescribeCACertificate operation.
     * @return Result of the DescribeCACertificate operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeCACertificate
     */
    @Override
    public DescribeCaCertificateResponse describeCACertificate(DescribeCaCertificateRequest describeCaCertificateRequest)
            throws InvalidRequestException, ThrottlingException, UnauthorizedException, ServiceUnavailableException,
            InternalFailureException, ResourceNotFoundException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeCaCertificateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeCaCertificateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeCaCertificateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeCaCertificateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeCACertificate");

            return clientHandler.execute(new ClientExecutionParams<DescribeCaCertificateRequest, DescribeCaCertificateResponse>()
                    .withOperationName("DescribeCACertificate").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeCaCertificateRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeCaCertificateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about the specified certificate.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeCertificate</a> action.
     * </p>
     *
     * @param describeCertificateRequest
     *        The input for the DescribeCertificate operation.
     * @return Result of the DescribeCertificate operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeCertificate
     */
    @Override
    public DescribeCertificateResponse describeCertificate(DescribeCertificateRequest describeCertificateRequest)
            throws InvalidRequestException, ThrottlingException, UnauthorizedException, ServiceUnavailableException,
            InternalFailureException, ResourceNotFoundException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeCertificateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeCertificateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeCertificateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeCertificateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeCertificate");

            return clientHandler.execute(new ClientExecutionParams<DescribeCertificateRequest, DescribeCertificateResponse>()
                    .withOperationName("DescribeCertificate").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeCertificateRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeCertificateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about a Device Defender detect custom metric.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeCustomMetric</a> action.
     * </p>
     *
     * @param describeCustomMetricRequest
     * @return Result of the DescribeCustomMetric operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeCustomMetric
     */
    @Override
    public DescribeCustomMetricResponse describeCustomMetric(DescribeCustomMetricRequest describeCustomMetricRequest)
            throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, InternalFailureException,
            AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeCustomMetricResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeCustomMetricResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeCustomMetricRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeCustomMetricRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeCustomMetric");

            return clientHandler.execute(new ClientExecutionParams<DescribeCustomMetricRequest, DescribeCustomMetricResponse>()
                    .withOperationName("DescribeCustomMetric").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeCustomMetricRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeCustomMetricRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the default authorizer.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeDefaultAuthorizer</a> action.
     * </p>
     *
     * @param describeDefaultAuthorizerRequest
     * @return Result of the DescribeDefaultAuthorizer operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeDefaultAuthorizer
     */
    @Override
    public DescribeDefaultAuthorizerResponse describeDefaultAuthorizer(
            DescribeDefaultAuthorizerRequest describeDefaultAuthorizerRequest) throws ResourceNotFoundException,
            InvalidRequestException, ThrottlingException, UnauthorizedException, ServiceUnavailableException,
            InternalFailureException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeDefaultAuthorizerResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeDefaultAuthorizerResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDefaultAuthorizerRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDefaultAuthorizerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDefaultAuthorizer");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeDefaultAuthorizerRequest, DescribeDefaultAuthorizerResponse>()
                            .withOperationName("DescribeDefaultAuthorizer").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeDefaultAuthorizerRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeDefaultAuthorizerRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about a Device Defender ML Detect mitigation action.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeDetectMitigationActionsTask</a> action.
     * </p>
     *
     * @param describeDetectMitigationActionsTaskRequest
     * @return Result of the DescribeDetectMitigationActionsTask operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeDetectMitigationActionsTask
     */
    @Override
    public DescribeDetectMitigationActionsTaskResponse describeDetectMitigationActionsTask(
            DescribeDetectMitigationActionsTaskRequest describeDetectMitigationActionsTaskRequest)
            throws ResourceNotFoundException, InvalidRequestException, ThrottlingException, InternalFailureException,
            AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeDetectMitigationActionsTaskResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeDetectMitigationActionsTaskResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDetectMitigationActionsTaskRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeDetectMitigationActionsTaskRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDetectMitigationActionsTask");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeDetectMitigationActionsTaskRequest, DescribeDetectMitigationActionsTaskResponse>()
                            .withOperationName("DescribeDetectMitigationActionsTask").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeDetectMitigationActionsTaskRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeDetectMitigationActionsTaskRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Provides details about a dimension that is defined in your Amazon Web Services accounts.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeDimension</a> action.
     * </p>
     *
     * @param describeDimensionRequest
     * @return Result of the DescribeDimension operation returned by the service.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeDimension
     */
    @Override
    public DescribeDimensionResponse describeDimension(DescribeDimensionRequest describeDimensionRequest)
            throws InternalFailureException, InvalidRequestException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeDimensionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeDimensionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDimensionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDimensionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDimension");

            return clientHandler.execute(new ClientExecutionParams<DescribeDimensionRequest, DescribeDimensionResponse>()
                    .withOperationName("DescribeDimension").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeDimensionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeDimensionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets summary information about a domain configuration.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeDomainConfiguration</a> action.
     * </p>
     *
     * @param describeDomainConfigurationRequest
     * @return Result of the DescribeDomainConfiguration operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeDomainConfiguration
     */
    @Override
    public DescribeDomainConfigurationResponse describeDomainConfiguration(
            DescribeDomainConfigurationRequest describeDomainConfigurationRequest) throws ResourceNotFoundException,
            ThrottlingException, InvalidRequestException, UnauthorizedException, ServiceUnavailableException,
            InternalFailureException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeDomainConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeDomainConfigurationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDomainConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDomainConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDomainConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeDomainConfigurationRequest, DescribeDomainConfigurationResponse>()
                            .withOperationName("DescribeDomainConfiguration").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeDomainConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeDomainConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a unique endpoint specific to the Amazon Web Services account making the call.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeEndpoint</a> action.
     * </p>
     *
     * @param describeEndpointRequest
     *        The input for the DescribeEndpoint operation.
     * @return Result of the DescribeEndpoint operation returned by the service.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeEndpoint
     */
    @Override
    public DescribeEndpointResponse describeEndpoint(DescribeEndpointRequest describeEndpointRequest)
            throws InternalFailureException, InvalidRequestException, UnauthorizedException, ThrottlingException,
            AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeEndpointResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeEndpointResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeEndpointRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeEndpointRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeEndpoint");

            return clientHandler.execute(new ClientExecutionParams<DescribeEndpointRequest, DescribeEndpointResponse>()
                    .withOperationName("DescribeEndpoint").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeEndpointRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeEndpointRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes event configurations.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeEventConfigurations</a> action.
     * </p>
     *
     * @param describeEventConfigurationsRequest
     * @return Result of the DescribeEventConfigurations operation returned by the service.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeEventConfigurations
     */
    @Override
    public DescribeEventConfigurationsResponse describeEventConfigurations(
            DescribeEventConfigurationsRequest describeEventConfigurationsRequest) throws InternalFailureException,
            ThrottlingException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeEventConfigurationsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeEventConfigurationsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeEventConfigurationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeEventConfigurationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeEventConfigurations");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeEventConfigurationsRequest, DescribeEventConfigurationsResponse>()
                            .withOperationName("DescribeEventConfigurations").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeEventConfigurationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeEventConfigurationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about the specified fleet metric.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeFleetMetric</a> action.
     * </p>
     *
     * @param describeFleetMetricRequest
     * @return Result of the DescribeFleetMetric operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeFleetMetric
     */
    @Override
    public DescribeFleetMetricResponse describeFleetMetric(DescribeFleetMetricRequest describeFleetMetricRequest)
            throws InvalidRequestException, ThrottlingException, UnauthorizedException, ServiceUnavailableException,
            InternalFailureException, ResourceNotFoundException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeFleetMetricResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeFleetMetricResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeFleetMetricRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeFleetMetricRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeFleetMetric");

            return clientHandler.execute(new ClientExecutionParams<DescribeFleetMetricRequest, DescribeFleetMetricResponse>()
                    .withOperationName("DescribeFleetMetric").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeFleetMetricRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeFleetMetricRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes a search index.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeIndex</a> action.
     * </p>
     *
     * @param describeIndexRequest
     * @return Result of the DescribeIndex operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeIndex
     */
    @Override
    public DescribeIndexResponse describeIndex(DescribeIndexRequest describeIndexRequest) throws InvalidRequestException,
            ThrottlingException, UnauthorizedException, ServiceUnavailableException, InternalFailureException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeIndexResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeIndexResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeIndexRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeIndexRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeIndex");

            return clientHandler.execute(new ClientExecutionParams<DescribeIndexRequest, DescribeIndexResponse>()
                    .withOperationName("DescribeIndex").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeIndexRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeIndexRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes a job.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeJob</a> action.
     * </p>
     *
     * @param describeJobRequest
     * @return Result of the DescribeJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeJob
     */
    @Override
    public DescribeJobResponse describeJob(DescribeJobRequest describeJobRequest) throws InvalidRequestException,
            ResourceNotFoundException, ThrottlingException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeJobResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeJob");

            return clientHandler.execute(new ClientExecutionParams<DescribeJobRequest, DescribeJobResponse>()
                    .withOperationName("DescribeJob").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(describeJobRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes a job execution.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeJobExecution</a> action.
     * </p>
     *
     * @param describeJobExecutionRequest
     * @return Result of the DescribeJobExecution operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeJobExecution
     */
    @Override
    public DescribeJobExecutionResponse describeJobExecution(DescribeJobExecutionRequest describeJobExecutionRequest)
            throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeJobExecutionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeJobExecutionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeJobExecutionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeJobExecutionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeJobExecution");

            return clientHandler.execute(new ClientExecutionParams<DescribeJobExecutionRequest, DescribeJobExecutionResponse>()
                    .withOperationName("DescribeJobExecution").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeJobExecutionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeJobExecutionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about a job template.
     * </p>
     *
     * @param describeJobTemplateRequest
     * @return Result of the DescribeJobTemplate operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeJobTemplate
     */
    @Override
    public DescribeJobTemplateResponse describeJobTemplate(DescribeJobTemplateRequest describeJobTemplateRequest)
            throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, InternalFailureException,
            AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeJobTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeJobTemplateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeJobTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeJobTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeJobTemplate");

            return clientHandler.execute(new ClientExecutionParams<DescribeJobTemplateRequest, DescribeJobTemplateResponse>()
                    .withOperationName("DescribeJobTemplate").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeJobTemplateRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeJobTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * View details of a managed job template.
     * </p>
     *
     * @param describeManagedJobTemplateRequest
     * @return Result of the DescribeManagedJobTemplate operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeManagedJobTemplate
     */
    @Override
    public DescribeManagedJobTemplateResponse describeManagedJobTemplate(
            DescribeManagedJobTemplateRequest describeManagedJobTemplateRequest) throws InvalidRequestException,
            ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeManagedJobTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeManagedJobTemplateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeManagedJobTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeManagedJobTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeManagedJobTemplate");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeManagedJobTemplateRequest, DescribeManagedJobTemplateResponse>()
                            .withOperationName("DescribeManagedJobTemplate").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeManagedJobTemplateRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeManagedJobTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about a mitigation action.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeMitigationAction</a> action.
     * </p>
     *
     * @param describeMitigationActionRequest
     * @return Result of the DescribeMitigationAction operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeMitigationAction
     */
    @Override
    public DescribeMitigationActionResponse describeMitigationAction(
            DescribeMitigationActionRequest describeMitigationActionRequest) throws InvalidRequestException,
            ResourceNotFoundException, ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException,
            IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeMitigationActionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeMitigationActionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeMitigationActionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeMitigationActionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeMitigationAction");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeMitigationActionRequest, DescribeMitigationActionResponse>()
                            .withOperationName("DescribeMitigationAction").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeMitigationActionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeMitigationActionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about a provisioning template.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeProvisioningTemplate</a> action.
     * </p>
     *
     * @param describeProvisioningTemplateRequest
     * @return Result of the DescribeProvisioningTemplate operation returned by the service.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeProvisioningTemplate
     */
    @Override
    public DescribeProvisioningTemplateResponse describeProvisioningTemplate(
            DescribeProvisioningTemplateRequest describeProvisioningTemplateRequest) throws InternalFailureException,
            InvalidRequestException, ResourceNotFoundException, ThrottlingException, UnauthorizedException, AwsServiceException,
            SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeProvisioningTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeProvisioningTemplateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeProvisioningTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeProvisioningTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeProvisioningTemplate");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeProvisioningTemplateRequest, DescribeProvisioningTemplateResponse>()
                            .withOperationName("DescribeProvisioningTemplate").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeProvisioningTemplateRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeProvisioningTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about a provisioning template version.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeProvisioningTemplateVersion</a> action.
     * </p>
     *
     * @param describeProvisioningTemplateVersionRequest
     * @return Result of the DescribeProvisioningTemplateVersion operation returned by the service.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeProvisioningTemplateVersion
     */
    @Override
    public DescribeProvisioningTemplateVersionResponse describeProvisioningTemplateVersion(
            DescribeProvisioningTemplateVersionRequest describeProvisioningTemplateVersionRequest)
            throws InternalFailureException, InvalidRequestException, ThrottlingException, ResourceNotFoundException,
            UnauthorizedException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeProvisioningTemplateVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeProvisioningTemplateVersionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeProvisioningTemplateVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeProvisioningTemplateVersionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeProvisioningTemplateVersion");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeProvisioningTemplateVersionRequest, DescribeProvisioningTemplateVersionResponse>()
                            .withOperationName("DescribeProvisioningTemplateVersion").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeProvisioningTemplateVersionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeProvisioningTemplateVersionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes a role alias.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeRoleAlias</a> action.
     * </p>
     *
     * @param describeRoleAliasRequest
     * @return Result of the DescribeRoleAlias operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeRoleAlias
     */
    @Override
    public DescribeRoleAliasResponse describeRoleAlias(DescribeRoleAliasRequest describeRoleAliasRequest)
            throws InvalidRequestException, ThrottlingException, UnauthorizedException, ServiceUnavailableException,
            InternalFailureException, ResourceNotFoundException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeRoleAliasResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeRoleAliasResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeRoleAliasRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeRoleAliasRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeRoleAlias");

            return clientHandler.execute(new ClientExecutionParams<DescribeRoleAliasRequest, DescribeRoleAliasResponse>()
                    .withOperationName("DescribeRoleAlias").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeRoleAliasRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeRoleAliasRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about a scheduled audit.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeScheduledAudit</a> action.
     * </p>
     *
     * @param describeScheduledAuditRequest
     * @return Result of the DescribeScheduledAudit operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeScheduledAudit
     */
    @Override
    public DescribeScheduledAuditResponse describeScheduledAudit(DescribeScheduledAuditRequest describeScheduledAuditRequest)
            throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, InternalFailureException,
            AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeScheduledAuditResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeScheduledAuditResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeScheduledAuditRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeScheduledAuditRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeScheduledAudit");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeScheduledAuditRequest, DescribeScheduledAuditResponse>()
                            .withOperationName("DescribeScheduledAudit").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeScheduledAuditRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeScheduledAuditRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about a Device Defender security profile.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeSecurityProfile</a> action.
     * </p>
     *
     * @param describeSecurityProfileRequest
     * @return Result of the DescribeSecurityProfile operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeSecurityProfile
     */
    @Override
    public DescribeSecurityProfileResponse describeSecurityProfile(DescribeSecurityProfileRequest describeSecurityProfileRequest)
            throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, InternalFailureException,
            AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeSecurityProfileResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeSecurityProfileResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeSecurityProfileRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeSecurityProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeSecurityProfile");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeSecurityProfileRequest, DescribeSecurityProfileResponse>()
                            .withOperationName("DescribeSecurityProfile").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeSecurityProfileRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeSecurityProfileRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about a stream.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeStream</a> action.
     * </p>
     *
     * @param describeStreamRequest
     * @return Result of the DescribeStream operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeStream
     */
    @Override
    public DescribeStreamResponse describeStream(DescribeStreamRequest describeStreamRequest) throws InvalidRequestException,
            ResourceNotFoundException, ThrottlingException, UnauthorizedException, ServiceUnavailableException,
            InternalFailureException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeStreamResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeStreamResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeStreamRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeStreamRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeStream");

            return clientHandler.execute(new ClientExecutionParams<DescribeStreamRequest, DescribeStreamResponse>()
                    .withOperationName("DescribeStream").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeStreamRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeStreamRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about the specified thing.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeThing</a> action.
     * </p>
     *
     * @param describeThingRequest
     *        The input for the DescribeThing operation.
     * @return Result of the DescribeThing operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeThing
     */
    @Override
    public DescribeThingResponse describeThing(DescribeThingRequest describeThingRequest) throws ResourceNotFoundException,
            InvalidRequestException, ThrottlingException, UnauthorizedException, ServiceUnavailableException,
            InternalFailureException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeThingResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeThingResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeThingRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeThingRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeThing");

            return clientHandler.execute(new ClientExecutionParams<DescribeThingRequest, DescribeThingResponse>()
                    .withOperationName("DescribeThing").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeThingRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeThingRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describe a thing group.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeThingGroup</a> action.
     * </p>
     *
     * @param describeThingGroupRequest
     * @return Result of the DescribeThingGroup operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeThingGroup
     */
    @Override
    public DescribeThingGroupResponse describeThingGroup(DescribeThingGroupRequest describeThingGroupRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeThingGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeThingGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeThingGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeThingGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeThingGroup");

            return clientHandler.execute(new ClientExecutionParams<DescribeThingGroupRequest, DescribeThingGroupResponse>()
                    .withOperationName("DescribeThingGroup").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeThingGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeThingGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes a bulk thing provisioning task.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeThingRegistrationTask</a> action.
     * </p>
     *
     * @param describeThingRegistrationTaskRequest
     * @return Result of the DescribeThingRegistrationTask operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeThingRegistrationTask
     */
    @Override
    public DescribeThingRegistrationTaskResponse describeThingRegistrationTask(
            DescribeThingRegistrationTaskRequest describeThingRegistrationTaskRequest) throws InvalidRequestException,
            ThrottlingException, UnauthorizedException, InternalFailureException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeThingRegistrationTaskResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeThingRegistrationTaskResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeThingRegistrationTaskRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeThingRegistrationTaskRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeThingRegistrationTask");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeThingRegistrationTaskRequest, DescribeThingRegistrationTaskResponse>()
                            .withOperationName("DescribeThingRegistrationTask").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeThingRegistrationTaskRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeThingRegistrationTaskRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about the specified thing type.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeThingType</a> action.
     * </p>
     *
     * @param describeThingTypeRequest
     *        The input for the DescribeThingType operation.
     * @return Result of the DescribeThingType operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeThingType
     */
    @Override
    public DescribeThingTypeResponse describeThingType(DescribeThingTypeRequest describeThingTypeRequest)
            throws ResourceNotFoundException, InvalidRequestException, ThrottlingException, UnauthorizedException,
            ServiceUnavailableException, InternalFailureException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeThingTypeResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeThingTypeResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeThingTypeRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeThingTypeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeThingType");

            return clientHandler.execute(new ClientExecutionParams<DescribeThingTypeRequest, DescribeThingTypeResponse>()
                    .withOperationName("DescribeThingType").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeThingTypeRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeThingTypeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Detaches a policy from the specified target.
     * </p>
     * <note>
     * <p>
     * Because of the distributed nature of Amazon Web Services, it can take up to five minutes after a policy is
     * detached before it's ready to be deleted.
     * </p>
     * </note>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DetachPolicy</a> action.
     * </p>
     *
     * @param detachPolicyRequest
     * @return Result of the DetachPolicy operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DetachPolicy
     */
    @Override
    public DetachPolicyResponse detachPolicy(DetachPolicyRequest detachPolicyRequest) throws InvalidRequestException,
            ThrottlingException, UnauthorizedException, ServiceUnavailableException, InternalFailureException,
            LimitExceededException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DetachPolicyResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DetachPolicyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(detachPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, detachPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DetachPolicy");

            return clientHandler.execute(new ClientExecutionParams<DetachPolicyRequest, DetachPolicyResponse>()
                    .withOperationName("DetachPolicy").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(detachPolicyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DetachPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Disassociates a Device Defender security profile from a thing group or from this account.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DetachSecurityProfile</a> action.
     * </p>
     *
     * @param detachSecurityProfileRequest
     * @return Result of the DetachSecurityProfile operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DetachSecurityProfile
     */
    @Override
    public DetachSecurityProfileResponse detachSecurityProfile(DetachSecurityProfileRequest detachSecurityProfileRequest)
            throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, InternalFailureException,
            AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DetachSecurityProfileResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DetachSecurityProfileResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(detachSecurityProfileRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, detachSecurityProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DetachSecurityProfile");

            return clientHandler.execute(new ClientExecutionParams<DetachSecurityProfileRequest, DetachSecurityProfileResponse>()
                    .withOperationName("DetachSecurityProfile").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(detachSecurityProfileRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DetachSecurityProfileRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Detaches the specified principal from the specified thing. A principal can be X.509 certificates, IAM users,
     * groups, and roles, Amazon Cognito identities or federated identities.
     * </p>
     * <note>
     * <p>
     * This call is asynchronous. It might take several seconds for the detachment to propagate.
     * </p>
     * </note>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DetachThingPrincipal</a> action.
     * </p>
     *
     * @param detachThingPrincipalRequest
     *        The input for the DetachThingPrincipal operation.
     * @return Result of the DetachThingPrincipal operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DetachThingPrincipal
     */
    @Override
    public DetachThingPrincipalResponse detachThingPrincipal(DetachThingPrincipalRequest detachThingPrincipalRequest)
            throws ResourceNotFoundException, InvalidRequestException, ThrottlingException, UnauthorizedException,
            ServiceUnavailableException, InternalFailureException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DetachThingPrincipalResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DetachThingPrincipalResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(detachThingPrincipalRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, detachThingPrincipalRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DetachThingPrincipal");

            return clientHandler.execute(new ClientExecutionParams<DetachThingPrincipalRequest, DetachThingPrincipalResponse>()
                    .withOperationName("DetachThingPrincipal").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(detachThingPrincipalRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DetachThingPrincipalRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Disables the rule.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DisableTopicRule</a> action.
     * </p>
     *
     * @param disableTopicRuleRequest
     *        The input for the DisableTopicRuleRequest operation.
     * @return Result of the DisableTopicRule operation returned by the service.
     * @throws InternalException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ConflictingResourceUpdateException
     *         A conflicting resource update exception. This exception is thrown when two pending updates cause a
     *         conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DisableTopicRule
     */
    @Override
    public DisableTopicRuleResponse disableTopicRule(DisableTopicRuleRequest disableTopicRuleRequest) throws InternalException,
            InvalidRequestException, ServiceUnavailableException, UnauthorizedException, ConflictingResourceUpdateException,
            AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DisableTopicRuleResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DisableTopicRuleResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disableTopicRuleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disableTopicRuleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisableTopicRule");

            return clientHandler.execute(new ClientExecutionParams<DisableTopicRuleRequest, DisableTopicRuleResponse>()
                    .withOperationName("DisableTopicRule").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(disableTopicRuleRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DisableTopicRuleRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Enables the rule.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >EnableTopicRule</a> action.
     * </p>
     *
     * @param enableTopicRuleRequest
     *        The input for the EnableTopicRuleRequest operation.
     * @return Result of the EnableTopicRule operation returned by the service.
     * @throws InternalException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ConflictingResourceUpdateException
     *         A conflicting resource update exception. This exception is thrown when two pending updates cause a
     *         conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.EnableTopicRule
     */
    @Override
    public EnableTopicRuleResponse enableTopicRule(EnableTopicRuleRequest enableTopicRuleRequest) throws InternalException,
            InvalidRequestException, ServiceUnavailableException, UnauthorizedException, ConflictingResourceUpdateException,
            AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<EnableTopicRuleResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                EnableTopicRuleResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(enableTopicRuleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, enableTopicRuleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "EnableTopicRule");

            return clientHandler.execute(new ClientExecutionParams<EnableTopicRuleRequest, EnableTopicRuleResponse>()
                    .withOperationName("EnableTopicRule").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(enableTopicRuleRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new EnableTopicRuleRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a Device Defender's ML Detect Security Profile training model's status.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >GetBehaviorModelTrainingSummaries</a> action.
     * </p>
     *
     * @param getBehaviorModelTrainingSummariesRequest
     * @return Result of the GetBehaviorModelTrainingSummaries operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.GetBehaviorModelTrainingSummaries
     */
    @Override
    public GetBehaviorModelTrainingSummariesResponse getBehaviorModelTrainingSummaries(
            GetBehaviorModelTrainingSummariesRequest getBehaviorModelTrainingSummariesRequest) throws InvalidRequestException,
            ThrottlingException, InternalFailureException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetBehaviorModelTrainingSummariesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetBehaviorModelTrainingSummariesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getBehaviorModelTrainingSummariesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getBehaviorModelTrainingSummariesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetBehaviorModelTrainingSummaries");

            return clientHandler
                    .execute(new ClientExecutionParams<GetBehaviorModelTrainingSummariesRequest, GetBehaviorModelTrainingSummariesResponse>()
                            .withOperationName("GetBehaviorModelTrainingSummaries").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getBehaviorModelTrainingSummariesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetBehaviorModelTrainingSummariesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Aggregates on indexed data with search queries pertaining to particular fields.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >GetBucketsAggregation</a> action.
     * </p>
     *
     * @param getBucketsAggregationRequest
     * @return Result of the GetBucketsAggregation operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidQueryException
     *         The query is invalid.
     * @throws InvalidAggregationException
     *         The aggregation is invalid.
     * @throws IndexNotReadyException
     *         The index is not ready.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.GetBucketsAggregation
     */
    @Override
    public GetBucketsAggregationResponse getBucketsAggregation(GetBucketsAggregationRequest getBucketsAggregationRequest)
            throws InvalidRequestException, ThrottlingException, UnauthorizedException, ServiceUnavailableException,
            InternalFailureException, ResourceNotFoundException, InvalidQueryException, InvalidAggregationException,
            IndexNotReadyException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetBucketsAggregationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetBucketsAggregationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getBucketsAggregationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getBucketsAggregationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetBucketsAggregation");

            return clientHandler.execute(new ClientExecutionParams<GetBucketsAggregationRequest, GetBucketsAggregationResponse>()
                    .withOperationName("GetBucketsAggregation").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getBucketsAggregationRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetBucketsAggregationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the approximate count of unique values that match the query.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >GetCardinality</a> action.
     * </p>
     *
     * @param getCardinalityRequest
     * @return Result of the GetCardinality operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidQueryException
     *         The query is invalid.
     * @throws InvalidAggregationException
     *         The aggregation is invalid.
     * @throws IndexNotReadyException
     *         The index is not ready.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.GetCardinality
     */
    @Override
    public GetCardinalityResponse getCardinality(GetCardinalityRequest getCardinalityRequest) throws InvalidRequestException,
            ThrottlingException, UnauthorizedException, ServiceUnavailableException, InternalFailureException,
            ResourceNotFoundException, InvalidQueryException, InvalidAggregationException, IndexNotReadyException,
            AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetCardinalityResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetCardinalityResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getCardinalityRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getCardinalityRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCardinality");

            return clientHandler.execute(new ClientExecutionParams<GetCardinalityRequest, GetCardinalityResponse>()
                    .withOperationName("GetCardinality").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getCardinalityRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetCardinalityRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a list of the policies that have an effect on the authorization behavior of the specified device when it
     * connects to the IoT device gateway.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >GetEffectivePolicies</a> action.
     * </p>
     *
     * @param getEffectivePoliciesRequest
     * @return Result of the GetEffectivePolicies operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.GetEffectivePolicies
     */
    @Override
    public GetEffectivePoliciesResponse getEffectivePolicies(GetEffectivePoliciesRequest getEffectivePoliciesRequest)
            throws ResourceNotFoundException, InvalidRequestException, ThrottlingException, UnauthorizedException,
            ServiceUnavailableException, InternalFailureException, LimitExceededException, AwsServiceException,
            SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetEffectivePoliciesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetEffectivePoliciesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getEffectivePoliciesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getEffectivePoliciesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetEffectivePolicies");

            return clientHandler.execute(new ClientExecutionParams<GetEffectivePoliciesRequest, GetEffectivePoliciesResponse>()
                    .withOperationName("GetEffectivePolicies").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getEffectivePoliciesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetEffectivePoliciesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets the indexing configuration.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >GetIndexingConfiguration</a> action.
     * </p>
     *
     * @param getIndexingConfigurationRequest
     * @return Result of the GetIndexingConfiguration operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.GetIndexingConfiguration
     */
    @Override
    public GetIndexingConfigurationResponse getIndexingConfiguration(
            GetIndexingConfigurationRequest getIndexingConfigurationRequest) throws InvalidRequestException, ThrottlingException,
            UnauthorizedException, ServiceUnavailableException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetIndexingConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetIndexingConfigurationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getIndexingConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getIndexingConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetIndexingConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<GetIndexingConfigurationRequest, GetIndexingConfigurationResponse>()
                            .withOperationName("GetIndexingConfiguration").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getIndexingConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetIndexingConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a job document.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >GetJobDocument</a> action.
     * </p>
     *
     * @param getJobDocumentRequest
     * @return Result of the GetJobDocument operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.GetJobDocument
     */
    @Override
    public GetJobDocumentResponse getJobDocument(GetJobDocumentRequest getJobDocumentRequest) throws InvalidRequestException,
            ResourceNotFoundException, ThrottlingException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetJobDocumentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetJobDocumentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getJobDocumentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getJobDocumentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetJobDocument");

            return clientHandler.execute(new ClientExecutionParams<GetJobDocumentRequest, GetJobDocumentResponse>()
                    .withOperationName("GetJobDocument").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getJobDocumentRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetJobDocumentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets the logging options.
     * </p>
     * <p>
     * NOTE: use of this command is not recommended. Use <code>GetV2LoggingOptions</code> instead.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >GetLoggingOptions</a> action.
     * </p>
     *
     * @param getLoggingOptionsRequest
     *        The input for the GetLoggingOptions operation.
     * @return Result of the GetLoggingOptions operation returned by the service.
     * @throws InternalException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.GetLoggingOptions
     */
    @Override
    public GetLoggingOptionsResponse getLoggingOptions(GetLoggingOptionsRequest getLoggingOptionsRequest)
            throws InternalException, InvalidRequestException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetLoggingOptionsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetLoggingOptionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getLoggingOptionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getLoggingOptionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetLoggingOptions");

            return clientHandler.execute(new ClientExecutionParams<GetLoggingOptionsRequest, GetLoggingOptionsResponse>()
                    .withOperationName("GetLoggingOptions").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getLoggingOptionsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetLoggingOptionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets an OTA update.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >GetOTAUpdate</a> action.
     * </p>
     *
     * @param getOtaUpdateRequest
     * @return Result of the GetOTAUpdate operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.GetOTAUpdate
     */
    @Override
    public GetOtaUpdateResponse getOTAUpdate(GetOtaUpdateRequest getOtaUpdateRequest) throws InvalidRequestException,
            ThrottlingException, UnauthorizedException, InternalFailureException, ServiceUnavailableException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetOtaUpdateResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetOtaUpdateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getOtaUpdateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getOtaUpdateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetOTAUpdate");

            return clientHandler.execute(new ClientExecutionParams<GetOtaUpdateRequest, GetOtaUpdateResponse>()
                    .withOperationName("GetOTAUpdate").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getOtaUpdateRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetOtaUpdateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about the specified software package.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >GetPackage</a> action.
     * </p>
     *
     * @param getPackageRequest
     * @return Result of the GetPackage operation returned by the service.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ValidationException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.GetPackage
     */
    @Override
    public GetPackageResponse getPackage(GetPackageRequest getPackageRequest) throws ThrottlingException,
            InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetPackageResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetPackageResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getPackageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getPackageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetPackage");

            return clientHandler.execute(new ClientExecutionParams<GetPackageRequest, GetPackageResponse>()
                    .withOperationName("GetPackage").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getPackageRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetPackageRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about the specified software package's configuration.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >GetPackageConfiguration</a> action.
     * </p>
     *
     * @param getPackageConfigurationRequest
     * @return Result of the GetPackageConfiguration operation returned by the service.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.GetPackageConfiguration
     */
    @Override
    public GetPackageConfigurationResponse getPackageConfiguration(GetPackageConfigurationRequest getPackageConfigurationRequest)
            throws ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetPackageConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetPackageConfigurationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getPackageConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getPackageConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetPackageConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<GetPackageConfigurationRequest, GetPackageConfigurationResponse>()
                            .withOperationName("GetPackageConfiguration").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getPackageConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetPackageConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about the specified package version.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >GetPackageVersion</a> action.
     * </p>
     *
     * @param getPackageVersionRequest
     * @return Result of the GetPackageVersion operation returned by the service.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ValidationException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.GetPackageVersion
     */
    @Override
    public GetPackageVersionResponse getPackageVersion(GetPackageVersionRequest getPackageVersionRequest)
            throws ThrottlingException, InternalServerException, ValidationException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetPackageVersionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetPackageVersionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getPackageVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getPackageVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetPackageVersion");

            return clientHandler.execute(new ClientExecutionParams<GetPackageVersionRequest, GetPackageVersionResponse>()
                    .withOperationName("GetPackageVersion").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getPackageVersionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetPackageVersionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Groups the aggregated values that match the query into percentile groupings. The default percentile groupings
     * are: 1,5,25,50,75,95,99, although you can specify your own when you call <code>GetPercentiles</code>. This
     * function returns a value for each percentile group specified (or the default percentile groupings). The
     * percentile group "1" contains the aggregated field value that occurs in approximately one percent of the values
     * that match the query. The percentile group "5" contains the aggregated field value that occurs in approximately
     * five percent of the values that match the query, and so on. The result is an approximation, the more values that
     * match the query, the more accurate the percentile values.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >GetPercentiles</a> action.
     * </p>
     *
     * @param getPercentilesRequest
     * @return Result of the GetPercentiles operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidQueryException
     *         The query is invalid.
     * @throws InvalidAggregationException
     *         The aggregation is invalid.
     * @throws IndexNotReadyException
     *         The index is not ready.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.GetPercentiles
     */
    @Override
    public GetPercentilesResponse getPercentiles(GetPercentilesRequest getPercentilesRequest) throws InvalidRequestException,
            ThrottlingException, UnauthorizedException, ServiceUnavailableException, InternalFailureException,
            ResourceNotFoundException, InvalidQueryException, InvalidAggregationException, IndexNotReadyException,
            AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetPercentilesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetPercentilesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getPercentilesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getPercentilesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetPercentiles");

            return clientHandler.execute(new ClientExecutionParams<GetPercentilesRequest, GetPercentilesResponse>()
                    .withOperationName("GetPercentiles").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getPercentilesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetPercentilesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about the specified policy with the policy document of the default version.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >GetPolicy</a> action.
     * </p>
     *
     * @param getPolicyRequest
     *        The input for the GetPolicy operation.
     * @return Result of the GetPolicy operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.GetPolicy
     */
    @Override
    public GetPolicyResponse getPolicy(GetPolicyRequest getPolicyRequest) throws ResourceNotFoundException,
            InvalidRequestException, ThrottlingException, UnauthorizedException, ServiceUnavailableException,
            InternalFailureException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetPolicyResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetPolicyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetPolicy");

            return clientHandler.execute(new ClientExecutionParams<GetPolicyRequest, GetPolicyResponse>()
                    .withOperationName("GetPolicy").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getPolicyRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about the specified policy version.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >GetPolicyVersion</a> action.
     * </p>
     *
     * @param getPolicyVersionRequest
     *        The input for the GetPolicyVersion operation.
     * @return Result of the GetPolicyVersion operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.GetPolicyVersion
     */
    @Override
    public GetPolicyVersionResponse getPolicyVersion(GetPolicyVersionRequest getPolicyVersionRequest)
            throws ResourceNotFoundException, InvalidRequestException, ThrottlingException, UnauthorizedException,
            ServiceUnavailableException, InternalFailureException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetPolicyVersionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetPolicyVersionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getPolicyVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getPolicyVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetPolicyVersion");

            return clientHandler.execute(new ClientExecutionParams<GetPolicyVersionRequest, GetPolicyVersionResponse>()
                    .withOperationName("GetPolicyVersion").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getPolicyVersionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetPolicyVersionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a registration code used to register a CA certificate with IoT.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >GetRegistrationCode</a> action.
     * </p>
     *
     * @param getRegistrationCodeRequest
     *        The input to the GetRegistrationCode operation.
     * @return Result of the GetRegistrationCode operation returned by the service.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.GetRegistrationCode
     */
    @Override
    public GetRegistrationCodeResponse getRegistrationCode(GetRegistrationCodeRequest getRegistrationCodeRequest)
            throws ThrottlingException, UnauthorizedException, ServiceUnavailableException, InternalFailureException,
            InvalidRequestException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetRegistrationCodeResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetRegistrationCodeResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getRegistrationCodeRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getRegistrationCodeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRegistrationCode");

            return clientHandler.execute(new ClientExecutionParams<GetRegistrationCodeRequest, GetRegistrationCodeResponse>()
                    .withOperationName("GetRegistrationCode").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getRegistrationCodeRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetRegistrationCodeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the count, average, sum, minimum, maximum, sum of squares, variance, and standard deviation for the
     * specified aggregated field. If the aggregation field is of type <code>String</code>, only the count statistic is
     * returned.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >GetStatistics</a> action.
     * </p>
     *
     * @param getStatisticsRequest
     * @return Result of the GetStatistics operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidQueryException
     *         The query is invalid.
     * @throws InvalidAggregationException
     *         The aggregation is invalid.
     * @throws IndexNotReadyException
     *         The index is not ready.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.GetStatistics
     */
    @Override
    public GetStatisticsResponse getStatistics(GetStatisticsRequest getStatisticsRequest) throws InvalidRequestException,
            ThrottlingException, UnauthorizedException, ServiceUnavailableException, InternalFailureException,
            ResourceNotFoundException, InvalidQueryException, InvalidAggregationException, IndexNotReadyException,
            AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetStatisticsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetStatisticsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getStatisticsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getStatisticsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetStatistics");

            return clientHandler.execute(new ClientExecutionParams<GetStatisticsRequest, GetStatisticsResponse>()
                    .withOperationName("GetStatistics").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getStatisticsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetStatisticsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about the rule.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >GetTopicRule</a> action.
     * </p>
     *
     * @param getTopicRuleRequest
     *        The input for the GetTopicRule operation.
     * @return Result of the GetTopicRule operation returned by the service.
     * @throws InternalException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.GetTopicRule
     */
    @Override
    public GetTopicRuleResponse getTopicRule(GetTopicRuleRequest getTopicRuleRequest) throws InternalException,
            InvalidRequestException, ServiceUnavailableException, UnauthorizedException, AwsServiceException, SdkClientException,
            IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetTopicRuleResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetTopicRuleResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getTopicRuleRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getTopicRuleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetTopicRule");

            return clientHandler.execute(new ClientExecutionParams<GetTopicRuleRequest, GetTopicRuleResponse>()
                    .withOperationName("GetTopicRule").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getTopicRuleRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetTopicRuleRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about a topic rule destination.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >GetTopicRuleDestination</a> action.
     * </p>
     *
     * @param getTopicRuleDestinationRequest
     * @return Result of the GetTopicRuleDestination operation returned by the service.
     * @throws InternalException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.GetTopicRuleDestination
     */
    @Override
    public GetTopicRuleDestinationResponse getTopicRuleDestination(GetTopicRuleDestinationRequest getTopicRuleDestinationRequest)
            throws InternalException, InvalidRequestException, ServiceUnavailableException, UnauthorizedException,
            AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetTopicRuleDestinationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetTopicRuleDestinationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getTopicRuleDestinationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getTopicRuleDestinationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetTopicRuleDestination");

            return clientHandler
                    .execute(new ClientExecutionParams<GetTopicRuleDestinationRequest, GetTopicRuleDestinationResponse>()
                            .withOperationName("GetTopicRuleDestination").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getTopicRuleDestinationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetTopicRuleDestinationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets the fine grained logging options.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >GetV2LoggingOptions</a> action.
     * </p>
     *
     * @param getV2LoggingOptionsRequest
     * @return Result of the GetV2LoggingOptions operation returned by the service.
     * @throws InternalException
     *         An unexpected error has occurred.
     * @throws NotConfiguredException
     *         The resource is not configured.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.GetV2LoggingOptions
     */
    @Override
    public GetV2LoggingOptionsResponse getV2LoggingOptions(GetV2LoggingOptionsRequest getV2LoggingOptionsRequest)
            throws InternalException, NotConfiguredException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetV2LoggingOptionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetV2LoggingOptionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getV2LoggingOptionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getV2LoggingOptionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetV2LoggingOptions");

            return clientHandler.execute(new ClientExecutionParams<GetV2LoggingOptionsRequest, GetV2LoggingOptionsResponse>()
                    .withOperationName("GetV2LoggingOptions").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getV2LoggingOptionsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetV2LoggingOptionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the active violations for a given Device Defender security profile.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListActiveViolations</a> action.
     * </p>
     *
     * @param listActiveViolationsRequest
     * @return Result of the ListActiveViolations operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListActiveViolations
     */
    @Override
    public ListActiveViolationsResponse listActiveViolations(ListActiveViolationsRequest listActiveViolationsRequest)
            throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, InternalFailureException,
            AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListActiveViolationsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListActiveViolationsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listActiveViolationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listActiveViolationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListActiveViolations");

            return clientHandler.execute(new ClientExecutionParams<ListActiveViolationsRequest, ListActiveViolationsResponse>()
                    .withOperationName("ListActiveViolations").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listActiveViolationsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListActiveViolationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the policies attached to the specified thing group.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListAttachedPolicies</a> action.
     * </p>
     *
     * @param listAttachedPoliciesRequest
     * @return Result of the ListAttachedPolicies operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListAttachedPolicies
     */
    @Override
    public ListAttachedPoliciesResponse listAttachedPolicies(ListAttachedPoliciesRequest listAttachedPoliciesRequest)
            throws ResourceNotFoundException, InvalidRequestException, ThrottlingException, UnauthorizedException,
            ServiceUnavailableException, InternalFailureException, LimitExceededException, AwsServiceException,
            SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAttachedPoliciesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListAttachedPoliciesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAttachedPoliciesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAttachedPoliciesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAttachedPolicies");

            return clientHandler.execute(new ClientExecutionParams<ListAttachedPoliciesRequest, ListAttachedPoliciesResponse>()
                    .withOperationName("ListAttachedPolicies").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listAttachedPoliciesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListAttachedPoliciesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the findings (results) of a Device Defender audit or of the audits performed during a specified time
     * period. (Findings are retained for 90 days.)
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListAuditFindings</a> action.
     * </p>
     *
     * @param listAuditFindingsRequest
     * @return Result of the ListAuditFindings operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListAuditFindings
     */
    @Override
    public ListAuditFindingsResponse listAuditFindings(ListAuditFindingsRequest listAuditFindingsRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAuditFindingsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListAuditFindingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAuditFindingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAuditFindingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAuditFindings");

            return clientHandler.execute(new ClientExecutionParams<ListAuditFindingsRequest, ListAuditFindingsResponse>()
                    .withOperationName("ListAuditFindings").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listAuditFindingsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListAuditFindingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets the status of audit mitigation action tasks that were executed.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListAuditMitigationActionsExecutions</a> action.
     * </p>
     *
     * @param listAuditMitigationActionsExecutionsRequest
     * @return Result of the ListAuditMitigationActionsExecutions operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListAuditMitigationActionsExecutions
     */
    @Override
    public ListAuditMitigationActionsExecutionsResponse listAuditMitigationActionsExecutions(
            ListAuditMitigationActionsExecutionsRequest listAuditMitigationActionsExecutionsRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAuditMitigationActionsExecutionsResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, ListAuditMitigationActionsExecutionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAuditMitigationActionsExecutionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listAuditMitigationActionsExecutionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAuditMitigationActionsExecutions");

            return clientHandler
                    .execute(new ClientExecutionParams<ListAuditMitigationActionsExecutionsRequest, ListAuditMitigationActionsExecutionsResponse>()
                            .withOperationName("ListAuditMitigationActionsExecutions").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listAuditMitigationActionsExecutionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListAuditMitigationActionsExecutionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a list of audit mitigation action tasks that match the specified filters.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListAuditMitigationActionsTasks</a> action.
     * </p>
     *
     * @param listAuditMitigationActionsTasksRequest
     * @return Result of the ListAuditMitigationActionsTasks operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListAuditMitigationActionsTasks
     */
    @Override
    public ListAuditMitigationActionsTasksResponse listAuditMitigationActionsTasks(
            ListAuditMitigationActionsTasksRequest listAuditMitigationActionsTasksRequest) throws InvalidRequestException,
            ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAuditMitigationActionsTasksResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListAuditMitigationActionsTasksResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAuditMitigationActionsTasksRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listAuditMitigationActionsTasksRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAuditMitigationActionsTasks");

            return clientHandler
                    .execute(new ClientExecutionParams<ListAuditMitigationActionsTasksRequest, ListAuditMitigationActionsTasksResponse>()
                            .withOperationName("ListAuditMitigationActionsTasks").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listAuditMitigationActionsTasksRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListAuditMitigationActionsTasksRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists your Device Defender audit listings.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListAuditSuppressions</a> action.
     * </p>
     *
     * @param listAuditSuppressionsRequest
     * @return Result of the ListAuditSuppressions operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListAuditSuppressions
     */
    @Override
    public ListAuditSuppressionsResponse listAuditSuppressions(ListAuditSuppressionsRequest listAuditSuppressionsRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAuditSuppressionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListAuditSuppressionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAuditSuppressionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAuditSuppressionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAuditSuppressions");

            return clientHandler.execute(new ClientExecutionParams<ListAuditSuppressionsRequest, ListAuditSuppressionsResponse>()
                    .withOperationName("ListAuditSuppressions").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listAuditSuppressionsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListAuditSuppressionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the Device Defender audits that have been performed during a given time period.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListAuditTasks</a> action.
     * </p>
     *
     * @param listAuditTasksRequest
     * @return Result of the ListAuditTasks operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListAuditTasks
     */
    @Override
    public ListAuditTasksResponse listAuditTasks(ListAuditTasksRequest listAuditTasksRequest) throws InvalidRequestException,
            ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAuditTasksResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListAuditTasksResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAuditTasksRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAuditTasksRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAuditTasks");

            return clientHandler.execute(new ClientExecutionParams<ListAuditTasksRequest, ListAuditTasksResponse>()
                    .withOperationName("ListAuditTasks").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listAuditTasksRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListAuditTasksRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the authorizers registered in your account.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListAuthorizers</a> action.
     * </p>
     *
     * @param listAuthorizersRequest
     * @return Result of the ListAuthorizers operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListAuthorizers
     */
    @Override
    public ListAuthorizersResponse listAuthorizers(ListAuthorizersRequest listAuthorizersRequest) throws InvalidRequestException,
            ThrottlingException, UnauthorizedException, ServiceUnavailableException, InternalFailureException,
            AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAuthorizersResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListAuthorizersResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAuthorizersRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAuthorizersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAuthorizers");

            return clientHandler.execute(new ClientExecutionParams<ListAuthorizersRequest, ListAuthorizersResponse>()
                    .withOperationName("ListAuthorizers").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listAuthorizersRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListAuthorizersRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the billing groups you have created.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListBillingGroups</a> action.
     * </p>
     *
     * @param listBillingGroupsRequest
     * @return Result of the ListBillingGroups operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListBillingGroups
     */
    @Override
    public ListBillingGroupsResponse listBillingGroups(ListBillingGroupsRequest listBillingGroupsRequest)
            throws InvalidRequestException, InternalFailureException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListBillingGroupsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListBillingGroupsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listBillingGroupsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listBillingGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListBillingGroups");

            return clientHandler.execute(new ClientExecutionParams<ListBillingGroupsRequest, ListBillingGroupsResponse>()
                    .withOperationName("ListBillingGroups").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listBillingGroupsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListBillingGroupsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the CA certificates registered for your Amazon Web Services account.
     * </p>
     * <p>
     * The results are paginated with a default page size of 25. You can use the returned marker to retrieve additional
     * results.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListCACertificates</a> action.
     * </p>
     *
     * @param listCaCertificatesRequest
     *        Input for the ListCACertificates operation.
     * @return Result of the ListCACertificates operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListCACertificates
     */
    @Override
    public ListCaCertificatesResponse listCACertificates(ListCaCertificatesRequest listCaCertificatesRequest)
            throws InvalidRequestException, ThrottlingException, UnauthorizedException, ServiceUnavailableException,
            InternalFailureException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListCaCertificatesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListCaCertificatesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listCaCertificatesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listCaCertificatesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCACertificates");

            return clientHandler.execute(new ClientExecutionParams<ListCaCertificatesRequest, ListCaCertificatesResponse>()
                    .withOperationName("ListCACertificates").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listCaCertificatesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListCaCertificatesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the certificates registered in your Amazon Web Services account.
     * </p>
     * <p>
     * The results are paginated with a default page size of 25. You can use the returned marker to retrieve additional
     * results.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListCertificates</a> action.
     * </p>
     *
     * @param listCertificatesRequest
     *        The input for the ListCertificates operation.
     * @return Result of the ListCertificates operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListCertificates
     */
    @Override
    public ListCertificatesResponse listCertificates(ListCertificatesRequest listCertificatesRequest)
            throws InvalidRequestException, ThrottlingException, UnauthorizedException, ServiceUnavailableException,
            InternalFailureException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListCertificatesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListCertificatesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listCertificatesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listCertificatesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCertificates");

            return clientHandler.execute(new ClientExecutionParams<ListCertificatesRequest, ListCertificatesResponse>()
                    .withOperationName("ListCertificates").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listCertificatesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListCertificatesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * List the device certificates signed by the specified CA certificate.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListCertificatesByCA</a> action.
     * </p>
     *
     * @param listCertificatesByCaRequest
     *        The input to the ListCertificatesByCA operation.
     * @return Result of the ListCertificatesByCA operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListCertificatesByCA
     */
    @Override
    public ListCertificatesByCaResponse listCertificatesByCA(ListCertificatesByCaRequest listCertificatesByCaRequest)
            throws InvalidRequestException, ThrottlingException, UnauthorizedException, ServiceUnavailableException,
            InternalFailureException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListCertificatesByCaResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListCertificatesByCaResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listCertificatesByCaRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listCertificatesByCaRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCertificatesByCA");

            return clientHandler.execute(new ClientExecutionParams<ListCertificatesByCaRequest, ListCertificatesByCaResponse>()
                    .withOperationName("ListCertificatesByCA").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listCertificatesByCaRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListCertificatesByCaRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists your Device Defender detect custom metrics.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListCustomMetrics</a> action.
     * </p>
     *
     * @param listCustomMetricsRequest
     * @return Result of the ListCustomMetrics operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListCustomMetrics
     */
    @Override
    public ListCustomMetricsResponse listCustomMetrics(ListCustomMetricsRequest listCustomMetricsRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListCustomMetricsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListCustomMetricsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listCustomMetricsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listCustomMetricsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCustomMetrics");

            return clientHandler.execute(new ClientExecutionParams<ListCustomMetricsRequest, ListCustomMetricsResponse>()
                    .withOperationName("ListCustomMetrics").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listCustomMetricsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListCustomMetricsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists mitigation actions executions for a Device Defender ML Detect Security Profile.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListDetectMitigationActionsExecutions</a> action.
     * </p>
     *
     * @param listDetectMitigationActionsExecutionsRequest
     * @return Result of the ListDetectMitigationActionsExecutions operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListDetectMitigationActionsExecutions
     */
    @Override
    public ListDetectMitigationActionsExecutionsResponse listDetectMitigationActionsExecutions(
            ListDetectMitigationActionsExecutionsRequest listDetectMitigationActionsExecutionsRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListDetectMitigationActionsExecutionsResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, ListDetectMitigationActionsExecutionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listDetectMitigationActionsExecutionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listDetectMitigationActionsExecutionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDetectMitigationActionsExecutions");

            return clientHandler
                    .execute(new ClientExecutionParams<ListDetectMitigationActionsExecutionsRequest, ListDetectMitigationActionsExecutionsResponse>()
                            .withOperationName("ListDetectMitigationActionsExecutions").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration)
                            .withInput(listDetectMitigationActionsExecutionsRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListDetectMitigationActionsExecutionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * List of Device Defender ML Detect mitigation actions tasks.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListDetectMitigationActionsTasks</a> action.
     * </p>
     *
     * @param listDetectMitigationActionsTasksRequest
     * @return Result of the ListDetectMitigationActionsTasks operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListDetectMitigationActionsTasks
     */
    @Override
    public ListDetectMitigationActionsTasksResponse listDetectMitigationActionsTasks(
            ListDetectMitigationActionsTasksRequest listDetectMitigationActionsTasksRequest) throws InvalidRequestException,
            ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListDetectMitigationActionsTasksResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListDetectMitigationActionsTasksResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listDetectMitigationActionsTasksRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listDetectMitigationActionsTasksRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDetectMitigationActionsTasks");

            return clientHandler
                    .execute(new ClientExecutionParams<ListDetectMitigationActionsTasksRequest, ListDetectMitigationActionsTasksResponse>()
                            .withOperationName("ListDetectMitigationActionsTasks").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listDetectMitigationActionsTasksRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListDetectMitigationActionsTasksRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * List the set of dimensions that are defined for your Amazon Web Services accounts.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListDimensions</a> action.
     * </p>
     *
     * @param listDimensionsRequest
     * @return Result of the ListDimensions operation returned by the service.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListDimensions
     */
    @Override
    public ListDimensionsResponse listDimensions(ListDimensionsRequest listDimensionsRequest) throws InternalFailureException,
            InvalidRequestException, ThrottlingException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListDimensionsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListDimensionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listDimensionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDimensionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDimensions");

            return clientHandler.execute(new ClientExecutionParams<ListDimensionsRequest, ListDimensionsResponse>()
                    .withOperationName("ListDimensions").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listDimensionsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListDimensionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a list of domain configurations for the user. This list is sorted alphabetically by domain configuration
     * name.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListDomainConfigurations</a> action.
     * </p>
     *
     * @param listDomainConfigurationsRequest
     * @return Result of the ListDomainConfigurations operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListDomainConfigurations
     */
    @Override
    public ListDomainConfigurationsResponse listDomainConfigurations(
            ListDomainConfigurationsRequest listDomainConfigurationsRequest) throws InvalidRequestException, ThrottlingException,
            UnauthorizedException, ServiceUnavailableException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListDomainConfigurationsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListDomainConfigurationsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listDomainConfigurationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDomainConfigurationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDomainConfigurations");

            return clientHandler
                    .execute(new ClientExecutionParams<ListDomainConfigurationsRequest, ListDomainConfigurationsResponse>()
                            .withOperationName("ListDomainConfigurations").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listDomainConfigurationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListDomainConfigurationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all your fleet metrics.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListFleetMetrics</a> action.
     * </p>
     *
     * @param listFleetMetricsRequest
     * @return Result of the ListFleetMetrics operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListFleetMetrics
     */
    @Override
    public ListFleetMetricsResponse listFleetMetrics(ListFleetMetricsRequest listFleetMetricsRequest)
            throws InvalidRequestException, ThrottlingException, UnauthorizedException, ServiceUnavailableException,
            InternalFailureException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListFleetMetricsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListFleetMetricsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listFleetMetricsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listFleetMetricsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListFleetMetrics");

            return clientHandler.execute(new ClientExecutionParams<ListFleetMetricsRequest, ListFleetMetricsResponse>()
                    .withOperationName("ListFleetMetrics").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listFleetMetricsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListFleetMetricsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the search indices.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListIndices</a> action.
     * </p>
     *
     * @param listIndicesRequest
     * @return Result of the ListIndices operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListIndices
     */
    @Override
    public ListIndicesResponse listIndices(ListIndicesRequest listIndicesRequest) throws InvalidRequestException,
            ThrottlingException, UnauthorizedException, ServiceUnavailableException, InternalFailureException,
            AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListIndicesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListIndicesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listIndicesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listIndicesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListIndices");

            return clientHandler.execute(new ClientExecutionParams<ListIndicesRequest, ListIndicesResponse>()
                    .withOperationName("ListIndices").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(listIndicesRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListIndicesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the job executions for a job.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListJobExecutionsForJob</a> action.
     * </p>
     *
     * @param listJobExecutionsForJobRequest
     * @return Result of the ListJobExecutionsForJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListJobExecutionsForJob
     */
    @Override
    public ListJobExecutionsForJobResponse listJobExecutionsForJob(ListJobExecutionsForJobRequest listJobExecutionsForJobRequest)
            throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListJobExecutionsForJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListJobExecutionsForJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listJobExecutionsForJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listJobExecutionsForJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListJobExecutionsForJob");

            return clientHandler
                    .execute(new ClientExecutionParams<ListJobExecutionsForJobRequest, ListJobExecutionsForJobResponse>()
                            .withOperationName("ListJobExecutionsForJob").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listJobExecutionsForJobRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListJobExecutionsForJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the job executions for the specified thing.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListJobExecutionsForThing</a> action.
     * </p>
     *
     * @param listJobExecutionsForThingRequest
     * @return Result of the ListJobExecutionsForThing operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListJobExecutionsForThing
     */
    @Override
    public ListJobExecutionsForThingResponse listJobExecutionsForThing(
            ListJobExecutionsForThingRequest listJobExecutionsForThingRequest) throws InvalidRequestException,
            ResourceNotFoundException, ThrottlingException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListJobExecutionsForThingResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListJobExecutionsForThingResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listJobExecutionsForThingRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listJobExecutionsForThingRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListJobExecutionsForThing");

            return clientHandler
                    .execute(new ClientExecutionParams<ListJobExecutionsForThingRequest, ListJobExecutionsForThingResponse>()
                            .withOperationName("ListJobExecutionsForThing").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listJobExecutionsForThingRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListJobExecutionsForThingRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of job templates.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListJobTemplates</a> action.
     * </p>
     *
     * @param listJobTemplatesRequest
     * @return Result of the ListJobTemplates operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListJobTemplates
     */
    @Override
    public ListJobTemplatesResponse listJobTemplates(ListJobTemplatesRequest listJobTemplatesRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListJobTemplatesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListJobTemplatesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listJobTemplatesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listJobTemplatesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListJobTemplates");

            return clientHandler.execute(new ClientExecutionParams<ListJobTemplatesRequest, ListJobTemplatesResponse>()
                    .withOperationName("ListJobTemplates").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listJobTemplatesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListJobTemplatesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists jobs.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListJobs</a> action.
     * </p>
     *
     * @param listJobsRequest
     * @return Result of the ListJobs operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListJobs
     */
    @Override
    public ListJobsResponse listJobs(ListJobsRequest listJobsRequest) throws InvalidRequestException, ResourceNotFoundException,
            ThrottlingException, ServiceUnavailableException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListJobsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListJobsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listJobsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListJobs");

            return clientHandler.execute(new ClientExecutionParams<ListJobsRequest, ListJobsResponse>()
                    .withOperationName("ListJobs").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(listJobsRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListJobsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of managed job templates.
     * </p>
     *
     * @param listManagedJobTemplatesRequest
     * @return Result of the ListManagedJobTemplates operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListManagedJobTemplates
     */
    @Override
    public ListManagedJobTemplatesResponse listManagedJobTemplates(ListManagedJobTemplatesRequest listManagedJobTemplatesRequest)
            throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListManagedJobTemplatesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListManagedJobTemplatesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listManagedJobTemplatesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listManagedJobTemplatesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListManagedJobTemplates");

            return clientHandler
                    .execute(new ClientExecutionParams<ListManagedJobTemplatesRequest, ListManagedJobTemplatesResponse>()
                            .withOperationName("ListManagedJobTemplates").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listManagedJobTemplatesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListManagedJobTemplatesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the values reported for an IoT Device Defender metric (device-side metric, cloud-side metric, or custom
     * metric) by the given thing during the specified time period.
     * </p>
     *
     * @param listMetricValuesRequest
     * @return Result of the ListMetricValues operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListMetricValues
     */
    @Override
    public ListMetricValuesResponse listMetricValues(ListMetricValuesRequest listMetricValuesRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListMetricValuesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListMetricValuesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listMetricValuesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listMetricValuesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListMetricValues");

            return clientHandler.execute(new ClientExecutionParams<ListMetricValuesRequest, ListMetricValuesResponse>()
                    .withOperationName("ListMetricValues").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listMetricValuesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListMetricValuesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a list of all mitigation actions that match the specified filter criteria.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListMitigationActions</a> action.
     * </p>
     *
     * @param listMitigationActionsRequest
     * @return Result of the ListMitigationActions operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListMitigationActions
     */
    @Override
    public ListMitigationActionsResponse listMitigationActions(ListMitigationActionsRequest listMitigationActionsRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListMitigationActionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListMitigationActionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listMitigationActionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listMitigationActionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListMitigationActions");

            return clientHandler.execute(new ClientExecutionParams<ListMitigationActionsRequest, ListMitigationActionsResponse>()
                    .withOperationName("ListMitigationActions").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listMitigationActionsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListMitigationActionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists OTA updates.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListOTAUpdates</a> action.
     * </p>
     *
     * @param listOtaUpdatesRequest
     * @return Result of the ListOTAUpdates operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListOTAUpdates
     */
    @Override
    public ListOtaUpdatesResponse listOTAUpdates(ListOtaUpdatesRequest listOtaUpdatesRequest) throws InvalidRequestException,
            ThrottlingException, UnauthorizedException, InternalFailureException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListOtaUpdatesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListOtaUpdatesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listOtaUpdatesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listOtaUpdatesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListOTAUpdates");

            return clientHandler.execute(new ClientExecutionParams<ListOtaUpdatesRequest, ListOtaUpdatesResponse>()
                    .withOperationName("ListOTAUpdates").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listOtaUpdatesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListOtaUpdatesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists certificates that are being transferred but not yet accepted.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListOutgoingCertificates</a> action.
     * </p>
     *
     * @param listOutgoingCertificatesRequest
     *        The input to the ListOutgoingCertificates operation.
     * @return Result of the ListOutgoingCertificates operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListOutgoingCertificates
     */
    @Override
    public ListOutgoingCertificatesResponse listOutgoingCertificates(
            ListOutgoingCertificatesRequest listOutgoingCertificatesRequest) throws InvalidRequestException, ThrottlingException,
            UnauthorizedException, ServiceUnavailableException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListOutgoingCertificatesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListOutgoingCertificatesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listOutgoingCertificatesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listOutgoingCertificatesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListOutgoingCertificates");

            return clientHandler
                    .execute(new ClientExecutionParams<ListOutgoingCertificatesRequest, ListOutgoingCertificatesResponse>()
                            .withOperationName("ListOutgoingCertificates").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listOutgoingCertificatesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListOutgoingCertificatesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the software package versions associated to the account.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListPackageVersions</a> action.
     * </p>
     *
     * @param listPackageVersionsRequest
     * @return Result of the ListPackageVersions operation returned by the service.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ValidationException
     *         The request is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListPackageVersions
     */
    @Override
    public ListPackageVersionsResponse listPackageVersions(ListPackageVersionsRequest listPackageVersionsRequest)
            throws ThrottlingException, InternalServerException, ValidationException, AwsServiceException, SdkClientException,
            IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListPackageVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListPackageVersionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listPackageVersionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listPackageVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListPackageVersions");

            return clientHandler.execute(new ClientExecutionParams<ListPackageVersionsRequest, ListPackageVersionsResponse>()
                    .withOperationName("ListPackageVersions").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listPackageVersionsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListPackageVersionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the software packages associated to the account.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListPackages</a> action.
     * </p>
     *
     * @param listPackagesRequest
     * @return Result of the ListPackages operation returned by the service.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ValidationException
     *         The request is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListPackages
     */
    @Override
    public ListPackagesResponse listPackages(ListPackagesRequest listPackagesRequest) throws ThrottlingException,
            InternalServerException, ValidationException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListPackagesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListPackagesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listPackagesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listPackagesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListPackages");

            return clientHandler.execute(new ClientExecutionParams<ListPackagesRequest, ListPackagesResponse>()
                    .withOperationName("ListPackages").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listPackagesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListPackagesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists your policies.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListPolicies</a> action.
     * </p>
     *
     * @param listPoliciesRequest
     *        The input for the ListPolicies operation.
     * @return Result of the ListPolicies operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListPolicies
     */
    @Override
    public ListPoliciesResponse listPolicies(ListPoliciesRequest listPoliciesRequest) throws InvalidRequestException,
            ThrottlingException, UnauthorizedException, ServiceUnavailableException, InternalFailureException,
            AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListPoliciesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListPoliciesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listPoliciesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listPoliciesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListPolicies");

            return clientHandler.execute(new ClientExecutionParams<ListPoliciesRequest, ListPoliciesResponse>()
                    .withOperationName("ListPolicies").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listPoliciesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListPoliciesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the versions of the specified policy and identifies the default version.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListPolicyVersions</a> action.
     * </p>
     *
     * @param listPolicyVersionsRequest
     *        The input for the ListPolicyVersions operation.
     * @return Result of the ListPolicyVersions operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListPolicyVersions
     */
    @Override
    public ListPolicyVersionsResponse listPolicyVersions(ListPolicyVersionsRequest listPolicyVersionsRequest)
            throws ResourceNotFoundException, InvalidRequestException, ThrottlingException, UnauthorizedException,
            ServiceUnavailableException, InternalFailureException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListPolicyVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListPolicyVersionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listPolicyVersionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listPolicyVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListPolicyVersions");

            return clientHandler.execute(new ClientExecutionParams<ListPolicyVersionsRequest, ListPolicyVersionsResponse>()
                    .withOperationName("ListPolicyVersions").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listPolicyVersionsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListPolicyVersionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the things associated with the specified principal. A principal can be X.509 certificates, IAM users,
     * groups, and roles, Amazon Cognito identities or federated identities.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListPrincipalThings</a> action.
     * </p>
     *
     * @param listPrincipalThingsRequest
     *        The input for the ListPrincipalThings operation.
     * @return Result of the ListPrincipalThings operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListPrincipalThings
     */
    @Override
    public ListPrincipalThingsResponse listPrincipalThings(ListPrincipalThingsRequest listPrincipalThingsRequest)
            throws InvalidRequestException, ThrottlingException, UnauthorizedException, ServiceUnavailableException,
            InternalFailureException, ResourceNotFoundException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListPrincipalThingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListPrincipalThingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listPrincipalThingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listPrincipalThingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListPrincipalThings");

            return clientHandler.execute(new ClientExecutionParams<ListPrincipalThingsRequest, ListPrincipalThingsResponse>()
                    .withOperationName("ListPrincipalThings").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listPrincipalThingsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListPrincipalThingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * A list of provisioning template versions.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListProvisioningTemplateVersions</a> action.
     * </p>
     *
     * @param listProvisioningTemplateVersionsRequest
     * @return Result of the ListProvisioningTemplateVersions operation returned by the service.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListProvisioningTemplateVersions
     */
    @Override
    public ListProvisioningTemplateVersionsResponse listProvisioningTemplateVersions(
            ListProvisioningTemplateVersionsRequest listProvisioningTemplateVersionsRequest) throws InternalFailureException,
            InvalidRequestException, ThrottlingException, ResourceNotFoundException, UnauthorizedException, AwsServiceException,
            SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListProvisioningTemplateVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListProvisioningTemplateVersionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listProvisioningTemplateVersionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listProvisioningTemplateVersionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListProvisioningTemplateVersions");

            return clientHandler
                    .execute(new ClientExecutionParams<ListProvisioningTemplateVersionsRequest, ListProvisioningTemplateVersionsResponse>()
                            .withOperationName("ListProvisioningTemplateVersions").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listProvisioningTemplateVersionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListProvisioningTemplateVersionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the provisioning templates in your Amazon Web Services account.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListProvisioningTemplates</a> action.
     * </p>
     *
     * @param listProvisioningTemplatesRequest
     * @return Result of the ListProvisioningTemplates operation returned by the service.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListProvisioningTemplates
     */
    @Override
    public ListProvisioningTemplatesResponse listProvisioningTemplates(
            ListProvisioningTemplatesRequest listProvisioningTemplatesRequest) throws InternalFailureException,
            InvalidRequestException, ThrottlingException, UnauthorizedException, AwsServiceException, SdkClientException,
            IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListProvisioningTemplatesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListProvisioningTemplatesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listProvisioningTemplatesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listProvisioningTemplatesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListProvisioningTemplates");

            return clientHandler
                    .execute(new ClientExecutionParams<ListProvisioningTemplatesRequest, ListProvisioningTemplatesResponse>()
                            .withOperationName("ListProvisioningTemplates").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listProvisioningTemplatesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListProvisioningTemplatesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * The related resources of an Audit finding. The following resources can be returned from calling this API:
     * </p>
     * <ul>
     * <li>
     * <p>
     * DEVICE_CERTIFICATE
     * </p>
     * </li>
     * <li>
     * <p>
     * CA_CERTIFICATE
     * </p>
     * </li>
     * <li>
     * <p>
     * IOT_POLICY
     * </p>
     * </li>
     * <li>
     * <p>
     * COGNITO_IDENTITY_POOL
     * </p>
     * </li>
     * <li>
     * <p>
     * CLIENT_ID
     * </p>
     * </li>
     * <li>
     * <p>
     * ACCOUNT_SETTINGS
     * </p>
     * </li>
     * <li>
     * <p>
     * ROLE_ALIAS
     * </p>
     * </li>
     * <li>
     * <p>
     * IAM_ROLE
     * </p>
     * </li>
     * <li>
     * <p>
     * ISSUER_CERTIFICATE
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * This API is similar to DescribeAuditFinding's <a
     * href="https://docs.aws.amazon.com/iot/latest/apireference/API_DescribeAuditFinding.html">RelatedResources</a> but
     * provides pagination and is not limited to 10 resources. When calling <a
     * href="https://docs.aws.amazon.com/iot/latest/apireference/API_DescribeAuditFinding.html">DescribeAuditFinding</a>
     * for the intermediate CA revoked for active device certificates check, RelatedResources will not be populated. You
     * must use this API, ListRelatedResourcesForAuditFinding, to list the certificates.
     * </p>
     * </note>
     *
     * @param listRelatedResourcesForAuditFindingRequest
     * @return Result of the ListRelatedResourcesForAuditFinding operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListRelatedResourcesForAuditFinding
     */
    @Override
    public ListRelatedResourcesForAuditFindingResponse listRelatedResourcesForAuditFinding(
            ListRelatedResourcesForAuditFindingRequest listRelatedResourcesForAuditFindingRequest)
            throws ResourceNotFoundException, InvalidRequestException, ThrottlingException, InternalFailureException,
            AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListRelatedResourcesForAuditFindingResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListRelatedResourcesForAuditFindingResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listRelatedResourcesForAuditFindingRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listRelatedResourcesForAuditFindingRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListRelatedResourcesForAuditFinding");

            return clientHandler
                    .execute(new ClientExecutionParams<ListRelatedResourcesForAuditFindingRequest, ListRelatedResourcesForAuditFindingResponse>()
                            .withOperationName("ListRelatedResourcesForAuditFinding").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listRelatedResourcesForAuditFindingRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListRelatedResourcesForAuditFindingRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the role aliases registered in your account.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListRoleAliases</a> action.
     * </p>
     *
     * @param listRoleAliasesRequest
     * @return Result of the ListRoleAliases operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListRoleAliases
     */
    @Override
    public ListRoleAliasesResponse listRoleAliases(ListRoleAliasesRequest listRoleAliasesRequest) throws InvalidRequestException,
            ThrottlingException, UnauthorizedException, ServiceUnavailableException, InternalFailureException,
            AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListRoleAliasesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListRoleAliasesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listRoleAliasesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listRoleAliasesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListRoleAliases");

            return clientHandler.execute(new ClientExecutionParams<ListRoleAliasesRequest, ListRoleAliasesResponse>()
                    .withOperationName("ListRoleAliases").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listRoleAliasesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListRoleAliasesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all of your scheduled audits.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListScheduledAudits</a> action.
     * </p>
     *
     * @param listScheduledAuditsRequest
     * @return Result of the ListScheduledAudits operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListScheduledAudits
     */
    @Override
    public ListScheduledAuditsResponse listScheduledAudits(ListScheduledAuditsRequest listScheduledAuditsRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListScheduledAuditsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListScheduledAuditsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listScheduledAuditsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listScheduledAuditsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListScheduledAudits");

            return clientHandler.execute(new ClientExecutionParams<ListScheduledAuditsRequest, ListScheduledAuditsResponse>()
                    .withOperationName("ListScheduledAudits").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listScheduledAuditsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListScheduledAuditsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the Device Defender security profiles you've created. You can filter security profiles by dimension or
     * custom metric.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListSecurityProfiles</a> action.
     * </p>
     * <note>
     * <p>
     * <code>dimensionName</code> and <code>metricName</code> cannot be used in the same request.
     * </p>
     * </note>
     *
     * @param listSecurityProfilesRequest
     * @return Result of the ListSecurityProfiles operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListSecurityProfiles
     */
    @Override
    public ListSecurityProfilesResponse listSecurityProfiles(ListSecurityProfilesRequest listSecurityProfilesRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListSecurityProfilesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListSecurityProfilesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listSecurityProfilesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listSecurityProfilesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListSecurityProfiles");

            return clientHandler.execute(new ClientExecutionParams<ListSecurityProfilesRequest, ListSecurityProfilesResponse>()
                    .withOperationName("ListSecurityProfiles").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listSecurityProfilesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListSecurityProfilesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the Device Defender security profiles attached to a target (thing group).
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListSecurityProfilesForTarget</a> action.
     * </p>
     *
     * @param listSecurityProfilesForTargetRequest
     * @return Result of the ListSecurityProfilesForTarget operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListSecurityProfilesForTarget
     */
    @Override
    public ListSecurityProfilesForTargetResponse listSecurityProfilesForTarget(
            ListSecurityProfilesForTargetRequest listSecurityProfilesForTargetRequest) throws InvalidRequestException,
            ThrottlingException, InternalFailureException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListSecurityProfilesForTargetResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListSecurityProfilesForTargetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listSecurityProfilesForTargetRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listSecurityProfilesForTargetRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListSecurityProfilesForTarget");

            return clientHandler
                    .execute(new ClientExecutionParams<ListSecurityProfilesForTargetRequest, ListSecurityProfilesForTargetResponse>()
                            .withOperationName("ListSecurityProfilesForTarget").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listSecurityProfilesForTargetRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListSecurityProfilesForTargetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all of the streams in your Amazon Web Services account.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListStreams</a> action.
     * </p>
     *
     * @param listStreamsRequest
     * @return Result of the ListStreams operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListStreams
     */
    @Override
    public ListStreamsResponse listStreams(ListStreamsRequest listStreamsRequest) throws InvalidRequestException,
            ThrottlingException, UnauthorizedException, ServiceUnavailableException, InternalFailureException,
            AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListStreamsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListStreamsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listStreamsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listStreamsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListStreams");

            return clientHandler.execute(new ClientExecutionParams<ListStreamsRequest, ListStreamsResponse>()
                    .withOperationName("ListStreams").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(listStreamsRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListStreamsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the tags (metadata) you have assigned to the resource.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListTagsForResource</a> action.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListTagsForResource
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws InvalidRequestException, InternalFailureException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListTagsForResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsForResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");

            return clientHandler.execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                    .withOperationName("ListTagsForResource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listTagsForResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * List targets for the specified policy.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListTargetsForPolicy</a> action.
     * </p>
     *
     * @param listTargetsForPolicyRequest
     * @return Result of the ListTargetsForPolicy operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListTargetsForPolicy
     */
    @Override
    public ListTargetsForPolicyResponse listTargetsForPolicy(ListTargetsForPolicyRequest listTargetsForPolicyRequest)
            throws ResourceNotFoundException, InvalidRequestException, ThrottlingException, UnauthorizedException,
            ServiceUnavailableException, InternalFailureException, LimitExceededException, AwsServiceException,
            SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTargetsForPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListTargetsForPolicyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTargetsForPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTargetsForPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTargetsForPolicy");

            return clientHandler.execute(new ClientExecutionParams<ListTargetsForPolicyRequest, ListTargetsForPolicyResponse>()
                    .withOperationName("ListTargetsForPolicy").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listTargetsForPolicyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTargetsForPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the targets (thing groups) associated with a given Device Defender security profile.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListTargetsForSecurityProfile</a> action.
     * </p>
     *
     * @param listTargetsForSecurityProfileRequest
     * @return Result of the ListTargetsForSecurityProfile operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListTargetsForSecurityProfile
     */
    @Override
    public ListTargetsForSecurityProfileResponse listTargetsForSecurityProfile(
            ListTargetsForSecurityProfileRequest listTargetsForSecurityProfileRequest) throws InvalidRequestException,
            ResourceNotFoundException, ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException,
            IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTargetsForSecurityProfileResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListTargetsForSecurityProfileResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTargetsForSecurityProfileRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listTargetsForSecurityProfileRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTargetsForSecurityProfile");

            return clientHandler
                    .execute(new ClientExecutionParams<ListTargetsForSecurityProfileRequest, ListTargetsForSecurityProfileResponse>()
                            .withOperationName("ListTargetsForSecurityProfile").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listTargetsForSecurityProfileRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListTargetsForSecurityProfileRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * List the thing groups in your account.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListThingGroups</a> action.
     * </p>
     *
     * @param listThingGroupsRequest
     * @return Result of the ListThingGroups operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListThingGroups
     */
    @Override
    public ListThingGroupsResponse listThingGroups(ListThingGroupsRequest listThingGroupsRequest) throws InvalidRequestException,
            InternalFailureException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListThingGroupsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListThingGroupsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listThingGroupsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listThingGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListThingGroups");

            return clientHandler.execute(new ClientExecutionParams<ListThingGroupsRequest, ListThingGroupsResponse>()
                    .withOperationName("ListThingGroups").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listThingGroupsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListThingGroupsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * List the thing groups to which the specified thing belongs.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListThingGroupsForThing</a> action.
     * </p>
     *
     * @param listThingGroupsForThingRequest
     * @return Result of the ListThingGroupsForThing operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListThingGroupsForThing
     */
    @Override
    public ListThingGroupsForThingResponse listThingGroupsForThing(ListThingGroupsForThingRequest listThingGroupsForThingRequest)
            throws InvalidRequestException, InternalFailureException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListThingGroupsForThingResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListThingGroupsForThingResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listThingGroupsForThingRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listThingGroupsForThingRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListThingGroupsForThing");

            return clientHandler
                    .execute(new ClientExecutionParams<ListThingGroupsForThingRequest, ListThingGroupsForThingResponse>()
                            .withOperationName("ListThingGroupsForThing").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listThingGroupsForThingRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListThingGroupsForThingRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the principals associated with the specified thing. A principal can be X.509 certificates, IAM users,
     * groups, and roles, Amazon Cognito identities or federated identities.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListThingPrincipals</a> action.
     * </p>
     *
     * @param listThingPrincipalsRequest
     *        The input for the ListThingPrincipal operation.
     * @return Result of the ListThingPrincipals operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListThingPrincipals
     */
    @Override
    public ListThingPrincipalsResponse listThingPrincipals(ListThingPrincipalsRequest listThingPrincipalsRequest)
            throws InvalidRequestException, ThrottlingException, UnauthorizedException, ServiceUnavailableException,
            InternalFailureException, ResourceNotFoundException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListThingPrincipalsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListThingPrincipalsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listThingPrincipalsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listThingPrincipalsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListThingPrincipals");

            return clientHandler.execute(new ClientExecutionParams<ListThingPrincipalsRequest, ListThingPrincipalsResponse>()
                    .withOperationName("ListThingPrincipals").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listThingPrincipalsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListThingPrincipalsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Information about the thing registration tasks.
     * </p>
     *
     * @param listThingRegistrationTaskReportsRequest
     * @return Result of the ListThingRegistrationTaskReports operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListThingRegistrationTaskReports
     */
    @Override
    public ListThingRegistrationTaskReportsResponse listThingRegistrationTaskReports(
            ListThingRegistrationTaskReportsRequest listThingRegistrationTaskReportsRequest) throws InvalidRequestException,
            ThrottlingException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException,
            IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListThingRegistrationTaskReportsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListThingRegistrationTaskReportsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listThingRegistrationTaskReportsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listThingRegistrationTaskReportsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListThingRegistrationTaskReports");

            return clientHandler
                    .execute(new ClientExecutionParams<ListThingRegistrationTaskReportsRequest, ListThingRegistrationTaskReportsResponse>()
                            .withOperationName("ListThingRegistrationTaskReports").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listThingRegistrationTaskReportsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListThingRegistrationTaskReportsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * List bulk thing provisioning tasks.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListThingRegistrationTasks</a> action.
     * </p>
     *
     * @param listThingRegistrationTasksRequest
     * @return Result of the ListThingRegistrationTasks operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListThingRegistrationTasks
     */
    @Override
    public ListThingRegistrationTasksResponse listThingRegistrationTasks(
            ListThingRegistrationTasksRequest listThingRegistrationTasksRequest) throws InvalidRequestException,
            ThrottlingException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException,
            IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListThingRegistrationTasksResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListThingRegistrationTasksResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listThingRegistrationTasksRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listThingRegistrationTasksRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListThingRegistrationTasks");

            return clientHandler
                    .execute(new ClientExecutionParams<ListThingRegistrationTasksRequest, ListThingRegistrationTasksResponse>()
                            .withOperationName("ListThingRegistrationTasks").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listThingRegistrationTasksRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListThingRegistrationTasksRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the existing thing types.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListThingTypes</a> action.
     * </p>
     *
     * @param listThingTypesRequest
     *        The input for the ListThingTypes operation.
     * @return Result of the ListThingTypes operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListThingTypes
     */
    @Override
    public ListThingTypesResponse listThingTypes(ListThingTypesRequest listThingTypesRequest) throws InvalidRequestException,
            ThrottlingException, UnauthorizedException, ServiceUnavailableException, InternalFailureException,
            AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListThingTypesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListThingTypesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listThingTypesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listThingTypesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListThingTypes");

            return clientHandler.execute(new ClientExecutionParams<ListThingTypesRequest, ListThingTypesResponse>()
                    .withOperationName("ListThingTypes").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listThingTypesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListThingTypesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists your things. Use the <b>attributeName</b> and <b>attributeValue</b> parameters to filter your things. For
     * example, calling <code>ListThings</code> with attributeName=Color and attributeValue=Red retrieves all things in
     * the registry that contain an attribute <b>Color</b> with the value <b>Red</b>. For more information, see <a
     * href="https://docs.aws.amazon.com/iot/latest/developerguide/thing-registry.html#list-things">List Things</a> from
     * the <i>Amazon Web Services IoT Core Developer Guide</i>.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListThings</a> action.
     * </p>
     * <note>
     * <p>
     * You will not be charged for calling this API if an <code>Access denied</code> error is returned. You will also
     * not be charged if no attributes or pagination token was provided in request and no pagination token and no
     * results were returned.
     * </p>
     * </note>
     *
     * @param listThingsRequest
     *        The input for the ListThings operation.
     * @return Result of the ListThings operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListThings
     */
    @Override
    public ListThingsResponse listThings(ListThingsRequest listThingsRequest) throws InvalidRequestException,
            ThrottlingException, UnauthorizedException, ServiceUnavailableException, InternalFailureException,
            AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListThingsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListThingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listThingsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listThingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListThings");

            return clientHandler.execute(new ClientExecutionParams<ListThingsRequest, ListThingsResponse>()
                    .withOperationName("ListThings").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(listThingsRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListThingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the things you have added to the given billing group.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListThingsInBillingGroup</a> action.
     * </p>
     *
     * @param listThingsInBillingGroupRequest
     * @return Result of the ListThingsInBillingGroup operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListThingsInBillingGroup
     */
    @Override
    public ListThingsInBillingGroupResponse listThingsInBillingGroup(
            ListThingsInBillingGroupRequest listThingsInBillingGroupRequest) throws InvalidRequestException,
            InternalFailureException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListThingsInBillingGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListThingsInBillingGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listThingsInBillingGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listThingsInBillingGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListThingsInBillingGroup");

            return clientHandler
                    .execute(new ClientExecutionParams<ListThingsInBillingGroupRequest, ListThingsInBillingGroupResponse>()
                            .withOperationName("ListThingsInBillingGroup").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listThingsInBillingGroupRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListThingsInBillingGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the things in the specified group.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListThingsInThingGroup</a> action.
     * </p>
     *
     * @param listThingsInThingGroupRequest
     * @return Result of the ListThingsInThingGroup operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListThingsInThingGroup
     */
    @Override
    public ListThingsInThingGroupResponse listThingsInThingGroup(ListThingsInThingGroupRequest listThingsInThingGroupRequest)
            throws InvalidRequestException, InternalFailureException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListThingsInThingGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListThingsInThingGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listThingsInThingGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listThingsInThingGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListThingsInThingGroup");

            return clientHandler
                    .execute(new ClientExecutionParams<ListThingsInThingGroupRequest, ListThingsInThingGroupResponse>()
                            .withOperationName("ListThingsInThingGroup").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listThingsInThingGroupRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListThingsInThingGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all the topic rule destinations in your Amazon Web Services account.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListTopicRuleDestinations</a> action.
     * </p>
     *
     * @param listTopicRuleDestinationsRequest
     * @return Result of the ListTopicRuleDestinations operation returned by the service.
     * @throws InternalException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListTopicRuleDestinations
     */
    @Override
    public ListTopicRuleDestinationsResponse listTopicRuleDestinations(
            ListTopicRuleDestinationsRequest listTopicRuleDestinationsRequest) throws InternalException, InvalidRequestException,
            ServiceUnavailableException, UnauthorizedException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTopicRuleDestinationsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListTopicRuleDestinationsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTopicRuleDestinationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTopicRuleDestinationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTopicRuleDestinations");

            return clientHandler
                    .execute(new ClientExecutionParams<ListTopicRuleDestinationsRequest, ListTopicRuleDestinationsResponse>()
                            .withOperationName("ListTopicRuleDestinations").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listTopicRuleDestinationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListTopicRuleDestinationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the rules for the specific topic.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListTopicRules</a> action.
     * </p>
     *
     * @param listTopicRulesRequest
     *        The input for the ListTopicRules operation.
     * @return Result of the ListTopicRules operation returned by the service.
     * @throws InternalException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListTopicRules
     */
    @Override
    public ListTopicRulesResponse listTopicRules(ListTopicRulesRequest listTopicRulesRequest) throws InternalException,
            InvalidRequestException, ServiceUnavailableException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTopicRulesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListTopicRulesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTopicRulesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTopicRulesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTopicRules");

            return clientHandler.execute(new ClientExecutionParams<ListTopicRulesRequest, ListTopicRulesResponse>()
                    .withOperationName("ListTopicRules").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listTopicRulesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTopicRulesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists logging levels.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListV2LoggingLevels</a> action.
     * </p>
     *
     * @param listV2LoggingLevelsRequest
     * @return Result of the ListV2LoggingLevels operation returned by the service.
     * @throws InternalException
     *         An unexpected error has occurred.
     * @throws NotConfiguredException
     *         The resource is not configured.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListV2LoggingLevels
     */
    @Override
    public ListV2LoggingLevelsResponse listV2LoggingLevels(ListV2LoggingLevelsRequest listV2LoggingLevelsRequest)
            throws InternalException, NotConfiguredException, InvalidRequestException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListV2LoggingLevelsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListV2LoggingLevelsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listV2LoggingLevelsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listV2LoggingLevelsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListV2LoggingLevels");

            return clientHandler.execute(new ClientExecutionParams<ListV2LoggingLevelsRequest, ListV2LoggingLevelsResponse>()
                    .withOperationName("ListV2LoggingLevels").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listV2LoggingLevelsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListV2LoggingLevelsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the Device Defender security profile violations discovered during the given time period. You can use
     * filters to limit the results to those alerts issued for a particular security profile, behavior, or thing
     * (device).
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListViolationEvents</a> action.
     * </p>
     *
     * @param listViolationEventsRequest
     * @return Result of the ListViolationEvents operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListViolationEvents
     */
    @Override
    public ListViolationEventsResponse listViolationEvents(ListViolationEventsRequest listViolationEventsRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListViolationEventsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListViolationEventsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listViolationEventsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listViolationEventsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListViolationEvents");

            return clientHandler.execute(new ClientExecutionParams<ListViolationEventsRequest, ListViolationEventsResponse>()
                    .withOperationName("ListViolationEvents").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listViolationEventsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListViolationEventsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Set a verification state and provide a description of that verification state on a violation (detect alarm).
     * </p>
     *
     * @param putVerificationStateOnViolationRequest
     * @return Result of the PutVerificationStateOnViolation operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.PutVerificationStateOnViolation
     */
    @Override
    public PutVerificationStateOnViolationResponse putVerificationStateOnViolation(
            PutVerificationStateOnViolationRequest putVerificationStateOnViolationRequest) throws InvalidRequestException,
            ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutVerificationStateOnViolationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, PutVerificationStateOnViolationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putVerificationStateOnViolationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                putVerificationStateOnViolationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutVerificationStateOnViolation");

            return clientHandler
                    .execute(new ClientExecutionParams<PutVerificationStateOnViolationRequest, PutVerificationStateOnViolationResponse>()
                            .withOperationName("PutVerificationStateOnViolation").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(putVerificationStateOnViolationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new PutVerificationStateOnViolationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Registers a CA certificate with Amazon Web Services IoT Core. There is no limit to the number of CA certificates
     * you can register in your Amazon Web Services account. You can register up to 10 CA certificates with the same
     * <code>CA subject field</code> per Amazon Web Services account.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >RegisterCACertificate</a> action.
     * </p>
     *
     * @param registerCaCertificateRequest
     *        The input to the RegisterCACertificate operation.
     * @return Result of the RegisterCACertificate operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws RegistrationCodeValidationException
     *         The registration code is invalid.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws CertificateValidationException
     *         The certificate is invalid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.RegisterCACertificate
     */
    @Override
    public RegisterCaCertificateResponse registerCACertificate(RegisterCaCertificateRequest registerCaCertificateRequest)
            throws ResourceNotFoundException, ResourceAlreadyExistsException, RegistrationCodeValidationException,
            InvalidRequestException, CertificateValidationException, ThrottlingException, LimitExceededException,
            UnauthorizedException, ServiceUnavailableException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<RegisterCaCertificateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, RegisterCaCertificateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(registerCaCertificateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, registerCaCertificateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RegisterCACertificate");

            return clientHandler.execute(new ClientExecutionParams<RegisterCaCertificateRequest, RegisterCaCertificateResponse>()
                    .withOperationName("RegisterCACertificate").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(registerCaCertificateRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new RegisterCaCertificateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Registers a device certificate with IoT in the same <a href=
     * "https://docs.aws.amazon.com/iot/latest/apireference/API_CertificateDescription.html#iot-Type-CertificateDescription-certificateMode"
     * >certificate mode</a> as the signing CA. If you have more than one CA certificate that has the same subject
     * field, you must specify the CA certificate that was used to sign the device certificate being registered.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >RegisterCertificate</a> action.
     * </p>
     *
     * @param registerCertificateRequest
     *        The input to the RegisterCertificate operation.
     * @return Result of the RegisterCertificate operation returned by the service.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws CertificateValidationException
     *         The certificate is invalid.
     * @throws CertificateStateException
     *         The certificate operation is not allowed.
     * @throws CertificateConflictException
     *         Unable to verify the CA certificate used to sign the device certificate you are attempting to register.
     *         This is happens when you have registered more than one CA certificate that has the same subject field and
     *         public key.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.RegisterCertificate
     */
    @Override
    public RegisterCertificateResponse registerCertificate(RegisterCertificateRequest registerCertificateRequest)
            throws ResourceAlreadyExistsException, InvalidRequestException, CertificateValidationException,
            CertificateStateException, CertificateConflictException, ThrottlingException, UnauthorizedException,
            ServiceUnavailableException, InternalFailureException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<RegisterCertificateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, RegisterCertificateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(registerCertificateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, registerCertificateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RegisterCertificate");

            return clientHandler.execute(new ClientExecutionParams<RegisterCertificateRequest, RegisterCertificateResponse>()
                    .withOperationName("RegisterCertificate").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(registerCertificateRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new RegisterCertificateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Register a certificate that does not have a certificate authority (CA). For supported certificates, consult <a
     * href="https://docs.aws.amazon.com/iot/latest/developerguide/x509-client-certs.html#x509-cert-algorithms">
     * Certificate signing algorithms supported by IoT</a>.
     * </p>
     *
     * @param registerCertificateWithoutCaRequest
     * @return Result of the RegisterCertificateWithoutCA operation returned by the service.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws CertificateStateException
     *         The certificate operation is not allowed.
     * @throws CertificateValidationException
     *         The certificate is invalid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.RegisterCertificateWithoutCA
     */
    @Override
    public RegisterCertificateWithoutCaResponse registerCertificateWithoutCA(
            RegisterCertificateWithoutCaRequest registerCertificateWithoutCaRequest) throws ResourceAlreadyExistsException,
            InvalidRequestException, CertificateStateException, CertificateValidationException, ThrottlingException,
            UnauthorizedException, ServiceUnavailableException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<RegisterCertificateWithoutCaResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, RegisterCertificateWithoutCaResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(registerCertificateWithoutCaRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, registerCertificateWithoutCaRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RegisterCertificateWithoutCA");

            return clientHandler
                    .execute(new ClientExecutionParams<RegisterCertificateWithoutCaRequest, RegisterCertificateWithoutCaResponse>()
                            .withOperationName("RegisterCertificateWithoutCA").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(registerCertificateWithoutCaRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new RegisterCertificateWithoutCaRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Provisions a thing in the device registry. RegisterThing calls other IoT control plane APIs. These calls might
     * exceed your account level <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_iot"> IoT Throttling
     * Limits</a> and cause throttle errors. Please contact <a href="https://console.aws.amazon.com/support/home">Amazon
     * Web Services Customer Support</a> to raise your throttling limits if necessary.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >RegisterThing</a> action.
     * </p>
     *
     * @param registerThingRequest
     * @return Result of the RegisterThing operation returned by the service.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ConflictingResourceUpdateException
     *         A conflicting resource update exception. This exception is thrown when two pending updates cause a
     *         conflict.
     * @throws ResourceRegistrationFailureException
     *         The resource registration failed.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.RegisterThing
     */
    @Override
    public RegisterThingResponse registerThing(RegisterThingRequest registerThingRequest) throws InternalFailureException,
            ServiceUnavailableException, InvalidRequestException, UnauthorizedException, ThrottlingException,
            ConflictingResourceUpdateException, ResourceRegistrationFailureException, AwsServiceException, SdkClientException,
            IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<RegisterThingResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                RegisterThingResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(registerThingRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, registerThingRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RegisterThing");

            return clientHandler.execute(new ClientExecutionParams<RegisterThingRequest, RegisterThingResponse>()
                    .withOperationName("RegisterThing").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(registerThingRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new RegisterThingRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Rejects a pending certificate transfer. After IoT rejects a certificate transfer, the certificate status changes
     * from <b>PENDING_TRANSFER</b> to <b>INACTIVE</b>.
     * </p>
     * <p>
     * To check for pending certificate transfers, call <a>ListCertificates</a> to enumerate your certificates.
     * </p>
     * <p>
     * This operation can only be called by the transfer destination. After it is called, the certificate will be
     * returned to the source's account in the INACTIVE state.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >RejectCertificateTransfer</a> action.
     * </p>
     *
     * @param rejectCertificateTransferRequest
     *        The input for the RejectCertificateTransfer operation.
     * @return Result of the RejectCertificateTransfer operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws TransferAlreadyCompletedException
     *         You can't revert the certificate transfer because the transfer is already complete.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.RejectCertificateTransfer
     */
    @Override
    public RejectCertificateTransferResponse rejectCertificateTransfer(
            RejectCertificateTransferRequest rejectCertificateTransferRequest) throws ResourceNotFoundException,
            TransferAlreadyCompletedException, InvalidRequestException, ThrottlingException, UnauthorizedException,
            ServiceUnavailableException, InternalFailureException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<RejectCertificateTransferResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, RejectCertificateTransferResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(rejectCertificateTransferRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, rejectCertificateTransferRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RejectCertificateTransfer");

            return clientHandler
                    .execute(new ClientExecutionParams<RejectCertificateTransferRequest, RejectCertificateTransferResponse>()
                            .withOperationName("RejectCertificateTransfer").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(rejectCertificateTransferRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new RejectCertificateTransferRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes the given thing from the billing group.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >RemoveThingFromBillingGroup</a> action.
     * </p>
     * <note>
     * <p>
     * This call is asynchronous. It might take several seconds for the detachment to propagate.
     * </p>
     * </note>
     *
     * @param removeThingFromBillingGroupRequest
     * @return Result of the RemoveThingFromBillingGroup operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.RemoveThingFromBillingGroup
     */
    @Override
    public RemoveThingFromBillingGroupResponse removeThingFromBillingGroup(
            RemoveThingFromBillingGroupRequest removeThingFromBillingGroupRequest) throws InvalidRequestException,
            ThrottlingException, InternalFailureException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<RemoveThingFromBillingGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, RemoveThingFromBillingGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(removeThingFromBillingGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, removeThingFromBillingGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RemoveThingFromBillingGroup");

            return clientHandler
                    .execute(new ClientExecutionParams<RemoveThingFromBillingGroupRequest, RemoveThingFromBillingGroupResponse>()
                            .withOperationName("RemoveThingFromBillingGroup").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(removeThingFromBillingGroupRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new RemoveThingFromBillingGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Remove the specified thing from the specified group.
     * </p>
     * <p>
     * You must specify either a <code>thingGroupArn</code> or a <code>thingGroupName</code> to identify the thing group
     * and either a <code>thingArn</code> or a <code>thingName</code> to identify the thing to remove from the thing
     * group.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >RemoveThingFromThingGroup</a> action.
     * </p>
     *
     * @param removeThingFromThingGroupRequest
     * @return Result of the RemoveThingFromThingGroup operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.RemoveThingFromThingGroup
     */
    @Override
    public RemoveThingFromThingGroupResponse removeThingFromThingGroup(
            RemoveThingFromThingGroupRequest removeThingFromThingGroupRequest) throws InvalidRequestException,
            ThrottlingException, InternalFailureException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<RemoveThingFromThingGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, RemoveThingFromThingGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(removeThingFromThingGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, removeThingFromThingGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RemoveThingFromThingGroup");

            return clientHandler
                    .execute(new ClientExecutionParams<RemoveThingFromThingGroupRequest, RemoveThingFromThingGroupResponse>()
                            .withOperationName("RemoveThingFromThingGroup").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(removeThingFromThingGroupRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new RemoveThingFromThingGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Replaces the rule. You must specify all parameters for the new rule. Creating rules is an administrator-level
     * action. Any user who has permission to create rules will be able to access data processed by the rule.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ReplaceTopicRule</a> action.
     * </p>
     *
     * @param replaceTopicRuleRequest
     *        The input for the ReplaceTopicRule operation.
     * @return Result of the ReplaceTopicRule operation returned by the service.
     * @throws SqlParseException
     *         The Rule-SQL expression can't be parsed correctly.
     * @throws InternalException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ConflictingResourceUpdateException
     *         A conflicting resource update exception. This exception is thrown when two pending updates cause a
     *         conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ReplaceTopicRule
     */
    @Override
    public ReplaceTopicRuleResponse replaceTopicRule(ReplaceTopicRuleRequest replaceTopicRuleRequest) throws SqlParseException,
            InternalException, InvalidRequestException, ServiceUnavailableException, UnauthorizedException,
            ConflictingResourceUpdateException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ReplaceTopicRuleResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ReplaceTopicRuleResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(replaceTopicRuleRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, replaceTopicRuleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ReplaceTopicRule");

            return clientHandler.execute(new ClientExecutionParams<ReplaceTopicRuleRequest, ReplaceTopicRuleResponse>()
                    .withOperationName("ReplaceTopicRule").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(replaceTopicRuleRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ReplaceTopicRuleRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * The query search index.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >SearchIndex</a> action.
     * </p>
     *
     * @param searchIndexRequest
     * @return Result of the SearchIndex operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidQueryException
     *         The query is invalid.
     * @throws IndexNotReadyException
     *         The index is not ready.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.SearchIndex
     */
    @Override
    public SearchIndexResponse searchIndex(SearchIndexRequest searchIndexRequest) throws InvalidRequestException,
            ThrottlingException, UnauthorizedException, ServiceUnavailableException, InternalFailureException,
            ResourceNotFoundException, InvalidQueryException, IndexNotReadyException, AwsServiceException, SdkClientException,
            IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<SearchIndexResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                SearchIndexResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(searchIndexRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, searchIndexRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SearchIndex");

            return clientHandler.execute(new ClientExecutionParams<SearchIndexRequest, SearchIndexResponse>()
                    .withOperationName("SearchIndex").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(searchIndexRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new SearchIndexRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Sets the default authorizer. This will be used if a websocket connection is made without specifying an
     * authorizer.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >SetDefaultAuthorizer</a> action.
     * </p>
     *
     * @param setDefaultAuthorizerRequest
     * @return Result of the SetDefaultAuthorizer operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.SetDefaultAuthorizer
     */
    @Override
    public SetDefaultAuthorizerResponse setDefaultAuthorizer(SetDefaultAuthorizerRequest setDefaultAuthorizerRequest)
            throws ResourceNotFoundException, InvalidRequestException, ThrottlingException, UnauthorizedException,
            ServiceUnavailableException, InternalFailureException, ResourceAlreadyExistsException, AwsServiceException,
            SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<SetDefaultAuthorizerResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, SetDefaultAuthorizerResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(setDefaultAuthorizerRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, setDefaultAuthorizerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SetDefaultAuthorizer");

            return clientHandler.execute(new ClientExecutionParams<SetDefaultAuthorizerRequest, SetDefaultAuthorizerResponse>()
                    .withOperationName("SetDefaultAuthorizer").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(setDefaultAuthorizerRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new SetDefaultAuthorizerRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Sets the specified version of the specified policy as the policy's default (operative) version. This action
     * affects all certificates to which the policy is attached. To list the principals the policy is attached to, use
     * the <a>ListPrincipalPolicies</a> action.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >SetDefaultPolicyVersion</a> action.
     * </p>
     *
     * @param setDefaultPolicyVersionRequest
     *        The input for the SetDefaultPolicyVersion operation.
     * @return Result of the SetDefaultPolicyVersion operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.SetDefaultPolicyVersion
     */
    @Override
    public SetDefaultPolicyVersionResponse setDefaultPolicyVersion(SetDefaultPolicyVersionRequest setDefaultPolicyVersionRequest)
            throws ResourceNotFoundException, InvalidRequestException, ThrottlingException, UnauthorizedException,
            ServiceUnavailableException, InternalFailureException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<SetDefaultPolicyVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, SetDefaultPolicyVersionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(setDefaultPolicyVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, setDefaultPolicyVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SetDefaultPolicyVersion");

            return clientHandler
                    .execute(new ClientExecutionParams<SetDefaultPolicyVersionRequest, SetDefaultPolicyVersionResponse>()
                            .withOperationName("SetDefaultPolicyVersion").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(setDefaultPolicyVersionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new SetDefaultPolicyVersionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Sets the logging options.
     * </p>
     * <p>
     * NOTE: use of this command is not recommended. Use <code>SetV2LoggingOptions</code> instead.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >SetLoggingOptions</a> action.
     * </p>
     *
     * @param setLoggingOptionsRequest
     *        The input for the SetLoggingOptions operation.
     * @return Result of the SetLoggingOptions operation returned by the service.
     * @throws InternalException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.SetLoggingOptions
     */
    @Override
    public SetLoggingOptionsResponse setLoggingOptions(SetLoggingOptionsRequest setLoggingOptionsRequest)
            throws InternalException, InvalidRequestException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<SetLoggingOptionsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                SetLoggingOptionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(setLoggingOptionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, setLoggingOptionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SetLoggingOptions");

            return clientHandler.execute(new ClientExecutionParams<SetLoggingOptionsRequest, SetLoggingOptionsResponse>()
                    .withOperationName("SetLoggingOptions").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(setLoggingOptionsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new SetLoggingOptionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Sets the logging level.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >SetV2LoggingLevel</a> action.
     * </p>
     *
     * @param setV2LoggingLevelRequest
     * @return Result of the SetV2LoggingLevel operation returned by the service.
     * @throws InternalException
     *         An unexpected error has occurred.
     * @throws NotConfiguredException
     *         The resource is not configured.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.SetV2LoggingLevel
     */
    @Override
    public SetV2LoggingLevelResponse setV2LoggingLevel(SetV2LoggingLevelRequest setV2LoggingLevelRequest)
            throws InternalException, NotConfiguredException, InvalidRequestException, ServiceUnavailableException,
            LimitExceededException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<SetV2LoggingLevelResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                SetV2LoggingLevelResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(setV2LoggingLevelRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, setV2LoggingLevelRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SetV2LoggingLevel");

            return clientHandler.execute(new ClientExecutionParams<SetV2LoggingLevelRequest, SetV2LoggingLevelResponse>()
                    .withOperationName("SetV2LoggingLevel").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(setV2LoggingLevelRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new SetV2LoggingLevelRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Sets the logging options for the V2 logging service.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >SetV2LoggingOptions</a> action.
     * </p>
     *
     * @param setV2LoggingOptionsRequest
     * @return Result of the SetV2LoggingOptions operation returned by the service.
     * @throws InternalException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.SetV2LoggingOptions
     */
    @Override
    public SetV2LoggingOptionsResponse setV2LoggingOptions(SetV2LoggingOptionsRequest setV2LoggingOptionsRequest)
            throws InternalException, InvalidRequestException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<SetV2LoggingOptionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, SetV2LoggingOptionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(setV2LoggingOptionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, setV2LoggingOptionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SetV2LoggingOptions");

            return clientHandler.execute(new ClientExecutionParams<SetV2LoggingOptionsRequest, SetV2LoggingOptionsResponse>()
                    .withOperationName("SetV2LoggingOptions").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(setV2LoggingOptionsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new SetV2LoggingOptionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Starts a task that applies a set of mitigation actions to the specified target.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >StartAuditMitigationActionsTask</a> action.
     * </p>
     *
     * @param startAuditMitigationActionsTaskRequest
     * @return Result of the StartAuditMitigationActionsTask operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws TaskAlreadyExistsException
     *         This exception occurs if you attempt to start a task with the same task-id as an existing task but with a
     *         different clientRequestToken.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.StartAuditMitigationActionsTask
     */
    @Override
    public StartAuditMitigationActionsTaskResponse startAuditMitigationActionsTask(
            StartAuditMitigationActionsTaskRequest startAuditMitigationActionsTaskRequest) throws InvalidRequestException,
            TaskAlreadyExistsException, LimitExceededException, ThrottlingException, InternalFailureException,
            AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartAuditMitigationActionsTaskResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StartAuditMitigationActionsTaskResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startAuditMitigationActionsTaskRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                startAuditMitigationActionsTaskRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartAuditMitigationActionsTask");

            return clientHandler
                    .execute(new ClientExecutionParams<StartAuditMitigationActionsTaskRequest, StartAuditMitigationActionsTaskResponse>()
                            .withOperationName("StartAuditMitigationActionsTask").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(startAuditMitigationActionsTaskRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new StartAuditMitigationActionsTaskRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Starts a Device Defender ML Detect mitigation actions task.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >StartDetectMitigationActionsTask</a> action.
     * </p>
     *
     * @param startDetectMitigationActionsTaskRequest
     * @return Result of the StartDetectMitigationActionsTask operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws TaskAlreadyExistsException
     *         This exception occurs if you attempt to start a task with the same task-id as an existing task but with a
     *         different clientRequestToken.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.StartDetectMitigationActionsTask
     */
    @Override
    public StartDetectMitigationActionsTaskResponse startDetectMitigationActionsTask(
            StartDetectMitigationActionsTaskRequest startDetectMitigationActionsTaskRequest) throws InvalidRequestException,
            TaskAlreadyExistsException, LimitExceededException, ThrottlingException, InternalFailureException,
            AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartDetectMitigationActionsTaskResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StartDetectMitigationActionsTaskResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startDetectMitigationActionsTaskRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                startDetectMitigationActionsTaskRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartDetectMitigationActionsTask");

            return clientHandler
                    .execute(new ClientExecutionParams<StartDetectMitigationActionsTaskRequest, StartDetectMitigationActionsTaskResponse>()
                            .withOperationName("StartDetectMitigationActionsTask").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(startDetectMitigationActionsTaskRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new StartDetectMitigationActionsTaskRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Starts an on-demand Device Defender audit.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >StartOnDemandAuditTask</a> action.
     * </p>
     *
     * @param startOnDemandAuditTaskRequest
     * @return Result of the StartOnDemandAuditTask operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.StartOnDemandAuditTask
     */
    @Override
    public StartOnDemandAuditTaskResponse startOnDemandAuditTask(StartOnDemandAuditTaskRequest startOnDemandAuditTaskRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, LimitExceededException,
            AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartOnDemandAuditTaskResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StartOnDemandAuditTaskResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startOnDemandAuditTaskRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startOnDemandAuditTaskRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartOnDemandAuditTask");

            return clientHandler
                    .execute(new ClientExecutionParams<StartOnDemandAuditTaskRequest, StartOnDemandAuditTaskResponse>()
                            .withOperationName("StartOnDemandAuditTask").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(startOnDemandAuditTaskRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new StartOnDemandAuditTaskRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a bulk thing provisioning task.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >StartThingRegistrationTask</a> action.
     * </p>
     *
     * @param startThingRegistrationTaskRequest
     * @return Result of the StartThingRegistrationTask operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.StartThingRegistrationTask
     */
    @Override
    public StartThingRegistrationTaskResponse startThingRegistrationTask(
            StartThingRegistrationTaskRequest startThingRegistrationTaskRequest) throws InvalidRequestException,
            ThrottlingException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException,
            IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartThingRegistrationTaskResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StartThingRegistrationTaskResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startThingRegistrationTaskRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startThingRegistrationTaskRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartThingRegistrationTask");

            return clientHandler
                    .execute(new ClientExecutionParams<StartThingRegistrationTaskRequest, StartThingRegistrationTaskResponse>()
                            .withOperationName("StartThingRegistrationTask").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(startThingRegistrationTaskRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new StartThingRegistrationTaskRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Cancels a bulk thing provisioning task.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >StopThingRegistrationTask</a> action.
     * </p>
     *
     * @param stopThingRegistrationTaskRequest
     * @return Result of the StopThingRegistrationTask operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.StopThingRegistrationTask
     */
    @Override
    public StopThingRegistrationTaskResponse stopThingRegistrationTask(
            StopThingRegistrationTaskRequest stopThingRegistrationTaskRequest) throws InvalidRequestException,
            ThrottlingException, UnauthorizedException, InternalFailureException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StopThingRegistrationTaskResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StopThingRegistrationTaskResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(stopThingRegistrationTaskRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopThingRegistrationTaskRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopThingRegistrationTask");

            return clientHandler
                    .execute(new ClientExecutionParams<StopThingRegistrationTaskRequest, StopThingRegistrationTaskResponse>()
                            .withOperationName("StopThingRegistrationTask").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(stopThingRegistrationTaskRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new StopThingRegistrationTaskRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Adds to or modifies the tags of the given resource. Tags are metadata which can be used to manage a resource.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >TagResource</a> action.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.TagResource
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InvalidRequestException,
            InternalFailureException, ResourceNotFoundException, ThrottlingException, LimitExceededException,
            AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                TagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");

            return clientHandler.execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                    .withOperationName("TagResource").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(tagResourceRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new TagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Tests if a specified principal is authorized to perform an IoT action on a specified resource. Use this to test
     * and debug the authorization behavior of devices that connect to the IoT device gateway.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >TestAuthorization</a> action.
     * </p>
     *
     * @param testAuthorizationRequest
     * @return Result of the TestAuthorization operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.TestAuthorization
     */
    @Override
    public TestAuthorizationResponse testAuthorization(TestAuthorizationRequest testAuthorizationRequest)
            throws ResourceNotFoundException, InvalidRequestException, ThrottlingException, UnauthorizedException,
            ServiceUnavailableException, InternalFailureException, LimitExceededException, AwsServiceException,
            SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<TestAuthorizationResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                TestAuthorizationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(testAuthorizationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, testAuthorizationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TestAuthorization");

            return clientHandler.execute(new ClientExecutionParams<TestAuthorizationRequest, TestAuthorizationResponse>()
                    .withOperationName("TestAuthorization").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(testAuthorizationRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new TestAuthorizationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Tests a custom authorization behavior by invoking a specified custom authorizer. Use this to test and debug the
     * custom authorization behavior of devices that connect to the IoT device gateway.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >TestInvokeAuthorizer</a> action.
     * </p>
     *
     * @param testInvokeAuthorizerRequest
     * @return Result of the TestInvokeAuthorizer operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws InvalidResponseException
     *         The response is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.TestInvokeAuthorizer
     */
    @Override
    public TestInvokeAuthorizerResponse testInvokeAuthorizer(TestInvokeAuthorizerRequest testInvokeAuthorizerRequest)
            throws ResourceNotFoundException, InvalidRequestException, ThrottlingException, UnauthorizedException,
            ServiceUnavailableException, InternalFailureException, InvalidResponseException, AwsServiceException,
            SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<TestInvokeAuthorizerResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, TestInvokeAuthorizerResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(testInvokeAuthorizerRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, testInvokeAuthorizerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TestInvokeAuthorizer");

            return clientHandler.execute(new ClientExecutionParams<TestInvokeAuthorizerRequest, TestInvokeAuthorizerResponse>()
                    .withOperationName("TestInvokeAuthorizer").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(testInvokeAuthorizerRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new TestInvokeAuthorizerRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Transfers the specified certificate to the specified Amazon Web Services account.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >TransferCertificate</a> action.
     * </p>
     * <p>
     * You can cancel the transfer until it is acknowledged by the recipient.
     * </p>
     * <p>
     * No notification is sent to the transfer destination's account. It is up to the caller to notify the transfer
     * target.
     * </p>
     * <p>
     * The certificate being transferred must not be in the ACTIVE state. You can use the <a>UpdateCertificate</a>
     * action to deactivate it.
     * </p>
     * <p>
     * The certificate must not have any policies attached to it. You can use the <a>DetachPolicy</a> action to detach
     * them.
     * </p>
     *
     * @param transferCertificateRequest
     *        The input for the TransferCertificate operation.
     * @return Result of the TransferCertificate operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws CertificateStateException
     *         The certificate operation is not allowed.
     * @throws TransferConflictException
     *         You can't transfer the certificate because authorization policies are still attached.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.TransferCertificate
     */
    @Override
    public TransferCertificateResponse transferCertificate(TransferCertificateRequest transferCertificateRequest)
            throws InvalidRequestException, ResourceNotFoundException, CertificateStateException, TransferConflictException,
            ThrottlingException, UnauthorizedException, ServiceUnavailableException, InternalFailureException,
            AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<TransferCertificateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, TransferCertificateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(transferCertificateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, transferCertificateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TransferCertificate");

            return clientHandler.execute(new ClientExecutionParams<TransferCertificateRequest, TransferCertificateResponse>()
                    .withOperationName("TransferCertificate").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(transferCertificateRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new TransferCertificateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes the given tags (metadata) from the resource.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >UntagResource</a> action.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.UntagResource
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InvalidRequestException,
            InternalFailureException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UntagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");

            return clientHandler.execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                    .withOperationName("UntagResource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(untagResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Configures or reconfigures the Device Defender audit settings for this account. Settings include how audit
     * notifications are sent and which audit checks are enabled or disabled.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >UpdateAccountAuditConfiguration</a> action.
     * </p>
     *
     * @param updateAccountAuditConfigurationRequest
     * @return Result of the UpdateAccountAuditConfiguration operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.UpdateAccountAuditConfiguration
     */
    @Override
    public UpdateAccountAuditConfigurationResponse updateAccountAuditConfiguration(
            UpdateAccountAuditConfigurationRequest updateAccountAuditConfigurationRequest) throws InvalidRequestException,
            ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateAccountAuditConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateAccountAuditConfigurationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateAccountAuditConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateAccountAuditConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAccountAuditConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateAccountAuditConfigurationRequest, UpdateAccountAuditConfigurationResponse>()
                            .withOperationName("UpdateAccountAuditConfiguration").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(updateAccountAuditConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateAccountAuditConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a Device Defender audit suppression.
     * </p>
     *
     * @param updateAuditSuppressionRequest
     * @return Result of the UpdateAuditSuppression operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.UpdateAuditSuppression
     */
    @Override
    public UpdateAuditSuppressionResponse updateAuditSuppression(UpdateAuditSuppressionRequest updateAuditSuppressionRequest)
            throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, InternalFailureException,
            AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateAuditSuppressionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateAuditSuppressionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateAuditSuppressionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateAuditSuppressionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAuditSuppression");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateAuditSuppressionRequest, UpdateAuditSuppressionResponse>()
                            .withOperationName("UpdateAuditSuppression").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(updateAuditSuppressionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateAuditSuppressionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates an authorizer.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >UpdateAuthorizer</a> action.
     * </p>
     *
     * @param updateAuthorizerRequest
     * @return Result of the UpdateAuthorizer operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.UpdateAuthorizer
     */
    @Override
    public UpdateAuthorizerResponse updateAuthorizer(UpdateAuthorizerRequest updateAuthorizerRequest)
            throws ResourceNotFoundException, InvalidRequestException, LimitExceededException, ThrottlingException,
            UnauthorizedException, ServiceUnavailableException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateAuthorizerResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateAuthorizerResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateAuthorizerRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateAuthorizerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAuthorizer");

            return clientHandler.execute(new ClientExecutionParams<UpdateAuthorizerRequest, UpdateAuthorizerResponse>()
                    .withOperationName("UpdateAuthorizer").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateAuthorizerRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateAuthorizerRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates information about the billing group.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >UpdateBillingGroup</a> action.
     * </p>
     *
     * @param updateBillingGroupRequest
     * @return Result of the UpdateBillingGroup operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws VersionConflictException
     *         An exception thrown when the version of an entity specified with the <code>expectedVersion</code>
     *         parameter does not match the latest version in the system.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.UpdateBillingGroup
     */
    @Override
    public UpdateBillingGroupResponse updateBillingGroup(UpdateBillingGroupRequest updateBillingGroupRequest)
            throws InvalidRequestException, VersionConflictException, ThrottlingException, InternalFailureException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateBillingGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateBillingGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateBillingGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateBillingGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateBillingGroup");

            return clientHandler.execute(new ClientExecutionParams<UpdateBillingGroupRequest, UpdateBillingGroupResponse>()
                    .withOperationName("UpdateBillingGroup").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateBillingGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateBillingGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a registered CA certificate.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >UpdateCACertificate</a> action.
     * </p>
     *
     * @param updateCaCertificateRequest
     *        The input to the UpdateCACertificate operation.
     * @return Result of the UpdateCACertificate operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.UpdateCACertificate
     */
    @Override
    public UpdateCaCertificateResponse updateCACertificate(UpdateCaCertificateRequest updateCaCertificateRequest)
            throws ResourceNotFoundException, InvalidRequestException, ThrottlingException, UnauthorizedException,
            ServiceUnavailableException, InternalFailureException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateCaCertificateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateCaCertificateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateCaCertificateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateCaCertificateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateCACertificate");

            return clientHandler.execute(new ClientExecutionParams<UpdateCaCertificateRequest, UpdateCaCertificateResponse>()
                    .withOperationName("UpdateCACertificate").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateCaCertificateRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateCaCertificateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the status of the specified certificate. This operation is idempotent.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >UpdateCertificate</a> action.
     * </p>
     * <p>
     * Certificates must be in the ACTIVE state to authenticate devices that use a certificate to connect to IoT.
     * </p>
     * <p>
     * Within a few minutes of updating a certificate from the ACTIVE state to any other state, IoT disconnects all
     * devices that used that certificate to connect. Devices cannot use a certificate that is not in the ACTIVE state
     * to reconnect.
     * </p>
     *
     * @param updateCertificateRequest
     *        The input for the UpdateCertificate operation.
     * @return Result of the UpdateCertificate operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws CertificateStateException
     *         The certificate operation is not allowed.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.UpdateCertificate
     */
    @Override
    public UpdateCertificateResponse updateCertificate(UpdateCertificateRequest updateCertificateRequest)
            throws ResourceNotFoundException, CertificateStateException, InvalidRequestException, ThrottlingException,
            UnauthorizedException, ServiceUnavailableException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateCertificateResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateCertificateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateCertificateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateCertificateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateCertificate");

            return clientHandler.execute(new ClientExecutionParams<UpdateCertificateRequest, UpdateCertificateResponse>()
                    .withOperationName("UpdateCertificate").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateCertificateRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateCertificateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a Device Defender detect custom metric.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >UpdateCustomMetric</a> action.
     * </p>
     *
     * @param updateCustomMetricRequest
     * @return Result of the UpdateCustomMetric operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.UpdateCustomMetric
     */
    @Override
    public UpdateCustomMetricResponse updateCustomMetric(UpdateCustomMetricRequest updateCustomMetricRequest)
            throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, InternalFailureException,
            AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateCustomMetricResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateCustomMetricResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateCustomMetricRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateCustomMetricRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateCustomMetric");

            return clientHandler.execute(new ClientExecutionParams<UpdateCustomMetricRequest, UpdateCustomMetricResponse>()
                    .withOperationName("UpdateCustomMetric").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateCustomMetricRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateCustomMetricRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the definition for a dimension. You cannot change the type of a dimension after it is created (you can
     * delete it and recreate it).
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >UpdateDimension</a> action.
     * </p>
     *
     * @param updateDimensionRequest
     * @return Result of the UpdateDimension operation returned by the service.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.UpdateDimension
     */
    @Override
    public UpdateDimensionResponse updateDimension(UpdateDimensionRequest updateDimensionRequest)
            throws InternalFailureException, InvalidRequestException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateDimensionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateDimensionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateDimensionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateDimensionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateDimension");

            return clientHandler.execute(new ClientExecutionParams<UpdateDimensionRequest, UpdateDimensionResponse>()
                    .withOperationName("UpdateDimension").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateDimensionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateDimensionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates values stored in the domain configuration. Domain configurations for default endpoints can't be updated.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >UpdateDomainConfiguration</a> action.
     * </p>
     *
     * @param updateDomainConfigurationRequest
     * @return Result of the UpdateDomainConfiguration operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws CertificateValidationException
     *         The certificate is invalid.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.UpdateDomainConfiguration
     */
    @Override
    public UpdateDomainConfigurationResponse updateDomainConfiguration(
            UpdateDomainConfigurationRequest updateDomainConfigurationRequest) throws ResourceNotFoundException,
            CertificateValidationException, InvalidRequestException, ThrottlingException, UnauthorizedException,
            ServiceUnavailableException, InternalFailureException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateDomainConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateDomainConfigurationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateDomainConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateDomainConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateDomainConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateDomainConfigurationRequest, UpdateDomainConfigurationResponse>()
                            .withOperationName("UpdateDomainConfiguration").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(updateDomainConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateDomainConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a dynamic thing group.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >UpdateDynamicThingGroup</a> action.
     * </p>
     *
     * @param updateDynamicThingGroupRequest
     * @return Result of the UpdateDynamicThingGroup operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws VersionConflictException
     *         An exception thrown when the version of an entity specified with the <code>expectedVersion</code>
     *         parameter does not match the latest version in the system.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidQueryException
     *         The query is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.UpdateDynamicThingGroup
     */
    @Override
    public UpdateDynamicThingGroupResponse updateDynamicThingGroup(UpdateDynamicThingGroupRequest updateDynamicThingGroupRequest)
            throws InvalidRequestException, VersionConflictException, ThrottlingException, InternalFailureException,
            ResourceNotFoundException, InvalidQueryException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateDynamicThingGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateDynamicThingGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateDynamicThingGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateDynamicThingGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateDynamicThingGroup");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateDynamicThingGroupRequest, UpdateDynamicThingGroupResponse>()
                            .withOperationName("UpdateDynamicThingGroup").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(updateDynamicThingGroupRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateDynamicThingGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the event configurations.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >UpdateEventConfigurations</a> action.
     * </p>
     *
     * @param updateEventConfigurationsRequest
     * @return Result of the UpdateEventConfigurations operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.UpdateEventConfigurations
     */
    @Override
    public UpdateEventConfigurationsResponse updateEventConfigurations(
            UpdateEventConfigurationsRequest updateEventConfigurationsRequest) throws InvalidRequestException,
            InternalFailureException, ThrottlingException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateEventConfigurationsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateEventConfigurationsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateEventConfigurationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateEventConfigurationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateEventConfigurations");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateEventConfigurationsRequest, UpdateEventConfigurationsResponse>()
                            .withOperationName("UpdateEventConfigurations").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(updateEventConfigurationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateEventConfigurationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the data for a fleet metric.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >UpdateFleetMetric</a> action.
     * </p>
     *
     * @param updateFleetMetricRequest
     * @return Result of the UpdateFleetMetric operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidQueryException
     *         The query is invalid.
     * @throws InvalidAggregationException
     *         The aggregation is invalid.
     * @throws VersionConflictException
     *         An exception thrown when the version of an entity specified with the <code>expectedVersion</code>
     *         parameter does not match the latest version in the system.
     * @throws IndexNotReadyException
     *         The index is not ready.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.UpdateFleetMetric
     */
    @Override
    public UpdateFleetMetricResponse updateFleetMetric(UpdateFleetMetricRequest updateFleetMetricRequest)
            throws InvalidRequestException, ThrottlingException, UnauthorizedException, ServiceUnavailableException,
            InternalFailureException, ResourceNotFoundException, InvalidQueryException, InvalidAggregationException,
            VersionConflictException, IndexNotReadyException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateFleetMetricResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateFleetMetricResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateFleetMetricRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateFleetMetricRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateFleetMetric");

            return clientHandler.execute(new ClientExecutionParams<UpdateFleetMetricRequest, UpdateFleetMetricResponse>()
                    .withOperationName("UpdateFleetMetric").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateFleetMetricRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateFleetMetricRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the search configuration.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >UpdateIndexingConfiguration</a> action.
     * </p>
     *
     * @param updateIndexingConfigurationRequest
     * @return Result of the UpdateIndexingConfiguration operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.UpdateIndexingConfiguration
     */
    @Override
    public UpdateIndexingConfigurationResponse updateIndexingConfiguration(
            UpdateIndexingConfigurationRequest updateIndexingConfigurationRequest) throws InvalidRequestException,
            ThrottlingException, UnauthorizedException, ServiceUnavailableException, InternalFailureException,
            AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateIndexingConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateIndexingConfigurationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateIndexingConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateIndexingConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateIndexingConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateIndexingConfigurationRequest, UpdateIndexingConfigurationResponse>()
                            .withOperationName("UpdateIndexingConfiguration").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(updateIndexingConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateIndexingConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates supported fields of the specified job.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >UpdateJob</a> action.
     * </p>
     *
     * @param updateJobRequest
     * @return Result of the UpdateJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.UpdateJob
     */
    @Override
    public UpdateJobResponse updateJob(UpdateJobRequest updateJobRequest) throws InvalidRequestException,
            ResourceNotFoundException, ThrottlingException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateJobResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateJobResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateJob");

            return clientHandler.execute(new ClientExecutionParams<UpdateJobRequest, UpdateJobResponse>()
                    .withOperationName("UpdateJob").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(updateJobRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the definition for the specified mitigation action.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >UpdateMitigationAction</a> action.
     * </p>
     *
     * @param updateMitigationActionRequest
     * @return Result of the UpdateMitigationAction operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.UpdateMitigationAction
     */
    @Override
    public UpdateMitigationActionResponse updateMitigationAction(UpdateMitigationActionRequest updateMitigationActionRequest)
            throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, InternalFailureException,
            AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateMitigationActionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateMitigationActionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateMitigationActionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateMitigationActionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateMitigationAction");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateMitigationActionRequest, UpdateMitigationActionResponse>()
                            .withOperationName("UpdateMitigationAction").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(updateMitigationActionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateMitigationActionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the supported fields for a specific software package.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >UpdatePackage</a> and <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >GetIndexingConfiguration</a> actions.
     * </p>
     *
     * @param updatePackageRequest
     * @return Result of the UpdatePackage operation returned by the service.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ValidationException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.UpdatePackage
     */
    @Override
    public UpdatePackageResponse updatePackage(UpdatePackageRequest updatePackageRequest) throws ThrottlingException,
            InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdatePackageResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdatePackageResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updatePackageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updatePackageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdatePackage");

            return clientHandler.execute(new ClientExecutionParams<UpdatePackageRequest, UpdatePackageResponse>()
                    .withOperationName("UpdatePackage").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updatePackageRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdatePackageRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the software package configuration.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >UpdatePackageConfiguration</a> and <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_passrole.html">iam:PassRole</a> actions.
     * </p>
     *
     * @param updatePackageConfigurationRequest
     * @return Result of the UpdatePackageConfiguration operation returned by the service.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ValidationException
     *         The request is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.UpdatePackageConfiguration
     */
    @Override
    public UpdatePackageConfigurationResponse updatePackageConfiguration(
            UpdatePackageConfigurationRequest updatePackageConfigurationRequest) throws ThrottlingException,
            InternalServerException, ValidationException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdatePackageConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdatePackageConfigurationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updatePackageConfigurationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updatePackageConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdatePackageConfiguration");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdatePackageConfigurationRequest, UpdatePackageConfigurationResponse>()
                            .withOperationName("UpdatePackageConfiguration").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(updatePackageConfigurationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdatePackageConfigurationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the supported fields for a specific package version.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >UpdatePackageVersion</a> and <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >GetIndexingConfiguration</a> actions.
     * </p>
     *
     * @param updatePackageVersionRequest
     * @return Result of the UpdatePackageVersion operation returned by the service.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ValidationException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.UpdatePackageVersion
     */
    @Override
    public UpdatePackageVersionResponse updatePackageVersion(UpdatePackageVersionRequest updatePackageVersionRequest)
            throws ThrottlingException, InternalServerException, ValidationException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdatePackageVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdatePackageVersionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updatePackageVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updatePackageVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdatePackageVersion");

            return clientHandler.execute(new ClientExecutionParams<UpdatePackageVersionRequest, UpdatePackageVersionResponse>()
                    .withOperationName("UpdatePackageVersion").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updatePackageVersionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdatePackageVersionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a provisioning template.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >UpdateProvisioningTemplate</a> action.
     * </p>
     *
     * @param updateProvisioningTemplateRequest
     * @return Result of the UpdateProvisioningTemplate operation returned by the service.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ConflictingResourceUpdateException
     *         A conflicting resource update exception. This exception is thrown when two pending updates cause a
     *         conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.UpdateProvisioningTemplate
     */
    @Override
    public UpdateProvisioningTemplateResponse updateProvisioningTemplate(
            UpdateProvisioningTemplateRequest updateProvisioningTemplateRequest) throws InternalFailureException,
            InvalidRequestException, ResourceNotFoundException, UnauthorizedException, ConflictingResourceUpdateException,
            AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateProvisioningTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateProvisioningTemplateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateProvisioningTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateProvisioningTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateProvisioningTemplate");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateProvisioningTemplateRequest, UpdateProvisioningTemplateResponse>()
                            .withOperationName("UpdateProvisioningTemplate").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(updateProvisioningTemplateRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateProvisioningTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a role alias.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >UpdateRoleAlias</a> action.
     * </p>
     *
     * @param updateRoleAliasRequest
     * @return Result of the UpdateRoleAlias operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.UpdateRoleAlias
     */
    @Override
    public UpdateRoleAliasResponse updateRoleAlias(UpdateRoleAliasRequest updateRoleAliasRequest)
            throws ResourceNotFoundException, InvalidRequestException, ThrottlingException, UnauthorizedException,
            ServiceUnavailableException, InternalFailureException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateRoleAliasResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateRoleAliasResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateRoleAliasRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateRoleAliasRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateRoleAlias");

            return clientHandler.execute(new ClientExecutionParams<UpdateRoleAliasRequest, UpdateRoleAliasResponse>()
                    .withOperationName("UpdateRoleAlias").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateRoleAliasRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateRoleAliasRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a scheduled audit, including which checks are performed and how often the audit takes place.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >UpdateScheduledAudit</a> action.
     * </p>
     *
     * @param updateScheduledAuditRequest
     * @return Result of the UpdateScheduledAudit operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.UpdateScheduledAudit
     */
    @Override
    public UpdateScheduledAuditResponse updateScheduledAudit(UpdateScheduledAuditRequest updateScheduledAuditRequest)
            throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, InternalFailureException,
            AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateScheduledAuditResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateScheduledAuditResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateScheduledAuditRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateScheduledAuditRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateScheduledAudit");

            return clientHandler.execute(new ClientExecutionParams<UpdateScheduledAuditRequest, UpdateScheduledAuditResponse>()
                    .withOperationName("UpdateScheduledAudit").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateScheduledAuditRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateScheduledAuditRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a Device Defender security profile.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >UpdateSecurityProfile</a> action.
     * </p>
     *
     * @param updateSecurityProfileRequest
     * @return Result of the UpdateSecurityProfile operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws VersionConflictException
     *         An exception thrown when the version of an entity specified with the <code>expectedVersion</code>
     *         parameter does not match the latest version in the system.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.UpdateSecurityProfile
     */
    @Override
    public UpdateSecurityProfileResponse updateSecurityProfile(UpdateSecurityProfileRequest updateSecurityProfileRequest)
            throws InvalidRequestException, ResourceNotFoundException, VersionConflictException, ThrottlingException,
            InternalFailureException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateSecurityProfileResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateSecurityProfileResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateSecurityProfileRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateSecurityProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateSecurityProfile");

            return clientHandler.execute(new ClientExecutionParams<UpdateSecurityProfileRequest, UpdateSecurityProfileResponse>()
                    .withOperationName("UpdateSecurityProfile").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateSecurityProfileRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateSecurityProfileRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates an existing stream. The stream version will be incremented by one.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >UpdateStream</a> action.
     * </p>
     *
     * @param updateStreamRequest
     * @return Result of the UpdateStream operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.UpdateStream
     */
    @Override
    public UpdateStreamResponse updateStream(UpdateStreamRequest updateStreamRequest) throws InvalidRequestException,
            ResourceNotFoundException, ThrottlingException, UnauthorizedException, ServiceUnavailableException,
            InternalFailureException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateStreamResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateStreamResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateStreamRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateStreamRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateStream");

            return clientHandler.execute(new ClientExecutionParams<UpdateStreamRequest, UpdateStreamResponse>()
                    .withOperationName("UpdateStream").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateStreamRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateStreamRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the data for a thing.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >UpdateThing</a> action.
     * </p>
     *
     * @param updateThingRequest
     *        The input for the UpdateThing operation.
     * @return Result of the UpdateThing operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws VersionConflictException
     *         An exception thrown when the version of an entity specified with the <code>expectedVersion</code>
     *         parameter does not match the latest version in the system.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.UpdateThing
     */
    @Override
    public UpdateThingResponse updateThing(UpdateThingRequest updateThingRequest) throws InvalidRequestException,
            VersionConflictException, ThrottlingException, UnauthorizedException, ServiceUnavailableException,
            InternalFailureException, ResourceNotFoundException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateThingResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateThingResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateThingRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateThingRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateThing");

            return clientHandler.execute(new ClientExecutionParams<UpdateThingRequest, UpdateThingResponse>()
                    .withOperationName("UpdateThing").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(updateThingRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateThingRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Update a thing group.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >UpdateThingGroup</a> action.
     * </p>
     *
     * @param updateThingGroupRequest
     * @return Result of the UpdateThingGroup operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws VersionConflictException
     *         An exception thrown when the version of an entity specified with the <code>expectedVersion</code>
     *         parameter does not match the latest version in the system.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.UpdateThingGroup
     */
    @Override
    public UpdateThingGroupResponse updateThingGroup(UpdateThingGroupRequest updateThingGroupRequest)
            throws InvalidRequestException, VersionConflictException, ThrottlingException, InternalFailureException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateThingGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateThingGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateThingGroupRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateThingGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoT");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateThingGroup");

            return clientHandler.execute(new ClientExecutionParams<UpdateThingGroupRequest, UpdateThingGroupResponse>()
                    .withOperationName("UpdateThingGroup").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateThingGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateThingGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the groups to which the thing belongs.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >UpdateThingGroupsForThing</a> action.
     * </p>
     *
     * @param updateThingGroupsForThingRequest
     * @return Result of the UpdateThingGroupsForThing operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.UpdateThingGroupsForThing
     */
    @Override
    public UpdateThingGroupsForThingResponse updateThingGroupsForThing(
            UpdateThingGroupsForThingRequest updateThingGroupsForThingRequest) throws InvalidRequestException,
            ThrottlingException, InternalFailureException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            IotException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateThingGroupsForThingResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateThingGroupsForThingResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
    