/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the HTTP context to use for the test authorizer request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HttpContext implements SdkPojo, Serializable, ToCopyableBuilder<HttpContext.Builder, HttpContext> {
    private static final SdkField<Map<String, String>> HEADERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("headers")
            .getter(getter(HttpContext::headers))
            .setter(setter(Builder::headers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("headers").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> QUERY_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("queryString").getter(getter(HttpContext::queryString)).setter(setter(Builder::queryString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryString").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HEADERS_FIELD,
            QUERY_STRING_FIELD));

    private static final long serialVersionUID = 1L;

    private final Map<String, String> headers;

    private final String queryString;

    private HttpContext(BuilderImpl builder) {
        this.headers = builder.headers;
        this.queryString = builder.queryString;
    }

    /**
     * For responses, this returns true if the service returned a value for the Headers property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasHeaders() {
        return headers != null && !(headers instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The header keys and values in an HTTP authorization request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHeaders} method.
     * </p>
     * 
     * @return The header keys and values in an HTTP authorization request.
     */
    public final Map<String, String> headers() {
        return headers;
    }

    /**
     * <p>
     * The query string keys and values in an HTTP authorization request.
     * </p>
     * 
     * @return The query string keys and values in an HTTP authorization request.
     */
    public final String queryString() {
        return queryString;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasHeaders() ? headers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(queryString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HttpContext)) {
            return false;
        }
        HttpContext other = (HttpContext) obj;
        return hasHeaders() == other.hasHeaders() && Objects.equals(headers(), other.headers())
                && Objects.equals(queryString(), other.queryString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HttpContext").add("Headers", hasHeaders() ? headers() : null).add("QueryString", queryString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "headers":
            return Optional.ofNullable(clazz.cast(headers()));
        case "queryString":
            return Optional.ofNullable(clazz.cast(queryString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HttpContext, T> g) {
        return obj -> g.apply((HttpContext) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HttpContext> {
        /**
         * <p>
         * The header keys and values in an HTTP authorization request.
         * </p>
         * 
         * @param headers
         *        The header keys and values in an HTTP authorization request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder headers(Map<String, String> headers);

        /**
         * <p>
         * The query string keys and values in an HTTP authorization request.
         * </p>
         * 
         * @param queryString
         *        The query string keys and values in an HTTP authorization request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryString(String queryString);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, String> headers = DefaultSdkAutoConstructMap.getInstance();

        private String queryString;

        private BuilderImpl() {
        }

        private BuilderImpl(HttpContext model) {
            headers(model.headers);
            queryString(model.queryString);
        }

        public final Map<String, String> getHeaders() {
            if (headers instanceof SdkAutoConstructMap) {
                return null;
            }
            return headers;
        }

        public final void setHeaders(Map<String, String> headers) {
            this.headers = HttpHeadersCopier.copy(headers);
        }

        @Override
        public final Builder headers(Map<String, String> headers) {
            this.headers = HttpHeadersCopier.copy(headers);
            return this;
        }

        public final String getQueryString() {
            return queryString;
        }

        public final void setQueryString(String queryString) {
            this.queryString = queryString;
        }

        @Override
        public final Builder queryString(String queryString) {
            this.queryString = queryString;
            return this;
        }

        @Override
        public HttpContext build() {
            return new HttpContext(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
