/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The thing indexing configuration. For more information, see <a
 * href="https://docs.aws.amazon.com/iot/latest/developerguide/managing-index.html">Managing Thing Indexing</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ThingIndexingConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ThingIndexingConfiguration.Builder, ThingIndexingConfiguration> {
    private static final SdkField<String> THING_INDEXING_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("thingIndexingMode").getter(getter(ThingIndexingConfiguration::thingIndexingModeAsString))
            .setter(setter(Builder::thingIndexingMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingIndexingMode").build()).build();

    private static final SdkField<String> THING_CONNECTIVITY_INDEXING_MODE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("thingConnectivityIndexingMode")
            .getter(getter(ThingIndexingConfiguration::thingConnectivityIndexingModeAsString))
            .setter(setter(Builder::thingConnectivityIndexingMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingConnectivityIndexingMode")
                    .build()).build();

    private static final SdkField<String> DEVICE_DEFENDER_INDEXING_MODE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("deviceDefenderIndexingMode")
            .getter(getter(ThingIndexingConfiguration::deviceDefenderIndexingModeAsString))
            .setter(setter(Builder::deviceDefenderIndexingMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceDefenderIndexingMode").build())
            .build();

    private static final SdkField<String> NAMED_SHADOW_INDEXING_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("namedShadowIndexingMode").getter(getter(ThingIndexingConfiguration::namedShadowIndexingModeAsString))
            .setter(setter(Builder::namedShadowIndexingMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namedShadowIndexingMode").build())
            .build();

    private static final SdkField<List<Field>> MANAGED_FIELDS_FIELD = SdkField
            .<List<Field>> builder(MarshallingType.LIST)
            .memberName("managedFields")
            .getter(getter(ThingIndexingConfiguration::managedFields))
            .setter(setter(Builder::managedFields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managedFields").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Field> builder(MarshallingType.SDK_POJO)
                                            .constructor(Field::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Field>> CUSTOM_FIELDS_FIELD = SdkField
            .<List<Field>> builder(MarshallingType.LIST)
            .memberName("customFields")
            .getter(getter(ThingIndexingConfiguration::customFields))
            .setter(setter(Builder::customFields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customFields").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Field> builder(MarshallingType.SDK_POJO)
                                            .constructor(Field::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<IndexingFilter> FILTER_FIELD = SdkField.<IndexingFilter> builder(MarshallingType.SDK_POJO)
            .memberName("filter").getter(getter(ThingIndexingConfiguration::filter)).setter(setter(Builder::filter))
            .constructor(IndexingFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filter").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THING_INDEXING_MODE_FIELD,
            THING_CONNECTIVITY_INDEXING_MODE_FIELD, DEVICE_DEFENDER_INDEXING_MODE_FIELD, NAMED_SHADOW_INDEXING_MODE_FIELD,
            MANAGED_FIELDS_FIELD, CUSTOM_FIELDS_FIELD, FILTER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String thingIndexingMode;

    private final String thingConnectivityIndexingMode;

    private final String deviceDefenderIndexingMode;

    private final String namedShadowIndexingMode;

    private final List<Field> managedFields;

    private final List<Field> customFields;

    private final IndexingFilter filter;

    private ThingIndexingConfiguration(BuilderImpl builder) {
        this.thingIndexingMode = builder.thingIndexingMode;
        this.thingConnectivityIndexingMode = builder.thingConnectivityIndexingMode;
        this.deviceDefenderIndexingMode = builder.deviceDefenderIndexingMode;
        this.namedShadowIndexingMode = builder.namedShadowIndexingMode;
        this.managedFields = builder.managedFields;
        this.customFields = builder.customFields;
        this.filter = builder.filter;
    }

    /**
     * <p>
     * Thing indexing mode. Valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * REGISTRY – Your thing index contains registry data only.
     * </p>
     * </li>
     * <li>
     * <p>
     * REGISTRY_AND_SHADOW - Your thing index contains registry and shadow data.
     * </p>
     * </li>
     * <li>
     * <p>
     * OFF - Thing indexing is disabled.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #thingIndexingMode}
     * will return {@link ThingIndexingMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #thingIndexingModeAsString}.
     * </p>
     * 
     * @return Thing indexing mode. Valid values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         REGISTRY – Your thing index contains registry data only.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         REGISTRY_AND_SHADOW - Your thing index contains registry and shadow data.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OFF - Thing indexing is disabled.
     *         </p>
     *         </li>
     * @see ThingIndexingMode
     */
    public final ThingIndexingMode thingIndexingMode() {
        return ThingIndexingMode.fromValue(thingIndexingMode);
    }

    /**
     * <p>
     * Thing indexing mode. Valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * REGISTRY – Your thing index contains registry data only.
     * </p>
     * </li>
     * <li>
     * <p>
     * REGISTRY_AND_SHADOW - Your thing index contains registry and shadow data.
     * </p>
     * </li>
     * <li>
     * <p>
     * OFF - Thing indexing is disabled.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #thingIndexingMode}
     * will return {@link ThingIndexingMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #thingIndexingModeAsString}.
     * </p>
     * 
     * @return Thing indexing mode. Valid values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         REGISTRY – Your thing index contains registry data only.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         REGISTRY_AND_SHADOW - Your thing index contains registry and shadow data.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OFF - Thing indexing is disabled.
     *         </p>
     *         </li>
     * @see ThingIndexingMode
     */
    public final String thingIndexingModeAsString() {
        return thingIndexingMode;
    }

    /**
     * <p>
     * Thing connectivity indexing mode. Valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * STATUS – Your thing index contains connectivity status. To enable thing connectivity indexing,
     * <i>thingIndexMode</i> must not be set to OFF.
     * </p>
     * </li>
     * <li>
     * <p>
     * OFF - Thing connectivity status indexing is disabled.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #thingConnectivityIndexingMode} will return {@link ThingConnectivityIndexingMode#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #thingConnectivityIndexingModeAsString}.
     * </p>
     * 
     * @return Thing connectivity indexing mode. Valid values are: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         STATUS – Your thing index contains connectivity status. To enable thing connectivity indexing,
     *         <i>thingIndexMode</i> must not be set to OFF.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OFF - Thing connectivity status indexing is disabled.
     *         </p>
     *         </li>
     * @see ThingConnectivityIndexingMode
     */
    public final ThingConnectivityIndexingMode thingConnectivityIndexingMode() {
        return ThingConnectivityIndexingMode.fromValue(thingConnectivityIndexingMode);
    }

    /**
     * <p>
     * Thing connectivity indexing mode. Valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * STATUS – Your thing index contains connectivity status. To enable thing connectivity indexing,
     * <i>thingIndexMode</i> must not be set to OFF.
     * </p>
     * </li>
     * <li>
     * <p>
     * OFF - Thing connectivity status indexing is disabled.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #thingConnectivityIndexingMode} will return {@link ThingConnectivityIndexingMode#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #thingConnectivityIndexingModeAsString}.
     * </p>
     * 
     * @return Thing connectivity indexing mode. Valid values are: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         STATUS – Your thing index contains connectivity status. To enable thing connectivity indexing,
     *         <i>thingIndexMode</i> must not be set to OFF.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OFF - Thing connectivity status indexing is disabled.
     *         </p>
     *         </li>
     * @see ThingConnectivityIndexingMode
     */
    public final String thingConnectivityIndexingModeAsString() {
        return thingConnectivityIndexingMode;
    }

    /**
     * <p>
     * Device Defender indexing mode. Valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * VIOLATIONS – Your thing index contains Device Defender violations. To enable Device Defender indexing,
     * <i>deviceDefenderIndexingMode</i> must not be set to OFF.
     * </p>
     * </li>
     * <li>
     * <p>
     * OFF - Device Defender indexing is disabled.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about Device Defender violations, see <a
     * href="https://docs.aws.amazon.com/iot/latest/developerguide/device-defender-detect.html">Device Defender
     * Detect.</a>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #deviceDefenderIndexingMode} will return {@link DeviceDefenderIndexingMode#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #deviceDefenderIndexingModeAsString}.
     * </p>
     * 
     * @return Device Defender indexing mode. Valid values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         VIOLATIONS – Your thing index contains Device Defender violations. To enable Device Defender indexing,
     *         <i>deviceDefenderIndexingMode</i> must not be set to OFF.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OFF - Device Defender indexing is disabled.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information about Device Defender violations, see <a
     *         href="https://docs.aws.amazon.com/iot/latest/developerguide/device-defender-detect.html">Device Defender
     *         Detect.</a>
     * @see DeviceDefenderIndexingMode
     */
    public final DeviceDefenderIndexingMode deviceDefenderIndexingMode() {
        return DeviceDefenderIndexingMode.fromValue(deviceDefenderIndexingMode);
    }

    /**
     * <p>
     * Device Defender indexing mode. Valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * VIOLATIONS – Your thing index contains Device Defender violations. To enable Device Defender indexing,
     * <i>deviceDefenderIndexingMode</i> must not be set to OFF.
     * </p>
     * </li>
     * <li>
     * <p>
     * OFF - Device Defender indexing is disabled.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about Device Defender violations, see <a
     * href="https://docs.aws.amazon.com/iot/latest/developerguide/device-defender-detect.html">Device Defender
     * Detect.</a>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #deviceDefenderIndexingMode} will return {@link DeviceDefenderIndexingMode#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #deviceDefenderIndexingModeAsString}.
     * </p>
     * 
     * @return Device Defender indexing mode. Valid values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         VIOLATIONS – Your thing index contains Device Defender violations. To enable Device Defender indexing,
     *         <i>deviceDefenderIndexingMode</i> must not be set to OFF.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OFF - Device Defender indexing is disabled.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information about Device Defender violations, see <a
     *         href="https://docs.aws.amazon.com/iot/latest/developerguide/device-defender-detect.html">Device Defender
     *         Detect.</a>
     * @see DeviceDefenderIndexingMode
     */
    public final String deviceDefenderIndexingModeAsString() {
        return deviceDefenderIndexingMode;
    }

    /**
     * <p>
     * Named shadow indexing mode. Valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * ON – Your thing index contains named shadow. To enable thing named shadow indexing,
     * <i>namedShadowIndexingMode</i> must not be set to OFF.
     * </p>
     * </li>
     * <li>
     * <p>
     * OFF - Named shadow indexing is disabled.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about Shadows, see <a
     * href="https://docs.aws.amazon.com/iot/latest/developerguide/iot-device-shadows.html">IoT Device Shadow
     * service.</a>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #namedShadowIndexingMode} will return {@link NamedShadowIndexingMode#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #namedShadowIndexingModeAsString}.
     * </p>
     * 
     * @return Named shadow indexing mode. Valid values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         ON – Your thing index contains named shadow. To enable thing named shadow indexing,
     *         <i>namedShadowIndexingMode</i> must not be set to OFF.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OFF - Named shadow indexing is disabled.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information about Shadows, see <a
     *         href="https://docs.aws.amazon.com/iot/latest/developerguide/iot-device-shadows.html">IoT Device Shadow
     *         service.</a>
     * @see NamedShadowIndexingMode
     */
    public final NamedShadowIndexingMode namedShadowIndexingMode() {
        return NamedShadowIndexingMode.fromValue(namedShadowIndexingMode);
    }

    /**
     * <p>
     * Named shadow indexing mode. Valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * ON – Your thing index contains named shadow. To enable thing named shadow indexing,
     * <i>namedShadowIndexingMode</i> must not be set to OFF.
     * </p>
     * </li>
     * <li>
     * <p>
     * OFF - Named shadow indexing is disabled.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about Shadows, see <a
     * href="https://docs.aws.amazon.com/iot/latest/developerguide/iot-device-shadows.html">IoT Device Shadow
     * service.</a>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #namedShadowIndexingMode} will return {@link NamedShadowIndexingMode#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #namedShadowIndexingModeAsString}.
     * </p>
     * 
     * @return Named shadow indexing mode. Valid values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         ON – Your thing index contains named shadow. To enable thing named shadow indexing,
     *         <i>namedShadowIndexingMode</i> must not be set to OFF.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OFF - Named shadow indexing is disabled.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information about Shadows, see <a
     *         href="https://docs.aws.amazon.com/iot/latest/developerguide/iot-device-shadows.html">IoT Device Shadow
     *         service.</a>
     * @see NamedShadowIndexingMode
     */
    public final String namedShadowIndexingModeAsString() {
        return namedShadowIndexingMode;
    }

    /**
     * For responses, this returns true if the service returned a value for the ManagedFields property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasManagedFields() {
        return managedFields != null && !(managedFields instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains fields that are indexed and whose types are already known by the Fleet Indexing service. This is an
     * optional field. For more information, see <a
     * href="https://docs.aws.amazon.com/iot/latest/developerguide/managing-fleet-index.html#managed-field">Managed
     * fields</a> in the <i>Amazon Web Services IoT Core Developer Guide</i>.
     * </p>
     * <note>
     * <p>
     * You can't modify managed fields by updating fleet indexing configuration.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasManagedFields} method.
     * </p>
     * 
     * @return Contains fields that are indexed and whose types are already known by the Fleet Indexing service. This is
     *         an optional field. For more information, see <a
     *         href="https://docs.aws.amazon.com/iot/latest/developerguide/managing-fleet-index.html#managed-field"
     *         >Managed fields</a> in the <i>Amazon Web Services IoT Core Developer Guide</i>.</p> <note>
     *         <p>
     *         You can't modify managed fields by updating fleet indexing configuration.
     *         </p>
     */
    public final List<Field> managedFields() {
        return managedFields;
    }

    /**
     * For responses, this returns true if the service returned a value for the CustomFields property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCustomFields() {
        return customFields != null && !(customFields instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains custom field names and their data type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCustomFields} method.
     * </p>
     * 
     * @return Contains custom field names and their data type.
     */
    public final List<Field> customFields() {
        return customFields;
    }

    /**
     * <p>
     * Provides additional filters for specific data sources. Named shadow is the only data source that currently
     * supports and requires a filter. To add named shadows to your fleet indexing configuration, set
     * <code>namedShadowIndexingMode</code> to be <code>ON</code> and specify your shadow names in <code>filter</code>.
     * </p>
     * 
     * @return Provides additional filters for specific data sources. Named shadow is the only data source that
     *         currently supports and requires a filter. To add named shadows to your fleet indexing configuration, set
     *         <code>namedShadowIndexingMode</code> to be <code>ON</code> and specify your shadow names in
     *         <code>filter</code>.
     */
    public final IndexingFilter filter() {
        return filter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(thingIndexingModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(thingConnectivityIndexingModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(deviceDefenderIndexingModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(namedShadowIndexingModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasManagedFields() ? managedFields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasCustomFields() ? customFields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(filter());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThingIndexingConfiguration)) {
            return false;
        }
        ThingIndexingConfiguration other = (ThingIndexingConfiguration) obj;
        return Objects.equals(thingIndexingModeAsString(), other.thingIndexingModeAsString())
                && Objects.equals(thingConnectivityIndexingModeAsString(), other.thingConnectivityIndexingModeAsString())
                && Objects.equals(deviceDefenderIndexingModeAsString(), other.deviceDefenderIndexingModeAsString())
                && Objects.equals(namedShadowIndexingModeAsString(), other.namedShadowIndexingModeAsString())
                && hasManagedFields() == other.hasManagedFields() && Objects.equals(managedFields(), other.managedFields())
                && hasCustomFields() == other.hasCustomFields() && Objects.equals(customFields(), other.customFields())
                && Objects.equals(filter(), other.filter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ThingIndexingConfiguration").add("ThingIndexingMode", thingIndexingModeAsString())
                .add("ThingConnectivityIndexingMode", thingConnectivityIndexingModeAsString())
                .add("DeviceDefenderIndexingMode", deviceDefenderIndexingModeAsString())
                .add("NamedShadowIndexingMode", namedShadowIndexingModeAsString())
                .add("ManagedFields", hasManagedFields() ? managedFields() : null)
                .add("CustomFields", hasCustomFields() ? customFields() : null).add("Filter", filter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "thingIndexingMode":
            return Optional.ofNullable(clazz.cast(thingIndexingModeAsString()));
        case "thingConnectivityIndexingMode":
            return Optional.ofNullable(clazz.cast(thingConnectivityIndexingModeAsString()));
        case "deviceDefenderIndexingMode":
            return Optional.ofNullable(clazz.cast(deviceDefenderIndexingModeAsString()));
        case "namedShadowIndexingMode":
            return Optional.ofNullable(clazz.cast(namedShadowIndexingModeAsString()));
        case "managedFields":
            return Optional.ofNullable(clazz.cast(managedFields()));
        case "customFields":
            return Optional.ofNullable(clazz.cast(customFields()));
        case "filter":
            return Optional.ofNullable(clazz.cast(filter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ThingIndexingConfiguration, T> g) {
        return obj -> g.apply((ThingIndexingConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ThingIndexingConfiguration> {
        /**
         * <p>
         * Thing indexing mode. Valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * REGISTRY – Your thing index contains registry data only.
         * </p>
         * </li>
         * <li>
         * <p>
         * REGISTRY_AND_SHADOW - Your thing index contains registry and shadow data.
         * </p>
         * </li>
         * <li>
         * <p>
         * OFF - Thing indexing is disabled.
         * </p>
         * </li>
         * </ul>
         * 
         * @param thingIndexingMode
         *        Thing indexing mode. Valid values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        REGISTRY – Your thing index contains registry data only.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        REGISTRY_AND_SHADOW - Your thing index contains registry and shadow data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        OFF - Thing indexing is disabled.
         *        </p>
         *        </li>
         * @see ThingIndexingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ThingIndexingMode
         */
        Builder thingIndexingMode(String thingIndexingMode);

        /**
         * <p>
         * Thing indexing mode. Valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * REGISTRY – Your thing index contains registry data only.
         * </p>
         * </li>
         * <li>
         * <p>
         * REGISTRY_AND_SHADOW - Your thing index contains registry and shadow data.
         * </p>
         * </li>
         * <li>
         * <p>
         * OFF - Thing indexing is disabled.
         * </p>
         * </li>
         * </ul>
         * 
         * @param thingIndexingMode
         *        Thing indexing mode. Valid values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        REGISTRY – Your thing index contains registry data only.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        REGISTRY_AND_SHADOW - Your thing index contains registry and shadow data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        OFF - Thing indexing is disabled.
         *        </p>
         *        </li>
         * @see ThingIndexingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ThingIndexingMode
         */
        Builder thingIndexingMode(ThingIndexingMode thingIndexingMode);

        /**
         * <p>
         * Thing connectivity indexing mode. Valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * STATUS – Your thing index contains connectivity status. To enable thing connectivity indexing,
         * <i>thingIndexMode</i> must not be set to OFF.
         * </p>
         * </li>
         * <li>
         * <p>
         * OFF - Thing connectivity status indexing is disabled.
         * </p>
         * </li>
         * </ul>
         * 
         * @param thingConnectivityIndexingMode
         *        Thing connectivity indexing mode. Valid values are: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        STATUS – Your thing index contains connectivity status. To enable thing connectivity indexing,
         *        <i>thingIndexMode</i> must not be set to OFF.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        OFF - Thing connectivity status indexing is disabled.
         *        </p>
         *        </li>
         * @see ThingConnectivityIndexingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ThingConnectivityIndexingMode
         */
        Builder thingConnectivityIndexingMode(String thingConnectivityIndexingMode);

        /**
         * <p>
         * Thing connectivity indexing mode. Valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * STATUS – Your thing index contains connectivity status. To enable thing connectivity indexing,
         * <i>thingIndexMode</i> must not be set to OFF.
         * </p>
         * </li>
         * <li>
         * <p>
         * OFF - Thing connectivity status indexing is disabled.
         * </p>
         * </li>
         * </ul>
         * 
         * @param thingConnectivityIndexingMode
         *        Thing connectivity indexing mode. Valid values are: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        STATUS – Your thing index contains connectivity status. To enable thing connectivity indexing,
         *        <i>thingIndexMode</i> must not be set to OFF.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        OFF - Thing connectivity status indexing is disabled.
         *        </p>
         *        </li>
         * @see ThingConnectivityIndexingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ThingConnectivityIndexingMode
         */
        Builder thingConnectivityIndexingMode(ThingConnectivityIndexingMode thingConnectivityIndexingMode);

        /**
         * <p>
         * Device Defender indexing mode. Valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * VIOLATIONS – Your thing index contains Device Defender violations. To enable Device Defender indexing,
         * <i>deviceDefenderIndexingMode</i> must not be set to OFF.
         * </p>
         * </li>
         * <li>
         * <p>
         * OFF - Device Defender indexing is disabled.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information about Device Defender violations, see <a
         * href="https://docs.aws.amazon.com/iot/latest/developerguide/device-defender-detect.html">Device Defender
         * Detect.</a>
         * </p>
         * 
         * @param deviceDefenderIndexingMode
         *        Device Defender indexing mode. Valid values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        VIOLATIONS – Your thing index contains Device Defender violations. To enable Device Defender indexing,
         *        <i>deviceDefenderIndexingMode</i> must not be set to OFF.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        OFF - Device Defender indexing is disabled.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information about Device Defender violations, see <a
         *        href="https://docs.aws.amazon.com/iot/latest/developerguide/device-defender-detect.html">Device
         *        Defender Detect.</a>
         * @see DeviceDefenderIndexingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceDefenderIndexingMode
         */
        Builder deviceDefenderIndexingMode(String deviceDefenderIndexingMode);

        /**
         * <p>
         * Device Defender indexing mode. Valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * VIOLATIONS – Your thing index contains Device Defender violations. To enable Device Defender indexing,
         * <i>deviceDefenderIndexingMode</i> must not be set to OFF.
         * </p>
         * </li>
         * <li>
         * <p>
         * OFF - Device Defender indexing is disabled.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information about Device Defender violations, see <a
         * href="https://docs.aws.amazon.com/iot/latest/developerguide/device-defender-detect.html">Device Defender
         * Detect.</a>
         * </p>
         * 
         * @param deviceDefenderIndexingMode
         *        Device Defender indexing mode. Valid values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        VIOLATIONS – Your thing index contains Device Defender violations. To enable Device Defender indexing,
         *        <i>deviceDefenderIndexingMode</i> must not be set to OFF.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        OFF - Device Defender indexing is disabled.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information about Device Defender violations, see <a
         *        href="https://docs.aws.amazon.com/iot/latest/developerguide/device-defender-detect.html">Device
         *        Defender Detect.</a>
         * @see DeviceDefenderIndexingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceDefenderIndexingMode
         */
        Builder deviceDefenderIndexingMode(DeviceDefenderIndexingMode deviceDefenderIndexingMode);

        /**
         * <p>
         * Named shadow indexing mode. Valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * ON – Your thing index contains named shadow. To enable thing named shadow indexing,
         * <i>namedShadowIndexingMode</i> must not be set to OFF.
         * </p>
         * </li>
         * <li>
         * <p>
         * OFF - Named shadow indexing is disabled.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information about Shadows, see <a
         * href="https://docs.aws.amazon.com/iot/latest/developerguide/iot-device-shadows.html">IoT Device Shadow
         * service.</a>
         * </p>
         * 
         * @param namedShadowIndexingMode
         *        Named shadow indexing mode. Valid values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        ON – Your thing index contains named shadow. To enable thing named shadow indexing,
         *        <i>namedShadowIndexingMode</i> must not be set to OFF.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        OFF - Named shadow indexing is disabled.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information about Shadows, see <a
         *        href="https://docs.aws.amazon.com/iot/latest/developerguide/iot-device-shadows.html">IoT Device Shadow
         *        service.</a>
         * @see NamedShadowIndexingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NamedShadowIndexingMode
         */
        Builder namedShadowIndexingMode(String namedShadowIndexingMode);

        /**
         * <p>
         * Named shadow indexing mode. Valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * ON – Your thing index contains named shadow. To enable thing named shadow indexing,
         * <i>namedShadowIndexingMode</i> must not be set to OFF.
         * </p>
         * </li>
         * <li>
         * <p>
         * OFF - Named shadow indexing is disabled.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information about Shadows, see <a
         * href="https://docs.aws.amazon.com/iot/latest/developerguide/iot-device-shadows.html">IoT Device Shadow
         * service.</a>
         * </p>
         * 
         * @param namedShadowIndexingMode
         *        Named shadow indexing mode. Valid values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        ON – Your thing index contains named shadow. To enable thing named shadow indexing,
         *        <i>namedShadowIndexingMode</i> must not be set to OFF.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        OFF - Named shadow indexing is disabled.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information about Shadows, see <a
         *        href="https://docs.aws.amazon.com/iot/latest/developerguide/iot-device-shadows.html">IoT Device Shadow
         *        service.</a>
         * @see NamedShadowIndexingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NamedShadowIndexingMode
         */
        Builder namedShadowIndexingMode(NamedShadowIndexingMode namedShadowIndexingMode);

        /**
         * <p>
         * Contains fields that are indexed and whose types are already known by the Fleet Indexing service. This is an
         * optional field. For more information, see <a
         * href="https://docs.aws.amazon.com/iot/latest/developerguide/managing-fleet-index.html#managed-field">Managed
         * fields</a> in the <i>Amazon Web Services IoT Core Developer Guide</i>.
         * </p>
         * <note>
         * <p>
         * You can't modify managed fields by updating fleet indexing configuration.
         * </p>
         * </note>
         * 
         * @param managedFields
         *        Contains fields that are indexed and whose types are already known by the Fleet Indexing service. This
         *        is an optional field. For more information, see <a
         *        href="https://docs.aws.amazon.com/iot/latest/developerguide/managing-fleet-index.html#managed-field"
         *        >Managed fields</a> in the <i>Amazon Web Services IoT Core Developer Guide</i>.</p> <note>
         *        <p>
         *        You can't modify managed fields by updating fleet indexing configuration.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedFields(Collection<Field> managedFields);

        /**
         * <p>
         * Contains fields that are indexed and whose types are already known by the Fleet Indexing service. This is an
         * optional field. For more information, see <a
         * href="https://docs.aws.amazon.com/iot/latest/developerguide/managing-fleet-index.html#managed-field">Managed
         * fields</a> in the <i>Amazon Web Services IoT Core Developer Guide</i>.
         * </p>
         * <note>
         * <p>
         * You can't modify managed fields by updating fleet indexing configuration.
         * </p>
         * </note>
         * 
         * @param managedFields
         *        Contains fields that are indexed and whose types are already known by the Fleet Indexing service. This
         *        is an optional field. For more information, see <a
         *        href="https://docs.aws.amazon.com/iot/latest/developerguide/managing-fleet-index.html#managed-field"
         *        >Managed fields</a> in the <i>Amazon Web Services IoT Core Developer Guide</i>.</p> <note>
         *        <p>
         *        You can't modify managed fields by updating fleet indexing configuration.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedFields(Field... managedFields);

        /**
         * <p>
         * Contains fields that are indexed and whose types are already known by the Fleet Indexing service. This is an
         * optional field. For more information, see <a
         * href="https://docs.aws.amazon.com/iot/latest/developerguide/managing-fleet-index.html#managed-field">Managed
         * fields</a> in the <i>Amazon Web Services IoT Core Developer Guide</i>.
         * </p>
         * <note>
         * <p>
         * You can't modify managed fields by updating fleet indexing configuration.
         * </p>
         * </note> This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iot.model.Field.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.iot.model.Field#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.iot.model.Field.Builder#build()}
         * is called immediately and its result is passed to {@link #managedFields(List<Field>)}.
         * 
         * @param managedFields
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.iot.model.Field.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #managedFields(java.util.Collection<Field>)
         */
        Builder managedFields(Consumer<Field.Builder>... managedFields);

        /**
         * <p>
         * Contains custom field names and their data type.
         * </p>
         * 
         * @param customFields
         *        Contains custom field names and their data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customFields(Collection<Field> customFields);

        /**
         * <p>
         * Contains custom field names and their data type.
         * </p>
         * 
         * @param customFields
         *        Contains custom field names and their data type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customFields(Field... customFields);

        /**
         * <p>
         * Contains custom field names and their data type.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iot.model.Field.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.iot.model.Field#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.iot.model.Field.Builder#build()}
         * is called immediately and its result is passed to {@link #customFields(List<Field>)}.
         * 
         * @param customFields
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.iot.model.Field.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customFields(java.util.Collection<Field>)
         */
        Builder customFields(Consumer<Field.Builder>... customFields);

        /**
         * <p>
         * Provides additional filters for specific data sources. Named shadow is the only data source that currently
         * supports and requires a filter. To add named shadows to your fleet indexing configuration, set
         * <code>namedShadowIndexingMode</code> to be <code>ON</code> and specify your shadow names in
         * <code>filter</code>.
         * </p>
         * 
         * @param filter
         *        Provides additional filters for specific data sources. Named shadow is the only data source that
         *        currently supports and requires a filter. To add named shadows to your fleet indexing configuration,
         *        set <code>namedShadowIndexingMode</code> to be <code>ON</code> and specify your shadow names in
         *        <code>filter</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(IndexingFilter filter);

        /**
         * <p>
         * Provides additional filters for specific data sources. Named shadow is the only data source that currently
         * supports and requires a filter. To add named shadows to your fleet indexing configuration, set
         * <code>namedShadowIndexingMode</code> to be <code>ON</code> and specify your shadow names in
         * <code>filter</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link IndexingFilter.Builder} avoiding the need
         * to create one manually via {@link IndexingFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IndexingFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #filter(IndexingFilter)}.
         * 
         * @param filter
         *        a consumer that will call methods on {@link IndexingFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filter(IndexingFilter)
         */
        default Builder filter(Consumer<IndexingFilter.Builder> filter) {
            return filter(IndexingFilter.builder().applyMutation(filter).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String thingIndexingMode;

        private String thingConnectivityIndexingMode;

        private String deviceDefenderIndexingMode;

        private String namedShadowIndexingMode;

        private List<Field> managedFields = DefaultSdkAutoConstructList.getInstance();

        private List<Field> customFields = DefaultSdkAutoConstructList.getInstance();

        private IndexingFilter filter;

        private BuilderImpl() {
        }

        private BuilderImpl(ThingIndexingConfiguration model) {
            thingIndexingMode(model.thingIndexingMode);
            thingConnectivityIndexingMode(model.thingConnectivityIndexingMode);
            deviceDefenderIndexingMode(model.deviceDefenderIndexingMode);
            namedShadowIndexingMode(model.namedShadowIndexingMode);
            managedFields(model.managedFields);
            customFields(model.customFields);
            filter(model.filter);
        }

        public final String getThingIndexingMode() {
            return thingIndexingMode;
        }

        public final void setThingIndexingMode(String thingIndexingMode) {
            this.thingIndexingMode = thingIndexingMode;
        }

        @Override
        public final Builder thingIndexingMode(String thingIndexingMode) {
            this.thingIndexingMode = thingIndexingMode;
            return this;
        }

        @Override
        public final Builder thingIndexingMode(ThingIndexingMode thingIndexingMode) {
            this.thingIndexingMode(thingIndexingMode == null ? null : thingIndexingMode.toString());
            return this;
        }

        public final String getThingConnectivityIndexingMode() {
            return thingConnectivityIndexingMode;
        }

        public final void setThingConnectivityIndexingMode(String thingConnectivityIndexingMode) {
            this.thingConnectivityIndexingMode = thingConnectivityIndexingMode;
        }

        @Override
        public final Builder thingConnectivityIndexingMode(String thingConnectivityIndexingMode) {
            this.thingConnectivityIndexingMode = thingConnectivityIndexingMode;
            return this;
        }

        @Override
        public final Builder thingConnectivityIndexingMode(ThingConnectivityIndexingMode thingConnectivityIndexingMode) {
            this.thingConnectivityIndexingMode(thingConnectivityIndexingMode == null ? null : thingConnectivityIndexingMode
                    .toString());
            return this;
        }

        public final String getDeviceDefenderIndexingMode() {
            return deviceDefenderIndexingMode;
        }

        public final void setDeviceDefenderIndexingMode(String deviceDefenderIndexingMode) {
            this.deviceDefenderIndexingMode = deviceDefenderIndexingMode;
        }

        @Override
        public final Builder deviceDefenderIndexingMode(String deviceDefenderIndexingMode) {
            this.deviceDefenderIndexingMode = deviceDefenderIndexingMode;
            return this;
        }

        @Override
        public final Builder deviceDefenderIndexingMode(DeviceDefenderIndexingMode deviceDefenderIndexingMode) {
            this.deviceDefenderIndexingMode(deviceDefenderIndexingMode == null ? null : deviceDefenderIndexingMode.toString());
            return this;
        }

        public final String getNamedShadowIndexingMode() {
            return namedShadowIndexingMode;
        }

        public final void setNamedShadowIndexingMode(String namedShadowIndexingMode) {
            this.namedShadowIndexingMode = namedShadowIndexingMode;
        }

        @Override
        public final Builder namedShadowIndexingMode(String namedShadowIndexingMode) {
            this.namedShadowIndexingMode = namedShadowIndexingMode;
            return this;
        }

        @Override
        public final Builder namedShadowIndexingMode(NamedShadowIndexingMode namedShadowIndexingMode) {
            this.namedShadowIndexingMode(namedShadowIndexingMode == null ? null : namedShadowIndexingMode.toString());
            return this;
        }

        public final List<Field.Builder> getManagedFields() {
            List<Field.Builder> result = FieldsCopier.copyToBuilder(this.managedFields);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setManagedFields(Collection<Field.BuilderImpl> managedFields) {
            this.managedFields = FieldsCopier.copyFromBuilder(managedFields);
        }

        @Override
        public final Builder managedFields(Collection<Field> managedFields) {
            this.managedFields = FieldsCopier.copy(managedFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder managedFields(Field... managedFields) {
            managedFields(Arrays.asList(managedFields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder managedFields(Consumer<Field.Builder>... managedFields) {
            managedFields(Stream.of(managedFields).map(c -> Field.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<Field.Builder> getCustomFields() {
            List<Field.Builder> result = FieldsCopier.copyToBuilder(this.customFields);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCustomFields(Collection<Field.BuilderImpl> customFields) {
            this.customFields = FieldsCopier.copyFromBuilder(customFields);
        }

        @Override
        public final Builder customFields(Collection<Field> customFields) {
            this.customFields = FieldsCopier.copy(customFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customFields(Field... customFields) {
            customFields(Arrays.asList(customFields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customFields(Consumer<Field.Builder>... customFields) {
            customFields(Stream.of(customFields).map(c -> Field.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final IndexingFilter.Builder getFilter() {
            return filter != null ? filter.toBuilder() : null;
        }

        public final void setFilter(IndexingFilter.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        @Override
        public final Builder filter(IndexingFilter filter) {
            this.filter = filter;
            return this;
        }

        @Override
        public ThingIndexingConfiguration build() {
            return new ThingIndexingConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
