/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The metric you want to retain. Dimensions are optional.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MetricToRetain implements SdkPojo, Serializable, ToCopyableBuilder<MetricToRetain.Builder, MetricToRetain> {
    private static final SdkField<String> METRIC_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("metric")
            .getter(getter(MetricToRetain::metric)).setter(setter(Builder::metric))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metric").build()).build();

    private static final SdkField<MetricDimension> METRIC_DIMENSION_FIELD = SdkField
            .<MetricDimension> builder(MarshallingType.SDK_POJO).memberName("metricDimension")
            .getter(getter(MetricToRetain::metricDimension)).setter(setter(Builder::metricDimension))
            .constructor(MetricDimension::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricDimension").build()).build();

    private static final SdkField<Boolean> EXPORT_METRIC_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("exportMetric").getter(getter(MetricToRetain::exportMetric)).setter(setter(Builder::exportMetric))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exportMetric").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_FIELD,
            METRIC_DIMENSION_FIELD, EXPORT_METRIC_FIELD));

    private static final long serialVersionUID = 1L;

    private final String metric;

    private final MetricDimension metricDimension;

    private final Boolean exportMetric;

    private MetricToRetain(BuilderImpl builder) {
        this.metric = builder.metric;
        this.metricDimension = builder.metricDimension;
        this.exportMetric = builder.exportMetric;
    }

    /**
     * <p>
     * What is measured by the behavior.
     * </p>
     * 
     * @return What is measured by the behavior.
     */
    public final String metric() {
        return metric;
    }

    /**
     * <p>
     * The dimension of a metric. This can't be used with custom metrics.
     * </p>
     * 
     * @return The dimension of a metric. This can't be used with custom metrics.
     */
    public final MetricDimension metricDimension() {
        return metricDimension;
    }

    /**
     * <p>
     * Value added in both Behavior and AdditionalMetricsToRetainV2 to indicate if Device Defender Detect should export
     * the corresponding metrics.
     * </p>
     * 
     * @return Value added in both Behavior and AdditionalMetricsToRetainV2 to indicate if Device Defender Detect should
     *         export the corresponding metrics.
     */
    public final Boolean exportMetric() {
        return exportMetric;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(metric());
        hashCode = 31 * hashCode + Objects.hashCode(metricDimension());
        hashCode = 31 * hashCode + Objects.hashCode(exportMetric());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricToRetain)) {
            return false;
        }
        MetricToRetain other = (MetricToRetain) obj;
        return Objects.equals(metric(), other.metric()) && Objects.equals(metricDimension(), other.metricDimension())
                && Objects.equals(exportMetric(), other.exportMetric());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MetricToRetain").add("Metric", metric()).add("MetricDimension", metricDimension())
                .add("ExportMetric", exportMetric()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "metric":
            return Optional.ofNullable(clazz.cast(metric()));
        case "metricDimension":
            return Optional.ofNullable(clazz.cast(metricDimension()));
        case "exportMetric":
            return Optional.ofNullable(clazz.cast(exportMetric()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MetricToRetain, T> g) {
        return obj -> g.apply((MetricToRetain) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MetricToRetain> {
        /**
         * <p>
         * What is measured by the behavior.
         * </p>
         * 
         * @param metric
         *        What is measured by the behavior.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metric(String metric);

        /**
         * <p>
         * The dimension of a metric. This can't be used with custom metrics.
         * </p>
         * 
         * @param metricDimension
         *        The dimension of a metric. This can't be used with custom metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricDimension(MetricDimension metricDimension);

        /**
         * <p>
         * The dimension of a metric. This can't be used with custom metrics.
         * </p>
         * This is a convenience method that creates an instance of the {@link MetricDimension.Builder} avoiding the
         * need to create one manually via {@link MetricDimension#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MetricDimension.Builder#build()} is called immediately and its
         * result is passed to {@link #metricDimension(MetricDimension)}.
         * 
         * @param metricDimension
         *        a consumer that will call methods on {@link MetricDimension.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricDimension(MetricDimension)
         */
        default Builder metricDimension(Consumer<MetricDimension.Builder> metricDimension) {
            return metricDimension(MetricDimension.builder().applyMutation(metricDimension).build());
        }

        /**
         * <p>
         * Value added in both Behavior and AdditionalMetricsToRetainV2 to indicate if Device Defender Detect should
         * export the corresponding metrics.
         * </p>
         * 
         * @param exportMetric
         *        Value added in both Behavior and AdditionalMetricsToRetainV2 to indicate if Device Defender Detect
         *        should export the corresponding metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportMetric(Boolean exportMetric);
    }

    static final class BuilderImpl implements Builder {
        private String metric;

        private MetricDimension metricDimension;

        private Boolean exportMetric;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricToRetain model) {
            metric(model.metric);
            metricDimension(model.metricDimension);
            exportMetric(model.exportMetric);
        }

        public final String getMetric() {
            return metric;
        }

        public final void setMetric(String metric) {
            this.metric = metric;
        }

        @Override
        public final Builder metric(String metric) {
            this.metric = metric;
            return this;
        }

        public final MetricDimension.Builder getMetricDimension() {
            return metricDimension != null ? metricDimension.toBuilder() : null;
        }

        public final void setMetricDimension(MetricDimension.BuilderImpl metricDimension) {
            this.metricDimension = metricDimension != null ? metricDimension.build() : null;
        }

        @Override
        public final Builder metricDimension(MetricDimension metricDimension) {
            this.metricDimension = metricDimension;
            return this;
        }

        public final Boolean getExportMetric() {
            return exportMetric;
        }

        public final void setExportMetric(Boolean exportMetric) {
            this.exportMetric = exportMetric;
        }

        @Override
        public final Builder exportMetric(Boolean exportMetric) {
            this.exportMetric = exportMetric;
            return this;
        }

        @Override
        public MetricToRetain build() {
            return new MetricToRetain(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
