/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.iot.model.AcceptCertificateTransferRequest;
import software.amazon.awssdk.services.iot.model.AcceptCertificateTransferResponse;
import software.amazon.awssdk.services.iot.model.AddThingToBillingGroupRequest;
import software.amazon.awssdk.services.iot.model.AddThingToBillingGroupResponse;
import software.amazon.awssdk.services.iot.model.AddThingToThingGroupRequest;
import software.amazon.awssdk.services.iot.model.AddThingToThingGroupResponse;
import software.amazon.awssdk.services.iot.model.AssociateTargetsWithJobRequest;
import software.amazon.awssdk.services.iot.model.AssociateTargetsWithJobResponse;
import software.amazon.awssdk.services.iot.model.AttachPolicyRequest;
import software.amazon.awssdk.services.iot.model.AttachPolicyResponse;
import software.amazon.awssdk.services.iot.model.AttachSecurityProfileRequest;
import software.amazon.awssdk.services.iot.model.AttachSecurityProfileResponse;
import software.amazon.awssdk.services.iot.model.AttachThingPrincipalRequest;
import software.amazon.awssdk.services.iot.model.AttachThingPrincipalResponse;
import software.amazon.awssdk.services.iot.model.CancelAuditMitigationActionsTaskRequest;
import software.amazon.awssdk.services.iot.model.CancelAuditMitigationActionsTaskResponse;
import software.amazon.awssdk.services.iot.model.CancelAuditTaskRequest;
import software.amazon.awssdk.services.iot.model.CancelAuditTaskResponse;
import software.amazon.awssdk.services.iot.model.CancelCertificateTransferRequest;
import software.amazon.awssdk.services.iot.model.CancelCertificateTransferResponse;
import software.amazon.awssdk.services.iot.model.CancelDetectMitigationActionsTaskRequest;
import software.amazon.awssdk.services.iot.model.CancelDetectMitigationActionsTaskResponse;
import software.amazon.awssdk.services.iot.model.CancelJobExecutionRequest;
import software.amazon.awssdk.services.iot.model.CancelJobExecutionResponse;
import software.amazon.awssdk.services.iot.model.CancelJobRequest;
import software.amazon.awssdk.services.iot.model.CancelJobResponse;
import software.amazon.awssdk.services.iot.model.CertificateConflictException;
import software.amazon.awssdk.services.iot.model.CertificateStateException;
import software.amazon.awssdk.services.iot.model.CertificateValidationException;
import software.amazon.awssdk.services.iot.model.ClearDefaultAuthorizerRequest;
import software.amazon.awssdk.services.iot.model.ClearDefaultAuthorizerResponse;
import software.amazon.awssdk.services.iot.model.ConfirmTopicRuleDestinationRequest;
import software.amazon.awssdk.services.iot.model.ConfirmTopicRuleDestinationResponse;
import software.amazon.awssdk.services.iot.model.ConflictException;
import software.amazon.awssdk.services.iot.model.ConflictingResourceUpdateException;
import software.amazon.awssdk.services.iot.model.CreateAuditSuppressionRequest;
import software.amazon.awssdk.services.iot.model.CreateAuditSuppressionResponse;
import software.amazon.awssdk.services.iot.model.CreateAuthorizerRequest;
import software.amazon.awssdk.services.iot.model.CreateAuthorizerResponse;
import software.amazon.awssdk.services.iot.model.CreateBillingGroupRequest;
import software.amazon.awssdk.services.iot.model.CreateBillingGroupResponse;
import software.amazon.awssdk.services.iot.model.CreateCertificateFromCsrRequest;
import software.amazon.awssdk.services.iot.model.CreateCertificateFromCsrResponse;
import software.amazon.awssdk.services.iot.model.CreateCertificateProviderRequest;
import software.amazon.awssdk.services.iot.model.CreateCertificateProviderResponse;
import software.amazon.awssdk.services.iot.model.CreateCustomMetricRequest;
import software.amazon.awssdk.services.iot.model.CreateCustomMetricResponse;
import software.amazon.awssdk.services.iot.model.CreateDimensionRequest;
import software.amazon.awssdk.services.iot.model.CreateDimensionResponse;
import software.amazon.awssdk.services.iot.model.CreateDomainConfigurationRequest;
import software.amazon.awssdk.services.iot.model.CreateDomainConfigurationResponse;
import software.amazon.awssdk.services.iot.model.CreateDynamicThingGroupRequest;
import software.amazon.awssdk.services.iot.model.CreateDynamicThingGroupResponse;
import software.amazon.awssdk.services.iot.model.CreateFleetMetricRequest;
import software.amazon.awssdk.services.iot.model.CreateFleetMetricResponse;
import software.amazon.awssdk.services.iot.model.CreateJobRequest;
import software.amazon.awssdk.services.iot.model.CreateJobResponse;
import software.amazon.awssdk.services.iot.model.CreateJobTemplateRequest;
import software.amazon.awssdk.services.iot.model.CreateJobTemplateResponse;
import software.amazon.awssdk.services.iot.model.CreateKeysAndCertificateRequest;
import software.amazon.awssdk.services.iot.model.CreateKeysAndCertificateResponse;
import software.amazon.awssdk.services.iot.model.CreateMitigationActionRequest;
import software.amazon.awssdk.services.iot.model.CreateMitigationActionResponse;
import software.amazon.awssdk.services.iot.model.CreateOtaUpdateRequest;
import software.amazon.awssdk.services.iot.model.CreateOtaUpdateResponse;
import software.amazon.awssdk.services.iot.model.CreatePackageRequest;
import software.amazon.awssdk.services.iot.model.CreatePackageResponse;
import software.amazon.awssdk.services.iot.model.CreatePackageVersionRequest;
import software.amazon.awssdk.services.iot.model.CreatePackageVersionResponse;
import software.amazon.awssdk.services.iot.model.CreatePolicyRequest;
import software.amazon.awssdk.services.iot.model.CreatePolicyResponse;
import software.amazon.awssdk.services.iot.model.CreatePolicyVersionRequest;
import software.amazon.awssdk.services.iot.model.CreatePolicyVersionResponse;
import software.amazon.awssdk.services.iot.model.CreateProvisioningClaimRequest;
import software.amazon.awssdk.services.iot.model.CreateProvisioningClaimResponse;
import software.amazon.awssdk.services.iot.model.CreateProvisioningTemplateRequest;
import software.amazon.awssdk.services.iot.model.CreateProvisioningTemplateResponse;
import software.amazon.awssdk.services.iot.model.CreateProvisioningTemplateVersionRequest;
import software.amazon.awssdk.services.iot.model.CreateProvisioningTemplateVersionResponse;
import software.amazon.awssdk.services.iot.model.CreateRoleAliasRequest;
import software.amazon.awssdk.services.iot.model.CreateRoleAliasResponse;
import software.amazon.awssdk.services.iot.model.CreateScheduledAuditRequest;
import software.amazon.awssdk.services.iot.model.CreateScheduledAuditResponse;
import software.amazon.awssdk.services.iot.model.CreateSecurityProfileRequest;
import software.amazon.awssdk.services.iot.model.CreateSecurityProfileResponse;
import software.amazon.awssdk.services.iot.model.CreateStreamRequest;
import software.amazon.awssdk.services.iot.model.CreateStreamResponse;
import software.amazon.awssdk.services.iot.model.CreateThingGroupRequest;
import software.amazon.awssdk.services.iot.model.CreateThingGroupResponse;
import software.amazon.awssdk.services.iot.model.CreateThingRequest;
import software.amazon.awssdk.services.iot.model.CreateThingResponse;
import software.amazon.awssdk.services.iot.model.CreateThingTypeRequest;
import software.amazon.awssdk.services.iot.model.CreateThingTypeResponse;
import software.amazon.awssdk.services.iot.model.CreateTopicRuleDestinationRequest;
import software.amazon.awssdk.services.iot.model.CreateTopicRuleDestinationResponse;
import software.amazon.awssdk.services.iot.model.CreateTopicRuleRequest;
import software.amazon.awssdk.services.iot.model.CreateTopicRuleResponse;
import software.amazon.awssdk.services.iot.model.DeleteAccountAuditConfigurationRequest;
import software.amazon.awssdk.services.iot.model.DeleteAccountAuditConfigurationResponse;
import software.amazon.awssdk.services.iot.model.DeleteAuditSuppressionRequest;
import software.amazon.awssdk.services.iot.model.DeleteAuditSuppressionResponse;
import software.amazon.awssdk.services.iot.model.DeleteAuthorizerRequest;
import software.amazon.awssdk.services.iot.model.DeleteAuthorizerResponse;
import software.amazon.awssdk.services.iot.model.DeleteBillingGroupRequest;
import software.amazon.awssdk.services.iot.model.DeleteBillingGroupResponse;
import software.amazon.awssdk.services.iot.model.DeleteCaCertificateRequest;
import software.amazon.awssdk.services.iot.model.DeleteCaCertificateResponse;
import software.amazon.awssdk.services.iot.model.DeleteCertificateProviderRequest;
import software.amazon.awssdk.services.iot.model.DeleteCertificateProviderResponse;
import software.amazon.awssdk.services.iot.model.DeleteCertificateRequest;
import software.amazon.awssdk.services.iot.model.DeleteCertificateResponse;
import software.amazon.awssdk.services.iot.model.DeleteConflictException;
import software.amazon.awssdk.services.iot.model.DeleteCustomMetricRequest;
import software.amazon.awssdk.services.iot.model.DeleteCustomMetricResponse;
import software.amazon.awssdk.services.iot.model.DeleteDimensionRequest;
import software.amazon.awssdk.services.iot.model.DeleteDimensionResponse;
import software.amazon.awssdk.services.iot.model.DeleteDomainConfigurationRequest;
import software.amazon.awssdk.services.iot.model.DeleteDomainConfigurationResponse;
import software.amazon.awssdk.services.iot.model.DeleteDynamicThingGroupRequest;
import software.amazon.awssdk.services.iot.model.DeleteDynamicThingGroupResponse;
import software.amazon.awssdk.services.iot.model.DeleteFleetMetricRequest;
import software.amazon.awssdk.services.iot.model.DeleteFleetMetricResponse;
import software.amazon.awssdk.services.iot.model.DeleteJobExecutionRequest;
import software.amazon.awssdk.services.iot.model.DeleteJobExecutionResponse;
import software.amazon.awssdk.services.iot.model.DeleteJobRequest;
import software.amazon.awssdk.services.iot.model.DeleteJobResponse;
import software.amazon.awssdk.services.iot.model.DeleteJobTemplateRequest;
import software.amazon.awssdk.services.iot.model.DeleteJobTemplateResponse;
import software.amazon.awssdk.services.iot.model.DeleteMitigationActionRequest;
import software.amazon.awssdk.services.iot.model.DeleteMitigationActionResponse;
import software.amazon.awssdk.services.iot.model.DeleteOtaUpdateRequest;
import software.amazon.awssdk.services.iot.model.DeleteOtaUpdateResponse;
import software.amazon.awssdk.services.iot.model.DeletePackageRequest;
import software.amazon.awssdk.services.iot.model.DeletePackageResponse;
import software.amazon.awssdk.services.iot.model.DeletePackageVersionRequest;
import software.amazon.awssdk.services.iot.model.DeletePackageVersionResponse;
import software.amazon.awssdk.services.iot.model.DeletePolicyRequest;
import software.amazon.awssdk.services.iot.model.DeletePolicyResponse;
import software.amazon.awssdk.services.iot.model.DeletePolicyVersionRequest;
import software.amazon.awssdk.services.iot.model.DeletePolicyVersionResponse;
import software.amazon.awssdk.services.iot.model.DeleteProvisioningTemplateRequest;
import software.amazon.awssdk.services.iot.model.DeleteProvisioningTemplateResponse;
import software.amazon.awssdk.services.iot.model.DeleteProvisioningTemplateVersionRequest;
import software.amazon.awssdk.services.iot.model.DeleteProvisioningTemplateVersionResponse;
import software.amazon.awssdk.services.iot.model.DeleteRegistrationCodeRequest;
import software.amazon.awssdk.services.iot.model.DeleteRegistrationCodeResponse;
import software.amazon.awssdk.services.iot.model.DeleteRoleAliasRequest;
import software.amazon.awssdk.services.iot.model.DeleteRoleAliasResponse;
import software.amazon.awssdk.services.iot.model.DeleteScheduledAuditRequest;
import software.amazon.awssdk.services.iot.model.DeleteScheduledAuditResponse;
import software.amazon.awssdk.services.iot.model.DeleteSecurityProfileRequest;
import software.amazon.awssdk.services.iot.model.DeleteSecurityProfileResponse;
import software.amazon.awssdk.services.iot.model.DeleteStreamRequest;
import software.amazon.awssdk.services.iot.model.DeleteStreamResponse;
import software.amazon.awssdk.services.iot.model.DeleteThingGroupRequest;
import software.amazon.awssdk.services.iot.model.DeleteThingGroupResponse;
import software.amazon.awssdk.services.iot.model.DeleteThingRequest;
import software.amazon.awssdk.services.iot.model.DeleteThingResponse;
import software.amazon.awssdk.services.iot.model.DeleteThingTypeRequest;
import software.amazon.awssdk.services.iot.model.DeleteThingTypeResponse;
import software.amazon.awssdk.services.iot.model.DeleteTopicRuleDestinationRequest;
import software.amazon.awssdk.services.iot.model.DeleteTopicRuleDestinationResponse;
import software.amazon.awssdk.services.iot.model.DeleteTopicRuleRequest;
import software.amazon.awssdk.services.iot.model.DeleteTopicRuleResponse;
import software.amazon.awssdk.services.iot.model.DeleteV2LoggingLevelRequest;
import software.amazon.awssdk.services.iot.model.DeleteV2LoggingLevelResponse;
import software.amazon.awssdk.services.iot.model.DeprecateThingTypeRequest;
import software.amazon.awssdk.services.iot.model.DeprecateThingTypeResponse;
import software.amazon.awssdk.services.iot.model.DescribeAccountAuditConfigurationRequest;
import software.amazon.awssdk.services.iot.model.DescribeAccountAuditConfigurationResponse;
import software.amazon.awssdk.services.iot.model.DescribeAuditFindingRequest;
import software.amazon.awssdk.services.iot.model.DescribeAuditFindingResponse;
import software.amazon.awssdk.services.iot.model.DescribeAuditMitigationActionsTaskRequest;
import software.amazon.awssdk.services.iot.model.DescribeAuditMitigationActionsTaskResponse;
import software.amazon.awssdk.services.iot.model.DescribeAuditSuppressionRequest;
import software.amazon.awssdk.services.iot.model.DescribeAuditSuppressionResponse;
import software.amazon.awssdk.services.iot.model.DescribeAuditTaskRequest;
import software.amazon.awssdk.services.iot.model.DescribeAuditTaskResponse;
import software.amazon.awssdk.services.iot.model.DescribeAuthorizerRequest;
import software.amazon.awssdk.services.iot.model.DescribeAuthorizerResponse;
import software.amazon.awssdk.services.iot.model.DescribeBillingGroupRequest;
import software.amazon.awssdk.services.iot.model.DescribeBillingGroupResponse;
import software.amazon.awssdk.services.iot.model.DescribeCaCertificateRequest;
import software.amazon.awssdk.services.iot.model.DescribeCaCertificateResponse;
import software.amazon.awssdk.services.iot.model.DescribeCertificateProviderRequest;
import software.amazon.awssdk.services.iot.model.DescribeCertificateProviderResponse;
import software.amazon.awssdk.services.iot.model.DescribeCertificateRequest;
import software.amazon.awssdk.services.iot.model.DescribeCertificateResponse;
import software.amazon.awssdk.services.iot.model.DescribeCustomMetricRequest;
import software.amazon.awssdk.services.iot.model.DescribeCustomMetricResponse;
import software.amazon.awssdk.services.iot.model.DescribeDefaultAuthorizerRequest;
import software.amazon.awssdk.services.iot.model.DescribeDefaultAuthorizerResponse;
import software.amazon.awssdk.services.iot.model.DescribeDetectMitigationActionsTaskRequest;
import software.amazon.awssdk.services.iot.model.DescribeDetectMitigationActionsTaskResponse;
import software.amazon.awssdk.services.iot.model.DescribeDimensionRequest;
import software.amazon.awssdk.services.iot.model.DescribeDimensionResponse;
import software.amazon.awssdk.services.iot.model.DescribeDomainConfigurationRequest;
import software.amazon.awssdk.services.iot.model.DescribeDomainConfigurationResponse;
import software.amazon.awssdk.services.iot.model.DescribeEndpointRequest;
import software.amazon.awssdk.services.iot.model.DescribeEndpointResponse;
import software.amazon.awssdk.services.iot.model.DescribeEventConfigurationsRequest;
import software.amazon.awssdk.services.iot.model.DescribeEventConfigurationsResponse;
import software.amazon.awssdk.services.iot.model.DescribeFleetMetricRequest;
import software.amazon.awssdk.services.iot.model.DescribeFleetMetricResponse;
import software.amazon.awssdk.services.iot.model.DescribeIndexRequest;
import software.amazon.awssdk.services.iot.model.DescribeIndexResponse;
import software.amazon.awssdk.services.iot.model.DescribeJobExecutionRequest;
import software.amazon.awssdk.services.iot.model.DescribeJobExecutionResponse;
import software.amazon.awssdk.services.iot.model.DescribeJobRequest;
import software.amazon.awssdk.services.iot.model.DescribeJobResponse;
import software.amazon.awssdk.services.iot.model.DescribeJobTemplateRequest;
import software.amazon.awssdk.services.iot.model.DescribeJobTemplateResponse;
import software.amazon.awssdk.services.iot.model.DescribeManagedJobTemplateRequest;
import software.amazon.awssdk.services.iot.model.DescribeManagedJobTemplateResponse;
import software.amazon.awssdk.services.iot.model.DescribeMitigationActionRequest;
import software.amazon.awssdk.services.iot.model.DescribeMitigationActionResponse;
import software.amazon.awssdk.services.iot.model.DescribeProvisioningTemplateRequest;
import software.amazon.awssdk.services.iot.model.DescribeProvisioningTemplateResponse;
import software.amazon.awssdk.services.iot.model.DescribeProvisioningTemplateVersionRequest;
import software.amazon.awssdk.services.iot.model.DescribeProvisioningTemplateVersionResponse;
import software.amazon.awssdk.services.iot.model.DescribeRoleAliasRequest;
import software.amazon.awssdk.services.iot.model.DescribeRoleAliasResponse;
import software.amazon.awssdk.services.iot.model.DescribeScheduledAuditRequest;
import software.amazon.awssdk.services.iot.model.DescribeScheduledAuditResponse;
import software.amazon.awssdk.services.iot.model.DescribeSecurityProfileRequest;
import software.amazon.awssdk.services.iot.model.DescribeSecurityProfileResponse;
import software.amazon.awssdk.services.iot.model.DescribeStreamRequest;
import software.amazon.awssdk.services.iot.model.DescribeStreamResponse;
import software.amazon.awssdk.services.iot.model.DescribeThingGroupRequest;
import software.amazon.awssdk.services.iot.model.DescribeThingGroupResponse;
import software.amazon.awssdk.services.iot.model.DescribeThingRegistrationTaskRequest;
import software.amazon.awssdk.services.iot.model.DescribeThingRegistrationTaskResponse;
import software.amazon.awssdk.services.iot.model.DescribeThingRequest;
import software.amazon.awssdk.services.iot.model.DescribeThingResponse;
import software.amazon.awssdk.services.iot.model.DescribeThingTypeRequest;
import software.amazon.awssdk.services.iot.model.DescribeThingTypeResponse;
import software.amazon.awssdk.services.iot.model.DetachPolicyRequest;
import software.amazon.awssdk.services.iot.model.DetachPolicyResponse;
import software.amazon.awssdk.services.iot.model.DetachSecurityProfileRequest;
import software.amazon.awssdk.services.iot.model.DetachSecurityProfileResponse;
import software.amazon.awssdk.services.iot.model.DetachThingPrincipalRequest;
import software.amazon.awssdk.services.iot.model.DetachThingPrincipalResponse;
import software.amazon.awssdk.services.iot.model.DisableTopicRuleRequest;
import software.amazon.awssdk.services.iot.model.DisableTopicRuleResponse;
import software.amazon.awssdk.services.iot.model.EnableTopicRuleRequest;
import software.amazon.awssdk.services.iot.model.EnableTopicRuleResponse;
import software.amazon.awssdk.services.iot.model.GetBehaviorModelTrainingSummariesRequest;
import software.amazon.awssdk.services.iot.model.GetBehaviorModelTrainingSummariesResponse;
import software.amazon.awssdk.services.iot.model.GetBucketsAggregationRequest;
import software.amazon.awssdk.services.iot.model.GetBucketsAggregationResponse;
import software.amazon.awssdk.services.iot.model.GetCardinalityRequest;
import software.amazon.awssdk.services.iot.model.GetCardinalityResponse;
import software.amazon.awssdk.services.iot.model.GetEffectivePoliciesRequest;
import software.amazon.awssdk.services.iot.model.GetEffectivePoliciesResponse;
import software.amazon.awssdk.services.iot.model.GetIndexingConfigurationRequest;
import software.amazon.awssdk.services.iot.model.GetIndexingConfigurationResponse;
import software.amazon.awssdk.services.iot.model.GetJobDocumentRequest;
import software.amazon.awssdk.services.iot.model.GetJobDocumentResponse;
import software.amazon.awssdk.services.iot.model.GetLoggingOptionsRequest;
import software.amazon.awssdk.services.iot.model.GetLoggingOptionsResponse;
import software.amazon.awssdk.services.iot.model.GetOtaUpdateRequest;
import software.amazon.awssdk.services.iot.model.GetOtaUpdateResponse;
import software.amazon.awssdk.services.iot.model.GetPackageConfigurationRequest;
import software.amazon.awssdk.services.iot.model.GetPackageConfigurationResponse;
import software.amazon.awssdk.services.iot.model.GetPackageRequest;
import software.amazon.awssdk.services.iot.model.GetPackageResponse;
import software.amazon.awssdk.services.iot.model.GetPackageVersionRequest;
import software.amazon.awssdk.services.iot.model.GetPackageVersionResponse;
import software.amazon.awssdk.services.iot.model.GetPercentilesRequest;
import software.amazon.awssdk.services.iot.model.GetPercentilesResponse;
import software.amazon.awssdk.services.iot.model.GetPolicyRequest;
import software.amazon.awssdk.services.iot.model.GetPolicyResponse;
import software.amazon.awssdk.services.iot.model.GetPolicyVersionRequest;
import software.amazon.awssdk.services.iot.model.GetPolicyVersionResponse;
import software.amazon.awssdk.services.iot.model.GetRegistrationCodeRequest;
import software.amazon.awssdk.services.iot.model.GetRegistrationCodeResponse;
import software.amazon.awssdk.services.iot.model.GetStatisticsRequest;
import software.amazon.awssdk.services.iot.model.GetStatisticsResponse;
import software.amazon.awssdk.services.iot.model.GetTopicRuleDestinationRequest;
import software.amazon.awssdk.services.iot.model.GetTopicRuleDestinationResponse;
import software.amazon.awssdk.services.iot.model.GetTopicRuleRequest;
import software.amazon.awssdk.services.iot.model.GetTopicRuleResponse;
import software.amazon.awssdk.services.iot.model.GetV2LoggingOptionsRequest;
import software.amazon.awssdk.services.iot.model.GetV2LoggingOptionsResponse;
import software.amazon.awssdk.services.iot.model.IndexNotReadyException;
import software.amazon.awssdk.services.iot.model.InternalException;
import software.amazon.awssdk.services.iot.model.InternalFailureException;
import software.amazon.awssdk.services.iot.model.InternalServerException;
import software.amazon.awssdk.services.iot.model.InvalidAggregationException;
import software.amazon.awssdk.services.iot.model.InvalidQueryException;
import software.amazon.awssdk.services.iot.model.InvalidRequestException;
import software.amazon.awssdk.services.iot.model.InvalidResponseException;
import software.amazon.awssdk.services.iot.model.InvalidStateTransitionException;
import software.amazon.awssdk.services.iot.model.IotException;
import software.amazon.awssdk.services.iot.model.LimitExceededException;
import software.amazon.awssdk.services.iot.model.ListActiveViolationsRequest;
import software.amazon.awssdk.services.iot.model.ListActiveViolationsResponse;
import software.amazon.awssdk.services.iot.model.ListAttachedPoliciesRequest;
import software.amazon.awssdk.services.iot.model.ListAttachedPoliciesResponse;
import software.amazon.awssdk.services.iot.model.ListAuditFindingsRequest;
import software.amazon.awssdk.services.iot.model.ListAuditFindingsResponse;
import software.amazon.awssdk.services.iot.model.ListAuditMitigationActionsExecutionsRequest;
import software.amazon.awssdk.services.iot.model.ListAuditMitigationActionsExecutionsResponse;
import software.amazon.awssdk.services.iot.model.ListAuditMitigationActionsTasksRequest;
import software.amazon.awssdk.services.iot.model.ListAuditMitigationActionsTasksResponse;
import software.amazon.awssdk.services.iot.model.ListAuditSuppressionsRequest;
import software.amazon.awssdk.services.iot.model.ListAuditSuppressionsResponse;
import software.amazon.awssdk.services.iot.model.ListAuditTasksRequest;
import software.amazon.awssdk.services.iot.model.ListAuditTasksResponse;
import software.amazon.awssdk.services.iot.model.ListAuthorizersRequest;
import software.amazon.awssdk.services.iot.model.ListAuthorizersResponse;
import software.amazon.awssdk.services.iot.model.ListBillingGroupsRequest;
import software.amazon.awssdk.services.iot.model.ListBillingGroupsResponse;
import software.amazon.awssdk.services.iot.model.ListCaCertificatesRequest;
import software.amazon.awssdk.services.iot.model.ListCaCertificatesResponse;
import software.amazon.awssdk.services.iot.model.ListCertificateProvidersRequest;
import software.amazon.awssdk.services.iot.model.ListCertificateProvidersResponse;
import software.amazon.awssdk.services.iot.model.ListCertificatesByCaRequest;
import software.amazon.awssdk.services.iot.model.ListCertificatesByCaResponse;
import software.amazon.awssdk.services.iot.model.ListCertificatesRequest;
import software.amazon.awssdk.services.iot.model.ListCertificatesResponse;
import software.amazon.awssdk.services.iot.model.ListCustomMetricsRequest;
import software.amazon.awssdk.services.iot.model.ListCustomMetricsResponse;
import software.amazon.awssdk.services.iot.model.ListDetectMitigationActionsExecutionsRequest;
import software.amazon.awssdk.services.iot.model.ListDetectMitigationActionsExecutionsResponse;
import software.amazon.awssdk.services.iot.model.ListDetectMitigationActionsTasksRequest;
import software.amazon.awssdk.services.iot.model.ListDetectMitigationActionsTasksResponse;
import software.amazon.awssdk.services.iot.model.ListDimensionsRequest;
import software.amazon.awssdk.services.iot.model.ListDimensionsResponse;
import software.amazon.awssdk.services.iot.model.ListDomainConfigurationsRequest;
import software.amazon.awssdk.services.iot.model.ListDomainConfigurationsResponse;
import software.amazon.awssdk.services.iot.model.ListFleetMetricsRequest;
import software.amazon.awssdk.services.iot.model.ListFleetMetricsResponse;
import software.amazon.awssdk.services.iot.model.ListIndicesRequest;
import software.amazon.awssdk.services.iot.model.ListIndicesResponse;
import software.amazon.awssdk.services.iot.model.ListJobExecutionsForJobRequest;
import software.amazon.awssdk.services.iot.model.ListJobExecutionsForJobResponse;
import software.amazon.awssdk.services.iot.model.ListJobExecutionsForThingRequest;
import software.amazon.awssdk.services.iot.model.ListJobExecutionsForThingResponse;
import software.amazon.awssdk.services.iot.model.ListJobTemplatesRequest;
import software.amazon.awssdk.services.iot.model.ListJobTemplatesResponse;
import software.amazon.awssdk.services.iot.model.ListJobsRequest;
import software.amazon.awssdk.services.iot.model.ListJobsResponse;
import software.amazon.awssdk.services.iot.model.ListManagedJobTemplatesRequest;
import software.amazon.awssdk.services.iot.model.ListManagedJobTemplatesResponse;
import software.amazon.awssdk.services.iot.model.ListMetricValuesRequest;
import software.amazon.awssdk.services.iot.model.ListMetricValuesResponse;
import software.amazon.awssdk.services.iot.model.ListMitigationActionsRequest;
import software.amazon.awssdk.services.iot.model.ListMitigationActionsResponse;
import software.amazon.awssdk.services.iot.model.ListOtaUpdatesRequest;
import software.amazon.awssdk.services.iot.model.ListOtaUpdatesResponse;
import software.amazon.awssdk.services.iot.model.ListOutgoingCertificatesRequest;
import software.amazon.awssdk.services.iot.model.ListOutgoingCertificatesResponse;
import software.amazon.awssdk.services.iot.model.ListPackageVersionsRequest;
import software.amazon.awssdk.services.iot.model.ListPackageVersionsResponse;
import software.amazon.awssdk.services.iot.model.ListPackagesRequest;
import software.amazon.awssdk.services.iot.model.ListPackagesResponse;
import software.amazon.awssdk.services.iot.model.ListPoliciesRequest;
import software.amazon.awssdk.services.iot.model.ListPoliciesResponse;
import software.amazon.awssdk.services.iot.model.ListPolicyVersionsRequest;
import software.amazon.awssdk.services.iot.model.ListPolicyVersionsResponse;
import software.amazon.awssdk.services.iot.model.ListPrincipalThingsRequest;
import software.amazon.awssdk.services.iot.model.ListPrincipalThingsResponse;
import software.amazon.awssdk.services.iot.model.ListProvisioningTemplateVersionsRequest;
import software.amazon.awssdk.services.iot.model.ListProvisioningTemplateVersionsResponse;
import software.amazon.awssdk.services.iot.model.ListProvisioningTemplatesRequest;
import software.amazon.awssdk.services.iot.model.ListProvisioningTemplatesResponse;
import software.amazon.awssdk.services.iot.model.ListRelatedResourcesForAuditFindingRequest;
import software.amazon.awssdk.services.iot.model.ListRelatedResourcesForAuditFindingResponse;
import software.amazon.awssdk.services.iot.model.ListRoleAliasesRequest;
import software.amazon.awssdk.services.iot.model.ListRoleAliasesResponse;
import software.amazon.awssdk.services.iot.model.ListScheduledAuditsRequest;
import software.amazon.awssdk.services.iot.model.ListScheduledAuditsResponse;
import software.amazon.awssdk.services.iot.model.ListSecurityProfilesForTargetRequest;
import software.amazon.awssdk.services.iot.model.ListSecurityProfilesForTargetResponse;
import software.amazon.awssdk.services.iot.model.ListSecurityProfilesRequest;
import software.amazon.awssdk.services.iot.model.ListSecurityProfilesResponse;
import software.amazon.awssdk.services.iot.model.ListStreamsRequest;
import software.amazon.awssdk.services.iot.model.ListStreamsResponse;
import software.amazon.awssdk.services.iot.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.iot.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.iot.model.ListTargetsForPolicyRequest;
import software.amazon.awssdk.services.iot.model.ListTargetsForPolicyResponse;
import software.amazon.awssdk.services.iot.model.ListTargetsForSecurityProfileRequest;
import software.amazon.awssdk.services.iot.model.ListTargetsForSecurityProfileResponse;
import software.amazon.awssdk.services.iot.model.ListThingGroupsForThingRequest;
import software.amazon.awssdk.services.iot.model.ListThingGroupsForThingResponse;
import software.amazon.awssdk.services.iot.model.ListThingGroupsRequest;
import software.amazon.awssdk.services.iot.model.ListThingGroupsResponse;
import software.amazon.awssdk.services.iot.model.ListThingPrincipalsRequest;
import software.amazon.awssdk.services.iot.model.ListThingPrincipalsResponse;
import software.amazon.awssdk.services.iot.model.ListThingRegistrationTaskReportsRequest;
import software.amazon.awssdk.services.iot.model.ListThingRegistrationTaskReportsResponse;
import software.amazon.awssdk.services.iot.model.ListThingRegistrationTasksRequest;
import software.amazon.awssdk.services.iot.model.ListThingRegistrationTasksResponse;
import software.amazon.awssdk.services.iot.model.ListThingTypesRequest;
import software.amazon.awssdk.services.iot.model.ListThingTypesResponse;
import software.amazon.awssdk.services.iot.model.ListThingsInBillingGroupRequest;
import software.amazon.awssdk.services.iot.model.ListThingsInBillingGroupResponse;
import software.amazon.awssdk.services.iot.model.ListThingsInThingGroupRequest;
import software.amazon.awssdk.services.iot.model.ListThingsInThingGroupResponse;
import software.amazon.awssdk.services.iot.model.ListThingsRequest;
import software.amazon.awssdk.services.iot.model.ListThingsResponse;
import software.amazon.awssdk.services.iot.model.ListTopicRuleDestinationsRequest;
import software.amazon.awssdk.services.iot.model.ListTopicRuleDestinationsResponse;
import software.amazon.awssdk.services.iot.model.ListTopicRulesRequest;
import software.amazon.awssdk.services.iot.model.ListTopicRulesResponse;
import software.amazon.awssdk.services.iot.model.ListV2LoggingLevelsRequest;
import software.amazon.awssdk.services.iot.model.ListV2LoggingLevelsResponse;
import software.amazon.awssdk.services.iot.model.ListViolationEventsRequest;
import software.amazon.awssdk.services.iot.model.ListViolationEventsResponse;
import software.amazon.awssdk.services.iot.model.MalformedPolicyException;
import software.amazon.awssdk.services.iot.model.NotConfiguredException;
import software.amazon.awssdk.services.iot.model.PutVerificationStateOnViolationRequest;
import software.amazon.awssdk.services.iot.model.PutVerificationStateOnViolationResponse;
import software.amazon.awssdk.services.iot.model.RegisterCaCertificateRequest;
import software.amazon.awssdk.services.iot.model.RegisterCaCertificateResponse;
import software.amazon.awssdk.services.iot.model.RegisterCertificateRequest;
import software.amazon.awssdk.services.iot.model.RegisterCertificateResponse;
import software.amazon.awssdk.services.iot.model.RegisterCertificateWithoutCaRequest;
import software.amazon.awssdk.services.iot.model.RegisterCertificateWithoutCaResponse;
import software.amazon.awssdk.services.iot.model.RegisterThingRequest;
import software.amazon.awssdk.services.iot.model.RegisterThingResponse;
import software.amazon.awssdk.services.iot.model.RegistrationCodeValidationException;
import software.amazon.awssdk.services.iot.model.RejectCertificateTransferRequest;
import software.amazon.awssdk.services.iot.model.RejectCertificateTransferResponse;
import software.amazon.awssdk.services.iot.model.RemoveThingFromBillingGroupRequest;
import software.amazon.awssdk.services.iot.model.RemoveThingFromBillingGroupResponse;
import software.amazon.awssdk.services.iot.model.RemoveThingFromThingGroupRequest;
import software.amazon.awssdk.services.iot.model.RemoveThingFromThingGroupResponse;
import software.amazon.awssdk.services.iot.model.ReplaceTopicRuleRequest;
import software.amazon.awssdk.services.iot.model.ReplaceTopicRuleResponse;
import software.amazon.awssdk.services.iot.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.iot.model.ResourceNotFoundException;
import software.amazon.awssdk.services.iot.model.ResourceRegistrationFailureException;
import software.amazon.awssdk.services.iot.model.SearchIndexRequest;
import software.amazon.awssdk.services.iot.model.SearchIndexResponse;
import software.amazon.awssdk.services.iot.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.iot.model.ServiceUnavailableException;
import software.amazon.awssdk.services.iot.model.SetDefaultAuthorizerRequest;
import software.amazon.awssdk.services.iot.model.SetDefaultAuthorizerResponse;
import software.amazon.awssdk.services.iot.model.SetDefaultPolicyVersionRequest;
import software.amazon.awssdk.services.iot.model.SetDefaultPolicyVersionResponse;
import software.amazon.awssdk.services.iot.model.SetLoggingOptionsRequest;
import software.amazon.awssdk.services.iot.model.SetLoggingOptionsResponse;
import software.amazon.awssdk.services.iot.model.SetV2LoggingLevelRequest;
import software.amazon.awssdk.services.iot.model.SetV2LoggingLevelResponse;
import software.amazon.awssdk.services.iot.model.SetV2LoggingOptionsRequest;
import software.amazon.awssdk.services.iot.model.SetV2LoggingOptionsResponse;
import software.amazon.awssdk.services.iot.model.SqlParseException;
import software.amazon.awssdk.services.iot.model.StartAuditMitigationActionsTaskRequest;
import software.amazon.awssdk.services.iot.model.StartAuditMitigationActionsTaskResponse;
import software.amazon.awssdk.services.iot.model.StartDetectMitigationActionsTaskRequest;
import software.amazon.awssdk.services.iot.model.StartDetectMitigationActionsTaskResponse;
import software.amazon.awssdk.services.iot.model.StartOnDemandAuditTaskRequest;
import software.amazon.awssdk.services.iot.model.StartOnDemandAuditTaskResponse;
import software.amazon.awssdk.services.iot.model.StartThingRegistrationTaskRequest;
import software.amazon.awssdk.services.iot.model.StartThingRegistrationTaskResponse;
import software.amazon.awssdk.services.iot.model.StopThingRegistrationTaskRequest;
import software.amazon.awssdk.services.iot.model.StopThingRegistrationTaskResponse;
import software.amazon.awssdk.services.iot.model.TagResourceRequest;
import software.amazon.awssdk.services.iot.model.TagResourceResponse;
import software.amazon.awssdk.services.iot.model.TaskAlreadyExistsException;
import software.amazon.awssdk.services.iot.model.TestAuthorizationRequest;
import software.amazon.awssdk.services.iot.model.TestAuthorizationResponse;
import software.amazon.awssdk.services.iot.model.TestInvokeAuthorizerRequest;
import software.amazon.awssdk.services.iot.model.TestInvokeAuthorizerResponse;
import software.amazon.awssdk.services.iot.model.ThrottlingException;
import software.amazon.awssdk.services.iot.model.TransferAlreadyCompletedException;
import software.amazon.awssdk.services.iot.model.TransferCertificateRequest;
import software.amazon.awssdk.services.iot.model.TransferCertificateResponse;
import software.amazon.awssdk.services.iot.model.TransferConflictException;
import software.amazon.awssdk.services.iot.model.UnauthorizedException;
import software.amazon.awssdk.services.iot.model.UntagResourceRequest;
import software.amazon.awssdk.services.iot.model.UntagResourceResponse;
import software.amazon.awssdk.services.iot.model.UpdateAccountAuditConfigurationRequest;
import software.amazon.awssdk.services.iot.model.UpdateAccountAuditConfigurationResponse;
import software.amazon.awssdk.services.iot.model.UpdateAuditSuppressionRequest;
import software.amazon.awssdk.services.iot.model.UpdateAuditSuppressionResponse;
import software.amazon.awssdk.services.iot.model.UpdateAuthorizerRequest;
import software.amazon.awssdk.services.iot.model.UpdateAuthorizerResponse;
import software.amazon.awssdk.services.iot.model.UpdateBillingGroupRequest;
import software.amazon.awssdk.services.iot.model.UpdateBillingGroupResponse;
import software.amazon.awssdk.services.iot.model.UpdateCaCertificateRequest;
import software.amazon.awssdk.services.iot.model.UpdateCaCertificateResponse;
import software.amazon.awssdk.services.iot.model.UpdateCertificateProviderRequest;
import software.amazon.awssdk.services.iot.model.UpdateCertificateProviderResponse;
import software.amazon.awssdk.services.iot.model.UpdateCertificateRequest;
import software.amazon.awssdk.services.iot.model.UpdateCertificateResponse;
import software.amazon.awssdk.services.iot.model.UpdateCustomMetricRequest;
import software.amazon.awssdk.services.iot.model.UpdateCustomMetricResponse;
import software.amazon.awssdk.services.iot.model.UpdateDimensionRequest;
import software.amazon.awssdk.services.iot.model.UpdateDimensionResponse;
import software.amazon.awssdk.services.iot.model.UpdateDomainConfigurationRequest;
import software.amazon.awssdk.services.iot.model.UpdateDomainConfigurationResponse;
import software.amazon.awssdk.services.iot.model.UpdateDynamicThingGroupRequest;
import software.amazon.awssdk.services.iot.model.UpdateDynamicThingGroupResponse;
import software.amazon.awssdk.services.iot.model.UpdateEventConfigurationsRequest;
import software.amazon.awssdk.services.iot.model.UpdateEventConfigurationsResponse;
import software.amazon.awssdk.services.iot.model.UpdateFleetMetricRequest;
import software.amazon.awssdk.services.iot.model.UpdateFleetMetricResponse;
import software.amazon.awssdk.services.iot.model.UpdateIndexingConfigurationRequest;
import software.amazon.awssdk.services.iot.model.UpdateIndexingConfigurationResponse;
import software.amazon.awssdk.services.iot.model.UpdateJobRequest;
import software.amazon.awssdk.services.iot.model.UpdateJobResponse;
import software.amazon.awssdk.services.iot.model.UpdateMitigationActionRequest;
import software.amazon.awssdk.services.iot.model.UpdateMitigationActionResponse;
import software.amazon.awssdk.services.iot.model.UpdatePackageConfigurationRequest;
import software.amazon.awssdk.services.iot.model.UpdatePackageConfigurationResponse;
import software.amazon.awssdk.services.iot.model.UpdatePackageRequest;
import software.amazon.awssdk.services.iot.model.UpdatePackageResponse;
import software.amazon.awssdk.services.iot.model.UpdatePackageVersionRequest;
import software.amazon.awssdk.services.iot.model.UpdatePackageVersionResponse;
import software.amazon.awssdk.services.iot.model.UpdateProvisioningTemplateRequest;
import software.amazon.awssdk.services.iot.model.UpdateProvisioningTemplateResponse;
import software.amazon.awssdk.services.iot.model.UpdateRoleAliasRequest;
import software.amazon.awssdk.services.iot.model.UpdateRoleAliasResponse;
import software.amazon.awssdk.services.iot.model.UpdateScheduledAuditRequest;
import software.amazon.awssdk.services.iot.model.UpdateScheduledAuditResponse;
import software.amazon.awssdk.services.iot.model.UpdateSecurityProfileRequest;
import software.amazon.awssdk.services.iot.model.UpdateSecurityProfileResponse;
import software.amazon.awssdk.services.iot.model.UpdateStreamRequest;
import software.amazon.awssdk.services.iot.model.UpdateStreamResponse;
import software.amazon.awssdk.services.iot.model.UpdateThingGroupRequest;
import software.amazon.awssdk.services.iot.model.UpdateThingGroupResponse;
import software.amazon.awssdk.services.iot.model.UpdateThingGroupsForThingRequest;
import software.amazon.awssdk.services.iot.model.UpdateThingGroupsForThingResponse;
import software.amazon.awssdk.services.iot.model.UpdateThingRequest;
import software.amazon.awssdk.services.iot.model.UpdateThingResponse;
import software.amazon.awssdk.services.iot.model.UpdateTopicRuleDestinationRequest;
import software.amazon.awssdk.services.iot.model.UpdateTopicRuleDestinationResponse;
import software.amazon.awssdk.services.iot.model.ValidateSecurityProfileBehaviorsRequest;
import software.amazon.awssdk.services.iot.model.ValidateSecurityProfileBehaviorsResponse;
import software.amazon.awssdk.services.iot.model.ValidationException;
import software.amazon.awssdk.services.iot.model.VersionConflictException;
import software.amazon.awssdk.services.iot.model.VersionsLimitExceededException;
import software.amazon.awssdk.services.iot.paginators.GetBehaviorModelTrainingSummariesIterable;
import software.amazon.awssdk.services.iot.paginators.ListActiveViolationsIterable;
import software.amazon.awssdk.services.iot.paginators.ListAttachedPoliciesIterable;
import software.amazon.awssdk.services.iot.paginators.ListAuditFindingsIterable;
import software.amazon.awssdk.services.iot.paginators.ListAuditMitigationActionsExecutionsIterable;
import software.amazon.awssdk.services.iot.paginators.ListAuditMitigationActionsTasksIterable;
import software.amazon.awssdk.services.iot.paginators.ListAuditSuppressionsIterable;
import software.amazon.awssdk.services.iot.paginators.ListAuditTasksIterable;
import software.amazon.awssdk.services.iot.paginators.ListAuthorizersIterable;
import software.amazon.awssdk.services.iot.paginators.ListBillingGroupsIterable;
import software.amazon.awssdk.services.iot.paginators.ListCACertificatesIterable;
import software.amazon.awssdk.services.iot.paginators.ListCertificatesByCAIterable;
import software.amazon.awssdk.services.iot.paginators.ListCertificatesIterable;
import software.amazon.awssdk.services.iot.paginators.ListCustomMetricsIterable;
import software.amazon.awssdk.services.iot.paginators.ListDetectMitigationActionsExecutionsIterable;
import software.amazon.awssdk.services.iot.paginators.ListDetectMitigationActionsTasksIterable;
import software.amazon.awssdk.services.iot.paginators.ListDimensionsIterable;
import software.amazon.awssdk.services.iot.paginators.ListDomainConfigurationsIterable;
import software.amazon.awssdk.services.iot.paginators.ListFleetMetricsIterable;
import software.amazon.awssdk.services.iot.paginators.ListIndicesIterable;
import software.amazon.awssdk.services.iot.paginators.ListJobExecutionsForJobIterable;
import software.amazon.awssdk.services.iot.paginators.ListJobExecutionsForThingIterable;
import software.amazon.awssdk.services.iot.paginators.ListJobTemplatesIterable;
import software.amazon.awssdk.services.iot.paginators.ListJobsIterable;
import software.amazon.awssdk.services.iot.paginators.ListManagedJobTemplatesIterable;
import software.amazon.awssdk.services.iot.paginators.ListMetricValuesIterable;
import software.amazon.awssdk.services.iot.paginators.ListMitigationActionsIterable;
import software.amazon.awssdk.services.iot.paginators.ListOTAUpdatesIterable;
import software.amazon.awssdk.services.iot.paginators.ListOutgoingCertificatesIterable;
import software.amazon.awssdk.services.iot.paginators.ListPackageVersionsIterable;
import software.amazon.awssdk.services.iot.paginators.ListPackagesIterable;
import software.amazon.awssdk.services.iot.paginators.ListPoliciesIterable;
import software.amazon.awssdk.services.iot.paginators.ListPrincipalThingsIterable;
import software.amazon.awssdk.services.iot.paginators.ListProvisioningTemplateVersionsIterable;
import software.amazon.awssdk.services.iot.paginators.ListProvisioningTemplatesIterable;
import software.amazon.awssdk.services.iot.paginators.ListRelatedResourcesForAuditFindingIterable;
import software.amazon.awssdk.services.iot.paginators.ListRoleAliasesIterable;
import software.amazon.awssdk.services.iot.paginators.ListScheduledAuditsIterable;
import software.amazon.awssdk.services.iot.paginators.ListSecurityProfilesForTargetIterable;
import software.amazon.awssdk.services.iot.paginators.ListSecurityProfilesIterable;
import software.amazon.awssdk.services.iot.paginators.ListStreamsIterable;
import software.amazon.awssdk.services.iot.paginators.ListTagsForResourceIterable;
import software.amazon.awssdk.services.iot.paginators.ListTargetsForPolicyIterable;
import software.amazon.awssdk.services.iot.paginators.ListTargetsForSecurityProfileIterable;
import software.amazon.awssdk.services.iot.paginators.ListThingGroupsForThingIterable;
import software.amazon.awssdk.services.iot.paginators.ListThingGroupsIterable;
import software.amazon.awssdk.services.iot.paginators.ListThingPrincipalsIterable;
import software.amazon.awssdk.services.iot.paginators.ListThingRegistrationTaskReportsIterable;
import software.amazon.awssdk.services.iot.paginators.ListThingRegistrationTasksIterable;
import software.amazon.awssdk.services.iot.paginators.ListThingTypesIterable;
import software.amazon.awssdk.services.iot.paginators.ListThingsInBillingGroupIterable;
import software.amazon.awssdk.services.iot.paginators.ListThingsInThingGroupIterable;
import software.amazon.awssdk.services.iot.paginators.ListThingsIterable;
import software.amazon.awssdk.services.iot.paginators.ListTopicRuleDestinationsIterable;
import software.amazon.awssdk.services.iot.paginators.ListTopicRulesIterable;
import software.amazon.awssdk.services.iot.paginators.ListV2LoggingLevelsIterable;
import software.amazon.awssdk.services.iot.paginators.ListViolationEventsIterable;

/**
 * Service client for accessing AWS IoT. This can be created using the static {@link #builder()} method.
 *
 * <fullname>IoT</fullname>
 * <p>
 * IoT provides secure, bi-directional communication between Internet-connected devices (such as sensors, actuators,
 * embedded devices, or smart appliances) and the Amazon Web Services cloud. You can discover your custom IoT-Data
 * endpoint to communicate with, configure rules for data processing and integration with other services, organize
 * resources associated with each device (Registry), configure logging, and create and manage policies and credentials
 * to authenticate devices.
 * </p>
 * <p>
 * The service endpoints that expose this API are listed in <a
 * href="https://docs.aws.amazon.com/general/latest/gr/iot-core.html">Amazon Web Services IoT Core Endpoints and
 * Quotas</a>. You must use the endpoint for the region that has the resources you want to access.
 * </p>
 * <p>
 * The service name used by <a href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Amazon Web
 * Services Signature Version 4</a> to sign the request is: <i>execute-api</i>.
 * </p>
 * <p>
 * For more information about how IoT works, see the <a
 * href="https://docs.aws.amazon.com/iot/latest/developerguide/aws-iot-how-it-works.html">Developer Guide</a>.
 * </p>
 * <p>
 * For information about how to use the credentials provider for IoT, see <a
 * href="https://docs.aws.amazon.com/iot/latest/developerguide/authorizing-direct-aws.html">Authorizing Direct Calls to
 * Amazon Web Services Services</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface IotClient extends AwsClient {
    String SERVICE_NAME = "iot";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "iot";

    /**
     * <p>
     * Accepts a pending certificate transfer. The default state of the certificate is INACTIVE.
     * </p>
     * <p>
     * To check for pending certificate transfers, call <a>ListCertificates</a> to enumerate your certificates.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >AcceptCertificateTransfer</a> action.
     * </p>
     *
     * @param acceptCertificateTransferRequest
     *        The input for the AcceptCertificateTransfer operation.
     * @return Result of the AcceptCertificateTransfer operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws TransferAlreadyCompletedException
     *         You can't revert the certificate transfer because the transfer is already complete.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.AcceptCertificateTransfer
     */
    default AcceptCertificateTransferResponse acceptCertificateTransfer(
            AcceptCertificateTransferRequest acceptCertificateTransferRequest) throws ResourceNotFoundException,
            TransferAlreadyCompletedException, InvalidRequestException, ThrottlingException, UnauthorizedException,
            ServiceUnavailableException, InternalFailureException, AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Accepts a pending certificate transfer. The default state of the certificate is INACTIVE.
     * </p>
     * <p>
     * To check for pending certificate transfers, call <a>ListCertificates</a> to enumerate your certificates.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >AcceptCertificateTransfer</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AcceptCertificateTransferRequest.Builder} avoiding
     * the need to create one manually via {@link AcceptCertificateTransferRequest#builder()}
     * </p>
     *
     * @param acceptCertificateTransferRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.AcceptCertificateTransferRequest.Builder} to create a
     *        request. The input for the AcceptCertificateTransfer operation.
     * @return Result of the AcceptCertificateTransfer operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws TransferAlreadyCompletedException
     *         You can't revert the certificate transfer because the transfer is already complete.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.AcceptCertificateTransfer
     */
    default AcceptCertificateTransferResponse acceptCertificateTransfer(
            Consumer<AcceptCertificateTransferRequest.Builder> acceptCertificateTransferRequest)
            throws ResourceNotFoundException, TransferAlreadyCompletedException, InvalidRequestException, ThrottlingException,
            UnauthorizedException, ServiceUnavailableException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        return acceptCertificateTransfer(AcceptCertificateTransferRequest.builder()
                .applyMutation(acceptCertificateTransferRequest).build());
    }

    /**
     * <p>
     * Adds a thing to a billing group.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >AddThingToBillingGroup</a> action.
     * </p>
     *
     * @param addThingToBillingGroupRequest
     * @return Result of the AddThingToBillingGroup operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.AddThingToBillingGroup
     */
    default AddThingToBillingGroupResponse addThingToBillingGroup(AddThingToBillingGroupRequest addThingToBillingGroupRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a thing to a billing group.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >AddThingToBillingGroup</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddThingToBillingGroupRequest.Builder} avoiding the
     * need to create one manually via {@link AddThingToBillingGroupRequest#builder()}
     * </p>
     *
     * @param addThingToBillingGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.AddThingToBillingGroupRequest.Builder} to create a
     *        request.
     * @return Result of the AddThingToBillingGroup operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.AddThingToBillingGroup
     */
    default AddThingToBillingGroupResponse addThingToBillingGroup(
            Consumer<AddThingToBillingGroupRequest.Builder> addThingToBillingGroupRequest) throws InvalidRequestException,
            ThrottlingException, InternalFailureException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            IotException {
        return addThingToBillingGroup(AddThingToBillingGroupRequest.builder().applyMutation(addThingToBillingGroupRequest)
                .build());
    }

    /**
     * <p>
     * Adds a thing to a thing group.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >AddThingToThingGroup</a> action.
     * </p>
     *
     * @param addThingToThingGroupRequest
     * @return Result of the AddThingToThingGroup operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.AddThingToThingGroup
     */
    default AddThingToThingGroupResponse addThingToThingGroup(AddThingToThingGroupRequest addThingToThingGroupRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a thing to a thing group.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >AddThingToThingGroup</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddThingToThingGroupRequest.Builder} avoiding the
     * need to create one manually via {@link AddThingToThingGroupRequest#builder()}
     * </p>
     *
     * @param addThingToThingGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.AddThingToThingGroupRequest.Builder} to create a request.
     * @return Result of the AddThingToThingGroup operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.AddThingToThingGroup
     */
    default AddThingToThingGroupResponse addThingToThingGroup(
            Consumer<AddThingToThingGroupRequest.Builder> addThingToThingGroupRequest) throws InvalidRequestException,
            ThrottlingException, InternalFailureException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            IotException {
        return addThingToThingGroup(AddThingToThingGroupRequest.builder().applyMutation(addThingToThingGroupRequest).build());
    }

    /**
     * <p>
     * Associates a group with a continuous job. The following criteria must be met:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The job must have been created with the <code>targetSelection</code> field set to "CONTINUOUS".
     * </p>
     * </li>
     * <li>
     * <p>
     * The job status must currently be "IN_PROGRESS".
     * </p>
     * </li>
     * <li>
     * <p>
     * The total number of targets associated with a job must not exceed 100.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >AssociateTargetsWithJob</a> action.
     * </p>
     *
     * @param associateTargetsWithJobRequest
     * @return Result of the AssociateTargetsWithJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.AssociateTargetsWithJob
     */
    default AssociateTargetsWithJobResponse associateTargetsWithJob(AssociateTargetsWithJobRequest associateTargetsWithJobRequest)
            throws InvalidRequestException, ResourceNotFoundException, LimitExceededException, ThrottlingException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a group with a continuous job. The following criteria must be met:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The job must have been created with the <code>targetSelection</code> field set to "CONTINUOUS".
     * </p>
     * </li>
     * <li>
     * <p>
     * The job status must currently be "IN_PROGRESS".
     * </p>
     * </li>
     * <li>
     * <p>
     * The total number of targets associated with a job must not exceed 100.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >AssociateTargetsWithJob</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateTargetsWithJobRequest.Builder} avoiding
     * the need to create one manually via {@link AssociateTargetsWithJobRequest#builder()}
     * </p>
     *
     * @param associateTargetsWithJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.AssociateTargetsWithJobRequest.Builder} to create a
     *        request.
     * @return Result of the AssociateTargetsWithJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.AssociateTargetsWithJob
     */
    default AssociateTargetsWithJobResponse associateTargetsWithJob(
            Consumer<AssociateTargetsWithJobRequest.Builder> associateTargetsWithJobRequest) throws InvalidRequestException,
            ResourceNotFoundException, LimitExceededException, ThrottlingException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, IotException {
        return associateTargetsWithJob(AssociateTargetsWithJobRequest.builder().applyMutation(associateTargetsWithJobRequest)
                .build());
    }

    /**
     * <p>
     * Attaches the specified policy to the specified principal (certificate or other credential).
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >AttachPolicy</a> action.
     * </p>
     *
     * @param attachPolicyRequest
     * @return Result of the AttachPolicy operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.AttachPolicy
     */
    default AttachPolicyResponse attachPolicy(AttachPolicyRequest attachPolicyRequest) throws ResourceNotFoundException,
            InvalidRequestException, ThrottlingException, UnauthorizedException, ServiceUnavailableException,
            InternalFailureException, LimitExceededException, AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attaches the specified policy to the specified principal (certificate or other credential).
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >AttachPolicy</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AttachPolicyRequest.Builder} avoiding the need to
     * create one manually via {@link AttachPolicyRequest#builder()}
     * </p>
     *
     * @param attachPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.AttachPolicyRequest.Builder} to create a request.
     * @return Result of the AttachPolicy operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.AttachPolicy
     */
    default AttachPolicyResponse attachPolicy(Consumer<AttachPolicyRequest.Builder> attachPolicyRequest)
            throws ResourceNotFoundException, InvalidRequestException, ThrottlingException, UnauthorizedException,
            ServiceUnavailableException, InternalFailureException, LimitExceededException, AwsServiceException,
            SdkClientException, IotException {
        return attachPolicy(AttachPolicyRequest.builder().applyMutation(attachPolicyRequest).build());
    }

    /**
     * <p>
     * Associates a Device Defender security profile with a thing group or this account. Each thing group or account can
     * have up to five security profiles associated with it.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >AttachSecurityProfile</a> action.
     * </p>
     *
     * @param attachSecurityProfileRequest
     * @return Result of the AttachSecurityProfile operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws VersionConflictException
     *         An exception thrown when the version of an entity specified with the <code>expectedVersion</code>
     *         parameter does not match the latest version in the system.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.AttachSecurityProfile
     */
    default AttachSecurityProfileResponse attachSecurityProfile(AttachSecurityProfileRequest attachSecurityProfileRequest)
            throws InvalidRequestException, ResourceNotFoundException, LimitExceededException, VersionConflictException,
            ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a Device Defender security profile with a thing group or this account. Each thing group or account can
     * have up to five security profiles associated with it.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >AttachSecurityProfile</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AttachSecurityProfileRequest.Builder} avoiding the
     * need to create one manually via {@link AttachSecurityProfileRequest#builder()}
     * </p>
     *
     * @param attachSecurityProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.AttachSecurityProfileRequest.Builder} to create a
     *        request.
     * @return Result of the AttachSecurityProfile operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws VersionConflictException
     *         An exception thrown when the version of an entity specified with the <code>expectedVersion</code>
     *         parameter does not match the latest version in the system.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.AttachSecurityProfile
     */
    default AttachSecurityProfileResponse attachSecurityProfile(
            Consumer<AttachSecurityProfileRequest.Builder> attachSecurityProfileRequest) throws InvalidRequestException,
            ResourceNotFoundException, LimitExceededException, VersionConflictException, ThrottlingException,
            InternalFailureException, AwsServiceException, SdkClientException, IotException {
        return attachSecurityProfile(AttachSecurityProfileRequest.builder().applyMutation(attachSecurityProfileRequest).build());
    }

    /**
     * <p>
     * Attaches the specified principal to the specified thing. A principal can be X.509 certificates, Amazon Cognito
     * identities or federated identities.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >AttachThingPrincipal</a> action.
     * </p>
     *
     * @param attachThingPrincipalRequest
     *        The input for the AttachThingPrincipal operation.
     * @return Result of the AttachThingPrincipal operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.AttachThingPrincipal
     */
    default AttachThingPrincipalResponse attachThingPrincipal(AttachThingPrincipalRequest attachThingPrincipalRequest)
            throws ResourceNotFoundException, InvalidRequestException, ThrottlingException, UnauthorizedException,
            ServiceUnavailableException, InternalFailureException, AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attaches the specified principal to the specified thing. A principal can be X.509 certificates, Amazon Cognito
     * identities or federated identities.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >AttachThingPrincipal</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AttachThingPrincipalRequest.Builder} avoiding the
     * need to create one manually via {@link AttachThingPrincipalRequest#builder()}
     * </p>
     *
     * @param attachThingPrincipalRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.AttachThingPrincipalRequest.Builder} to create a request.
     *        The input for the AttachThingPrincipal operation.
     * @return Result of the AttachThingPrincipal operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.AttachThingPrincipal
     */
    default AttachThingPrincipalResponse attachThingPrincipal(
            Consumer<AttachThingPrincipalRequest.Builder> attachThingPrincipalRequest) throws ResourceNotFoundException,
            InvalidRequestException, ThrottlingException, UnauthorizedException, ServiceUnavailableException,
            InternalFailureException, AwsServiceException, SdkClientException, IotException {
        return attachThingPrincipal(AttachThingPrincipalRequest.builder().applyMutation(attachThingPrincipalRequest).build());
    }

    /**
     * <p>
     * Cancels a mitigation action task that is in progress. If the task is not in progress, an InvalidRequestException
     * occurs.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CancelAuditMitigationActionsTask</a> action.
     * </p>
     *
     * @param cancelAuditMitigationActionsTaskRequest
     * @return Result of the CancelAuditMitigationActionsTask operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CancelAuditMitigationActionsTask
     */
    default CancelAuditMitigationActionsTaskResponse cancelAuditMitigationActionsTask(
            CancelAuditMitigationActionsTaskRequest cancelAuditMitigationActionsTaskRequest) throws ResourceNotFoundException,
            InvalidRequestException, ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException,
            IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels a mitigation action task that is in progress. If the task is not in progress, an InvalidRequestException
     * occurs.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CancelAuditMitigationActionsTask</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelAuditMitigationActionsTaskRequest.Builder}
     * avoiding the need to create one manually via {@link CancelAuditMitigationActionsTaskRequest#builder()}
     * </p>
     *
     * @param cancelAuditMitigationActionsTaskRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.CancelAuditMitigationActionsTaskRequest.Builder} to
     *        create a request.
     * @return Result of the CancelAuditMitigationActionsTask operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CancelAuditMitigationActionsTask
     */
    default CancelAuditMitigationActionsTaskResponse cancelAuditMitigationActionsTask(
            Consumer<CancelAuditMitigationActionsTaskRequest.Builder> cancelAuditMitigationActionsTaskRequest)
            throws ResourceNotFoundException, InvalidRequestException, ThrottlingException, InternalFailureException,
            AwsServiceException, SdkClientException, IotException {
        return cancelAuditMitigationActionsTask(CancelAuditMitigationActionsTaskRequest.builder()
                .applyMutation(cancelAuditMitigationActionsTaskRequest).build());
    }

    /**
     * <p>
     * Cancels an audit that is in progress. The audit can be either scheduled or on demand. If the audit isn't in
     * progress, an "InvalidRequestException" occurs.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CancelAuditTask</a> action.
     * </p>
     *
     * @param cancelAuditTaskRequest
     * @return Result of the CancelAuditTask operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CancelAuditTask
     */
    default CancelAuditTaskResponse cancelAuditTask(CancelAuditTaskRequest cancelAuditTaskRequest)
            throws ResourceNotFoundException, InvalidRequestException, ThrottlingException, InternalFailureException,
            AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels an audit that is in progress. The audit can be either scheduled or on demand. If the audit isn't in
     * progress, an "InvalidRequestException" occurs.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CancelAuditTask</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelAuditTaskRequest.Builder} avoiding the need
     * to create one manually via {@link CancelAuditTaskRequest#builder()}
     * </p>
     *
     * @param cancelAuditTaskRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.CancelAuditTaskRequest.Builder} to create a request.
     * @return Result of the CancelAuditTask operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CancelAuditTask
     */
    default CancelAuditTaskResponse cancelAuditTask(Consumer<CancelAuditTaskRequest.Builder> cancelAuditTaskRequest)
            throws ResourceNotFoundException, InvalidRequestException, ThrottlingException, InternalFailureException,
            AwsServiceException, SdkClientException, IotException {
        return cancelAuditTask(CancelAuditTaskRequest.builder().applyMutation(cancelAuditTaskRequest).build());
    }

    /**
     * <p>
     * Cancels a pending transfer for the specified certificate.
     * </p>
     * <p>
     * <b>Note</b> Only the transfer source account can use this operation to cancel a transfer. (Transfer destinations
     * can use <a>RejectCertificateTransfer</a> instead.) After transfer, IoT returns the certificate to the source
     * account in the INACTIVE state. After the destination account has accepted the transfer, the transfer cannot be
     * cancelled.
     * </p>
     * <p>
     * After a certificate transfer is cancelled, the status of the certificate changes from PENDING_TRANSFER to
     * INACTIVE.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CancelCertificateTransfer</a> action.
     * </p>
     *
     * @param cancelCertificateTransferRequest
     *        The input for the CancelCertificateTransfer operation.
     * @return Result of the CancelCertificateTransfer operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws TransferAlreadyCompletedException
     *         You can't revert the certificate transfer because the transfer is already complete.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CancelCertificateTransfer
     */
    default CancelCertificateTransferResponse cancelCertificateTransfer(
            CancelCertificateTransferRequest cancelCertificateTransferRequest) throws ResourceNotFoundException,
            TransferAlreadyCompletedException, InvalidRequestException, ThrottlingException, UnauthorizedException,
            ServiceUnavailableException, InternalFailureException, AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels a pending transfer for the specified certificate.
     * </p>
     * <p>
     * <b>Note</b> Only the transfer source account can use this operation to cancel a transfer. (Transfer destinations
     * can use <a>RejectCertificateTransfer</a> instead.) After transfer, IoT returns the certificate to the source
     * account in the INACTIVE state. After the destination account has accepted the transfer, the transfer cannot be
     * cancelled.
     * </p>
     * <p>
     * After a certificate transfer is cancelled, the status of the certificate changes from PENDING_TRANSFER to
     * INACTIVE.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CancelCertificateTransfer</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelCertificateTransferRequest.Builder} avoiding
     * the need to create one manually via {@link CancelCertificateTransferRequest#builder()}
     * </p>
     *
     * @param cancelCertificateTransferRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.CancelCertificateTransferRequest.Builder} to create a
     *        request. The input for the CancelCertificateTransfer operation.
     * @return Result of the CancelCertificateTransfer operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws TransferAlreadyCompletedException
     *         You can't revert the certificate transfer because the transfer is already complete.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CancelCertificateTransfer
     */
    default CancelCertificateTransferResponse cancelCertificateTransfer(
            Consumer<CancelCertificateTransferRequest.Builder> cancelCertificateTransferRequest)
            throws ResourceNotFoundException, TransferAlreadyCompletedException, InvalidRequestException, ThrottlingException,
            UnauthorizedException, ServiceUnavailableException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        return cancelCertificateTransfer(CancelCertificateTransferRequest.builder()
                .applyMutation(cancelCertificateTransferRequest).build());
    }

    /**
     * <p>
     * Cancels a Device Defender ML Detect mitigation action.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CancelDetectMitigationActionsTask</a> action.
     * </p>
     *
     * @param cancelDetectMitigationActionsTaskRequest
     * @return Result of the CancelDetectMitigationActionsTask operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CancelDetectMitigationActionsTask
     */
    default CancelDetectMitigationActionsTaskResponse cancelDetectMitigationActionsTask(
            CancelDetectMitigationActionsTaskRequest cancelDetectMitigationActionsTaskRequest) throws ResourceNotFoundException,
            InvalidRequestException, ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException,
            IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels a Device Defender ML Detect mitigation action.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CancelDetectMitigationActionsTask</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelDetectMitigationActionsTaskRequest.Builder}
     * avoiding the need to create one manually via {@link CancelDetectMitigationActionsTaskRequest#builder()}
     * </p>
     *
     * @param cancelDetectMitigationActionsTaskRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.CancelDetectMitigationActionsTaskRequest.Builder} to
     *        create a request.
     * @return Result of the CancelDetectMitigationActionsTask operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CancelDetectMitigationActionsTask
     */
    default CancelDetectMitigationActionsTaskResponse cancelDetectMitigationActionsTask(
            Consumer<CancelDetectMitigationActionsTaskRequest.Builder> cancelDetectMitigationActionsTaskRequest)
            throws ResourceNotFoundException, InvalidRequestException, ThrottlingException, InternalFailureException,
            AwsServiceException, SdkClientException, IotException {
        return cancelDetectMitigationActionsTask(CancelDetectMitigationActionsTaskRequest.builder()
                .applyMutation(cancelDetectMitigationActionsTaskRequest).build());
    }

    /**
     * <p>
     * Cancels a job.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CancelJob</a> action.
     * </p>
     *
     * @param cancelJobRequest
     * @return Result of the CancelJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CancelJob
     */
    default CancelJobResponse cancelJob(CancelJobRequest cancelJobRequest) throws InvalidRequestException,
            ResourceNotFoundException, ThrottlingException, ServiceUnavailableException, LimitExceededException,
            AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels a job.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CancelJob</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelJobRequest.Builder} avoiding the need to
     * create one manually via {@link CancelJobRequest#builder()}
     * </p>
     *
     * @param cancelJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.CancelJobRequest.Builder} to create a request.
     * @return Result of the CancelJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CancelJob
     */
    default CancelJobResponse cancelJob(Consumer<CancelJobRequest.Builder> cancelJobRequest) throws InvalidRequestException,
            ResourceNotFoundException, ThrottlingException, ServiceUnavailableException, LimitExceededException,
            AwsServiceException, SdkClientException, IotException {
        return cancelJob(CancelJobRequest.builder().applyMutation(cancelJobRequest).build());
    }

    /**
     * <p>
     * Cancels the execution of a job for a given thing.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CancelJobExecution</a> action.
     * </p>
     *
     * @param cancelJobExecutionRequest
     * @return Result of the CancelJobExecution operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidStateTransitionException
     *         An attempt was made to change to an invalid state, for example by deleting a job or a job execution which
     *         is "IN_PROGRESS" without setting the <code>force</code> parameter.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws VersionConflictException
     *         An exception thrown when the version of an entity specified with the <code>expectedVersion</code>
     *         parameter does not match the latest version in the system.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CancelJobExecution
     */
    default CancelJobExecutionResponse cancelJobExecution(CancelJobExecutionRequest cancelJobExecutionRequest)
            throws InvalidRequestException, InvalidStateTransitionException, ResourceNotFoundException, ThrottlingException,
            ServiceUnavailableException, VersionConflictException, AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels the execution of a job for a given thing.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CancelJobExecution</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelJobExecutionRequest.Builder} avoiding the
     * need to create one manually via {@link CancelJobExecutionRequest#builder()}
     * </p>
     *
     * @param cancelJobExecutionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.CancelJobExecutionRequest.Builder} to create a request.
     * @return Result of the CancelJobExecution operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidStateTransitionException
     *         An attempt was made to change to an invalid state, for example by deleting a job or a job execution which
     *         is "IN_PROGRESS" without setting the <code>force</code> parameter.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws VersionConflictException
     *         An exception thrown when the version of an entity specified with the <code>expectedVersion</code>
     *         parameter does not match the latest version in the system.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CancelJobExecution
     */
    default CancelJobExecutionResponse cancelJobExecution(Consumer<CancelJobExecutionRequest.Builder> cancelJobExecutionRequest)
            throws InvalidRequestException, InvalidStateTransitionException, ResourceNotFoundException, ThrottlingException,
            ServiceUnavailableException, VersionConflictException, AwsServiceException, SdkClientException, IotException {
        return cancelJobExecution(CancelJobExecutionRequest.builder().applyMutation(cancelJobExecutionRequest).build());
    }

    /**
     * <p>
     * Clears the default authorizer.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ClearDefaultAuthorizer</a> action.
     * </p>
     *
     * @param clearDefaultAuthorizerRequest
     * @return Result of the ClearDefaultAuthorizer operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ClearDefaultAuthorizer
     */
    default ClearDefaultAuthorizerResponse clearDefaultAuthorizer(ClearDefaultAuthorizerRequest clearDefaultAuthorizerRequest)
            throws ResourceNotFoundException, InvalidRequestException, ThrottlingException, UnauthorizedException,
            ServiceUnavailableException, InternalFailureException, AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Clears the default authorizer.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ClearDefaultAuthorizer</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ClearDefaultAuthorizerRequest.Builder} avoiding the
     * need to create one manually via {@link ClearDefaultAuthorizerRequest#builder()}
     * </p>
     *
     * @param clearDefaultAuthorizerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.ClearDefaultAuthorizerRequest.Builder} to create a
     *        request.
     * @return Result of the ClearDefaultAuthorizer operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ClearDefaultAuthorizer
     */
    default ClearDefaultAuthorizerResponse clearDefaultAuthorizer(
            Consumer<ClearDefaultAuthorizerRequest.Builder> clearDefaultAuthorizerRequest) throws ResourceNotFoundException,
            InvalidRequestException, ThrottlingException, UnauthorizedException, ServiceUnavailableException,
            InternalFailureException, AwsServiceException, SdkClientException, IotException {
        return clearDefaultAuthorizer(ClearDefaultAuthorizerRequest.builder().applyMutation(clearDefaultAuthorizerRequest)
                .build());
    }

    /**
     * <p>
     * Clears the default authorizer.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ClearDefaultAuthorizer</a> action.
     * </p>
     *
     * @return Result of the ClearDefaultAuthorizer operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ClearDefaultAuthorizer
     * @see #clearDefaultAuthorizer(ClearDefaultAuthorizerRequest)
     */
    default ClearDefaultAuthorizerResponse clearDefaultAuthorizer() throws ResourceNotFoundException, InvalidRequestException,
            ThrottlingException, UnauthorizedException, ServiceUnavailableException, InternalFailureException,
            AwsServiceException, SdkClientException, IotException {
        return clearDefaultAuthorizer(ClearDefaultAuthorizerRequest.builder().build());
    }

    /**
     * <p>
     * Confirms a topic rule destination. When you create a rule requiring a destination, IoT sends a confirmation
     * message to the endpoint or base address you specify. The message includes a token which you pass back when
     * calling <code>ConfirmTopicRuleDestination</code> to confirm that you own or have access to the endpoint.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ConfirmTopicRuleDestination</a> action.
     * </p>
     *
     * @param confirmTopicRuleDestinationRequest
     * @return Result of the ConfirmTopicRuleDestination operation returned by the service.
     * @throws InternalException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ConflictingResourceUpdateException
     *         A conflicting resource update exception. This exception is thrown when two pending updates cause a
     *         conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ConfirmTopicRuleDestination
     */
    default ConfirmTopicRuleDestinationResponse confirmTopicRuleDestination(
            ConfirmTopicRuleDestinationRequest confirmTopicRuleDestinationRequest) throws InternalException,
            InvalidRequestException, ServiceUnavailableException, UnauthorizedException, ConflictingResourceUpdateException,
            AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Confirms a topic rule destination. When you create a rule requiring a destination, IoT sends a confirmation
     * message to the endpoint or base address you specify. The message includes a token which you pass back when
     * calling <code>ConfirmTopicRuleDestination</code> to confirm that you own or have access to the endpoint.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ConfirmTopicRuleDestination</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ConfirmTopicRuleDestinationRequest.Builder}
     * avoiding the need to create one manually via {@link ConfirmTopicRuleDestinationRequest#builder()}
     * </p>
     *
     * @param confirmTopicRuleDestinationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.ConfirmTopicRuleDestinationRequest.Builder} to create a
     *        request.
     * @return Result of the ConfirmTopicRuleDestination operation returned by the service.
     * @throws InternalException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ConflictingResourceUpdateException
     *         A conflicting resource update exception. This exception is thrown when two pending updates cause a
     *         conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ConfirmTopicRuleDestination
     */
    default ConfirmTopicRuleDestinationResponse confirmTopicRuleDestination(
            Consumer<ConfirmTopicRuleDestinationRequest.Builder> confirmTopicRuleDestinationRequest) throws InternalException,
            InvalidRequestException, ServiceUnavailableException, UnauthorizedException, ConflictingResourceUpdateException,
            AwsServiceException, SdkClientException, IotException {
        return confirmTopicRuleDestination(ConfirmTopicRuleDestinationRequest.builder()
                .applyMutation(confirmTopicRuleDestinationRequest).build());
    }

    /**
     * <p>
     * Creates a Device Defender audit suppression.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateAuditSuppression</a> action.
     * </p>
     *
     * @param createAuditSuppressionRequest
     * @return Result of the CreateAuditSuppression operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateAuditSuppression
     */
    default CreateAuditSuppressionResponse createAuditSuppression(CreateAuditSuppressionRequest createAuditSuppressionRequest)
            throws InvalidRequestException, ResourceAlreadyExistsException, ThrottlingException, InternalFailureException,
            LimitExceededException, AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a Device Defender audit suppression.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateAuditSuppression</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAuditSuppressionRequest.Builder} avoiding the
     * need to create one manually via {@link CreateAuditSuppressionRequest#builder()}
     * </p>
     *
     * @param createAuditSuppressionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.CreateAuditSuppressionRequest.Builder} to create a
     *        request.
     * @return Result of the CreateAuditSuppression operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateAuditSuppression
     */
    default CreateAuditSuppressionResponse createAuditSuppression(
            Consumer<CreateAuditSuppressionRequest.Builder> createAuditSuppressionRequest) throws InvalidRequestException,
            ResourceAlreadyExistsException, ThrottlingException, InternalFailureException, LimitExceededException,
            AwsServiceException, SdkClientException, IotException {
        return createAuditSuppression(CreateAuditSuppressionRequest.builder().applyMutation(createAuditSuppressionRequest)
                .build());
    }

    /**
     * <p>
     * Creates an authorizer.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateAuthorizer</a> action.
     * </p>
     *
     * @param createAuthorizerRequest
     * @return Result of the CreateAuthorizer operation returned by the service.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateAuthorizer
     */
    default CreateAuthorizerResponse createAuthorizer(CreateAuthorizerRequest createAuthorizerRequest)
            throws ResourceAlreadyExistsException, InvalidRequestException, LimitExceededException, ThrottlingException,
            UnauthorizedException, ServiceUnavailableException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an authorizer.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateAuthorizer</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAuthorizerRequest.Builder} avoiding the need
     * to create one manually via {@link CreateAuthorizerRequest#builder()}
     * </p>
     *
     * @param createAuthorizerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.CreateAuthorizerRequest.Builder} to create a request.
     * @return Result of the CreateAuthorizer operation returned by the service.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateAuthorizer
     */
    default CreateAuthorizerResponse createAuthorizer(Consumer<CreateAuthorizerRequest.Builder> createAuthorizerRequest)
            throws ResourceAlreadyExistsException, InvalidRequestException, LimitExceededException, ThrottlingException,
            UnauthorizedException, ServiceUnavailableException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        return createAuthorizer(CreateAuthorizerRequest.builder().applyMutation(createAuthorizerRequest).build());
    }

    /**
     * <p>
     * Creates a billing group.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateBillingGroup</a> action.
     * </p>
     *
     * @param createBillingGroupRequest
     * @return Result of the CreateBillingGroup operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateBillingGroup
     */
    default CreateBillingGroupResponse createBillingGroup(CreateBillingGroupRequest createBillingGroupRequest)
            throws InvalidRequestException, ResourceAlreadyExistsException, ThrottlingException, InternalFailureException,
            AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a billing group.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateBillingGroup</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateBillingGroupRequest.Builder} avoiding the
     * need to create one manually via {@link CreateBillingGroupRequest#builder()}
     * </p>
     *
     * @param createBillingGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.CreateBillingGroupRequest.Builder} to create a request.
     * @return Result of the CreateBillingGroup operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateBillingGroup
     */
    default CreateBillingGroupResponse createBillingGroup(Consumer<CreateBillingGroupRequest.Builder> createBillingGroupRequest)
            throws InvalidRequestException, ResourceAlreadyExistsException, ThrottlingException, InternalFailureException,
            AwsServiceException, SdkClientException, IotException {
        return createBillingGroup(CreateBillingGroupRequest.builder().applyMutation(createBillingGroupRequest).build());
    }

    /**
     * <p>
     * Creates an X.509 certificate using the specified certificate signing request.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateCertificateFromCsr</a> action.
     * </p>
     * <note>
     * <p>
     * The CSR must include a public key that is either an RSA key with a length of at least 2048 bits or an ECC key
     * from NIST P-256, NIST P-384, or NIST P-521 curves. For supported certificates, consult <a
     * href="https://docs.aws.amazon.com/iot/latest/developerguide/x509-client-certs.html#x509-cert-algorithms">
     * Certificate signing algorithms supported by IoT</a>.
     * </p>
     * </note> <note>
     * <p>
     * Reusing the same certificate signing request (CSR) results in a distinct certificate.
     * </p>
     * </note>
     * <p>
     * You can create multiple certificates in a batch by creating a directory, copying multiple <code>.csr</code> files
     * into that directory, and then specifying that directory on the command line. The following commands show how to
     * create a batch of certificates given a batch of CSRs. In the following commands, we assume that a set of CSRs are
     * located inside of the directory my-csr-directory:
     * </p>
     * <p>
     * On Linux and OS X, the command is:
     * </p>
     * <p>
     * <code>&#36 ls my-csr-directory/ | xargs -I {} aws iot create-certificate-from-csr --certificate-signing-request file://my-csr-directory/{}</code>
     * </p>
     * <p>
     * This command lists all of the CSRs in my-csr-directory and pipes each CSR file name to the
     * <code>aws iot create-certificate-from-csr</code> Amazon Web Services CLI command to create a certificate for the
     * corresponding CSR.
     * </p>
     * <p>
     * You can also run the <code>aws iot create-certificate-from-csr</code> part of the command in parallel to speed up
     * the certificate creation process:
     * </p>
     * <p>
     * <code>&#36 ls my-csr-directory/ | xargs -P 10 -I {} aws iot create-certificate-from-csr --certificate-signing-request file://my-csr-directory/{} </code>
     * </p>
     * <p>
     * On Windows PowerShell, the command to create certificates for all CSRs in my-csr-directory is:
     * </p>
     * <p>
     * <code>&gt; ls -Name my-csr-directory | %{aws iot create-certificate-from-csr --certificate-signing-request file://my-csr-directory/&#36_} </code>
     * </p>
     * <p>
     * On a Windows command prompt, the command to create certificates for all CSRs in my-csr-directory is:
     * </p>
     * <p>
     * <code>&gt; forfiles /p my-csr-directory /c "cmd /c aws iot create-certificate-from-csr --certificate-signing-request file://@path" </code>
     * </p>
     *
     * @param createCertificateFromCsrRequest
     *        The input for the CreateCertificateFromCsr operation.
     * @return Result of the CreateCertificateFromCsr operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateCertificateFromCsr
     */
    default CreateCertificateFromCsrResponse createCertificateFromCsr(
            CreateCertificateFromCsrRequest createCertificateFromCsrRequest) throws InvalidRequestException, ThrottlingException,
            UnauthorizedException, ServiceUnavailableException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an X.509 certificate using the specified certificate signing request.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateCertificateFromCsr</a> action.
     * </p>
     * <note>
     * <p>
     * The CSR must include a public key that is either an RSA key with a length of at least 2048 bits or an ECC key
     * from NIST P-256, NIST P-384, or NIST P-521 curves. For supported certificates, consult <a
     * href="https://docs.aws.amazon.com/iot/latest/developerguide/x509-client-certs.html#x509-cert-algorithms">
     * Certificate signing algorithms supported by IoT</a>.
     * </p>
     * </note> <note>
     * <p>
     * Reusing the same certificate signing request (CSR) results in a distinct certificate.
     * </p>
     * </note>
     * <p>
     * You can create multiple certificates in a batch by creating a directory, copying multiple <code>.csr</code> files
     * into that directory, and then specifying that directory on the command line. The following commands show how to
     * create a batch of certificates given a batch of CSRs. In the following commands, we assume that a set of CSRs are
     * located inside of the directory my-csr-directory:
     * </p>
     * <p>
     * On Linux and OS X, the command is:
     * </p>
     * <p>
     * <code>&#36 ls my-csr-directory/ | xargs -I {} aws iot create-certificate-from-csr --certificate-signing-request file://my-csr-directory/{}</code>
     * </p>
     * <p>
     * This command lists all of the CSRs in my-csr-directory and pipes each CSR file name to the
     * <code>aws iot create-certificate-from-csr</code> Amazon Web Services CLI command to create a certificate for the
     * corresponding CSR.
     * </p>
     * <p>
     * You can also run the <code>aws iot create-certificate-from-csr</code> part of the command in parallel to speed up
     * the certificate creation process:
     * </p>
     * <p>
     * <code>&#36 ls my-csr-directory/ | xargs -P 10 -I {} aws iot create-certificate-from-csr --certificate-signing-request file://my-csr-directory/{} </code>
     * </p>
     * <p>
     * On Windows PowerShell, the command to create certificates for all CSRs in my-csr-directory is:
     * </p>
     * <p>
     * <code>&gt; ls -Name my-csr-directory | %{aws iot create-certificate-from-csr --certificate-signing-request file://my-csr-directory/&#36_} </code>
     * </p>
     * <p>
     * On a Windows command prompt, the command to create certificates for all CSRs in my-csr-directory is:
     * </p>
     * <p>
     * <code>&gt; forfiles /p my-csr-directory /c "cmd /c aws iot create-certificate-from-csr --certificate-signing-request file://@path" </code>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCertificateFromCsrRequest.Builder} avoiding
     * the need to create one manually via {@link CreateCertificateFromCsrRequest#builder()}
     * </p>
     *
     * @param createCertificateFromCsrRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.CreateCertificateFromCsrRequest.Builder} to create a
     *        request. The input for the CreateCertificateFromCsr operation.
     * @return Result of the CreateCertificateFromCsr operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateCertificateFromCsr
     */
    default CreateCertificateFromCsrResponse createCertificateFromCsr(
            Consumer<CreateCertificateFromCsrRequest.Builder> createCertificateFromCsrRequest) throws InvalidRequestException,
            ThrottlingException, UnauthorizedException, ServiceUnavailableException, InternalFailureException,
            AwsServiceException, SdkClientException, IotException {
        return createCertificateFromCsr(CreateCertificateFromCsrRequest.builder().applyMutation(createCertificateFromCsrRequest)
                .build());
    }

    /**
     * <p>
     * Creates an Amazon Web Services IoT Core certificate provider. You can use Amazon Web Services IoT Core
     * certificate provider to customize how to sign a certificate signing request (CSR) in IoT fleet provisioning. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/iot/latest/developerguide/provisioning-cert-provider.html">Customizing
     * certificate signing using Amazon Web Services IoT Core certificate provider</a> from <i>Amazon Web Services IoT
     * Core Developer Guide</i>.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateCertificateProvider</a> action.
     * </p>
     * <important>
     * <p>
     * After you create a certificate provider, the behavior of <a
     * href="https://docs.aws.amazon.com/iot/latest/developerguide/fleet-provision-api.html#create-cert-csr">
     * <code>CreateCertificateFromCsr</code> API for fleet provisioning</a> will change and all API calls to
     * <code>CreateCertificateFromCsr</code> will invoke the certificate provider to create the certificates. It can
     * take up to a few minutes for this behavior to change after a certificate provider is created.
     * </p>
     * </important>
     *
     * @param createCertificateProviderRequest
     * @return Result of the CreateCertificateProvider operation returned by the service.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateCertificateProvider
     */
    default CreateCertificateProviderResponse createCertificateProvider(
            CreateCertificateProviderRequest createCertificateProviderRequest) throws LimitExceededException,
            ResourceAlreadyExistsException, InvalidRequestException, ThrottlingException, UnauthorizedException,
            ServiceUnavailableException, InternalFailureException, AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an Amazon Web Services IoT Core certificate provider. You can use Amazon Web Services IoT Core
     * certificate provider to customize how to sign a certificate signing request (CSR) in IoT fleet provisioning. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/iot/latest/developerguide/provisioning-cert-provider.html">Customizing
     * certificate signing using Amazon Web Services IoT Core certificate provider</a> from <i>Amazon Web Services IoT
     * Core Developer Guide</i>.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateCertificateProvider</a> action.
     * </p>
     * <important>
     * <p>
     * After you create a certificate provider, the behavior of <a
     * href="https://docs.aws.amazon.com/iot/latest/developerguide/fleet-provision-api.html#create-cert-csr">
     * <code>CreateCertificateFromCsr</code> API for fleet provisioning</a> will change and all API calls to
     * <code>CreateCertificateFromCsr</code> will invoke the certificate provider to create the certificates. It can
     * take up to a few minutes for this behavior to change after a certificate provider is created.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCertificateProviderRequest.Builder} avoiding
     * the need to create one manually via {@link CreateCertificateProviderRequest#builder()}
     * </p>
     *
     * @param createCertificateProviderRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.CreateCertificateProviderRequest.Builder} to create a
     *        request.
     * @return Result of the CreateCertificateProvider operation returned by the service.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateCertificateProvider
     */
    default CreateCertificateProviderResponse createCertificateProvider(
            Consumer<CreateCertificateProviderRequest.Builder> createCertificateProviderRequest) throws LimitExceededException,
            ResourceAlreadyExistsException, InvalidRequestException, ThrottlingException, UnauthorizedException,
            ServiceUnavailableException, InternalFailureException, AwsServiceException, SdkClientException, IotException {
        return createCertificateProvider(CreateCertificateProviderRequest.builder()
                .applyMutation(createCertificateProviderRequest).build());
    }

    /**
     * <p>
     * Use this API to define a Custom Metric published by your devices to Device Defender.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateCustomMetric</a> action.
     * </p>
     *
     * @param createCustomMetricRequest
     * @return Result of the CreateCustomMetric operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateCustomMetric
     */
    default CreateCustomMetricResponse createCustomMetric(CreateCustomMetricRequest createCustomMetricRequest)
            throws InvalidRequestException, LimitExceededException, ResourceAlreadyExistsException, ThrottlingException,
            InternalFailureException, AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Use this API to define a Custom Metric published by your devices to Device Defender.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateCustomMetric</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCustomMetricRequest.Builder} avoiding the
     * need to create one manually via {@link CreateCustomMetricRequest#builder()}
     * </p>
     *
     * @param createCustomMetricRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.CreateCustomMetricRequest.Builder} to create a request.
     * @return Result of the CreateCustomMetric operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateCustomMetric
     */
    default CreateCustomMetricResponse createCustomMetric(Consumer<CreateCustomMetricRequest.Builder> createCustomMetricRequest)
            throws InvalidRequestException, LimitExceededException, ResourceAlreadyExistsException, ThrottlingException,
            InternalFailureException, AwsServiceException, SdkClientException, IotException {
        return createCustomMetric(CreateCustomMetricRequest.builder().applyMutation(createCustomMetricRequest).build());
    }

    /**
     * <p>
     * Create a dimension that you can use to limit the scope of a metric used in a security profile for IoT Device
     * Defender. For example, using a <code>TOPIC_FILTER</code> dimension, you can narrow down the scope of the metric
     * only to MQTT topics whose name match the pattern specified in the dimension.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateDimension</a> action.
     * </p>
     *
     * @param createDimensionRequest
     * @return Result of the CreateDimension operation returned by the service.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateDimension
     */
    default CreateDimensionResponse createDimension(CreateDimensionRequest createDimensionRequest)
            throws InternalFailureException, InvalidRequestException, LimitExceededException, ResourceAlreadyExistsException,
            ThrottlingException, AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a dimension that you can use to limit the scope of a metric used in a security profile for IoT Device
     * Defender. For example, using a <code>TOPIC_FILTER</code> dimension, you can narrow down the scope of the metric
     * only to MQTT topics whose name match the pattern specified in the dimension.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateDimension</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDimensionRequest.Builder} avoiding the need
     * to create one manually via {@link CreateDimensionRequest#builder()}
     * </p>
     *
     * @param createDimensionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.CreateDimensionRequest.Builder} to create a request.
     * @return Result of the CreateDimension operation returned by the service.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateDimension
     */
    default CreateDimensionResponse createDimension(Consumer<CreateDimensionRequest.Builder> createDimensionRequest)
            throws InternalFailureException, InvalidRequestException, LimitExceededException, ResourceAlreadyExistsException,
            ThrottlingException, AwsServiceException, SdkClientException, IotException {
        return createDimension(CreateDimensionRequest.builder().applyMutation(createDimensionRequest).build());
    }

    /**
     * <p>
     * Creates a domain configuration.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateDomainConfiguration</a> action.
     * </p>
     *
     * @param createDomainConfigurationRequest
     * @return Result of the CreateDomainConfiguration operation returned by the service.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws CertificateValidationException
     *         The certificate is invalid.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateDomainConfiguration
     */
    default CreateDomainConfigurationResponse createDomainConfiguration(
            CreateDomainConfigurationRequest createDomainConfigurationRequest) throws LimitExceededException,
            CertificateValidationException, ResourceAlreadyExistsException, ServiceUnavailableException,
            InternalFailureException, InvalidRequestException, UnauthorizedException, ThrottlingException, AwsServiceException,
            SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a domain configuration.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateDomainConfiguration</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDomainConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link CreateDomainConfigurationRequest#builder()}
     * </p>
     *
     * @param createDomainConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.CreateDomainConfigurationRequest.Builder} to create a
     *        request.
     * @return Result of the CreateDomainConfiguration operation returned by the service.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws CertificateValidationException
     *         The certificate is invalid.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateDomainConfiguration
     */
    default CreateDomainConfigurationResponse createDomainConfiguration(
            Consumer<CreateDomainConfigurationRequest.Builder> createDomainConfigurationRequest) throws LimitExceededException,
            CertificateValidationException, ResourceAlreadyExistsException, ServiceUnavailableException,
            InternalFailureException, InvalidRequestException, UnauthorizedException, ThrottlingException, AwsServiceException,
            SdkClientException, IotException {
        return createDomainConfiguration(CreateDomainConfigurationRequest.builder()
                .applyMutation(createDomainConfigurationRequest).build());
    }

    /**
     * <p>
     * Creates a dynamic thing group.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateDynamicThingGroup</a> action.
     * </p>
     *
     * @param createDynamicThingGroupRequest
     * @return Result of the CreateDynamicThingGroup operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws InvalidQueryException
     *         The query is invalid.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateDynamicThingGroup
     */
    default CreateDynamicThingGroupResponse createDynamicThingGroup(CreateDynamicThingGroupRequest createDynamicThingGroupRequest)
            throws InvalidRequestException, ResourceAlreadyExistsException, ResourceNotFoundException, ThrottlingException,
            InternalFailureException, InvalidQueryException, LimitExceededException, AwsServiceException, SdkClientException,
            IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a dynamic thing group.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateDynamicThingGroup</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDynamicThingGroupRequest.Builder} avoiding
     * the need to create one manually via {@link CreateDynamicThingGroupRequest#builder()}
     * </p>
     *
     * @param createDynamicThingGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.CreateDynamicThingGroupRequest.Builder} to create a
     *        request.
     * @return Result of the CreateDynamicThingGroup operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws InvalidQueryException
     *         The query is invalid.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateDynamicThingGroup
     */
    default CreateDynamicThingGroupResponse createDynamicThingGroup(
            Consumer<CreateDynamicThingGroupRequest.Builder> createDynamicThingGroupRequest) throws InvalidRequestException,
            ResourceAlreadyExistsException, ResourceNotFoundException, ThrottlingException, InternalFailureException,
            InvalidQueryException, LimitExceededException, AwsServiceException, SdkClientException, IotException {
        return createDynamicThingGroup(CreateDynamicThingGroupRequest.builder().applyMutation(createDynamicThingGroupRequest)
                .build());
    }

    /**
     * <p>
     * Creates a fleet metric.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateFleetMetric</a> action.
     * </p>
     *
     * @param createFleetMetricRequest
     * @return Result of the CreateFleetMetric operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidQueryException
     *         The query is invalid.
     * @throws InvalidAggregationException
     *         The aggregation is invalid.
     * @throws IndexNotReadyException
     *         The index is not ready.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateFleetMetric
     */
    default CreateFleetMetricResponse createFleetMetric(CreateFleetMetricRequest createFleetMetricRequest)
            throws InvalidRequestException, ThrottlingException, UnauthorizedException, ServiceUnavailableException,
            InternalFailureException, LimitExceededException, ResourceAlreadyExistsException, ResourceNotFoundException,
            InvalidQueryException, InvalidAggregationException, IndexNotReadyException, AwsServiceException, SdkClientException,
            IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a fleet metric.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateFleetMetric</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFleetMetricRequest.Builder} avoiding the need
     * to create one manually via {@link CreateFleetMetricRequest#builder()}
     * </p>
     *
     * @param createFleetMetricRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.CreateFleetMetricRequest.Builder} to create a request.
     * @return Result of the CreateFleetMetric operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidQueryException
     *         The query is invalid.
     * @throws InvalidAggregationException
     *         The aggregation is invalid.
     * @throws IndexNotReadyException
     *         The index is not ready.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateFleetMetric
     */
    default CreateFleetMetricResponse createFleetMetric(Consumer<CreateFleetMetricRequest.Builder> createFleetMetricRequest)
            throws InvalidRequestException, ThrottlingException, UnauthorizedException, ServiceUnavailableException,
            InternalFailureException, LimitExceededException, ResourceAlreadyExistsException, ResourceNotFoundException,
            InvalidQueryException, InvalidAggregationException, IndexNotReadyException, AwsServiceException, SdkClientException,
            IotException {
        return createFleetMetric(CreateFleetMetricRequest.builder().applyMutation(createFleetMetricRequest).build());
    }

    /**
     * <p>
     * Creates a job.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateJob</a> action.
     * </p>
     *
     * @param createJobRequest
     * @return Result of the CreateJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateJob
     */
    default CreateJobResponse createJob(CreateJobRequest createJobRequest) throws InvalidRequestException,
            ResourceNotFoundException, ResourceAlreadyExistsException, LimitExceededException, ThrottlingException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a job.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateJob</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateJobRequest.Builder} avoiding the need to
     * create one manually via {@link CreateJobRequest#builder()}
     * </p>
     *
     * @param createJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.CreateJobRequest.Builder} to create a request.
     * @return Result of the CreateJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateJob
     */
    default CreateJobResponse createJob(Consumer<CreateJobRequest.Builder> createJobRequest) throws InvalidRequestException,
            ResourceNotFoundException, ResourceAlreadyExistsException, LimitExceededException, ThrottlingException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, IotException {
        return createJob(CreateJobRequest.builder().applyMutation(createJobRequest).build());
    }

    /**
     * <p>
     * Creates a job template.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateJobTemplate</a> action.
     * </p>
     *
     * @param createJobTemplateRequest
     * @return Result of the CreateJobTemplate operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ConflictException
     *         A resource with the same name already exists.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateJobTemplate
     */
    default CreateJobTemplateResponse createJobTemplate(CreateJobTemplateRequest createJobTemplateRequest)
            throws InvalidRequestException, ResourceNotFoundException, ConflictException, LimitExceededException,
            ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a job template.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateJobTemplate</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateJobTemplateRequest.Builder} avoiding the need
     * to create one manually via {@link CreateJobTemplateRequest#builder()}
     * </p>
     *
     * @param createJobTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.CreateJobTemplateRequest.Builder} to create a request.
     * @return Result of the CreateJobTemplate operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ConflictException
     *         A resource with the same name already exists.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateJobTemplate
     */
    default CreateJobTemplateResponse createJobTemplate(Consumer<CreateJobTemplateRequest.Builder> createJobTemplateRequest)
            throws InvalidRequestException, ResourceNotFoundException, ConflictException, LimitExceededException,
            ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException, IotException {
        return createJobTemplate(CreateJobTemplateRequest.builder().applyMutation(createJobTemplateRequest).build());
    }

    /**
     * <p>
     * Creates a 2048-bit RSA key pair and issues an X.509 certificate using the issued public key. You can also call
     * <code>CreateKeysAndCertificate</code> over MQTT from a device, for more information, see <a
     * href="https://docs.aws.amazon.com/iot/latest/developerguide/provision-wo-cert.html#provision-mqtt-api"
     * >Provisioning MQTT API</a>.
     * </p>
     * <p>
     * <b>Note</b> This is the only time IoT issues the private key for this certificate, so it is important to keep it
     * in a secure location.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateKeysAndCertificate</a> action.
     * </p>
     *
     * @param createKeysAndCertificateRequest
     *        The input for the CreateKeysAndCertificate operation.</p>
     *        <p>
     *        Requires permission to access the <a href=
     *        "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     *        >CreateKeysAndCertificateRequest</a> action.
     * @return Result of the CreateKeysAndCertificate operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateKeysAndCertificate
     */
    default CreateKeysAndCertificateResponse createKeysAndCertificate(
            CreateKeysAndCertificateRequest createKeysAndCertificateRequest) throws InvalidRequestException, ThrottlingException,
            UnauthorizedException, ServiceUnavailableException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a 2048-bit RSA key pair and issues an X.509 certificate using the issued public key. You can also call
     * <code>CreateKeysAndCertificate</code> over MQTT from a device, for more information, see <a
     * href="https://docs.aws.amazon.com/iot/latest/developerguide/provision-wo-cert.html#provision-mqtt-api"
     * >Provisioning MQTT API</a>.
     * </p>
     * <p>
     * <b>Note</b> This is the only time IoT issues the private key for this certificate, so it is important to keep it
     * in a secure location.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateKeysAndCertificate</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateKeysAndCertificateRequest.Builder} avoiding
     * the need to create one manually via {@link CreateKeysAndCertificateRequest#builder()}
     * </p>
     *
     * @param createKeysAndCertificateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.CreateKeysAndCertificateRequest.Builder} to create a
     *        request. The input for the CreateKeysAndCertificate operation.</p>
     *        <p>
     *        Requires permission to access the <a href=
     *        "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     *        >CreateKeysAndCertificateRequest</a> action.
     * @return Result of the CreateKeysAndCertificate operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateKeysAndCertificate
     */
    default CreateKeysAndCertificateResponse createKeysAndCertificate(
            Consumer<CreateKeysAndCertificateRequest.Builder> createKeysAndCertificateRequest) throws InvalidRequestException,
            ThrottlingException, UnauthorizedException, ServiceUnavailableException, InternalFailureException,
            AwsServiceException, SdkClientException, IotException {
        return createKeysAndCertificate(CreateKeysAndCertificateRequest.builder().applyMutation(createKeysAndCertificateRequest)
                .build());
    }

    /**
     * <p>
     * Creates a 2048-bit RSA key pair and issues an X.509 certificate using the issued public key. You can also call
     * <code>CreateKeysAndCertificate</code> over MQTT from a device, for more information, see <a
     * href="https://docs.aws.amazon.com/iot/latest/developerguide/provision-wo-cert.html#provision-mqtt-api"
     * >Provisioning MQTT API</a>.
     * </p>
     * <p>
     * <b>Note</b> This is the only time IoT issues the private key for this certificate, so it is important to keep it
     * in a secure location.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateKeysAndCertificate</a> action.
     * </p>
     *
     * @return Result of the CreateKeysAndCertificate operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateKeysAndCertificate
     * @see #createKeysAndCertificate(CreateKeysAndCertificateRequest)
     */
    default CreateKeysAndCertificateResponse createKeysAndCertificate() throws InvalidRequestException, ThrottlingException,
            UnauthorizedException, ServiceUnavailableException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        return createKeysAndCertificate(CreateKeysAndCertificateRequest.builder().build());
    }

    /**
     * <p>
     * Defines an action that can be applied to audit findings by using StartAuditMitigationActionsTask. Only certain
     * types of mitigation actions can be applied to specific check names. For more information, see <a
     * href="https://docs.aws.amazon.com/iot/latest/developerguide/device-defender-mitigation-actions.html">Mitigation
     * actions</a>. Each mitigation action can apply only one type of change.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateMitigationAction</a> action.
     * </p>
     *
     * @param createMitigationActionRequest
     * @return Result of the CreateMitigationAction operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateMitigationAction
     */
    default CreateMitigationActionResponse createMitigationAction(CreateMitigationActionRequest createMitigationActionRequest)
            throws InvalidRequestException, ResourceAlreadyExistsException, LimitExceededException, ThrottlingException,
            InternalFailureException, AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Defines an action that can be applied to audit findings by using StartAuditMitigationActionsTask. Only certain
     * types of mitigation actions can be applied to specific check names. For more information, see <a
     * href="https://docs.aws.amazon.com/iot/latest/developerguide/device-defender-mitigation-actions.html">Mitigation
     * actions</a>. Each mitigation action can apply only one type of change.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateMitigationAction</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateMitigationActionRequest.Builder} avoiding the
     * need to create one manually via {@link CreateMitigationActionRequest#builder()}
     * </p>
     *
     * @param createMitigationActionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.CreateMitigationActionRequest.Builder} to create a
     *        request.
     * @return Result of the CreateMitigationAction operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateMitigationAction
     */
    default CreateMitigationActionResponse createMitigationAction(
            Consumer<CreateMitigationActionRequest.Builder> createMitigationActionRequest) throws InvalidRequestException,
            ResourceAlreadyExistsException, LimitExceededException, ThrottlingException, InternalFailureException,
            AwsServiceException, SdkClientException, IotException {
        return createMitigationAction(CreateMitigationActionRequest.builder().applyMutation(createMitigationActionRequest)
                .build());
    }

    /**
     * <p>
     * Creates an IoT OTA update on a target group of things or groups.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateOTAUpdate</a> action.
     * </p>
     *
     * @param createOtaUpdateRequest
     * @return Result of the CreateOTAUpdate operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateOTAUpdate
     */
    default CreateOtaUpdateResponse createOTAUpdate(CreateOtaUpdateRequest createOtaUpdateRequest)
            throws InvalidRequestException, LimitExceededException, ResourceNotFoundException, ResourceAlreadyExistsException,
            ThrottlingException, UnauthorizedException, InternalFailureException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an IoT OTA update on a target group of things or groups.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateOTAUpdate</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateOtaUpdateRequest.Builder} avoiding the need
     * to create one manually via {@link CreateOtaUpdateRequest#builder()}
     * </p>
     *
     * @param createOtaUpdateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.CreateOtaUpdateRequest.Builder} to create a request.
     * @return Result of the CreateOTAUpdate operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateOTAUpdate
     */
    default CreateOtaUpdateResponse createOTAUpdate(Consumer<CreateOtaUpdateRequest.Builder> createOtaUpdateRequest)
            throws InvalidRequestException, LimitExceededException, ResourceNotFoundException, ResourceAlreadyExistsException,
            ThrottlingException, UnauthorizedException, InternalFailureException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, IotException {
        return createOTAUpdate(CreateOtaUpdateRequest.builder().applyMutation(createOtaUpdateRequest).build());
    }

    /**
     * <p>
     * Creates an IoT software package that can be deployed to your fleet.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreatePackage</a> and <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >GetIndexingConfiguration</a> actions.
     * </p>
     *
     * @param createPackageRequest
     * @return Result of the CreatePackage operation returned by the service.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ConflictException
     *         A resource with the same name already exists.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ValidationException
     *         The request is not valid.
     * @throws ServiceQuotaExceededException
     *         A limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreatePackage
     */
    default CreatePackageResponse createPackage(CreatePackageRequest createPackageRequest) throws ThrottlingException,
            ConflictException, InternalServerException, ValidationException, ServiceQuotaExceededException, AwsServiceException,
            SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an IoT software package that can be deployed to your fleet.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreatePackage</a> and <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >GetIndexingConfiguration</a> actions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePackageRequest.Builder} avoiding the need to
     * create one manually via {@link CreatePackageRequest#builder()}
     * </p>
     *
     * @param createPackageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.CreatePackageRequest.Builder} to create a request.
     * @return Result of the CreatePackage operation returned by the service.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ConflictException
     *         A resource with the same name already exists.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ValidationException
     *         The request is not valid.
     * @throws ServiceQuotaExceededException
     *         A limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreatePackage
     */
    default CreatePackageResponse createPackage(Consumer<CreatePackageRequest.Builder> createPackageRequest)
            throws ThrottlingException, ConflictException, InternalServerException, ValidationException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, IotException {
        return createPackage(CreatePackageRequest.builder().applyMutation(createPackageRequest).build());
    }

    /**
     * <p>
     * Creates a new version for an existing IoT software package.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreatePackageVersion</a> and <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >GetIndexingConfiguration</a> actions.
     * </p>
     *
     * @param createPackageVersionRequest
     * @return Result of the CreatePackageVersion operation returned by the service.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ConflictException
     *         A resource with the same name already exists.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ValidationException
     *         The request is not valid.
     * @throws ServiceQuotaExceededException
     *         A limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreatePackageVersion
     */
    default CreatePackageVersionResponse createPackageVersion(CreatePackageVersionRequest createPackageVersionRequest)
            throws ThrottlingException, ConflictException, InternalServerException, ValidationException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new version for an existing IoT software package.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreatePackageVersion</a> and <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >GetIndexingConfiguration</a> actions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePackageVersionRequest.Builder} avoiding the
     * need to create one manually via {@link CreatePackageVersionRequest#builder()}
     * </p>
     *
     * @param createPackageVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.CreatePackageVersionRequest.Builder} to create a request.
     * @return Result of the CreatePackageVersion operation returned by the service.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ConflictException
     *         A resource with the same name already exists.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ValidationException
     *         The request is not valid.
     * @throws ServiceQuotaExceededException
     *         A limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreatePackageVersion
     */
    default CreatePackageVersionResponse createPackageVersion(
            Consumer<CreatePackageVersionRequest.Builder> createPackageVersionRequest) throws ThrottlingException,
            ConflictException, InternalServerException, ValidationException, ServiceQuotaExceededException, AwsServiceException,
            SdkClientException, IotException {
        return createPackageVersion(CreatePackageVersionRequest.builder().applyMutation(createPackageVersionRequest).build());
    }

    /**
     * <p>
     * Creates an IoT policy.
     * </p>
     * <p>
     * The created policy is the default version for the policy. This operation creates a policy version with a version
     * identifier of <b>1</b> and sets <b>1</b> as the policy's default version.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreatePolicy</a> action.
     * </p>
     *
     * @param createPolicyRequest
     *        The input for the CreatePolicy operation.
     * @return Result of the CreatePolicy operation returned by the service.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws MalformedPolicyException
     *         The policy documentation is not valid.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreatePolicy
     */
    default CreatePolicyResponse createPolicy(CreatePolicyRequest createPolicyRequest) throws ResourceAlreadyExistsException,
            MalformedPolicyException, InvalidRequestException, ThrottlingException, UnauthorizedException,
            ServiceUnavailableException, InternalFailureException, AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an IoT policy.
     * </p>
     * <p>
     * The created policy is the default version for the policy. This operation creates a policy version with a version
     * identifier of <b>1</b> and sets <b>1</b> as the policy's default version.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreatePolicy</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePolicyRequest.Builder} avoiding the need to
     * create one manually via {@link CreatePolicyRequest#builder()}
     * </p>
     *
     * @param createPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.CreatePolicyRequest.Builder} to create a request. The
     *        input for the CreatePolicy operation.
     * @return Result of the CreatePolicy operation returned by the service.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws MalformedPolicyException
     *         The policy documentation is not valid.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreatePolicy
     */
    default CreatePolicyResponse createPolicy(Consumer<CreatePolicyRequest.Builder> createPolicyRequest)
            throws ResourceAlreadyExistsException, MalformedPolicyException, InvalidRequestException, ThrottlingException,
            UnauthorizedException, ServiceUnavailableException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        return createPolicy(CreatePolicyRequest.builder().applyMutation(createPolicyRequest).build());
    }

    /**
     * <p>
     * Creates a new version of the specified IoT policy. To update a policy, create a new policy version. A managed
     * policy can have up to five versions. If the policy has five versions, you must use <a>DeletePolicyVersion</a> to
     * delete an existing version before you create a new one.
     * </p>
     * <p>
     * Optionally, you can set the new version as the policy's default version. The default version is the operative
     * version (that is, the version that is in effect for the certificates to which the policy is attached).
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreatePolicyVersion</a> action.
     * </p>
     *
     * @param createPolicyVersionRequest
     *        The input for the CreatePolicyVersion operation.
     * @return Result of the CreatePolicyVersion operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws MalformedPolicyException
     *         The policy documentation is not valid.
     * @throws VersionsLimitExceededException
     *         The number of policy versions exceeds the limit.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreatePolicyVersion
     */
    default CreatePolicyVersionResponse createPolicyVersion(CreatePolicyVersionRequest createPolicyVersionRequest)
            throws ResourceNotFoundException, MalformedPolicyException, VersionsLimitExceededException, InvalidRequestException,
            ThrottlingException, UnauthorizedException, ServiceUnavailableException, InternalFailureException,
            AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new version of the specified IoT policy. To update a policy, create a new policy version. A managed
     * policy can have up to five versions. If the policy has five versions, you must use <a>DeletePolicyVersion</a> to
     * delete an existing version before you create a new one.
     * </p>
     * <p>
     * Optionally, you can set the new version as the policy's default version. The default version is the operative
     * version (that is, the version that is in effect for the certificates to which the policy is attached).
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreatePolicyVersion</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePolicyVersionRequest.Builder} avoiding the
     * need to create one manually via {@link CreatePolicyVersionRequest#builder()}
     * </p>
     *
     * @param createPolicyVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.CreatePolicyVersionRequest.Builder} to create a request.
     *        The input for the CreatePolicyVersion operation.
     * @return Result of the CreatePolicyVersion operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws MalformedPolicyException
     *         The policy documentation is not valid.
     * @throws VersionsLimitExceededException
     *         The number of policy versions exceeds the limit.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreatePolicyVersion
     */
    default CreatePolicyVersionResponse createPolicyVersion(
            Consumer<CreatePolicyVersionRequest.Builder> createPolicyVersionRequest) throws ResourceNotFoundException,
            MalformedPolicyException, VersionsLimitExceededException, InvalidRequestException, ThrottlingException,
            UnauthorizedException, ServiceUnavailableException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        return createPolicyVersion(CreatePolicyVersionRequest.builder().applyMutation(createPolicyVersionRequest).build());
    }

    /**
     * <p>
     * Creates a provisioning claim.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateProvisioningClaim</a> action.
     * </p>
     *
     * @param createProvisioningClaimRequest
     * @return Result of the CreateProvisioningClaim operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateProvisioningClaim
     */
    default CreateProvisioningClaimResponse createProvisioningClaim(CreateProvisioningClaimRequest createProvisioningClaimRequest)
            throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, UnauthorizedException,
            ServiceUnavailableException, InternalFailureException, AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a provisioning claim.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateProvisioningClaim</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateProvisioningClaimRequest.Builder} avoiding
     * the need to create one manually via {@link CreateProvisioningClaimRequest#builder()}
     * </p>
     *
     * @param createProvisioningClaimRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.CreateProvisioningClaimRequest.Builder} to create a
     *        request.
     * @return Result of the CreateProvisioningClaim operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateProvisioningClaim
     */
    default CreateProvisioningClaimResponse createProvisioningClaim(
            Consumer<CreateProvisioningClaimRequest.Builder> createProvisioningClaimRequest) throws InvalidRequestException,
            ResourceNotFoundException, ThrottlingException, UnauthorizedException, ServiceUnavailableException,
            InternalFailureException, AwsServiceException, SdkClientException, IotException {
        return createProvisioningClaim(CreateProvisioningClaimRequest.builder().applyMutation(createProvisioningClaimRequest)
                .build());
    }

    /**
     * <p>
     * Creates a provisioning template.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateProvisioningTemplate</a> action.
     * </p>
     *
     * @param createProvisioningTemplateRequest
     * @return Result of the CreateProvisioningTemplate operation returned by the service.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateProvisioningTemplate
     */
    default CreateProvisioningTemplateResponse createProvisioningTemplate(
            CreateProvisioningTemplateRequest createProvisioningTemplateRequest) throws InternalFailureException,
            InvalidRequestException, LimitExceededException, ThrottlingException, UnauthorizedException,
            ResourceAlreadyExistsException, AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a provisioning template.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateProvisioningTemplate</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateProvisioningTemplateRequest.Builder} avoiding
     * the need to create one manually via {@link CreateProvisioningTemplateRequest#builder()}
     * </p>
     *
     * @param createProvisioningTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.CreateProvisioningTemplateRequest.Builder} to create a
     *        request.
     * @return Result of the CreateProvisioningTemplate operation returned by the service.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateProvisioningTemplate
     */
    default CreateProvisioningTemplateResponse createProvisioningTemplate(
            Consumer<CreateProvisioningTemplateRequest.Builder> createProvisioningTemplateRequest)
            throws InternalFailureException, InvalidRequestException, LimitExceededException, ThrottlingException,
            UnauthorizedException, ResourceAlreadyExistsException, AwsServiceException, SdkClientException, IotException {
        return createProvisioningTemplate(CreateProvisioningTemplateRequest.builder()
                .applyMutation(createProvisioningTemplateRequest).build());
    }

    /**
     * <p>
     * Creates a new version of a provisioning template.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateProvisioningTemplateVersion</a> action.
     * </p>
     *
     * @param createProvisioningTemplateVersionRequest
     * @return Result of the CreateProvisioningTemplateVersion operation returned by the service.
     * @throws VersionsLimitExceededException
     *         The number of policy versions exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ConflictingResourceUpdateException
     *         A conflicting resource update exception. This exception is thrown when two pending updates cause a
     *         conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateProvisioningTemplateVersion
     */
    default CreateProvisioningTemplateVersionResponse createProvisioningTemplateVersion(
            CreateProvisioningTemplateVersionRequest createProvisioningTemplateVersionRequest)
            throws VersionsLimitExceededException, InternalFailureException, InvalidRequestException, ThrottlingException,
            ResourceNotFoundException, UnauthorizedException, ConflictingResourceUpdateException, AwsServiceException,
            SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new version of a provisioning template.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateProvisioningTemplateVersion</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateProvisioningTemplateVersionRequest.Builder}
     * avoiding the need to create one manually via {@link CreateProvisioningTemplateVersionRequest#builder()}
     * </p>
     *
     * @param createProvisioningTemplateVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.CreateProvisioningTemplateVersionRequest.Builder} to
     *        create a request.
     * @return Result of the CreateProvisioningTemplateVersion operation returned by the service.
     * @throws VersionsLimitExceededException
     *         The number of policy versions exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ConflictingResourceUpdateException
     *         A conflicting resource update exception. This exception is thrown when two pending updates cause a
     *         conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateProvisioningTemplateVersion
     */
    default CreateProvisioningTemplateVersionResponse createProvisioningTemplateVersion(
            Consumer<CreateProvisioningTemplateVersionRequest.Builder> createProvisioningTemplateVersionRequest)
            throws VersionsLimitExceededException, InternalFailureException, InvalidRequestException, ThrottlingException,
            ResourceNotFoundException, UnauthorizedException, ConflictingResourceUpdateException, AwsServiceException,
            SdkClientException, IotException {
        return createProvisioningTemplateVersion(CreateProvisioningTemplateVersionRequest.builder()
                .applyMutation(createProvisioningTemplateVersionRequest).build());
    }

    /**
     * <p>
     * Creates a role alias.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateRoleAlias</a> action.
     * </p>
     *
     * @param createRoleAliasRequest
     * @return Result of the CreateRoleAlias operation returned by the service.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateRoleAlias
     */
    default CreateRoleAliasResponse createRoleAlias(CreateRoleAliasRequest createRoleAliasRequest)
            throws ResourceAlreadyExistsException, InvalidRequestException, LimitExceededException, ThrottlingException,
            UnauthorizedException, ServiceUnavailableException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a role alias.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateRoleAlias</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRoleAliasRequest.Builder} avoiding the need
     * to create one manually via {@link CreateRoleAliasRequest#builder()}
     * </p>
     *
     * @param createRoleAliasRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.CreateRoleAliasRequest.Builder} to create a request.
     * @return Result of the CreateRoleAlias operation returned by the service.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateRoleAlias
     */
    default CreateRoleAliasResponse createRoleAlias(Consumer<CreateRoleAliasRequest.Builder> createRoleAliasRequest)
            throws ResourceAlreadyExistsException, InvalidRequestException, LimitExceededException, ThrottlingException,
            UnauthorizedException, ServiceUnavailableException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        return createRoleAlias(CreateRoleAliasRequest.builder().applyMutation(createRoleAliasRequest).build());
    }

    /**
     * <p>
     * Creates a scheduled audit that is run at a specified time interval.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateScheduledAudit</a> action.
     * </p>
     *
     * @param createScheduledAuditRequest
     * @return Result of the CreateScheduledAudit operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateScheduledAudit
     */
    default CreateScheduledAuditResponse createScheduledAudit(CreateScheduledAuditRequest createScheduledAuditRequest)
            throws InvalidRequestException, ResourceAlreadyExistsException, ThrottlingException, InternalFailureException,
            LimitExceededException, AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a scheduled audit that is run at a specified time interval.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateScheduledAudit</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateScheduledAuditRequest.Builder} avoiding the
     * need to create one manually via {@link CreateScheduledAuditRequest#builder()}
     * </p>
     *
     * @param createScheduledAuditRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.CreateScheduledAuditRequest.Builder} to create a request.
     * @return Result of the CreateScheduledAudit operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateScheduledAudit
     */
    default CreateScheduledAuditResponse createScheduledAudit(
            Consumer<CreateScheduledAuditRequest.Builder> createScheduledAuditRequest) throws InvalidRequestException,
            ResourceAlreadyExistsException, ThrottlingException, InternalFailureException, LimitExceededException,
            AwsServiceException, SdkClientException, IotException {
        return createScheduledAudit(CreateScheduledAuditRequest.builder().applyMutation(createScheduledAuditRequest).build());
    }

    /**
     * <p>
     * Creates a Device Defender security profile.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateSecurityProfile</a> action.
     * </p>
     *
     * @param createSecurityProfileRequest
     * @return Result of the CreateSecurityProfile operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateSecurityProfile
     */
    default CreateSecurityProfileResponse createSecurityProfile(CreateSecurityProfileRequest createSecurityProfileRequest)
            throws InvalidRequestException, ResourceAlreadyExistsException, ThrottlingException, InternalFailureException,
            AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a Device Defender security profile.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateSecurityProfile</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSecurityProfileRequest.Builder} avoiding the
     * need to create one manually via {@link CreateSecurityProfileRequest#builder()}
     * </p>
     *
     * @param createSecurityProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.CreateSecurityProfileRequest.Builder} to create a
     *        request.
     * @return Result of the CreateSecurityProfile operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateSecurityProfile
     */
    default CreateSecurityProfileResponse createSecurityProfile(
            Consumer<CreateSecurityProfileRequest.Builder> createSecurityProfileRequest) throws InvalidRequestException,
            ResourceAlreadyExistsException, ThrottlingException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        return createSecurityProfile(CreateSecurityProfileRequest.builder().applyMutation(createSecurityProfileRequest).build());
    }

    /**
     * <p>
     * Creates a stream for delivering one or more large files in chunks over MQTT. A stream transports data bytes in
     * chunks or blocks packaged as MQTT messages from a source like S3. You can have one or more files associated with
     * a stream.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateStream</a> action.
     * </p>
     *
     * @param createStreamRequest
     * @return Result of the CreateStream operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateStream
     */
    default CreateStreamResponse createStream(CreateStreamRequest createStreamRequest) throws InvalidRequestException,
            LimitExceededException, ResourceNotFoundException, ResourceAlreadyExistsException, ThrottlingException,
            UnauthorizedException, ServiceUnavailableException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a stream for delivering one or more large files in chunks over MQTT. A stream transports data bytes in
     * chunks or blocks packaged as MQTT messages from a source like S3. You can have one or more files associated with
     * a stream.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateStream</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateStreamRequest.Builder} avoiding the need to
     * create one manually via {@link CreateStreamRequest#builder()}
     * </p>
     *
     * @param createStreamRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.CreateStreamRequest.Builder} to create a request.
     * @return Result of the CreateStream operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateStream
     */
    default CreateStreamResponse createStream(Consumer<CreateStreamRequest.Builder> createStreamRequest)
            throws InvalidRequestException, LimitExceededException, ResourceNotFoundException, ResourceAlreadyExistsException,
            ThrottlingException, UnauthorizedException, ServiceUnavailableException, InternalFailureException,
            AwsServiceException, SdkClientException, IotException {
        return createStream(CreateStreamRequest.builder().applyMutation(createStreamRequest).build());
    }

    /**
     * <p>
     * Creates a thing record in the registry. If this call is made multiple times using the same thing name and
     * configuration, the call will succeed. If this call is made with the same thing name but different configuration a
     * <code>ResourceAlreadyExistsException</code> is thrown.
     * </p>
     * <note>
     * <p>
     * This is a control plane operation. See <a
     * href="https://docs.aws.amazon.com/iot/latest/developerguide/iot-authorization.html">Authorization</a> for
     * information about authorizing control plane actions.
     * </p>
     * </note>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateThing</a> action.
     * </p>
     *
     * @param createThingRequest
     *        The input for the CreateThing operation.
     * @return Result of the CreateThing operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateThing
     */
    default CreateThingResponse createThing(CreateThingRequest createThingRequest) throws InvalidRequestException,
            ThrottlingException, UnauthorizedException, ServiceUnavailableException, InternalFailureException,
            ResourceAlreadyExistsException, ResourceNotFoundException, AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a thing record in the registry. If this call is made multiple times using the same thing name and
     * configuration, the call will succeed. If this call is made with the same thing name but different configuration a
     * <code>ResourceAlreadyExistsException</code> is thrown.
     * </p>
     * <note>
     * <p>
     * This is a control plane operation. See <a
     * href="https://docs.aws.amazon.com/iot/latest/developerguide/iot-authorization.html">Authorization</a> for
     * information about authorizing control plane actions.
     * </p>
     * </note>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateThing</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateThingRequest.Builder} avoiding the need to
     * create one manually via {@link CreateThingRequest#builder()}
     * </p>
     *
     * @param createThingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.CreateThingRequest.Builder} to create a request. The
     *        input for the CreateThing operation.
     * @return Result of the CreateThing operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateThing
     */
    default CreateThingResponse createThing(Consumer<CreateThingRequest.Builder> createThingRequest)
            throws InvalidRequestException, ThrottlingException, UnauthorizedException, ServiceUnavailableException,
            InternalFailureException, ResourceAlreadyExistsException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, IotException {
        return createThing(CreateThingRequest.builder().applyMutation(createThingRequest).build());
    }

    /**
     * <p>
     * Create a thing group.
     * </p>
     * <note>
     * <p>
     * This is a control plane operation. See <a
     * href="https://docs.aws.amazon.com/iot/latest/developerguide/iot-authorization.html">Authorization</a> for
     * information about authorizing control plane actions.
     * </p>
     * <p>
     * If the <code>ThingGroup</code> that you create has the exact same attributes as an existing
     * <code>ThingGroup</code>, you will get a 200 success response.
     * </p>
     * </note>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateThingGroup</a> action.
     * </p>
     *
     * @param createThingGroupRequest
     * @return Result of the CreateThingGroup operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateThingGroup
     */
    default CreateThingGroupResponse createThingGroup(CreateThingGroupRequest createThingGroupRequest)
            throws InvalidRequestException, ResourceAlreadyExistsException, ThrottlingException, InternalFailureException,
            AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a thing group.
     * </p>
     * <note>
     * <p>
     * This is a control plane operation. See <a
     * href="https://docs.aws.amazon.com/iot/latest/developerguide/iot-authorization.html">Authorization</a> for
     * information about authorizing control plane actions.
     * </p>
     * <p>
     * If the <code>ThingGroup</code> that you create has the exact same attributes as an existing
     * <code>ThingGroup</code>, you will get a 200 success response.
     * </p>
     * </note>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateThingGroup</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateThingGroupRequest.Builder} avoiding the need
     * to create one manually via {@link CreateThingGroupRequest#builder()}
     * </p>
     *
     * @param createThingGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.CreateThingGroupRequest.Builder} to create a request.
     * @return Result of the CreateThingGroup operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateThingGroup
     */
    default CreateThingGroupResponse createThingGroup(Consumer<CreateThingGroupRequest.Builder> createThingGroupRequest)
            throws InvalidRequestException, ResourceAlreadyExistsException, ThrottlingException, InternalFailureException,
            AwsServiceException, SdkClientException, IotException {
        return createThingGroup(CreateThingGroupRequest.builder().applyMutation(createThingGroupRequest).build());
    }

    /**
     * <p>
     * Creates a new thing type.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateThingType</a> action.
     * </p>
     *
     * @param createThingTypeRequest
     *        The input for the CreateThingType operation.
     * @return Result of the CreateThingType operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateThingType
     */
    default CreateThingTypeResponse createThingType(CreateThingTypeRequest createThingTypeRequest)
            throws InvalidRequestException, ThrottlingException, UnauthorizedException, ServiceUnavailableException,
            InternalFailureException, ResourceAlreadyExistsException, AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new thing type.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateThingType</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateThingTypeRequest.Builder} avoiding the need
     * to create one manually via {@link CreateThingTypeRequest#builder()}
     * </p>
     *
     * @param createThingTypeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.CreateThingTypeRequest.Builder} to create a request. The
     *        input for the CreateThingType operation.
     * @return Result of the CreateThingType operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateThingType
     */
    default CreateThingTypeResponse createThingType(Consumer<CreateThingTypeRequest.Builder> createThingTypeRequest)
            throws InvalidRequestException, ThrottlingException, UnauthorizedException, ServiceUnavailableException,
            InternalFailureException, ResourceAlreadyExistsException, AwsServiceException, SdkClientException, IotException {
        return createThingType(CreateThingTypeRequest.builder().applyMutation(createThingTypeRequest).build());
    }

    /**
     * <p>
     * Creates a rule. Creating rules is an administrator-level action. Any user who has permission to create rules will
     * be able to access data processed by the rule.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateTopicRule</a> action.
     * </p>
     *
     * @param createTopicRuleRequest
     *        The input for the CreateTopicRule operation.
     * @return Result of the CreateTopicRule operation returned by the service.
     * @throws SqlParseException
     *         The Rule-SQL expression can't be parsed correctly.
     * @throws InternalException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ConflictingResourceUpdateException
     *         A conflicting resource update exception. This exception is thrown when two pending updates cause a
     *         conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateTopicRule
     */
    default CreateTopicRuleResponse createTopicRule(CreateTopicRuleRequest createTopicRuleRequest) throws SqlParseException,
            InternalException, InvalidRequestException, ResourceAlreadyExistsException, ServiceUnavailableException,
            ConflictingResourceUpdateException, AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a rule. Creating rules is an administrator-level action. Any user who has permission to create rules will
     * be able to access data processed by the rule.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateTopicRule</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTopicRuleRequest.Builder} avoiding the need
     * to create one manually via {@link CreateTopicRuleRequest#builder()}
     * </p>
     *
     * @param createTopicRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.CreateTopicRuleRequest.Builder} to create a request. The
     *        input for the CreateTopicRule operation.
     * @return Result of the CreateTopicRule operation returned by the service.
     * @throws SqlParseException
     *         The Rule-SQL expression can't be parsed correctly.
     * @throws InternalException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ConflictingResourceUpdateException
     *         A conflicting resource update exception. This exception is thrown when two pending updates cause a
     *         conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateTopicRule
     */
    default CreateTopicRuleResponse createTopicRule(Consumer<CreateTopicRuleRequest.Builder> createTopicRuleRequest)
            throws SqlParseException, InternalException, InvalidRequestException, ResourceAlreadyExistsException,
            ServiceUnavailableException, ConflictingResourceUpdateException, AwsServiceException, SdkClientException,
            IotException {
        return createTopicRule(CreateTopicRuleRequest.builder().applyMutation(createTopicRuleRequest).build());
    }

    /**
     * <p>
     * Creates a topic rule destination. The destination must be confirmed prior to use.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateTopicRuleDestination</a> action.
     * </p>
     *
     * @param createTopicRuleDestinationRequest
     * @return Result of the CreateTopicRuleDestination operation returned by the service.
     * @throws InternalException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ConflictingResourceUpdateException
     *         A conflicting resource update exception. This exception is thrown when two pending updates cause a
     *         conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateTopicRuleDestination
     */
    default CreateTopicRuleDestinationResponse createTopicRuleDestination(
            CreateTopicRuleDestinationRequest createTopicRuleDestinationRequest) throws InternalException,
            InvalidRequestException, ResourceAlreadyExistsException, ServiceUnavailableException,
            ConflictingResourceUpdateException, AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a topic rule destination. The destination must be confirmed prior to use.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >CreateTopicRuleDestination</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTopicRuleDestinationRequest.Builder} avoiding
     * the need to create one manually via {@link CreateTopicRuleDestinationRequest#builder()}
     * </p>
     *
     * @param createTopicRuleDestinationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.CreateTopicRuleDestinationRequest.Builder} to create a
     *        request.
     * @return Result of the CreateTopicRuleDestination operation returned by the service.
     * @throws InternalException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceAlreadyExistsException
     *         The resource already exists.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ConflictingResourceUpdateException
     *         A conflicting resource update exception. This exception is thrown when two pending updates cause a
     *         conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.CreateTopicRuleDestination
     */
    default CreateTopicRuleDestinationResponse createTopicRuleDestination(
            Consumer<CreateTopicRuleDestinationRequest.Builder> createTopicRuleDestinationRequest) throws InternalException,
            InvalidRequestException, ResourceAlreadyExistsException, ServiceUnavailableException,
            ConflictingResourceUpdateException, AwsServiceException, SdkClientException, IotException {
        return createTopicRuleDestination(CreateTopicRuleDestinationRequest.builder()
                .applyMutation(createTopicRuleDestinationRequest).build());
    }

    /**
     * <p>
     * Restores the default settings for Device Defender audits for this account. Any configuration data you entered is
     * deleted and all audit checks are reset to disabled.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteAccountAuditConfiguration</a> action.
     * </p>
     *
     * @param deleteAccountAuditConfigurationRequest
     * @return Result of the DeleteAccountAuditConfiguration operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteAccountAuditConfiguration
     */
    default DeleteAccountAuditConfigurationResponse deleteAccountAuditConfiguration(
            DeleteAccountAuditConfigurationRequest deleteAccountAuditConfigurationRequest) throws InvalidRequestException,
            ResourceNotFoundException, ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException,
            IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Restores the default settings for Device Defender audits for this account. Any configuration data you entered is
     * deleted and all audit checks are reset to disabled.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteAccountAuditConfiguration</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAccountAuditConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteAccountAuditConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteAccountAuditConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.DeleteAccountAuditConfigurationRequest.Builder} to create
     *        a request.
     * @return Result of the DeleteAccountAuditConfiguration operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteAccountAuditConfiguration
     */
    default DeleteAccountAuditConfigurationResponse deleteAccountAuditConfiguration(
            Consumer<DeleteAccountAuditConfigurationRequest.Builder> deleteAccountAuditConfigurationRequest)
            throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, InternalFailureException,
            AwsServiceException, SdkClientException, IotException {
        return deleteAccountAuditConfiguration(DeleteAccountAuditConfigurationRequest.builder()
                .applyMutation(deleteAccountAuditConfigurationRequest).build());
    }

    /**
     * <p>
     * Restores the default settings for Device Defender audits for this account. Any configuration data you entered is
     * deleted and all audit checks are reset to disabled.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteAccountAuditConfiguration</a> action.
     * </p>
     *
     * @return Result of the DeleteAccountAuditConfiguration operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteAccountAuditConfiguration
     * @see #deleteAccountAuditConfiguration(DeleteAccountAuditConfigurationRequest)
     */
    default DeleteAccountAuditConfigurationResponse deleteAccountAuditConfiguration() throws InvalidRequestException,
            ResourceNotFoundException, ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException,
            IotException {
        return deleteAccountAuditConfiguration(DeleteAccountAuditConfigurationRequest.builder().build());
    }

    /**
     * <p>
     * Deletes a Device Defender audit suppression.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteAuditSuppression</a> action.
     * </p>
     *
     * @param deleteAuditSuppressionRequest
     * @return Result of the DeleteAuditSuppression operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteAuditSuppression
     */
    default DeleteAuditSuppressionResponse deleteAuditSuppression(DeleteAuditSuppressionRequest deleteAuditSuppressionRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a Device Defender audit suppression.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteAuditSuppression</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAuditSuppressionRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteAuditSuppressionRequest#builder()}
     * </p>
     *
     * @param deleteAuditSuppressionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.DeleteAuditSuppressionRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteAuditSuppression operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteAuditSuppression
     */
    default DeleteAuditSuppressionResponse deleteAuditSuppression(
            Consumer<DeleteAuditSuppressionRequest.Builder> deleteAuditSuppressionRequest) throws InvalidRequestException,
            ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException, IotException {
        return deleteAuditSuppression(DeleteAuditSuppressionRequest.builder().applyMutation(deleteAuditSuppressionRequest)
                .build());
    }

    /**
     * <p>
     * Deletes an authorizer.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteAuthorizer</a> action.
     * </p>
     *
     * @param deleteAuthorizerRequest
     * @return Result of the DeleteAuthorizer operation returned by the service.
     * @throws DeleteConflictException
     *         You can't delete the resource because it is attached to one or more resources.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteAuthorizer
     */
    default DeleteAuthorizerResponse deleteAuthorizer(DeleteAuthorizerRequest deleteAuthorizerRequest)
            throws DeleteConflictException, ResourceNotFoundException, InvalidRequestException, ThrottlingException,
            UnauthorizedException, ServiceUnavailableException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an authorizer.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteAuthorizer</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAuthorizerRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteAuthorizerRequest#builder()}
     * </p>
     *
     * @param deleteAuthorizerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.DeleteAuthorizerRequest.Builder} to create a request.
     * @return Result of the DeleteAuthorizer operation returned by the service.
     * @throws DeleteConflictException
     *         You can't delete the resource because it is attached to one or more resources.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteAuthorizer
     */
    default DeleteAuthorizerResponse deleteAuthorizer(Consumer<DeleteAuthorizerRequest.Builder> deleteAuthorizerRequest)
            throws DeleteConflictException, ResourceNotFoundException, InvalidRequestException, ThrottlingException,
            UnauthorizedException, ServiceUnavailableException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        return deleteAuthorizer(DeleteAuthorizerRequest.builder().applyMutation(deleteAuthorizerRequest).build());
    }

    /**
     * <p>
     * Deletes the billing group.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteBillingGroup</a> action.
     * </p>
     *
     * @param deleteBillingGroupRequest
     * @return Result of the DeleteBillingGroup operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws VersionConflictException
     *         An exception thrown when the version of an entity specified with the <code>expectedVersion</code>
     *         parameter does not match the latest version in the system.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteBillingGroup
     */
    default DeleteBillingGroupResponse deleteBillingGroup(DeleteBillingGroupRequest deleteBillingGroupRequest)
            throws InvalidRequestException, VersionConflictException, ThrottlingException, InternalFailureException,
            AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the billing group.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteBillingGroup</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBillingGroupRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteBillingGroupRequest#builder()}
     * </p>
     *
     * @param deleteBillingGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.DeleteBillingGroupRequest.Builder} to create a request.
     * @return Result of the DeleteBillingGroup operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws VersionConflictException
     *         An exception thrown when the version of an entity specified with the <code>expectedVersion</code>
     *         parameter does not match the latest version in the system.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteBillingGroup
     */
    default DeleteBillingGroupResponse deleteBillingGroup(Consumer<DeleteBillingGroupRequest.Builder> deleteBillingGroupRequest)
            throws InvalidRequestException, VersionConflictException, ThrottlingException, InternalFailureException,
            AwsServiceException, SdkClientException, IotException {
        return deleteBillingGroup(DeleteBillingGroupRequest.builder().applyMutation(deleteBillingGroupRequest).build());
    }

    /**
     * <p>
     * Deletes a registered CA certificate.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteCACertificate</a> action.
     * </p>
     *
     * @param deleteCaCertificateRequest
     *        Input for the DeleteCACertificate operation.
     * @return Result of the DeleteCACertificate operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws CertificateStateException
     *         The certificate operation is not allowed.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteCACertificate
     */
    default DeleteCaCertificateResponse deleteCACertificate(DeleteCaCertificateRequest deleteCaCertificateRequest)
            throws InvalidRequestException, CertificateStateException, ThrottlingException, UnauthorizedException,
            ServiceUnavailableException, InternalFailureException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a registered CA certificate.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteCACertificate</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCaCertificateRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteCaCertificateRequest#builder()}
     * </p>
     *
     * @param deleteCaCertificateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.DeleteCaCertificateRequest.Builder} to create a request.
     *        Input for the DeleteCACertificate operation.
     * @return Result of the DeleteCACertificate operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws CertificateStateException
     *         The certificate operation is not allowed.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteCACertificate
     */
    default DeleteCaCertificateResponse deleteCACertificate(
            Consumer<DeleteCaCertificateRequest.Builder> deleteCaCertificateRequest) throws InvalidRequestException,
            CertificateStateException, ThrottlingException, UnauthorizedException, ServiceUnavailableException,
            InternalFailureException, ResourceNotFoundException, AwsServiceException, SdkClientException, IotException {
        return deleteCACertificate(DeleteCaCertificateRequest.builder().applyMutation(deleteCaCertificateRequest).build());
    }

    /**
     * <p>
     * Deletes the specified certificate.
     * </p>
     * <p>
     * A certificate cannot be deleted if it has a policy or IoT thing attached to it or if its status is set to ACTIVE.
     * To delete a certificate, first use the <a>DetachPolicy</a> action to detach all policies. Next, use the
     * <a>UpdateCertificate</a> action to set the certificate to the INACTIVE status.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteCertificate</a> action.
     * </p>
     *
     * @param deleteCertificateRequest
     *        The input for the DeleteCertificate operation.
     * @return Result of the DeleteCertificate operation returned by the service.
     * @throws CertificateStateException
     *         The certificate operation is not allowed.
     * @throws DeleteConflictException
     *         You can't delete the resource because it is attached to one or more resources.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteCertificate
     */
    default DeleteCertificateResponse deleteCertificate(DeleteCertificateRequest deleteCertificateRequest)
            throws CertificateStateException, DeleteConflictException, InvalidRequestException, ThrottlingException,
            UnauthorizedException, ServiceUnavailableException, InternalFailureException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified certificate.
     * </p>
     * <p>
     * A certificate cannot be deleted if it has a policy or IoT thing attached to it or if its status is set to ACTIVE.
     * To delete a certificate, first use the <a>DetachPolicy</a> action to detach all policies. Next, use the
     * <a>UpdateCertificate</a> action to set the certificate to the INACTIVE status.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteCertificate</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCertificateRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteCertificateRequest#builder()}
     * </p>
     *
     * @param deleteCertificateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.DeleteCertificateRequest.Builder} to create a request.
     *        The input for the DeleteCertificate operation.
     * @return Result of the DeleteCertificate operation returned by the service.
     * @throws CertificateStateException
     *         The certificate operation is not allowed.
     * @throws DeleteConflictException
     *         You can't delete the resource because it is attached to one or more resources.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteCertificate
     */
    default DeleteCertificateResponse deleteCertificate(Consumer<DeleteCertificateRequest.Builder> deleteCertificateRequest)
            throws CertificateStateException, DeleteConflictException, InvalidRequestException, ThrottlingException,
            UnauthorizedException, ServiceUnavailableException, InternalFailureException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, IotException {
        return deleteCertificate(DeleteCertificateRequest.builder().applyMutation(deleteCertificateRequest).build());
    }

    /**
     * <p>
     * Deletes a certificate provider.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteCertificateProvider</a> action.
     * </p>
     * <p>
     * If you delete the certificate provider resource, the behavior of <code>CreateCertificateFromCsr</code> will
     * resume, and IoT will create certificates signed by IoT from a certificate signing request (CSR).
     * </p>
     *
     * @param deleteCertificateProviderRequest
     * @return Result of the DeleteCertificateProvider operation returned by the service.
     * @throws DeleteConflictException
     *         You can't delete the resource because it is attached to one or more resources.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteCertificateProvider
     */
    default DeleteCertificateProviderResponse deleteCertificateProvider(
            DeleteCertificateProviderRequest deleteCertificateProviderRequest) throws DeleteConflictException,
            ResourceNotFoundException, InvalidRequestException, ThrottlingException, UnauthorizedException,
            ServiceUnavailableException, InternalFailureException, AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a certificate provider.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteCertificateProvider</a> action.
     * </p>
     * <p>
     * If you delete the certificate provider resource, the behavior of <code>CreateCertificateFromCsr</code> will
     * resume, and IoT will create certificates signed by IoT from a certificate signing request (CSR).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCertificateProviderRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteCertificateProviderRequest#builder()}
     * </p>
     *
     * @param deleteCertificateProviderRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.DeleteCertificateProviderRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteCertificateProvider operation returned by the service.
     * @throws DeleteConflictException
     *         You can't delete the resource because it is attached to one or more resources.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteCertificateProvider
     */
    default DeleteCertificateProviderResponse deleteCertificateProvider(
            Consumer<DeleteCertificateProviderRequest.Builder> deleteCertificateProviderRequest) throws DeleteConflictException,
            ResourceNotFoundException, InvalidRequestException, ThrottlingException, UnauthorizedException,
            ServiceUnavailableException, InternalFailureException, AwsServiceException, SdkClientException, IotException {
        return deleteCertificateProvider(DeleteCertificateProviderRequest.builder()
                .applyMutation(deleteCertificateProviderRequest).build());
    }

    /**
     * <p>
     * Deletes a Device Defender detect custom metric.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteCustomMetric</a> action.
     * </p>
     * <note>
     * <p>
     * Before you can delete a custom metric, you must first remove the custom metric from all security profiles it's a
     * part of. The security profile associated with the custom metric can be found using the <a
     * href="https://docs.aws.amazon.com/iot/latest/apireference/API_ListSecurityProfiles.html">ListSecurityProfiles</a>
     * API with <code>metricName</code> set to your custom metric name.
     * </p>
     * </note>
     *
     * @param deleteCustomMetricRequest
     * @return Result of the DeleteCustomMetric operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteCustomMetric
     */
    default DeleteCustomMetricResponse deleteCustomMetric(DeleteCustomMetricRequest deleteCustomMetricRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a Device Defender detect custom metric.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteCustomMetric</a> action.
     * </p>
     * <note>
     * <p>
     * Before you can delete a custom metric, you must first remove the custom metric from all security profiles it's a
     * part of. The security profile associated with the custom metric can be found using the <a
     * href="https://docs.aws.amazon.com/iot/latest/apireference/API_ListSecurityProfiles.html">ListSecurityProfiles</a>
     * API with <code>metricName</code> set to your custom metric name.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCustomMetricRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteCustomMetricRequest#builder()}
     * </p>
     *
     * @param deleteCustomMetricRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.DeleteCustomMetricRequest.Builder} to create a request.
     * @return Result of the DeleteCustomMetric operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteCustomMetric
     */
    default DeleteCustomMetricResponse deleteCustomMetric(Consumer<DeleteCustomMetricRequest.Builder> deleteCustomMetricRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        return deleteCustomMetric(DeleteCustomMetricRequest.builder().applyMutation(deleteCustomMetricRequest).build());
    }

    /**
     * <p>
     * Removes the specified dimension from your Amazon Web Services accounts.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteDimension</a> action.
     * </p>
     *
     * @param deleteDimensionRequest
     * @return Result of the DeleteDimension operation returned by the service.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteDimension
     */
    default DeleteDimensionResponse deleteDimension(DeleteDimensionRequest deleteDimensionRequest)
            throws InternalFailureException, InvalidRequestException, ThrottlingException, AwsServiceException,
            SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the specified dimension from your Amazon Web Services accounts.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteDimension</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDimensionRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteDimensionRequest#builder()}
     * </p>
     *
     * @param deleteDimensionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.DeleteDimensionRequest.Builder} to create a request.
     * @return Result of the DeleteDimension operation returned by the service.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteDimension
     */
    default DeleteDimensionResponse deleteDimension(Consumer<DeleteDimensionRequest.Builder> deleteDimensionRequest)
            throws InternalFailureException, InvalidRequestException, ThrottlingException, AwsServiceException,
            SdkClientException, IotException {
        return deleteDimension(DeleteDimensionRequest.builder().applyMutation(deleteDimensionRequest).build());
    }

    /**
     * <p>
     * Deletes the specified domain configuration.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteDomainConfiguration</a> action.
     * </p>
     *
     * @param deleteDomainConfigurationRequest
     * @return Result of the DeleteDomainConfiguration operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteDomainConfiguration
     */
    default DeleteDomainConfigurationResponse deleteDomainConfiguration(
            DeleteDomainConfigurationRequest deleteDomainConfigurationRequest) throws ResourceNotFoundException,
            ThrottlingException, UnauthorizedException, ServiceUnavailableException, InternalFailureException,
            InvalidRequestException, AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified domain configuration.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteDomainConfiguration</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDomainConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteDomainConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteDomainConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.DeleteDomainConfigurationRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteDomainConfiguration operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteDomainConfiguration
     */
    default DeleteDomainConfigurationResponse deleteDomainConfiguration(
            Consumer<DeleteDomainConfigurationRequest.Builder> deleteDomainConfigurationRequest)
            throws ResourceNotFoundException, ThrottlingException, UnauthorizedException, ServiceUnavailableException,
            InternalFailureException, InvalidRequestException, AwsServiceException, SdkClientException, IotException {
        return deleteDomainConfiguration(DeleteDomainConfigurationRequest.builder()
                .applyMutation(deleteDomainConfigurationRequest).build());
    }

    /**
     * <p>
     * Deletes a dynamic thing group.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteDynamicThingGroup</a> action.
     * </p>
     *
     * @param deleteDynamicThingGroupRequest
     * @return Result of the DeleteDynamicThingGroup operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws VersionConflictException
     *         An exception thrown when the version of an entity specified with the <code>expectedVersion</code>
     *         parameter does not match the latest version in the system.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteDynamicThingGroup
     */
    default DeleteDynamicThingGroupResponse deleteDynamicThingGroup(DeleteDynamicThingGroupRequest deleteDynamicThingGroupRequest)
            throws InvalidRequestException, VersionConflictException, ThrottlingException, InternalFailureException,
            AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a dynamic thing group.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteDynamicThingGroup</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDynamicThingGroupRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteDynamicThingGroupRequest#builder()}
     * </p>
     *
     * @param deleteDynamicThingGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.DeleteDynamicThingGroupRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteDynamicThingGroup operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws VersionConflictException
     *         An exception thrown when the version of an entity specified with the <code>expectedVersion</code>
     *         parameter does not match the latest version in the system.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteDynamicThingGroup
     */
    default DeleteDynamicThingGroupResponse deleteDynamicThingGroup(
            Consumer<DeleteDynamicThingGroupRequest.Builder> deleteDynamicThingGroupRequest) throws InvalidRequestException,
            VersionConflictException, ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException,
            IotException {
        return deleteDynamicThingGroup(DeleteDynamicThingGroupRequest.builder().applyMutation(deleteDynamicThingGroupRequest)
                .build());
    }

    /**
     * <p>
     * Deletes the specified fleet metric. Returns successfully with no error if the deletion is successful or you
     * specify a fleet metric that doesn't exist.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteFleetMetric</a> action.
     * </p>
     *
     * @param deleteFleetMetricRequest
     * @return Result of the DeleteFleetMetric operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws VersionConflictException
     *         An exception thrown when the version of an entity specified with the <code>expectedVersion</code>
     *         parameter does not match the latest version in the system.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteFleetMetric
     */
    default DeleteFleetMetricResponse deleteFleetMetric(DeleteFleetMetricRequest deleteFleetMetricRequest)
            throws InvalidRequestException, ThrottlingException, UnauthorizedException, ServiceUnavailableException,
            InternalFailureException, VersionConflictException, AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified fleet metric. Returns successfully with no error if the deletion is successful or you
     * specify a fleet metric that doesn't exist.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteFleetMetric</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFleetMetricRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteFleetMetricRequest#builder()}
     * </p>
     *
     * @param deleteFleetMetricRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.DeleteFleetMetricRequest.Builder} to create a request.
     * @return Result of the DeleteFleetMetric operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws VersionConflictException
     *         An exception thrown when the version of an entity specified with the <code>expectedVersion</code>
     *         parameter does not match the latest version in the system.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteFleetMetric
     */
    default DeleteFleetMetricResponse deleteFleetMetric(Consumer<DeleteFleetMetricRequest.Builder> deleteFleetMetricRequest)
            throws InvalidRequestException, ThrottlingException, UnauthorizedException, ServiceUnavailableException,
            InternalFailureException, VersionConflictException, AwsServiceException, SdkClientException, IotException {
        return deleteFleetMetric(DeleteFleetMetricRequest.builder().applyMutation(deleteFleetMetricRequest).build());
    }

    /**
     * <p>
     * Deletes a job and its related job executions.
     * </p>
     * <p>
     * Deleting a job may take time, depending on the number of job executions created for the job and various other
     * factors. While the job is being deleted, the status of the job will be shown as "DELETION_IN_PROGRESS".
     * Attempting to delete or cancel a job whose status is already "DELETION_IN_PROGRESS" will result in an error.
     * </p>
     * <p>
     * Only 10 jobs may have status "DELETION_IN_PROGRESS" at the same time, or a LimitExceededException will occur.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteJob</a> action.
     * </p>
     *
     * @param deleteJobRequest
     * @return Result of the DeleteJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidStateTransitionException
     *         An attempt was made to change to an invalid state, for example by deleting a job or a job execution which
     *         is "IN_PROGRESS" without setting the <code>force</code> parameter.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteJob
     */
    default DeleteJobResponse deleteJob(DeleteJobRequest deleteJobRequest) throws InvalidRequestException,
            InvalidStateTransitionException, ResourceNotFoundException, LimitExceededException, ThrottlingException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a job and its related job executions.
     * </p>
     * <p>
     * Deleting a job may take time, depending on the number of job executions created for the job and various other
     * factors. While the job is being deleted, the status of the job will be shown as "DELETION_IN_PROGRESS".
     * Attempting to delete or cancel a job whose status is already "DELETION_IN_PROGRESS" will result in an error.
     * </p>
     * <p>
     * Only 10 jobs may have status "DELETION_IN_PROGRESS" at the same time, or a LimitExceededException will occur.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteJob</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteJobRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteJobRequest#builder()}
     * </p>
     *
     * @param deleteJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.DeleteJobRequest.Builder} to create a request.
     * @return Result of the DeleteJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidStateTransitionException
     *         An attempt was made to change to an invalid state, for example by deleting a job or a job execution which
     *         is "IN_PROGRESS" without setting the <code>force</code> parameter.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteJob
     */
    default DeleteJobResponse deleteJob(Consumer<DeleteJobRequest.Builder> deleteJobRequest) throws InvalidRequestException,
            InvalidStateTransitionException, ResourceNotFoundException, LimitExceededException, ThrottlingException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, IotException {
        return deleteJob(DeleteJobRequest.builder().applyMutation(deleteJobRequest).build());
    }

    /**
     * <p>
     * Deletes a job execution.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteJobExecution</a> action.
     * </p>
     *
     * @param deleteJobExecutionRequest
     * @return Result of the DeleteJobExecution operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidStateTransitionException
     *         An attempt was made to change to an invalid state, for example by deleting a job or a job execution which
     *         is "IN_PROGRESS" without setting the <code>force</code> parameter.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteJobExecution
     */
    default DeleteJobExecutionResponse deleteJobExecution(DeleteJobExecutionRequest deleteJobExecutionRequest)
            throws InvalidRequestException, InvalidStateTransitionException, ResourceNotFoundException, ThrottlingException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a job execution.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteJobExecution</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteJobExecutionRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteJobExecutionRequest#builder()}
     * </p>
     *
     * @param deleteJobExecutionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.DeleteJobExecutionRequest.Builder} to create a request.
     * @return Result of the DeleteJobExecution operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InvalidStateTransitionException
     *         An attempt was made to change to an invalid state, for example by deleting a job or a job execution which
     *         is "IN_PROGRESS" without setting the <code>force</code> parameter.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteJobExecution
     */
    default DeleteJobExecutionResponse deleteJobExecution(Consumer<DeleteJobExecutionRequest.Builder> deleteJobExecutionRequest)
            throws InvalidRequestException, InvalidStateTransitionException, ResourceNotFoundException, ThrottlingException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, IotException {
        return deleteJobExecution(DeleteJobExecutionRequest.builder().applyMutation(deleteJobExecutionRequest).build());
    }

    /**
     * <p>
     * Deletes the specified job template.
     * </p>
     *
     * @param deleteJobTemplateRequest
     * @return Result of the DeleteJobTemplate operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteJobTemplate
     */
    default DeleteJobTemplateResponse deleteJobTemplate(DeleteJobTemplateRequest deleteJobTemplateRequest)
            throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, InternalFailureException,
            AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified job template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteJobTemplateRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteJobTemplateRequest#builder()}
     * </p>
     *
     * @param deleteJobTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.DeleteJobTemplateRequest.Builder} to create a request.
     * @return Result of the DeleteJobTemplate operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteJobTemplate
     */
    default DeleteJobTemplateResponse deleteJobTemplate(Consumer<DeleteJobTemplateRequest.Builder> deleteJobTemplateRequest)
            throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, InternalFailureException,
            AwsServiceException, SdkClientException, IotException {
        return deleteJobTemplate(DeleteJobTemplateRequest.builder().applyMutation(deleteJobTemplateRequest).build());
    }

    /**
     * <p>
     * Deletes a defined mitigation action from your Amazon Web Services accounts.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteMitigationAction</a> action.
     * </p>
     *
     * @param deleteMitigationActionRequest
     * @return Result of the DeleteMitigationAction operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteMitigationAction
     */
    default DeleteMitigationActionResponse deleteMitigationAction(DeleteMitigationActionRequest deleteMitigationActionRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a defined mitigation action from your Amazon Web Services accounts.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteMitigationAction</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteMitigationActionRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteMitigationActionRequest#builder()}
     * </p>
     *
     * @param deleteMitigationActionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.DeleteMitigationActionRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteMitigationAction operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteMitigationAction
     */
    default DeleteMitigationActionResponse deleteMitigationAction(
            Consumer<DeleteMitigationActionRequest.Builder> deleteMitigationActionRequest) throws InvalidRequestException,
            ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException, IotException {
        return deleteMitigationAction(DeleteMitigationActionRequest.builder().applyMutation(deleteMitigationActionRequest)
                .build());
    }

    /**
     * <p>
     * Delete an OTA update.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteOTAUpdate</a> action.
     * </p>
     *
     * @param deleteOtaUpdateRequest
     * @return Result of the DeleteOTAUpdate operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws VersionConflictException
     *         An exception thrown when the version of an entity specified with the <code>expectedVersion</code>
     *         parameter does not match the latest version in the system.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteOTAUpdate
     */
    default DeleteOtaUpdateResponse deleteOTAUpdate(DeleteOtaUpdateRequest deleteOtaUpdateRequest)
            throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, UnauthorizedException,
            InternalFailureException, ServiceUnavailableException, VersionConflictException, AwsServiceException,
            SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete an OTA update.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteOTAUpdate</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteOtaUpdateRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteOtaUpdateRequest#builder()}
     * </p>
     *
     * @param deleteOtaUpdateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.DeleteOtaUpdateRequest.Builder} to create a request.
     * @return Result of the DeleteOTAUpdate operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws VersionConflictException
     *         An exception thrown when the version of an entity specified with the <code>expectedVersion</code>
     *         parameter does not match the latest version in the system.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteOTAUpdate
     */
    default DeleteOtaUpdateResponse deleteOTAUpdate(Consumer<DeleteOtaUpdateRequest.Builder> deleteOtaUpdateRequest)
            throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, UnauthorizedException,
            InternalFailureException, ServiceUnavailableException, VersionConflictException, AwsServiceException,
            SdkClientException, IotException {
        return deleteOTAUpdate(DeleteOtaUpdateRequest.builder().applyMutation(deleteOtaUpdateRequest).build());
    }

    /**
     * <p>
     * Deletes a specific version from a software package.
     * </p>
     * <p>
     * <b>Note:</b> All package versions must be deleted before deleting the software package.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeletePackageVersion</a> action.
     * </p>
     *
     * @param deletePackageRequest
     * @return Result of the DeletePackage operation returned by the service.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ValidationException
     *         The request is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeletePackage
     */
    default DeletePackageResponse deletePackage(DeletePackageRequest deletePackageRequest) throws ThrottlingException,
            InternalServerException, ValidationException, AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a specific version from a software package.
     * </p>
     * <p>
     * <b>Note:</b> All package versions must be deleted before deleting the software package.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeletePackageVersion</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePackageRequest.Builder} avoiding the need to
     * create one manually via {@link DeletePackageRequest#builder()}
     * </p>
     *
     * @param deletePackageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.DeletePackageRequest.Builder} to create a request.
     * @return Result of the DeletePackage operation returned by the service.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ValidationException
     *         The request is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeletePackage
     */
    default DeletePackageResponse deletePackage(Consumer<DeletePackageRequest.Builder> deletePackageRequest)
            throws ThrottlingException, InternalServerException, ValidationException, AwsServiceException, SdkClientException,
            IotException {
        return deletePackage(DeletePackageRequest.builder().applyMutation(deletePackageRequest).build());
    }

    /**
     * <p>
     * Deletes a specific version from a software package.
     * </p>
     * <p>
     * <b>Note:</b> If a package version is designated as default, you must remove the designation from the software
     * package using the <a>UpdatePackage</a> action.
     * </p>
     *
     * @param deletePackageVersionRequest
     * @return Result of the DeletePackageVersion operation returned by the service.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ValidationException
     *         The request is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeletePackageVersion
     */
    default DeletePackageVersionResponse deletePackageVersion(DeletePackageVersionRequest deletePackageVersionRequest)
            throws ThrottlingException, InternalServerException, ValidationException, AwsServiceException, SdkClientException,
            IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a specific version from a software package.
     * </p>
     * <p>
     * <b>Note:</b> If a package version is designated as default, you must remove the designation from the software
     * package using the <a>UpdatePackage</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePackageVersionRequest.Builder} avoiding the
     * need to create one manually via {@link DeletePackageVersionRequest#builder()}
     * </p>
     *
     * @param deletePackageVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.DeletePackageVersionRequest.Builder} to create a request.
     * @return Result of the DeletePackageVersion operation returned by the service.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ValidationException
     *         The request is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeletePackageVersion
     */
    default DeletePackageVersionResponse deletePackageVersion(
            Consumer<DeletePackageVersionRequest.Builder> deletePackageVersionRequest) throws ThrottlingException,
            InternalServerException, ValidationException, AwsServiceException, SdkClientException, IotException {
        return deletePackageVersion(DeletePackageVersionRequest.builder().applyMutation(deletePackageVersionRequest).build());
    }

    /**
     * <p>
     * Deletes the specified policy.
     * </p>
     * <p>
     * A policy cannot be deleted if it has non-default versions or it is attached to any certificate.
     * </p>
     * <p>
     * To delete a policy, use the <a>DeletePolicyVersion</a> action to delete all non-default versions of the policy;
     * use the <a>DetachPolicy</a> action to detach the policy from any certificate; and then use the DeletePolicy
     * action to delete the policy.
     * </p>
     * <p>
     * When a policy is deleted using DeletePolicy, its default version is deleted with it.
     * </p>
     * <note>
     * <p>
     * Because of the distributed nature of Amazon Web Services, it can take up to five minutes after a policy is
     * detached before it's ready to be deleted.
     * </p>
     * </note>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeletePolicy</a> action.
     * </p>
     *
     * @param deletePolicyRequest
     *        The input for the DeletePolicy operation.
     * @return Result of the DeletePolicy operation returned by the service.
     * @throws DeleteConflictException
     *         You can't delete the resource because it is attached to one or more resources.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeletePolicy
     */
    default DeletePolicyResponse deletePolicy(DeletePolicyRequest deletePolicyRequest) throws DeleteConflictException,
            ResourceNotFoundException, InvalidRequestException, ThrottlingException, UnauthorizedException,
            ServiceUnavailableException, InternalFailureException, AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified policy.
     * </p>
     * <p>
     * A policy cannot be deleted if it has non-default versions or it is attached to any certificate.
     * </p>
     * <p>
     * To delete a policy, use the <a>DeletePolicyVersion</a> action to delete all non-default versions of the policy;
     * use the <a>DetachPolicy</a> action to detach the policy from any certificate; and then use the DeletePolicy
     * action to delete the policy.
     * </p>
     * <p>
     * When a policy is deleted using DeletePolicy, its default version is deleted with it.
     * </p>
     * <note>
     * <p>
     * Because of the distributed nature of Amazon Web Services, it can take up to five minutes after a policy is
     * detached before it's ready to be deleted.
     * </p>
     * </note>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeletePolicy</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePolicyRequest.Builder} avoiding the need to
     * create one manually via {@link DeletePolicyRequest#builder()}
     * </p>
     *
     * @param deletePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.DeletePolicyRequest.Builder} to create a request. The
     *        input for the DeletePolicy operation.
     * @return Result of the DeletePolicy operation returned by the service.
     * @throws DeleteConflictException
     *         You can't delete the resource because it is attached to one or more resources.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeletePolicy
     */
    default DeletePolicyResponse deletePolicy(Consumer<DeletePolicyRequest.Builder> deletePolicyRequest)
            throws DeleteConflictException, ResourceNotFoundException, InvalidRequestException, ThrottlingException,
            UnauthorizedException, ServiceUnavailableException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        return deletePolicy(DeletePolicyRequest.builder().applyMutation(deletePolicyRequest).build());
    }

    /**
     * <p>
     * Deletes the specified version of the specified policy. You cannot delete the default version of a policy using
     * this action. To delete the default version of a policy, use <a>DeletePolicy</a>. To find out which version of a
     * policy is marked as the default version, use ListPolicyVersions.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeletePolicyVersion</a> action.
     * </p>
     *
     * @param deletePolicyVersionRequest
     *        The input for the DeletePolicyVersion operation.
     * @return Result of the DeletePolicyVersion operation returned by the service.
     * @throws DeleteConflictException
     *         You can't delete the resource because it is attached to one or more resources.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeletePolicyVersion
     */
    default DeletePolicyVersionResponse deletePolicyVersion(DeletePolicyVersionRequest deletePolicyVersionRequest)
            throws DeleteConflictException, ResourceNotFoundException, InvalidRequestException, ThrottlingException,
            UnauthorizedException, ServiceUnavailableException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified version of the specified policy. You cannot delete the default version of a policy using
     * this action. To delete the default version of a policy, use <a>DeletePolicy</a>. To find out which version of a
     * policy is marked as the default version, use ListPolicyVersions.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeletePolicyVersion</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePolicyVersionRequest.Builder} avoiding the
     * need to create one manually via {@link DeletePolicyVersionRequest#builder()}
     * </p>
     *
     * @param deletePolicyVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.DeletePolicyVersionRequest.Builder} to create a request.
     *        The input for the DeletePolicyVersion operation.
     * @return Result of the DeletePolicyVersion operation returned by the service.
     * @throws DeleteConflictException
     *         You can't delete the resource because it is attached to one or more resources.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeletePolicyVersion
     */
    default DeletePolicyVersionResponse deletePolicyVersion(
            Consumer<DeletePolicyVersionRequest.Builder> deletePolicyVersionRequest) throws DeleteConflictException,
            ResourceNotFoundException, InvalidRequestException, ThrottlingException, UnauthorizedException,
            ServiceUnavailableException, InternalFailureException, AwsServiceException, SdkClientException, IotException {
        return deletePolicyVersion(DeletePolicyVersionRequest.builder().applyMutation(deletePolicyVersionRequest).build());
    }

    /**
     * <p>
     * Deletes a provisioning template.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteProvisioningTemplate</a> action.
     * </p>
     *
     * @param deleteProvisioningTemplateRequest
     * @return Result of the DeleteProvisioningTemplate operation returned by the service.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws DeleteConflictException
     *         You can't delete the resource because it is attached to one or more resources.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ConflictingResourceUpdateException
     *         A conflicting resource update exception. This exception is thrown when two pending updates cause a
     *         conflict.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteProvisioningTemplate
     */
    default DeleteProvisioningTemplateResponse deleteProvisioningTemplate(
            DeleteProvisioningTemplateRequest deleteProvisioningTemplateRequest) throws InternalFailureException,
            InvalidRequestException, ResourceNotFoundException, DeleteConflictException, ThrottlingException,
            ConflictingResourceUpdateException, UnauthorizedException, AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a provisioning template.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteProvisioningTemplate</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteProvisioningTemplateRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteProvisioningTemplateRequest#builder()}
     * </p>
     *
     * @param deleteProvisioningTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.DeleteProvisioningTemplateRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteProvisioningTemplate operation returned by the service.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws DeleteConflictException
     *         You can't delete the resource because it is attached to one or more resources.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ConflictingResourceUpdateException
     *         A conflicting resource update exception. This exception is thrown when two pending updates cause a
     *         conflict.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteProvisioningTemplate
     */
    default DeleteProvisioningTemplateResponse deleteProvisioningTemplate(
            Consumer<DeleteProvisioningTemplateRequest.Builder> deleteProvisioningTemplateRequest)
            throws InternalFailureException, InvalidRequestException, ResourceNotFoundException, DeleteConflictException,
            ThrottlingException, ConflictingResourceUpdateException, UnauthorizedException, AwsServiceException,
            SdkClientException, IotException {
        return deleteProvisioningTemplate(DeleteProvisioningTemplateRequest.builder()
                .applyMutation(deleteProvisioningTemplateRequest).build());
    }

    /**
     * <p>
     * Deletes a provisioning template version.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteProvisioningTemplateVersion</a> action.
     * </p>
     *
     * @param deleteProvisioningTemplateVersionRequest
     * @return Result of the DeleteProvisioningTemplateVersion operation returned by the service.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ConflictingResourceUpdateException
     *         A conflicting resource update exception. This exception is thrown when two pending updates cause a
     *         conflict.
     * @throws DeleteConflictException
     *         You can't delete the resource because it is attached to one or more resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteProvisioningTemplateVersion
     */
    default DeleteProvisioningTemplateVersionResponse deleteProvisioningTemplateVersion(
            DeleteProvisioningTemplateVersionRequest deleteProvisioningTemplateVersionRequest) throws InternalFailureException,
            InvalidRequestException, ThrottlingException, ResourceNotFoundException, UnauthorizedException,
            ConflictingResourceUpdateException, DeleteConflictException, AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a provisioning template version.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteProvisioningTemplateVersion</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteProvisioningTemplateVersionRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteProvisioningTemplateVersionRequest#builder()}
     * </p>
     *
     * @param deleteProvisioningTemplateVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.DeleteProvisioningTemplateVersionRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteProvisioningTemplateVersion operation returned by the service.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ConflictingResourceUpdateException
     *         A conflicting resource update exception. This exception is thrown when two pending updates cause a
     *         conflict.
     * @throws DeleteConflictException
     *         You can't delete the resource because it is attached to one or more resources.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteProvisioningTemplateVersion
     */
    default DeleteProvisioningTemplateVersionResponse deleteProvisioningTemplateVersion(
            Consumer<DeleteProvisioningTemplateVersionRequest.Builder> deleteProvisioningTemplateVersionRequest)
            throws InternalFailureException, InvalidRequestException, ThrottlingException, ResourceNotFoundException,
            UnauthorizedException, ConflictingResourceUpdateException, DeleteConflictException, AwsServiceException,
            SdkClientException, IotException {
        return deleteProvisioningTemplateVersion(DeleteProvisioningTemplateVersionRequest.builder()
                .applyMutation(deleteProvisioningTemplateVersionRequest).build());
    }

    /**
     * <p>
     * Deletes a CA certificate registration code.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteRegistrationCode</a> action.
     * </p>
     *
     * @param deleteRegistrationCodeRequest
     *        The input for the DeleteRegistrationCode operation.
     * @return Result of the DeleteRegistrationCode operation returned by the service.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteRegistrationCode
     */
    default DeleteRegistrationCodeResponse deleteRegistrationCode(DeleteRegistrationCodeRequest deleteRegistrationCodeRequest)
            throws ThrottlingException, ResourceNotFoundException, UnauthorizedException, ServiceUnavailableException,
            InternalFailureException, AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a CA certificate registration code.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteRegistrationCode</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRegistrationCodeRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteRegistrationCodeRequest#builder()}
     * </p>
     *
     * @param deleteRegistrationCodeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.DeleteRegistrationCodeRequest.Builder} to create a
     *        request. The input for the DeleteRegistrationCode operation.
     * @return Result of the DeleteRegistrationCode operation returned by the service.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteRegistrationCode
     */
    default DeleteRegistrationCodeResponse deleteRegistrationCode(
            Consumer<DeleteRegistrationCodeRequest.Builder> deleteRegistrationCodeRequest) throws ThrottlingException,
            ResourceNotFoundException, UnauthorizedException, ServiceUnavailableException, InternalFailureException,
            AwsServiceException, SdkClientException, IotException {
        return deleteRegistrationCode(DeleteRegistrationCodeRequest.builder().applyMutation(deleteRegistrationCodeRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a CA certificate registration code.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteRegistrationCode</a> action.
     * </p>
     *
     * @return Result of the DeleteRegistrationCode operation returned by the service.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteRegistrationCode
     * @see #deleteRegistrationCode(DeleteRegistrationCodeRequest)
     */
    default DeleteRegistrationCodeResponse deleteRegistrationCode() throws ThrottlingException, ResourceNotFoundException,
            UnauthorizedException, ServiceUnavailableException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        return deleteRegistrationCode(DeleteRegistrationCodeRequest.builder().build());
    }

    /**
     * <p>
     * Deletes a role alias
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteRoleAlias</a> action.
     * </p>
     *
     * @param deleteRoleAliasRequest
     * @return Result of the DeleteRoleAlias operation returned by the service.
     * @throws DeleteConflictException
     *         You can't delete the resource because it is attached to one or more resources.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteRoleAlias
     */
    default DeleteRoleAliasResponse deleteRoleAlias(DeleteRoleAliasRequest deleteRoleAliasRequest)
            throws DeleteConflictException, InvalidRequestException, ThrottlingException, UnauthorizedException,
            ServiceUnavailableException, InternalFailureException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a role alias
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteRoleAlias</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRoleAliasRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteRoleAliasRequest#builder()}
     * </p>
     *
     * @param deleteRoleAliasRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.DeleteRoleAliasRequest.Builder} to create a request.
     * @return Result of the DeleteRoleAlias operation returned by the service.
     * @throws DeleteConflictException
     *         You can't delete the resource because it is attached to one or more resources.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteRoleAlias
     */
    default DeleteRoleAliasResponse deleteRoleAlias(Consumer<DeleteRoleAliasRequest.Builder> deleteRoleAliasRequest)
            throws DeleteConflictException, InvalidRequestException, ThrottlingException, UnauthorizedException,
            ServiceUnavailableException, InternalFailureException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, IotException {
        return deleteRoleAlias(DeleteRoleAliasRequest.builder().applyMutation(deleteRoleAliasRequest).build());
    }

    /**
     * <p>
     * Deletes a scheduled audit.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteScheduledAudit</a> action.
     * </p>
     *
     * @param deleteScheduledAuditRequest
     * @return Result of the DeleteScheduledAudit operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteScheduledAudit
     */
    default DeleteScheduledAuditResponse deleteScheduledAudit(DeleteScheduledAuditRequest deleteScheduledAuditRequest)
            throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, InternalFailureException,
            AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a scheduled audit.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteScheduledAudit</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteScheduledAuditRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteScheduledAuditRequest#builder()}
     * </p>
     *
     * @param deleteScheduledAuditRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.DeleteScheduledAuditRequest.Builder} to create a request.
     * @return Result of the DeleteScheduledAudit operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteScheduledAudit
     */
    default DeleteScheduledAuditResponse deleteScheduledAudit(
            Consumer<DeleteScheduledAuditRequest.Builder> deleteScheduledAuditRequest) throws InvalidRequestException,
            ResourceNotFoundException, ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException,
            IotException {
        return deleteScheduledAudit(DeleteScheduledAuditRequest.builder().applyMutation(deleteScheduledAuditRequest).build());
    }

    /**
     * <p>
     * Deletes a Device Defender security profile.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteSecurityProfile</a> action.
     * </p>
     *
     * @param deleteSecurityProfileRequest
     * @return Result of the DeleteSecurityProfile operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws VersionConflictException
     *         An exception thrown when the version of an entity specified with the <code>expectedVersion</code>
     *         parameter does not match the latest version in the system.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteSecurityProfile
     */
    default DeleteSecurityProfileResponse deleteSecurityProfile(DeleteSecurityProfileRequest deleteSecurityProfileRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, VersionConflictException,
            AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a Device Defender security profile.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteSecurityProfile</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSecurityProfileRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteSecurityProfileRequest#builder()}
     * </p>
     *
     * @param deleteSecurityProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.DeleteSecurityProfileRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteSecurityProfile operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws VersionConflictException
     *         An exception thrown when the version of an entity specified with the <code>expectedVersion</code>
     *         parameter does not match the latest version in the system.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteSecurityProfile
     */
    default DeleteSecurityProfileResponse deleteSecurityProfile(
            Consumer<DeleteSecurityProfileRequest.Builder> deleteSecurityProfileRequest) throws InvalidRequestException,
            ThrottlingException, InternalFailureException, VersionConflictException, AwsServiceException, SdkClientException,
            IotException {
        return deleteSecurityProfile(DeleteSecurityProfileRequest.builder().applyMutation(deleteSecurityProfileRequest).build());
    }

    /**
     * <p>
     * Deletes a stream.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteStream</a> action.
     * </p>
     *
     * @param deleteStreamRequest
     * @return Result of the DeleteStream operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws DeleteConflictException
     *         You can't delete the resource because it is attached to one or more resources.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteStream
     */
    default DeleteStreamResponse deleteStream(DeleteStreamRequest deleteStreamRequest) throws ResourceNotFoundException,
            DeleteConflictException, InvalidRequestException, ThrottlingException, UnauthorizedException,
            ServiceUnavailableException, InternalFailureException, AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a stream.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteStream</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteStreamRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteStreamRequest#builder()}
     * </p>
     *
     * @param deleteStreamRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.DeleteStreamRequest.Builder} to create a request.
     * @return Result of the DeleteStream operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws DeleteConflictException
     *         You can't delete the resource because it is attached to one or more resources.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteStream
     */
    default DeleteStreamResponse deleteStream(Consumer<DeleteStreamRequest.Builder> deleteStreamRequest)
            throws ResourceNotFoundException, DeleteConflictException, InvalidRequestException, ThrottlingException,
            UnauthorizedException, ServiceUnavailableException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        return deleteStream(DeleteStreamRequest.builder().applyMutation(deleteStreamRequest).build());
    }

    /**
     * <p>
     * Deletes the specified thing. Returns successfully with no error if the deletion is successful or you specify a
     * thing that doesn't exist.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteThing</a> action.
     * </p>
     *
     * @param deleteThingRequest
     *        The input for the DeleteThing operation.
     * @return Result of the DeleteThing operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws VersionConflictException
     *         An exception thrown when the version of an entity specified with the <code>expectedVersion</code>
     *         parameter does not match the latest version in the system.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteThing
     */
    default DeleteThingResponse deleteThing(DeleteThingRequest deleteThingRequest) throws ResourceNotFoundException,
            VersionConflictException, InvalidRequestException, ThrottlingException, UnauthorizedException,
            ServiceUnavailableException, InternalFailureException, AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified thing. Returns successfully with no error if the deletion is successful or you specify a
     * thing that doesn't exist.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteThing</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteThingRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteThingRequest#builder()}
     * </p>
     *
     * @param deleteThingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.DeleteThingRequest.Builder} to create a request. The
     *        input for the DeleteThing operation.
     * @return Result of the DeleteThing operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws VersionConflictException
     *         An exception thrown when the version of an entity specified with the <code>expectedVersion</code>
     *         parameter does not match the latest version in the system.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteThing
     */
    default DeleteThingResponse deleteThing(Consumer<DeleteThingRequest.Builder> deleteThingRequest)
            throws ResourceNotFoundException, VersionConflictException, InvalidRequestException, ThrottlingException,
            UnauthorizedException, ServiceUnavailableException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        return deleteThing(DeleteThingRequest.builder().applyMutation(deleteThingRequest).build());
    }

    /**
     * <p>
     * Deletes a thing group.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteThingGroup</a> action.
     * </p>
     *
     * @param deleteThingGroupRequest
     * @return Result of the DeleteThingGroup operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws VersionConflictException
     *         An exception thrown when the version of an entity specified with the <code>expectedVersion</code>
     *         parameter does not match the latest version in the system.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteThingGroup
     */
    default DeleteThingGroupResponse deleteThingGroup(DeleteThingGroupRequest deleteThingGroupRequest)
            throws InvalidRequestException, VersionConflictException, ThrottlingException, InternalFailureException,
            AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a thing group.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteThingGroup</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteThingGroupRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteThingGroupRequest#builder()}
     * </p>
     *
     * @param deleteThingGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.DeleteThingGroupRequest.Builder} to create a request.
     * @return Result of the DeleteThingGroup operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws VersionConflictException
     *         An exception thrown when the version of an entity specified with the <code>expectedVersion</code>
     *         parameter does not match the latest version in the system.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteThingGroup
     */
    default DeleteThingGroupResponse deleteThingGroup(Consumer<DeleteThingGroupRequest.Builder> deleteThingGroupRequest)
            throws InvalidRequestException, VersionConflictException, ThrottlingException, InternalFailureException,
            AwsServiceException, SdkClientException, IotException {
        return deleteThingGroup(DeleteThingGroupRequest.builder().applyMutation(deleteThingGroupRequest).build());
    }

    /**
     * <p>
     * Deletes the specified thing type. You cannot delete a thing type if it has things associated with it. To delete a
     * thing type, first mark it as deprecated by calling <a>DeprecateThingType</a>, then remove any associated things
     * by calling <a>UpdateThing</a> to change the thing type on any associated thing, and finally use
     * <a>DeleteThingType</a> to delete the thing type.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteThingType</a> action.
     * </p>
     *
     * @param deleteThingTypeRequest
     *        The input for the DeleteThingType operation.
     * @return Result of the DeleteThingType operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteThingType
     */
    default DeleteThingTypeResponse deleteThingType(DeleteThingTypeRequest deleteThingTypeRequest)
            throws ResourceNotFoundException, InvalidRequestException, ThrottlingException, UnauthorizedException,
            ServiceUnavailableException, InternalFailureException, AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified thing type. You cannot delete a thing type if it has things associated with it. To delete a
     * thing type, first mark it as deprecated by calling <a>DeprecateThingType</a>, then remove any associated things
     * by calling <a>UpdateThing</a> to change the thing type on any associated thing, and finally use
     * <a>DeleteThingType</a> to delete the thing type.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteThingType</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteThingTypeRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteThingTypeRequest#builder()}
     * </p>
     *
     * @param deleteThingTypeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.DeleteThingTypeRequest.Builder} to create a request. The
     *        input for the DeleteThingType operation.
     * @return Result of the DeleteThingType operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteThingType
     */
    default DeleteThingTypeResponse deleteThingType(Consumer<DeleteThingTypeRequest.Builder> deleteThingTypeRequest)
            throws ResourceNotFoundException, InvalidRequestException, ThrottlingException, UnauthorizedException,
            ServiceUnavailableException, InternalFailureException, AwsServiceException, SdkClientException, IotException {
        return deleteThingType(DeleteThingTypeRequest.builder().applyMutation(deleteThingTypeRequest).build());
    }

    /**
     * <p>
     * Deletes the rule.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteTopicRule</a> action.
     * </p>
     *
     * @param deleteTopicRuleRequest
     *        The input for the DeleteTopicRule operation.
     * @return Result of the DeleteTopicRule operation returned by the service.
     * @throws InternalException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ConflictingResourceUpdateException
     *         A conflicting resource update exception. This exception is thrown when two pending updates cause a
     *         conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteTopicRule
     */
    default DeleteTopicRuleResponse deleteTopicRule(DeleteTopicRuleRequest deleteTopicRuleRequest) throws InternalException,
            InvalidRequestException, ServiceUnavailableException, UnauthorizedException, ConflictingResourceUpdateException,
            AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the rule.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteTopicRule</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTopicRuleRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteTopicRuleRequest#builder()}
     * </p>
     *
     * @param deleteTopicRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.DeleteTopicRuleRequest.Builder} to create a request. The
     *        input for the DeleteTopicRule operation.
     * @return Result of the DeleteTopicRule operation returned by the service.
     * @throws InternalException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ConflictingResourceUpdateException
     *         A conflicting resource update exception. This exception is thrown when two pending updates cause a
     *         conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteTopicRule
     */
    default DeleteTopicRuleResponse deleteTopicRule(Consumer<DeleteTopicRuleRequest.Builder> deleteTopicRuleRequest)
            throws InternalException, InvalidRequestException, ServiceUnavailableException, UnauthorizedException,
            ConflictingResourceUpdateException, AwsServiceException, SdkClientException, IotException {
        return deleteTopicRule(DeleteTopicRuleRequest.builder().applyMutation(deleteTopicRuleRequest).build());
    }

    /**
     * <p>
     * Deletes a topic rule destination.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteTopicRuleDestination</a> action.
     * </p>
     *
     * @param deleteTopicRuleDestinationRequest
     * @return Result of the DeleteTopicRuleDestination operation returned by the service.
     * @throws InternalException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ConflictingResourceUpdateException
     *         A conflicting resource update exception. This exception is thrown when two pending updates cause a
     *         conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteTopicRuleDestination
     */
    default DeleteTopicRuleDestinationResponse deleteTopicRuleDestination(
            DeleteTopicRuleDestinationRequest deleteTopicRuleDestinationRequest) throws InternalException,
            InvalidRequestException, ServiceUnavailableException, UnauthorizedException, ConflictingResourceUpdateException,
            AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a topic rule destination.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteTopicRuleDestination</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTopicRuleDestinationRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteTopicRuleDestinationRequest#builder()}
     * </p>
     *
     * @param deleteTopicRuleDestinationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.DeleteTopicRuleDestinationRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteTopicRuleDestination operation returned by the service.
     * @throws InternalException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ConflictingResourceUpdateException
     *         A conflicting resource update exception. This exception is thrown when two pending updates cause a
     *         conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteTopicRuleDestination
     */
    default DeleteTopicRuleDestinationResponse deleteTopicRuleDestination(
            Consumer<DeleteTopicRuleDestinationRequest.Builder> deleteTopicRuleDestinationRequest) throws InternalException,
            InvalidRequestException, ServiceUnavailableException, UnauthorizedException, ConflictingResourceUpdateException,
            AwsServiceException, SdkClientException, IotException {
        return deleteTopicRuleDestination(DeleteTopicRuleDestinationRequest.builder()
                .applyMutation(deleteTopicRuleDestinationRequest).build());
    }

    /**
     * <p>
     * Deletes a logging level.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteV2LoggingLevel</a> action.
     * </p>
     *
     * @param deleteV2LoggingLevelRequest
     * @return Result of the DeleteV2LoggingLevel operation returned by the service.
     * @throws InternalException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteV2LoggingLevel
     */
    default DeleteV2LoggingLevelResponse deleteV2LoggingLevel(DeleteV2LoggingLevelRequest deleteV2LoggingLevelRequest)
            throws InternalException, InvalidRequestException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a logging level.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeleteV2LoggingLevel</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteV2LoggingLevelRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteV2LoggingLevelRequest#builder()}
     * </p>
     *
     * @param deleteV2LoggingLevelRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.DeleteV2LoggingLevelRequest.Builder} to create a request.
     * @return Result of the DeleteV2LoggingLevel operation returned by the service.
     * @throws InternalException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeleteV2LoggingLevel
     */
    default DeleteV2LoggingLevelResponse deleteV2LoggingLevel(
            Consumer<DeleteV2LoggingLevelRequest.Builder> deleteV2LoggingLevelRequest) throws InternalException,
            InvalidRequestException, ServiceUnavailableException, AwsServiceException, SdkClientException, IotException {
        return deleteV2LoggingLevel(DeleteV2LoggingLevelRequest.builder().applyMutation(deleteV2LoggingLevelRequest).build());
    }

    /**
     * <p>
     * Deprecates a thing type. You can not associate new things with deprecated thing type.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeprecateThingType</a> action.
     * </p>
     *
     * @param deprecateThingTypeRequest
     *        The input for the DeprecateThingType operation.
     * @return Result of the DeprecateThingType operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeprecateThingType
     */
    default DeprecateThingTypeResponse deprecateThingType(DeprecateThingTypeRequest deprecateThingTypeRequest)
            throws ResourceNotFoundException, InvalidRequestException, ThrottlingException, UnauthorizedException,
            ServiceUnavailableException, InternalFailureException, AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deprecates a thing type. You can not associate new things with deprecated thing type.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DeprecateThingType</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeprecateThingTypeRequest.Builder} avoiding the
     * need to create one manually via {@link DeprecateThingTypeRequest#builder()}
     * </p>
     *
     * @param deprecateThingTypeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.DeprecateThingTypeRequest.Builder} to create a request.
     *        The input for the DeprecateThingType operation.
     * @return Result of the DeprecateThingType operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DeprecateThingType
     */
    default DeprecateThingTypeResponse deprecateThingType(Consumer<DeprecateThingTypeRequest.Builder> deprecateThingTypeRequest)
            throws ResourceNotFoundException, InvalidRequestException, ThrottlingException, UnauthorizedException,
            ServiceUnavailableException, InternalFailureException, AwsServiceException, SdkClientException, IotException {
        return deprecateThingType(DeprecateThingTypeRequest.builder().applyMutation(deprecateThingTypeRequest).build());
    }

    /**
     * <p>
     * Gets information about the Device Defender audit settings for this account. Settings include how audit
     * notifications are sent and which audit checks are enabled or disabled.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeAccountAuditConfiguration</a> action.
     * </p>
     *
     * @param describeAccountAuditConfigurationRequest
     * @return Result of the DescribeAccountAuditConfiguration operation returned by the service.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeAccountAuditConfiguration
     */
    default DescribeAccountAuditConfigurationResponse describeAccountAuditConfiguration(
            DescribeAccountAuditConfigurationRequest describeAccountAuditConfigurationRequest) throws ThrottlingException,
            InternalFailureException, AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the Device Defender audit settings for this account. Settings include how audit
     * notifications are sent and which audit checks are enabled or disabled.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeAccountAuditConfiguration</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAccountAuditConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeAccountAuditConfigurationRequest#builder()}
     * </p>
     *
     * @param describeAccountAuditConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.DescribeAccountAuditConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeAccountAuditConfiguration operation returned by the service.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeAccountAuditConfiguration
     */
    default DescribeAccountAuditConfigurationResponse describeAccountAuditConfiguration(
            Consumer<DescribeAccountAuditConfigurationRequest.Builder> describeAccountAuditConfigurationRequest)
            throws ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException, IotException {
        return describeAccountAuditConfiguration(DescribeAccountAuditConfigurationRequest.builder()
                .applyMutation(describeAccountAuditConfigurationRequest).build());
    }

    /**
     * <p>
     * Gets information about the Device Defender audit settings for this account. Settings include how audit
     * notifications are sent and which audit checks are enabled or disabled.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeAccountAuditConfiguration</a> action.
     * </p>
     *
     * @return Result of the DescribeAccountAuditConfiguration operation returned by the service.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeAccountAuditConfiguration
     * @see #describeAccountAuditConfiguration(DescribeAccountAuditConfigurationRequest)
     */
    default DescribeAccountAuditConfigurationResponse describeAccountAuditConfiguration() throws ThrottlingException,
            InternalFailureException, AwsServiceException, SdkClientException, IotException {
        return describeAccountAuditConfiguration(DescribeAccountAuditConfigurationRequest.builder().build());
    }

    /**
     * <p>
     * Gets information about a single audit finding. Properties include the reason for noncompliance, the severity of
     * the issue, and the start time when the audit that returned the finding.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeAuditFinding</a> action.
     * </p>
     *
     * @param describeAuditFindingRequest
     * @return Result of the DescribeAuditFinding operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeAuditFinding
     */
    default DescribeAuditFindingResponse describeAuditFinding(DescribeAuditFindingRequest describeAuditFindingRequest)
            throws ResourceNotFoundException, InvalidRequestException, ThrottlingException, InternalFailureException,
            AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a single audit finding. Properties include the reason for noncompliance, the severity of
     * the issue, and the start time when the audit that returned the finding.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeAuditFinding</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAuditFindingRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeAuditFindingRequest#builder()}
     * </p>
     *
     * @param describeAuditFindingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.DescribeAuditFindingRequest.Builder} to create a request.
     * @return Result of the DescribeAuditFinding operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeAuditFinding
     */
    default DescribeAuditFindingResponse describeAuditFinding(
            Consumer<DescribeAuditFindingRequest.Builder> describeAuditFindingRequest) throws ResourceNotFoundException,
            InvalidRequestException, ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException,
            IotException {
        return describeAuditFinding(DescribeAuditFindingRequest.builder().applyMutation(describeAuditFindingRequest).build());
    }

    /**
     * <p>
     * Gets information about an audit mitigation task that is used to apply mitigation actions to a set of audit
     * findings. Properties include the actions being applied, the audit checks to which they're being applied, the task
     * status, and aggregated task statistics.
     * </p>
     *
     * @param describeAuditMitigationActionsTaskRequest
     * @return Result of the DescribeAuditMitigationActionsTask operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeAuditMitigationActionsTask
     */
    default DescribeAuditMitigationActionsTaskResponse describeAuditMitigationActionsTask(
            DescribeAuditMitigationActionsTaskRequest describeAuditMitigationActionsTaskRequest) throws InvalidRequestException,
            ResourceNotFoundException, ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException,
            IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about an audit mitigation task that is used to apply mitigation actions to a set of audit
     * findings. Properties include the actions being applied, the audit checks to which they're being applied, the task
     * status, and aggregated task statistics.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAuditMitigationActionsTaskRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeAuditMitigationActionsTaskRequest#builder()}
     * </p>
     *
     * @param describeAuditMitigationActionsTaskRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.DescribeAuditMitigationActionsTaskRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeAuditMitigationActionsTask operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeAuditMitigationActionsTask
     */
    default DescribeAuditMitigationActionsTaskResponse describeAuditMitigationActionsTask(
            Consumer<DescribeAuditMitigationActionsTaskRequest.Builder> describeAuditMitigationActionsTaskRequest)
            throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, InternalFailureException,
            AwsServiceException, SdkClientException, IotException {
        return describeAuditMitigationActionsTask(DescribeAuditMitigationActionsTaskRequest.builder()
                .applyMutation(describeAuditMitigationActionsTaskRequest).build());
    }

    /**
     * <p>
     * Gets information about a Device Defender audit suppression.
     * </p>
     *
     * @param describeAuditSuppressionRequest
     * @return Result of the DescribeAuditSuppression operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeAuditSuppression
     */
    default DescribeAuditSuppressionResponse describeAuditSuppression(
            DescribeAuditSuppressionRequest describeAuditSuppressionRequest) throws InvalidRequestException,
            ResourceNotFoundException, ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException,
            IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a Device Defender audit suppression.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAuditSuppressionRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeAuditSuppressionRequest#builder()}
     * </p>
     *
     * @param describeAuditSuppressionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.DescribeAuditSuppressionRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeAuditSuppression operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeAuditSuppression
     */
    default DescribeAuditSuppressionResponse describeAuditSuppression(
            Consumer<DescribeAuditSuppressionRequest.Builder> describeAuditSuppressionRequest) throws InvalidRequestException,
            ResourceNotFoundException, ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException,
            IotException {
        return describeAuditSuppression(DescribeAuditSuppressionRequest.builder().applyMutation(describeAuditSuppressionRequest)
                .build());
    }

    /**
     * <p>
     * Gets information about a Device Defender audit.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeAuditTask</a> action.
     * </p>
     *
     * @param describeAuditTaskRequest
     * @return Result of the DescribeAuditTask operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeAuditTask
     */
    default DescribeAuditTaskResponse describeAuditTask(DescribeAuditTaskRequest describeAuditTaskRequest)
            throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, InternalFailureException,
            AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a Device Defender audit.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeAuditTask</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAuditTaskRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeAuditTaskRequest#builder()}
     * </p>
     *
     * @param describeAuditTaskRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.DescribeAuditTaskRequest.Builder} to create a request.
     * @return Result of the DescribeAuditTask operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeAuditTask
     */
    default DescribeAuditTaskResponse describeAuditTask(Consumer<DescribeAuditTaskRequest.Builder> describeAuditTaskRequest)
            throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, InternalFailureException,
            AwsServiceException, SdkClientException, IotException {
        return describeAuditTask(DescribeAuditTaskRequest.builder().applyMutation(describeAuditTaskRequest).build());
    }

    /**
     * <p>
     * Describes an authorizer.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeAuthorizer</a> action.
     * </p>
     *
     * @param describeAuthorizerRequest
     * @return Result of the DescribeAuthorizer operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeAuthorizer
     */
    default DescribeAuthorizerResponse describeAuthorizer(DescribeAuthorizerRequest describeAuthorizerRequest)
            throws ResourceNotFoundException, InvalidRequestException, ThrottlingException, UnauthorizedException,
            ServiceUnavailableException, InternalFailureException, AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes an authorizer.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeAuthorizer</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAuthorizerRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeAuthorizerRequest#builder()}
     * </p>
     *
     * @param describeAuthorizerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.DescribeAuthorizerRequest.Builder} to create a request.
     * @return Result of the DescribeAuthorizer operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeAuthorizer
     */
    default DescribeAuthorizerResponse describeAuthorizer(Consumer<DescribeAuthorizerRequest.Builder> describeAuthorizerRequest)
            throws ResourceNotFoundException, InvalidRequestException, ThrottlingException, UnauthorizedException,
            ServiceUnavailableException, InternalFailureException, AwsServiceException, SdkClientException, IotException {
        return describeAuthorizer(DescribeAuthorizerRequest.builder().applyMutation(describeAuthorizerRequest).build());
    }

    /**
     * <p>
     * Returns information about a billing group.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeBillingGroup</a> action.
     * </p>
     *
     * @param describeBillingGroupRequest
     * @return Result of the DescribeBillingGroup operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeBillingGroup
     */
    default DescribeBillingGroupResponse describeBillingGroup(DescribeBillingGroupRequest describeBillingGroupRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a billing group.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeBillingGroup</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeBillingGroupRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeBillingGroupRequest#builder()}
     * </p>
     *
     * @param describeBillingGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.DescribeBillingGroupRequest.Builder} to create a request.
     * @return Result of the DescribeBillingGroup operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeBillingGroup
     */
    default DescribeBillingGroupResponse describeBillingGroup(
            Consumer<DescribeBillingGroupRequest.Builder> describeBillingGroupRequest) throws InvalidRequestException,
            ThrottlingException, InternalFailureException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            IotException {
        return describeBillingGroup(DescribeBillingGroupRequest.builder().applyMutation(describeBillingGroupRequest).build());
    }

    /**
     * <p>
     * Describes a registered CA certificate.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeCACertificate</a> action.
     * </p>
     *
     * @param describeCaCertificateRequest
     *        The input for the DescribeCACertificate operation.
     * @return Result of the DescribeCACertificate operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeCACertificate
     */
    default DescribeCaCertificateResponse describeCACertificate(DescribeCaCertificateRequest describeCaCertificateRequest)
            throws InvalidRequestException, ThrottlingException, UnauthorizedException, ServiceUnavailableException,
            InternalFailureException, ResourceNotFoundException, AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a registered CA certificate.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeCACertificate</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeCaCertificateRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeCaCertificateRequest#builder()}
     * </p>
     *
     * @param describeCaCertificateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.DescribeCaCertificateRequest.Builder} to create a
     *        request. The input for the DescribeCACertificate operation.
     * @return Result of the DescribeCACertificate operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeCACertificate
     */
    default DescribeCaCertificateResponse describeCACertificate(
            Consumer<DescribeCaCertificateRequest.Builder> describeCaCertificateRequest) throws InvalidRequestException,
            ThrottlingException, UnauthorizedException, ServiceUnavailableException, InternalFailureException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, IotException {
        return describeCACertificate(DescribeCaCertificateRequest.builder().applyMutation(describeCaCertificateRequest).build());
    }

    /**
     * <p>
     * Gets information about the specified certificate.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeCertificate</a> action.
     * </p>
     *
     * @param describeCertificateRequest
     *        The input for the DescribeCertificate operation.
     * @return Result of the DescribeCertificate operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeCertificate
     */
    default DescribeCertificateResponse describeCertificate(DescribeCertificateRequest describeCertificateRequest)
            throws InvalidRequestException, ThrottlingException, UnauthorizedException, ServiceUnavailableException,
            InternalFailureException, ResourceNotFoundException, AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the specified certificate.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeCertificate</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeCertificateRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeCertificateRequest#builder()}
     * </p>
     *
     * @param describeCertificateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.DescribeCertificateRequest.Builder} to create a request.
     *        The input for the DescribeCertificate operation.
     * @return Result of the DescribeCertificate operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeCertificate
     */
    default DescribeCertificateResponse describeCertificate(
            Consumer<DescribeCertificateRequest.Builder> describeCertificateRequest) throws InvalidRequestException,
            ThrottlingException, UnauthorizedException, ServiceUnavailableException, InternalFailureException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, IotException {
        return describeCertificate(DescribeCertificateRequest.builder().applyMutation(describeCertificateRequest).build());
    }

    /**
     * <p>
     * Describes a certificate provider.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeCertificateProvider</a> action.
     * </p>
     *
     * @param describeCertificateProviderRequest
     * @return Result of the DescribeCertificateProvider operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeCertificateProvider
     */
    default DescribeCertificateProviderResponse describeCertificateProvider(
            DescribeCertificateProviderRequest describeCertificateProviderRequest) throws ResourceNotFoundException,
            InvalidRequestException, ThrottlingException, UnauthorizedException, ServiceUnavailableException,
            InternalFailureException, AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a certificate provider.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeCertificateProvider</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeCertificateProviderRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeCertificateProviderRequest#builder()}
     * </p>
     *
     * @param describeCertificateProviderRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.DescribeCertificateProviderRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeCertificateProvider operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeCertificateProvider
     */
    default DescribeCertificateProviderResponse describeCertificateProvider(
            Consumer<DescribeCertificateProviderRequest.Builder> describeCertificateProviderRequest)
            throws ResourceNotFoundException, InvalidRequestException, ThrottlingException, UnauthorizedException,
            ServiceUnavailableException, InternalFailureException, AwsServiceException, SdkClientException, IotException {
        return describeCertificateProvider(DescribeCertificateProviderRequest.builder()
                .applyMutation(describeCertificateProviderRequest).build());
    }

    /**
     * <p>
     * Gets information about a Device Defender detect custom metric.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeCustomMetric</a> action.
     * </p>
     *
     * @param describeCustomMetricRequest
     * @return Result of the DescribeCustomMetric operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeCustomMetric
     */
    default DescribeCustomMetricResponse describeCustomMetric(DescribeCustomMetricRequest describeCustomMetricRequest)
            throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, InternalFailureException,
            AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a Device Defender detect custom metric.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeCustomMetric</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeCustomMetricRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeCustomMetricRequest#builder()}
     * </p>
     *
     * @param describeCustomMetricRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.DescribeCustomMetricRequest.Builder} to create a request.
     * @return Result of the DescribeCustomMetric operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeCustomMetric
     */
    default DescribeCustomMetricResponse describeCustomMetric(
            Consumer<DescribeCustomMetricRequest.Builder> describeCustomMetricRequest) throws InvalidRequestException,
            ResourceNotFoundException, ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException,
            IotException {
        return describeCustomMetric(DescribeCustomMetricRequest.builder().applyMutation(describeCustomMetricRequest).build());
    }

    /**
     * <p>
     * Describes the default authorizer.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeDefaultAuthorizer</a> action.
     * </p>
     *
     * @param describeDefaultAuthorizerRequest
     * @return Result of the DescribeDefaultAuthorizer operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeDefaultAuthorizer
     */
    default DescribeDefaultAuthorizerResponse describeDefaultAuthorizer(
            DescribeDefaultAuthorizerRequest describeDefaultAuthorizerRequest) throws ResourceNotFoundException,
            InvalidRequestException, ThrottlingException, UnauthorizedException, ServiceUnavailableException,
            InternalFailureException, AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the default authorizer.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeDefaultAuthorizer</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDefaultAuthorizerRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeDefaultAuthorizerRequest#builder()}
     * </p>
     *
     * @param describeDefaultAuthorizerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.DescribeDefaultAuthorizerRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeDefaultAuthorizer operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeDefaultAuthorizer
     */
    default DescribeDefaultAuthorizerResponse describeDefaultAuthorizer(
            Consumer<DescribeDefaultAuthorizerRequest.Builder> describeDefaultAuthorizerRequest)
            throws ResourceNotFoundException, InvalidRequestException, ThrottlingException, UnauthorizedException,
            ServiceUnavailableException, InternalFailureException, AwsServiceException, SdkClientException, IotException {
        return describeDefaultAuthorizer(DescribeDefaultAuthorizerRequest.builder()
                .applyMutation(describeDefaultAuthorizerRequest).build());
    }

    /**
     * <p>
     * Gets information about a Device Defender ML Detect mitigation action.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeDetectMitigationActionsTask</a> action.
     * </p>
     *
     * @param describeDetectMitigationActionsTaskRequest
     * @return Result of the DescribeDetectMitigationActionsTask operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeDetectMitigationActionsTask
     */
    default DescribeDetectMitigationActionsTaskResponse describeDetectMitigationActionsTask(
            DescribeDetectMitigationActionsTaskRequest describeDetectMitigationActionsTaskRequest)
            throws ResourceNotFoundException, InvalidRequestException, ThrottlingException, InternalFailureException,
            AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a Device Defender ML Detect mitigation action.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeDetectMitigationActionsTask</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDetectMitigationActionsTaskRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeDetectMitigationActionsTaskRequest#builder()}
     * </p>
     *
     * @param describeDetectMitigationActionsTaskRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.DescribeDetectMitigationActionsTaskRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeDetectMitigationActionsTask operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeDetectMitigationActionsTask
     */
    default DescribeDetectMitigationActionsTaskResponse describeDetectMitigationActionsTask(
            Consumer<DescribeDetectMitigationActionsTaskRequest.Builder> describeDetectMitigationActionsTaskRequest)
            throws ResourceNotFoundException, InvalidRequestException, ThrottlingException, InternalFailureException,
            AwsServiceException, SdkClientException, IotException {
        return describeDetectMitigationActionsTask(DescribeDetectMitigationActionsTaskRequest.builder()
                .applyMutation(describeDetectMitigationActionsTaskRequest).build());
    }

    /**
     * <p>
     * Provides details about a dimension that is defined in your Amazon Web Services accounts.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeDimension</a> action.
     * </p>
     *
     * @param describeDimensionRequest
     * @return Result of the DescribeDimension operation returned by the service.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeDimension
     */
    default DescribeDimensionResponse describeDimension(DescribeDimensionRequest describeDimensionRequest)
            throws InternalFailureException, InvalidRequestException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides details about a dimension that is defined in your Amazon Web Services accounts.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeDimension</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDimensionRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeDimensionRequest#builder()}
     * </p>
     *
     * @param describeDimensionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.DescribeDimensionRequest.Builder} to create a request.
     * @return Result of the DescribeDimension operation returned by the service.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeDimension
     */
    default DescribeDimensionResponse describeDimension(Consumer<DescribeDimensionRequest.Builder> describeDimensionRequest)
            throws InternalFailureException, InvalidRequestException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, IotException {
        return describeDimension(DescribeDimensionRequest.builder().applyMutation(describeDimensionRequest).build());
    }

    /**
     * <p>
     * Gets summary information about a domain configuration.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeDomainConfiguration</a> action.
     * </p>
     *
     * @param describeDomainConfigurationRequest
     * @return Result of the DescribeDomainConfiguration operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeDomainConfiguration
     */
    default DescribeDomainConfigurationResponse describeDomainConfiguration(
            DescribeDomainConfigurationRequest describeDomainConfigurationRequest) throws ResourceNotFoundException,
            ThrottlingException, InvalidRequestException, UnauthorizedException, ServiceUnavailableException,
            InternalFailureException, AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets summary information about a domain configuration.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeDomainConfiguration</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDomainConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeDomainConfigurationRequest#builder()}
     * </p>
     *
     * @param describeDomainConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.DescribeDomainConfigurationRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeDomainConfiguration operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeDomainConfiguration
     */
    default DescribeDomainConfigurationResponse describeDomainConfiguration(
            Consumer<DescribeDomainConfigurationRequest.Builder> describeDomainConfigurationRequest)
            throws ResourceNotFoundException, ThrottlingException, InvalidRequestException, UnauthorizedException,
            ServiceUnavailableException, InternalFailureException, AwsServiceException, SdkClientException, IotException {
        return describeDomainConfiguration(DescribeDomainConfigurationRequest.builder()
                .applyMutation(describeDomainConfigurationRequest).build());
    }

    /**
     * <p>
     * Returns a unique endpoint specific to the Amazon Web Services account making the call.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeEndpoint</a> action.
     * </p>
     *
     * @param describeEndpointRequest
     *        The input for the DescribeEndpoint operation.
     * @return Result of the DescribeEndpoint operation returned by the service.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeEndpoint
     */
    default DescribeEndpointResponse describeEndpoint(DescribeEndpointRequest describeEndpointRequest)
            throws InternalFailureException, InvalidRequestException, UnauthorizedException, ThrottlingException,
            AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a unique endpoint specific to the Amazon Web Services account making the call.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeEndpoint</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEndpointRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeEndpointRequest#builder()}
     * </p>
     *
     * @param describeEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.DescribeEndpointRequest.Builder} to create a request. The
     *        input for the DescribeEndpoint operation.
     * @return Result of the DescribeEndpoint operation returned by the service.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeEndpoint
     */
    default DescribeEndpointResponse describeEndpoint(Consumer<DescribeEndpointRequest.Builder> describeEndpointRequest)
            throws InternalFailureException, InvalidRequestException, UnauthorizedException, ThrottlingException,
            AwsServiceException, SdkClientException, IotException {
        return describeEndpoint(DescribeEndpointRequest.builder().applyMutation(describeEndpointRequest).build());
    }

    /**
     * <p>
     * Returns a unique endpoint specific to the Amazon Web Services account making the call.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeEndpoint</a> action.
     * </p>
     *
     * @return Result of the DescribeEndpoint operation returned by the service.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeEndpoint
     * @see #describeEndpoint(DescribeEndpointRequest)
     */
    default DescribeEndpointResponse describeEndpoint() throws InternalFailureException, InvalidRequestException,
            UnauthorizedException, ThrottlingException, AwsServiceException, SdkClientException, IotException {
        return describeEndpoint(DescribeEndpointRequest.builder().build());
    }

    /**
     * <p>
     * Describes event configurations.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeEventConfigurations</a> action.
     * </p>
     *
     * @param describeEventConfigurationsRequest
     * @return Result of the DescribeEventConfigurations operation returned by the service.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeEventConfigurations
     */
    default DescribeEventConfigurationsResponse describeEventConfigurations(
            DescribeEventConfigurationsRequest describeEventConfigurationsRequest) throws InternalFailureException,
            ThrottlingException, AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes event configurations.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeEventConfigurations</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEventConfigurationsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeEventConfigurationsRequest#builder()}
     * </p>
     *
     * @param describeEventConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.DescribeEventConfigurationsRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeEventConfigurations operation returned by the service.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeEventConfigurations
     */
    default DescribeEventConfigurationsResponse describeEventConfigurations(
            Consumer<DescribeEventConfigurationsRequest.Builder> describeEventConfigurationsRequest)
            throws InternalFailureException, ThrottlingException, AwsServiceException, SdkClientException, IotException {
        return describeEventConfigurations(DescribeEventConfigurationsRequest.builder()
                .applyMutation(describeEventConfigurationsRequest).build());
    }

    /**
     * <p>
     * Describes event configurations.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeEventConfigurations</a> action.
     * </p>
     *
     * @return Result of the DescribeEventConfigurations operation returned by the service.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeEventConfigurations
     * @see #describeEventConfigurations(DescribeEventConfigurationsRequest)
     */
    default DescribeEventConfigurationsResponse describeEventConfigurations() throws InternalFailureException,
            ThrottlingException, AwsServiceException, SdkClientException, IotException {
        return describeEventConfigurations(DescribeEventConfigurationsRequest.builder().build());
    }

    /**
     * <p>
     * Gets information about the specified fleet metric.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeFleetMetric</a> action.
     * </p>
     *
     * @param describeFleetMetricRequest
     * @return Result of the DescribeFleetMetric operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeFleetMetric
     */
    default DescribeFleetMetricResponse describeFleetMetric(DescribeFleetMetricRequest describeFleetMetricRequest)
            throws InvalidRequestException, ThrottlingException, UnauthorizedException, ServiceUnavailableException,
            InternalFailureException, ResourceNotFoundException, AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the specified fleet metric.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeFleetMetric</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFleetMetricRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeFleetMetricRequest#builder()}
     * </p>
     *
     * @param describeFleetMetricRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.DescribeFleetMetricRequest.Builder} to create a request.
     * @return Result of the DescribeFleetMetric operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeFleetMetric
     */
    default DescribeFleetMetricResponse describeFleetMetric(
            Consumer<DescribeFleetMetricRequest.Builder> describeFleetMetricRequest) throws InvalidRequestException,
            ThrottlingException, UnauthorizedException, ServiceUnavailableException, InternalFailureException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, IotException {
        return describeFleetMetric(DescribeFleetMetricRequest.builder().applyMutation(describeFleetMetricRequest).build());
    }

    /**
     * <p>
     * Describes a search index.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeIndex</a> action.
     * </p>
     *
     * @param describeIndexRequest
     * @return Result of the DescribeIndex operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeIndex
     */
    default DescribeIndexResponse describeIndex(DescribeIndexRequest describeIndexRequest) throws InvalidRequestException,
            ThrottlingException, UnauthorizedException, ServiceUnavailableException, InternalFailureException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a search index.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeIndex</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeIndexRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeIndexRequest#builder()}
     * </p>
     *
     * @param describeIndexRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.DescribeIndexRequest.Builder} to create a request.
     * @return Result of the DescribeIndex operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeIndex
     */
    default DescribeIndexResponse describeIndex(Consumer<DescribeIndexRequest.Builder> describeIndexRequest)
            throws InvalidRequestException, ThrottlingException, UnauthorizedException, ServiceUnavailableException,
            InternalFailureException, ResourceNotFoundException, AwsServiceException, SdkClientException, IotException {
        return describeIndex(DescribeIndexRequest.builder().applyMutation(describeIndexRequest).build());
    }

    /**
     * <p>
     * Describes a job.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeJob</a> action.
     * </p>
     *
     * @param describeJobRequest
     * @return Result of the DescribeJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeJob
     */
    default DescribeJobResponse describeJob(DescribeJobRequest describeJobRequest) throws InvalidRequestException,
            ResourceNotFoundException, ThrottlingException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a job.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeJob</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeJobRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeJobRequest#builder()}
     * </p>
     *
     * @param describeJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.DescribeJobRequest.Builder} to create a request.
     * @return Result of the DescribeJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeJob
     */
    default DescribeJobResponse describeJob(Consumer<DescribeJobRequest.Builder> describeJobRequest)
            throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, IotException {
        return describeJob(DescribeJobRequest.builder().applyMutation(describeJobRequest).build());
    }

    /**
     * <p>
     * Describes a job execution.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeJobExecution</a> action.
     * </p>
     *
     * @param describeJobExecutionRequest
     * @return Result of the DescribeJobExecution operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeJobExecution
     */
    default DescribeJobExecutionResponse describeJobExecution(DescribeJobExecutionRequest describeJobExecutionRequest)
            throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a job execution.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeJobExecution</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeJobExecutionRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeJobExecutionRequest#builder()}
     * </p>
     *
     * @param describeJobExecutionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.DescribeJobExecutionRequest.Builder} to create a request.
     * @return Result of the DescribeJobExecution operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeJobExecution
     */
    default DescribeJobExecutionResponse describeJobExecution(
            Consumer<DescribeJobExecutionRequest.Builder> describeJobExecutionRequest) throws InvalidRequestException,
            ResourceNotFoundException, ThrottlingException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            IotException {
        return describeJobExecution(DescribeJobExecutionRequest.builder().applyMutation(describeJobExecutionRequest).build());
    }

    /**
     * <p>
     * Returns information about a job template.
     * </p>
     *
     * @param describeJobTemplateRequest
     * @return Result of the DescribeJobTemplate operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeJobTemplate
     */
    default DescribeJobTemplateResponse describeJobTemplate(DescribeJobTemplateRequest describeJobTemplateRequest)
            throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, InternalFailureException,
            AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a job template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeJobTemplateRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeJobTemplateRequest#builder()}
     * </p>
     *
     * @param describeJobTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.DescribeJobTemplateRequest.Builder} to create a request.
     * @return Result of the DescribeJobTemplate operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeJobTemplate
     */
    default DescribeJobTemplateResponse describeJobTemplate(
            Consumer<DescribeJobTemplateRequest.Builder> describeJobTemplateRequest) throws InvalidRequestException,
            ResourceNotFoundException, ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException,
            IotException {
        return describeJobTemplate(DescribeJobTemplateRequest.builder().applyMutation(describeJobTemplateRequest).build());
    }

    /**
     * <p>
     * View details of a managed job template.
     * </p>
     *
     * @param describeManagedJobTemplateRequest
     * @return Result of the DescribeManagedJobTemplate operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeManagedJobTemplate
     */
    default DescribeManagedJobTemplateResponse describeManagedJobTemplate(
            DescribeManagedJobTemplateRequest describeManagedJobTemplateRequest) throws InvalidRequestException,
            ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * View details of a managed job template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeManagedJobTemplateRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeManagedJobTemplateRequest#builder()}
     * </p>
     *
     * @param describeManagedJobTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.DescribeManagedJobTemplateRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeManagedJobTemplate operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeManagedJobTemplate
     */
    default DescribeManagedJobTemplateResponse describeManagedJobTemplate(
            Consumer<DescribeManagedJobTemplateRequest.Builder> describeManagedJobTemplateRequest)
            throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, IotException {
        return describeManagedJobTemplate(DescribeManagedJobTemplateRequest.builder()
                .applyMutation(describeManagedJobTemplateRequest).build());
    }

    /**
     * <p>
     * Gets information about a mitigation action.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeMitigationAction</a> action.
     * </p>
     *
     * @param describeMitigationActionRequest
     * @return Result of the DescribeMitigationAction operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeMitigationAction
     */
    default DescribeMitigationActionResponse describeMitigationAction(
            DescribeMitigationActionRequest describeMitigationActionRequest) throws InvalidRequestException,
            ResourceNotFoundException, ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException,
            IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a mitigation action.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeMitigationAction</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeMitigationActionRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeMitigationActionRequest#builder()}
     * </p>
     *
     * @param describeMitigationActionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.DescribeMitigationActionRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeMitigationAction operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeMitigationAction
     */
    default DescribeMitigationActionResponse describeMitigationAction(
            Consumer<DescribeMitigationActionRequest.Builder> describeMitigationActionRequest) throws InvalidRequestException,
            ResourceNotFoundException, ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException,
            IotException {
        return describeMitigationAction(DescribeMitigationActionRequest.builder().applyMutation(describeMitigationActionRequest)
                .build());
    }

    /**
     * <p>
     * Returns information about a provisioning template.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeProvisioningTemplate</a> action.
     * </p>
     *
     * @param describeProvisioningTemplateRequest
     * @return Result of the DescribeProvisioningTemplate operation returned by the service.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeProvisioningTemplate
     */
    default DescribeProvisioningTemplateResponse describeProvisioningTemplate(
            DescribeProvisioningTemplateRequest describeProvisioningTemplateRequest) throws InternalFailureException,
            InvalidRequestException, ResourceNotFoundException, ThrottlingException, UnauthorizedException, AwsServiceException,
            SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a provisioning template.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeProvisioningTemplate</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeProvisioningTemplateRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeProvisioningTemplateRequest#builder()}
     * </p>
     *
     * @param describeProvisioningTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.DescribeProvisioningTemplateRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeProvisioningTemplate operation returned by the service.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeProvisioningTemplate
     */
    default DescribeProvisioningTemplateResponse describeProvisioningTemplate(
            Consumer<DescribeProvisioningTemplateRequest.Builder> describeProvisioningTemplateRequest)
            throws InternalFailureException, InvalidRequestException, ResourceNotFoundException, ThrottlingException,
            UnauthorizedException, AwsServiceException, SdkClientException, IotException {
        return describeProvisioningTemplate(DescribeProvisioningTemplateRequest.builder()
                .applyMutation(describeProvisioningTemplateRequest).build());
    }

    /**
     * <p>
     * Returns information about a provisioning template version.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeProvisioningTemplateVersion</a> action.
     * </p>
     *
     * @param describeProvisioningTemplateVersionRequest
     * @return Result of the DescribeProvisioningTemplateVersion operation returned by the service.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeProvisioningTemplateVersion
     */
    default DescribeProvisioningTemplateVersionResponse describeProvisioningTemplateVersion(
            DescribeProvisioningTemplateVersionRequest describeProvisioningTemplateVersionRequest)
            throws InternalFailureException, InvalidRequestException, ThrottlingException, ResourceNotFoundException,
            UnauthorizedException, AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a provisioning template version.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeProvisioningTemplateVersion</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeProvisioningTemplateVersionRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeProvisioningTemplateVersionRequest#builder()}
     * </p>
     *
     * @param describeProvisioningTemplateVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.DescribeProvisioningTemplateVersionRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeProvisioningTemplateVersion operation returned by the service.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeProvisioningTemplateVersion
     */
    default DescribeProvisioningTemplateVersionResponse describeProvisioningTemplateVersion(
            Consumer<DescribeProvisioningTemplateVersionRequest.Builder> describeProvisioningTemplateVersionRequest)
            throws InternalFailureException, InvalidRequestException, ThrottlingException, ResourceNotFoundException,
            UnauthorizedException, AwsServiceException, SdkClientException, IotException {
        return describeProvisioningTemplateVersion(DescribeProvisioningTemplateVersionRequest.builder()
                .applyMutation(describeProvisioningTemplateVersionRequest).build());
    }

    /**
     * <p>
     * Describes a role alias.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeRoleAlias</a> action.
     * </p>
     *
     * @param describeRoleAliasRequest
     * @return Result of the DescribeRoleAlias operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeRoleAlias
     */
    default DescribeRoleAliasResponse describeRoleAlias(DescribeRoleAliasRequest describeRoleAliasRequest)
            throws InvalidRequestException, ThrottlingException, UnauthorizedException, ServiceUnavailableException,
            InternalFailureException, ResourceNotFoundException, AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a role alias.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeRoleAlias</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeRoleAliasRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeRoleAliasRequest#builder()}
     * </p>
     *
     * @param describeRoleAliasRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.DescribeRoleAliasRequest.Builder} to create a request.
     * @return Result of the DescribeRoleAlias operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeRoleAlias
     */
    default DescribeRoleAliasResponse describeRoleAlias(Consumer<DescribeRoleAliasRequest.Builder> describeRoleAliasRequest)
            throws InvalidRequestException, ThrottlingException, UnauthorizedException, ServiceUnavailableException,
            InternalFailureException, ResourceNotFoundException, AwsServiceException, SdkClientException, IotException {
        return describeRoleAlias(DescribeRoleAliasRequest.builder().applyMutation(describeRoleAliasRequest).build());
    }

    /**
     * <p>
     * Gets information about a scheduled audit.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeScheduledAudit</a> action.
     * </p>
     *
     * @param describeScheduledAuditRequest
     * @return Result of the DescribeScheduledAudit operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeScheduledAudit
     */
    default DescribeScheduledAuditResponse describeScheduledAudit(DescribeScheduledAuditRequest describeScheduledAuditRequest)
            throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, InternalFailureException,
            AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a scheduled audit.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeScheduledAudit</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeScheduledAuditRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeScheduledAuditRequest#builder()}
     * </p>
     *
     * @param describeScheduledAuditRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.DescribeScheduledAuditRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeScheduledAudit operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeScheduledAudit
     */
    default DescribeScheduledAuditResponse describeScheduledAudit(
            Consumer<DescribeScheduledAuditRequest.Builder> describeScheduledAuditRequest) throws InvalidRequestException,
            ResourceNotFoundException, ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException,
            IotException {
        return describeScheduledAudit(DescribeScheduledAuditRequest.builder().applyMutation(describeScheduledAuditRequest)
                .build());
    }

    /**
     * <p>
     * Gets information about a Device Defender security profile.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeSecurityProfile</a> action.
     * </p>
     *
     * @param describeSecurityProfileRequest
     * @return Result of the DescribeSecurityProfile operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeSecurityProfile
     */
    default DescribeSecurityProfileResponse describeSecurityProfile(DescribeSecurityProfileRequest describeSecurityProfileRequest)
            throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, InternalFailureException,
            AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a Device Defender security profile.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeSecurityProfile</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSecurityProfileRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeSecurityProfileRequest#builder()}
     * </p>
     *
     * @param describeSecurityProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.DescribeSecurityProfileRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeSecurityProfile operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeSecurityProfile
     */
    default DescribeSecurityProfileResponse describeSecurityProfile(
            Consumer<DescribeSecurityProfileRequest.Builder> describeSecurityProfileRequest) throws InvalidRequestException,
            ResourceNotFoundException, ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException,
            IotException {
        return describeSecurityProfile(DescribeSecurityProfileRequest.builder().applyMutation(describeSecurityProfileRequest)
                .build());
    }

    /**
     * <p>
     * Gets information about a stream.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeStream</a> action.
     * </p>
     *
     * @param describeStreamRequest
     * @return Result of the DescribeStream operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeStream
     */
    default DescribeStreamResponse describeStream(DescribeStreamRequest describeStreamRequest) throws InvalidRequestException,
            ResourceNotFoundException, ThrottlingException, UnauthorizedException, ServiceUnavailableException,
            InternalFailureException, AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a stream.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeStream</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeStreamRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeStreamRequest#builder()}
     * </p>
     *
     * @param describeStreamRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.DescribeStreamRequest.Builder} to create a request.
     * @return Result of the DescribeStream operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeStream
     */
    default DescribeStreamResponse describeStream(Consumer<DescribeStreamRequest.Builder> describeStreamRequest)
            throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, UnauthorizedException,
            ServiceUnavailableException, InternalFailureException, AwsServiceException, SdkClientException, IotException {
        return describeStream(DescribeStreamRequest.builder().applyMutation(describeStreamRequest).build());
    }

    /**
     * <p>
     * Gets information about the specified thing.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeThing</a> action.
     * </p>
     *
     * @param describeThingRequest
     *        The input for the DescribeThing operation.
     * @return Result of the DescribeThing operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeThing
     */
    default DescribeThingResponse describeThing(DescribeThingRequest describeThingRequest) throws ResourceNotFoundException,
            InvalidRequestException, ThrottlingException, UnauthorizedException, ServiceUnavailableException,
            InternalFailureException, AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the specified thing.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeThing</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeThingRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeThingRequest#builder()}
     * </p>
     *
     * @param describeThingRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.DescribeThingRequest.Builder} to create a request. The
     *        input for the DescribeThing operation.
     * @return Result of the DescribeThing operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeThing
     */
    default DescribeThingResponse describeThing(Consumer<DescribeThingRequest.Builder> describeThingRequest)
            throws ResourceNotFoundException, InvalidRequestException, ThrottlingException, UnauthorizedException,
            ServiceUnavailableException, InternalFailureException, AwsServiceException, SdkClientException, IotException {
        return describeThing(DescribeThingRequest.builder().applyMutation(describeThingRequest).build());
    }

    /**
     * <p>
     * Describe a thing group.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeThingGroup</a> action.
     * </p>
     *
     * @param describeThingGroupRequest
     * @return Result of the DescribeThingGroup operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeThingGroup
     */
    default DescribeThingGroupResponse describeThingGroup(DescribeThingGroupRequest describeThingGroupRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describe a thing group.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeThingGroup</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeThingGroupRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeThingGroupRequest#builder()}
     * </p>
     *
     * @param describeThingGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.DescribeThingGroupRequest.Builder} to create a request.
     * @return Result of the DescribeThingGroup operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeThingGroup
     */
    default DescribeThingGroupResponse describeThingGroup(Consumer<DescribeThingGroupRequest.Builder> describeThingGroupRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, IotException {
        return describeThingGroup(DescribeThingGroupRequest.builder().applyMutation(describeThingGroupRequest).build());
    }

    /**
     * <p>
     * Describes a bulk thing provisioning task.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeThingRegistrationTask</a> action.
     * </p>
     *
     * @param describeThingRegistrationTaskRequest
     * @return Result of the DescribeThingRegistrationTask operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeThingRegistrationTask
     */
    default DescribeThingRegistrationTaskResponse describeThingRegistrationTask(
            DescribeThingRegistrationTaskRequest describeThingRegistrationTaskRequest) throws InvalidRequestException,
            ThrottlingException, UnauthorizedException, InternalFailureException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a bulk thing provisioning task.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeThingRegistrationTask</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeThingRegistrationTaskRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeThingRegistrationTaskRequest#builder()}
     * </p>
     *
     * @param describeThingRegistrationTaskRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.DescribeThingRegistrationTaskRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeThingRegistrationTask operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeThingRegistrationTask
     */
    default DescribeThingRegistrationTaskResponse describeThingRegistrationTask(
            Consumer<DescribeThingRegistrationTaskRequest.Builder> describeThingRegistrationTaskRequest)
            throws InvalidRequestException, ThrottlingException, UnauthorizedException, InternalFailureException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, IotException {
        return describeThingRegistrationTask(DescribeThingRegistrationTaskRequest.builder()
                .applyMutation(describeThingRegistrationTaskRequest).build());
    }

    /**
     * <p>
     * Gets information about the specified thing type.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeThingType</a> action.
     * </p>
     *
     * @param describeThingTypeRequest
     *        The input for the DescribeThingType operation.
     * @return Result of the DescribeThingType operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeThingType
     */
    default DescribeThingTypeResponse describeThingType(DescribeThingTypeRequest describeThingTypeRequest)
            throws ResourceNotFoundException, InvalidRequestException, ThrottlingException, UnauthorizedException,
            ServiceUnavailableException, InternalFailureException, AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the specified thing type.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DescribeThingType</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeThingTypeRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeThingTypeRequest#builder()}
     * </p>
     *
     * @param describeThingTypeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.DescribeThingTypeRequest.Builder} to create a request.
     *        The input for the DescribeThingType operation.
     * @return Result of the DescribeThingType operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DescribeThingType
     */
    default DescribeThingTypeResponse describeThingType(Consumer<DescribeThingTypeRequest.Builder> describeThingTypeRequest)
            throws ResourceNotFoundException, InvalidRequestException, ThrottlingException, UnauthorizedException,
            ServiceUnavailableException, InternalFailureException, AwsServiceException, SdkClientException, IotException {
        return describeThingType(DescribeThingTypeRequest.builder().applyMutation(describeThingTypeRequest).build());
    }

    /**
     * <p>
     * Detaches a policy from the specified target.
     * </p>
     * <note>
     * <p>
     * Because of the distributed nature of Amazon Web Services, it can take up to five minutes after a policy is
     * detached before it's ready to be deleted.
     * </p>
     * </note>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DetachPolicy</a> action.
     * </p>
     *
     * @param detachPolicyRequest
     * @return Result of the DetachPolicy operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DetachPolicy
     */
    default DetachPolicyResponse detachPolicy(DetachPolicyRequest detachPolicyRequest) throws InvalidRequestException,
            ThrottlingException, UnauthorizedException, ServiceUnavailableException, InternalFailureException,
            LimitExceededException, AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Detaches a policy from the specified target.
     * </p>
     * <note>
     * <p>
     * Because of the distributed nature of Amazon Web Services, it can take up to five minutes after a policy is
     * detached before it's ready to be deleted.
     * </p>
     * </note>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DetachPolicy</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DetachPolicyRequest.Builder} avoiding the need to
     * create one manually via {@link DetachPolicyRequest#builder()}
     * </p>
     *
     * @param detachPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.DetachPolicyRequest.Builder} to create a request.
     * @return Result of the DetachPolicy operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DetachPolicy
     */
    default DetachPolicyResponse detachPolicy(Consumer<DetachPolicyRequest.Builder> detachPolicyRequest)
            throws InvalidRequestException, ThrottlingException, UnauthorizedException, ServiceUnavailableException,
            InternalFailureException, LimitExceededException, AwsServiceException, SdkClientException, IotException {
        return detachPolicy(DetachPolicyRequest.builder().applyMutation(detachPolicyRequest).build());
    }

    /**
     * <p>
     * Disassociates a Device Defender security profile from a thing group or from this account.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DetachSecurityProfile</a> action.
     * </p>
     *
     * @param detachSecurityProfileRequest
     * @return Result of the DetachSecurityProfile operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DetachSecurityProfile
     */
    default DetachSecurityProfileResponse detachSecurityProfile(DetachSecurityProfileRequest detachSecurityProfileRequest)
            throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, InternalFailureException,
            AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a Device Defender security profile from a thing group or from this account.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DetachSecurityProfile</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DetachSecurityProfileRequest.Builder} avoiding the
     * need to create one manually via {@link DetachSecurityProfileRequest#builder()}
     * </p>
     *
     * @param detachSecurityProfileRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.DetachSecurityProfileRequest.Builder} to create a
     *        request.
     * @return Result of the DetachSecurityProfile operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DetachSecurityProfile
     */
    default DetachSecurityProfileResponse detachSecurityProfile(
            Consumer<DetachSecurityProfileRequest.Builder> detachSecurityProfileRequest) throws InvalidRequestException,
            ResourceNotFoundException, ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException,
            IotException {
        return detachSecurityProfile(DetachSecurityProfileRequest.builder().applyMutation(detachSecurityProfileRequest).build());
    }

    /**
     * <p>
     * Detaches the specified principal from the specified thing. A principal can be X.509 certificates, IAM users,
     * groups, and roles, Amazon Cognito identities or federated identities.
     * </p>
     * <note>
     * <p>
     * This call is asynchronous. It might take several seconds for the detachment to propagate.
     * </p>
     * </note>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DetachThingPrincipal</a> action.
     * </p>
     *
     * @param detachThingPrincipalRequest
     *        The input for the DetachThingPrincipal operation.
     * @return Result of the DetachThingPrincipal operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DetachThingPrincipal
     */
    default DetachThingPrincipalResponse detachThingPrincipal(DetachThingPrincipalRequest detachThingPrincipalRequest)
            throws ResourceNotFoundException, InvalidRequestException, ThrottlingException, UnauthorizedException,
            ServiceUnavailableException, InternalFailureException, AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Detaches the specified principal from the specified thing. A principal can be X.509 certificates, IAM users,
     * groups, and roles, Amazon Cognito identities or federated identities.
     * </p>
     * <note>
     * <p>
     * This call is asynchronous. It might take several seconds for the detachment to propagate.
     * </p>
     * </note>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DetachThingPrincipal</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DetachThingPrincipalRequest.Builder} avoiding the
     * need to create one manually via {@link DetachThingPrincipalRequest#builder()}
     * </p>
     *
     * @param detachThingPrincipalRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.DetachThingPrincipalRequest.Builder} to create a request.
     *        The input for the DetachThingPrincipal operation.
     * @return Result of the DetachThingPrincipal operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DetachThingPrincipal
     */
    default DetachThingPrincipalResponse detachThingPrincipal(
            Consumer<DetachThingPrincipalRequest.Builder> detachThingPrincipalRequest) throws ResourceNotFoundException,
            InvalidRequestException, ThrottlingException, UnauthorizedException, ServiceUnavailableException,
            InternalFailureException, AwsServiceException, SdkClientException, IotException {
        return detachThingPrincipal(DetachThingPrincipalRequest.builder().applyMutation(detachThingPrincipalRequest).build());
    }

    /**
     * <p>
     * Disables the rule.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DisableTopicRule</a> action.
     * </p>
     *
     * @param disableTopicRuleRequest
     *        The input for the DisableTopicRuleRequest operation.
     * @return Result of the DisableTopicRule operation returned by the service.
     * @throws InternalException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ConflictingResourceUpdateException
     *         A conflicting resource update exception. This exception is thrown when two pending updates cause a
     *         conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DisableTopicRule
     */
    default DisableTopicRuleResponse disableTopicRule(DisableTopicRuleRequest disableTopicRuleRequest) throws InternalException,
            InvalidRequestException, ServiceUnavailableException, UnauthorizedException, ConflictingResourceUpdateException,
            AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disables the rule.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >DisableTopicRule</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisableTopicRuleRequest.Builder} avoiding the need
     * to create one manually via {@link DisableTopicRuleRequest#builder()}
     * </p>
     *
     * @param disableTopicRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.DisableTopicRuleRequest.Builder} to create a request. The
     *        input for the DisableTopicRuleRequest operation.
     * @return Result of the DisableTopicRule operation returned by the service.
     * @throws InternalException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ConflictingResourceUpdateException
     *         A conflicting resource update exception. This exception is thrown when two pending updates cause a
     *         conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.DisableTopicRule
     */
    default DisableTopicRuleResponse disableTopicRule(Consumer<DisableTopicRuleRequest.Builder> disableTopicRuleRequest)
            throws InternalException, InvalidRequestException, ServiceUnavailableException, UnauthorizedException,
            ConflictingResourceUpdateException, AwsServiceException, SdkClientException, IotException {
        return disableTopicRule(DisableTopicRuleRequest.builder().applyMutation(disableTopicRuleRequest).build());
    }

    /**
     * <p>
     * Enables the rule.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >EnableTopicRule</a> action.
     * </p>
     *
     * @param enableTopicRuleRequest
     *        The input for the EnableTopicRuleRequest operation.
     * @return Result of the EnableTopicRule operation returned by the service.
     * @throws InternalException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ConflictingResourceUpdateException
     *         A conflicting resource update exception. This exception is thrown when two pending updates cause a
     *         conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.EnableTopicRule
     */
    default EnableTopicRuleResponse enableTopicRule(EnableTopicRuleRequest enableTopicRuleRequest) throws InternalException,
            InvalidRequestException, ServiceUnavailableException, UnauthorizedException, ConflictingResourceUpdateException,
            AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables the rule.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >EnableTopicRule</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link EnableTopicRuleRequest.Builder} avoiding the need
     * to create one manually via {@link EnableTopicRuleRequest#builder()}
     * </p>
     *
     * @param enableTopicRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.EnableTopicRuleRequest.Builder} to create a request. The
     *        input for the EnableTopicRuleRequest operation.
     * @return Result of the EnableTopicRule operation returned by the service.
     * @throws InternalException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ConflictingResourceUpdateException
     *         A conflicting resource update exception. This exception is thrown when two pending updates cause a
     *         conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.EnableTopicRule
     */
    default EnableTopicRuleResponse enableTopicRule(Consumer<EnableTopicRuleRequest.Builder> enableTopicRuleRequest)
            throws InternalException, InvalidRequestException, ServiceUnavailableException, UnauthorizedException,
            ConflictingResourceUpdateException, AwsServiceException, SdkClientException, IotException {
        return enableTopicRule(EnableTopicRuleRequest.builder().applyMutation(enableTopicRuleRequest).build());
    }

    /**
     * <p>
     * Returns a Device Defender's ML Detect Security Profile training model's status.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >GetBehaviorModelTrainingSummaries</a> action.
     * </p>
     *
     * @param getBehaviorModelTrainingSummariesRequest
     * @return Result of the GetBehaviorModelTrainingSummaries operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.GetBehaviorModelTrainingSummaries
     */
    default GetBehaviorModelTrainingSummariesResponse getBehaviorModelTrainingSummaries(
            GetBehaviorModelTrainingSummariesRequest getBehaviorModelTrainingSummariesRequest) throws InvalidRequestException,
            ThrottlingException, InternalFailureException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a Device Defender's ML Detect Security Profile training model's status.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >GetBehaviorModelTrainingSummaries</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBehaviorModelTrainingSummariesRequest.Builder}
     * avoiding the need to create one manually via {@link GetBehaviorModelTrainingSummariesRequest#builder()}
     * </p>
     *
     * @param getBehaviorModelTrainingSummariesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.GetBehaviorModelTrainingSummariesRequest.Builder} to
     *        create a request.
     * @return Result of the GetBehaviorModelTrainingSummaries operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.GetBehaviorModelTrainingSummaries
     */
    default GetBehaviorModelTrainingSummariesResponse getBehaviorModelTrainingSummaries(
            Consumer<GetBehaviorModelTrainingSummariesRequest.Builder> getBehaviorModelTrainingSummariesRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, IotException {
        return getBehaviorModelTrainingSummaries(GetBehaviorModelTrainingSummariesRequest.builder()
                .applyMutation(getBehaviorModelTrainingSummariesRequest).build());
    }

    /**
     * <p>
     * Returns a Device Defender's ML Detect Security Profile training model's status.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >GetBehaviorModelTrainingSummaries</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getBehaviorModelTrainingSummaries(software.amazon.awssdk.services.iot.model.GetBehaviorModelTrainingSummariesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.GetBehaviorModelTrainingSummariesIterable responses = client.getBehaviorModelTrainingSummariesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iot.paginators.GetBehaviorModelTrainingSummariesIterable responses = client
     *             .getBehaviorModelTrainingSummariesPaginator(request);
     *     for (software.amazon.awssdk.services.iot.model.GetBehaviorModelTrainingSummariesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.GetBehaviorModelTrainingSummariesIterable responses = client.getBehaviorModelTrainingSummariesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getBehaviorModelTrainingSummaries(software.amazon.awssdk.services.iot.model.GetBehaviorModelTrainingSummariesRequest)}
     * operation.</b>
     * </p>
     *
     * @param getBehaviorModelTrainingSummariesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.GetBehaviorModelTrainingSummaries
     */
    default GetBehaviorModelTrainingSummariesIterable getBehaviorModelTrainingSummariesPaginator(
            GetBehaviorModelTrainingSummariesRequest getBehaviorModelTrainingSummariesRequest) throws InvalidRequestException,
            ThrottlingException, InternalFailureException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            IotException {
        return new GetBehaviorModelTrainingSummariesIterable(this, getBehaviorModelTrainingSummariesRequest);
    }

    /**
     * <p>
     * Returns a Device Defender's ML Detect Security Profile training model's status.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >GetBehaviorModelTrainingSummaries</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getBehaviorModelTrainingSummaries(software.amazon.awssdk.services.iot.model.GetBehaviorModelTrainingSummariesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.GetBehaviorModelTrainingSummariesIterable responses = client.getBehaviorModelTrainingSummariesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iot.paginators.GetBehaviorModelTrainingSummariesIterable responses = client
     *             .getBehaviorModelTrainingSummariesPaginator(request);
     *     for (software.amazon.awssdk.services.iot.model.GetBehaviorModelTrainingSummariesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.GetBehaviorModelTrainingSummariesIterable responses = client.getBehaviorModelTrainingSummariesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getBehaviorModelTrainingSummaries(software.amazon.awssdk.services.iot.model.GetBehaviorModelTrainingSummariesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBehaviorModelTrainingSummariesRequest.Builder}
     * avoiding the need to create one manually via {@link GetBehaviorModelTrainingSummariesRequest#builder()}
     * </p>
     *
     * @param getBehaviorModelTrainingSummariesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.GetBehaviorModelTrainingSummariesRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.GetBehaviorModelTrainingSummaries
     */
    default GetBehaviorModelTrainingSummariesIterable getBehaviorModelTrainingSummariesPaginator(
            Consumer<GetBehaviorModelTrainingSummariesRequest.Builder> getBehaviorModelTrainingSummariesRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, IotException {
        return getBehaviorModelTrainingSummariesPaginator(GetBehaviorModelTrainingSummariesRequest.builder()
                .applyMutation(getBehaviorModelTrainingSummariesRequest).build());
    }

    /**
     * <p>
     * Aggregates on indexed data with search queries pertaining to particular fields.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >GetBucketsAggregation</a> action.
     * </p>
     *
     * @param getBucketsAggregationRequest
     * @return Result of the GetBucketsAggregation operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidQueryException
     *         The query is invalid.
     * @throws InvalidAggregationException
     *         The aggregation is invalid.
     * @throws IndexNotReadyException
     *         The index is not ready.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.GetBucketsAggregation
     */
    default GetBucketsAggregationResponse getBucketsAggregation(GetBucketsAggregationRequest getBucketsAggregationRequest)
            throws InvalidRequestException, ThrottlingException, UnauthorizedException, ServiceUnavailableException,
            InternalFailureException, ResourceNotFoundException, InvalidQueryException, InvalidAggregationException,
            IndexNotReadyException, AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Aggregates on indexed data with search queries pertaining to particular fields.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >GetBucketsAggregation</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBucketsAggregationRequest.Builder} avoiding the
     * need to create one manually via {@link GetBucketsAggregationRequest#builder()}
     * </p>
     *
     * @param getBucketsAggregationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.GetBucketsAggregationRequest.Builder} to create a
     *        request.
     * @return Result of the GetBucketsAggregation operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidQueryException
     *         The query is invalid.
     * @throws InvalidAggregationException
     *         The aggregation is invalid.
     * @throws IndexNotReadyException
     *         The index is not ready.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.GetBucketsAggregation
     */
    default GetBucketsAggregationResponse getBucketsAggregation(
            Consumer<GetBucketsAggregationRequest.Builder> getBucketsAggregationRequest) throws InvalidRequestException,
            ThrottlingException, UnauthorizedException, ServiceUnavailableException, InternalFailureException,
            ResourceNotFoundException, InvalidQueryException, InvalidAggregationException, IndexNotReadyException,
            AwsServiceException, SdkClientException, IotException {
        return getBucketsAggregation(GetBucketsAggregationRequest.builder().applyMutation(getBucketsAggregationRequest).build());
    }

    /**
     * <p>
     * Returns the approximate count of unique values that match the query.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >GetCardinality</a> action.
     * </p>
     *
     * @param getCardinalityRequest
     * @return Result of the GetCardinality operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidQueryException
     *         The query is invalid.
     * @throws InvalidAggregationException
     *         The aggregation is invalid.
     * @throws IndexNotReadyException
     *         The index is not ready.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.GetCardinality
     */
    default GetCardinalityResponse getCardinality(GetCardinalityRequest getCardinalityRequest) throws InvalidRequestException,
            ThrottlingException, UnauthorizedException, ServiceUnavailableException, InternalFailureException,
            ResourceNotFoundException, InvalidQueryException, InvalidAggregationException, IndexNotReadyException,
            AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the approximate count of unique values that match the query.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >GetCardinality</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCardinalityRequest.Builder} avoiding the need to
     * create one manually via {@link GetCardinalityRequest#builder()}
     * </p>
     *
     * @param getCardinalityRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.GetCardinalityRequest.Builder} to create a request.
     * @return Result of the GetCardinality operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidQueryException
     *         The query is invalid.
     * @throws InvalidAggregationException
     *         The aggregation is invalid.
     * @throws IndexNotReadyException
     *         The index is not ready.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.GetCardinality
     */
    default GetCardinalityResponse getCardinality(Consumer<GetCardinalityRequest.Builder> getCardinalityRequest)
            throws InvalidRequestException, ThrottlingException, UnauthorizedException, ServiceUnavailableException,
            InternalFailureException, ResourceNotFoundException, InvalidQueryException, InvalidAggregationException,
            IndexNotReadyException, AwsServiceException, SdkClientException, IotException {
        return getCardinality(GetCardinalityRequest.builder().applyMutation(getCardinalityRequest).build());
    }

    /**
     * <p>
     * Gets a list of the policies that have an effect on the authorization behavior of the specified device when it
     * connects to the IoT device gateway.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >GetEffectivePolicies</a> action.
     * </p>
     *
     * @param getEffectivePoliciesRequest
     * @return Result of the GetEffectivePolicies operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.GetEffectivePolicies
     */
    default GetEffectivePoliciesResponse getEffectivePolicies(GetEffectivePoliciesRequest getEffectivePoliciesRequest)
            throws ResourceNotFoundException, InvalidRequestException, ThrottlingException, UnauthorizedException,
            ServiceUnavailableException, InternalFailureException, LimitExceededException, AwsServiceException,
            SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of the policies that have an effect on the authorization behavior of the specified device when it
     * connects to the IoT device gateway.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >GetEffectivePolicies</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEffectivePoliciesRequest.Builder} avoiding the
     * need to create one manually via {@link GetEffectivePoliciesRequest#builder()}
     * </p>
     *
     * @param getEffectivePoliciesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.GetEffectivePoliciesRequest.Builder} to create a request.
     * @return Result of the GetEffectivePolicies operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.GetEffectivePolicies
     */
    default GetEffectivePoliciesResponse getEffectivePolicies(
            Consumer<GetEffectivePoliciesRequest.Builder> getEffectivePoliciesRequest) throws ResourceNotFoundException,
            InvalidRequestException, ThrottlingException, UnauthorizedException, ServiceUnavailableException,
            InternalFailureException, LimitExceededException, AwsServiceException, SdkClientException, IotException {
        return getEffectivePolicies(GetEffectivePoliciesRequest.builder().applyMutation(getEffectivePoliciesRequest).build());
    }

    /**
     * <p>
     * Gets the indexing configuration.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >GetIndexingConfiguration</a> action.
     * </p>
     *
     * @param getIndexingConfigurationRequest
     * @return Result of the GetIndexingConfiguration operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.GetIndexingConfiguration
     */
    default GetIndexingConfigurationResponse getIndexingConfiguration(
            GetIndexingConfigurationRequest getIndexingConfigurationRequest) throws InvalidRequestException, ThrottlingException,
            UnauthorizedException, ServiceUnavailableException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the indexing configuration.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >GetIndexingConfiguration</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetIndexingConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link GetIndexingConfigurationRequest#builder()}
     * </p>
     *
     * @param getIndexingConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.GetIndexingConfigurationRequest.Builder} to create a
     *        request.
     * @return Result of the GetIndexingConfiguration operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.GetIndexingConfiguration
     */
    default GetIndexingConfigurationResponse getIndexingConfiguration(
            Consumer<GetIndexingConfigurationRequest.Builder> getIndexingConfigurationRequest) throws InvalidRequestException,
            ThrottlingException, UnauthorizedException, ServiceUnavailableException, InternalFailureException,
            AwsServiceException, SdkClientException, IotException {
        return getIndexingConfiguration(GetIndexingConfigurationRequest.builder().applyMutation(getIndexingConfigurationRequest)
                .build());
    }

    /**
     * <p>
     * Gets the indexing configuration.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >GetIndexingConfiguration</a> action.
     * </p>
     *
     * @return Result of the GetIndexingConfiguration operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.GetIndexingConfiguration
     * @see #getIndexingConfiguration(GetIndexingConfigurationRequest)
     */
    default GetIndexingConfigurationResponse getIndexingConfiguration() throws InvalidRequestException, ThrottlingException,
            UnauthorizedException, ServiceUnavailableException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        return getIndexingConfiguration(GetIndexingConfigurationRequest.builder().build());
    }

    /**
     * <p>
     * Gets a job document.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >GetJobDocument</a> action.
     * </p>
     *
     * @param getJobDocumentRequest
     * @return Result of the GetJobDocument operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.GetJobDocument
     */
    default GetJobDocumentResponse getJobDocument(GetJobDocumentRequest getJobDocumentRequest) throws InvalidRequestException,
            ResourceNotFoundException, ThrottlingException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a job document.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >GetJobDocument</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetJobDocumentRequest.Builder} avoiding the need to
     * create one manually via {@link GetJobDocumentRequest#builder()}
     * </p>
     *
     * @param getJobDocumentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.GetJobDocumentRequest.Builder} to create a request.
     * @return Result of the GetJobDocument operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.GetJobDocument
     */
    default GetJobDocumentResponse getJobDocument(Consumer<GetJobDocumentRequest.Builder> getJobDocumentRequest)
            throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, IotException {
        return getJobDocument(GetJobDocumentRequest.builder().applyMutation(getJobDocumentRequest).build());
    }

    /**
     * <p>
     * Gets the logging options.
     * </p>
     * <p>
     * NOTE: use of this command is not recommended. Use <code>GetV2LoggingOptions</code> instead.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >GetLoggingOptions</a> action.
     * </p>
     *
     * @param getLoggingOptionsRequest
     *        The input for the GetLoggingOptions operation.
     * @return Result of the GetLoggingOptions operation returned by the service.
     * @throws InternalException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.GetLoggingOptions
     */
    default GetLoggingOptionsResponse getLoggingOptions(GetLoggingOptionsRequest getLoggingOptionsRequest)
            throws InternalException, InvalidRequestException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the logging options.
     * </p>
     * <p>
     * NOTE: use of this command is not recommended. Use <code>GetV2LoggingOptions</code> instead.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >GetLoggingOptions</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLoggingOptionsRequest.Builder} avoiding the need
     * to create one manually via {@link GetLoggingOptionsRequest#builder()}
     * </p>
     *
     * @param getLoggingOptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.GetLoggingOptionsRequest.Builder} to create a request.
     *        The input for the GetLoggingOptions operation.
     * @return Result of the GetLoggingOptions operation returned by the service.
     * @throws InternalException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.GetLoggingOptions
     */
    default GetLoggingOptionsResponse getLoggingOptions(Consumer<GetLoggingOptionsRequest.Builder> getLoggingOptionsRequest)
            throws InternalException, InvalidRequestException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, IotException {
        return getLoggingOptions(GetLoggingOptionsRequest.builder().applyMutation(getLoggingOptionsRequest).build());
    }

    /**
     * <p>
     * Gets the logging options.
     * </p>
     * <p>
     * NOTE: use of this command is not recommended. Use <code>GetV2LoggingOptions</code> instead.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >GetLoggingOptions</a> action.
     * </p>
     *
     * @return Result of the GetLoggingOptions operation returned by the service.
     * @throws InternalException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.GetLoggingOptions
     * @see #getLoggingOptions(GetLoggingOptionsRequest)
     */
    default GetLoggingOptionsResponse getLoggingOptions() throws InternalException, InvalidRequestException,
            ServiceUnavailableException, AwsServiceException, SdkClientException, IotException {
        return getLoggingOptions(GetLoggingOptionsRequest.builder().build());
    }

    /**
     * <p>
     * Gets an OTA update.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >GetOTAUpdate</a> action.
     * </p>
     *
     * @param getOtaUpdateRequest
     * @return Result of the GetOTAUpdate operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.GetOTAUpdate
     */
    default GetOtaUpdateResponse getOTAUpdate(GetOtaUpdateRequest getOtaUpdateRequest) throws InvalidRequestException,
            ThrottlingException, UnauthorizedException, InternalFailureException, ServiceUnavailableException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets an OTA update.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >GetOTAUpdate</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetOtaUpdateRequest.Builder} avoiding the need to
     * create one manually via {@link GetOtaUpdateRequest#builder()}
     * </p>
     *
     * @param getOtaUpdateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.GetOtaUpdateRequest.Builder} to create a request.
     * @return Result of the GetOTAUpdate operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.GetOTAUpdate
     */
    default GetOtaUpdateResponse getOTAUpdate(Consumer<GetOtaUpdateRequest.Builder> getOtaUpdateRequest)
            throws InvalidRequestException, ThrottlingException, UnauthorizedException, InternalFailureException,
            ServiceUnavailableException, ResourceNotFoundException, AwsServiceException, SdkClientException, IotException {
        return getOTAUpdate(GetOtaUpdateRequest.builder().applyMutation(getOtaUpdateRequest).build());
    }

    /**
     * <p>
     * Gets information about the specified software package.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >GetPackage</a> action.
     * </p>
     *
     * @param getPackageRequest
     * @return Result of the GetPackage operation returned by the service.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ValidationException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.GetPackage
     */
    default GetPackageResponse getPackage(GetPackageRequest getPackageRequest) throws ThrottlingException,
            InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the specified software package.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >GetPackage</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPackageRequest.Builder} avoiding the need to
     * create one manually via {@link GetPackageRequest#builder()}
     * </p>
     *
     * @param getPackageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.GetPackageRequest.Builder} to create a request.
     * @return Result of the GetPackage operation returned by the service.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ValidationException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.GetPackage
     */
    default GetPackageResponse getPackage(Consumer<GetPackageRequest.Builder> getPackageRequest) throws ThrottlingException,
            InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            IotException {
        return getPackage(GetPackageRequest.builder().applyMutation(getPackageRequest).build());
    }

    /**
     * <p>
     * Gets information about the specified software package's configuration.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >GetPackageConfiguration</a> action.
     * </p>
     *
     * @param getPackageConfigurationRequest
     * @return Result of the GetPackageConfiguration operation returned by the service.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.GetPackageConfiguration
     */
    default GetPackageConfigurationResponse getPackageConfiguration(GetPackageConfigurationRequest getPackageConfigurationRequest)
            throws ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the specified software package's configuration.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >GetPackageConfiguration</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPackageConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link GetPackageConfigurationRequest#builder()}
     * </p>
     *
     * @param getPackageConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.GetPackageConfigurationRequest.Builder} to create a
     *        request.
     * @return Result of the GetPackageConfiguration operation returned by the service.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.GetPackageConfiguration
     */
    default GetPackageConfigurationResponse getPackageConfiguration(
            Consumer<GetPackageConfigurationRequest.Builder> getPackageConfigurationRequest) throws ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, IotException {
        return getPackageConfiguration(GetPackageConfigurationRequest.builder().applyMutation(getPackageConfigurationRequest)
                .build());
    }

    /**
     * <p>
     * Gets information about the specified package version.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >GetPackageVersion</a> action.
     * </p>
     *
     * @param getPackageVersionRequest
     * @return Result of the GetPackageVersion operation returned by the service.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ValidationException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.GetPackageVersion
     */
    default GetPackageVersionResponse getPackageVersion(GetPackageVersionRequest getPackageVersionRequest)
            throws ThrottlingException, InternalServerException, ValidationException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the specified package version.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >GetPackageVersion</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPackageVersionRequest.Builder} avoiding the need
     * to create one manually via {@link GetPackageVersionRequest#builder()}
     * </p>
     *
     * @param getPackageVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.GetPackageVersionRequest.Builder} to create a request.
     * @return Result of the GetPackageVersion operation returned by the service.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalServerException
     *         Internal error from the service that indicates an unexpected error or that the service is unavailable.
     * @throws ValidationException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.GetPackageVersion
     */
    default GetPackageVersionResponse getPackageVersion(Consumer<GetPackageVersionRequest.Builder> getPackageVersionRequest)
            throws ThrottlingException, InternalServerException, ValidationException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, IotException {
        return getPackageVersion(GetPackageVersionRequest.builder().applyMutation(getPackageVersionRequest).build());
    }

    /**
     * <p>
     * Groups the aggregated values that match the query into percentile groupings. The default percentile groupings
     * are: 1,5,25,50,75,95,99, although you can specify your own when you call <code>GetPercentiles</code>. This
     * function returns a value for each percentile group specified (or the default percentile groupings). The
     * percentile group "1" contains the aggregated field value that occurs in approximately one percent of the values
     * that match the query. The percentile group "5" contains the aggregated field value that occurs in approximately
     * five percent of the values that match the query, and so on. The result is an approximation, the more values that
     * match the query, the more accurate the percentile values.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >GetPercentiles</a> action.
     * </p>
     *
     * @param getPercentilesRequest
     * @return Result of the GetPercentiles operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidQueryException
     *         The query is invalid.
     * @throws InvalidAggregationException
     *         The aggregation is invalid.
     * @throws IndexNotReadyException
     *         The index is not ready.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.GetPercentiles
     */
    default GetPercentilesResponse getPercentiles(GetPercentilesRequest getPercentilesRequest) throws InvalidRequestException,
            ThrottlingException, UnauthorizedException, ServiceUnavailableException, InternalFailureException,
            ResourceNotFoundException, InvalidQueryException, InvalidAggregationException, IndexNotReadyException,
            AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Groups the aggregated values that match the query into percentile groupings. The default percentile groupings
     * are: 1,5,25,50,75,95,99, although you can specify your own when you call <code>GetPercentiles</code>. This
     * function returns a value for each percentile group specified (or the default percentile groupings). The
     * percentile group "1" contains the aggregated field value that occurs in approximately one percent of the values
     * that match the query. The percentile group "5" contains the aggregated field value that occurs in approximately
     * five percent of the values that match the query, and so on. The result is an approximation, the more values that
     * match the query, the more accurate the percentile values.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >GetPercentiles</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPercentilesRequest.Builder} avoiding the need to
     * create one manually via {@link GetPercentilesRequest#builder()}
     * </p>
     *
     * @param getPercentilesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.GetPercentilesRequest.Builder} to create a request.
     * @return Result of the GetPercentiles operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidQueryException
     *         The query is invalid.
     * @throws InvalidAggregationException
     *         The aggregation is invalid.
     * @throws IndexNotReadyException
     *         The index is not ready.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.GetPercentiles
     */
    default GetPercentilesResponse getPercentiles(Consumer<GetPercentilesRequest.Builder> getPercentilesRequest)
            throws InvalidRequestException, ThrottlingException, UnauthorizedException, ServiceUnavailableException,
            InternalFailureException, ResourceNotFoundException, InvalidQueryException, InvalidAggregationException,
            IndexNotReadyException, AwsServiceException, SdkClientException, IotException {
        return getPercentiles(GetPercentilesRequest.builder().applyMutation(getPercentilesRequest).build());
    }

    /**
     * <p>
     * Gets information about the specified policy with the policy document of the default version.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >GetPolicy</a> action.
     * </p>
     *
     * @param getPolicyRequest
     *        The input for the GetPolicy operation.
     * @return Result of the GetPolicy operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.GetPolicy
     */
    default GetPolicyResponse getPolicy(GetPolicyRequest getPolicyRequest) throws ResourceNotFoundException,
            InvalidRequestException, ThrottlingException, UnauthorizedException, ServiceUnavailableException,
            InternalFailureException, AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the specified policy with the policy document of the default version.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >GetPolicy</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPolicyRequest.Builder} avoiding the need to
     * create one manually via {@link GetPolicyRequest#builder()}
     * </p>
     *
     * @param getPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.GetPolicyRequest.Builder} to create a request. The input
     *        for the GetPolicy operation.
     * @return Result of the GetPolicy operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.GetPolicy
     */
    default GetPolicyResponse getPolicy(Consumer<GetPolicyRequest.Builder> getPolicyRequest) throws ResourceNotFoundException,
            InvalidRequestException, ThrottlingException, UnauthorizedException, ServiceUnavailableException,
            InternalFailureException, AwsServiceException, SdkClientException, IotException {
        return getPolicy(GetPolicyRequest.builder().applyMutation(getPolicyRequest).build());
    }

    /**
     * <p>
     * Gets information about the specified policy version.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >GetPolicyVersion</a> action.
     * </p>
     *
     * @param getPolicyVersionRequest
     *        The input for the GetPolicyVersion operation.
     * @return Result of the GetPolicyVersion operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.GetPolicyVersion
     */
    default GetPolicyVersionResponse getPolicyVersion(GetPolicyVersionRequest getPolicyVersionRequest)
            throws ResourceNotFoundException, InvalidRequestException, ThrottlingException, UnauthorizedException,
            ServiceUnavailableException, InternalFailureException, AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the specified policy version.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >GetPolicyVersion</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPolicyVersionRequest.Builder} avoiding the need
     * to create one manually via {@link GetPolicyVersionRequest#builder()}
     * </p>
     *
     * @param getPolicyVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.GetPolicyVersionRequest.Builder} to create a request. The
     *        input for the GetPolicyVersion operation.
     * @return Result of the GetPolicyVersion operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.GetPolicyVersion
     */
    default GetPolicyVersionResponse getPolicyVersion(Consumer<GetPolicyVersionRequest.Builder> getPolicyVersionRequest)
            throws ResourceNotFoundException, InvalidRequestException, ThrottlingException, UnauthorizedException,
            ServiceUnavailableException, InternalFailureException, AwsServiceException, SdkClientException, IotException {
        return getPolicyVersion(GetPolicyVersionRequest.builder().applyMutation(getPolicyVersionRequest).build());
    }

    /**
     * <p>
     * Gets a registration code used to register a CA certificate with IoT.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >GetRegistrationCode</a> action.
     * </p>
     *
     * @param getRegistrationCodeRequest
     *        The input to the GetRegistrationCode operation.
     * @return Result of the GetRegistrationCode operation returned by the service.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.GetRegistrationCode
     */
    default GetRegistrationCodeResponse getRegistrationCode(GetRegistrationCodeRequest getRegistrationCodeRequest)
            throws ThrottlingException, UnauthorizedException, ServiceUnavailableException, InternalFailureException,
            InvalidRequestException, AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a registration code used to register a CA certificate with IoT.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >GetRegistrationCode</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRegistrationCodeRequest.Builder} avoiding the
     * need to create one manually via {@link GetRegistrationCodeRequest#builder()}
     * </p>
     *
     * @param getRegistrationCodeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.GetRegistrationCodeRequest.Builder} to create a request.
     *        The input to the GetRegistrationCode operation.
     * @return Result of the GetRegistrationCode operation returned by the service.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.GetRegistrationCode
     */
    default GetRegistrationCodeResponse getRegistrationCode(
            Consumer<GetRegistrationCodeRequest.Builder> getRegistrationCodeRequest) throws ThrottlingException,
            UnauthorizedException, ServiceUnavailableException, InternalFailureException, InvalidRequestException,
            AwsServiceException, SdkClientException, IotException {
        return getRegistrationCode(GetRegistrationCodeRequest.builder().applyMutation(getRegistrationCodeRequest).build());
    }

    /**
     * <p>
     * Gets a registration code used to register a CA certificate with IoT.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >GetRegistrationCode</a> action.
     * </p>
     *
     * @return Result of the GetRegistrationCode operation returned by the service.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.GetRegistrationCode
     * @see #getRegistrationCode(GetRegistrationCodeRequest)
     */
    default GetRegistrationCodeResponse getRegistrationCode() throws ThrottlingException, UnauthorizedException,
            ServiceUnavailableException, InternalFailureException, InvalidRequestException, AwsServiceException,
            SdkClientException, IotException {
        return getRegistrationCode(GetRegistrationCodeRequest.builder().build());
    }

    /**
     * <p>
     * Returns the count, average, sum, minimum, maximum, sum of squares, variance, and standard deviation for the
     * specified aggregated field. If the aggregation field is of type <code>String</code>, only the count statistic is
     * returned.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >GetStatistics</a> action.
     * </p>
     *
     * @param getStatisticsRequest
     * @return Result of the GetStatistics operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidQueryException
     *         The query is invalid.
     * @throws InvalidAggregationException
     *         The aggregation is invalid.
     * @throws IndexNotReadyException
     *         The index is not ready.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.GetStatistics
     */
    default GetStatisticsResponse getStatistics(GetStatisticsRequest getStatisticsRequest) throws InvalidRequestException,
            ThrottlingException, UnauthorizedException, ServiceUnavailableException, InternalFailureException,
            ResourceNotFoundException, InvalidQueryException, InvalidAggregationException, IndexNotReadyException,
            AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the count, average, sum, minimum, maximum, sum of squares, variance, and standard deviation for the
     * specified aggregated field. If the aggregation field is of type <code>String</code>, only the count statistic is
     * returned.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >GetStatistics</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetStatisticsRequest.Builder} avoiding the need to
     * create one manually via {@link GetStatisticsRequest#builder()}
     * </p>
     *
     * @param getStatisticsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.GetStatisticsRequest.Builder} to create a request.
     * @return Result of the GetStatistics operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidQueryException
     *         The query is invalid.
     * @throws InvalidAggregationException
     *         The aggregation is invalid.
     * @throws IndexNotReadyException
     *         The index is not ready.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.GetStatistics
     */
    default GetStatisticsResponse getStatistics(Consumer<GetStatisticsRequest.Builder> getStatisticsRequest)
            throws InvalidRequestException, ThrottlingException, UnauthorizedException, ServiceUnavailableException,
            InternalFailureException, ResourceNotFoundException, InvalidQueryException, InvalidAggregationException,
            IndexNotReadyException, AwsServiceException, SdkClientException, IotException {
        return getStatistics(GetStatisticsRequest.builder().applyMutation(getStatisticsRequest).build());
    }

    /**
     * <p>
     * Gets information about the rule.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >GetTopicRule</a> action.
     * </p>
     *
     * @param getTopicRuleRequest
     *        The input for the GetTopicRule operation.
     * @return Result of the GetTopicRule operation returned by the service.
     * @throws InternalException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.GetTopicRule
     */
    default GetTopicRuleResponse getTopicRule(GetTopicRuleRequest getTopicRuleRequest) throws InternalException,
            InvalidRequestException, ServiceUnavailableException, UnauthorizedException, AwsServiceException, SdkClientException,
            IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the rule.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >GetTopicRule</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTopicRuleRequest.Builder} avoiding the need to
     * create one manually via {@link GetTopicRuleRequest#builder()}
     * </p>
     *
     * @param getTopicRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.GetTopicRuleRequest.Builder} to create a request. The
     *        input for the GetTopicRule operation.
     * @return Result of the GetTopicRule operation returned by the service.
     * @throws InternalException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.GetTopicRule
     */
    default GetTopicRuleResponse getTopicRule(Consumer<GetTopicRuleRequest.Builder> getTopicRuleRequest)
            throws InternalException, InvalidRequestException, ServiceUnavailableException, UnauthorizedException,
            AwsServiceException, SdkClientException, IotException {
        return getTopicRule(GetTopicRuleRequest.builder().applyMutation(getTopicRuleRequest).build());
    }

    /**
     * <p>
     * Gets information about a topic rule destination.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >GetTopicRuleDestination</a> action.
     * </p>
     *
     * @param getTopicRuleDestinationRequest
     * @return Result of the GetTopicRuleDestination operation returned by the service.
     * @throws InternalException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.GetTopicRuleDestination
     */
    default GetTopicRuleDestinationResponse getTopicRuleDestination(GetTopicRuleDestinationRequest getTopicRuleDestinationRequest)
            throws InternalException, InvalidRequestException, ServiceUnavailableException, UnauthorizedException,
            AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a topic rule destination.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >GetTopicRuleDestination</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTopicRuleDestinationRequest.Builder} avoiding
     * the need to create one manually via {@link GetTopicRuleDestinationRequest#builder()}
     * </p>
     *
     * @param getTopicRuleDestinationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.GetTopicRuleDestinationRequest.Builder} to create a
     *        request.
     * @return Result of the GetTopicRuleDestination operation returned by the service.
     * @throws InternalException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.GetTopicRuleDestination
     */
    default GetTopicRuleDestinationResponse getTopicRuleDestination(
            Consumer<GetTopicRuleDestinationRequest.Builder> getTopicRuleDestinationRequest) throws InternalException,
            InvalidRequestException, ServiceUnavailableException, UnauthorizedException, AwsServiceException, SdkClientException,
            IotException {
        return getTopicRuleDestination(GetTopicRuleDestinationRequest.builder().applyMutation(getTopicRuleDestinationRequest)
                .build());
    }

    /**
     * <p>
     * Gets the fine grained logging options.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >GetV2LoggingOptions</a> action.
     * </p>
     *
     * @param getV2LoggingOptionsRequest
     * @return Result of the GetV2LoggingOptions operation returned by the service.
     * @throws InternalException
     *         An unexpected error has occurred.
     * @throws NotConfiguredException
     *         The resource is not configured.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.GetV2LoggingOptions
     */
    default GetV2LoggingOptionsResponse getV2LoggingOptions(GetV2LoggingOptionsRequest getV2LoggingOptionsRequest)
            throws InternalException, NotConfiguredException, ServiceUnavailableException, AwsServiceException,
            SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the fine grained logging options.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >GetV2LoggingOptions</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetV2LoggingOptionsRequest.Builder} avoiding the
     * need to create one manually via {@link GetV2LoggingOptionsRequest#builder()}
     * </p>
     *
     * @param getV2LoggingOptionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.GetV2LoggingOptionsRequest.Builder} to create a request.
     * @return Result of the GetV2LoggingOptions operation returned by the service.
     * @throws InternalException
     *         An unexpected error has occurred.
     * @throws NotConfiguredException
     *         The resource is not configured.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.GetV2LoggingOptions
     */
    default GetV2LoggingOptionsResponse getV2LoggingOptions(
            Consumer<GetV2LoggingOptionsRequest.Builder> getV2LoggingOptionsRequest) throws InternalException,
            NotConfiguredException, ServiceUnavailableException, AwsServiceException, SdkClientException, IotException {
        return getV2LoggingOptions(GetV2LoggingOptionsRequest.builder().applyMutation(getV2LoggingOptionsRequest).build());
    }

    /**
     * <p>
     * Lists the active violations for a given Device Defender security profile.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListActiveViolations</a> action.
     * </p>
     *
     * @param listActiveViolationsRequest
     * @return Result of the ListActiveViolations operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListActiveViolations
     */
    default ListActiveViolationsResponse listActiveViolations(ListActiveViolationsRequest listActiveViolationsRequest)
            throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, InternalFailureException,
            AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the active violations for a given Device Defender security profile.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListActiveViolations</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListActiveViolationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListActiveViolationsRequest#builder()}
     * </p>
     *
     * @param listActiveViolationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.ListActiveViolationsRequest.Builder} to create a request.
     * @return Result of the ListActiveViolations operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListActiveViolations
     */
    default ListActiveViolationsResponse listActiveViolations(
            Consumer<ListActiveViolationsRequest.Builder> listActiveViolationsRequest) throws InvalidRequestException,
            ResourceNotFoundException, ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException,
            IotException {
        return listActiveViolations(ListActiveViolationsRequest.builder().applyMutation(listActiveViolationsRequest).build());
    }

    /**
     * <p>
     * Lists the active violations for a given Device Defender security profile.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListActiveViolations</a> action.
     * </p>
     *
     * @return Result of the ListActiveViolations operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListActiveViolations
     * @see #listActiveViolations(ListActiveViolationsRequest)
     */
    default ListActiveViolationsResponse listActiveViolations() throws InvalidRequestException, ResourceNotFoundException,
            ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException, IotException {
        return listActiveViolations(ListActiveViolationsRequest.builder().build());
    }

    /**
     * <p>
     * Lists the active violations for a given Device Defender security profile.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListActiveViolations</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listActiveViolations(software.amazon.awssdk.services.iot.model.ListActiveViolationsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.ListActiveViolationsIterable responses = client.listActiveViolationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iot.paginators.ListActiveViolationsIterable responses = client
     *             .listActiveViolationsPaginator(request);
     *     for (software.amazon.awssdk.services.iot.model.ListActiveViolationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.ListActiveViolationsIterable responses = client.listActiveViolationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listActiveViolations(software.amazon.awssdk.services.iot.model.ListActiveViolationsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListActiveViolations
     * @see #listActiveViolationsPaginator(ListActiveViolationsRequest)
     */
    default ListActiveViolationsIterable listActiveViolationsPaginator() throws InvalidRequestException,
            ResourceNotFoundException, ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException,
            IotException {
        return listActiveViolationsPaginator(ListActiveViolationsRequest.builder().build());
    }

    /**
     * <p>
     * Lists the active violations for a given Device Defender security profile.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListActiveViolations</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listActiveViolations(software.amazon.awssdk.services.iot.model.ListActiveViolationsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.ListActiveViolationsIterable responses = client.listActiveViolationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iot.paginators.ListActiveViolationsIterable responses = client
     *             .listActiveViolationsPaginator(request);
     *     for (software.amazon.awssdk.services.iot.model.ListActiveViolationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.ListActiveViolationsIterable responses = client.listActiveViolationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listActiveViolations(software.amazon.awssdk.services.iot.model.ListActiveViolationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listActiveViolationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListActiveViolations
     */
    default ListActiveViolationsIterable listActiveViolationsPaginator(ListActiveViolationsRequest listActiveViolationsRequest)
            throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, InternalFailureException,
            AwsServiceException, SdkClientException, IotException {
        return new ListActiveViolationsIterable(this, listActiveViolationsRequest);
    }

    /**
     * <p>
     * Lists the active violations for a given Device Defender security profile.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListActiveViolations</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listActiveViolations(software.amazon.awssdk.services.iot.model.ListActiveViolationsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.ListActiveViolationsIterable responses = client.listActiveViolationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iot.paginators.ListActiveViolationsIterable responses = client
     *             .listActiveViolationsPaginator(request);
     *     for (software.amazon.awssdk.services.iot.model.ListActiveViolationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.ListActiveViolationsIterable responses = client.listActiveViolationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listActiveViolations(software.amazon.awssdk.services.iot.model.ListActiveViolationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListActiveViolationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListActiveViolationsRequest#builder()}
     * </p>
     *
     * @param listActiveViolationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.ListActiveViolationsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListActiveViolations
     */
    default ListActiveViolationsIterable listActiveViolationsPaginator(
            Consumer<ListActiveViolationsRequest.Builder> listActiveViolationsRequest) throws InvalidRequestException,
            ResourceNotFoundException, ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException,
            IotException {
        return listActiveViolationsPaginator(ListActiveViolationsRequest.builder().applyMutation(listActiveViolationsRequest)
                .build());
    }

    /**
     * <p>
     * Lists the policies attached to the specified thing group.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListAttachedPolicies</a> action.
     * </p>
     *
     * @param listAttachedPoliciesRequest
     * @return Result of the ListAttachedPolicies operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListAttachedPolicies
     */
    default ListAttachedPoliciesResponse listAttachedPolicies(ListAttachedPoliciesRequest listAttachedPoliciesRequest)
            throws ResourceNotFoundException, InvalidRequestException, ThrottlingException, UnauthorizedException,
            ServiceUnavailableException, InternalFailureException, LimitExceededException, AwsServiceException,
            SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the policies attached to the specified thing group.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListAttachedPolicies</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAttachedPoliciesRequest.Builder} avoiding the
     * need to create one manually via {@link ListAttachedPoliciesRequest#builder()}
     * </p>
     *
     * @param listAttachedPoliciesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.ListAttachedPoliciesRequest.Builder} to create a request.
     * @return Result of the ListAttachedPolicies operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListAttachedPolicies
     */
    default ListAttachedPoliciesResponse listAttachedPolicies(
            Consumer<ListAttachedPoliciesRequest.Builder> listAttachedPoliciesRequest) throws ResourceNotFoundException,
            InvalidRequestException, ThrottlingException, UnauthorizedException, ServiceUnavailableException,
            InternalFailureException, LimitExceededException, AwsServiceException, SdkClientException, IotException {
        return listAttachedPolicies(ListAttachedPoliciesRequest.builder().applyMutation(listAttachedPoliciesRequest).build());
    }

    /**
     * <p>
     * Lists the policies attached to the specified thing group.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListAttachedPolicies</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAttachedPolicies(software.amazon.awssdk.services.iot.model.ListAttachedPoliciesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.ListAttachedPoliciesIterable responses = client.listAttachedPoliciesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iot.paginators.ListAttachedPoliciesIterable responses = client
     *             .listAttachedPoliciesPaginator(request);
     *     for (software.amazon.awssdk.services.iot.model.ListAttachedPoliciesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.ListAttachedPoliciesIterable responses = client.listAttachedPoliciesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of pageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAttachedPolicies(software.amazon.awssdk.services.iot.model.ListAttachedPoliciesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAttachedPoliciesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListAttachedPolicies
     */
    default ListAttachedPoliciesIterable listAttachedPoliciesPaginator(ListAttachedPoliciesRequest listAttachedPoliciesRequest)
            throws ResourceNotFoundException, InvalidRequestException, ThrottlingException, UnauthorizedException,
            ServiceUnavailableException, InternalFailureException, LimitExceededException, AwsServiceException,
            SdkClientException, IotException {
        return new ListAttachedPoliciesIterable(this, listAttachedPoliciesRequest);
    }

    /**
     * <p>
     * Lists the policies attached to the specified thing group.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListAttachedPolicies</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAttachedPolicies(software.amazon.awssdk.services.iot.model.ListAttachedPoliciesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.ListAttachedPoliciesIterable responses = client.listAttachedPoliciesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iot.paginators.ListAttachedPoliciesIterable responses = client
     *             .listAttachedPoliciesPaginator(request);
     *     for (software.amazon.awssdk.services.iot.model.ListAttachedPoliciesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.ListAttachedPoliciesIterable responses = client.listAttachedPoliciesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of pageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAttachedPolicies(software.amazon.awssdk.services.iot.model.ListAttachedPoliciesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAttachedPoliciesRequest.Builder} avoiding the
     * need to create one manually via {@link ListAttachedPoliciesRequest#builder()}
     * </p>
     *
     * @param listAttachedPoliciesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.ListAttachedPoliciesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws LimitExceededException
     *         A limit has been exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListAttachedPolicies
     */
    default ListAttachedPoliciesIterable listAttachedPoliciesPaginator(
            Consumer<ListAttachedPoliciesRequest.Builder> listAttachedPoliciesRequest) throws ResourceNotFoundException,
            InvalidRequestException, ThrottlingException, UnauthorizedException, ServiceUnavailableException,
            InternalFailureException, LimitExceededException, AwsServiceException, SdkClientException, IotException {
        return listAttachedPoliciesPaginator(ListAttachedPoliciesRequest.builder().applyMutation(listAttachedPoliciesRequest)
                .build());
    }

    /**
     * <p>
     * Lists the findings (results) of a Device Defender audit or of the audits performed during a specified time
     * period. (Findings are retained for 90 days.)
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListAuditFindings</a> action.
     * </p>
     *
     * @param listAuditFindingsRequest
     * @return Result of the ListAuditFindings operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListAuditFindings
     */
    default ListAuditFindingsResponse listAuditFindings(ListAuditFindingsRequest listAuditFindingsRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the findings (results) of a Device Defender audit or of the audits performed during a specified time
     * period. (Findings are retained for 90 days.)
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListAuditFindings</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAuditFindingsRequest.Builder} avoiding the need
     * to create one manually via {@link ListAuditFindingsRequest#builder()}
     * </p>
     *
     * @param listAuditFindingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.ListAuditFindingsRequest.Builder} to create a request.
     * @return Result of the ListAuditFindings operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListAuditFindings
     */
    default ListAuditFindingsResponse listAuditFindings(Consumer<ListAuditFindingsRequest.Builder> listAuditFindingsRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        return listAuditFindings(ListAuditFindingsRequest.builder().applyMutation(listAuditFindingsRequest).build());
    }

    /**
     * <p>
     * Lists the findings (results) of a Device Defender audit or of the audits performed during a specified time
     * period. (Findings are retained for 90 days.)
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListAuditFindings</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAuditFindings(software.amazon.awssdk.services.iot.model.ListAuditFindingsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.ListAuditFindingsIterable responses = client.listAuditFindingsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iot.paginators.ListAuditFindingsIterable responses = client
     *             .listAuditFindingsPaginator(request);
     *     for (software.amazon.awssdk.services.iot.model.ListAuditFindingsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.ListAuditFindingsIterable responses = client.listAuditFindingsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAuditFindings(software.amazon.awssdk.services.iot.model.ListAuditFindingsRequest)} operation.</b>
     * </p>
     *
     * @param listAuditFindingsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListAuditFindings
     */
    default ListAuditFindingsIterable listAuditFindingsPaginator(ListAuditFindingsRequest listAuditFindingsRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        return new ListAuditFindingsIterable(this, listAuditFindingsRequest);
    }

    /**
     * <p>
     * Lists the findings (results) of a Device Defender audit or of the audits performed during a specified time
     * period. (Findings are retained for 90 days.)
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListAuditFindings</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAuditFindings(software.amazon.awssdk.services.iot.model.ListAuditFindingsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.ListAuditFindingsIterable responses = client.listAuditFindingsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iot.paginators.ListAuditFindingsIterable responses = client
     *             .listAuditFindingsPaginator(request);
     *     for (software.amazon.awssdk.services.iot.model.ListAuditFindingsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.ListAuditFindingsIterable responses = client.listAuditFindingsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAuditFindings(software.amazon.awssdk.services.iot.model.ListAuditFindingsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAuditFindingsRequest.Builder} avoiding the need
     * to create one manually via {@link ListAuditFindingsRequest#builder()}
     * </p>
     *
     * @param listAuditFindingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.ListAuditFindingsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListAuditFindings
     */
    default ListAuditFindingsIterable listAuditFindingsPaginator(
            Consumer<ListAuditFindingsRequest.Builder> listAuditFindingsRequest) throws InvalidRequestException,
            ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException, IotException {
        return listAuditFindingsPaginator(ListAuditFindingsRequest.builder().applyMutation(listAuditFindingsRequest).build());
    }

    /**
     * <p>
     * Gets the status of audit mitigation action tasks that were executed.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListAuditMitigationActionsExecutions</a> action.
     * </p>
     *
     * @param listAuditMitigationActionsExecutionsRequest
     * @return Result of the ListAuditMitigationActionsExecutions operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListAuditMitigationActionsExecutions
     */
    default ListAuditMitigationActionsExecutionsResponse listAuditMitigationActionsExecutions(
            ListAuditMitigationActionsExecutionsRequest listAuditMitigationActionsExecutionsRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the status of audit mitigation action tasks that were executed.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListAuditMitigationActionsExecutions</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListAuditMitigationActionsExecutionsRequest.Builder} avoiding the need to create one manually via
     * {@link ListAuditMitigationActionsExecutionsRequest#builder()}
     * </p>
     *
     * @param listAuditMitigationActionsExecutionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.ListAuditMitigationActionsExecutionsRequest.Builder} to
     *        create a request.
     * @return Result of the ListAuditMitigationActionsExecutions operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListAuditMitigationActionsExecutions
     */
    default ListAuditMitigationActionsExecutionsResponse listAuditMitigationActionsExecutions(
            Consumer<ListAuditMitigationActionsExecutionsRequest.Builder> listAuditMitigationActionsExecutionsRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        return listAuditMitigationActionsExecutions(ListAuditMitigationActionsExecutionsRequest.builder()
                .applyMutation(listAuditMitigationActionsExecutionsRequest).build());
    }

    /**
     * <p>
     * Gets the status of audit mitigation action tasks that were executed.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListAuditMitigationActionsExecutions</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAuditMitigationActionsExecutions(software.amazon.awssdk.services.iot.model.ListAuditMitigationActionsExecutionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.ListAuditMitigationActionsExecutionsIterable responses = client.listAuditMitigationActionsExecutionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iot.paginators.ListAuditMitigationActionsExecutionsIterable responses = client
     *             .listAuditMitigationActionsExecutionsPaginator(request);
     *     for (software.amazon.awssdk.services.iot.model.ListAuditMitigationActionsExecutionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.ListAuditMitigationActionsExecutionsIterable responses = client.listAuditMitigationActionsExecutionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAuditMitigationActionsExecutions(software.amazon.awssdk.services.iot.model.ListAuditMitigationActionsExecutionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAuditMitigationActionsExecutionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListAuditMitigationActionsExecutions
     */
    default ListAuditMitigationActionsExecutionsIterable listAuditMitigationActionsExecutionsPaginator(
            ListAuditMitigationActionsExecutionsRequest listAuditMitigationActionsExecutionsRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        return new ListAuditMitigationActionsExecutionsIterable(this, listAuditMitigationActionsExecutionsRequest);
    }

    /**
     * <p>
     * Gets the status of audit mitigation action tasks that were executed.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListAuditMitigationActionsExecutions</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAuditMitigationActionsExecutions(software.amazon.awssdk.services.iot.model.ListAuditMitigationActionsExecutionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.ListAuditMitigationActionsExecutionsIterable responses = client.listAuditMitigationActionsExecutionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iot.paginators.ListAuditMitigationActionsExecutionsIterable responses = client
     *             .listAuditMitigationActionsExecutionsPaginator(request);
     *     for (software.amazon.awssdk.services.iot.model.ListAuditMitigationActionsExecutionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.ListAuditMitigationActionsExecutionsIterable responses = client.listAuditMitigationActionsExecutionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAuditMitigationActionsExecutions(software.amazon.awssdk.services.iot.model.ListAuditMitigationActionsExecutionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListAuditMitigationActionsExecutionsRequest.Builder} avoiding the need to create one manually via
     * {@link ListAuditMitigationActionsExecutionsRequest#builder()}
     * </p>
     *
     * @param listAuditMitigationActionsExecutionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.ListAuditMitigationActionsExecutionsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListAuditMitigationActionsExecutions
     */
    default ListAuditMitigationActionsExecutionsIterable listAuditMitigationActionsExecutionsPaginator(
            Consumer<ListAuditMitigationActionsExecutionsRequest.Builder> listAuditMitigationActionsExecutionsRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        return listAuditMitigationActionsExecutionsPaginator(ListAuditMitigationActionsExecutionsRequest.builder()
                .applyMutation(listAuditMitigationActionsExecutionsRequest).build());
    }

    /**
     * <p>
     * Gets a list of audit mitigation action tasks that match the specified filters.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListAuditMitigationActionsTasks</a> action.
     * </p>
     *
     * @param listAuditMitigationActionsTasksRequest
     * @return Result of the ListAuditMitigationActionsTasks operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListAuditMitigationActionsTasks
     */
    default ListAuditMitigationActionsTasksResponse listAuditMitigationActionsTasks(
            ListAuditMitigationActionsTasksRequest listAuditMitigationActionsTasksRequest) throws InvalidRequestException,
            ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of audit mitigation action tasks that match the specified filters.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListAuditMitigationActionsTasks</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAuditMitigationActionsTasksRequest.Builder}
     * avoiding the need to create one manually via {@link ListAuditMitigationActionsTasksRequest#builder()}
     * </p>
     *
     * @param listAuditMitigationActionsTasksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.ListAuditMitigationActionsTasksRequest.Builder} to create
     *        a request.
     * @return Result of the ListAuditMitigationActionsTasks operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListAuditMitigationActionsTasks
     */
    default ListAuditMitigationActionsTasksResponse listAuditMitigationActionsTasks(
            Consumer<ListAuditMitigationActionsTasksRequest.Builder> listAuditMitigationActionsTasksRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        return listAuditMitigationActionsTasks(ListAuditMitigationActionsTasksRequest.builder()
                .applyMutation(listAuditMitigationActionsTasksRequest).build());
    }

    /**
     * <p>
     * Gets a list of audit mitigation action tasks that match the specified filters.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListAuditMitigationActionsTasks</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAuditMitigationActionsTasks(software.amazon.awssdk.services.iot.model.ListAuditMitigationActionsTasksRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.ListAuditMitigationActionsTasksIterable responses = client.listAuditMitigationActionsTasksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iot.paginators.ListAuditMitigationActionsTasksIterable responses = client
     *             .listAuditMitigationActionsTasksPaginator(request);
     *     for (software.amazon.awssdk.services.iot.model.ListAuditMitigationActionsTasksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.ListAuditMitigationActionsTasksIterable responses = client.listAuditMitigationActionsTasksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAuditMitigationActionsTasks(software.amazon.awssdk.services.iot.model.ListAuditMitigationActionsTasksRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAuditMitigationActionsTasksRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListAuditMitigationActionsTasks
     */
    default ListAuditMitigationActionsTasksIterable listAuditMitigationActionsTasksPaginator(
            ListAuditMitigationActionsTasksRequest listAuditMitigationActionsTasksRequest) throws InvalidRequestException,
            ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException, IotException {
        return new ListAuditMitigationActionsTasksIterable(this, listAuditMitigationActionsTasksRequest);
    }

    /**
     * <p>
     * Gets a list of audit mitigation action tasks that match the specified filters.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListAuditMitigationActionsTasks</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAuditMitigationActionsTasks(software.amazon.awssdk.services.iot.model.ListAuditMitigationActionsTasksRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.ListAuditMitigationActionsTasksIterable responses = client.listAuditMitigationActionsTasksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iot.paginators.ListAuditMitigationActionsTasksIterable responses = client
     *             .listAuditMitigationActionsTasksPaginator(request);
     *     for (software.amazon.awssdk.services.iot.model.ListAuditMitigationActionsTasksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.ListAuditMitigationActionsTasksIterable responses = client.listAuditMitigationActionsTasksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAuditMitigationActionsTasks(software.amazon.awssdk.services.iot.model.ListAuditMitigationActionsTasksRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAuditMitigationActionsTasksRequest.Builder}
     * avoiding the need to create one manually via {@link ListAuditMitigationActionsTasksRequest#builder()}
     * </p>
     *
     * @param listAuditMitigationActionsTasksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.ListAuditMitigationActionsTasksRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListAuditMitigationActionsTasks
     */
    default ListAuditMitigationActionsTasksIterable listAuditMitigationActionsTasksPaginator(
            Consumer<ListAuditMitigationActionsTasksRequest.Builder> listAuditMitigationActionsTasksRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        return listAuditMitigationActionsTasksPaginator(ListAuditMitigationActionsTasksRequest.builder()
                .applyMutation(listAuditMitigationActionsTasksRequest).build());
    }

    /**
     * <p>
     * Lists your Device Defender audit listings.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListAuditSuppressions</a> action.
     * </p>
     *
     * @param listAuditSuppressionsRequest
     * @return Result of the ListAuditSuppressions operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListAuditSuppressions
     */
    default ListAuditSuppressionsResponse listAuditSuppressions(ListAuditSuppressionsRequest listAuditSuppressionsRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists your Device Defender audit listings.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListAuditSuppressions</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAuditSuppressionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAuditSuppressionsRequest#builder()}
     * </p>
     *
     * @param listAuditSuppressionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.ListAuditSuppressionsRequest.Builder} to create a
     *        request.
     * @return Result of the ListAuditSuppressions operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListAuditSuppressions
     */
    default ListAuditSuppressionsResponse listAuditSuppressions(
            Consumer<ListAuditSuppressionsRequest.Builder> listAuditSuppressionsRequest) throws InvalidRequestException,
            ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException, IotException {
        return listAuditSuppressions(ListAuditSuppressionsRequest.builder().applyMutation(listAuditSuppressionsRequest).build());
    }

    /**
     * <p>
     * Lists your Device Defender audit listings.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListAuditSuppressions</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAuditSuppressions(software.amazon.awssdk.services.iot.model.ListAuditSuppressionsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.ListAuditSuppressionsIterable responses = client.listAuditSuppressionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iot.paginators.ListAuditSuppressionsIterable responses = client
     *             .listAuditSuppressionsPaginator(request);
     *     for (software.amazon.awssdk.services.iot.model.ListAuditSuppressionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.ListAuditSuppressionsIterable responses = client.listAuditSuppressionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAuditSuppressions(software.amazon.awssdk.services.iot.model.ListAuditSuppressionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAuditSuppressionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListAuditSuppressions
     */
    default ListAuditSuppressionsIterable listAuditSuppressionsPaginator(ListAuditSuppressionsRequest listAuditSuppressionsRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        return new ListAuditSuppressionsIterable(this, listAuditSuppressionsRequest);
    }

    /**
     * <p>
     * Lists your Device Defender audit listings.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListAuditSuppressions</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAuditSuppressions(software.amazon.awssdk.services.iot.model.ListAuditSuppressionsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.ListAuditSuppressionsIterable responses = client.listAuditSuppressionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iot.paginators.ListAuditSuppressionsIterable responses = client
     *             .listAuditSuppressionsPaginator(request);
     *     for (software.amazon.awssdk.services.iot.model.ListAuditSuppressionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.ListAuditSuppressionsIterable responses = client.listAuditSuppressionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAuditSuppressions(software.amazon.awssdk.services.iot.model.ListAuditSuppressionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAuditSuppressionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAuditSuppressionsRequest#builder()}
     * </p>
     *
     * @param listAuditSuppressionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.ListAuditSuppressionsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListAuditSuppressions
     */
    default ListAuditSuppressionsIterable listAuditSuppressionsPaginator(
            Consumer<ListAuditSuppressionsRequest.Builder> listAuditSuppressionsRequest) throws InvalidRequestException,
            ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException, IotException {
        return listAuditSuppressionsPaginator(ListAuditSuppressionsRequest.builder().applyMutation(listAuditSuppressionsRequest)
                .build());
    }

    /**
     * <p>
     * Lists the Device Defender audits that have been performed during a given time period.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListAuditTasks</a> action.
     * </p>
     *
     * @param listAuditTasksRequest
     * @return Result of the ListAuditTasks operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListAuditTasks
     */
    default ListAuditTasksResponse listAuditTasks(ListAuditTasksRequest listAuditTasksRequest) throws InvalidRequestException,
            ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the Device Defender audits that have been performed during a given time period.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListAuditTasks</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAuditTasksRequest.Builder} avoiding the need to
     * create one manually via {@link ListAuditTasksRequest#builder()}
     * </p>
     *
     * @param listAuditTasksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.ListAuditTasksRequest.Builder} to create a request.
     * @return Result of the ListAuditTasks operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListAuditTasks
     */
    default ListAuditTasksResponse listAuditTasks(Consumer<ListAuditTasksRequest.Builder> listAuditTasksRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        return listAuditTasks(ListAuditTasksRequest.builder().applyMutation(listAuditTasksRequest).build());
    }

    /**
     * <p>
     * Lists the Device Defender audits that have been performed during a given time period.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListAuditTasks</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listAuditTasks(software.amazon.awssdk.services.iot.model.ListAuditTasksRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.ListAuditTasksIterable responses = client.listAuditTasksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iot.paginators.ListAuditTasksIterable responses = client.listAuditTasksPaginator(request);
     *     for (software.amazon.awssdk.services.iot.model.ListAuditTasksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.ListAuditTasksIterable responses = client.listAuditTasksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAuditTasks(software.amazon.awssdk.services.iot.model.ListAuditTasksRequest)} operation.</b>
     * </p>
     *
     * @param listAuditTasksRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListAuditTasks
     */
    default ListAuditTasksIterable listAuditTasksPaginator(ListAuditTasksRequest listAuditTasksRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        return new ListAuditTasksIterable(this, listAuditTasksRequest);
    }

    /**
     * <p>
     * Lists the Device Defender audits that have been performed during a given time period.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListAuditTasks</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listAuditTasks(software.amazon.awssdk.services.iot.model.ListAuditTasksRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.ListAuditTasksIterable responses = client.listAuditTasksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iot.paginators.ListAuditTasksIterable responses = client.listAuditTasksPaginator(request);
     *     for (software.amazon.awssdk.services.iot.model.ListAuditTasksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.ListAuditTasksIterable responses = client.listAuditTasksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAuditTasks(software.amazon.awssdk.services.iot.model.ListAuditTasksRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAuditTasksRequest.Builder} avoiding the need to
     * create one manually via {@link ListAuditTasksRequest#builder()}
     * </p>
     *
     * @param listAuditTasksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.ListAuditTasksRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListAuditTasks
     */
    default ListAuditTasksIterable listAuditTasksPaginator(Consumer<ListAuditTasksRequest.Builder> listAuditTasksRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        return listAuditTasksPaginator(ListAuditTasksRequest.builder().applyMutation(listAuditTasksRequest).build());
    }

    /**
     * <p>
     * Lists the authorizers registered in your account.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListAuthorizers</a> action.
     * </p>
     *
     * @param listAuthorizersRequest
     * @return Result of the ListAuthorizers operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListAuthorizers
     */
    default ListAuthorizersResponse listAuthorizers(ListAuthorizersRequest listAuthorizersRequest)
            throws InvalidRequestException, ThrottlingException, UnauthorizedException, ServiceUnavailableException,
            InternalFailureException, AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the authorizers registered in your account.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListAuthorizers</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAuthorizersRequest.Builder} avoiding the need
     * to create one manually via {@link ListAuthorizersRequest#builder()}
     * </p>
     *
     * @param listAuthorizersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.ListAuthorizersRequest.Builder} to create a request.
     * @return Result of the ListAuthorizers operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListAuthorizers
     */
    default ListAuthorizersResponse listAuthorizers(Consumer<ListAuthorizersRequest.Builder> listAuthorizersRequest)
            throws InvalidRequestException, ThrottlingException, UnauthorizedException, ServiceUnavailableException,
            InternalFailureException, AwsServiceException, SdkClientException, IotException {
        return listAuthorizers(ListAuthorizersRequest.builder().applyMutation(listAuthorizersRequest).build());
    }

    /**
     * <p>
     * Lists the authorizers registered in your account.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListAuthorizers</a> action.
     * </p>
     *
     * @return Result of the ListAuthorizers operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListAuthorizers
     * @see #listAuthorizers(ListAuthorizersRequest)
     */
    default ListAuthorizersResponse listAuthorizers() throws InvalidRequestException, ThrottlingException, UnauthorizedException,
            ServiceUnavailableException, InternalFailureException, AwsServiceException, SdkClientException, IotException {
        return listAuthorizers(ListAuthorizersRequest.builder().build());
    }

    /**
     * <p>
     * Lists the authorizers registered in your account.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListAuthorizers</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listAuthorizers(software.amazon.awssdk.services.iot.model.ListAuthorizersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.ListAuthorizersIterable responses = client.listAuthorizersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iot.paginators.ListAuthorizersIterable responses = client.listAuthorizersPaginator(request);
     *     for (software.amazon.awssdk.services.iot.model.ListAuthorizersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.ListAuthorizersIterable responses = client.listAuthorizersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of pageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAuthorizers(software.amazon.awssdk.services.iot.model.ListAuthorizersRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListAuthorizers
     * @see #listAuthorizersPaginator(ListAuthorizersRequest)
     */
    default ListAuthorizersIterable listAuthorizersPaginator() throws InvalidRequestException, ThrottlingException,
            UnauthorizedException, ServiceUnavailableException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        return listAuthorizersPaginator(ListAuthorizersRequest.builder().build());
    }

    /**
     * <p>
     * Lists the authorizers registered in your account.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListAuthorizers</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listAuthorizers(software.amazon.awssdk.services.iot.model.ListAuthorizersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.ListAuthorizersIterable responses = client.listAuthorizersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iot.paginators.ListAuthorizersIterable responses = client.listAuthorizersPaginator(request);
     *     for (software.amazon.awssdk.services.iot.model.ListAuthorizersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.ListAuthorizersIterable responses = client.listAuthorizersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of pageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAuthorizers(software.amazon.awssdk.services.iot.model.ListAuthorizersRequest)} operation.</b>
     * </p>
     *
     * @param listAuthorizersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListAuthorizers
     */
    default ListAuthorizersIterable listAuthorizersPaginator(ListAuthorizersRequest listAuthorizersRequest)
            throws InvalidRequestException, ThrottlingException, UnauthorizedException, ServiceUnavailableException,
            InternalFailureException, AwsServiceException, SdkClientException, IotException {
        return new ListAuthorizersIterable(this, listAuthorizersRequest);
    }

    /**
     * <p>
     * Lists the authorizers registered in your account.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListAuthorizers</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listAuthorizers(software.amazon.awssdk.services.iot.model.ListAuthorizersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.ListAuthorizersIterable responses = client.listAuthorizersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iot.paginators.ListAuthorizersIterable responses = client.listAuthorizersPaginator(request);
     *     for (software.amazon.awssdk.services.iot.model.ListAuthorizersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.ListAuthorizersIterable responses = client.listAuthorizersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of pageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAuthorizers(software.amazon.awssdk.services.iot.model.ListAuthorizersRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAuthorizersRequest.Builder} avoiding the need
     * to create one manually via {@link ListAuthorizersRequest#builder()}
     * </p>
     *
     * @param listAuthorizersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.ListAuthorizersRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListAuthorizers
     */
    default ListAuthorizersIterable listAuthorizersPaginator(Consumer<ListAuthorizersRequest.Builder> listAuthorizersRequest)
            throws InvalidRequestException, ThrottlingException, UnauthorizedException, ServiceUnavailableException,
            InternalFailureException, AwsServiceException, SdkClientException, IotException {
        return listAuthorizersPaginator(ListAuthorizersRequest.builder().applyMutation(listAuthorizersRequest).build());
    }

    /**
     * <p>
     * Lists the billing groups you have created.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListBillingGroups</a> action.
     * </p>
     *
     * @param listBillingGroupsRequest
     * @return Result of the ListBillingGroups operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListBillingGroups
     */
    default ListBillingGroupsResponse listBillingGroups(ListBillingGroupsRequest listBillingGroupsRequest)
            throws InvalidRequestException, InternalFailureException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the billing groups you have created.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListBillingGroups</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBillingGroupsRequest.Builder} avoiding the need
     * to create one manually via {@link ListBillingGroupsRequest#builder()}
     * </p>
     *
     * @param listBillingGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.ListBillingGroupsRequest.Builder} to create a request.
     * @return Result of the ListBillingGroups operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListBillingGroups
     */
    default ListBillingGroupsResponse listBillingGroups(Consumer<ListBillingGroupsRequest.Builder> listBillingGroupsRequest)
            throws InvalidRequestException, InternalFailureException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, IotException {
        return listBillingGroups(ListBillingGroupsRequest.builder().applyMutation(listBillingGroupsRequest).build());
    }

    /**
     * <p>
     * Lists the billing groups you have created.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListBillingGroups</a> action.
     * </p>
     *
     * @return Result of the ListBillingGroups operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListBillingGroups
     * @see #listBillingGroups(ListBillingGroupsRequest)
     */
    default ListBillingGroupsResponse listBillingGroups() throws InvalidRequestException, InternalFailureException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, IotException {
        return listBillingGroups(ListBillingGroupsRequest.builder().build());
    }

    /**
     * <p>
     * Lists the billing groups you have created.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListBillingGroups</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBillingGroups(software.amazon.awssdk.services.iot.model.ListBillingGroupsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.ListBillingGroupsIterable responses = client.listBillingGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iot.paginators.ListBillingGroupsIterable responses = client
     *             .listBillingGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.iot.model.ListBillingGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.ListBillingGroupsIterable responses = client.listBillingGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBillingGroups(software.amazon.awssdk.services.iot.model.ListBillingGroupsRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListBillingGroups
     * @see #listBillingGroupsPaginator(ListBillingGroupsRequest)
     */
    default ListBillingGroupsIterable listBillingGroupsPaginator() throws InvalidRequestException, InternalFailureException,
            ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, IotException {
        return listBillingGroupsPaginator(ListBillingGroupsRequest.builder().build());
    }

    /**
     * <p>
     * Lists the billing groups you have created.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListBillingGroups</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBillingGroups(software.amazon.awssdk.services.iot.model.ListBillingGroupsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.ListBillingGroupsIterable responses = client.listBillingGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iot.paginators.ListBillingGroupsIterable responses = client
     *             .listBillingGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.iot.model.ListBillingGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.ListBillingGroupsIterable responses = client.listBillingGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBillingGroups(software.amazon.awssdk.services.iot.model.ListBillingGroupsRequest)} operation.</b>
     * </p>
     *
     * @param listBillingGroupsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListBillingGroups
     */
    default ListBillingGroupsIterable listBillingGroupsPaginator(ListBillingGroupsRequest listBillingGroupsRequest)
            throws InvalidRequestException, InternalFailureException, ResourceNotFoundException, ThrottlingException,
            AwsServiceException, SdkClientException, IotException {
        return new ListBillingGroupsIterable(this, listBillingGroupsRequest);
    }

    /**
     * <p>
     * Lists the billing groups you have created.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListBillingGroups</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBillingGroups(software.amazon.awssdk.services.iot.model.ListBillingGroupsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.ListBillingGroupsIterable responses = client.listBillingGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iot.paginators.ListBillingGroupsIterable responses = client
     *             .listBillingGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.iot.model.ListBillingGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.ListBillingGroupsIterable responses = client.listBillingGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBillingGroups(software.amazon.awssdk.services.iot.model.ListBillingGroupsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBillingGroupsRequest.Builder} avoiding the need
     * to create one manually via {@link ListBillingGroupsRequest#builder()}
     * </p>
     *
     * @param listBillingGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.ListBillingGroupsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListBillingGroups
     */
    default ListBillingGroupsIterable listBillingGroupsPaginator(
            Consumer<ListBillingGroupsRequest.Builder> listBillingGroupsRequest) throws InvalidRequestException,
            InternalFailureException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException,
            IotException {
        return listBillingGroupsPaginator(ListBillingGroupsRequest.builder().applyMutation(listBillingGroupsRequest).build());
    }

    /**
     * <p>
     * Lists the CA certificates registered for your Amazon Web Services account.
     * </p>
     * <p>
     * The results are paginated with a default page size of 25. You can use the returned marker to retrieve additional
     * results.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListCACertificates</a> action.
     * </p>
     *
     * @param listCaCertificatesRequest
     *        Input for the ListCACertificates operation.
     * @return Result of the ListCACertificates operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListCACertificates
     */
    default ListCaCertificatesResponse listCACertificates(ListCaCertificatesRequest listCaCertificatesRequest)
            throws InvalidRequestException, ThrottlingException, UnauthorizedException, ServiceUnavailableException,
            InternalFailureException, AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the CA certificates registered for your Amazon Web Services account.
     * </p>
     * <p>
     * The results are paginated with a default page size of 25. You can use the returned marker to retrieve additional
     * results.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListCACertificates</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCaCertificatesRequest.Builder} avoiding the
     * need to create one manually via {@link ListCaCertificatesRequest#builder()}
     * </p>
     *
     * @param listCaCertificatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.ListCaCertificatesRequest.Builder} to create a request.
     *        Input for the ListCACertificates operation.
     * @return Result of the ListCACertificates operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListCACertificates
     */
    default ListCaCertificatesResponse listCACertificates(Consumer<ListCaCertificatesRequest.Builder> listCaCertificatesRequest)
            throws InvalidRequestException, ThrottlingException, UnauthorizedException, ServiceUnavailableException,
            InternalFailureException, AwsServiceException, SdkClientException, IotException {
        return listCACertificates(ListCaCertificatesRequest.builder().applyMutation(listCaCertificatesRequest).build());
    }

    /**
     * <p>
     * Lists the CA certificates registered for your Amazon Web Services account.
     * </p>
     * <p>
     * The results are paginated with a default page size of 25. You can use the returned marker to retrieve additional
     * results.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListCACertificates</a> action.
     * </p>
     *
     * @return Result of the ListCACertificates operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListCACertificates
     * @see #listCACertificates(ListCaCertificatesRequest)
     */
    default ListCaCertificatesResponse listCACertificates() throws InvalidRequestException, ThrottlingException,
            UnauthorizedException, ServiceUnavailableException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        return listCACertificates(ListCaCertificatesRequest.builder().build());
    }

    /**
     * <p>
     * Lists the CA certificates registered for your Amazon Web Services account.
     * </p>
     * <p>
     * The results are paginated with a default page size of 25. You can use the returned marker to retrieve additional
     * results.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListCACertificates</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCACertificates(software.amazon.awssdk.services.iot.model.ListCaCertificatesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.ListCACertificatesIterable responses = client.listCACertificatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iot.paginators.ListCACertificatesIterable responses = client
     *             .listCACertificatesPaginator(request);
     *     for (software.amazon.awssdk.services.iot.model.ListCaCertificatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.ListCACertificatesIterable responses = client.listCACertificatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of pageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCACertificates(software.amazon.awssdk.services.iot.model.ListCaCertificatesRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListCACertificates
     * @see #listCACertificatesPaginator(ListCaCertificatesRequest)
     */
    default ListCACertificatesIterable listCACertificatesPaginator() throws InvalidRequestException, ThrottlingException,
            UnauthorizedException, ServiceUnavailableException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        return listCACertificatesPaginator(ListCaCertificatesRequest.builder().build());
    }

    /**
     * <p>
     * Lists the CA certificates registered for your Amazon Web Services account.
     * </p>
     * <p>
     * The results are paginated with a default page size of 25. You can use the returned marker to retrieve additional
     * results.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListCACertificates</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCACertificates(software.amazon.awssdk.services.iot.model.ListCaCertificatesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.ListCACertificatesIterable responses = client.listCACertificatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iot.paginators.ListCACertificatesIterable responses = client
     *             .listCACertificatesPaginator(request);
     *     for (software.amazon.awssdk.services.iot.model.ListCaCertificatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.ListCACertificatesIterable responses = client.listCACertificatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of pageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCACertificates(software.amazon.awssdk.services.iot.model.ListCaCertificatesRequest)} operation.</b>
     * </p>
     *
     * @param listCaCertificatesRequest
     *        Input for the ListCACertificates operation.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListCACertificates
     */
    default ListCACertificatesIterable listCACertificatesPaginator(ListCaCertificatesRequest listCaCertificatesRequest)
            throws InvalidRequestException, ThrottlingException, UnauthorizedException, ServiceUnavailableException,
            InternalFailureException, AwsServiceException, SdkClientException, IotException {
        return new ListCACertificatesIterable(this, listCaCertificatesRequest);
    }

    /**
     * <p>
     * Lists the CA certificates registered for your Amazon Web Services account.
     * </p>
     * <p>
     * The results are paginated with a default page size of 25. You can use the returned marker to retrieve additional
     * results.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListCACertificates</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCACertificates(software.amazon.awssdk.services.iot.model.ListCaCertificatesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.ListCACertificatesIterable responses = client.listCACertificatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iot.paginators.ListCACertificatesIterable responses = client
     *             .listCACertificatesPaginator(request);
     *     for (software.amazon.awssdk.services.iot.model.ListCaCertificatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.ListCACertificatesIterable responses = client.listCACertificatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of pageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCACertificates(software.amazon.awssdk.services.iot.model.ListCaCertificatesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCaCertificatesRequest.Builder} avoiding the
     * need to create one manually via {@link ListCaCertificatesRequest#builder()}
     * </p>
     *
     * @param listCaCertificatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.ListCaCertificatesRequest.Builder} to create a request.
     *        Input for the ListCACertificates operation.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListCACertificates
     */
    default ListCACertificatesIterable listCACertificatesPaginator(
            Consumer<ListCaCertificatesRequest.Builder> listCaCertificatesRequest) throws InvalidRequestException,
            ThrottlingException, UnauthorizedException, ServiceUnavailableException, InternalFailureException,
            AwsServiceException, SdkClientException, IotException {
        return listCACertificatesPaginator(ListCaCertificatesRequest.builder().applyMutation(listCaCertificatesRequest).build());
    }

    /**
     * <p>
     * Lists all your certificate providers in your Amazon Web Services account.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListCertificateProviders</a> action.
     * </p>
     *
     * @param listCertificateProvidersRequest
     * @return Result of the ListCertificateProviders operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListCertificateProviders
     */
    default ListCertificateProvidersResponse listCertificateProviders(
            ListCertificateProvidersRequest listCertificateProvidersRequest) throws InvalidRequestException, ThrottlingException,
            UnauthorizedException, ServiceUnavailableException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all your certificate providers in your Amazon Web Services account.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListCertificateProviders</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCertificateProvidersRequest.Builder} avoiding
     * the need to create one manually via {@link ListCertificateProvidersRequest#builder()}
     * </p>
     *
     * @param listCertificateProvidersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.ListCertificateProvidersRequest.Builder} to create a
     *        request.
     * @return Result of the ListCertificateProviders operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListCertificateProviders
     */
    default ListCertificateProvidersResponse listCertificateProviders(
            Consumer<ListCertificateProvidersRequest.Builder> listCertificateProvidersRequest) throws InvalidRequestException,
            ThrottlingException, UnauthorizedException, ServiceUnavailableException, InternalFailureException,
            AwsServiceException, SdkClientException, IotException {
        return listCertificateProviders(ListCertificateProvidersRequest.builder().applyMutation(listCertificateProvidersRequest)
                .build());
    }

    /**
     * <p>
     * Lists the certificates registered in your Amazon Web Services account.
     * </p>
     * <p>
     * The results are paginated with a default page size of 25. You can use the returned marker to retrieve additional
     * results.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListCertificates</a> action.
     * </p>
     *
     * @param listCertificatesRequest
     *        The input for the ListCertificates operation.
     * @return Result of the ListCertificates operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListCertificates
     */
    default ListCertificatesResponse listCertificates(ListCertificatesRequest listCertificatesRequest)
            throws InvalidRequestException, ThrottlingException, UnauthorizedException, ServiceUnavailableException,
            InternalFailureException, AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the certificates registered in your Amazon Web Services account.
     * </p>
     * <p>
     * The results are paginated with a default page size of 25. You can use the returned marker to retrieve additional
     * results.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListCertificates</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCertificatesRequest.Builder} avoiding the need
     * to create one manually via {@link ListCertificatesRequest#builder()}
     * </p>
     *
     * @param listCertificatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.ListCertificatesRequest.Builder} to create a request. The
     *        input for the ListCertificates operation.
     * @return Result of the ListCertificates operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListCertificates
     */
    default ListCertificatesResponse listCertificates(Consumer<ListCertificatesRequest.Builder> listCertificatesRequest)
            throws InvalidRequestException, ThrottlingException, UnauthorizedException, ServiceUnavailableException,
            InternalFailureException, AwsServiceException, SdkClientException, IotException {
        return listCertificates(ListCertificatesRequest.builder().applyMutation(listCertificatesRequest).build());
    }

    /**
     * <p>
     * Lists the certificates registered in your Amazon Web Services account.
     * </p>
     * <p>
     * The results are paginated with a default page size of 25. You can use the returned marker to retrieve additional
     * results.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListCertificates</a> action.
     * </p>
     *
     * @return Result of the ListCertificates operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListCertificates
     * @see #listCertificates(ListCertificatesRequest)
     */
    default ListCertificatesResponse listCertificates() throws InvalidRequestException, ThrottlingException,
            UnauthorizedException, ServiceUnavailableException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        return listCertificates(ListCertificatesRequest.builder().build());
    }

    /**
     * <p>
     * Lists the certificates registered in your Amazon Web Services account.
     * </p>
     * <p>
     * The results are paginated with a default page size of 25. You can use the returned marker to retrieve additional
     * results.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListCertificates</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listCertificates(software.amazon.awssdk.services.iot.model.ListCertificatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.ListCertificatesIterable responses = client.listCertificatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iot.paginators.ListCertificatesIterable responses = client.listCertificatesPaginator(request);
     *     for (software.amazon.awssdk.services.iot.model.ListCertificatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.ListCertificatesIterable responses = client.listCertificatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of pageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCertificates(software.amazon.awssdk.services.iot.model.ListCertificatesRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListCertificates
     * @see #listCertificatesPaginator(ListCertificatesRequest)
     */
    default ListCertificatesIterable listCertificatesPaginator() throws InvalidRequestException, ThrottlingException,
            UnauthorizedException, ServiceUnavailableException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        return listCertificatesPaginator(ListCertificatesRequest.builder().build());
    }

    /**
     * <p>
     * Lists the certificates registered in your Amazon Web Services account.
     * </p>
     * <p>
     * The results are paginated with a default page size of 25. You can use the returned marker to retrieve additional
     * results.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListCertificates</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listCertificates(software.amazon.awssdk.services.iot.model.ListCertificatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.ListCertificatesIterable responses = client.listCertificatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iot.paginators.ListCertificatesIterable responses = client.listCertificatesPaginator(request);
     *     for (software.amazon.awssdk.services.iot.model.ListCertificatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.ListCertificatesIterable responses = client.listCertificatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of pageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCertificates(software.amazon.awssdk.services.iot.model.ListCertificatesRequest)} operation.</b>
     * </p>
     *
     * @param listCertificatesRequest
     *        The input for the ListCertificates operation.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListCertificates
     */
    default ListCertificatesIterable listCertificatesPaginator(ListCertificatesRequest listCertificatesRequest)
            throws InvalidRequestException, ThrottlingException, UnauthorizedException, ServiceUnavailableException,
            InternalFailureException, AwsServiceException, SdkClientException, IotException {
        return new ListCertificatesIterable(this, listCertificatesRequest);
    }

    /**
     * <p>
     * Lists the certificates registered in your Amazon Web Services account.
     * </p>
     * <p>
     * The results are paginated with a default page size of 25. You can use the returned marker to retrieve additional
     * results.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListCertificates</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listCertificates(software.amazon.awssdk.services.iot.model.ListCertificatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.ListCertificatesIterable responses = client.listCertificatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iot.paginators.ListCertificatesIterable responses = client.listCertificatesPaginator(request);
     *     for (software.amazon.awssdk.services.iot.model.ListCertificatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.ListCertificatesIterable responses = client.listCertificatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of pageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCertificates(software.amazon.awssdk.services.iot.model.ListCertificatesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCertificatesRequest.Builder} avoiding the need
     * to create one manually via {@link ListCertificatesRequest#builder()}
     * </p>
     *
     * @param listCertificatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.ListCertificatesRequest.Builder} to create a request. The
     *        input for the ListCertificates operation.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListCertificates
     */
    default ListCertificatesIterable listCertificatesPaginator(Consumer<ListCertificatesRequest.Builder> listCertificatesRequest)
            throws InvalidRequestException, ThrottlingException, UnauthorizedException, ServiceUnavailableException,
            InternalFailureException, AwsServiceException, SdkClientException, IotException {
        return listCertificatesPaginator(ListCertificatesRequest.builder().applyMutation(listCertificatesRequest).build());
    }

    /**
     * <p>
     * List the device certificates signed by the specified CA certificate.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListCertificatesByCA</a> action.
     * </p>
     *
     * @param listCertificatesByCaRequest
     *        The input to the ListCertificatesByCA operation.
     * @return Result of the ListCertificatesByCA operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListCertificatesByCA
     */
    default ListCertificatesByCaResponse listCertificatesByCA(ListCertificatesByCaRequest listCertificatesByCaRequest)
            throws InvalidRequestException, ThrottlingException, UnauthorizedException, ServiceUnavailableException,
            InternalFailureException, AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the device certificates signed by the specified CA certificate.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListCertificatesByCA</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCertificatesByCaRequest.Builder} avoiding the
     * need to create one manually via {@link ListCertificatesByCaRequest#builder()}
     * </p>
     *
     * @param listCertificatesByCaRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.ListCertificatesByCaRequest.Builder} to create a request.
     *        The input to the ListCertificatesByCA operation.
     * @return Result of the ListCertificatesByCA operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListCertificatesByCA
     */
    default ListCertificatesByCaResponse listCertificatesByCA(
            Consumer<ListCertificatesByCaRequest.Builder> listCertificatesByCaRequest) throws InvalidRequestException,
            ThrottlingException, UnauthorizedException, ServiceUnavailableException, InternalFailureException,
            AwsServiceException, SdkClientException, IotException {
        return listCertificatesByCA(ListCertificatesByCaRequest.builder().applyMutation(listCertificatesByCaRequest).build());
    }

    /**
     * <p>
     * List the device certificates signed by the specified CA certificate.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListCertificatesByCA</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCertificatesByCA(software.amazon.awssdk.services.iot.model.ListCertificatesByCaRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.ListCertificatesByCAIterable responses = client.listCertificatesByCAPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iot.paginators.ListCertificatesByCAIterable responses = client
     *             .listCertificatesByCAPaginator(request);
     *     for (software.amazon.awssdk.services.iot.model.ListCertificatesByCaResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.ListCertificatesByCAIterable responses = client.listCertificatesByCAPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of pageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCertificatesByCA(software.amazon.awssdk.services.iot.model.ListCertificatesByCaRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCertificatesByCaRequest
     *        The input to the ListCertificatesByCA operation.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListCertificatesByCA
     */
    default ListCertificatesByCAIterable listCertificatesByCAPaginator(ListCertificatesByCaRequest listCertificatesByCaRequest)
            throws InvalidRequestException, ThrottlingException, UnauthorizedException, ServiceUnavailableException,
            InternalFailureException, AwsServiceException, SdkClientException, IotException {
        return new ListCertificatesByCAIterable(this, listCertificatesByCaRequest);
    }

    /**
     * <p>
     * List the device certificates signed by the specified CA certificate.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListCertificatesByCA</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCertificatesByCA(software.amazon.awssdk.services.iot.model.ListCertificatesByCaRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.ListCertificatesByCAIterable responses = client.listCertificatesByCAPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iot.paginators.ListCertificatesByCAIterable responses = client
     *             .listCertificatesByCAPaginator(request);
     *     for (software.amazon.awssdk.services.iot.model.ListCertificatesByCaResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.ListCertificatesByCAIterable responses = client.listCertificatesByCAPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of pageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCertificatesByCA(software.amazon.awssdk.services.iot.model.ListCertificatesByCaRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCertificatesByCaRequest.Builder} avoiding the
     * need to create one manually via {@link ListCertificatesByCaRequest#builder()}
     * </p>
     *
     * @param listCertificatesByCaRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.ListCertificatesByCaRequest.Builder} to create a request.
     *        The input to the ListCertificatesByCA operation.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListCertificatesByCA
     */
    default ListCertificatesByCAIterable listCertificatesByCAPaginator(
            Consumer<ListCertificatesByCaRequest.Builder> listCertificatesByCaRequest) throws InvalidRequestException,
            ThrottlingException, UnauthorizedException, ServiceUnavailableException, InternalFailureException,
            AwsServiceException, SdkClientException, IotException {
        return listCertificatesByCAPaginator(ListCertificatesByCaRequest.builder().applyMutation(listCertificatesByCaRequest)
                .build());
    }

    /**
     * <p>
     * Lists your Device Defender detect custom metrics.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListCustomMetrics</a> action.
     * </p>
     *
     * @param listCustomMetricsRequest
     * @return Result of the ListCustomMetrics operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListCustomMetrics
     */
    default ListCustomMetricsResponse listCustomMetrics(ListCustomMetricsRequest listCustomMetricsRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists your Device Defender detect custom metrics.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListCustomMetrics</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCustomMetricsRequest.Builder} avoiding the need
     * to create one manually via {@link ListCustomMetricsRequest#builder()}
     * </p>
     *
     * @param listCustomMetricsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.ListCustomMetricsRequest.Builder} to create a request.
     * @return Result of the ListCustomMetrics operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListCustomMetrics
     */
    default ListCustomMetricsResponse listCustomMetrics(Consumer<ListCustomMetricsRequest.Builder> listCustomMetricsRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        return listCustomMetrics(ListCustomMetricsRequest.builder().applyMutation(listCustomMetricsRequest).build());
    }

    /**
     * <p>
     * Lists your Device Defender detect custom metrics.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListCustomMetrics</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCustomMetrics(software.amazon.awssdk.services.iot.model.ListCustomMetricsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.ListCustomMetricsIterable responses = client.listCustomMetricsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iot.paginators.ListCustomMetricsIterable responses = client
     *             .listCustomMetricsPaginator(request);
     *     for (software.amazon.awssdk.services.iot.model.ListCustomMetricsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.ListCustomMetricsIterable responses = client.listCustomMetricsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCustomMetrics(software.amazon.awssdk.services.iot.model.ListCustomMetricsRequest)} operation.</b>
     * </p>
     *
     * @param listCustomMetricsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListCustomMetrics
     */
    default ListCustomMetricsIterable listCustomMetricsPaginator(ListCustomMetricsRequest listCustomMetricsRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        return new ListCustomMetricsIterable(this, listCustomMetricsRequest);
    }

    /**
     * <p>
     * Lists your Device Defender detect custom metrics.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListCustomMetrics</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCustomMetrics(software.amazon.awssdk.services.iot.model.ListCustomMetricsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.ListCustomMetricsIterable responses = client.listCustomMetricsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iot.paginators.ListCustomMetricsIterable responses = client
     *             .listCustomMetricsPaginator(request);
     *     for (software.amazon.awssdk.services.iot.model.ListCustomMetricsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.ListCustomMetricsIterable responses = client.listCustomMetricsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCustomMetrics(software.amazon.awssdk.services.iot.model.ListCustomMetricsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCustomMetricsRequest.Builder} avoiding the need
     * to create one manually via {@link ListCustomMetricsRequest#builder()}
     * </p>
     *
     * @param listCustomMetricsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.ListCustomMetricsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListCustomMetrics
     */
    default ListCustomMetricsIterable listCustomMetricsPaginator(
            Consumer<ListCustomMetricsRequest.Builder> listCustomMetricsRequest) throws InvalidRequestException,
            ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException, IotException {
        return listCustomMetricsPaginator(ListCustomMetricsRequest.builder().applyMutation(listCustomMetricsRequest).build());
    }

    /**
     * <p>
     * Lists mitigation actions executions for a Device Defender ML Detect Security Profile.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListDetectMitigationActionsExecutions</a> action.
     * </p>
     *
     * @param listDetectMitigationActionsExecutionsRequest
     * @return Result of the ListDetectMitigationActionsExecutions operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListDetectMitigationActionsExecutions
     */
    default ListDetectMitigationActionsExecutionsResponse listDetectMitigationActionsExecutions(
            ListDetectMitigationActionsExecutionsRequest listDetectMitigationActionsExecutionsRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists mitigation actions executions for a Device Defender ML Detect Security Profile.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListDetectMitigationActionsExecutions</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListDetectMitigationActionsExecutionsRequest.Builder} avoiding the need to create one manually via
     * {@link ListDetectMitigationActionsExecutionsRequest#builder()}
     * </p>
     *
     * @param listDetectMitigationActionsExecutionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.ListDetectMitigationActionsExecutionsRequest.Builder} to
     *        create a request.
     * @return Result of the ListDetectMitigationActionsExecutions operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListDetectMitigationActionsExecutions
     */
    default ListDetectMitigationActionsExecutionsResponse listDetectMitigationActionsExecutions(
            Consumer<ListDetectMitigationActionsExecutionsRequest.Builder> listDetectMitigationActionsExecutionsRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        return listDetectMitigationActionsExecutions(ListDetectMitigationActionsExecutionsRequest.builder()
                .applyMutation(listDetectMitigationActionsExecutionsRequest).build());
    }

    /**
     * <p>
     * Lists mitigation actions executions for a Device Defender ML Detect Security Profile.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListDetectMitigationActionsExecutions</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDetectMitigationActionsExecutions(software.amazon.awssdk.services.iot.model.ListDetectMitigationActionsExecutionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.ListDetectMitigationActionsExecutionsIterable responses = client.listDetectMitigationActionsExecutionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iot.paginators.ListDetectMitigationActionsExecutionsIterable responses = client
     *             .listDetectMitigationActionsExecutionsPaginator(request);
     *     for (software.amazon.awssdk.services.iot.model.ListDetectMitigationActionsExecutionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.ListDetectMitigationActionsExecutionsIterable responses = client.listDetectMitigationActionsExecutionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDetectMitigationActionsExecutions(software.amazon.awssdk.services.iot.model.ListDetectMitigationActionsExecutionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDetectMitigationActionsExecutionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListDetectMitigationActionsExecutions
     */
    default ListDetectMitigationActionsExecutionsIterable listDetectMitigationActionsExecutionsPaginator(
            ListDetectMitigationActionsExecutionsRequest listDetectMitigationActionsExecutionsRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        return new ListDetectMitigationActionsExecutionsIterable(this, listDetectMitigationActionsExecutionsRequest);
    }

    /**
     * <p>
     * Lists mitigation actions executions for a Device Defender ML Detect Security Profile.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListDetectMitigationActionsExecutions</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDetectMitigationActionsExecutions(software.amazon.awssdk.services.iot.model.ListDetectMitigationActionsExecutionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.ListDetectMitigationActionsExecutionsIterable responses = client.listDetectMitigationActionsExecutionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iot.paginators.ListDetectMitigationActionsExecutionsIterable responses = client
     *             .listDetectMitigationActionsExecutionsPaginator(request);
     *     for (software.amazon.awssdk.services.iot.model.ListDetectMitigationActionsExecutionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.ListDetectMitigationActionsExecutionsIterable responses = client.listDetectMitigationActionsExecutionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDetectMitigationActionsExecutions(software.amazon.awssdk.services.iot.model.ListDetectMitigationActionsExecutionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListDetectMitigationActionsExecutionsRequest.Builder} avoiding the need to create one manually via
     * {@link ListDetectMitigationActionsExecutionsRequest#builder()}
     * </p>
     *
     * @param listDetectMitigationActionsExecutionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.ListDetectMitigationActionsExecutionsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListDetectMitigationActionsExecutions
     */
    default ListDetectMitigationActionsExecutionsIterable listDetectMitigationActionsExecutionsPaginator(
            Consumer<ListDetectMitigationActionsExecutionsRequest.Builder> listDetectMitigationActionsExecutionsRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        return listDetectMitigationActionsExecutionsPaginator(ListDetectMitigationActionsExecutionsRequest.builder()
                .applyMutation(listDetectMitigationActionsExecutionsRequest).build());
    }

    /**
     * <p>
     * List of Device Defender ML Detect mitigation actions tasks.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListDetectMitigationActionsTasks</a> action.
     * </p>
     *
     * @param listDetectMitigationActionsTasksRequest
     * @return Result of the ListDetectMitigationActionsTasks operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListDetectMitigationActionsTasks
     */
    default ListDetectMitigationActionsTasksResponse listDetectMitigationActionsTasks(
            ListDetectMitigationActionsTasksRequest listDetectMitigationActionsTasksRequest) throws InvalidRequestException,
            ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List of Device Defender ML Detect mitigation actions tasks.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListDetectMitigationActionsTasks</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDetectMitigationActionsTasksRequest.Builder}
     * avoiding the need to create one manually via {@link ListDetectMitigationActionsTasksRequest#builder()}
     * </p>
     *
     * @param listDetectMitigationActionsTasksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.ListDetectMitigationActionsTasksRequest.Builder} to
     *        create a request.
     * @return Result of the ListDetectMitigationActionsTasks operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListDetectMitigationActionsTasks
     */
    default ListDetectMitigationActionsTasksResponse listDetectMitigationActionsTasks(
            Consumer<ListDetectMitigationActionsTasksRequest.Builder> listDetectMitigationActionsTasksRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        return listDetectMitigationActionsTasks(ListDetectMitigationActionsTasksRequest.builder()
                .applyMutation(listDetectMitigationActionsTasksRequest).build());
    }

    /**
     * <p>
     * List of Device Defender ML Detect mitigation actions tasks.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListDetectMitigationActionsTasks</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDetectMitigationActionsTasks(software.amazon.awssdk.services.iot.model.ListDetectMitigationActionsTasksRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.ListDetectMitigationActionsTasksIterable responses = client.listDetectMitigationActionsTasksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iot.paginators.ListDetectMitigationActionsTasksIterable responses = client
     *             .listDetectMitigationActionsTasksPaginator(request);
     *     for (software.amazon.awssdk.services.iot.model.ListDetectMitigationActionsTasksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.ListDetectMitigationActionsTasksIterable responses = client.listDetectMitigationActionsTasksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDetectMitigationActionsTasks(software.amazon.awssdk.services.iot.model.ListDetectMitigationActionsTasksRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDetectMitigationActionsTasksRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListDetectMitigationActionsTasks
     */
    default ListDetectMitigationActionsTasksIterable listDetectMitigationActionsTasksPaginator(
            ListDetectMitigationActionsTasksRequest listDetectMitigationActionsTasksRequest) throws InvalidRequestException,
            ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException, IotException {
        return new ListDetectMitigationActionsTasksIterable(this, listDetectMitigationActionsTasksRequest);
    }

    /**
     * <p>
     * List of Device Defender ML Detect mitigation actions tasks.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListDetectMitigationActionsTasks</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDetectMitigationActionsTasks(software.amazon.awssdk.services.iot.model.ListDetectMitigationActionsTasksRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.ListDetectMitigationActionsTasksIterable responses = client.listDetectMitigationActionsTasksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iot.paginators.ListDetectMitigationActionsTasksIterable responses = client
     *             .listDetectMitigationActionsTasksPaginator(request);
     *     for (software.amazon.awssdk.services.iot.model.ListDetectMitigationActionsTasksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.ListDetectMitigationActionsTasksIterable responses = client.listDetectMitigationActionsTasksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDetectMitigationActionsTasks(software.amazon.awssdk.services.iot.model.ListDetectMitigationActionsTasksRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDetectMitigationActionsTasksRequest.Builder}
     * avoiding the need to create one manually via {@link ListDetectMitigationActionsTasksRequest#builder()}
     * </p>
     *
     * @param listDetectMitigationActionsTasksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.ListDetectMitigationActionsTasksRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListDetectMitigationActionsTasks
     */
    default ListDetectMitigationActionsTasksIterable listDetectMitigationActionsTasksPaginator(
            Consumer<ListDetectMitigationActionsTasksRequest.Builder> listDetectMitigationActionsTasksRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        return listDetectMitigationActionsTasksPaginator(ListDetectMitigationActionsTasksRequest.builder()
                .applyMutation(listDetectMitigationActionsTasksRequest).build());
    }

    /**
     * <p>
     * List the set of dimensions that are defined for your Amazon Web Services accounts.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListDimensions</a> action.
     * </p>
     *
     * @param listDimensionsRequest
     * @return Result of the ListDimensions operation returned by the service.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListDimensions
     */
    default ListDimensionsResponse listDimensions(ListDimensionsRequest listDimensionsRequest) throws InternalFailureException,
            InvalidRequestException, ThrottlingException, AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the set of dimensions that are defined for your Amazon Web Services accounts.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListDimensions</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDimensionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListDimensionsRequest#builder()}
     * </p>
     *
     * @param listDimensionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.ListDimensionsRequest.Builder} to create a request.
     * @return Result of the ListDimensions operation returned by the service.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListDimensions
     */
    default ListDimensionsResponse listDimensions(Consumer<ListDimensionsRequest.Builder> listDimensionsRequest)
            throws InternalFailureException, InvalidRequestException, ThrottlingException, AwsServiceException,
            SdkClientException, IotException {
        return listDimensions(ListDimensionsRequest.builder().applyMutation(listDimensionsRequest).build());
    }

    /**
     * <p>
     * List the set of dimensions that are defined for your Amazon Web Services accounts.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListDimensions</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listDimensions(software.amazon.awssdk.services.iot.model.ListDimensionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.ListDimensionsIterable responses = client.listDimensionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iot.paginators.ListDimensionsIterable responses = client.listDimensionsPaginator(request);
     *     for (software.amazon.awssdk.services.iot.model.ListDimensionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.ListDimensionsIterable responses = client.listDimensionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDimensions(software.amazon.awssdk.services.iot.model.ListDimensionsRequest)} operation.</b>
     * </p>
     *
     * @param listDimensionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListDimensions
     */
    default ListDimensionsIterable listDimensionsPaginator(ListDimensionsRequest listDimensionsRequest)
            throws InternalFailureException, InvalidRequestException, ThrottlingException, AwsServiceException,
            SdkClientException, IotException {
        return new ListDimensionsIterable(this, listDimensionsRequest);
    }

    /**
     * <p>
     * List the set of dimensions that are defined for your Amazon Web Services accounts.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListDimensions</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listDimensions(software.amazon.awssdk.services.iot.model.ListDimensionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.ListDimensionsIterable responses = client.listDimensionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iot.paginators.ListDimensionsIterable responses = client.listDimensionsPaginator(request);
     *     for (software.amazon.awssdk.services.iot.model.ListDimensionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.ListDimensionsIterable responses = client.listDimensionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDimensions(software.amazon.awssdk.services.iot.model.ListDimensionsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDimensionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListDimensionsRequest#builder()}
     * </p>
     *
     * @param listDimensionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.ListDimensionsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListDimensions
     */
    default ListDimensionsIterable listDimensionsPaginator(Consumer<ListDimensionsRequest.Builder> listDimensionsRequest)
            throws InternalFailureException, InvalidRequestException, ThrottlingException, AwsServiceException,
            SdkClientException, IotException {
        return listDimensionsPaginator(ListDimensionsRequest.builder().applyMutation(listDimensionsRequest).build());
    }

    /**
     * <p>
     * Gets a list of domain configurations for the user. This list is sorted alphabetically by domain configuration
     * name.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListDomainConfigurations</a> action.
     * </p>
     *
     * @param listDomainConfigurationsRequest
     * @return Result of the ListDomainConfigurations operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListDomainConfigurations
     */
    default ListDomainConfigurationsResponse listDomainConfigurations(
            ListDomainConfigurationsRequest listDomainConfigurationsRequest) throws InvalidRequestException, ThrottlingException,
            UnauthorizedException, ServiceUnavailableException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a list of domain configurations for the user. This list is sorted alphabetically by domain configuration
     * name.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListDomainConfigurations</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDomainConfigurationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListDomainConfigurationsRequest#builder()}
     * </p>
     *
     * @param listDomainConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.ListDomainConfigurationsRequest.Builder} to create a
     *        request.
     * @return Result of the ListDomainConfigurations operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListDomainConfigurations
     */
    default ListDomainConfigurationsResponse listDomainConfigurations(
            Consumer<ListDomainConfigurationsRequest.Builder> listDomainConfigurationsRequest) throws InvalidRequestException,
            ThrottlingException, UnauthorizedException, ServiceUnavailableException, InternalFailureException,
            AwsServiceException, SdkClientException, IotException {
        return listDomainConfigurations(ListDomainConfigurationsRequest.builder().applyMutation(listDomainConfigurationsRequest)
                .build());
    }

    /**
     * <p>
     * Gets a list of domain configurations for the user. This list is sorted alphabetically by domain configuration
     * name.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListDomainConfigurations</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDomainConfigurations(software.amazon.awssdk.services.iot.model.ListDomainConfigurationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.ListDomainConfigurationsIterable responses = client.listDomainConfigurationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iot.paginators.ListDomainConfigurationsIterable responses = client
     *             .listDomainConfigurationsPaginator(request);
     *     for (software.amazon.awssdk.services.iot.model.ListDomainConfigurationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.ListDomainConfigurationsIterable responses = client.listDomainConfigurationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of pageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDomainConfigurations(software.amazon.awssdk.services.iot.model.ListDomainConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDomainConfigurationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListDomainConfigurations
     */
    default ListDomainConfigurationsIterable listDomainConfigurationsPaginator(
            ListDomainConfigurationsRequest listDomainConfigurationsRequest) throws InvalidRequestException, ThrottlingException,
            UnauthorizedException, ServiceUnavailableException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        return new ListDomainConfigurationsIterable(this, listDomainConfigurationsRequest);
    }

    /**
     * <p>
     * Gets a list of domain configurations for the user. This list is sorted alphabetically by domain configuration
     * name.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListDomainConfigurations</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDomainConfigurations(software.amazon.awssdk.services.iot.model.ListDomainConfigurationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.ListDomainConfigurationsIterable responses = client.listDomainConfigurationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iot.paginators.ListDomainConfigurationsIterable responses = client
     *             .listDomainConfigurationsPaginator(request);
     *     for (software.amazon.awssdk.services.iot.model.ListDomainConfigurationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.ListDomainConfigurationsIterable responses = client.listDomainConfigurationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of pageSize won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDomainConfigurations(software.amazon.awssdk.services.iot.model.ListDomainConfigurationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDomainConfigurationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListDomainConfigurationsRequest#builder()}
     * </p>
     *
     * @param listDomainConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.ListDomainConfigurationsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListDomainConfigurations
     */
    default ListDomainConfigurationsIterable listDomainConfigurationsPaginator(
            Consumer<ListDomainConfigurationsRequest.Builder> listDomainConfigurationsRequest) throws InvalidRequestException,
            ThrottlingException, UnauthorizedException, ServiceUnavailableException, InternalFailureException,
            AwsServiceException, SdkClientException, IotException {
        return listDomainConfigurationsPaginator(ListDomainConfigurationsRequest.builder()
                .applyMutation(listDomainConfigurationsRequest).build());
    }

    /**
     * <p>
     * Lists all your fleet metrics.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListFleetMetrics</a> action.
     * </p>
     *
     * @param listFleetMetricsRequest
     * @return Result of the ListFleetMetrics operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListFleetMetrics
     */
    default ListFleetMetricsResponse listFleetMetrics(ListFleetMetricsRequest listFleetMetricsRequest)
            throws InvalidRequestException, ThrottlingException, UnauthorizedException, ServiceUnavailableException,
            InternalFailureException, AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all your fleet metrics.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListFleetMetrics</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFleetMetricsRequest.Builder} avoiding the need
     * to create one manually via {@link ListFleetMetricsRequest#builder()}
     * </p>
     *
     * @param listFleetMetricsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.ListFleetMetricsRequest.Builder} to create a request.
     * @return Result of the ListFleetMetrics operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListFleetMetrics
     */
    default ListFleetMetricsResponse listFleetMetrics(Consumer<ListFleetMetricsRequest.Builder> listFleetMetricsRequest)
            throws InvalidRequestException, ThrottlingException, UnauthorizedException, ServiceUnavailableException,
            InternalFailureException, AwsServiceException, SdkClientException, IotException {
        return listFleetMetrics(ListFleetMetricsRequest.builder().applyMutation(listFleetMetricsRequest).build());
    }

    /**
     * <p>
     * Lists all your fleet metrics.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListFleetMetrics</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listFleetMetrics(software.amazon.awssdk.services.iot.model.ListFleetMetricsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.ListFleetMetricsIterable responses = client.listFleetMetricsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iot.paginators.ListFleetMetricsIterable responses = client.listFleetMetricsPaginator(request);
     *     for (software.amazon.awssdk.services.iot.model.ListFleetMetricsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.ListFleetMetricsIterable responses = client.listFleetMetricsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFleetMetrics(software.amazon.awssdk.services.iot.model.ListFleetMetricsRequest)} operation.</b>
     * </p>
     *
     * @param listFleetMetricsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListFleetMetrics
     */
    default ListFleetMetricsIterable listFleetMetricsPaginator(ListFleetMetricsRequest listFleetMetricsRequest)
            throws InvalidRequestException, ThrottlingException, UnauthorizedException, ServiceUnavailableException,
            InternalFailureException, AwsServiceException, SdkClientException, IotException {
        return new ListFleetMetricsIterable(this, listFleetMetricsRequest);
    }

    /**
     * <p>
     * Lists all your fleet metrics.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListFleetMetrics</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listFleetMetrics(software.amazon.awssdk.services.iot.model.ListFleetMetricsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.ListFleetMetricsIterable responses = client.listFleetMetricsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iot.paginators.ListFleetMetricsIterable responses = client.listFleetMetricsPaginator(request);
     *     for (software.amazon.awssdk.services.iot.model.ListFleetMetricsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.ListFleetMetricsIterable responses = client.listFleetMetricsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFleetMetrics(software.amazon.awssdk.services.iot.model.ListFleetMetricsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFleetMetricsRequest.Builder} avoiding the need
     * to create one manually via {@link ListFleetMetricsRequest#builder()}
     * </p>
     *
     * @param listFleetMetricsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.ListFleetMetricsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListFleetMetrics
     */
    default ListFleetMetricsIterable listFleetMetricsPaginator(Consumer<ListFleetMetricsRequest.Builder> listFleetMetricsRequest)
            throws InvalidRequestException, ThrottlingException, UnauthorizedException, ServiceUnavailableException,
            InternalFailureException, AwsServiceException, SdkClientException, IotException {
        return listFleetMetricsPaginator(ListFleetMetricsRequest.builder().applyMutation(listFleetMetricsRequest).build());
    }

    /**
     * <p>
     * Lists the search indices.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListIndices</a> action.
     * </p>
     *
     * @param listIndicesRequest
     * @return Result of the ListIndices operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListIndices
     */
    default ListIndicesResponse listIndices(ListIndicesRequest listIndicesRequest) throws InvalidRequestException,
            ThrottlingException, UnauthorizedException, ServiceUnavailableException, InternalFailureException,
            AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the search indices.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListIndices</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIndicesRequest.Builder} avoiding the need to
     * create one manually via {@link ListIndicesRequest#builder()}
     * </p>
     *
     * @param listIndicesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.ListIndicesRequest.Builder} to create a request.
     * @return Result of the ListIndices operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListIndices
     */
    default ListIndicesResponse listIndices(Consumer<ListIndicesRequest.Builder> listIndicesRequest)
            throws InvalidRequestException, ThrottlingException, UnauthorizedException, ServiceUnavailableException,
            InternalFailureException, AwsServiceException, SdkClientException, IotException {
        return listIndices(ListIndicesRequest.builder().applyMutation(listIndicesRequest).build());
    }

    /**
     * <p>
     * Lists the search indices.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListIndices</a> action.
     * </p>
     *
     * @return Result of the ListIndices operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListIndices
     * @see #listIndices(ListIndicesRequest)
     */
    default ListIndicesResponse listIndices() throws InvalidRequestException, ThrottlingException, UnauthorizedException,
            ServiceUnavailableException, InternalFailureException, AwsServiceException, SdkClientException, IotException {
        return listIndices(ListIndicesRequest.builder().build());
    }

    /**
     * <p>
     * Lists the search indices.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListIndices</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listIndices(software.amazon.awssdk.services.iot.model.ListIndicesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.ListIndicesIterable responses = client.listIndicesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iot.paginators.ListIndicesIterable responses = client.listIndicesPaginator(request);
     *     for (software.amazon.awssdk.services.iot.model.ListIndicesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.ListIndicesIterable responses = client.listIndicesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIndices(software.amazon.awssdk.services.iot.model.ListIndicesRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListIndices
     * @see #listIndicesPaginator(ListIndicesRequest)
     */
    default ListIndicesIterable listIndicesPaginator() throws InvalidRequestException, ThrottlingException,
            UnauthorizedException, ServiceUnavailableException, InternalFailureException, AwsServiceException,
            SdkClientException, IotException {
        return listIndicesPaginator(ListIndicesRequest.builder().build());
    }

    /**
     * <p>
     * Lists the search indices.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListIndices</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listIndices(software.amazon.awssdk.services.iot.model.ListIndicesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.ListIndicesIterable responses = client.listIndicesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iot.paginators.ListIndicesIterable responses = client.listIndicesPaginator(request);
     *     for (software.amazon.awssdk.services.iot.model.ListIndicesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.ListIndicesIterable responses = client.listIndicesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIndices(software.amazon.awssdk.services.iot.model.ListIndicesRequest)} operation.</b>
     * </p>
     *
     * @param listIndicesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListIndices
     */
    default ListIndicesIterable listIndicesPaginator(ListIndicesRequest listIndicesRequest) throws InvalidRequestException,
            ThrottlingException, UnauthorizedException, ServiceUnavailableException, InternalFailureException,
            AwsServiceException, SdkClientException, IotException {
        return new ListIndicesIterable(this, listIndicesRequest);
    }

    /**
     * <p>
     * Lists the search indices.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListIndices</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listIndices(software.amazon.awssdk.services.iot.model.ListIndicesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.ListIndicesIterable responses = client.listIndicesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iot.paginators.ListIndicesIterable responses = client.listIndicesPaginator(request);
     *     for (software.amazon.awssdk.services.iot.model.ListIndicesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.ListIndicesIterable responses = client.listIndicesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIndices(software.amazon.awssdk.services.iot.model.ListIndicesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIndicesRequest.Builder} avoiding the need to
     * create one manually via {@link ListIndicesRequest#builder()}
     * </p>
     *
     * @param listIndicesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.ListIndicesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws InternalFailureException
     *         An unexpected error has occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListIndices
     */
    default ListIndicesIterable listIndicesPaginator(Consumer<ListIndicesRequest.Builder> listIndicesRequest)
            throws InvalidRequestException, ThrottlingException, UnauthorizedException, ServiceUnavailableException,
            InternalFailureException, AwsServiceException, SdkClientException, IotException {
        return listIndicesPaginator(ListIndicesRequest.builder().applyMutation(listIndicesRequest).build());
    }

    /**
     * <p>
     * Lists the job executions for a job.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListJobExecutionsForJob</a> action.
     * </p>
     *
     * @param listJobExecutionsForJobRequest
     * @return Result of the ListJobExecutionsForJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListJobExecutionsForJob
     */
    default ListJobExecutionsForJobResponse listJobExecutionsForJob(ListJobExecutionsForJobRequest listJobExecutionsForJobRequest)
            throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, ServiceUnavailableException,
            AwsServiceException, SdkClientException, IotException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the job executions for a job.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListJobExecutionsForJob</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListJobExecutionsForJobRequest.Builder} avoiding
     * the need to create one manually via {@link ListJobExecutionsForJobRequest#builder()}
     * </p>
     *
     * @param listJobExecutionsForJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.ListJobExecutionsForJobRequest.Builder} to create a
     *        request.
     * @return Result of the ListJobExecutionsForJob operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListJobExecutionsForJob
     */
    default ListJobExecutionsForJobResponse listJobExecutionsForJob(
            Consumer<ListJobExecutionsForJobRequest.Builder> listJobExecutionsForJobRequest) throws InvalidRequestException,
            ResourceNotFoundException, ThrottlingException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            IotException {
        return listJobExecutionsForJob(ListJobExecutionsForJobRequest.builder().applyMutation(listJobExecutionsForJobRequest)
                .build());
    }

    /**
     * <p>
     * Lists the job executions for a job.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListJobExecutionsForJob</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listJobExecutionsForJob(software.amazon.awssdk.services.iot.model.ListJobExecutionsForJobRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.ListJobExecutionsForJobIterable responses = client.listJobExecutionsForJobPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iot.paginators.ListJobExecutionsForJobIterable responses = client
     *             .listJobExecutionsForJobPaginator(request);
     *     for (software.amazon.awssdk.services.iot.model.ListJobExecutionsForJobResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.ListJobExecutionsForJobIterable responses = client.listJobExecutionsForJobPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listJobExecutionsForJob(software.amazon.awssdk.services.iot.model.ListJobExecutionsForJobRequest)}
     * operation.</b>
     * </p>
     *
     * @param listJobExecutionsForJobRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListJobExecutionsForJob
     */
    default ListJobExecutionsForJobIterable listJobExecutionsForJobPaginator(
            ListJobExecutionsForJobRequest listJobExecutionsForJobRequest) throws InvalidRequestException,
            ResourceNotFoundException, ThrottlingException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            IotException {
        return new ListJobExecutionsForJobIterable(this, listJobExecutionsForJobRequest);
    }

    /**
     * <p>
     * Lists the job executions for a job.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListJobExecutionsForJob</a> action.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listJobExecutionsForJob(software.amazon.awssdk.services.iot.model.ListJobExecutionsForJobRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.ListJobExecutionsForJobIterable responses = client.listJobExecutionsForJobPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iot.paginators.ListJobExecutionsForJobIterable responses = client
     *             .listJobExecutionsForJobPaginator(request);
     *     for (software.amazon.awssdk.services.iot.model.ListJobExecutionsForJobResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iot.paginators.ListJobExecutionsForJobIterable responses = client.listJobExecutionsForJobPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listJobExecutionsForJob(software.amazon.awssdk.services.iot.model.ListJobExecutionsForJobRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListJobExecutionsForJobRequest.Builder} avoiding
     * the need to create one manually via {@link ListJobExecutionsForJobRequest#builder()}
     * </p>
     *
     * @param listJobExecutionsForJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.iot.model.ListJobExecutionsForJobRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @throws ThrottlingException
     *         The rate exceeds the limit.
     * @throws ServiceUnavailableException
     *         The service is temporarily unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IotException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IotClient.ListJobExecutionsForJob
     */
    default ListJobExecutionsForJobIterable listJobExecutionsForJobPaginator(
            Consumer<ListJobExecutionsForJobRequest.Builder> listJobExecutionsForJobRequest) throws InvalidRequestException,
            ResourceNotFoundException, ThrottlingException, ServiceUnavailableException, AwsServiceException, SdkClientException,
            IotException {
        return listJobExecutionsForJobPaginator(ListJobExecutionsForJobRequest.builder()
                .applyMutation(listJobExecutionsForJobRequest).build());
    }

    /**
     * <p>
     * Lists the job executions for the specified thing.
     * </p>
     * <p>
     * Requires permission to access the <a href=
     * "https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions"
     * >ListJobExecutionsForThing</a> action.
     * </p>
     *
     * @param listJobExecutionsForThingRequest
     * @return Result of the ListJobExecutionsForThing operation returned by the service.
     * @throws InvalidRequestException
     *         The request is not valid.
     * @throws ResourceNotFoundException
     *         The specified resource does not exist.
     * @th