/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.CodeSigningCertificateChain;
import software.amazon.awssdk.services.iot.model.CodeSigningSignature;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CustomCodeSigning
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CustomCodeSigning> {
    private static final SdkField<CodeSigningSignature> SIGNATURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("signature").getter(CustomCodeSigning.getter(CustomCodeSigning::signature)).setter(CustomCodeSigning.setter(Builder::signature)).constructor(CodeSigningSignature::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signature").build()}).build();
    private static final SdkField<CodeSigningCertificateChain> CERTIFICATE_CHAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("certificateChain").getter(CustomCodeSigning.getter(CustomCodeSigning::certificateChain)).setter(CustomCodeSigning.setter(Builder::certificateChain)).constructor(CodeSigningCertificateChain::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateChain").build()}).build();
    private static final SdkField<String> HASH_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("hashAlgorithm").getter(CustomCodeSigning.getter(CustomCodeSigning::hashAlgorithm)).setter(CustomCodeSigning.setter(Builder::hashAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hashAlgorithm").build()}).build();
    private static final SdkField<String> SIGNATURE_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("signatureAlgorithm").getter(CustomCodeSigning.getter(CustomCodeSigning::signatureAlgorithm)).setter(CustomCodeSigning.setter(Builder::signatureAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signatureAlgorithm").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIGNATURE_FIELD, CERTIFICATE_CHAIN_FIELD, HASH_ALGORITHM_FIELD, SIGNATURE_ALGORITHM_FIELD));
    private static final long serialVersionUID = 1L;
    private final CodeSigningSignature signature;
    private final CodeSigningCertificateChain certificateChain;
    private final String hashAlgorithm;
    private final String signatureAlgorithm;

    private CustomCodeSigning(BuilderImpl builder) {
        this.signature = builder.signature;
        this.certificateChain = builder.certificateChain;
        this.hashAlgorithm = builder.hashAlgorithm;
        this.signatureAlgorithm = builder.signatureAlgorithm;
    }

    public final CodeSigningSignature signature() {
        return this.signature;
    }

    public final CodeSigningCertificateChain certificateChain() {
        return this.certificateChain;
    }

    public final String hashAlgorithm() {
        return this.hashAlgorithm;
    }

    public final String signatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.signature());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateChain());
        hashCode = 31 * hashCode + Objects.hashCode(this.hashAlgorithm());
        hashCode = 31 * hashCode + Objects.hashCode(this.signatureAlgorithm());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomCodeSigning)) {
            return false;
        }
        CustomCodeSigning other = (CustomCodeSigning)obj;
        return Objects.equals(this.signature(), other.signature()) && Objects.equals(this.certificateChain(), other.certificateChain()) && Objects.equals(this.hashAlgorithm(), other.hashAlgorithm()) && Objects.equals(this.signatureAlgorithm(), other.signatureAlgorithm());
    }

    public final String toString() {
        return ToString.builder((String)"CustomCodeSigning").add("Signature", (Object)this.signature()).add("CertificateChain", (Object)this.certificateChain()).add("HashAlgorithm", (Object)this.hashAlgorithm()).add("SignatureAlgorithm", (Object)this.signatureAlgorithm()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "signature": {
                return Optional.ofNullable(clazz.cast(this.signature()));
            }
            case "certificateChain": {
                return Optional.ofNullable(clazz.cast(this.certificateChain()));
            }
            case "hashAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.hashAlgorithm()));
            }
            case "signatureAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.signatureAlgorithm()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CustomCodeSigning, T> g) {
        return obj -> g.apply((CustomCodeSigning)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private CodeSigningSignature signature;
        private CodeSigningCertificateChain certificateChain;
        private String hashAlgorithm;
        private String signatureAlgorithm;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomCodeSigning model) {
            this.signature(model.signature);
            this.certificateChain(model.certificateChain);
            this.hashAlgorithm(model.hashAlgorithm);
            this.signatureAlgorithm(model.signatureAlgorithm);
        }

        public final CodeSigningSignature.Builder getSignature() {
            return this.signature != null ? this.signature.toBuilder() : null;
        }

        public final void setSignature(CodeSigningSignature.BuilderImpl signature) {
            this.signature = signature != null ? signature.build() : null;
        }

        @Override
        public final Builder signature(CodeSigningSignature signature) {
            this.signature = signature;
            return this;
        }

        public final CodeSigningCertificateChain.Builder getCertificateChain() {
            return this.certificateChain != null ? this.certificateChain.toBuilder() : null;
        }

        public final void setCertificateChain(CodeSigningCertificateChain.BuilderImpl certificateChain) {
            this.certificateChain = certificateChain != null ? certificateChain.build() : null;
        }

        @Override
        public final Builder certificateChain(CodeSigningCertificateChain certificateChain) {
            this.certificateChain = certificateChain;
            return this;
        }

        public final String getHashAlgorithm() {
            return this.hashAlgorithm;
        }

        public final void setHashAlgorithm(String hashAlgorithm) {
            this.hashAlgorithm = hashAlgorithm;
        }

        @Override
        public final Builder hashAlgorithm(String hashAlgorithm) {
            this.hashAlgorithm = hashAlgorithm;
            return this;
        }

        public final String getSignatureAlgorithm() {
            return this.signatureAlgorithm;
        }

        public final void setSignatureAlgorithm(String signatureAlgorithm) {
            this.signatureAlgorithm = signatureAlgorithm;
        }

        @Override
        public final Builder signatureAlgorithm(String signatureAlgorithm) {
            this.signatureAlgorithm = signatureAlgorithm;
            return this;
        }

        public CustomCodeSigning build() {
            return new CustomCodeSigning(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CustomCodeSigning> {
        public Builder signature(CodeSigningSignature var1);

        default public Builder signature(Consumer<CodeSigningSignature.Builder> signature) {
            return this.signature((CodeSigningSignature)((CodeSigningSignature.Builder)CodeSigningSignature.builder().applyMutation(signature)).build());
        }

        public Builder certificateChain(CodeSigningCertificateChain var1);

        default public Builder certificateChain(Consumer<CodeSigningCertificateChain.Builder> certificateChain) {
            return this.certificateChain((CodeSigningCertificateChain)((CodeSigningCertificateChain.Builder)CodeSigningCertificateChain.builder().applyMutation(certificateChain)).build());
        }

        public Builder hashAlgorithm(String var1);

        public Builder signatureAlgorithm(String var1);
    }
}

