/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DimensionValueOperator {
    IN("IN"),
    NOT_IN("NOT_IN"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DimensionValueOperator> VALUE_MAP;
    private final String value;

    private DimensionValueOperator(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DimensionValueOperator fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DimensionValueOperator> knownValues() {
        EnumSet<DimensionValueOperator> knownValues = EnumSet.allOf(DimensionValueOperator.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DimensionValueOperator.class, DimensionValueOperator::toString);
    }
}

