/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetPercentilesResponse extends IotResponse implements
        ToCopyableBuilder<GetPercentilesResponse.Builder, GetPercentilesResponse> {
    private static final SdkField<List<PercentPair>> PERCENTILES_FIELD = SdkField
            .<List<PercentPair>> builder(MarshallingType.LIST)
            .memberName("percentiles")
            .getter(getter(GetPercentilesResponse::percentiles))
            .setter(setter(Builder::percentiles))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("percentiles").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PercentPair> builder(MarshallingType.SDK_POJO)
                                            .constructor(PercentPair::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PERCENTILES_FIELD));

    private final List<PercentPair> percentiles;

    private GetPercentilesResponse(BuilderImpl builder) {
        super(builder);
        this.percentiles = builder.percentiles;
    }

    /**
     * For responses, this returns true if the service returned a value for the Percentiles property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPercentiles() {
        return percentiles != null && !(percentiles instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The percentile values of the aggregated fields.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPercentiles} method.
     * </p>
     * 
     * @return The percentile values of the aggregated fields.
     */
    public final List<PercentPair> percentiles() {
        return percentiles;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasPercentiles() ? percentiles() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPercentilesResponse)) {
            return false;
        }
        GetPercentilesResponse other = (GetPercentilesResponse) obj;
        return hasPercentiles() == other.hasPercentiles() && Objects.equals(percentiles(), other.percentiles());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetPercentilesResponse").add("Percentiles", hasPercentiles() ? percentiles() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "percentiles":
            return Optional.ofNullable(clazz.cast(percentiles()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetPercentilesResponse, T> g) {
        return obj -> g.apply((GetPercentilesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetPercentilesResponse> {
        /**
         * <p>
         * The percentile values of the aggregated fields.
         * </p>
         * 
         * @param percentiles
         *        The percentile values of the aggregated fields.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder percentiles(Collection<PercentPair> percentiles);

        /**
         * <p>
         * The percentile values of the aggregated fields.
         * </p>
         * 
         * @param percentiles
         *        The percentile values of the aggregated fields.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder percentiles(PercentPair... percentiles);

        /**
         * <p>
         * The percentile values of the aggregated fields.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iot.model.PercentPair.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.iot.model.PercentPair#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iot.model.PercentPair.Builder#build()} is called immediately and its
         * result is passed to {@link #percentiles(List<PercentPair>)}.
         * 
         * @param percentiles
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iot.model.PercentPair.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #percentiles(java.util.Collection<PercentPair>)
         */
        Builder percentiles(Consumer<PercentPair.Builder>... percentiles);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private List<PercentPair> percentiles = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetPercentilesResponse model) {
            super(model);
            percentiles(model.percentiles);
        }

        public final List<PercentPair.Builder> getPercentiles() {
            List<PercentPair.Builder> result = PercentilesCopier.copyToBuilder(this.percentiles);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPercentiles(Collection<PercentPair.BuilderImpl> percentiles) {
            this.percentiles = PercentilesCopier.copyFromBuilder(percentiles);
        }

        @Override
        public final Builder percentiles(Collection<PercentPair> percentiles) {
            this.percentiles = PercentilesCopier.copy(percentiles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder percentiles(PercentPair... percentiles) {
            percentiles(Arrays.asList(percentiles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder percentiles(Consumer<PercentPair.Builder>... percentiles) {
            percentiles(Stream.of(percentiles).map(c -> PercentPair.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetPercentilesResponse build() {
            return new GetPercentilesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
