/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeJobTemplateResponse extends IotResponse implements
        ToCopyableBuilder<DescribeJobTemplateResponse.Builder, DescribeJobTemplateResponse> {
    private static final SdkField<String> JOB_TEMPLATE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobTemplateArn").getter(getter(DescribeJobTemplateResponse::jobTemplateArn))
            .setter(setter(Builder::jobTemplateArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobTemplateArn").build()).build();

    private static final SdkField<String> JOB_TEMPLATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobTemplateId").getter(getter(DescribeJobTemplateResponse::jobTemplateId))
            .setter(setter(Builder::jobTemplateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobTemplateId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(DescribeJobTemplateResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> DOCUMENT_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("documentSource").getter(getter(DescribeJobTemplateResponse::documentSource))
            .setter(setter(Builder::documentSource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documentSource").build()).build();

    private static final SdkField<String> DOCUMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("document").getter(getter(DescribeJobTemplateResponse::document)).setter(setter(Builder::document))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("document").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(DescribeJobTemplateResponse::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<PresignedUrlConfig> PRESIGNED_URL_CONFIG_FIELD = SdkField
            .<PresignedUrlConfig> builder(MarshallingType.SDK_POJO).memberName("presignedUrlConfig")
            .getter(getter(DescribeJobTemplateResponse::presignedUrlConfig)).setter(setter(Builder::presignedUrlConfig))
            .constructor(PresignedUrlConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("presignedUrlConfig").build())
            .build();

    private static final SdkField<JobExecutionsRolloutConfig> JOB_EXECUTIONS_ROLLOUT_CONFIG_FIELD = SdkField
            .<JobExecutionsRolloutConfig> builder(MarshallingType.SDK_POJO)
            .memberName("jobExecutionsRolloutConfig")
            .getter(getter(DescribeJobTemplateResponse::jobExecutionsRolloutConfig))
            .setter(setter(Builder::jobExecutionsRolloutConfig))
            .constructor(JobExecutionsRolloutConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobExecutionsRolloutConfig").build())
            .build();

    private static final SdkField<AbortConfig> ABORT_CONFIG_FIELD = SdkField.<AbortConfig> builder(MarshallingType.SDK_POJO)
            .memberName("abortConfig").getter(getter(DescribeJobTemplateResponse::abortConfig))
            .setter(setter(Builder::abortConfig)).constructor(AbortConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("abortConfig").build()).build();

    private static final SdkField<TimeoutConfig> TIMEOUT_CONFIG_FIELD = SdkField
            .<TimeoutConfig> builder(MarshallingType.SDK_POJO).memberName("timeoutConfig")
            .getter(getter(DescribeJobTemplateResponse::timeoutConfig)).setter(setter(Builder::timeoutConfig))
            .constructor(TimeoutConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutConfig").build()).build();

    private static final SdkField<JobExecutionsRetryConfig> JOB_EXECUTIONS_RETRY_CONFIG_FIELD = SdkField
            .<JobExecutionsRetryConfig> builder(MarshallingType.SDK_POJO).memberName("jobExecutionsRetryConfig")
            .getter(getter(DescribeJobTemplateResponse::jobExecutionsRetryConfig))
            .setter(setter(Builder::jobExecutionsRetryConfig)).constructor(JobExecutionsRetryConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobExecutionsRetryConfig").build())
            .build();

    private static final SdkField<List<MaintenanceWindow>> MAINTENANCE_WINDOWS_FIELD = SdkField
            .<List<MaintenanceWindow>> builder(MarshallingType.LIST)
            .memberName("maintenanceWindows")
            .getter(getter(DescribeJobTemplateResponse::maintenanceWindows))
            .setter(setter(Builder::maintenanceWindows))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maintenanceWindows").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MaintenanceWindow> builder(MarshallingType.SDK_POJO)
                                            .constructor(MaintenanceWindow::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> DESTINATION_PACKAGE_VERSIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("destinationPackageVersions")
            .getter(getter(DescribeJobTemplateResponse::destinationPackageVersions))
            .setter(setter(Builder::destinationPackageVersions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationPackageVersions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_TEMPLATE_ARN_FIELD,
            JOB_TEMPLATE_ID_FIELD, DESCRIPTION_FIELD, DOCUMENT_SOURCE_FIELD, DOCUMENT_FIELD, CREATED_AT_FIELD,
            PRESIGNED_URL_CONFIG_FIELD, JOB_EXECUTIONS_ROLLOUT_CONFIG_FIELD, ABORT_CONFIG_FIELD, TIMEOUT_CONFIG_FIELD,
            JOB_EXECUTIONS_RETRY_CONFIG_FIELD, MAINTENANCE_WINDOWS_FIELD, DESTINATION_PACKAGE_VERSIONS_FIELD));

    private final String jobTemplateArn;

    private final String jobTemplateId;

    private final String description;

    private final String documentSource;

    private final String document;

    private final Instant createdAt;

    private final PresignedUrlConfig presignedUrlConfig;

    private final JobExecutionsRolloutConfig jobExecutionsRolloutConfig;

    private final AbortConfig abortConfig;

    private final TimeoutConfig timeoutConfig;

    private final JobExecutionsRetryConfig jobExecutionsRetryConfig;

    private final List<MaintenanceWindow> maintenanceWindows;

    private final List<String> destinationPackageVersions;

    private DescribeJobTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.jobTemplateArn = builder.jobTemplateArn;
        this.jobTemplateId = builder.jobTemplateId;
        this.description = builder.description;
        this.documentSource = builder.documentSource;
        this.document = builder.document;
        this.createdAt = builder.createdAt;
        this.presignedUrlConfig = builder.presignedUrlConfig;
        this.jobExecutionsRolloutConfig = builder.jobExecutionsRolloutConfig;
        this.abortConfig = builder.abortConfig;
        this.timeoutConfig = builder.timeoutConfig;
        this.jobExecutionsRetryConfig = builder.jobExecutionsRetryConfig;
        this.maintenanceWindows = builder.maintenanceWindows;
        this.destinationPackageVersions = builder.destinationPackageVersions;
    }

    /**
     * <p>
     * The ARN of the job template.
     * </p>
     * 
     * @return The ARN of the job template.
     */
    public final String jobTemplateArn() {
        return jobTemplateArn;
    }

    /**
     * <p>
     * The unique identifier of the job template.
     * </p>
     * 
     * @return The unique identifier of the job template.
     */
    public final String jobTemplateId() {
        return jobTemplateId;
    }

    /**
     * <p>
     * A description of the job template.
     * </p>
     * 
     * @return A description of the job template.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * An S3 link to the job document.
     * </p>
     * 
     * @return An S3 link to the job document.
     */
    public final String documentSource() {
        return documentSource;
    }

    /**
     * <p>
     * The job document.
     * </p>
     * 
     * @return The job document.
     */
    public final String document() {
        return document;
    }

    /**
     * <p>
     * The time, in seconds since the epoch, when the job template was created.
     * </p>
     * 
     * @return The time, in seconds since the epoch, when the job template was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * Returns the value of the PresignedUrlConfig property for this object.
     * 
     * @return The value of the PresignedUrlConfig property for this object.
     */
    public final PresignedUrlConfig presignedUrlConfig() {
        return presignedUrlConfig;
    }

    /**
     * Returns the value of the JobExecutionsRolloutConfig property for this object.
     * 
     * @return The value of the JobExecutionsRolloutConfig property for this object.
     */
    public final JobExecutionsRolloutConfig jobExecutionsRolloutConfig() {
        return jobExecutionsRolloutConfig;
    }

    /**
     * Returns the value of the AbortConfig property for this object.
     * 
     * @return The value of the AbortConfig property for this object.
     */
    public final AbortConfig abortConfig() {
        return abortConfig;
    }

    /**
     * Returns the value of the TimeoutConfig property for this object.
     * 
     * @return The value of the TimeoutConfig property for this object.
     */
    public final TimeoutConfig timeoutConfig() {
        return timeoutConfig;
    }

    /**
     * <p>
     * The configuration that determines how many retries are allowed for each failure type for a job.
     * </p>
     * 
     * @return The configuration that determines how many retries are allowed for each failure type for a job.
     */
    public final JobExecutionsRetryConfig jobExecutionsRetryConfig() {
        return jobExecutionsRetryConfig;
    }

    /**
     * For responses, this returns true if the service returned a value for the MaintenanceWindows property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMaintenanceWindows() {
        return maintenanceWindows != null && !(maintenanceWindows instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Allows you to configure an optional maintenance window for the rollout of a job document to all devices in the
     * target group for a job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMaintenanceWindows} method.
     * </p>
     * 
     * @return Allows you to configure an optional maintenance window for the rollout of a job document to all devices
     *         in the target group for a job.
     */
    public final List<MaintenanceWindow> maintenanceWindows() {
        return maintenanceWindows;
    }

    /**
     * For responses, this returns true if the service returned a value for the DestinationPackageVersions property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasDestinationPackageVersions() {
        return destinationPackageVersions != null && !(destinationPackageVersions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The package version Amazon Resource Names (ARNs) that are installed on the device when the job successfully
     * completes. The package version must be in either the Published or Deprecated state when the job deploys. For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/iot/latest/developerguide/preparing-to-use-software-package-catalog.html#package-version-lifecycle"
     * >Package version lifecycle</a>.
     * </p>
     * <p>
     * <b>Note:</b>The following Length Constraints relates to a single ARN. Up to 25 package version ARNs are allowed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDestinationPackageVersions} method.
     * </p>
     * 
     * @return The package version Amazon Resource Names (ARNs) that are installed on the device when the job
     *         successfully completes. The package version must be in either the Published or Deprecated state when the
     *         job deploys. For more information, see <a href=
     *         "https://docs.aws.amazon.com/iot/latest/developerguide/preparing-to-use-software-package-catalog.html#package-version-lifecycle"
     *         >Package version lifecycle</a>.</p>
     *         <p>
     *         <b>Note:</b>The following Length Constraints relates to a single ARN. Up to 25 package version ARNs are
     *         allowed.
     */
    public final List<String> destinationPackageVersions() {
        return destinationPackageVersions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobTemplateArn());
        hashCode = 31 * hashCode + Objects.hashCode(jobTemplateId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(documentSource());
        hashCode = 31 * hashCode + Objects.hashCode(document());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(presignedUrlConfig());
        hashCode = 31 * hashCode + Objects.hashCode(jobExecutionsRolloutConfig());
        hashCode = 31 * hashCode + Objects.hashCode(abortConfig());
        hashCode = 31 * hashCode + Objects.hashCode(timeoutConfig());
        hashCode = 31 * hashCode + Objects.hashCode(jobExecutionsRetryConfig());
        hashCode = 31 * hashCode + Objects.hashCode(hasMaintenanceWindows() ? maintenanceWindows() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDestinationPackageVersions() ? destinationPackageVersions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeJobTemplateResponse)) {
            return false;
        }
        DescribeJobTemplateResponse other = (DescribeJobTemplateResponse) obj;
        return Objects.equals(jobTemplateArn(), other.jobTemplateArn()) && Objects.equals(jobTemplateId(), other.jobTemplateId())
                && Objects.equals(description(), other.description()) && Objects.equals(documentSource(), other.documentSource())
                && Objects.equals(document(), other.document()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(presignedUrlConfig(), other.presignedUrlConfig())
                && Objects.equals(jobExecutionsRolloutConfig(), other.jobExecutionsRolloutConfig())
                && Objects.equals(abortConfig(), other.abortConfig()) && Objects.equals(timeoutConfig(), other.timeoutConfig())
                && Objects.equals(jobExecutionsRetryConfig(), other.jobExecutionsRetryConfig())
                && hasMaintenanceWindows() == other.hasMaintenanceWindows()
                && Objects.equals(maintenanceWindows(), other.maintenanceWindows())
                && hasDestinationPackageVersions() == other.hasDestinationPackageVersions()
                && Objects.equals(destinationPackageVersions(), other.destinationPackageVersions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeJobTemplateResponse").add("JobTemplateArn", jobTemplateArn())
                .add("JobTemplateId", jobTemplateId()).add("Description", description()).add("DocumentSource", documentSource())
                .add("Document", document()).add("CreatedAt", createdAt()).add("PresignedUrlConfig", presignedUrlConfig())
                .add("JobExecutionsRolloutConfig", jobExecutionsRolloutConfig()).add("AbortConfig", abortConfig())
                .add("TimeoutConfig", timeoutConfig()).add("JobExecutionsRetryConfig", jobExecutionsRetryConfig())
                .add("MaintenanceWindows", hasMaintenanceWindows() ? maintenanceWindows() : null)
                .add("DestinationPackageVersions", hasDestinationPackageVersions() ? destinationPackageVersions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobTemplateArn":
            return Optional.ofNullable(clazz.cast(jobTemplateArn()));
        case "jobTemplateId":
            return Optional.ofNullable(clazz.cast(jobTemplateId()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "documentSource":
            return Optional.ofNullable(clazz.cast(documentSource()));
        case "document":
            return Optional.ofNullable(clazz.cast(document()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "presignedUrlConfig":
            return Optional.ofNullable(clazz.cast(presignedUrlConfig()));
        case "jobExecutionsRolloutConfig":
            return Optional.ofNullable(clazz.cast(jobExecutionsRolloutConfig()));
        case "abortConfig":
            return Optional.ofNullable(clazz.cast(abortConfig()));
        case "timeoutConfig":
            return Optional.ofNullable(clazz.cast(timeoutConfig()));
        case "jobExecutionsRetryConfig":
            return Optional.ofNullable(clazz.cast(jobExecutionsRetryConfig()));
        case "maintenanceWindows":
            return Optional.ofNullable(clazz.cast(maintenanceWindows()));
        case "destinationPackageVersions":
            return Optional.ofNullable(clazz.cast(destinationPackageVersions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeJobTemplateResponse, T> g) {
        return obj -> g.apply((DescribeJobTemplateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeJobTemplateResponse> {
        /**
         * <p>
         * The ARN of the job template.
         * </p>
         * 
         * @param jobTemplateArn
         *        The ARN of the job template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobTemplateArn(String jobTemplateArn);

        /**
         * <p>
         * The unique identifier of the job template.
         * </p>
         * 
         * @param jobTemplateId
         *        The unique identifier of the job template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobTemplateId(String jobTemplateId);

        /**
         * <p>
         * A description of the job template.
         * </p>
         * 
         * @param description
         *        A description of the job template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * An S3 link to the job document.
         * </p>
         * 
         * @param documentSource
         *        An S3 link to the job document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentSource(String documentSource);

        /**
         * <p>
         * The job document.
         * </p>
         * 
         * @param document
         *        The job document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder document(String document);

        /**
         * <p>
         * The time, in seconds since the epoch, when the job template was created.
         * </p>
         * 
         * @param createdAt
         *        The time, in seconds since the epoch, when the job template was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * Sets the value of the PresignedUrlConfig property for this object.
         *
         * @param presignedUrlConfig
         *        The new value for the PresignedUrlConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder presignedUrlConfig(PresignedUrlConfig presignedUrlConfig);

        /**
         * Sets the value of the PresignedUrlConfig property for this object.
         *
         * This is a convenience method that creates an instance of the {@link PresignedUrlConfig.Builder} avoiding the
         * need to create one manually via {@link PresignedUrlConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PresignedUrlConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #presignedUrlConfig(PresignedUrlConfig)}.
         * 
         * @param presignedUrlConfig
         *        a consumer that will call methods on {@link PresignedUrlConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #presignedUrlConfig(PresignedUrlConfig)
         */
        default Builder presignedUrlConfig(Consumer<PresignedUrlConfig.Builder> presignedUrlConfig) {
            return presignedUrlConfig(PresignedUrlConfig.builder().applyMutation(presignedUrlConfig).build());
        }

        /**
         * Sets the value of the JobExecutionsRolloutConfig property for this object.
         *
         * @param jobExecutionsRolloutConfig
         *        The new value for the JobExecutionsRolloutConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobExecutionsRolloutConfig(JobExecutionsRolloutConfig jobExecutionsRolloutConfig);

        /**
         * Sets the value of the JobExecutionsRolloutConfig property for this object.
         *
         * This is a convenience method that creates an instance of the {@link JobExecutionsRolloutConfig.Builder}
         * avoiding the need to create one manually via {@link JobExecutionsRolloutConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link JobExecutionsRolloutConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #jobExecutionsRolloutConfig(JobExecutionsRolloutConfig)}.
         * 
         * @param jobExecutionsRolloutConfig
         *        a consumer that will call methods on {@link JobExecutionsRolloutConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobExecutionsRolloutConfig(JobExecutionsRolloutConfig)
         */
        default Builder jobExecutionsRolloutConfig(Consumer<JobExecutionsRolloutConfig.Builder> jobExecutionsRolloutConfig) {
            return jobExecutionsRolloutConfig(JobExecutionsRolloutConfig.builder().applyMutation(jobExecutionsRolloutConfig)
                    .build());
        }

        /**
         * Sets the value of the AbortConfig property for this object.
         *
         * @param abortConfig
         *        The new value for the AbortConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder abortConfig(AbortConfig abortConfig);

        /**
         * Sets the value of the AbortConfig property for this object.
         *
         * This is a convenience method that creates an instance of the {@link AbortConfig.Builder} avoiding the need to
         * create one manually via {@link AbortConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AbortConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #abortConfig(AbortConfig)}.
         * 
         * @param abortConfig
         *        a consumer that will call methods on {@link AbortConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #abortConfig(AbortConfig)
         */
        default Builder abortConfig(Consumer<AbortConfig.Builder> abortConfig) {
            return abortConfig(AbortConfig.builder().applyMutation(abortConfig).build());
        }

        /**
         * Sets the value of the TimeoutConfig property for this object.
         *
         * @param timeoutConfig
         *        The new value for the TimeoutConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeoutConfig(TimeoutConfig timeoutConfig);

        /**
         * Sets the value of the TimeoutConfig property for this object.
         *
         * This is a convenience method that creates an instance of the {@link TimeoutConfig.Builder} avoiding the need
         * to create one manually via {@link TimeoutConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TimeoutConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #timeoutConfig(TimeoutConfig)}.
         * 
         * @param timeoutConfig
         *        a consumer that will call methods on {@link TimeoutConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timeoutConfig(TimeoutConfig)
         */
        default Builder timeoutConfig(Consumer<TimeoutConfig.Builder> timeoutConfig) {
            return timeoutConfig(TimeoutConfig.builder().applyMutation(timeoutConfig).build());
        }

        /**
         * <p>
         * The configuration that determines how many retries are allowed for each failure type for a job.
         * </p>
         * 
         * @param jobExecutionsRetryConfig
         *        The configuration that determines how many retries are allowed for each failure type for a job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobExecutionsRetryConfig(JobExecutionsRetryConfig jobExecutionsRetryConfig);

        /**
         * <p>
         * The configuration that determines how many retries are allowed for each failure type for a job.
         * </p>
         * This is a convenience method that creates an instance of the {@link JobExecutionsRetryConfig.Builder}
         * avoiding the need to create one manually via {@link JobExecutionsRetryConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link JobExecutionsRetryConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #jobExecutionsRetryConfig(JobExecutionsRetryConfig)}.
         * 
         * @param jobExecutionsRetryConfig
         *        a consumer that will call methods on {@link JobExecutionsRetryConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobExecutionsRetryConfig(JobExecutionsRetryConfig)
         */
        default Builder jobExecutionsRetryConfig(Consumer<JobExecutionsRetryConfig.Builder> jobExecutionsRetryConfig) {
            return jobExecutionsRetryConfig(JobExecutionsRetryConfig.builder().applyMutation(jobExecutionsRetryConfig).build());
        }

        /**
         * <p>
         * Allows you to configure an optional maintenance window for the rollout of a job document to all devices in
         * the target group for a job.
         * </p>
         * 
         * @param maintenanceWindows
         *        Allows you to configure an optional maintenance window for the rollout of a job document to all
         *        devices in the target group for a job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maintenanceWindows(Collection<MaintenanceWindow> maintenanceWindows);

        /**
         * <p>
         * Allows you to configure an optional maintenance window for the rollout of a job document to all devices in
         * the target group for a job.
         * </p>
         * 
         * @param maintenanceWindows
         *        Allows you to configure an optional maintenance window for the rollout of a job document to all
         *        devices in the target group for a job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maintenanceWindows(MaintenanceWindow... maintenanceWindows);

        /**
         * <p>
         * Allows you to configure an optional maintenance window for the rollout of a job document to all devices in
         * the target group for a job.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iot.model.MaintenanceWindow.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.iot.model.MaintenanceWindow#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iot.model.MaintenanceWindow.Builder#build()} is called immediately and
         * its result is passed to {@link #maintenanceWindows(List<MaintenanceWindow>)}.
         * 
         * @param maintenanceWindows
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iot.model.MaintenanceWindow.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #maintenanceWindows(java.util.Collection<MaintenanceWindow>)
         */
        Builder maintenanceWindows(Consumer<MaintenanceWindow.Builder>... maintenanceWindows);

        /**
         * <p>
         * The package version Amazon Resource Names (ARNs) that are installed on the device when the job successfully
         * completes. The package version must be in either the Published or Deprecated state when the job deploys. For
         * more information, see <a href=
         * "https://docs.aws.amazon.com/iot/latest/developerguide/preparing-to-use-software-package-catalog.html#package-version-lifecycle"
         * >Package version lifecycle</a>.
         * </p>
         * <p>
         * <b>Note:</b>The following Length Constraints relates to a single ARN. Up to 25 package version ARNs are
         * allowed.
         * </p>
         * 
         * @param destinationPackageVersions
         *        The package version Amazon Resource Names (ARNs) that are installed on the device when the job
         *        successfully completes. The package version must be in either the Published or Deprecated state when
         *        the job deploys. For more information, see <a href=
         *        "https://docs.aws.amazon.com/iot/latest/developerguide/preparing-to-use-software-package-catalog.html#package-version-lifecycle"
         *        >Package version lifecycle</a>.</p>
         *        <p>
         *        <b>Note:</b>The following Length Constraints relates to a single ARN. Up to 25 package version ARNs
         *        are allowed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationPackageVersions(Collection<String> destinationPackageVersions);

        /**
         * <p>
         * The package version Amazon Resource Names (ARNs) that are installed on the device when the job successfully
         * completes. The package version must be in either the Published or Deprecated state when the job deploys. For
         * more information, see <a href=
         * "https://docs.aws.amazon.com/iot/latest/developerguide/preparing-to-use-software-package-catalog.html#package-version-lifecycle"
         * >Package version lifecycle</a>.
         * </p>
         * <p>
         * <b>Note:</b>The following Length Constraints relates to a single ARN. Up to 25 package version ARNs are
         * allowed.
         * </p>
         * 
         * @param destinationPackageVersions
         *        The package version Amazon Resource Names (ARNs) that are installed on the device when the job
         *        successfully completes. The package version must be in either the Published or Deprecated state when
         *        the job deploys. For more information, see <a href=
         *        "https://docs.aws.amazon.com/iot/latest/developerguide/preparing-to-use-software-package-catalog.html#package-version-lifecycle"
         *        >Package version lifecycle</a>.</p>
         *        <p>
         *        <b>Note:</b>The following Length Constraints relates to a single ARN. Up to 25 package version ARNs
         *        are allowed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationPackageVersions(String... destinationPackageVersions);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private String jobTemplateArn;

        private String jobTemplateId;

        private String description;

        private String documentSource;

        private String document;

        private Instant createdAt;

        private PresignedUrlConfig presignedUrlConfig;

        private JobExecutionsRolloutConfig jobExecutionsRolloutConfig;

        private AbortConfig abortConfig;

        private TimeoutConfig timeoutConfig;

        private JobExecutionsRetryConfig jobExecutionsRetryConfig;

        private List<MaintenanceWindow> maintenanceWindows = DefaultSdkAutoConstructList.getInstance();

        private List<String> destinationPackageVersions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeJobTemplateResponse model) {
            super(model);
            jobTemplateArn(model.jobTemplateArn);
            jobTemplateId(model.jobTemplateId);
            description(model.description);
            documentSource(model.documentSource);
            document(model.document);
            createdAt(model.createdAt);
            presignedUrlConfig(model.presignedUrlConfig);
            jobExecutionsRolloutConfig(model.jobExecutionsRolloutConfig);
            abortConfig(model.abortConfig);
            timeoutConfig(model.timeoutConfig);
            jobExecutionsRetryConfig(model.jobExecutionsRetryConfig);
            maintenanceWindows(model.maintenanceWindows);
            destinationPackageVersions(model.destinationPackageVersions);
        }

        public final String getJobTemplateArn() {
            return jobTemplateArn;
        }

        public final void setJobTemplateArn(String jobTemplateArn) {
            this.jobTemplateArn = jobTemplateArn;
        }

        @Override
        public final Builder jobTemplateArn(String jobTemplateArn) {
            this.jobTemplateArn = jobTemplateArn;
            return this;
        }

        public final String getJobTemplateId() {
            return jobTemplateId;
        }

        public final void setJobTemplateId(String jobTemplateId) {
            this.jobTemplateId = jobTemplateId;
        }

        @Override
        public final Builder jobTemplateId(String jobTemplateId) {
            this.jobTemplateId = jobTemplateId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDocumentSource() {
            return documentSource;
        }

        public final void setDocumentSource(String documentSource) {
            this.documentSource = documentSource;
        }

        @Override
        public final Builder documentSource(String documentSource) {
            this.documentSource = documentSource;
            return this;
        }

        public final String getDocument() {
            return document;
        }

        public final void setDocument(String document) {
            this.document = document;
        }

        @Override
        public final Builder document(String document) {
            this.document = document;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final PresignedUrlConfig.Builder getPresignedUrlConfig() {
            return presignedUrlConfig != null ? presignedUrlConfig.toBuilder() : null;
        }

        public final void setPresignedUrlConfig(PresignedUrlConfig.BuilderImpl presignedUrlConfig) {
            this.presignedUrlConfig = presignedUrlConfig != null ? presignedUrlConfig.build() : null;
        }

        @Override
        public final Builder presignedUrlConfig(PresignedUrlConfig presignedUrlConfig) {
            this.presignedUrlConfig = presignedUrlConfig;
            return this;
        }

        public final JobExecutionsRolloutConfig.Builder getJobExecutionsRolloutConfig() {
            return jobExecutionsRolloutConfig != null ? jobExecutionsRolloutConfig.toBuilder() : null;
        }

        public final void setJobExecutionsRolloutConfig(JobExecutionsRolloutConfig.BuilderImpl jobExecutionsRolloutConfig) {
            this.jobExecutionsRolloutConfig = jobExecutionsRolloutConfig != null ? jobExecutionsRolloutConfig.build() : null;
        }

        @Override
        public final Builder jobExecutionsRolloutConfig(JobExecutionsRolloutConfig jobExecutionsRolloutConfig) {
            this.jobExecutionsRolloutConfig = jobExecutionsRolloutConfig;
            return this;
        }

        public final AbortConfig.Builder getAbortConfig() {
            return abortConfig != null ? abortConfig.toBuilder() : null;
        }

        public final void setAbortConfig(AbortConfig.BuilderImpl abortConfig) {
            this.abortConfig = abortConfig != null ? abortConfig.build() : null;
        }

        @Override
        public final Builder abortConfig(AbortConfig abortConfig) {
            this.abortConfig = abortConfig;
            return this;
        }

        public final TimeoutConfig.Builder getTimeoutConfig() {
            return timeoutConfig != null ? timeoutConfig.toBuilder() : null;
        }

        public final void setTimeoutConfig(TimeoutConfig.BuilderImpl timeoutConfig) {
            this.timeoutConfig = timeoutConfig != null ? timeoutConfig.build() : null;
        }

        @Override
        public final Builder timeoutConfig(TimeoutConfig timeoutConfig) {
            this.timeoutConfig = timeoutConfig;
            return this;
        }

        public final JobExecutionsRetryConfig.Builder getJobExecutionsRetryConfig() {
            return jobExecutionsRetryConfig != null ? jobExecutionsRetryConfig.toBuilder() : null;
        }

        public final void setJobExecutionsRetryConfig(JobExecutionsRetryConfig.BuilderImpl jobExecutionsRetryConfig) {
            this.jobExecutionsRetryConfig = jobExecutionsRetryConfig != null ? jobExecutionsRetryConfig.build() : null;
        }

        @Override
        public final Builder jobExecutionsRetryConfig(JobExecutionsRetryConfig jobExecutionsRetryConfig) {
            this.jobExecutionsRetryConfig = jobExecutionsRetryConfig;
            return this;
        }

        public final List<MaintenanceWindow.Builder> getMaintenanceWindows() {
            List<MaintenanceWindow.Builder> result = MaintenanceWindowsCopier.copyToBuilder(this.maintenanceWindows);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMaintenanceWindows(Collection<MaintenanceWindow.BuilderImpl> maintenanceWindows) {
            this.maintenanceWindows = MaintenanceWindowsCopier.copyFromBuilder(maintenanceWindows);
        }

        @Override
        public final Builder maintenanceWindows(Collection<MaintenanceWindow> maintenanceWindows) {
            this.maintenanceWindows = MaintenanceWindowsCopier.copy(maintenanceWindows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder maintenanceWindows(MaintenanceWindow... maintenanceWindows) {
            maintenanceWindows(Arrays.asList(maintenanceWindows));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder maintenanceWindows(Consumer<MaintenanceWindow.Builder>... maintenanceWindows) {
            maintenanceWindows(Stream.of(maintenanceWindows).map(c -> MaintenanceWindow.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getDestinationPackageVersions() {
            if (destinationPackageVersions instanceof SdkAutoConstructList) {
                return null;
            }
            return destinationPackageVersions;
        }

        public final void setDestinationPackageVersions(Collection<String> destinationPackageVersions) {
            this.destinationPackageVersions = DestinationPackageVersionsCopier.copy(destinationPackageVersions);
        }

        @Override
        public final Builder destinationPackageVersions(Collection<String> destinationPackageVersions) {
            this.destinationPackageVersions = DestinationPackageVersionsCopier.copy(destinationPackageVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder destinationPackageVersions(String... destinationPackageVersions) {
            destinationPackageVersions(Arrays.asList(destinationPackageVersions));
            return this;
        }

        @Override
        public DescribeJobTemplateResponse build() {
            return new DescribeJobTemplateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
