/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateCertificateProviderRequest extends IotRequest implements
        ToCopyableBuilder<UpdateCertificateProviderRequest.Builder, UpdateCertificateProviderRequest> {
    private static final SdkField<String> CERTIFICATE_PROVIDER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("certificateProviderName").getter(getter(UpdateCertificateProviderRequest::certificateProviderName))
            .setter(setter(Builder::certificateProviderName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("certificateProviderName").build())
            .build();

    private static final SdkField<String> LAMBDA_FUNCTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lambdaFunctionArn").getter(getter(UpdateCertificateProviderRequest::lambdaFunctionArn))
            .setter(setter(Builder::lambdaFunctionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambdaFunctionArn").build()).build();

    private static final SdkField<List<String>> ACCOUNT_DEFAULT_FOR_OPERATIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("accountDefaultForOperations")
            .getter(getter(UpdateCertificateProviderRequest::accountDefaultForOperationsAsStrings))
            .setter(setter(Builder::accountDefaultForOperationsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountDefaultForOperations")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CERTIFICATE_PROVIDER_NAME_FIELD, LAMBDA_FUNCTION_ARN_FIELD, ACCOUNT_DEFAULT_FOR_OPERATIONS_FIELD));

    private final String certificateProviderName;

    private final String lambdaFunctionArn;

    private final List<String> accountDefaultForOperations;

    private UpdateCertificateProviderRequest(BuilderImpl builder) {
        super(builder);
        this.certificateProviderName = builder.certificateProviderName;
        this.lambdaFunctionArn = builder.lambdaFunctionArn;
        this.accountDefaultForOperations = builder.accountDefaultForOperations;
    }

    /**
     * <p>
     * The name of the certificate provider.
     * </p>
     * 
     * @return The name of the certificate provider.
     */
    public final String certificateProviderName() {
        return certificateProviderName;
    }

    /**
     * <p>
     * The Lambda function ARN that's associated with the certificate provider.
     * </p>
     * 
     * @return The Lambda function ARN that's associated with the certificate provider.
     */
    public final String lambdaFunctionArn() {
        return lambdaFunctionArn;
    }

    /**
     * <p>
     * A list of the operations that the certificate provider will use to generate certificates. Valid value:
     * <code>CreateCertificateFromCsr</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccountDefaultForOperations} method.
     * </p>
     * 
     * @return A list of the operations that the certificate provider will use to generate certificates. Valid value:
     *         <code>CreateCertificateFromCsr</code>.
     */
    public final List<CertificateProviderOperation> accountDefaultForOperations() {
        return CertificateProviderAccountDefaultForOperationsCopier.copyStringToEnum(accountDefaultForOperations);
    }

    /**
     * For responses, this returns true if the service returned a value for the AccountDefaultForOperations property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAccountDefaultForOperations() {
        return accountDefaultForOperations != null && !(accountDefaultForOperations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the operations that the certificate provider will use to generate certificates. Valid value:
     * <code>CreateCertificateFromCsr</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccountDefaultForOperations} method.
     * </p>
     * 
     * @return A list of the operations that the certificate provider will use to generate certificates. Valid value:
     *         <code>CreateCertificateFromCsr</code>.
     */
    public final List<String> accountDefaultForOperationsAsStrings() {
        return accountDefaultForOperations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(certificateProviderName());
        hashCode = 31 * hashCode + Objects.hashCode(lambdaFunctionArn());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasAccountDefaultForOperations() ? accountDefaultForOperationsAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCertificateProviderRequest)) {
            return false;
        }
        UpdateCertificateProviderRequest other = (UpdateCertificateProviderRequest) obj;
        return Objects.equals(certificateProviderName(), other.certificateProviderName())
                && Objects.equals(lambdaFunctionArn(), other.lambdaFunctionArn())
                && hasAccountDefaultForOperations() == other.hasAccountDefaultForOperations()
                && Objects.equals(accountDefaultForOperationsAsStrings(), other.accountDefaultForOperationsAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("UpdateCertificateProviderRequest")
                .add("CertificateProviderName", certificateProviderName())
                .add("LambdaFunctionArn", lambdaFunctionArn())
                .add("AccountDefaultForOperations",
                        hasAccountDefaultForOperations() ? accountDefaultForOperationsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "certificateProviderName":
            return Optional.ofNullable(clazz.cast(certificateProviderName()));
        case "lambdaFunctionArn":
            return Optional.ofNullable(clazz.cast(lambdaFunctionArn()));
        case "accountDefaultForOperations":
            return Optional.ofNullable(clazz.cast(accountDefaultForOperationsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateCertificateProviderRequest, T> g) {
        return obj -> g.apply((UpdateCertificateProviderRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateCertificateProviderRequest> {
        /**
         * <p>
         * The name of the certificate provider.
         * </p>
         * 
         * @param certificateProviderName
         *        The name of the certificate provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateProviderName(String certificateProviderName);

        /**
         * <p>
         * The Lambda function ARN that's associated with the certificate provider.
         * </p>
         * 
         * @param lambdaFunctionArn
         *        The Lambda function ARN that's associated with the certificate provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaFunctionArn(String lambdaFunctionArn);

        /**
         * <p>
         * A list of the operations that the certificate provider will use to generate certificates. Valid value:
         * <code>CreateCertificateFromCsr</code>.
         * </p>
         * 
         * @param accountDefaultForOperations
         *        A list of the operations that the certificate provider will use to generate certificates. Valid value:
         *        <code>CreateCertificateFromCsr</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountDefaultForOperationsWithStrings(Collection<String> accountDefaultForOperations);

        /**
         * <p>
         * A list of the operations that the certificate provider will use to generate certificates. Valid value:
         * <code>CreateCertificateFromCsr</code>.
         * </p>
         * 
         * @param accountDefaultForOperations
         *        A list of the operations that the certificate provider will use to generate certificates. Valid value:
         *        <code>CreateCertificateFromCsr</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountDefaultForOperationsWithStrings(String... accountDefaultForOperations);

        /**
         * <p>
         * A list of the operations that the certificate provider will use to generate certificates. Valid value:
         * <code>CreateCertificateFromCsr</code>.
         * </p>
         * 
         * @param accountDefaultForOperations
         *        A list of the operations that the certificate provider will use to generate certificates. Valid value:
         *        <code>CreateCertificateFromCsr</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountDefaultForOperations(Collection<CertificateProviderOperation> accountDefaultForOperations);

        /**
         * <p>
         * A list of the operations that the certificate provider will use to generate certificates. Valid value:
         * <code>CreateCertificateFromCsr</code>.
         * </p>
         * 
         * @param accountDefaultForOperations
         *        A list of the operations that the certificate provider will use to generate certificates. Valid value:
         *        <code>CreateCertificateFromCsr</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountDefaultForOperations(CertificateProviderOperation... accountDefaultForOperations);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String certificateProviderName;

        private String lambdaFunctionArn;

        private List<String> accountDefaultForOperations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCertificateProviderRequest model) {
            super(model);
            certificateProviderName(model.certificateProviderName);
            lambdaFunctionArn(model.lambdaFunctionArn);
            accountDefaultForOperationsWithStrings(model.accountDefaultForOperations);
        }

        public final String getCertificateProviderName() {
            return certificateProviderName;
        }

        public final void setCertificateProviderName(String certificateProviderName) {
            this.certificateProviderName = certificateProviderName;
        }

        @Override
        public final Builder certificateProviderName(String certificateProviderName) {
            this.certificateProviderName = certificateProviderName;
            return this;
        }

        public final String getLambdaFunctionArn() {
            return lambdaFunctionArn;
        }

        public final void setLambdaFunctionArn(String lambdaFunctionArn) {
            this.lambdaFunctionArn = lambdaFunctionArn;
        }

        @Override
        public final Builder lambdaFunctionArn(String lambdaFunctionArn) {
            this.lambdaFunctionArn = lambdaFunctionArn;
            return this;
        }

        public final Collection<String> getAccountDefaultForOperations() {
            if (accountDefaultForOperations instanceof SdkAutoConstructList) {
                return null;
            }
            return accountDefaultForOperations;
        }

        public final void setAccountDefaultForOperations(Collection<String> accountDefaultForOperations) {
            this.accountDefaultForOperations = CertificateProviderAccountDefaultForOperationsCopier
                    .copy(accountDefaultForOperations);
        }

        @Override
        public final Builder accountDefaultForOperationsWithStrings(Collection<String> accountDefaultForOperations) {
            this.accountDefaultForOperations = CertificateProviderAccountDefaultForOperationsCopier
                    .copy(accountDefaultForOperations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountDefaultForOperationsWithStrings(String... accountDefaultForOperations) {
            accountDefaultForOperationsWithStrings(Arrays.asList(accountDefaultForOperations));
            return this;
        }

        @Override
        public final Builder accountDefaultForOperations(Collection<CertificateProviderOperation> accountDefaultForOperations) {
            this.accountDefaultForOperations = CertificateProviderAccountDefaultForOperationsCopier
                    .copyEnumToString(accountDefaultForOperations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountDefaultForOperations(CertificateProviderOperation... accountDefaultForOperations) {
            accountDefaultForOperations(Arrays.asList(accountDefaultForOperations));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateCertificateProviderRequest build() {
            return new UpdateCertificateProviderRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
