/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotClient;
import software.amazon.awssdk.services.iot.internal.UserAgentUtils;
import software.amazon.awssdk.services.iot.model.ListTopicRulesRequest;
import software.amazon.awssdk.services.iot.model.ListTopicRulesResponse;
import software.amazon.awssdk.services.iot.model.TopicRuleListItem;

public class ListTopicRulesIterable
implements SdkIterable<ListTopicRulesResponse> {
    private final IotClient client;
    private final ListTopicRulesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTopicRulesIterable(IotClient client, ListTopicRulesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListTopicRulesResponseFetcher();
    }

    public Iterator<ListTopicRulesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TopicRuleListItem> rules() {
        Function<ListTopicRulesResponse, Iterator> getIterator = response -> {
            if (response != null && response.rules() != null) {
                return response.rules().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListTopicRulesResponseFetcher
    implements SyncPageFetcher<ListTopicRulesResponse> {
        private ListTopicRulesResponseFetcher() {
        }

        public boolean hasNextPage(ListTopicRulesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTopicRulesResponse nextPage(ListTopicRulesResponse previousPage) {
            if (previousPage == null) {
                return ListTopicRulesIterable.this.client.listTopicRules(ListTopicRulesIterable.this.firstRequest);
            }
            return ListTopicRulesIterable.this.client.listTopicRules((ListTopicRulesRequest)((Object)ListTopicRulesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

