/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotClient;
import software.amazon.awssdk.services.iot.internal.UserAgentUtils;
import software.amazon.awssdk.services.iot.model.ListSecurityProfilesForTargetRequest;
import software.amazon.awssdk.services.iot.model.ListSecurityProfilesForTargetResponse;
import software.amazon.awssdk.services.iot.model.SecurityProfileTargetMapping;

public class ListSecurityProfilesForTargetIterable
implements SdkIterable<ListSecurityProfilesForTargetResponse> {
    private final IotClient client;
    private final ListSecurityProfilesForTargetRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSecurityProfilesForTargetIterable(IotClient client, ListSecurityProfilesForTargetRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListSecurityProfilesForTargetResponseFetcher();
    }

    public Iterator<ListSecurityProfilesForTargetResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SecurityProfileTargetMapping> securityProfileTargetMappings() {
        Function<ListSecurityProfilesForTargetResponse, Iterator> getIterator = response -> {
            if (response != null && response.securityProfileTargetMappings() != null) {
                return response.securityProfileTargetMappings().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListSecurityProfilesForTargetResponseFetcher
    implements SyncPageFetcher<ListSecurityProfilesForTargetResponse> {
        private ListSecurityProfilesForTargetResponseFetcher() {
        }

        public boolean hasNextPage(ListSecurityProfilesForTargetResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSecurityProfilesForTargetResponse nextPage(ListSecurityProfilesForTargetResponse previousPage) {
            if (previousPage == null) {
                return ListSecurityProfilesForTargetIterable.this.client.listSecurityProfilesForTarget(ListSecurityProfilesForTargetIterable.this.firstRequest);
            }
            return ListSecurityProfilesForTargetIterable.this.client.listSecurityProfilesForTarget((ListSecurityProfilesForTargetRequest)((Object)ListSecurityProfilesForTargetIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

