/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCardinalityResponse extends IotResponse implements
        ToCopyableBuilder<GetCardinalityResponse.Builder, GetCardinalityResponse> {
    private static final SdkField<Integer> CARDINALITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("cardinality").getter(getter(GetCardinalityResponse::cardinality)).setter(setter(Builder::cardinality))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cardinality").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CARDINALITY_FIELD));

    private final Integer cardinality;

    private GetCardinalityResponse(BuilderImpl builder) {
        super(builder);
        this.cardinality = builder.cardinality;
    }

    /**
     * <p>
     * The approximate count of unique values that match the query.
     * </p>
     * 
     * @return The approximate count of unique values that match the query.
     */
    public final Integer cardinality() {
        return cardinality;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(cardinality());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCardinalityResponse)) {
            return false;
        }
        GetCardinalityResponse other = (GetCardinalityResponse) obj;
        return Objects.equals(cardinality(), other.cardinality());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCardinalityResponse").add("Cardinality", cardinality()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cardinality":
            return Optional.ofNullable(clazz.cast(cardinality()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetCardinalityResponse, T> g) {
        return obj -> g.apply((GetCardinalityResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetCardinalityResponse> {
        /**
         * <p>
         * The approximate count of unique values that match the query.
         * </p>
         * 
         * @param cardinality
         *        The approximate count of unique values that match the query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cardinality(Integer cardinality);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private Integer cardinality;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCardinalityResponse model) {
            super(model);
            cardinality(model.cardinality);
        }

        public final Integer getCardinality() {
            return cardinality;
        }

        public final void setCardinality(Integer cardinality) {
            this.cardinality = cardinality;
        }

        @Override
        public final Builder cardinality(Integer cardinality) {
            this.cardinality = cardinality;
            return this;
        }

        @Override
        public GetCardinalityResponse build() {
            return new GetCardinalityResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
