/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PackageVersionAction {
    PUBLISH("PUBLISH"),
    DEPRECATE("DEPRECATE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PackageVersionAction> VALUE_MAP;
    private final String value;

    private PackageVersionAction(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PackageVersionAction fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PackageVersionAction> knownValues() {
        EnumSet<PackageVersionAction> knownValues = EnumSet.allOf(PackageVersionAction.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PackageVersionAction.class, PackageVersionAction::toString);
    }
}

