/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that speciﬁes the client certificate conﬁguration for a domain.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClientCertificateConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<ClientCertificateConfig.Builder, ClientCertificateConfig> {
    private static final SdkField<String> CLIENT_CERTIFICATE_CALLBACK_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientCertificateCallbackArn")
            .getter(getter(ClientCertificateConfig::clientCertificateCallbackArn))
            .setter(setter(Builder::clientCertificateCallbackArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientCertificateCallbackArn")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CLIENT_CERTIFICATE_CALLBACK_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String clientCertificateCallbackArn;

    private ClientCertificateConfig(BuilderImpl builder) {
        this.clientCertificateCallbackArn = builder.clientCertificateCallbackArn;
    }

    /**
     * <p>
     * The ARN of the Lambda function that IoT invokes after mutual TLS authentication during the connection.
     * </p>
     * 
     * @return The ARN of the Lambda function that IoT invokes after mutual TLS authentication during the connection.
     */
    public final String clientCertificateCallbackArn() {
        return clientCertificateCallbackArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clientCertificateCallbackArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClientCertificateConfig)) {
            return false;
        }
        ClientCertificateConfig other = (ClientCertificateConfig) obj;
        return Objects.equals(clientCertificateCallbackArn(), other.clientCertificateCallbackArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ClientCertificateConfig").add("ClientCertificateCallbackArn", clientCertificateCallbackArn())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientCertificateCallbackArn":
            return Optional.ofNullable(clazz.cast(clientCertificateCallbackArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ClientCertificateConfig, T> g) {
        return obj -> g.apply((ClientCertificateConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClientCertificateConfig> {
        /**
         * <p>
         * The ARN of the Lambda function that IoT invokes after mutual TLS authentication during the connection.
         * </p>
         * 
         * @param clientCertificateCallbackArn
         *        The ARN of the Lambda function that IoT invokes after mutual TLS authentication during the connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientCertificateCallbackArn(String clientCertificateCallbackArn);
    }

    static final class BuilderImpl implements Builder {
        private String clientCertificateCallbackArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ClientCertificateConfig model) {
            clientCertificateCallbackArn(model.clientCertificateCallbackArn);
        }

        public final String getClientCertificateCallbackArn() {
            return clientCertificateCallbackArn;
        }

        public final void setClientCertificateCallbackArn(String clientCertificateCallbackArn) {
            this.clientCertificateCallbackArn = clientCertificateCallbackArn;
        }

        @Override
        public final Builder clientCertificateCallbackArn(String clientCertificateCallbackArn) {
            this.clientCertificateCallbackArn = clientCertificateCallbackArn;
            return this;
        }

        @Override
        public ClientCertificateConfig build() {
            return new ClientCertificateConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
