/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The thing search index document.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ThingDocument implements SdkPojo, Serializable, ToCopyableBuilder<ThingDocument.Builder, ThingDocument> {
    private static final SdkField<String> THING_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("thingName").getter(getter(ThingDocument::thingName)).setter(setter(Builder::thingName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingName").build()).build();

    private static final SdkField<String> THING_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("thingId").getter(getter(ThingDocument::thingId)).setter(setter(Builder::thingId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingId").build()).build();

    private static final SdkField<String> THING_TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("thingTypeName").getter(getter(ThingDocument::thingTypeName)).setter(setter(Builder::thingTypeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingTypeName").build()).build();

    private static final SdkField<List<String>> THING_GROUP_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("thingGroupNames")
            .getter(getter(ThingDocument::thingGroupNames))
            .setter(setter(Builder::thingGroupNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingGroupNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("attributes")
            .getter(getter(ThingDocument::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> SHADOW_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("shadow")
            .getter(getter(ThingDocument::shadow)).setter(setter(Builder::shadow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shadow").build()).build();

    private static final SdkField<String> DEVICE_DEFENDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deviceDefender").getter(getter(ThingDocument::deviceDefender)).setter(setter(Builder::deviceDefender))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceDefender").build()).build();

    private static final SdkField<ThingConnectivity> CONNECTIVITY_FIELD = SdkField
            .<ThingConnectivity> builder(MarshallingType.SDK_POJO).memberName("connectivity")
            .getter(getter(ThingDocument::connectivity)).setter(setter(Builder::connectivity))
            .constructor(ThingConnectivity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectivity").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THING_NAME_FIELD,
            THING_ID_FIELD, THING_TYPE_NAME_FIELD, THING_GROUP_NAMES_FIELD, ATTRIBUTES_FIELD, SHADOW_FIELD,
            DEVICE_DEFENDER_FIELD, CONNECTIVITY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String thingName;

    private final String thingId;

    private final String thingTypeName;

    private final List<String> thingGroupNames;

    private final Map<String, String> attributes;

    private final String shadow;

    private final String deviceDefender;

    private final ThingConnectivity connectivity;

    private ThingDocument(BuilderImpl builder) {
        this.thingName = builder.thingName;
        this.thingId = builder.thingId;
        this.thingTypeName = builder.thingTypeName;
        this.thingGroupNames = builder.thingGroupNames;
        this.attributes = builder.attributes;
        this.shadow = builder.shadow;
        this.deviceDefender = builder.deviceDefender;
        this.connectivity = builder.connectivity;
    }

    /**
     * <p>
     * The thing name.
     * </p>
     * 
     * @return The thing name.
     */
    public final String thingName() {
        return thingName;
    }

    /**
     * <p>
     * The thing ID.
     * </p>
     * 
     * @return The thing ID.
     */
    public final String thingId() {
        return thingId;
    }

    /**
     * <p>
     * The thing type name.
     * </p>
     * 
     * @return The thing type name.
     */
    public final String thingTypeName() {
        return thingTypeName;
    }

    /**
     * For responses, this returns true if the service returned a value for the ThingGroupNames property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasThingGroupNames() {
        return thingGroupNames != null && !(thingGroupNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Thing group and billing group names.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasThingGroupNames} method.
     * </p>
     * 
     * @return Thing group and billing group names.
     */
    public final List<String> thingGroupNames() {
        return thingGroupNames;
    }

    /**
     * For responses, this returns true if the service returned a value for the Attributes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAttributes() {
        return attributes != null && !(attributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The attributes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributes} method.
     * </p>
     * 
     * @return The attributes.
     */
    public final Map<String, String> attributes() {
        return attributes;
    }

    /**
     * <p>
     * The unnamed shadow and named shadow.
     * </p>
     * <p>
     * For more information about shadows, see <a
     * href="https://docs.aws.amazon.com/iot/latest/developerguide/iot-device-shadows.html">IoT Device Shadow
     * service.</a>
     * </p>
     * 
     * @return The unnamed shadow and named shadow.</p>
     *         <p>
     *         For more information about shadows, see <a
     *         href="https://docs.aws.amazon.com/iot/latest/developerguide/iot-device-shadows.html">IoT Device Shadow
     *         service.</a>
     */
    public final String shadow() {
        return shadow;
    }

    /**
     * <p>
     * Contains Device Defender data.
     * </p>
     * <p>
     * For more information about Device Defender, see <a
     * href="https://docs.aws.amazon.com/iot/latest/developerguide/device-defender.html">Device Defender</a>.
     * </p>
     * 
     * @return Contains Device Defender data.</p>
     *         <p>
     *         For more information about Device Defender, see <a
     *         href="https://docs.aws.amazon.com/iot/latest/developerguide/device-defender.html">Device Defender</a>.
     */
    public final String deviceDefender() {
        return deviceDefender;
    }

    /**
     * <p>
     * Indicates whether the thing is connected to the Amazon Web Services IoT Core service.
     * </p>
     * 
     * @return Indicates whether the thing is connected to the Amazon Web Services IoT Core service.
     */
    public final ThingConnectivity connectivity() {
        return connectivity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(thingName());
        hashCode = 31 * hashCode + Objects.hashCode(thingId());
        hashCode = 31 * hashCode + Objects.hashCode(thingTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(hasThingGroupNames() ? thingGroupNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributes() ? attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(shadow());
        hashCode = 31 * hashCode + Objects.hashCode(deviceDefender());
        hashCode = 31 * hashCode + Objects.hashCode(connectivity());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThingDocument)) {
            return false;
        }
        ThingDocument other = (ThingDocument) obj;
        return Objects.equals(thingName(), other.thingName()) && Objects.equals(thingId(), other.thingId())
                && Objects.equals(thingTypeName(), other.thingTypeName()) && hasThingGroupNames() == other.hasThingGroupNames()
                && Objects.equals(thingGroupNames(), other.thingGroupNames()) && hasAttributes() == other.hasAttributes()
                && Objects.equals(attributes(), other.attributes()) && Objects.equals(shadow(), other.shadow())
                && Objects.equals(deviceDefender(), other.deviceDefender())
                && Objects.equals(connectivity(), other.connectivity());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ThingDocument").add("ThingName", thingName()).add("ThingId", thingId())
                .add("ThingTypeName", thingTypeName()).add("ThingGroupNames", hasThingGroupNames() ? thingGroupNames() : null)
                .add("Attributes", hasAttributes() ? attributes() : null).add("Shadow", shadow())
                .add("DeviceDefender", deviceDefender()).add("Connectivity", connectivity()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "thingName":
            return Optional.ofNullable(clazz.cast(thingName()));
        case "thingId":
            return Optional.ofNullable(clazz.cast(thingId()));
        case "thingTypeName":
            return Optional.ofNullable(clazz.cast(thingTypeName()));
        case "thingGroupNames":
            return Optional.ofNullable(clazz.cast(thingGroupNames()));
        case "attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        case "shadow":
            return Optional.ofNullable(clazz.cast(shadow()));
        case "deviceDefender":
            return Optional.ofNullable(clazz.cast(deviceDefender()));
        case "connectivity":
            return Optional.ofNullable(clazz.cast(connectivity()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ThingDocument, T> g) {
        return obj -> g.apply((ThingDocument) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ThingDocument> {
        /**
         * <p>
         * The thing name.
         * </p>
         * 
         * @param thingName
         *        The thing name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingName(String thingName);

        /**
         * <p>
         * The thing ID.
         * </p>
         * 
         * @param thingId
         *        The thing ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingId(String thingId);

        /**
         * <p>
         * The thing type name.
         * </p>
         * 
         * @param thingTypeName
         *        The thing type name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingTypeName(String thingTypeName);

        /**
         * <p>
         * Thing group and billing group names.
         * </p>
         * 
         * @param thingGroupNames
         *        Thing group and billing group names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingGroupNames(Collection<String> thingGroupNames);

        /**
         * <p>
         * Thing group and billing group names.
         * </p>
         * 
         * @param thingGroupNames
         *        Thing group and billing group names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingGroupNames(String... thingGroupNames);

        /**
         * <p>
         * The attributes.
         * </p>
         * 
         * @param attributes
         *        The attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Map<String, String> attributes);

        /**
         * <p>
         * The unnamed shadow and named shadow.
         * </p>
         * <p>
         * For more information about shadows, see <a
         * href="https://docs.aws.amazon.com/iot/latest/developerguide/iot-device-shadows.html">IoT Device Shadow
         * service.</a>
         * </p>
         * 
         * @param shadow
         *        The unnamed shadow and named shadow.</p>
         *        <p>
         *        For more information about shadows, see <a
         *        href="https://docs.aws.amazon.com/iot/latest/developerguide/iot-device-shadows.html">IoT Device Shadow
         *        service.</a>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shadow(String shadow);

        /**
         * <p>
         * Contains Device Defender data.
         * </p>
         * <p>
         * For more information about Device Defender, see <a
         * href="https://docs.aws.amazon.com/iot/latest/developerguide/device-defender.html">Device Defender</a>.
         * </p>
         * 
         * @param deviceDefender
         *        Contains Device Defender data.</p>
         *        <p>
         *        For more information about Device Defender, see <a
         *        href="https://docs.aws.amazon.com/iot/latest/developerguide/device-defender.html">Device Defender</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceDefender(String deviceDefender);

        /**
         * <p>
         * Indicates whether the thing is connected to the Amazon Web Services IoT Core service.
         * </p>
         * 
         * @param connectivity
         *        Indicates whether the thing is connected to the Amazon Web Services IoT Core service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectivity(ThingConnectivity connectivity);

        /**
         * <p>
         * Indicates whether the thing is connected to the Amazon Web Services IoT Core service.
         * </p>
         * This is a convenience method that creates an instance of the {@link ThingConnectivity.Builder} avoiding the
         * need to create one manually via {@link ThingConnectivity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ThingConnectivity.Builder#build()} is called immediately and its
         * result is passed to {@link #connectivity(ThingConnectivity)}.
         * 
         * @param connectivity
         *        a consumer that will call methods on {@link ThingConnectivity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connectivity(ThingConnectivity)
         */
        default Builder connectivity(Consumer<ThingConnectivity.Builder> connectivity) {
            return connectivity(ThingConnectivity.builder().applyMutation(connectivity).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String thingName;

        private String thingId;

        private String thingTypeName;

        private List<String> thingGroupNames = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();

        private String shadow;

        private String deviceDefender;

        private ThingConnectivity connectivity;

        private BuilderImpl() {
        }

        private BuilderImpl(ThingDocument model) {
            thingName(model.thingName);
            thingId(model.thingId);
            thingTypeName(model.thingTypeName);
            thingGroupNames(model.thingGroupNames);
            attributes(model.attributes);
            shadow(model.shadow);
            deviceDefender(model.deviceDefender);
            connectivity(model.connectivity);
        }

        public final String getThingName() {
            return thingName;
        }

        public final void setThingName(String thingName) {
            this.thingName = thingName;
        }

        @Override
        public final Builder thingName(String thingName) {
            this.thingName = thingName;
            return this;
        }

        public final String getThingId() {
            return thingId;
        }

        public final void setThingId(String thingId) {
            this.thingId = thingId;
        }

        @Override
        public final Builder thingId(String thingId) {
            this.thingId = thingId;
            return this;
        }

        public final String getThingTypeName() {
            return thingTypeName;
        }

        public final void setThingTypeName(String thingTypeName) {
            this.thingTypeName = thingTypeName;
        }

        @Override
        public final Builder thingTypeName(String thingTypeName) {
            this.thingTypeName = thingTypeName;
            return this;
        }

        public final Collection<String> getThingGroupNames() {
            if (thingGroupNames instanceof SdkAutoConstructList) {
                return null;
            }
            return thingGroupNames;
        }

        public final void setThingGroupNames(Collection<String> thingGroupNames) {
            this.thingGroupNames = ThingGroupNameListCopier.copy(thingGroupNames);
        }

        @Override
        public final Builder thingGroupNames(Collection<String> thingGroupNames) {
            this.thingGroupNames = ThingGroupNameListCopier.copy(thingGroupNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder thingGroupNames(String... thingGroupNames) {
            thingGroupNames(Arrays.asList(thingGroupNames));
            return this;
        }

        public final Map<String, String> getAttributes() {
            if (attributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return attributes;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
            return this;
        }

        public final String getShadow() {
            return shadow;
        }

        public final void setShadow(String shadow) {
            this.shadow = shadow;
        }

        @Override
        public final Builder shadow(String shadow) {
            this.shadow = shadow;
            return this;
        }

        public final String getDeviceDefender() {
            return deviceDefender;
        }

        public final void setDeviceDefender(String deviceDefender) {
            this.deviceDefender = deviceDefender;
        }

        @Override
        public final Builder deviceDefender(String deviceDefender) {
            this.deviceDefender = deviceDefender;
            return this;
        }

        public final ThingConnectivity.Builder getConnectivity() {
            return connectivity != null ? connectivity.toBuilder() : null;
        }

        public final void setConnectivity(ThingConnectivity.BuilderImpl connectivity) {
            this.connectivity = connectivity != null ? connectivity.build() : null;
        }

        @Override
        public final Builder connectivity(ThingConnectivity connectivity) {
            this.connectivity = connectivity;
            return this;
        }

        @Override
        public ThingDocument build() {
            return new ThingDocument(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
