/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateSbomWithPackageVersionResponse extends IotResponse implements
        ToCopyableBuilder<AssociateSbomWithPackageVersionResponse.Builder, AssociateSbomWithPackageVersionResponse> {
    private static final SdkField<String> PACKAGE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("packageName").getter(getter(AssociateSbomWithPackageVersionResponse::packageName))
            .setter(setter(Builder::packageName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("packageName").build()).build();

    private static final SdkField<String> VERSION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("versionName").getter(getter(AssociateSbomWithPackageVersionResponse::versionName))
            .setter(setter(Builder::versionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionName").build()).build();

    private static final SdkField<Sbom> SBOM_FIELD = SdkField.<Sbom> builder(MarshallingType.SDK_POJO).memberName("sbom")
            .getter(getter(AssociateSbomWithPackageVersionResponse::sbom)).setter(setter(Builder::sbom))
            .constructor(Sbom::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sbom").build()).build();

    private static final SdkField<String> SBOM_VALIDATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sbomValidationStatus")
            .getter(getter(AssociateSbomWithPackageVersionResponse::sbomValidationStatusAsString))
            .setter(setter(Builder::sbomValidationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sbomValidationStatus").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PACKAGE_NAME_FIELD,
            VERSION_NAME_FIELD, SBOM_FIELD, SBOM_VALIDATION_STATUS_FIELD));

    private final String packageName;

    private final String versionName;

    private final Sbom sbom;

    private final String sbomValidationStatus;

    private AssociateSbomWithPackageVersionResponse(BuilderImpl builder) {
        super(builder);
        this.packageName = builder.packageName;
        this.versionName = builder.versionName;
        this.sbom = builder.sbom;
        this.sbomValidationStatus = builder.sbomValidationStatus;
    }

    /**
     * <p>
     * The name of the new software package.
     * </p>
     * 
     * @return The name of the new software package.
     */
    public final String packageName() {
        return packageName;
    }

    /**
     * <p>
     * The name of the new package version.
     * </p>
     * 
     * @return The name of the new package version.
     */
    public final String versionName() {
        return versionName;
    }

    /**
     * Returns the value of the Sbom property for this object.
     * 
     * @return The value of the Sbom property for this object.
     */
    public final Sbom sbom() {
        return sbom;
    }

    /**
     * <p>
     * The status of the initial validation for the SBOM against the Software Package Data Exchange (SPDX) and CycloneDX
     * industry standard format.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #sbomValidationStatus} will return {@link SbomValidationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #sbomValidationStatusAsString}.
     * </p>
     * 
     * @return The status of the initial validation for the SBOM against the Software Package Data Exchange (SPDX) and
     *         CycloneDX industry standard format.
     * @see SbomValidationStatus
     */
    public final SbomValidationStatus sbomValidationStatus() {
        return SbomValidationStatus.fromValue(sbomValidationStatus);
    }

    /**
     * <p>
     * The status of the initial validation for the SBOM against the Software Package Data Exchange (SPDX) and CycloneDX
     * industry standard format.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #sbomValidationStatus} will return {@link SbomValidationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #sbomValidationStatusAsString}.
     * </p>
     * 
     * @return The status of the initial validation for the SBOM against the Software Package Data Exchange (SPDX) and
     *         CycloneDX industry standard format.
     * @see SbomValidationStatus
     */
    public final String sbomValidationStatusAsString() {
        return sbomValidationStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(packageName());
        hashCode = 31 * hashCode + Objects.hashCode(versionName());
        hashCode = 31 * hashCode + Objects.hashCode(sbom());
        hashCode = 31 * hashCode + Objects.hashCode(sbomValidationStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateSbomWithPackageVersionResponse)) {
            return false;
        }
        AssociateSbomWithPackageVersionResponse other = (AssociateSbomWithPackageVersionResponse) obj;
        return Objects.equals(packageName(), other.packageName()) && Objects.equals(versionName(), other.versionName())
                && Objects.equals(sbom(), other.sbom())
                && Objects.equals(sbomValidationStatusAsString(), other.sbomValidationStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateSbomWithPackageVersionResponse").add("PackageName", packageName())
                .add("VersionName", versionName()).add("Sbom", sbom())
                .add("SbomValidationStatus", sbomValidationStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "packageName":
            return Optional.ofNullable(clazz.cast(packageName()));
        case "versionName":
            return Optional.ofNullable(clazz.cast(versionName()));
        case "sbom":
            return Optional.ofNullable(clazz.cast(sbom()));
        case "sbomValidationStatus":
            return Optional.ofNullable(clazz.cast(sbomValidationStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateSbomWithPackageVersionResponse, T> g) {
        return obj -> g.apply((AssociateSbomWithPackageVersionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, AssociateSbomWithPackageVersionResponse> {
        /**
         * <p>
         * The name of the new software package.
         * </p>
         * 
         * @param packageName
         *        The name of the new software package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageName(String packageName);

        /**
         * <p>
         * The name of the new package version.
         * </p>
         * 
         * @param versionName
         *        The name of the new package version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionName(String versionName);

        /**
         * Sets the value of the Sbom property for this object.
         *
         * @param sbom
         *        The new value for the Sbom property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sbom(Sbom sbom);

        /**
         * Sets the value of the Sbom property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Sbom.Builder} avoiding the need to create
         * one manually via {@link Sbom#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Sbom.Builder#build()} is called immediately and its result is
         * passed to {@link #sbom(Sbom)}.
         * 
         * @param sbom
         *        a consumer that will call methods on {@link Sbom.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sbom(Sbom)
         */
        default Builder sbom(Consumer<Sbom.Builder> sbom) {
            return sbom(Sbom.builder().applyMutation(sbom).build());
        }

        /**
         * <p>
         * The status of the initial validation for the SBOM against the Software Package Data Exchange (SPDX) and
         * CycloneDX industry standard format.
         * </p>
         * 
         * @param sbomValidationStatus
         *        The status of the initial validation for the SBOM against the Software Package Data Exchange (SPDX)
         *        and CycloneDX industry standard format.
         * @see SbomValidationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SbomValidationStatus
         */
        Builder sbomValidationStatus(String sbomValidationStatus);

        /**
         * <p>
         * The status of the initial validation for the SBOM against the Software Package Data Exchange (SPDX) and
         * CycloneDX industry standard format.
         * </p>
         * 
         * @param sbomValidationStatus
         *        The status of the initial validation for the SBOM against the Software Package Data Exchange (SPDX)
         *        and CycloneDX industry standard format.
         * @see SbomValidationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SbomValidationStatus
         */
        Builder sbomValidationStatus(SbomValidationStatus sbomValidationStatus);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private String packageName;

        private String versionName;

        private Sbom sbom;

        private String sbomValidationStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateSbomWithPackageVersionResponse model) {
            super(model);
            packageName(model.packageName);
            versionName(model.versionName);
            sbom(model.sbom);
            sbomValidationStatus(model.sbomValidationStatus);
        }

        public final String getPackageName() {
            return packageName;
        }

        public final void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        @Override
        public final Builder packageName(String packageName) {
            this.packageName = packageName;
            return this;
        }

        public final String getVersionName() {
            return versionName;
        }

        public final void setVersionName(String versionName) {
            this.versionName = versionName;
        }

        @Override
        public final Builder versionName(String versionName) {
            this.versionName = versionName;
            return this;
        }

        public final Sbom.Builder getSbom() {
            return sbom != null ? sbom.toBuilder() : null;
        }

        public final void setSbom(Sbom.BuilderImpl sbom) {
            this.sbom = sbom != null ? sbom.build() : null;
        }

        @Override
        public final Builder sbom(Sbom sbom) {
            this.sbom = sbom;
            return this;
        }

        public final String getSbomValidationStatus() {
            return sbomValidationStatus;
        }

        public final void setSbomValidationStatus(String sbomValidationStatus) {
            this.sbomValidationStatus = sbomValidationStatus;
        }

        @Override
        public final Builder sbomValidationStatus(String sbomValidationStatus) {
            this.sbomValidationStatus = sbomValidationStatus;
            return this;
        }

        @Override
        public final Builder sbomValidationStatus(SbomValidationStatus sbomValidationStatus) {
            this.sbomValidationStatus(sbomValidationStatus == null ? null : sbomValidationStatus.toString());
            return this;
        }

        @Override
        public AssociateSbomWithPackageVersionResponse build() {
            return new AssociateSbomWithPackageVersionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
