/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetPackageVersionResponse extends IotResponse implements
        ToCopyableBuilder<GetPackageVersionResponse.Builder, GetPackageVersionResponse> {
    private static final SdkField<String> PACKAGE_VERSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("packageVersionArn").getter(getter(GetPackageVersionResponse::packageVersionArn))
            .setter(setter(Builder::packageVersionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("packageVersionArn").build()).build();

    private static final SdkField<String> PACKAGE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("packageName").getter(getter(GetPackageVersionResponse::packageName))
            .setter(setter(Builder::packageName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("packageName").build()).build();

    private static final SdkField<String> VERSION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("versionName").getter(getter(GetPackageVersionResponse::versionName))
            .setter(setter(Builder::versionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GetPackageVersionResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("attributes")
            .getter(getter(GetPackageVersionResponse::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<PackageVersionArtifact> ARTIFACT_FIELD = SdkField
            .<PackageVersionArtifact> builder(MarshallingType.SDK_POJO).memberName("artifact")
            .getter(getter(GetPackageVersionResponse::artifact)).setter(setter(Builder::artifact))
            .constructor(PackageVersionArtifact::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("artifact").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetPackageVersionResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> ERROR_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorReason").getter(getter(GetPackageVersionResponse::errorReason))
            .setter(setter(Builder::errorReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorReason").build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDate").getter(getter(GetPackageVersionResponse::creationDate))
            .setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastModifiedDate").getter(getter(GetPackageVersionResponse::lastModifiedDate))
            .setter(setter(Builder::lastModifiedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedDate").build()).build();

    private static final SdkField<Sbom> SBOM_FIELD = SdkField.<Sbom> builder(MarshallingType.SDK_POJO).memberName("sbom")
            .getter(getter(GetPackageVersionResponse::sbom)).setter(setter(Builder::sbom)).constructor(Sbom::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sbom").build()).build();

    private static final SdkField<String> SBOM_VALIDATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sbomValidationStatus").getter(getter(GetPackageVersionResponse::sbomValidationStatusAsString))
            .setter(setter(Builder::sbomValidationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sbomValidationStatus").build())
            .build();

    private static final SdkField<String> RECIPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("recipe")
            .getter(getter(GetPackageVersionResponse::recipe)).setter(setter(Builder::recipe))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recipe").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PACKAGE_VERSION_ARN_FIELD,
            PACKAGE_NAME_FIELD, VERSION_NAME_FIELD, DESCRIPTION_FIELD, ATTRIBUTES_FIELD, ARTIFACT_FIELD, STATUS_FIELD,
            ERROR_REASON_FIELD, CREATION_DATE_FIELD, LAST_MODIFIED_DATE_FIELD, SBOM_FIELD, SBOM_VALIDATION_STATUS_FIELD,
            RECIPE_FIELD));

    private final String packageVersionArn;

    private final String packageName;

    private final String versionName;

    private final String description;

    private final Map<String, String> attributes;

    private final PackageVersionArtifact artifact;

    private final String status;

    private final String errorReason;

    private final Instant creationDate;

    private final Instant lastModifiedDate;

    private final Sbom sbom;

    private final String sbomValidationStatus;

    private final String recipe;

    private GetPackageVersionResponse(BuilderImpl builder) {
        super(builder);
        this.packageVersionArn = builder.packageVersionArn;
        this.packageName = builder.packageName;
        this.versionName = builder.versionName;
        this.description = builder.description;
        this.attributes = builder.attributes;
        this.artifact = builder.artifact;
        this.status = builder.status;
        this.errorReason = builder.errorReason;
        this.creationDate = builder.creationDate;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.sbom = builder.sbom;
        this.sbomValidationStatus = builder.sbomValidationStatus;
        this.recipe = builder.recipe;
    }

    /**
     * <p>
     * The ARN for the package version.
     * </p>
     * 
     * @return The ARN for the package version.
     */
    public final String packageVersionArn() {
        return packageVersionArn;
    }

    /**
     * <p>
     * The name of the software package.
     * </p>
     * 
     * @return The name of the software package.
     */
    public final String packageName() {
        return packageName;
    }

    /**
     * <p>
     * The name of the package version.
     * </p>
     * 
     * @return The name of the package version.
     */
    public final String versionName() {
        return versionName;
    }

    /**
     * <p>
     * The package version description.
     * </p>
     * 
     * @return The package version description.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Attributes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAttributes() {
        return attributes != null && !(attributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Metadata that were added to the package version that can be used to define a package version’s configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributes} method.
     * </p>
     * 
     * @return Metadata that were added to the package version that can be used to define a package version’s
     *         configuration.
     */
    public final Map<String, String> attributes() {
        return attributes;
    }

    /**
     * <p>
     * The various components that make up a software package version.
     * </p>
     * 
     * @return The various components that make up a software package version.
     */
    public final PackageVersionArtifact artifact() {
        return artifact;
    }

    /**
     * <p>
     * The status associated to the package version. For more information, see <a href=
     * "https://docs.aws.amazon.com/iot/latest/developerguide/preparing-to-use-software-package-catalog.html#package-version-lifecycle"
     * >Package version lifecycle</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link PackageVersionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status associated to the package version. For more information, see <a href=
     *         "https://docs.aws.amazon.com/iot/latest/developerguide/preparing-to-use-software-package-catalog.html#package-version-lifecycle"
     *         >Package version lifecycle</a>.
     * @see PackageVersionStatus
     */
    public final PackageVersionStatus status() {
        return PackageVersionStatus.fromValue(status);
    }

    /**
     * <p>
     * The status associated to the package version. For more information, see <a href=
     * "https://docs.aws.amazon.com/iot/latest/developerguide/preparing-to-use-software-package-catalog.html#package-version-lifecycle"
     * >Package version lifecycle</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link PackageVersionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status associated to the package version. For more information, see <a href=
     *         "https://docs.aws.amazon.com/iot/latest/developerguide/preparing-to-use-software-package-catalog.html#package-version-lifecycle"
     *         >Package version lifecycle</a>.
     * @see PackageVersionStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Error reason for a package version failure during creation or update.
     * </p>
     * 
     * @return Error reason for a package version failure during creation or update.
     */
    public final String errorReason() {
        return errorReason;
    }

    /**
     * <p>
     * The date when the package version was created.
     * </p>
     * 
     * @return The date when the package version was created.
     */
    public final Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The date when the package version was last updated.
     * </p>
     * 
     * @return The date when the package version was last updated.
     */
    public final Instant lastModifiedDate() {
        return lastModifiedDate;
    }

    /**
     * <p>
     * The software bill of materials for a software package version.
     * </p>
     * 
     * @return The software bill of materials for a software package version.
     */
    public final Sbom sbom() {
        return sbom;
    }

    /**
     * <p>
     * The status of the validation for a new software bill of materials added to a software package version.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #sbomValidationStatus} will return {@link SbomValidationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #sbomValidationStatusAsString}.
     * </p>
     * 
     * @return The status of the validation for a new software bill of materials added to a software package version.
     * @see SbomValidationStatus
     */
    public final SbomValidationStatus sbomValidationStatus() {
        return SbomValidationStatus.fromValue(sbomValidationStatus);
    }

    /**
     * <p>
     * The status of the validation for a new software bill of materials added to a software package version.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #sbomValidationStatus} will return {@link SbomValidationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #sbomValidationStatusAsString}.
     * </p>
     * 
     * @return The status of the validation for a new software bill of materials added to a software package version.
     * @see SbomValidationStatus
     */
    public final String sbomValidationStatusAsString() {
        return sbomValidationStatus;
    }

    /**
     * <p>
     * The inline job document associated with a software package version used for a quick job deployment.
     * </p>
     * 
     * @return The inline job document associated with a software package version used for a quick job deployment.
     */
    public final String recipe() {
        return recipe;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(packageVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(packageName());
        hashCode = 31 * hashCode + Objects.hashCode(versionName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributes() ? attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(artifact());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(errorReason());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(sbom());
        hashCode = 31 * hashCode + Objects.hashCode(sbomValidationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(recipe());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPackageVersionResponse)) {
            return false;
        }
        GetPackageVersionResponse other = (GetPackageVersionResponse) obj;
        return Objects.equals(packageVersionArn(), other.packageVersionArn())
                && Objects.equals(packageName(), other.packageName()) && Objects.equals(versionName(), other.versionName())
                && Objects.equals(description(), other.description()) && hasAttributes() == other.hasAttributes()
                && Objects.equals(attributes(), other.attributes()) && Objects.equals(artifact(), other.artifact())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(errorReason(), other.errorReason())
                && Objects.equals(creationDate(), other.creationDate())
                && Objects.equals(lastModifiedDate(), other.lastModifiedDate()) && Objects.equals(sbom(), other.sbom())
                && Objects.equals(sbomValidationStatusAsString(), other.sbomValidationStatusAsString())
                && Objects.equals(recipe(), other.recipe());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetPackageVersionResponse").add("PackageVersionArn", packageVersionArn())
                .add("PackageName", packageName()).add("VersionName", versionName())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Attributes", attributes() == null ? null : "*** Sensitive Data Redacted ***").add("Artifact", artifact())
                .add("Status", statusAsString()).add("ErrorReason", errorReason()).add("CreationDate", creationDate())
                .add("LastModifiedDate", lastModifiedDate()).add("Sbom", sbom())
                .add("SbomValidationStatus", sbomValidationStatusAsString())
                .add("Recipe", recipe() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "packageVersionArn":
            return Optional.ofNullable(clazz.cast(packageVersionArn()));
        case "packageName":
            return Optional.ofNullable(clazz.cast(packageName()));
        case "versionName":
            return Optional.ofNullable(clazz.cast(versionName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        case "artifact":
            return Optional.ofNullable(clazz.cast(artifact()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "errorReason":
            return Optional.ofNullable(clazz.cast(errorReason()));
        case "creationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "lastModifiedDate":
            return Optional.ofNullable(clazz.cast(lastModifiedDate()));
        case "sbom":
            return Optional.ofNullable(clazz.cast(sbom()));
        case "sbomValidationStatus":
            return Optional.ofNullable(clazz.cast(sbomValidationStatusAsString()));
        case "recipe":
            return Optional.ofNullable(clazz.cast(recipe()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetPackageVersionResponse, T> g) {
        return obj -> g.apply((GetPackageVersionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetPackageVersionResponse> {
        /**
         * <p>
         * The ARN for the package version.
         * </p>
         * 
         * @param packageVersionArn
         *        The ARN for the package version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageVersionArn(String packageVersionArn);

        /**
         * <p>
         * The name of the software package.
         * </p>
         * 
         * @param packageName
         *        The name of the software package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageName(String packageName);

        /**
         * <p>
         * The name of the package version.
         * </p>
         * 
         * @param versionName
         *        The name of the package version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionName(String versionName);

        /**
         * <p>
         * The package version description.
         * </p>
         * 
         * @param description
         *        The package version description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Metadata that were added to the package version that can be used to define a package version’s configuration.
         * </p>
         * 
         * @param attributes
         *        Metadata that were added to the package version that can be used to define a package version’s
         *        configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Map<String, String> attributes);

        /**
         * <p>
         * The various components that make up a software package version.
         * </p>
         * 
         * @param artifact
         *        The various components that make up a software package version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder artifact(PackageVersionArtifact artifact);

        /**
         * <p>
         * The various components that make up a software package version.
         * </p>
         * This is a convenience method that creates an instance of the {@link PackageVersionArtifact.Builder} avoiding
         * the need to create one manually via {@link PackageVersionArtifact#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PackageVersionArtifact.Builder#build()} is called immediately and
         * its result is passed to {@link #artifact(PackageVersionArtifact)}.
         * 
         * @param artifact
         *        a consumer that will call methods on {@link PackageVersionArtifact.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #artifact(PackageVersionArtifact)
         */
        default Builder artifact(Consumer<PackageVersionArtifact.Builder> artifact) {
            return artifact(PackageVersionArtifact.builder().applyMutation(artifact).build());
        }

        /**
         * <p>
         * The status associated to the package version. For more information, see <a href=
         * "https://docs.aws.amazon.com/iot/latest/developerguide/preparing-to-use-software-package-catalog.html#package-version-lifecycle"
         * >Package version lifecycle</a>.
         * </p>
         * 
         * @param status
         *        The status associated to the package version. For more information, see <a href=
         *        "https://docs.aws.amazon.com/iot/latest/developerguide/preparing-to-use-software-package-catalog.html#package-version-lifecycle"
         *        >Package version lifecycle</a>.
         * @see PackageVersionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PackageVersionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status associated to the package version. For more information, see <a href=
         * "https://docs.aws.amazon.com/iot/latest/developerguide/preparing-to-use-software-package-catalog.html#package-version-lifecycle"
         * >Package version lifecycle</a>.
         * </p>
         * 
         * @param status
         *        The status associated to the package version. For more information, see <a href=
         *        "https://docs.aws.amazon.com/iot/latest/developerguide/preparing-to-use-software-package-catalog.html#package-version-lifecycle"
         *        >Package version lifecycle</a>.
         * @see PackageVersionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PackageVersionStatus
         */
        Builder status(PackageVersionStatus status);

        /**
         * <p>
         * Error reason for a package version failure during creation or update.
         * </p>
         * 
         * @param errorReason
         *        Error reason for a package version failure during creation or update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorReason(String errorReason);

        /**
         * <p>
         * The date when the package version was created.
         * </p>
         * 
         * @param creationDate
         *        The date when the package version was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * The date when the package version was last updated.
         * </p>
         * 
         * @param lastModifiedDate
         *        The date when the package version was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedDate(Instant lastModifiedDate);

        /**
         * <p>
         * The software bill of materials for a software package version.
         * </p>
         * 
         * @param sbom
         *        The software bill of materials for a software package version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sbom(Sbom sbom);

        /**
         * <p>
         * The software bill of materials for a software package version.
         * </p>
         * This is a convenience method that creates an instance of the {@link Sbom.Builder} avoiding the need to create
         * one manually via {@link Sbom#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Sbom.Builder#build()} is called immediately and its result is
         * passed to {@link #sbom(Sbom)}.
         * 
         * @param sbom
         *        a consumer that will call methods on {@link Sbom.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sbom(Sbom)
         */
        default Builder sbom(Consumer<Sbom.Builder> sbom) {
            return sbom(Sbom.builder().applyMutation(sbom).build());
        }

        /**
         * <p>
         * The status of the validation for a new software bill of materials added to a software package version.
         * </p>
         * 
         * @param sbomValidationStatus
         *        The status of the validation for a new software bill of materials added to a software package version.
         * @see SbomValidationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SbomValidationStatus
         */
        Builder sbomValidationStatus(String sbomValidationStatus);

        /**
         * <p>
         * The status of the validation for a new software bill of materials added to a software package version.
         * </p>
         * 
         * @param sbomValidationStatus
         *        The status of the validation for a new software bill of materials added to a software package version.
         * @see SbomValidationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SbomValidationStatus
         */
        Builder sbomValidationStatus(SbomValidationStatus sbomValidationStatus);

        /**
         * <p>
         * The inline job document associated with a software package version used for a quick job deployment.
         * </p>
         * 
         * @param recipe
         *        The inline job document associated with a software package version used for a quick job deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recipe(String recipe);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private String packageVersionArn;

        private String packageName;

        private String versionName;

        private String description;

        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();

        private PackageVersionArtifact artifact;

        private String status;

        private String errorReason;

        private Instant creationDate;

        private Instant lastModifiedDate;

        private Sbom sbom;

        private String sbomValidationStatus;

        private String recipe;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPackageVersionResponse model) {
            super(model);
            packageVersionArn(model.packageVersionArn);
            packageName(model.packageName);
            versionName(model.versionName);
            description(model.description);
            attributes(model.attributes);
            artifact(model.artifact);
            status(model.status);
            errorReason(model.errorReason);
            creationDate(model.creationDate);
            lastModifiedDate(model.lastModifiedDate);
            sbom(model.sbom);
            sbomValidationStatus(model.sbomValidationStatus);
            recipe(model.recipe);
        }

        public final String getPackageVersionArn() {
            return packageVersionArn;
        }

        public final void setPackageVersionArn(String packageVersionArn) {
            this.packageVersionArn = packageVersionArn;
        }

        @Override
        public final Builder packageVersionArn(String packageVersionArn) {
            this.packageVersionArn = packageVersionArn;
            return this;
        }

        public final String getPackageName() {
            return packageName;
        }

        public final void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        @Override
        public final Builder packageName(String packageName) {
            this.packageName = packageName;
            return this;
        }

        public final String getVersionName() {
            return versionName;
        }

        public final void setVersionName(String versionName) {
            this.versionName = versionName;
        }

        @Override
        public final Builder versionName(String versionName) {
            this.versionName = versionName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, String> getAttributes() {
            if (attributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return attributes;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = ResourceAttributesCopier.copy(attributes);
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = ResourceAttributesCopier.copy(attributes);
            return this;
        }

        public final PackageVersionArtifact.Builder getArtifact() {
            return artifact != null ? artifact.toBuilder() : null;
        }

        public final void setArtifact(PackageVersionArtifact.BuilderImpl artifact) {
            this.artifact = artifact != null ? artifact.build() : null;
        }

        @Override
        public final Builder artifact(PackageVersionArtifact artifact) {
            this.artifact = artifact;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(PackageVersionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getErrorReason() {
            return errorReason;
        }

        public final void setErrorReason(String errorReason) {
            this.errorReason = errorReason;
        }

        @Override
        public final Builder errorReason(String errorReason) {
            this.errorReason = errorReason;
            return this;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final Instant getLastModifiedDate() {
            return lastModifiedDate;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final Sbom.Builder getSbom() {
            return sbom != null ? sbom.toBuilder() : null;
        }

        public final void setSbom(Sbom.BuilderImpl sbom) {
            this.sbom = sbom != null ? sbom.build() : null;
        }

        @Override
        public final Builder sbom(Sbom sbom) {
            this.sbom = sbom;
            return this;
        }

        public final String getSbomValidationStatus() {
            return sbomValidationStatus;
        }

        public final void setSbomValidationStatus(String sbomValidationStatus) {
            this.sbomValidationStatus = sbomValidationStatus;
        }

        @Override
        public final Builder sbomValidationStatus(String sbomValidationStatus) {
            this.sbomValidationStatus = sbomValidationStatus;
            return this;
        }

        @Override
        public final Builder sbomValidationStatus(SbomValidationStatus sbomValidationStatus) {
            this.sbomValidationStatus(sbomValidationStatus == null ? null : sbomValidationStatus.toString());
            return this;
        }

        public final String getRecipe() {
            return recipe;
        }

        public final void setRecipe(String recipe) {
            this.recipe = recipe;
        }

        @Override
        public final Builder recipe(String recipe) {
            this.recipe = recipe;
            return this;
        }

        @Override
        public GetPackageVersionResponse build() {
            return new GetPackageVersionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
