/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for the CreateTopicRule operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateTopicRuleRequest extends IotRequest implements
        ToCopyableBuilder<CreateTopicRuleRequest.Builder, CreateTopicRuleRequest> {
    private static final SdkField<String> RULE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateTopicRuleRequest::ruleName)).setter(setter(Builder::ruleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ruleName").build()).build();

    private static final SdkField<TopicRulePayload> TOPIC_RULE_PAYLOAD_FIELD = SdkField
            .<TopicRulePayload> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateTopicRuleRequest::topicRulePayload))
            .setter(setter(Builder::topicRulePayload))
            .constructor(TopicRulePayload::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topicRulePayload").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_NAME_FIELD,
            TOPIC_RULE_PAYLOAD_FIELD));

    private final String ruleName;

    private final TopicRulePayload topicRulePayload;

    private CreateTopicRuleRequest(BuilderImpl builder) {
        super(builder);
        this.ruleName = builder.ruleName;
        this.topicRulePayload = builder.topicRulePayload;
    }

    /**
     * <p>
     * The name of the rule.
     * </p>
     * 
     * @return The name of the rule.
     */
    public String ruleName() {
        return ruleName;
    }

    /**
     * <p>
     * The rule payload.
     * </p>
     * 
     * @return The rule payload.
     */
    public TopicRulePayload topicRulePayload() {
        return topicRulePayload;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ruleName());
        hashCode = 31 * hashCode + Objects.hashCode(topicRulePayload());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTopicRuleRequest)) {
            return false;
        }
        CreateTopicRuleRequest other = (CreateTopicRuleRequest) obj;
        return Objects.equals(ruleName(), other.ruleName()) && Objects.equals(topicRulePayload(), other.topicRulePayload());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateTopicRuleRequest").add("RuleName", ruleName()).add("TopicRulePayload", topicRulePayload())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ruleName":
            return Optional.ofNullable(clazz.cast(ruleName()));
        case "topicRulePayload":
            return Optional.ofNullable(clazz.cast(topicRulePayload()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTopicRuleRequest, T> g) {
        return obj -> g.apply((CreateTopicRuleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateTopicRuleRequest> {
        /**
         * <p>
         * The name of the rule.
         * </p>
         * 
         * @param ruleName
         *        The name of the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleName(String ruleName);

        /**
         * <p>
         * The rule payload.
         * </p>
         * 
         * @param topicRulePayload
         *        The rule payload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicRulePayload(TopicRulePayload topicRulePayload);

        /**
         * <p>
         * The rule payload.
         * </p>
         * This is a convenience that creates an instance of the {@link TopicRulePayload.Builder} avoiding the need to
         * create one manually via {@link TopicRulePayload#builder()}.
         *
         * When the {@link Consumer} completes, {@link TopicRulePayload.Builder#build()} is called immediately and its
         * result is passed to {@link #topicRulePayload(TopicRulePayload)}.
         * 
         * @param topicRulePayload
         *        a consumer that will call methods on {@link TopicRulePayload.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #topicRulePayload(TopicRulePayload)
         */
        default Builder topicRulePayload(Consumer<TopicRulePayload.Builder> topicRulePayload) {
            return topicRulePayload(TopicRulePayload.builder().applyMutation(topicRulePayload).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String ruleName;

        private TopicRulePayload topicRulePayload;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTopicRuleRequest model) {
            super(model);
            ruleName(model.ruleName);
            topicRulePayload(model.topicRulePayload);
        }

        public final String getRuleName() {
            return ruleName;
        }

        @Override
        public final Builder ruleName(String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        public final void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }

        public final TopicRulePayload.Builder getTopicRulePayload() {
            return topicRulePayload != null ? topicRulePayload.toBuilder() : null;
        }

        @Override
        public final Builder topicRulePayload(TopicRulePayload topicRulePayload) {
            this.topicRulePayload = topicRulePayload;
            return this;
        }

        public final void setTopicRulePayload(TopicRulePayload.BuilderImpl topicRulePayload) {
            this.topicRulePayload = topicRulePayload != null ? topicRulePayload.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTopicRuleRequest build() {
            return new CreateTopicRuleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
