/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDefaultAuthorizerResponse extends IotResponse implements
        ToCopyableBuilder<DescribeDefaultAuthorizerResponse.Builder, DescribeDefaultAuthorizerResponse> {
    private static final SdkField<AuthorizerDescription> AUTHORIZER_DESCRIPTION_FIELD = SdkField
            .<AuthorizerDescription> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeDefaultAuthorizerResponse::authorizerDescription))
            .setter(setter(Builder::authorizerDescription)).constructor(AuthorizerDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizerDescription").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHORIZER_DESCRIPTION_FIELD));

    private final AuthorizerDescription authorizerDescription;

    private DescribeDefaultAuthorizerResponse(BuilderImpl builder) {
        super(builder);
        this.authorizerDescription = builder.authorizerDescription;
    }

    /**
     * <p>
     * The default authorizer's description.
     * </p>
     * 
     * @return The default authorizer's description.
     */
    public AuthorizerDescription authorizerDescription() {
        return authorizerDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(authorizerDescription());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDefaultAuthorizerResponse)) {
            return false;
        }
        DescribeDefaultAuthorizerResponse other = (DescribeDefaultAuthorizerResponse) obj;
        return Objects.equals(authorizerDescription(), other.authorizerDescription());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeDefaultAuthorizerResponse").add("AuthorizerDescription", authorizerDescription())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "authorizerDescription":
            return Optional.ofNullable(clazz.cast(authorizerDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDefaultAuthorizerResponse, T> g) {
        return obj -> g.apply((DescribeDefaultAuthorizerResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeDefaultAuthorizerResponse> {
        /**
         * <p>
         * The default authorizer's description.
         * </p>
         * 
         * @param authorizerDescription
         *        The default authorizer's description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorizerDescription(AuthorizerDescription authorizerDescription);

        /**
         * <p>
         * The default authorizer's description.
         * </p>
         * This is a convenience that creates an instance of the {@link AuthorizerDescription.Builder} avoiding the need
         * to create one manually via {@link AuthorizerDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link AuthorizerDescription.Builder#build()} is called immediately and
         * its result is passed to {@link #authorizerDescription(AuthorizerDescription)}.
         * 
         * @param authorizerDescription
         *        a consumer that will call methods on {@link AuthorizerDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #authorizerDescription(AuthorizerDescription)
         */
        default Builder authorizerDescription(Consumer<AuthorizerDescription.Builder> authorizerDescription) {
            return authorizerDescription(AuthorizerDescription.builder().applyMutation(authorizerDescription).build());
        }
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private AuthorizerDescription authorizerDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDefaultAuthorizerResponse model) {
            super(model);
            authorizerDescription(model.authorizerDescription);
        }

        public final AuthorizerDescription.Builder getAuthorizerDescription() {
            return authorizerDescription != null ? authorizerDescription.toBuilder() : null;
        }

        @Override
        public final Builder authorizerDescription(AuthorizerDescription authorizerDescription) {
            this.authorizerDescription = authorizerDescription;
            return this;
        }

        public final void setAuthorizerDescription(AuthorizerDescription.BuilderImpl authorizerDescription) {
            this.authorizerDescription = authorizerDescription != null ? authorizerDescription.build() : null;
        }

        @Override
        public DescribeDefaultAuthorizerResponse build() {
            return new DescribeDefaultAuthorizerResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
