/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAttachedPoliciesResponse extends IotResponse implements
        ToCopyableBuilder<ListAttachedPoliciesResponse.Builder, ListAttachedPoliciesResponse> {
    private static final SdkField<List<Policy>> POLICIES_FIELD = SdkField
            .<List<Policy>> builder(MarshallingType.LIST)
            .getter(getter(ListAttachedPoliciesResponse::policies))
            .setter(setter(Builder::policies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Policy> builder(MarshallingType.SDK_POJO)
                                            .constructor(Policy::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListAttachedPoliciesResponse::nextMarker)).setter(setter(Builder::nextMarker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextMarker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICIES_FIELD,
            NEXT_MARKER_FIELD));

    private final List<Policy> policies;

    private final String nextMarker;

    private ListAttachedPoliciesResponse(BuilderImpl builder) {
        super(builder);
        this.policies = builder.policies;
        this.nextMarker = builder.nextMarker;
    }

    /**
     * <p>
     * The policies.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The policies.
     */
    public List<Policy> policies() {
        return policies;
    }

    /**
     * <p>
     * The token to retrieve the next set of results, or ``null`` if there are no more results.
     * </p>
     * 
     * @return The token to retrieve the next set of results, or ``null`` if there are no more results.
     */
    public String nextMarker() {
        return nextMarker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(policies());
        hashCode = 31 * hashCode + Objects.hashCode(nextMarker());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAttachedPoliciesResponse)) {
            return false;
        }
        ListAttachedPoliciesResponse other = (ListAttachedPoliciesResponse) obj;
        return Objects.equals(policies(), other.policies()) && Objects.equals(nextMarker(), other.nextMarker());
    }

    @Override
    public String toString() {
        return ToString.builder("ListAttachedPoliciesResponse").add("Policies", policies()).add("NextMarker", nextMarker())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "policies":
            return Optional.ofNullable(clazz.cast(policies()));
        case "nextMarker":
            return Optional.ofNullable(clazz.cast(nextMarker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAttachedPoliciesResponse, T> g) {
        return obj -> g.apply((ListAttachedPoliciesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListAttachedPoliciesResponse> {
        /**
         * <p>
         * The policies.
         * </p>
         * 
         * @param policies
         *        The policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policies(Collection<Policy> policies);

        /**
         * <p>
         * The policies.
         * </p>
         * 
         * @param policies
         *        The policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policies(Policy... policies);

        /**
         * <p>
         * The policies.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Policy>.Builder} avoiding the need to
         * create one manually via {@link List<Policy>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Policy>.Builder#build()} is called immediately and its
         * result is passed to {@link #policies(List<Policy>)}.
         * 
         * @param policies
         *        a consumer that will call methods on {@link List<Policy>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #policies(List<Policy>)
         */
        Builder policies(Consumer<Policy.Builder>... policies);

        /**
         * <p>
         * The token to retrieve the next set of results, or ``null`` if there are no more results.
         * </p>
         * 
         * @param nextMarker
         *        The token to retrieve the next set of results, or ``null`` if there are no more results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextMarker(String nextMarker);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private List<Policy> policies = DefaultSdkAutoConstructList.getInstance();

        private String nextMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAttachedPoliciesResponse model) {
            super(model);
            policies(model.policies);
            nextMarker(model.nextMarker);
        }

        public final Collection<Policy.Builder> getPolicies() {
            return policies != null ? policies.stream().map(Policy::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder policies(Collection<Policy> policies) {
            this.policies = PoliciesCopier.copy(policies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policies(Policy... policies) {
            policies(Arrays.asList(policies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policies(Consumer<Policy.Builder>... policies) {
            policies(Stream.of(policies).map(c -> Policy.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPolicies(Collection<Policy.BuilderImpl> policies) {
            this.policies = PoliciesCopier.copyFromBuilder(policies);
        }

        public final String getNextMarker() {
            return nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public ListAttachedPoliciesResponse build() {
            return new ListAttachedPoliciesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
