/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an OTA update.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OTAUpdateInfo implements SdkPojo, Serializable, ToCopyableBuilder<OTAUpdateInfo.Builder, OTAUpdateInfo> {
    private static final SdkField<String> OTA_UPDATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(OTAUpdateInfo::otaUpdateId)).setter(setter(Builder::otaUpdateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("otaUpdateId").build()).build();

    private static final SdkField<String> OTA_UPDATE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(OTAUpdateInfo::otaUpdateArn)).setter(setter(Builder::otaUpdateArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("otaUpdateArn").build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(OTAUpdateInfo::creationDate)).setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(OTAUpdateInfo::lastModifiedDate)).setter(setter(Builder::lastModifiedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedDate").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(OTAUpdateInfo::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<String>> TARGETS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(OTAUpdateInfo::targets))
            .setter(setter(Builder::targets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AwsJobExecutionsRolloutConfig> AWS_JOB_EXECUTIONS_ROLLOUT_CONFIG_FIELD = SdkField
            .<AwsJobExecutionsRolloutConfig> builder(MarshallingType.SDK_POJO)
            .getter(getter(OTAUpdateInfo::awsJobExecutionsRolloutConfig))
            .setter(setter(Builder::awsJobExecutionsRolloutConfig))
            .constructor(AwsJobExecutionsRolloutConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsJobExecutionsRolloutConfig")
                    .build()).build();

    private static final SdkField<String> TARGET_SELECTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(OTAUpdateInfo::targetSelectionAsString)).setter(setter(Builder::targetSelection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetSelection").build()).build();

    private static final SdkField<List<OTAUpdateFile>> OTA_UPDATE_FILES_FIELD = SdkField
            .<List<OTAUpdateFile>> builder(MarshallingType.LIST)
            .getter(getter(OTAUpdateInfo::otaUpdateFiles))
            .setter(setter(Builder::otaUpdateFiles))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("otaUpdateFiles").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OTAUpdateFile> builder(MarshallingType.SDK_POJO)
                                            .constructor(OTAUpdateFile::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> OTA_UPDATE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(OTAUpdateInfo::otaUpdateStatusAsString)).setter(setter(Builder::otaUpdateStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("otaUpdateStatus").build()).build();

    private static final SdkField<String> AWS_IOT_JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(OTAUpdateInfo::awsIotJobId)).setter(setter(Builder::awsIotJobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsIotJobId").build()).build();

    private static final SdkField<String> AWS_IOT_JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(OTAUpdateInfo::awsIotJobArn)).setter(setter(Builder::awsIotJobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsIotJobArn").build()).build();

    private static final SdkField<ErrorInfo> ERROR_INFO_FIELD = SdkField.<ErrorInfo> builder(MarshallingType.SDK_POJO)
            .getter(getter(OTAUpdateInfo::errorInfo)).setter(setter(Builder::errorInfo)).constructor(ErrorInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorInfo").build()).build();

    private static final SdkField<Map<String, String>> ADDITIONAL_PARAMETERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(OTAUpdateInfo::additionalParameters))
            .setter(setter(Builder::additionalParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalParameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OTA_UPDATE_ID_FIELD,
            OTA_UPDATE_ARN_FIELD, CREATION_DATE_FIELD, LAST_MODIFIED_DATE_FIELD, DESCRIPTION_FIELD, TARGETS_FIELD,
            AWS_JOB_EXECUTIONS_ROLLOUT_CONFIG_FIELD, TARGET_SELECTION_FIELD, OTA_UPDATE_FILES_FIELD, OTA_UPDATE_STATUS_FIELD,
            AWS_IOT_JOB_ID_FIELD, AWS_IOT_JOB_ARN_FIELD, ERROR_INFO_FIELD, ADDITIONAL_PARAMETERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String otaUpdateId;

    private final String otaUpdateArn;

    private final Instant creationDate;

    private final Instant lastModifiedDate;

    private final String description;

    private final List<String> targets;

    private final AwsJobExecutionsRolloutConfig awsJobExecutionsRolloutConfig;

    private final String targetSelection;

    private final List<OTAUpdateFile> otaUpdateFiles;

    private final String otaUpdateStatus;

    private final String awsIotJobId;

    private final String awsIotJobArn;

    private final ErrorInfo errorInfo;

    private final Map<String, String> additionalParameters;

    private OTAUpdateInfo(BuilderImpl builder) {
        this.otaUpdateId = builder.otaUpdateId;
        this.otaUpdateArn = builder.otaUpdateArn;
        this.creationDate = builder.creationDate;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.description = builder.description;
        this.targets = builder.targets;
        this.awsJobExecutionsRolloutConfig = builder.awsJobExecutionsRolloutConfig;
        this.targetSelection = builder.targetSelection;
        this.otaUpdateFiles = builder.otaUpdateFiles;
        this.otaUpdateStatus = builder.otaUpdateStatus;
        this.awsIotJobId = builder.awsIotJobId;
        this.awsIotJobArn = builder.awsIotJobArn;
        this.errorInfo = builder.errorInfo;
        this.additionalParameters = builder.additionalParameters;
    }

    /**
     * <p>
     * The OTA update ID.
     * </p>
     * 
     * @return The OTA update ID.
     */
    public String otaUpdateId() {
        return otaUpdateId;
    }

    /**
     * <p>
     * The OTA update ARN.
     * </p>
     * 
     * @return The OTA update ARN.
     */
    public String otaUpdateArn() {
        return otaUpdateArn;
    }

    /**
     * <p>
     * The date when the OTA update was created.
     * </p>
     * 
     * @return The date when the OTA update was created.
     */
    public Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The date when the OTA update was last updated.
     * </p>
     * 
     * @return The date when the OTA update was last updated.
     */
    public Instant lastModifiedDate() {
        return lastModifiedDate;
    }

    /**
     * <p>
     * A description of the OTA update.
     * </p>
     * 
     * @return A description of the OTA update.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The targets of the OTA update.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The targets of the OTA update.
     */
    public List<String> targets() {
        return targets;
    }

    /**
     * <p>
     * Configuration for the rollout of OTA updates.
     * </p>
     * 
     * @return Configuration for the rollout of OTA updates.
     */
    public AwsJobExecutionsRolloutConfig awsJobExecutionsRolloutConfig() {
        return awsJobExecutionsRolloutConfig;
    }

    /**
     * <p>
     * Specifies whether the OTA update will continue to run (CONTINUOUS), or will be complete after all those things
     * specified as targets have completed the OTA update (SNAPSHOT). If continuous, the OTA update may also be run on a
     * thing when a change is detected in a target. For example, an OTA update will run on a thing when the thing is
     * added to a target group, even after the OTA update was completed by all things originally in the group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetSelection}
     * will return {@link TargetSelection#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #targetSelectionAsString}.
     * </p>
     * 
     * @return Specifies whether the OTA update will continue to run (CONTINUOUS), or will be complete after all those
     *         things specified as targets have completed the OTA update (SNAPSHOT). If continuous, the OTA update may
     *         also be run on a thing when a change is detected in a target. For example, an OTA update will run on a
     *         thing when the thing is added to a target group, even after the OTA update was completed by all things
     *         originally in the group.
     * @see TargetSelection
     */
    public TargetSelection targetSelection() {
        return TargetSelection.fromValue(targetSelection);
    }

    /**
     * <p>
     * Specifies whether the OTA update will continue to run (CONTINUOUS), or will be complete after all those things
     * specified as targets have completed the OTA update (SNAPSHOT). If continuous, the OTA update may also be run on a
     * thing when a change is detected in a target. For example, an OTA update will run on a thing when the thing is
     * added to a target group, even after the OTA update was completed by all things originally in the group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetSelection}
     * will return {@link TargetSelection#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #targetSelectionAsString}.
     * </p>
     * 
     * @return Specifies whether the OTA update will continue to run (CONTINUOUS), or will be complete after all those
     *         things specified as targets have completed the OTA update (SNAPSHOT). If continuous, the OTA update may
     *         also be run on a thing when a change is detected in a target. For example, an OTA update will run on a
     *         thing when the thing is added to a target group, even after the OTA update was completed by all things
     *         originally in the group.
     * @see TargetSelection
     */
    public String targetSelectionAsString() {
        return targetSelection;
    }

    /**
     * <p>
     * A list of files associated with the OTA update.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of files associated with the OTA update.
     */
    public List<OTAUpdateFile> otaUpdateFiles() {
        return otaUpdateFiles;
    }

    /**
     * <p>
     * The status of the OTA update.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #otaUpdateStatus}
     * will return {@link OTAUpdateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #otaUpdateStatusAsString}.
     * </p>
     * 
     * @return The status of the OTA update.
     * @see OTAUpdateStatus
     */
    public OTAUpdateStatus otaUpdateStatus() {
        return OTAUpdateStatus.fromValue(otaUpdateStatus);
    }

    /**
     * <p>
     * The status of the OTA update.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #otaUpdateStatus}
     * will return {@link OTAUpdateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #otaUpdateStatusAsString}.
     * </p>
     * 
     * @return The status of the OTA update.
     * @see OTAUpdateStatus
     */
    public String otaUpdateStatusAsString() {
        return otaUpdateStatus;
    }

    /**
     * <p>
     * The AWS IoT job ID associated with the OTA update.
     * </p>
     * 
     * @return The AWS IoT job ID associated with the OTA update.
     */
    public String awsIotJobId() {
        return awsIotJobId;
    }

    /**
     * <p>
     * The AWS IoT job ARN associated with the OTA update.
     * </p>
     * 
     * @return The AWS IoT job ARN associated with the OTA update.
     */
    public String awsIotJobArn() {
        return awsIotJobArn;
    }

    /**
     * <p>
     * Error information associated with the OTA update.
     * </p>
     * 
     * @return Error information associated with the OTA update.
     */
    public ErrorInfo errorInfo() {
        return errorInfo;
    }

    /**
     * <p>
     * A collection of name/value pairs
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A collection of name/value pairs
     */
    public Map<String, String> additionalParameters() {
        return additionalParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(otaUpdateId());
        hashCode = 31 * hashCode + Objects.hashCode(otaUpdateArn());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(targets());
        hashCode = 31 * hashCode + Objects.hashCode(awsJobExecutionsRolloutConfig());
        hashCode = 31 * hashCode + Objects.hashCode(targetSelectionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(otaUpdateFiles());
        hashCode = 31 * hashCode + Objects.hashCode(otaUpdateStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(awsIotJobId());
        hashCode = 31 * hashCode + Objects.hashCode(awsIotJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(errorInfo());
        hashCode = 31 * hashCode + Objects.hashCode(additionalParameters());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OTAUpdateInfo)) {
            return false;
        }
        OTAUpdateInfo other = (OTAUpdateInfo) obj;
        return Objects.equals(otaUpdateId(), other.otaUpdateId()) && Objects.equals(otaUpdateArn(), other.otaUpdateArn())
                && Objects.equals(creationDate(), other.creationDate())
                && Objects.equals(lastModifiedDate(), other.lastModifiedDate())
                && Objects.equals(description(), other.description()) && Objects.equals(targets(), other.targets())
                && Objects.equals(awsJobExecutionsRolloutConfig(), other.awsJobExecutionsRolloutConfig())
                && Objects.equals(targetSelectionAsString(), other.targetSelectionAsString())
                && Objects.equals(otaUpdateFiles(), other.otaUpdateFiles())
                && Objects.equals(otaUpdateStatusAsString(), other.otaUpdateStatusAsString())
                && Objects.equals(awsIotJobId(), other.awsIotJobId()) && Objects.equals(awsIotJobArn(), other.awsIotJobArn())
                && Objects.equals(errorInfo(), other.errorInfo())
                && Objects.equals(additionalParameters(), other.additionalParameters());
    }

    @Override
    public String toString() {
        return ToString.builder("OTAUpdateInfo").add("OtaUpdateId", otaUpdateId()).add("OtaUpdateArn", otaUpdateArn())
                .add("CreationDate", creationDate()).add("LastModifiedDate", lastModifiedDate())
                .add("Description", description()).add("Targets", targets())
                .add("AwsJobExecutionsRolloutConfig", awsJobExecutionsRolloutConfig())
                .add("TargetSelection", targetSelectionAsString()).add("OtaUpdateFiles", otaUpdateFiles())
                .add("OtaUpdateStatus", otaUpdateStatusAsString()).add("AwsIotJobId", awsIotJobId())
                .add("AwsIotJobArn", awsIotJobArn()).add("ErrorInfo", errorInfo())
                .add("AdditionalParameters", additionalParameters()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "otaUpdateId":
            return Optional.ofNullable(clazz.cast(otaUpdateId()));
        case "otaUpdateArn":
            return Optional.ofNullable(clazz.cast(otaUpdateArn()));
        case "creationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "lastModifiedDate":
            return Optional.ofNullable(clazz.cast(lastModifiedDate()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "targets":
            return Optional.ofNullable(clazz.cast(targets()));
        case "awsJobExecutionsRolloutConfig":
            return Optional.ofNullable(clazz.cast(awsJobExecutionsRolloutConfig()));
        case "targetSelection":
            return Optional.ofNullable(clazz.cast(targetSelectionAsString()));
        case "otaUpdateFiles":
            return Optional.ofNullable(clazz.cast(otaUpdateFiles()));
        case "otaUpdateStatus":
            return Optional.ofNullable(clazz.cast(otaUpdateStatusAsString()));
        case "awsIotJobId":
            return Optional.ofNullable(clazz.cast(awsIotJobId()));
        case "awsIotJobArn":
            return Optional.ofNullable(clazz.cast(awsIotJobArn()));
        case "errorInfo":
            return Optional.ofNullable(clazz.cast(errorInfo()));
        case "additionalParameters":
            return Optional.ofNullable(clazz.cast(additionalParameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OTAUpdateInfo, T> g) {
        return obj -> g.apply((OTAUpdateInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OTAUpdateInfo> {
        /**
         * <p>
         * The OTA update ID.
         * </p>
         * 
         * @param otaUpdateId
         *        The OTA update ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder otaUpdateId(String otaUpdateId);

        /**
         * <p>
         * The OTA update ARN.
         * </p>
         * 
         * @param otaUpdateArn
         *        The OTA update ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder otaUpdateArn(String otaUpdateArn);

        /**
         * <p>
         * The date when the OTA update was created.
         * </p>
         * 
         * @param creationDate
         *        The date when the OTA update was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * The date when the OTA update was last updated.
         * </p>
         * 
         * @param lastModifiedDate
         *        The date when the OTA update was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedDate(Instant lastModifiedDate);

        /**
         * <p>
         * A description of the OTA update.
         * </p>
         * 
         * @param description
         *        A description of the OTA update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The targets of the OTA update.
         * </p>
         * 
         * @param targets
         *        The targets of the OTA update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(Collection<String> targets);

        /**
         * <p>
         * The targets of the OTA update.
         * </p>
         * 
         * @param targets
         *        The targets of the OTA update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(String... targets);

        /**
         * <p>
         * Configuration for the rollout of OTA updates.
         * </p>
         * 
         * @param awsJobExecutionsRolloutConfig
         *        Configuration for the rollout of OTA updates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsJobExecutionsRolloutConfig(AwsJobExecutionsRolloutConfig awsJobExecutionsRolloutConfig);

        /**
         * <p>
         * Configuration for the rollout of OTA updates.
         * </p>
         * This is a convenience that creates an instance of the {@link AwsJobExecutionsRolloutConfig.Builder} avoiding
         * the need to create one manually via {@link AwsJobExecutionsRolloutConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsJobExecutionsRolloutConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #awsJobExecutionsRolloutConfig(AwsJobExecutionsRolloutConfig)}
         * .
         * 
         * @param awsJobExecutionsRolloutConfig
         *        a consumer that will call methods on {@link AwsJobExecutionsRolloutConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsJobExecutionsRolloutConfig(AwsJobExecutionsRolloutConfig)
         */
        default Builder awsJobExecutionsRolloutConfig(
                Consumer<AwsJobExecutionsRolloutConfig.Builder> awsJobExecutionsRolloutConfig) {
            return awsJobExecutionsRolloutConfig(AwsJobExecutionsRolloutConfig.builder()
                    .applyMutation(awsJobExecutionsRolloutConfig).build());
        }

        /**
         * <p>
         * Specifies whether the OTA update will continue to run (CONTINUOUS), or will be complete after all those
         * things specified as targets have completed the OTA update (SNAPSHOT). If continuous, the OTA update may also
         * be run on a thing when a change is detected in a target. For example, an OTA update will run on a thing when
         * the thing is added to a target group, even after the OTA update was completed by all things originally in the
         * group.
         * </p>
         * 
         * @param targetSelection
         *        Specifies whether the OTA update will continue to run (CONTINUOUS), or will be complete after all
         *        those things specified as targets have completed the OTA update (SNAPSHOT). If continuous, the OTA
         *        update may also be run on a thing when a change is detected in a target. For example, an OTA update
         *        will run on a thing when the thing is added to a target group, even after the OTA update was completed
         *        by all things originally in the group.
         * @see TargetSelection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetSelection
         */
        Builder targetSelection(String targetSelection);

        /**
         * <p>
         * Specifies whether the OTA update will continue to run (CONTINUOUS), or will be complete after all those
         * things specified as targets have completed the OTA update (SNAPSHOT). If continuous, the OTA update may also
         * be run on a thing when a change is detected in a target. For example, an OTA update will run on a thing when
         * the thing is added to a target group, even after the OTA update was completed by all things originally in the
         * group.
         * </p>
         * 
         * @param targetSelection
         *        Specifies whether the OTA update will continue to run (CONTINUOUS), or will be complete after all
         *        those things specified as targets have completed the OTA update (SNAPSHOT). If continuous, the OTA
         *        update may also be run on a thing when a change is detected in a target. For example, an OTA update
         *        will run on a thing when the thing is added to a target group, even after the OTA update was completed
         *        by all things originally in the group.
         * @see TargetSelection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetSelection
         */
        Builder targetSelection(TargetSelection targetSelection);

        /**
         * <p>
         * A list of files associated with the OTA update.
         * </p>
         * 
         * @param otaUpdateFiles
         *        A list of files associated with the OTA update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder otaUpdateFiles(Collection<OTAUpdateFile> otaUpdateFiles);

        /**
         * <p>
         * A list of files associated with the OTA update.
         * </p>
         * 
         * @param otaUpdateFiles
         *        A list of files associated with the OTA update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder otaUpdateFiles(OTAUpdateFile... otaUpdateFiles);

        /**
         * <p>
         * A list of files associated with the OTA update.
         * </p>
         * This is a convenience that creates an instance of the {@link List<OTAUpdateFile>.Builder} avoiding the need
         * to create one manually via {@link List<OTAUpdateFile>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<OTAUpdateFile>.Builder#build()} is called immediately and
         * its result is passed to {@link #otaUpdateFiles(List<OTAUpdateFile>)}.
         * 
         * @param otaUpdateFiles
         *        a consumer that will call methods on {@link List<OTAUpdateFile>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #otaUpdateFiles(List<OTAUpdateFile>)
         */
        Builder otaUpdateFiles(Consumer<OTAUpdateFile.Builder>... otaUpdateFiles);

        /**
         * <p>
         * The status of the OTA update.
         * </p>
         * 
         * @param otaUpdateStatus
         *        The status of the OTA update.
         * @see OTAUpdateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OTAUpdateStatus
         */
        Builder otaUpdateStatus(String otaUpdateStatus);

        /**
         * <p>
         * The status of the OTA update.
         * </p>
         * 
         * @param otaUpdateStatus
         *        The status of the OTA update.
         * @see OTAUpdateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OTAUpdateStatus
         */
        Builder otaUpdateStatus(OTAUpdateStatus otaUpdateStatus);

        /**
         * <p>
         * The AWS IoT job ID associated with the OTA update.
         * </p>
         * 
         * @param awsIotJobId
         *        The AWS IoT job ID associated with the OTA update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsIotJobId(String awsIotJobId);

        /**
         * <p>
         * The AWS IoT job ARN associated with the OTA update.
         * </p>
         * 
         * @param awsIotJobArn
         *        The AWS IoT job ARN associated with the OTA update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsIotJobArn(String awsIotJobArn);

        /**
         * <p>
         * Error information associated with the OTA update.
         * </p>
         * 
         * @param errorInfo
         *        Error information associated with the OTA update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorInfo(ErrorInfo errorInfo);

        /**
         * <p>
         * Error information associated with the OTA update.
         * </p>
         * This is a convenience that creates an instance of the {@link ErrorInfo.Builder} avoiding the need to create
         * one manually via {@link ErrorInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link ErrorInfo.Builder#build()} is called immediately and its result
         * is passed to {@link #errorInfo(ErrorInfo)}.
         * 
         * @param errorInfo
         *        a consumer that will call methods on {@link ErrorInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errorInfo(ErrorInfo)
         */
        default Builder errorInfo(Consumer<ErrorInfo.Builder> errorInfo) {
            return errorInfo(ErrorInfo.builder().applyMutation(errorInfo).build());
        }

        /**
         * <p>
         * A collection of name/value pairs
         * </p>
         * 
         * @param additionalParameters
         *        A collection of name/value pairs
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalParameters(Map<String, String> additionalParameters);
    }

    static final class BuilderImpl implements Builder {
        private String otaUpdateId;

        private String otaUpdateArn;

        private Instant creationDate;

        private Instant lastModifiedDate;

        private String description;

        private List<String> targets = DefaultSdkAutoConstructList.getInstance();

        private AwsJobExecutionsRolloutConfig awsJobExecutionsRolloutConfig;

        private String targetSelection;

        private List<OTAUpdateFile> otaUpdateFiles = DefaultSdkAutoConstructList.getInstance();

        private String otaUpdateStatus;

        private String awsIotJobId;

        private String awsIotJobArn;

        private ErrorInfo errorInfo;

        private Map<String, String> additionalParameters = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OTAUpdateInfo model) {
            otaUpdateId(model.otaUpdateId);
            otaUpdateArn(model.otaUpdateArn);
            creationDate(model.creationDate);
            lastModifiedDate(model.lastModifiedDate);
            description(model.description);
            targets(model.targets);
            awsJobExecutionsRolloutConfig(model.awsJobExecutionsRolloutConfig);
            targetSelection(model.targetSelection);
            otaUpdateFiles(model.otaUpdateFiles);
            otaUpdateStatus(model.otaUpdateStatus);
            awsIotJobId(model.awsIotJobId);
            awsIotJobArn(model.awsIotJobArn);
            errorInfo(model.errorInfo);
            additionalParameters(model.additionalParameters);
        }

        public final String getOtaUpdateId() {
            return otaUpdateId;
        }

        @Override
        public final Builder otaUpdateId(String otaUpdateId) {
            this.otaUpdateId = otaUpdateId;
            return this;
        }

        public final void setOtaUpdateId(String otaUpdateId) {
            this.otaUpdateId = otaUpdateId;
        }

        public final String getOtaUpdateArn() {
            return otaUpdateArn;
        }

        @Override
        public final Builder otaUpdateArn(String otaUpdateArn) {
            this.otaUpdateArn = otaUpdateArn;
            return this;
        }

        public final void setOtaUpdateArn(String otaUpdateArn) {
            this.otaUpdateArn = otaUpdateArn;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final Instant getLastModifiedDate() {
            return lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<String> getTargets() {
            return targets;
        }

        @Override
        public final Builder targets(Collection<String> targets) {
            this.targets = TargetsCopier.copy(targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(String... targets) {
            targets(Arrays.asList(targets));
            return this;
        }

        public final void setTargets(Collection<String> targets) {
            this.targets = TargetsCopier.copy(targets);
        }

        public final AwsJobExecutionsRolloutConfig.Builder getAwsJobExecutionsRolloutConfig() {
            return awsJobExecutionsRolloutConfig != null ? awsJobExecutionsRolloutConfig.toBuilder() : null;
        }

        @Override
        public final Builder awsJobExecutionsRolloutConfig(AwsJobExecutionsRolloutConfig awsJobExecutionsRolloutConfig) {
            this.awsJobExecutionsRolloutConfig = awsJobExecutionsRolloutConfig;
            return this;
        }

        public final void setAwsJobExecutionsRolloutConfig(AwsJobExecutionsRolloutConfig.BuilderImpl awsJobExecutionsRolloutConfig) {
            this.awsJobExecutionsRolloutConfig = awsJobExecutionsRolloutConfig != null ? awsJobExecutionsRolloutConfig.build()
                    : null;
        }

        public final String getTargetSelectionAsString() {
            return targetSelection;
        }

        @Override
        public final Builder targetSelection(String targetSelection) {
            this.targetSelection = targetSelection;
            return this;
        }

        @Override
        public final Builder targetSelection(TargetSelection targetSelection) {
            this.targetSelection(targetSelection.toString());
            return this;
        }

        public final void setTargetSelection(String targetSelection) {
            this.targetSelection = targetSelection;
        }

        public final Collection<OTAUpdateFile.Builder> getOtaUpdateFiles() {
            return otaUpdateFiles != null ? otaUpdateFiles.stream().map(OTAUpdateFile::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder otaUpdateFiles(Collection<OTAUpdateFile> otaUpdateFiles) {
            this.otaUpdateFiles = OTAUpdateFilesCopier.copy(otaUpdateFiles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder otaUpdateFiles(OTAUpdateFile... otaUpdateFiles) {
            otaUpdateFiles(Arrays.asList(otaUpdateFiles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder otaUpdateFiles(Consumer<OTAUpdateFile.Builder>... otaUpdateFiles) {
            otaUpdateFiles(Stream.of(otaUpdateFiles).map(c -> OTAUpdateFile.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setOtaUpdateFiles(Collection<OTAUpdateFile.BuilderImpl> otaUpdateFiles) {
            this.otaUpdateFiles = OTAUpdateFilesCopier.copyFromBuilder(otaUpdateFiles);
        }

        public final String getOtaUpdateStatusAsString() {
            return otaUpdateStatus;
        }

        @Override
        public final Builder otaUpdateStatus(String otaUpdateStatus) {
            this.otaUpdateStatus = otaUpdateStatus;
            return this;
        }

        @Override
        public final Builder otaUpdateStatus(OTAUpdateStatus otaUpdateStatus) {
            this.otaUpdateStatus(otaUpdateStatus.toString());
            return this;
        }

        public final void setOtaUpdateStatus(String otaUpdateStatus) {
            this.otaUpdateStatus = otaUpdateStatus;
        }

        public final String getAwsIotJobId() {
            return awsIotJobId;
        }

        @Override
        public final Builder awsIotJobId(String awsIotJobId) {
            this.awsIotJobId = awsIotJobId;
            return this;
        }

        public final void setAwsIotJobId(String awsIotJobId) {
            this.awsIotJobId = awsIotJobId;
        }

        public final String getAwsIotJobArn() {
            return awsIotJobArn;
        }

        @Override
        public final Builder awsIotJobArn(String awsIotJobArn) {
            this.awsIotJobArn = awsIotJobArn;
            return this;
        }

        public final void setAwsIotJobArn(String awsIotJobArn) {
            this.awsIotJobArn = awsIotJobArn;
        }

        public final ErrorInfo.Builder getErrorInfo() {
            return errorInfo != null ? errorInfo.toBuilder() : null;
        }

        @Override
        public final Builder errorInfo(ErrorInfo errorInfo) {
            this.errorInfo = errorInfo;
            return this;
        }

        public final void setErrorInfo(ErrorInfo.BuilderImpl errorInfo) {
            this.errorInfo = errorInfo != null ? errorInfo.build() : null;
        }

        public final Map<String, String> getAdditionalParameters() {
            return additionalParameters;
        }

        @Override
        public final Builder additionalParameters(Map<String, String> additionalParameters) {
            this.additionalParameters = AdditionalParameterMapCopier.copy(additionalParameters);
            return this;
        }

        public final void setAdditionalParameters(Map<String, String> additionalParameters) {
            this.additionalParameters = AdditionalParameterMapCopier.copy(additionalParameters);
        }

        @Override
        public OTAUpdateInfo build() {
            return new OTAUpdateInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
