/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a group of files that can be streamed.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Stream implements SdkPojo, Serializable, ToCopyableBuilder<Stream.Builder, Stream> {
    private static final SdkField<String> STREAM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Stream::streamId)).setter(setter(Builder::streamId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamId").build()).build();

    private static final SdkField<Integer> FILE_ID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Stream::fileId)).setter(setter(Builder::fileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(STREAM_ID_FIELD, FILE_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String streamId;

    private final Integer fileId;

    private Stream(BuilderImpl builder) {
        this.streamId = builder.streamId;
        this.fileId = builder.fileId;
    }

    /**
     * <p>
     * The stream ID.
     * </p>
     * 
     * @return The stream ID.
     */
    public String streamId() {
        return streamId;
    }

    /**
     * <p>
     * The ID of a file associated with a stream.
     * </p>
     * 
     * @return The ID of a file associated with a stream.
     */
    public Integer fileId() {
        return fileId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(streamId());
        hashCode = 31 * hashCode + Objects.hashCode(fileId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Stream)) {
            return false;
        }
        Stream other = (Stream) obj;
        return Objects.equals(streamId(), other.streamId()) && Objects.equals(fileId(), other.fileId());
    }

    @Override
    public String toString() {
        return ToString.builder("Stream").add("StreamId", streamId()).add("FileId", fileId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "streamId":
            return Optional.ofNullable(clazz.cast(streamId()));
        case "fileId":
            return Optional.ofNullable(clazz.cast(fileId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Stream, T> g) {
        return obj -> g.apply((Stream) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Stream> {
        /**
         * <p>
         * The stream ID.
         * </p>
         * 
         * @param streamId
         *        The stream ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamId(String streamId);

        /**
         * <p>
         * The ID of a file associated with a stream.
         * </p>
         * 
         * @param fileId
         *        The ID of a file associated with a stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileId(Integer fileId);
    }

    static final class BuilderImpl implements Builder {
        private String streamId;

        private Integer fileId;

        private BuilderImpl() {
        }

        private BuilderImpl(Stream model) {
            streamId(model.streamId);
            fileId(model.fileId);
        }

        public final String getStreamId() {
            return streamId;
        }

        @Override
        public final Builder streamId(String streamId) {
            this.streamId = streamId;
            return this;
        }

        public final void setStreamId(String streamId) {
            this.streamId = streamId;
        }

        public final Integer getFileId() {
            return fileId;
        }

        @Override
        public final Builder fileId(Integer fileId) {
            this.fileId = fileId;
            return this;
        }

        public final void setFileId(Integer fileId) {
            this.fileId = fileId;
        }

        @Override
        public Stream build() {
            return new Stream(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
