/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.iot.model.AttributesMapCopier;
import software.amazon.awssdk.services.iot.model.CodeSigning;
import software.amazon.awssdk.services.iot.model.FileLocation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OTAUpdateFile
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OTAUpdateFile> {
    private static final SdkField<String> FILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(OTAUpdateFile.getter(OTAUpdateFile::fileName)).setter(OTAUpdateFile.setter(Builder::fileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileName").build()}).build();
    private static final SdkField<String> FILE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(OTAUpdateFile.getter(OTAUpdateFile::fileVersion)).setter(OTAUpdateFile.setter(Builder::fileVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileVersion").build()}).build();
    private static final SdkField<FileLocation> FILE_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(OTAUpdateFile.getter(OTAUpdateFile::fileLocation)).setter(OTAUpdateFile.setter(Builder::fileLocation)).constructor(FileLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileLocation").build()}).build();
    private static final SdkField<CodeSigning> CODE_SIGNING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(OTAUpdateFile.getter(OTAUpdateFile::codeSigning)).setter(OTAUpdateFile.setter(Builder::codeSigning)).constructor(CodeSigning::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codeSigning").build()}).build();
    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(OTAUpdateFile.getter(OTAUpdateFile::attributes)).setter(OTAUpdateFile.setter(Builder::attributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_NAME_FIELD, FILE_VERSION_FIELD, FILE_LOCATION_FIELD, CODE_SIGNING_FIELD, ATTRIBUTES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String fileName;
    private final String fileVersion;
    private final FileLocation fileLocation;
    private final CodeSigning codeSigning;
    private final Map<String, String> attributes;

    private OTAUpdateFile(BuilderImpl builder) {
        this.fileName = builder.fileName;
        this.fileVersion = builder.fileVersion;
        this.fileLocation = builder.fileLocation;
        this.codeSigning = builder.codeSigning;
        this.attributes = builder.attributes;
    }

    public String fileName() {
        return this.fileName;
    }

    public String fileVersion() {
        return this.fileVersion;
    }

    public FileLocation fileLocation() {
        return this.fileLocation;
    }

    public CodeSigning codeSigning() {
        return this.codeSigning;
    }

    public Map<String, String> attributes() {
        return this.attributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.codeSigning());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OTAUpdateFile)) {
            return false;
        }
        OTAUpdateFile other = (OTAUpdateFile)obj;
        return Objects.equals(this.fileName(), other.fileName()) && Objects.equals(this.fileVersion(), other.fileVersion()) && Objects.equals(this.fileLocation(), other.fileLocation()) && Objects.equals(this.codeSigning(), other.codeSigning()) && Objects.equals(this.attributes(), other.attributes());
    }

    public String toString() {
        return ToString.builder((String)"OTAUpdateFile").add("FileName", (Object)this.fileName()).add("FileVersion", (Object)this.fileVersion()).add("FileLocation", (Object)this.fileLocation()).add("CodeSigning", (Object)this.codeSigning()).add("Attributes", this.attributes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "fileName": {
                return Optional.ofNullable(clazz.cast(this.fileName()));
            }
            case "fileVersion": {
                return Optional.ofNullable(clazz.cast(this.fileVersion()));
            }
            case "fileLocation": {
                return Optional.ofNullable(clazz.cast(this.fileLocation()));
            }
            case "codeSigning": {
                return Optional.ofNullable(clazz.cast(this.codeSigning()));
            }
            case "attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OTAUpdateFile, T> g) {
        return obj -> g.apply((OTAUpdateFile)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String fileName;
        private String fileVersion;
        private FileLocation fileLocation;
        private CodeSigning codeSigning;
        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OTAUpdateFile model) {
            this.fileName(model.fileName);
            this.fileVersion(model.fileVersion);
            this.fileLocation(model.fileLocation);
            this.codeSigning(model.codeSigning);
            this.attributes(model.attributes);
        }

        public final String getFileName() {
            return this.fileName;
        }

        @Override
        public final Builder fileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public final void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public final String getFileVersion() {
            return this.fileVersion;
        }

        @Override
        public final Builder fileVersion(String fileVersion) {
            this.fileVersion = fileVersion;
            return this;
        }

        public final void setFileVersion(String fileVersion) {
            this.fileVersion = fileVersion;
        }

        public final FileLocation.Builder getFileLocation() {
            return this.fileLocation != null ? this.fileLocation.toBuilder() : null;
        }

        @Override
        public final Builder fileLocation(FileLocation fileLocation) {
            this.fileLocation = fileLocation;
            return this;
        }

        public final void setFileLocation(FileLocation.BuilderImpl fileLocation) {
            this.fileLocation = fileLocation != null ? fileLocation.build() : null;
        }

        public final CodeSigning.Builder getCodeSigning() {
            return this.codeSigning != null ? this.codeSigning.toBuilder() : null;
        }

        @Override
        public final Builder codeSigning(CodeSigning codeSigning) {
            this.codeSigning = codeSigning;
            return this;
        }

        public final void setCodeSigning(CodeSigning.BuilderImpl codeSigning) {
            this.codeSigning = codeSigning != null ? codeSigning.build() : null;
        }

        public final Map<String, String> getAttributes() {
            return this.attributes;
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = AttributesMapCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = AttributesMapCopier.copy(attributes);
        }

        public OTAUpdateFile build() {
            return new OTAUpdateFile(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OTAUpdateFile> {
        public Builder fileName(String var1);

        public Builder fileVersion(String var1);

        public Builder fileLocation(FileLocation var1);

        default public Builder fileLocation(Consumer<FileLocation.Builder> fileLocation) {
            return this.fileLocation((FileLocation)((FileLocation.Builder)FileLocation.builder().applyMutation(fileLocation)).build());
        }

        public Builder codeSigning(CodeSigning var1);

        default public Builder codeSigning(Consumer<CodeSigning.Builder> codeSigning) {
            return this.codeSigning((CodeSigning)((CodeSigning.Builder)CodeSigning.builder().applyMutation(codeSigning)).build());
        }

        public Builder attributes(Map<String, String> var1);
    }
}

