/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the audit check.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AuditCheckDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AuditCheckDetails.Builder, AuditCheckDetails> {
    private static final SdkField<String> CHECK_RUN_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AuditCheckDetails::checkRunStatusAsString)).setter(setter(Builder::checkRunStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("checkRunStatus").build()).build();

    private static final SdkField<Boolean> CHECK_COMPLIANT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(AuditCheckDetails::checkCompliant)).setter(setter(Builder::checkCompliant))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("checkCompliant").build()).build();

    private static final SdkField<Long> TOTAL_RESOURCES_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(AuditCheckDetails::totalResourcesCount)).setter(setter(Builder::totalResourcesCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalResourcesCount").build())
            .build();

    private static final SdkField<Long> NON_COMPLIANT_RESOURCES_COUNT_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .getter(getter(AuditCheckDetails::nonCompliantResourcesCount))
            .setter(setter(Builder::nonCompliantResourcesCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nonCompliantResourcesCount").build())
            .build();

    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AuditCheckDetails::errorCode)).setter(setter(Builder::errorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorCode").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AuditCheckDetails::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHECK_RUN_STATUS_FIELD,
            CHECK_COMPLIANT_FIELD, TOTAL_RESOURCES_COUNT_FIELD, NON_COMPLIANT_RESOURCES_COUNT_FIELD, ERROR_CODE_FIELD,
            MESSAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String checkRunStatus;

    private final Boolean checkCompliant;

    private final Long totalResourcesCount;

    private final Long nonCompliantResourcesCount;

    private final String errorCode;

    private final String message;

    private AuditCheckDetails(BuilderImpl builder) {
        this.checkRunStatus = builder.checkRunStatus;
        this.checkCompliant = builder.checkCompliant;
        this.totalResourcesCount = builder.totalResourcesCount;
        this.nonCompliantResourcesCount = builder.nonCompliantResourcesCount;
        this.errorCode = builder.errorCode;
        this.message = builder.message;
    }

    /**
     * <p>
     * The completion status of this check, one of "IN_PROGRESS", "WAITING_FOR_DATA_COLLECTION", "CANCELED",
     * "COMPLETED_COMPLIANT", "COMPLETED_NON_COMPLIANT", or "FAILED".
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #checkRunStatus}
     * will return {@link AuditCheckRunStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #checkRunStatusAsString}.
     * </p>
     * 
     * @return The completion status of this check, one of "IN_PROGRESS", "WAITING_FOR_DATA_COLLECTION", "CANCELED",
     *         "COMPLETED_COMPLIANT", "COMPLETED_NON_COMPLIANT", or "FAILED".
     * @see AuditCheckRunStatus
     */
    public AuditCheckRunStatus checkRunStatus() {
        return AuditCheckRunStatus.fromValue(checkRunStatus);
    }

    /**
     * <p>
     * The completion status of this check, one of "IN_PROGRESS", "WAITING_FOR_DATA_COLLECTION", "CANCELED",
     * "COMPLETED_COMPLIANT", "COMPLETED_NON_COMPLIANT", or "FAILED".
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #checkRunStatus}
     * will return {@link AuditCheckRunStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #checkRunStatusAsString}.
     * </p>
     * 
     * @return The completion status of this check, one of "IN_PROGRESS", "WAITING_FOR_DATA_COLLECTION", "CANCELED",
     *         "COMPLETED_COMPLIANT", "COMPLETED_NON_COMPLIANT", or "FAILED".
     * @see AuditCheckRunStatus
     */
    public String checkRunStatusAsString() {
        return checkRunStatus;
    }

    /**
     * <p>
     * True if the check completed and found all resources compliant.
     * </p>
     * 
     * @return True if the check completed and found all resources compliant.
     */
    public Boolean checkCompliant() {
        return checkCompliant;
    }

    /**
     * <p>
     * The number of resources on which the check was performed.
     * </p>
     * 
     * @return The number of resources on which the check was performed.
     */
    public Long totalResourcesCount() {
        return totalResourcesCount;
    }

    /**
     * <p>
     * The number of resources that the check found non-compliant.
     * </p>
     * 
     * @return The number of resources that the check found non-compliant.
     */
    public Long nonCompliantResourcesCount() {
        return nonCompliantResourcesCount;
    }

    /**
     * <p>
     * The code of any error encountered when performing this check during this audit. One of
     * "INSUFFICIENT_PERMISSIONS", or "AUDIT_CHECK_DISABLED".
     * </p>
     * 
     * @return The code of any error encountered when performing this check during this audit. One of
     *         "INSUFFICIENT_PERMISSIONS", or "AUDIT_CHECK_DISABLED".
     */
    public String errorCode() {
        return errorCode;
    }

    /**
     * <p>
     * The message associated with any error encountered when performing this check during this audit.
     * </p>
     * 
     * @return The message associated with any error encountered when performing this check during this audit.
     */
    public String message() {
        return message;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(checkRunStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(checkCompliant());
        hashCode = 31 * hashCode + Objects.hashCode(totalResourcesCount());
        hashCode = 31 * hashCode + Objects.hashCode(nonCompliantResourcesCount());
        hashCode = 31 * hashCode + Objects.hashCode(errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuditCheckDetails)) {
            return false;
        }
        AuditCheckDetails other = (AuditCheckDetails) obj;
        return Objects.equals(checkRunStatusAsString(), other.checkRunStatusAsString())
                && Objects.equals(checkCompliant(), other.checkCompliant())
                && Objects.equals(totalResourcesCount(), other.totalResourcesCount())
                && Objects.equals(nonCompliantResourcesCount(), other.nonCompliantResourcesCount())
                && Objects.equals(errorCode(), other.errorCode()) && Objects.equals(message(), other.message());
    }

    @Override
    public String toString() {
        return ToString.builder("AuditCheckDetails").add("CheckRunStatus", checkRunStatusAsString())
                .add("CheckCompliant", checkCompliant()).add("TotalResourcesCount", totalResourcesCount())
                .add("NonCompliantResourcesCount", nonCompliantResourcesCount()).add("ErrorCode", errorCode())
                .add("Message", message()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "checkRunStatus":
            return Optional.ofNullable(clazz.cast(checkRunStatusAsString()));
        case "checkCompliant":
            return Optional.ofNullable(clazz.cast(checkCompliant()));
        case "totalResourcesCount":
            return Optional.ofNullable(clazz.cast(totalResourcesCount()));
        case "nonCompliantResourcesCount":
            return Optional.ofNullable(clazz.cast(nonCompliantResourcesCount()));
        case "errorCode":
            return Optional.ofNullable(clazz.cast(errorCode()));
        case "message":
            return Optional.ofNullable(clazz.cast(message()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AuditCheckDetails, T> g) {
        return obj -> g.apply((AuditCheckDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AuditCheckDetails> {
        /**
         * <p>
         * The completion status of this check, one of "IN_PROGRESS", "WAITING_FOR_DATA_COLLECTION", "CANCELED",
         * "COMPLETED_COMPLIANT", "COMPLETED_NON_COMPLIANT", or "FAILED".
         * </p>
         * 
         * @param checkRunStatus
         *        The completion status of this check, one of "IN_PROGRESS", "WAITING_FOR_DATA_COLLECTION", "CANCELED",
         *        "COMPLETED_COMPLIANT", "COMPLETED_NON_COMPLIANT", or "FAILED".
         * @see AuditCheckRunStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuditCheckRunStatus
         */
        Builder checkRunStatus(String checkRunStatus);

        /**
         * <p>
         * The completion status of this check, one of "IN_PROGRESS", "WAITING_FOR_DATA_COLLECTION", "CANCELED",
         * "COMPLETED_COMPLIANT", "COMPLETED_NON_COMPLIANT", or "FAILED".
         * </p>
         * 
         * @param checkRunStatus
         *        The completion status of this check, one of "IN_PROGRESS", "WAITING_FOR_DATA_COLLECTION", "CANCELED",
         *        "COMPLETED_COMPLIANT", "COMPLETED_NON_COMPLIANT", or "FAILED".
         * @see AuditCheckRunStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuditCheckRunStatus
         */
        Builder checkRunStatus(AuditCheckRunStatus checkRunStatus);

        /**
         * <p>
         * True if the check completed and found all resources compliant.
         * </p>
         * 
         * @param checkCompliant
         *        True if the check completed and found all resources compliant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checkCompliant(Boolean checkCompliant);

        /**
         * <p>
         * The number of resources on which the check was performed.
         * </p>
         * 
         * @param totalResourcesCount
         *        The number of resources on which the check was performed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalResourcesCount(Long totalResourcesCount);

        /**
         * <p>
         * The number of resources that the check found non-compliant.
         * </p>
         * 
         * @param nonCompliantResourcesCount
         *        The number of resources that the check found non-compliant.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nonCompliantResourcesCount(Long nonCompliantResourcesCount);

        /**
         * <p>
         * The code of any error encountered when performing this check during this audit. One of
         * "INSUFFICIENT_PERMISSIONS", or "AUDIT_CHECK_DISABLED".
         * </p>
         * 
         * @param errorCode
         *        The code of any error encountered when performing this check during this audit. One of
         *        "INSUFFICIENT_PERMISSIONS", or "AUDIT_CHECK_DISABLED".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorCode(String errorCode);

        /**
         * <p>
         * The message associated with any error encountered when performing this check during this audit.
         * </p>
         * 
         * @param message
         *        The message associated with any error encountered when performing this check during this audit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);
    }

    static final class BuilderImpl implements Builder {
        private String checkRunStatus;

        private Boolean checkCompliant;

        private Long totalResourcesCount;

        private Long nonCompliantResourcesCount;

        private String errorCode;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(AuditCheckDetails model) {
            checkRunStatus(model.checkRunStatus);
            checkCompliant(model.checkCompliant);
            totalResourcesCount(model.totalResourcesCount);
            nonCompliantResourcesCount(model.nonCompliantResourcesCount);
            errorCode(model.errorCode);
            message(model.message);
        }

        public final String getCheckRunStatusAsString() {
            return checkRunStatus;
        }

        @Override
        public final Builder checkRunStatus(String checkRunStatus) {
            this.checkRunStatus = checkRunStatus;
            return this;
        }

        @Override
        public final Builder checkRunStatus(AuditCheckRunStatus checkRunStatus) {
            this.checkRunStatus(checkRunStatus.toString());
            return this;
        }

        public final void setCheckRunStatus(String checkRunStatus) {
            this.checkRunStatus = checkRunStatus;
        }

        public final Boolean getCheckCompliant() {
            return checkCompliant;
        }

        @Override
        public final Builder checkCompliant(Boolean checkCompliant) {
            this.checkCompliant = checkCompliant;
            return this;
        }

        public final void setCheckCompliant(Boolean checkCompliant) {
            this.checkCompliant = checkCompliant;
        }

        public final Long getTotalResourcesCount() {
            return totalResourcesCount;
        }

        @Override
        public final Builder totalResourcesCount(Long totalResourcesCount) {
            this.totalResourcesCount = totalResourcesCount;
            return this;
        }

        public final void setTotalResourcesCount(Long totalResourcesCount) {
            this.totalResourcesCount = totalResourcesCount;
        }

        public final Long getNonCompliantResourcesCount() {
            return nonCompliantResourcesCount;
        }

        @Override
        public final Builder nonCompliantResourcesCount(Long nonCompliantResourcesCount) {
            this.nonCompliantResourcesCount = nonCompliantResourcesCount;
            return this;
        }

        public final void setNonCompliantResourcesCount(Long nonCompliantResourcesCount) {
            this.nonCompliantResourcesCount = nonCompliantResourcesCount;
        }

        public final String getErrorCode() {
            return errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public final String getMessage() {
            return message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public AuditCheckDetails build() {
            return new AuditCheckDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
