/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetIndexingConfigurationResponse extends IotResponse implements
        ToCopyableBuilder<GetIndexingConfigurationResponse.Builder, GetIndexingConfigurationResponse> {
    private static final SdkField<ThingIndexingConfiguration> THING_INDEXING_CONFIGURATION_FIELD = SdkField
            .<ThingIndexingConfiguration> builder(MarshallingType.SDK_POJO)
            .getter(getter(GetIndexingConfigurationResponse::thingIndexingConfiguration))
            .setter(setter(Builder::thingIndexingConfiguration))
            .constructor(ThingIndexingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingIndexingConfiguration").build())
            .build();

    private static final SdkField<ThingGroupIndexingConfiguration> THING_GROUP_INDEXING_CONFIGURATION_FIELD = SdkField
            .<ThingGroupIndexingConfiguration> builder(MarshallingType.SDK_POJO)
            .getter(getter(GetIndexingConfigurationResponse::thingGroupIndexingConfiguration))
            .setter(setter(Builder::thingGroupIndexingConfiguration))
            .constructor(ThingGroupIndexingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingGroupIndexingConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            THING_INDEXING_CONFIGURATION_FIELD, THING_GROUP_INDEXING_CONFIGURATION_FIELD));

    private final ThingIndexingConfiguration thingIndexingConfiguration;

    private final ThingGroupIndexingConfiguration thingGroupIndexingConfiguration;

    private GetIndexingConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.thingIndexingConfiguration = builder.thingIndexingConfiguration;
        this.thingGroupIndexingConfiguration = builder.thingGroupIndexingConfiguration;
    }

    /**
     * <p>
     * Thing indexing configuration.
     * </p>
     * 
     * @return Thing indexing configuration.
     */
    public ThingIndexingConfiguration thingIndexingConfiguration() {
        return thingIndexingConfiguration;
    }

    /**
     * <p>
     * The index configuration.
     * </p>
     * 
     * @return The index configuration.
     */
    public ThingGroupIndexingConfiguration thingGroupIndexingConfiguration() {
        return thingGroupIndexingConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(thingIndexingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(thingGroupIndexingConfiguration());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIndexingConfigurationResponse)) {
            return false;
        }
        GetIndexingConfigurationResponse other = (GetIndexingConfigurationResponse) obj;
        return Objects.equals(thingIndexingConfiguration(), other.thingIndexingConfiguration())
                && Objects.equals(thingGroupIndexingConfiguration(), other.thingGroupIndexingConfiguration());
    }

    @Override
    public String toString() {
        return ToString.builder("GetIndexingConfigurationResponse")
                .add("ThingIndexingConfiguration", thingIndexingConfiguration())
                .add("ThingGroupIndexingConfiguration", thingGroupIndexingConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "thingIndexingConfiguration":
            return Optional.ofNullable(clazz.cast(thingIndexingConfiguration()));
        case "thingGroupIndexingConfiguration":
            return Optional.ofNullable(clazz.cast(thingGroupIndexingConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetIndexingConfigurationResponse, T> g) {
        return obj -> g.apply((GetIndexingConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetIndexingConfigurationResponse> {
        /**
         * <p>
         * Thing indexing configuration.
         * </p>
         * 
         * @param thingIndexingConfiguration
         *        Thing indexing configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingIndexingConfiguration(ThingIndexingConfiguration thingIndexingConfiguration);

        /**
         * <p>
         * Thing indexing configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link ThingIndexingConfiguration.Builder} avoiding the
         * need to create one manually via {@link ThingIndexingConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link ThingIndexingConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #thingIndexingConfiguration(ThingIndexingConfiguration)}.
         * 
         * @param thingIndexingConfiguration
         *        a consumer that will call methods on {@link ThingIndexingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #thingIndexingConfiguration(ThingIndexingConfiguration)
         */
        default Builder thingIndexingConfiguration(Consumer<ThingIndexingConfiguration.Builder> thingIndexingConfiguration) {
            return thingIndexingConfiguration(ThingIndexingConfiguration.builder().applyMutation(thingIndexingConfiguration)
                    .build());
        }

        /**
         * <p>
         * The index configuration.
         * </p>
         * 
         * @param thingGroupIndexingConfiguration
         *        The index configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingGroupIndexingConfiguration(ThingGroupIndexingConfiguration thingGroupIndexingConfiguration);

        /**
         * <p>
         * The index configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link ThingGroupIndexingConfiguration.Builder}
         * avoiding the need to create one manually via {@link ThingGroupIndexingConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link ThingGroupIndexingConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #thingGroupIndexingConfiguration(ThingGroupIndexingConfiguration)}.
         * 
         * @param thingGroupIndexingConfiguration
         *        a consumer that will call methods on {@link ThingGroupIndexingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #thingGroupIndexingConfiguration(ThingGroupIndexingConfiguration)
         */
        default Builder thingGroupIndexingConfiguration(
                Consumer<ThingGroupIndexingConfiguration.Builder> thingGroupIndexingConfiguration) {
            return thingGroupIndexingConfiguration(ThingGroupIndexingConfiguration.builder()
                    .applyMutation(thingGroupIndexingConfiguration).build());
        }
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private ThingIndexingConfiguration thingIndexingConfiguration;

        private ThingGroupIndexingConfiguration thingGroupIndexingConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(GetIndexingConfigurationResponse model) {
            super(model);
            thingIndexingConfiguration(model.thingIndexingConfiguration);
            thingGroupIndexingConfiguration(model.thingGroupIndexingConfiguration);
        }

        public final ThingIndexingConfiguration.Builder getThingIndexingConfiguration() {
            return thingIndexingConfiguration != null ? thingIndexingConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder thingIndexingConfiguration(ThingIndexingConfiguration thingIndexingConfiguration) {
            this.thingIndexingConfiguration = thingIndexingConfiguration;
            return this;
        }

        public final void setThingIndexingConfiguration(ThingIndexingConfiguration.BuilderImpl thingIndexingConfiguration) {
            this.thingIndexingConfiguration = thingIndexingConfiguration != null ? thingIndexingConfiguration.build() : null;
        }

        public final ThingGroupIndexingConfiguration.Builder getThingGroupIndexingConfiguration() {
            return thingGroupIndexingConfiguration != null ? thingGroupIndexingConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder thingGroupIndexingConfiguration(ThingGroupIndexingConfiguration thingGroupIndexingConfiguration) {
            this.thingGroupIndexingConfiguration = thingGroupIndexingConfiguration;
            return this;
        }

        public final void setThingGroupIndexingConfiguration(
                ThingGroupIndexingConfiguration.BuilderImpl thingGroupIndexingConfiguration) {
            this.thingGroupIndexingConfiguration = thingGroupIndexingConfiguration != null ? thingGroupIndexingConfiguration
                    .build() : null;
        }

        @Override
        public GetIndexingConfigurationResponse build() {
            return new GetIndexingConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
