/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ValidateSecurityProfileBehaviorsResponse extends IotResponse implements
        ToCopyableBuilder<ValidateSecurityProfileBehaviorsResponse.Builder, ValidateSecurityProfileBehaviorsResponse> {
    private static final SdkField<Boolean> VALID_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(ValidateSecurityProfileBehaviorsResponse::valid)).setter(setter(Builder::valid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("valid").build()).build();

    private static final SdkField<List<ValidationError>> VALIDATION_ERRORS_FIELD = SdkField
            .<List<ValidationError>> builder(MarshallingType.LIST)
            .getter(getter(ValidateSecurityProfileBehaviorsResponse::validationErrors))
            .setter(setter(Builder::validationErrors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validationErrors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ValidationError> builder(MarshallingType.SDK_POJO)
                                            .constructor(ValidationError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALID_FIELD,
            VALIDATION_ERRORS_FIELD));

    private final Boolean valid;

    private final List<ValidationError> validationErrors;

    private ValidateSecurityProfileBehaviorsResponse(BuilderImpl builder) {
        super(builder);
        this.valid = builder.valid;
        this.validationErrors = builder.validationErrors;
    }

    /**
     * <p>
     * True if the behaviors were valid.
     * </p>
     * 
     * @return True if the behaviors were valid.
     */
    public Boolean valid() {
        return valid;
    }

    /**
     * <p>
     * The list of any errors found in the behaviors.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The list of any errors found in the behaviors.
     */
    public List<ValidationError> validationErrors() {
        return validationErrors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(valid());
        hashCode = 31 * hashCode + Objects.hashCode(validationErrors());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidateSecurityProfileBehaviorsResponse)) {
            return false;
        }
        ValidateSecurityProfileBehaviorsResponse other = (ValidateSecurityProfileBehaviorsResponse) obj;
        return Objects.equals(valid(), other.valid()) && Objects.equals(validationErrors(), other.validationErrors());
    }

    @Override
    public String toString() {
        return ToString.builder("ValidateSecurityProfileBehaviorsResponse").add("Valid", valid())
                .add("ValidationErrors", validationErrors()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "valid":
            return Optional.ofNullable(clazz.cast(valid()));
        case "validationErrors":
            return Optional.ofNullable(clazz.cast(validationErrors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ValidateSecurityProfileBehaviorsResponse, T> g) {
        return obj -> g.apply((ValidateSecurityProfileBehaviorsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ValidateSecurityProfileBehaviorsResponse> {
        /**
         * <p>
         * True if the behaviors were valid.
         * </p>
         * 
         * @param valid
         *        True if the behaviors were valid.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder valid(Boolean valid);

        /**
         * <p>
         * The list of any errors found in the behaviors.
         * </p>
         * 
         * @param validationErrors
         *        The list of any errors found in the behaviors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationErrors(Collection<ValidationError> validationErrors);

        /**
         * <p>
         * The list of any errors found in the behaviors.
         * </p>
         * 
         * @param validationErrors
         *        The list of any errors found in the behaviors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationErrors(ValidationError... validationErrors);

        /**
         * <p>
         * The list of any errors found in the behaviors.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ValidationError>.Builder} avoiding the need
         * to create one manually via {@link List<ValidationError>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ValidationError>.Builder#build()} is called immediately and
         * its result is passed to {@link #validationErrors(List<ValidationError>)}.
         * 
         * @param validationErrors
         *        a consumer that will call methods on {@link List<ValidationError>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #validationErrors(List<ValidationError>)
         */
        Builder validationErrors(Consumer<ValidationError.Builder>... validationErrors);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private Boolean valid;

        private List<ValidationError> validationErrors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ValidateSecurityProfileBehaviorsResponse model) {
            super(model);
            valid(model.valid);
            validationErrors(model.validationErrors);
        }

        public final Boolean getValid() {
            return valid;
        }

        @Override
        public final Builder valid(Boolean valid) {
            this.valid = valid;
            return this;
        }

        public final void setValid(Boolean valid) {
            this.valid = valid;
        }

        public final Collection<ValidationError.Builder> getValidationErrors() {
            return validationErrors != null ? validationErrors.stream().map(ValidationError::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder validationErrors(Collection<ValidationError> validationErrors) {
            this.validationErrors = ValidationErrorsCopier.copy(validationErrors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validationErrors(ValidationError... validationErrors) {
            validationErrors(Arrays.asList(validationErrors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validationErrors(Consumer<ValidationError.Builder>... validationErrors) {
            validationErrors(Stream.of(validationErrors).map(c -> ValidationError.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setValidationErrors(Collection<ValidationError.BuilderImpl> validationErrors) {
            this.validationErrors = ValidationErrorsCopier.copyFromBuilder(validationErrors);
        }

        @Override
        public ValidateSecurityProfileBehaviorsResponse build() {
            return new ValidateSecurityProfileBehaviorsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
