/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The job execution summary for a thing.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobExecutionSummaryForThing implements SdkPojo, Serializable,
        ToCopyableBuilder<JobExecutionSummaryForThing.Builder, JobExecutionSummaryForThing> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(JobExecutionSummaryForThing::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()).build();

    private static final SdkField<JobExecutionSummary> JOB_EXECUTION_SUMMARY_FIELD = SdkField
            .<JobExecutionSummary> builder(MarshallingType.SDK_POJO)
            .getter(getter(JobExecutionSummaryForThing::jobExecutionSummary)).setter(setter(Builder::jobExecutionSummary))
            .constructor(JobExecutionSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobExecutionSummary").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD,
            JOB_EXECUTION_SUMMARY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String jobId;

    private final JobExecutionSummary jobExecutionSummary;

    private JobExecutionSummaryForThing(BuilderImpl builder) {
        this.jobId = builder.jobId;
        this.jobExecutionSummary = builder.jobExecutionSummary;
    }

    /**
     * <p>
     * The unique identifier you assigned to this job when it was created.
     * </p>
     * 
     * @return The unique identifier you assigned to this job when it was created.
     */
    public String jobId() {
        return jobId;
    }

    /**
     * <p>
     * Contains a subset of information about a job execution.
     * </p>
     * 
     * @return Contains a subset of information about a job execution.
     */
    public JobExecutionSummary jobExecutionSummary() {
        return jobExecutionSummary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(jobExecutionSummary());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobExecutionSummaryForThing)) {
            return false;
        }
        JobExecutionSummaryForThing other = (JobExecutionSummaryForThing) obj;
        return Objects.equals(jobId(), other.jobId()) && Objects.equals(jobExecutionSummary(), other.jobExecutionSummary());
    }

    @Override
    public String toString() {
        return ToString.builder("JobExecutionSummaryForThing").add("JobId", jobId())
                .add("JobExecutionSummary", jobExecutionSummary()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "jobExecutionSummary":
            return Optional.ofNullable(clazz.cast(jobExecutionSummary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobExecutionSummaryForThing, T> g) {
        return obj -> g.apply((JobExecutionSummaryForThing) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JobExecutionSummaryForThing> {
        /**
         * <p>
         * The unique identifier you assigned to this job when it was created.
         * </p>
         * 
         * @param jobId
         *        The unique identifier you assigned to this job when it was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * Contains a subset of information about a job execution.
         * </p>
         * 
         * @param jobExecutionSummary
         *        Contains a subset of information about a job execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobExecutionSummary(JobExecutionSummary jobExecutionSummary);

        /**
         * <p>
         * Contains a subset of information about a job execution.
         * </p>
         * This is a convenience that creates an instance of the {@link JobExecutionSummary.Builder} avoiding the need
         * to create one manually via {@link JobExecutionSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link JobExecutionSummary.Builder#build()} is called immediately and
         * its result is passed to {@link #jobExecutionSummary(JobExecutionSummary)}.
         * 
         * @param jobExecutionSummary
         *        a consumer that will call methods on {@link JobExecutionSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobExecutionSummary(JobExecutionSummary)
         */
        default Builder jobExecutionSummary(Consumer<JobExecutionSummary.Builder> jobExecutionSummary) {
            return jobExecutionSummary(JobExecutionSummary.builder().applyMutation(jobExecutionSummary).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String jobId;

        private JobExecutionSummary jobExecutionSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(JobExecutionSummaryForThing model) {
            jobId(model.jobId);
            jobExecutionSummary(model.jobExecutionSummary);
        }

        public final String getJobId() {
            return jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public final JobExecutionSummary.Builder getJobExecutionSummary() {
            return jobExecutionSummary != null ? jobExecutionSummary.toBuilder() : null;
        }

        @Override
        public final Builder jobExecutionSummary(JobExecutionSummary jobExecutionSummary) {
            this.jobExecutionSummary = jobExecutionSummary;
            return this;
        }

        public final void setJobExecutionSummary(JobExecutionSummary.BuilderImpl jobExecutionSummary) {
            this.jobExecutionSummary = jobExecutionSummary != null ? jobExecutionSummary.build() : null;
        }

        @Override
        public JobExecutionSummaryForThing build() {
            return new JobExecutionSummaryForThing(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
