/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class TestInvokeAuthorizerResponse extends IotResponse implements
        ToCopyableBuilder<TestInvokeAuthorizerResponse.Builder, TestInvokeAuthorizerResponse> {
    private static final SdkField<Boolean> IS_AUTHENTICATED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(TestInvokeAuthorizerResponse::isAuthenticated)).setter(setter(Builder::isAuthenticated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isAuthenticated").build()).build();

    private static final SdkField<String> PRINCIPAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TestInvokeAuthorizerResponse::principalId)).setter(setter(Builder::principalId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principalId").build()).build();

    private static final SdkField<List<String>> POLICY_DOCUMENTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(TestInvokeAuthorizerResponse::policyDocuments))
            .setter(setter(Builder::policyDocuments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyDocuments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> REFRESH_AFTER_IN_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(TestInvokeAuthorizerResponse::refreshAfterInSeconds)).setter(setter(Builder::refreshAfterInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("refreshAfterInSeconds").build())
            .build();

    private static final SdkField<Integer> DISCONNECT_AFTER_IN_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).getter(getter(TestInvokeAuthorizerResponse::disconnectAfterInSeconds))
            .setter(setter(Builder::disconnectAfterInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("disconnectAfterInSeconds").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IS_AUTHENTICATED_FIELD,
            PRINCIPAL_ID_FIELD, POLICY_DOCUMENTS_FIELD, REFRESH_AFTER_IN_SECONDS_FIELD, DISCONNECT_AFTER_IN_SECONDS_FIELD));

    private final Boolean isAuthenticated;

    private final String principalId;

    private final List<String> policyDocuments;

    private final Integer refreshAfterInSeconds;

    private final Integer disconnectAfterInSeconds;

    private TestInvokeAuthorizerResponse(BuilderImpl builder) {
        super(builder);
        this.isAuthenticated = builder.isAuthenticated;
        this.principalId = builder.principalId;
        this.policyDocuments = builder.policyDocuments;
        this.refreshAfterInSeconds = builder.refreshAfterInSeconds;
        this.disconnectAfterInSeconds = builder.disconnectAfterInSeconds;
    }

    /**
     * <p>
     * True if the token is authenticated, otherwise false.
     * </p>
     * 
     * @return True if the token is authenticated, otherwise false.
     */
    public Boolean isAuthenticated() {
        return isAuthenticated;
    }

    /**
     * <p>
     * The principal ID.
     * </p>
     * 
     * @return The principal ID.
     */
    public String principalId() {
        return principalId;
    }

    /**
     * <p>
     * IAM policy documents.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return IAM policy documents.
     */
    public List<String> policyDocuments() {
        return policyDocuments;
    }

    /**
     * <p>
     * The number of seconds after which the temporary credentials are refreshed.
     * </p>
     * 
     * @return The number of seconds after which the temporary credentials are refreshed.
     */
    public Integer refreshAfterInSeconds() {
        return refreshAfterInSeconds;
    }

    /**
     * <p>
     * The number of seconds after which the connection is terminated.
     * </p>
     * 
     * @return The number of seconds after which the connection is terminated.
     */
    public Integer disconnectAfterInSeconds() {
        return disconnectAfterInSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(isAuthenticated());
        hashCode = 31 * hashCode + Objects.hashCode(principalId());
        hashCode = 31 * hashCode + Objects.hashCode(policyDocuments());
        hashCode = 31 * hashCode + Objects.hashCode(refreshAfterInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(disconnectAfterInSeconds());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestInvokeAuthorizerResponse)) {
            return false;
        }
        TestInvokeAuthorizerResponse other = (TestInvokeAuthorizerResponse) obj;
        return Objects.equals(isAuthenticated(), other.isAuthenticated()) && Objects.equals(principalId(), other.principalId())
                && Objects.equals(policyDocuments(), other.policyDocuments())
                && Objects.equals(refreshAfterInSeconds(), other.refreshAfterInSeconds())
                && Objects.equals(disconnectAfterInSeconds(), other.disconnectAfterInSeconds());
    }

    @Override
    public String toString() {
        return ToString.builder("TestInvokeAuthorizerResponse").add("IsAuthenticated", isAuthenticated())
                .add("PrincipalId", principalId()).add("PolicyDocuments", policyDocuments())
                .add("RefreshAfterInSeconds", refreshAfterInSeconds())
                .add("DisconnectAfterInSeconds", disconnectAfterInSeconds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "isAuthenticated":
            return Optional.ofNullable(clazz.cast(isAuthenticated()));
        case "principalId":
            return Optional.ofNullable(clazz.cast(principalId()));
        case "policyDocuments":
            return Optional.ofNullable(clazz.cast(policyDocuments()));
        case "refreshAfterInSeconds":
            return Optional.ofNullable(clazz.cast(refreshAfterInSeconds()));
        case "disconnectAfterInSeconds":
            return Optional.ofNullable(clazz.cast(disconnectAfterInSeconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TestInvokeAuthorizerResponse, T> g) {
        return obj -> g.apply((TestInvokeAuthorizerResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotResponse.Builder, SdkPojo, CopyableBuilder<Builder, TestInvokeAuthorizerResponse> {
        /**
         * <p>
         * True if the token is authenticated, otherwise false.
         * </p>
         * 
         * @param isAuthenticated
         *        True if the token is authenticated, otherwise false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isAuthenticated(Boolean isAuthenticated);

        /**
         * <p>
         * The principal ID.
         * </p>
         * 
         * @param principalId
         *        The principal ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principalId(String principalId);

        /**
         * <p>
         * IAM policy documents.
         * </p>
         * 
         * @param policyDocuments
         *        IAM policy documents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyDocuments(Collection<String> policyDocuments);

        /**
         * <p>
         * IAM policy documents.
         * </p>
         * 
         * @param policyDocuments
         *        IAM policy documents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyDocuments(String... policyDocuments);

        /**
         * <p>
         * The number of seconds after which the temporary credentials are refreshed.
         * </p>
         * 
         * @param refreshAfterInSeconds
         *        The number of seconds after which the temporary credentials are refreshed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder refreshAfterInSeconds(Integer refreshAfterInSeconds);

        /**
         * <p>
         * The number of seconds after which the connection is terminated.
         * </p>
         * 
         * @param disconnectAfterInSeconds
         *        The number of seconds after which the connection is terminated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disconnectAfterInSeconds(Integer disconnectAfterInSeconds);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private Boolean isAuthenticated;

        private String principalId;

        private List<String> policyDocuments = DefaultSdkAutoConstructList.getInstance();

        private Integer refreshAfterInSeconds;

        private Integer disconnectAfterInSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(TestInvokeAuthorizerResponse model) {
            super(model);
            isAuthenticated(model.isAuthenticated);
            principalId(model.principalId);
            policyDocuments(model.policyDocuments);
            refreshAfterInSeconds(model.refreshAfterInSeconds);
            disconnectAfterInSeconds(model.disconnectAfterInSeconds);
        }

        public final Boolean getIsAuthenticated() {
            return isAuthenticated;
        }

        @Override
        public final Builder isAuthenticated(Boolean isAuthenticated) {
            this.isAuthenticated = isAuthenticated;
            return this;
        }

        public final void setIsAuthenticated(Boolean isAuthenticated) {
            this.isAuthenticated = isAuthenticated;
        }

        public final String getPrincipalId() {
            return principalId;
        }

        @Override
        public final Builder principalId(String principalId) {
            this.principalId = principalId;
            return this;
        }

        public final void setPrincipalId(String principalId) {
            this.principalId = principalId;
        }

        public final Collection<String> getPolicyDocuments() {
            return policyDocuments;
        }

        @Override
        public final Builder policyDocuments(Collection<String> policyDocuments) {
            this.policyDocuments = PolicyDocumentsCopier.copy(policyDocuments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyDocuments(String... policyDocuments) {
            policyDocuments(Arrays.asList(policyDocuments));
            return this;
        }

        public final void setPolicyDocuments(Collection<String> policyDocuments) {
            this.policyDocuments = PolicyDocumentsCopier.copy(policyDocuments);
        }

        public final Integer getRefreshAfterInSeconds() {
            return refreshAfterInSeconds;
        }

        @Override
        public final Builder refreshAfterInSeconds(Integer refreshAfterInSeconds) {
            this.refreshAfterInSeconds = refreshAfterInSeconds;
            return this;
        }

        public final void setRefreshAfterInSeconds(Integer refreshAfterInSeconds) {
            this.refreshAfterInSeconds = refreshAfterInSeconds;
        }

        public final Integer getDisconnectAfterInSeconds() {
            return disconnectAfterInSeconds;
        }

        @Override
        public final Builder disconnectAfterInSeconds(Integer disconnectAfterInSeconds) {
            this.disconnectAfterInSeconds = disconnectAfterInSeconds;
            return this;
        }

        public final void setDisconnectAfterInSeconds(Integer disconnectAfterInSeconds) {
            this.disconnectAfterInSeconds = disconnectAfterInSeconds;
        }

        @Override
        public TestInvokeAuthorizerResponse build() {
            return new TestInvokeAuthorizerResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
