/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeJobExecutionRequest extends IotRequest implements
        ToCopyableBuilder<DescribeJobExecutionRequest.Builder, DescribeJobExecutionRequest> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeJobExecutionRequest::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("jobId").build()).build();

    private static final SdkField<String> THING_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeJobExecutionRequest::thingName)).setter(setter(Builder::thingName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("thingName").build()).build();

    private static final SdkField<Long> EXECUTION_NUMBER_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(DescribeJobExecutionRequest::executionNumber)).setter(setter(Builder::executionNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("executionNumber").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD,
            THING_NAME_FIELD, EXECUTION_NUMBER_FIELD));

    private final String jobId;

    private final String thingName;

    private final Long executionNumber;

    private DescribeJobExecutionRequest(BuilderImpl builder) {
        super(builder);
        this.jobId = builder.jobId;
        this.thingName = builder.thingName;
        this.executionNumber = builder.executionNumber;
    }

    /**
     * <p>
     * The unique identifier you assigned to this job when it was created.
     * </p>
     * 
     * @return The unique identifier you assigned to this job when it was created.
     */
    public String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The name of the thing on which the job execution is running.
     * </p>
     * 
     * @return The name of the thing on which the job execution is running.
     */
    public String thingName() {
        return thingName;
    }

    /**
     * <p>
     * A string (consisting of the digits "0" through "9" which is used to specify a particular job execution on a
     * particular device.
     * </p>
     * 
     * @return A string (consisting of the digits "0" through "9" which is used to specify a particular job execution on
     *         a particular device.
     */
    public Long executionNumber() {
        return executionNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(thingName());
        hashCode = 31 * hashCode + Objects.hashCode(executionNumber());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeJobExecutionRequest)) {
            return false;
        }
        DescribeJobExecutionRequest other = (DescribeJobExecutionRequest) obj;
        return Objects.equals(jobId(), other.jobId()) && Objects.equals(thingName(), other.thingName())
                && Objects.equals(executionNumber(), other.executionNumber());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeJobExecutionRequest").add("JobId", jobId()).add("ThingName", thingName())
                .add("ExecutionNumber", executionNumber()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "thingName":
            return Optional.ofNullable(clazz.cast(thingName()));
        case "executionNumber":
            return Optional.ofNullable(clazz.cast(executionNumber()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeJobExecutionRequest, T> g) {
        return obj -> g.apply((DescribeJobExecutionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeJobExecutionRequest> {
        /**
         * <p>
         * The unique identifier you assigned to this job when it was created.
         * </p>
         * 
         * @param jobId
         *        The unique identifier you assigned to this job when it was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The name of the thing on which the job execution is running.
         * </p>
         * 
         * @param thingName
         *        The name of the thing on which the job execution is running.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingName(String thingName);

        /**
         * <p>
         * A string (consisting of the digits "0" through "9" which is used to specify a particular job execution on a
         * particular device.
         * </p>
         * 
         * @param executionNumber
         *        A string (consisting of the digits "0" through "9" which is used to specify a particular job execution
         *        on a particular device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionNumber(Long executionNumber);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String jobId;

        private String thingName;

        private Long executionNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeJobExecutionRequest model) {
            super(model);
            jobId(model.jobId);
            thingName(model.thingName);
            executionNumber(model.executionNumber);
        }

        public final String getJobId() {
            return jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public final String getThingName() {
            return thingName;
        }

        @Override
        public final Builder thingName(String thingName) {
            this.thingName = thingName;
            return this;
        }

        public final void setThingName(String thingName) {
            this.thingName = thingName;
        }

        public final Long getExecutionNumber() {
            return executionNumber;
        }

        @Override
        public final Builder executionNumber(Long executionNumber) {
            this.executionNumber = executionNumber;
            return this;
        }

        public final void setExecutionNumber(Long executionNumber) {
            this.executionNumber = executionNumber;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeJobExecutionRequest build() {
            return new DescribeJobExecutionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
