/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateBillingGroupRequest extends IotRequest implements
        ToCopyableBuilder<UpdateBillingGroupRequest.Builder, UpdateBillingGroupRequest> {
    private static final SdkField<String> BILLING_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateBillingGroupRequest::billingGroupName)).setter(setter(Builder::billingGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("billingGroupName").build()).build();

    private static final SdkField<BillingGroupProperties> BILLING_GROUP_PROPERTIES_FIELD = SdkField
            .<BillingGroupProperties> builder(MarshallingType.SDK_POJO)
            .getter(getter(UpdateBillingGroupRequest::billingGroupProperties)).setter(setter(Builder::billingGroupProperties))
            .constructor(BillingGroupProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("billingGroupProperties").build())
            .build();

    private static final SdkField<Long> EXPECTED_VERSION_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(UpdateBillingGroupRequest::expectedVersion)).setter(setter(Builder::expectedVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expectedVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BILLING_GROUP_NAME_FIELD,
            BILLING_GROUP_PROPERTIES_FIELD, EXPECTED_VERSION_FIELD));

    private final String billingGroupName;

    private final BillingGroupProperties billingGroupProperties;

    private final Long expectedVersion;

    private UpdateBillingGroupRequest(BuilderImpl builder) {
        super(builder);
        this.billingGroupName = builder.billingGroupName;
        this.billingGroupProperties = builder.billingGroupProperties;
        this.expectedVersion = builder.expectedVersion;
    }

    /**
     * <p>
     * The name of the billing group.
     * </p>
     * 
     * @return The name of the billing group.
     */
    public String billingGroupName() {
        return billingGroupName;
    }

    /**
     * <p>
     * The properties of the billing group.
     * </p>
     * 
     * @return The properties of the billing group.
     */
    public BillingGroupProperties billingGroupProperties() {
        return billingGroupProperties;
    }

    /**
     * <p>
     * The expected version of the billing group. If the version of the billing group does not match the expected
     * version specified in the request, the <code>UpdateBillingGroup</code> request is rejected with a
     * <code>VersionConflictException</code>.
     * </p>
     * 
     * @return The expected version of the billing group. If the version of the billing group does not match the
     *         expected version specified in the request, the <code>UpdateBillingGroup</code> request is rejected with a
     *         <code>VersionConflictException</code>.
     */
    public Long expectedVersion() {
        return expectedVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(billingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(billingGroupProperties());
        hashCode = 31 * hashCode + Objects.hashCode(expectedVersion());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBillingGroupRequest)) {
            return false;
        }
        UpdateBillingGroupRequest other = (UpdateBillingGroupRequest) obj;
        return Objects.equals(billingGroupName(), other.billingGroupName())
                && Objects.equals(billingGroupProperties(), other.billingGroupProperties())
                && Objects.equals(expectedVersion(), other.expectedVersion());
    }

    @Override
    public String toString() {
        return ToString.builder("UpdateBillingGroupRequest").add("BillingGroupName", billingGroupName())
                .add("BillingGroupProperties", billingGroupProperties()).add("ExpectedVersion", expectedVersion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "billingGroupName":
            return Optional.ofNullable(clazz.cast(billingGroupName()));
        case "billingGroupProperties":
            return Optional.ofNullable(clazz.cast(billingGroupProperties()));
        case "expectedVersion":
            return Optional.ofNullable(clazz.cast(expectedVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateBillingGroupRequest, T> g) {
        return obj -> g.apply((UpdateBillingGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateBillingGroupRequest> {
        /**
         * <p>
         * The name of the billing group.
         * </p>
         * 
         * @param billingGroupName
         *        The name of the billing group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billingGroupName(String billingGroupName);

        /**
         * <p>
         * The properties of the billing group.
         * </p>
         * 
         * @param billingGroupProperties
         *        The properties of the billing group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billingGroupProperties(BillingGroupProperties billingGroupProperties);

        /**
         * <p>
         * The properties of the billing group.
         * </p>
         * This is a convenience that creates an instance of the {@link BillingGroupProperties.Builder} avoiding the
         * need to create one manually via {@link BillingGroupProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link BillingGroupProperties.Builder#build()} is called immediately and
         * its result is passed to {@link #billingGroupProperties(BillingGroupProperties)}.
         * 
         * @param billingGroupProperties
         *        a consumer that will call methods on {@link BillingGroupProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #billingGroupProperties(BillingGroupProperties)
         */
        default Builder billingGroupProperties(Consumer<BillingGroupProperties.Builder> billingGroupProperties) {
            return billingGroupProperties(BillingGroupProperties.builder().applyMutation(billingGroupProperties).build());
        }

        /**
         * <p>
         * The expected version of the billing group. If the version of the billing group does not match the expected
         * version specified in the request, the <code>UpdateBillingGroup</code> request is rejected with a
         * <code>VersionConflictException</code>.
         * </p>
         * 
         * @param expectedVersion
         *        The expected version of the billing group. If the version of the billing group does not match the
         *        expected version specified in the request, the <code>UpdateBillingGroup</code> request is rejected
         *        with a <code>VersionConflictException</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expectedVersion(Long expectedVersion);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String billingGroupName;

        private BillingGroupProperties billingGroupProperties;

        private Long expectedVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBillingGroupRequest model) {
            super(model);
            billingGroupName(model.billingGroupName);
            billingGroupProperties(model.billingGroupProperties);
            expectedVersion(model.expectedVersion);
        }

        public final String getBillingGroupName() {
            return billingGroupName;
        }

        @Override
        public final Builder billingGroupName(String billingGroupName) {
            this.billingGroupName = billingGroupName;
            return this;
        }

        public final void setBillingGroupName(String billingGroupName) {
            this.billingGroupName = billingGroupName;
        }

        public final BillingGroupProperties.Builder getBillingGroupProperties() {
            return billingGroupProperties != null ? billingGroupProperties.toBuilder() : null;
        }

        @Override
        public final Builder billingGroupProperties(BillingGroupProperties billingGroupProperties) {
            this.billingGroupProperties = billingGroupProperties;
            return this;
        }

        public final void setBillingGroupProperties(BillingGroupProperties.BuilderImpl billingGroupProperties) {
            this.billingGroupProperties = billingGroupProperties != null ? billingGroupProperties.build() : null;
        }

        public final Long getExpectedVersion() {
            return expectedVersion;
        }

        @Override
        public final Builder expectedVersion(Long expectedVersion) {
            this.expectedVersion = expectedVersion;
            return this;
        }

        public final void setExpectedVersion(Long expectedVersion) {
            this.expectedVersion = expectedVersion;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateBillingGroupRequest build() {
            return new UpdateBillingGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
