/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an action that captures a CloudWatch metric.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CloudwatchMetricAction implements SdkPojo, Serializable,
        ToCopyableBuilder<CloudwatchMetricAction.Builder, CloudwatchMetricAction> {
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CloudwatchMetricAction::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<String> METRIC_NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CloudwatchMetricAction::metricNamespace)).setter(setter(Builder::metricNamespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricNamespace").build()).build();

    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CloudwatchMetricAction::metricName)).setter(setter(Builder::metricName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricName").build()).build();

    private static final SdkField<String> METRIC_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CloudwatchMetricAction::metricValue)).setter(setter(Builder::metricValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricValue").build()).build();

    private static final SdkField<String> METRIC_UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CloudwatchMetricAction::metricUnit)).setter(setter(Builder::metricUnit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricUnit").build()).build();

    private static final SdkField<String> METRIC_TIMESTAMP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CloudwatchMetricAction::metricTimestamp)).setter(setter(Builder::metricTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricTimestamp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ARN_FIELD,
            METRIC_NAMESPACE_FIELD, METRIC_NAME_FIELD, METRIC_VALUE_FIELD, METRIC_UNIT_FIELD, METRIC_TIMESTAMP_FIELD));

    private static final long serialVersionUID = 1L;

    private final String roleArn;

    private final String metricNamespace;

    private final String metricName;

    private final String metricValue;

    private final String metricUnit;

    private final String metricTimestamp;

    private CloudwatchMetricAction(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.metricNamespace = builder.metricNamespace;
        this.metricName = builder.metricName;
        this.metricValue = builder.metricValue;
        this.metricUnit = builder.metricUnit;
        this.metricTimestamp = builder.metricTimestamp;
    }

    /**
     * <p>
     * The IAM role that allows access to the CloudWatch metric.
     * </p>
     * 
     * @return The IAM role that allows access to the CloudWatch metric.
     */
    public String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The CloudWatch metric namespace name.
     * </p>
     * 
     * @return The CloudWatch metric namespace name.
     */
    public String metricNamespace() {
        return metricNamespace;
    }

    /**
     * <p>
     * The CloudWatch metric name.
     * </p>
     * 
     * @return The CloudWatch metric name.
     */
    public String metricName() {
        return metricName;
    }

    /**
     * <p>
     * The CloudWatch metric value.
     * </p>
     * 
     * @return The CloudWatch metric value.
     */
    public String metricValue() {
        return metricValue;
    }

    /**
     * <p>
     * The <a
     * href="http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/cloudwatch_concepts.html#Unit">metric
     * unit</a> supported by CloudWatch.
     * </p>
     * 
     * @return The <a
     *         href="http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/cloudwatch_concepts.html#Unit"
     *         >metric unit</a> supported by CloudWatch.
     */
    public String metricUnit() {
        return metricUnit;
    }

    /**
     * <p>
     * An optional <a href=
     * "http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/cloudwatch_concepts.html#about_timestamp">Unix
     * timestamp</a>.
     * </p>
     * 
     * @return An optional <a href=
     *         "http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/cloudwatch_concepts.html#about_timestamp"
     *         >Unix timestamp</a>.
     */
    public String metricTimestamp() {
        return metricTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(metricNamespace());
        hashCode = 31 * hashCode + Objects.hashCode(metricName());
        hashCode = 31 * hashCode + Objects.hashCode(metricValue());
        hashCode = 31 * hashCode + Objects.hashCode(metricUnit());
        hashCode = 31 * hashCode + Objects.hashCode(metricTimestamp());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudwatchMetricAction)) {
            return false;
        }
        CloudwatchMetricAction other = (CloudwatchMetricAction) obj;
        return Objects.equals(roleArn(), other.roleArn()) && Objects.equals(metricNamespace(), other.metricNamespace())
                && Objects.equals(metricName(), other.metricName()) && Objects.equals(metricValue(), other.metricValue())
                && Objects.equals(metricUnit(), other.metricUnit()) && Objects.equals(metricTimestamp(), other.metricTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CloudwatchMetricAction").add("RoleArn", roleArn()).add("MetricNamespace", metricNamespace())
                .add("MetricName", metricName()).add("MetricValue", metricValue()).add("MetricUnit", metricUnit())
                .add("MetricTimestamp", metricTimestamp()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "metricNamespace":
            return Optional.ofNullable(clazz.cast(metricNamespace()));
        case "metricName":
            return Optional.ofNullable(clazz.cast(metricName()));
        case "metricValue":
            return Optional.ofNullable(clazz.cast(metricValue()));
        case "metricUnit":
            return Optional.ofNullable(clazz.cast(metricUnit()));
        case "metricTimestamp":
            return Optional.ofNullable(clazz.cast(metricTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CloudwatchMetricAction, T> g) {
        return obj -> g.apply((CloudwatchMetricAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CloudwatchMetricAction> {
        /**
         * <p>
         * The IAM role that allows access to the CloudWatch metric.
         * </p>
         * 
         * @param roleArn
         *        The IAM role that allows access to the CloudWatch metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The CloudWatch metric namespace name.
         * </p>
         * 
         * @param metricNamespace
         *        The CloudWatch metric namespace name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricNamespace(String metricNamespace);

        /**
         * <p>
         * The CloudWatch metric name.
         * </p>
         * 
         * @param metricName
         *        The CloudWatch metric name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricName(String metricName);

        /**
         * <p>
         * The CloudWatch metric value.
         * </p>
         * 
         * @param metricValue
         *        The CloudWatch metric value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricValue(String metricValue);

        /**
         * <p>
         * The <a
         * href="http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/cloudwatch_concepts.html#Unit">metric
         * unit</a> supported by CloudWatch.
         * </p>
         * 
         * @param metricUnit
         *        The <a href=
         *        "http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/cloudwatch_concepts.html#Unit"
         *        >metric unit</a> supported by CloudWatch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricUnit(String metricUnit);

        /**
         * <p>
         * An optional <a href=
         * "http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/cloudwatch_concepts.html#about_timestamp"
         * >Unix timestamp</a>.
         * </p>
         * 
         * @param metricTimestamp
         *        An optional <a href=
         *        "http://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/cloudwatch_concepts.html#about_timestamp"
         *        >Unix timestamp</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricTimestamp(String metricTimestamp);
    }

    static final class BuilderImpl implements Builder {
        private String roleArn;

        private String metricNamespace;

        private String metricName;

        private String metricValue;

        private String metricUnit;

        private String metricTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudwatchMetricAction model) {
            roleArn(model.roleArn);
            metricNamespace(model.metricNamespace);
            metricName(model.metricName);
            metricValue(model.metricValue);
            metricUnit(model.metricUnit);
            metricTimestamp(model.metricTimestamp);
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getMetricNamespace() {
            return metricNamespace;
        }

        @Override
        public final Builder metricNamespace(String metricNamespace) {
            this.metricNamespace = metricNamespace;
            return this;
        }

        public final void setMetricNamespace(String metricNamespace) {
            this.metricNamespace = metricNamespace;
        }

        public final String getMetricName() {
            return metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        public final String getMetricValue() {
            return metricValue;
        }

        @Override
        public final Builder metricValue(String metricValue) {
            this.metricValue = metricValue;
            return this;
        }

        public final void setMetricValue(String metricValue) {
            this.metricValue = metricValue;
        }

        public final String getMetricUnit() {
            return metricUnit;
        }

        @Override
        public final Builder metricUnit(String metricUnit) {
            this.metricUnit = metricUnit;
            return this;
        }

        public final void setMetricUnit(String metricUnit) {
            this.metricUnit = metricUnit;
        }

        public final String getMetricTimestamp() {
            return metricTimestamp;
        }

        @Override
        public final Builder metricTimestamp(String metricTimestamp) {
            this.metricTimestamp = metricTimestamp;
            return this;
        }

        public final void setMetricTimestamp(String metricTimestamp) {
            this.metricTimestamp = metricTimestamp;
        }

        @Override
        public CloudwatchMetricAction build() {
            return new CloudwatchMetricAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
