/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAuthorizersRequest extends IotRequest implements
        ToCopyableBuilder<ListAuthorizersRequest.Builder, ListAuthorizersRequest> {
    private static final SdkField<Integer> PAGE_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("pageSize").getter(getter(ListAuthorizersRequest::pageSize)).setter(setter(Builder::pageSize))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("pageSize").build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("marker")
            .getter(getter(ListAuthorizersRequest::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("marker").build()).build();

    private static final SdkField<Boolean> ASCENDING_ORDER_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ascendingOrder").getter(getter(ListAuthorizersRequest::ascendingOrder))
            .setter(setter(Builder::ascendingOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("isAscendingOrder").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(ListAuthorizersRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PAGE_SIZE_FIELD, MARKER_FIELD,
            ASCENDING_ORDER_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Integer pageSize;

    private final String marker;

    private final Boolean ascendingOrder;

    private final String status;

    private ListAuthorizersRequest(BuilderImpl builder) {
        super(builder);
        this.pageSize = builder.pageSize;
        this.marker = builder.marker;
        this.ascendingOrder = builder.ascendingOrder;
        this.status = builder.status;
    }

    /**
     * <p>
     * The maximum number of results to return at one time.
     * </p>
     * 
     * @return The maximum number of results to return at one time.
     */
    public final Integer pageSize() {
        return pageSize;
    }

    /**
     * <p>
     * A marker used to get the next set of results.
     * </p>
     * 
     * @return A marker used to get the next set of results.
     */
    public final String marker() {
        return marker;
    }

    /**
     * <p>
     * Return the list of authorizers in ascending alphabetical order.
     * </p>
     * 
     * @return Return the list of authorizers in ascending alphabetical order.
     */
    public final Boolean ascendingOrder() {
        return ascendingOrder;
    }

    /**
     * <p>
     * The status of the list authorizers request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AuthorizerStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the list authorizers request.
     * @see AuthorizerStatus
     */
    public final AuthorizerStatus status() {
        return AuthorizerStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the list authorizers request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AuthorizerStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the list authorizers request.
     * @see AuthorizerStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(pageSize());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(ascendingOrder());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAuthorizersRequest)) {
            return false;
        }
        ListAuthorizersRequest other = (ListAuthorizersRequest) obj;
        return Objects.equals(pageSize(), other.pageSize()) && Objects.equals(marker(), other.marker())
                && Objects.equals(ascendingOrder(), other.ascendingOrder())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAuthorizersRequest").add("PageSize", pageSize()).add("Marker", marker())
                .add("AscendingOrder", ascendingOrder()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "pageSize":
            return Optional.ofNullable(clazz.cast(pageSize()));
        case "marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "ascendingOrder":
            return Optional.ofNullable(clazz.cast(ascendingOrder()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("pageSize", PAGE_SIZE_FIELD);
        map.put("marker", MARKER_FIELD);
        map.put("isAscendingOrder", ASCENDING_ORDER_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAuthorizersRequest, T> g) {
        return obj -> g.apply((ListAuthorizersRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListAuthorizersRequest> {
        /**
         * <p>
         * The maximum number of results to return at one time.
         * </p>
         * 
         * @param pageSize
         *        The maximum number of results to return at one time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pageSize(Integer pageSize);

        /**
         * <p>
         * A marker used to get the next set of results.
         * </p>
         * 
         * @param marker
         *        A marker used to get the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * Return the list of authorizers in ascending alphabetical order.
         * </p>
         * 
         * @param ascendingOrder
         *        Return the list of authorizers in ascending alphabetical order.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ascendingOrder(Boolean ascendingOrder);

        /**
         * <p>
         * The status of the list authorizers request.
         * </p>
         * 
         * @param status
         *        The status of the list authorizers request.
         * @see AuthorizerStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthorizerStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the list authorizers request.
         * </p>
         * 
         * @param status
         *        The status of the list authorizers request.
         * @see AuthorizerStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthorizerStatus
         */
        Builder status(AuthorizerStatus status);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private Integer pageSize;

        private String marker;

        private Boolean ascendingOrder;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAuthorizersRequest model) {
            super(model);
            pageSize(model.pageSize);
            marker(model.marker);
            ascendingOrder(model.ascendingOrder);
            status(model.status);
        }

        public final Integer getPageSize() {
            return pageSize;
        }

        public final void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        @Override
        public final Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final Boolean getAscendingOrder() {
            return ascendingOrder;
        }

        public final void setAscendingOrder(Boolean ascendingOrder) {
            this.ascendingOrder = ascendingOrder;
        }

        @Override
        public final Builder ascendingOrder(Boolean ascendingOrder) {
            this.ascendingOrder = ascendingOrder;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AuthorizerStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListAuthorizersRequest build() {
            return new ListAuthorizersRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
