/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output from the GetTopicRule operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTopicRuleResponse extends IotResponse implements
        ToCopyableBuilder<GetTopicRuleResponse.Builder, GetTopicRuleResponse> {
    private static final SdkField<String> RULE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ruleArn").getter(getter(GetTopicRuleResponse::ruleArn)).setter(setter(Builder::ruleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleArn").build()).build();

    private static final SdkField<TopicRule> RULE_FIELD = SdkField.<TopicRule> builder(MarshallingType.SDK_POJO)
            .memberName("rule").getter(getter(GetTopicRuleResponse::rule)).setter(setter(Builder::rule))
            .constructor(TopicRule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rule").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_ARN_FIELD, RULE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String ruleArn;

    private final TopicRule rule;

    private GetTopicRuleResponse(BuilderImpl builder) {
        super(builder);
        this.ruleArn = builder.ruleArn;
        this.rule = builder.rule;
    }

    /**
     * <p>
     * The rule ARN.
     * </p>
     * 
     * @return The rule ARN.
     */
    public final String ruleArn() {
        return ruleArn;
    }

    /**
     * <p>
     * The rule.
     * </p>
     * 
     * @return The rule.
     */
    public final TopicRule rule() {
        return rule;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ruleArn());
        hashCode = 31 * hashCode + Objects.hashCode(rule());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTopicRuleResponse)) {
            return false;
        }
        GetTopicRuleResponse other = (GetTopicRuleResponse) obj;
        return Objects.equals(ruleArn(), other.ruleArn()) && Objects.equals(rule(), other.rule());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetTopicRuleResponse").add("RuleArn", ruleArn()).add("Rule", rule()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ruleArn":
            return Optional.ofNullable(clazz.cast(ruleArn()));
        case "rule":
            return Optional.ofNullable(clazz.cast(rule()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ruleArn", RULE_ARN_FIELD);
        map.put("rule", RULE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetTopicRuleResponse, T> g) {
        return obj -> g.apply((GetTopicRuleResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetTopicRuleResponse> {
        /**
         * <p>
         * The rule ARN.
         * </p>
         * 
         * @param ruleArn
         *        The rule ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleArn(String ruleArn);

        /**
         * <p>
         * The rule.
         * </p>
         * 
         * @param rule
         *        The rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rule(TopicRule rule);

        /**
         * <p>
         * The rule.
         * </p>
         * This is a convenience method that creates an instance of the {@link TopicRule.Builder} avoiding the need to
         * create one manually via {@link TopicRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TopicRule.Builder#build()} is called immediately and its result
         * is passed to {@link #rule(TopicRule)}.
         * 
         * @param rule
         *        a consumer that will call methods on {@link TopicRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rule(TopicRule)
         */
        default Builder rule(Consumer<TopicRule.Builder> rule) {
            return rule(TopicRule.builder().applyMutation(rule).build());
        }
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private String ruleArn;

        private TopicRule rule;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTopicRuleResponse model) {
            super(model);
            ruleArn(model.ruleArn);
            rule(model.rule);
        }

        public final String getRuleArn() {
            return ruleArn;
        }

        public final void setRuleArn(String ruleArn) {
            this.ruleArn = ruleArn;
        }

        @Override
        public final Builder ruleArn(String ruleArn) {
            this.ruleArn = ruleArn;
            return this;
        }

        public final TopicRule.Builder getRule() {
            return rule != null ? rule.toBuilder() : null;
        }

        public final void setRule(TopicRule.BuilderImpl rule) {
            this.rule = rule != null ? rule.build() : null;
        }

        @Override
        public final Builder rule(TopicRule rule) {
            this.rule = rule;
            return this;
        }

        @Override
        public GetTopicRuleResponse build() {
            return new GetTopicRuleResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
