/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListThingPrincipalsV2Response extends IotResponse implements
        ToCopyableBuilder<ListThingPrincipalsV2Response.Builder, ListThingPrincipalsV2Response> {
    private static final SdkField<List<ThingPrincipalObject>> THING_PRINCIPAL_OBJECTS_FIELD = SdkField
            .<List<ThingPrincipalObject>> builder(MarshallingType.LIST)
            .memberName("thingPrincipalObjects")
            .getter(getter(ListThingPrincipalsV2Response::thingPrincipalObjects))
            .setter(setter(Builder::thingPrincipalObjects))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingPrincipalObjects").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ThingPrincipalObject> builder(MarshallingType.SDK_POJO)
                                            .constructor(ThingPrincipalObject::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListThingPrincipalsV2Response::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THING_PRINCIPAL_OBJECTS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ThingPrincipalObject> thingPrincipalObjects;

    private final String nextToken;

    private ListThingPrincipalsV2Response(BuilderImpl builder) {
        super(builder);
        this.thingPrincipalObjects = builder.thingPrincipalObjects;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ThingPrincipalObjects property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasThingPrincipalObjects() {
        return thingPrincipalObjects != null && !(thingPrincipalObjects instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>thingPrincipalObject</code> that represents the principal and the type of relation it has with
     * the thing.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasThingPrincipalObjects} method.
     * </p>
     * 
     * @return A list of <code>thingPrincipalObject</code> that represents the principal and the type of relation it has
     *         with the thing.
     */
    public final List<ThingPrincipalObject> thingPrincipalObjects() {
        return thingPrincipalObjects;
    }

    /**
     * <p>
     * The token to use to get the next set of results, or <b>null</b> if there are no additional results.
     * </p>
     * 
     * @return The token to use to get the next set of results, or <b>null</b> if there are no additional results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasThingPrincipalObjects() ? thingPrincipalObjects() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListThingPrincipalsV2Response)) {
            return false;
        }
        ListThingPrincipalsV2Response other = (ListThingPrincipalsV2Response) obj;
        return hasThingPrincipalObjects() == other.hasThingPrincipalObjects()
                && Objects.equals(thingPrincipalObjects(), other.thingPrincipalObjects())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListThingPrincipalsV2Response")
                .add("ThingPrincipalObjects", hasThingPrincipalObjects() ? thingPrincipalObjects() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "thingPrincipalObjects":
            return Optional.ofNullable(clazz.cast(thingPrincipalObjects()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("thingPrincipalObjects", THING_PRINCIPAL_OBJECTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListThingPrincipalsV2Response, T> g) {
        return obj -> g.apply((ListThingPrincipalsV2Response) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListThingPrincipalsV2Response> {
        /**
         * <p>
         * A list of <code>thingPrincipalObject</code> that represents the principal and the type of relation it has
         * with the thing.
         * </p>
         * 
         * @param thingPrincipalObjects
         *        A list of <code>thingPrincipalObject</code> that represents the principal and the type of relation it
         *        has with the thing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingPrincipalObjects(Collection<ThingPrincipalObject> thingPrincipalObjects);

        /**
         * <p>
         * A list of <code>thingPrincipalObject</code> that represents the principal and the type of relation it has
         * with the thing.
         * </p>
         * 
         * @param thingPrincipalObjects
         *        A list of <code>thingPrincipalObject</code> that represents the principal and the type of relation it
         *        has with the thing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingPrincipalObjects(ThingPrincipalObject... thingPrincipalObjects);

        /**
         * <p>
         * A list of <code>thingPrincipalObject</code> that represents the principal and the type of relation it has
         * with the thing.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iot.model.ThingPrincipalObject.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.iot.model.ThingPrincipalObject#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iot.model.ThingPrincipalObject.Builder#build()} is called immediately
         * and its result is passed to {@link #thingPrincipalObjects(List<ThingPrincipalObject>)}.
         * 
         * @param thingPrincipalObjects
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iot.model.ThingPrincipalObject.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #thingPrincipalObjects(java.util.Collection<ThingPrincipalObject>)
         */
        Builder thingPrincipalObjects(Consumer<ThingPrincipalObject.Builder>... thingPrincipalObjects);

        /**
         * <p>
         * The token to use to get the next set of results, or <b>null</b> if there are no additional results.
         * </p>
         * 
         * @param nextToken
         *        The token to use to get the next set of results, or <b>null</b> if there are no additional results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private List<ThingPrincipalObject> thingPrincipalObjects = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListThingPrincipalsV2Response model) {
            super(model);
            thingPrincipalObjects(model.thingPrincipalObjects);
            nextToken(model.nextToken);
        }

        public final List<ThingPrincipalObject.Builder> getThingPrincipalObjects() {
            List<ThingPrincipalObject.Builder> result = ThingPrincipalObjectsCopier.copyToBuilder(this.thingPrincipalObjects);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setThingPrincipalObjects(Collection<ThingPrincipalObject.BuilderImpl> thingPrincipalObjects) {
            this.thingPrincipalObjects = ThingPrincipalObjectsCopier.copyFromBuilder(thingPrincipalObjects);
        }

        @Override
        public final Builder thingPrincipalObjects(Collection<ThingPrincipalObject> thingPrincipalObjects) {
            this.thingPrincipalObjects = ThingPrincipalObjectsCopier.copy(thingPrincipalObjects);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder thingPrincipalObjects(ThingPrincipalObject... thingPrincipalObjects) {
            thingPrincipalObjects(Arrays.asList(thingPrincipalObjects));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder thingPrincipalObjects(Consumer<ThingPrincipalObject.Builder>... thingPrincipalObjects) {
            thingPrincipalObjects(Stream.of(thingPrincipalObjects)
                    .map(c -> ThingPrincipalObject.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListThingPrincipalsV2Response build() {
            return new ListThingPrincipalsV2Response(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
