/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateThingGroupsForThingRequest extends IotRequest implements
        ToCopyableBuilder<UpdateThingGroupsForThingRequest.Builder, UpdateThingGroupsForThingRequest> {
    private static final SdkField<String> THING_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("thingName").getter(getter(UpdateThingGroupsForThingRequest::thingName))
            .setter(setter(Builder::thingName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingName").build()).build();

    private static final SdkField<List<String>> THING_GROUPS_TO_ADD_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("thingGroupsToAdd")
            .getter(getter(UpdateThingGroupsForThingRequest::thingGroupsToAdd))
            .setter(setter(Builder::thingGroupsToAdd))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingGroupsToAdd").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> THING_GROUPS_TO_REMOVE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("thingGroupsToRemove")
            .getter(getter(UpdateThingGroupsForThingRequest::thingGroupsToRemove))
            .setter(setter(Builder::thingGroupsToRemove))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thingGroupsToRemove").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> OVERRIDE_DYNAMIC_GROUPS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("overrideDynamicGroups").getter(getter(UpdateThingGroupsForThingRequest::overrideDynamicGroups))
            .setter(setter(Builder::overrideDynamicGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overrideDynamicGroups").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THING_NAME_FIELD,
            THING_GROUPS_TO_ADD_FIELD, THING_GROUPS_TO_REMOVE_FIELD, OVERRIDE_DYNAMIC_GROUPS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String thingName;

    private final List<String> thingGroupsToAdd;

    private final List<String> thingGroupsToRemove;

    private final Boolean overrideDynamicGroups;

    private UpdateThingGroupsForThingRequest(BuilderImpl builder) {
        super(builder);
        this.thingName = builder.thingName;
        this.thingGroupsToAdd = builder.thingGroupsToAdd;
        this.thingGroupsToRemove = builder.thingGroupsToRemove;
        this.overrideDynamicGroups = builder.overrideDynamicGroups;
    }

    /**
     * <p>
     * The thing whose group memberships will be updated.
     * </p>
     * 
     * @return The thing whose group memberships will be updated.
     */
    public final String thingName() {
        return thingName;
    }

    /**
     * For responses, this returns true if the service returned a value for the ThingGroupsToAdd property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasThingGroupsToAdd() {
        return thingGroupsToAdd != null && !(thingGroupsToAdd instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The groups to which the thing will be added.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasThingGroupsToAdd} method.
     * </p>
     * 
     * @return The groups to which the thing will be added.
     */
    public final List<String> thingGroupsToAdd() {
        return thingGroupsToAdd;
    }

    /**
     * For responses, this returns true if the service returned a value for the ThingGroupsToRemove property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasThingGroupsToRemove() {
        return thingGroupsToRemove != null && !(thingGroupsToRemove instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The groups from which the thing will be removed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasThingGroupsToRemove} method.
     * </p>
     * 
     * @return The groups from which the thing will be removed.
     */
    public final List<String> thingGroupsToRemove() {
        return thingGroupsToRemove;
    }

    /**
     * <p>
     * Override dynamic thing groups with static thing groups when 10-group limit is reached. If a thing belongs to 10
     * thing groups, and one or more of those groups are dynamic thing groups, adding a thing to a static group removes
     * the thing from the last dynamic group.
     * </p>
     * 
     * @return Override dynamic thing groups with static thing groups when 10-group limit is reached. If a thing belongs
     *         to 10 thing groups, and one or more of those groups are dynamic thing groups, adding a thing to a static
     *         group removes the thing from the last dynamic group.
     */
    public final Boolean overrideDynamicGroups() {
        return overrideDynamicGroups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(thingName());
        hashCode = 31 * hashCode + Objects.hashCode(hasThingGroupsToAdd() ? thingGroupsToAdd() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasThingGroupsToRemove() ? thingGroupsToRemove() : null);
        hashCode = 31 * hashCode + Objects.hashCode(overrideDynamicGroups());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateThingGroupsForThingRequest)) {
            return false;
        }
        UpdateThingGroupsForThingRequest other = (UpdateThingGroupsForThingRequest) obj;
        return Objects.equals(thingName(), other.thingName()) && hasThingGroupsToAdd() == other.hasThingGroupsToAdd()
                && Objects.equals(thingGroupsToAdd(), other.thingGroupsToAdd())
                && hasThingGroupsToRemove() == other.hasThingGroupsToRemove()
                && Objects.equals(thingGroupsToRemove(), other.thingGroupsToRemove())
                && Objects.equals(overrideDynamicGroups(), other.overrideDynamicGroups());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateThingGroupsForThingRequest").add("ThingName", thingName())
                .add("ThingGroupsToAdd", hasThingGroupsToAdd() ? thingGroupsToAdd() : null)
                .add("ThingGroupsToRemove", hasThingGroupsToRemove() ? thingGroupsToRemove() : null)
                .add("OverrideDynamicGroups", overrideDynamicGroups()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "thingName":
            return Optional.ofNullable(clazz.cast(thingName()));
        case "thingGroupsToAdd":
            return Optional.ofNullable(clazz.cast(thingGroupsToAdd()));
        case "thingGroupsToRemove":
            return Optional.ofNullable(clazz.cast(thingGroupsToRemove()));
        case "overrideDynamicGroups":
            return Optional.ofNullable(clazz.cast(overrideDynamicGroups()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("thingName", THING_NAME_FIELD);
        map.put("thingGroupsToAdd", THING_GROUPS_TO_ADD_FIELD);
        map.put("thingGroupsToRemove", THING_GROUPS_TO_REMOVE_FIELD);
        map.put("overrideDynamicGroups", OVERRIDE_DYNAMIC_GROUPS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateThingGroupsForThingRequest, T> g) {
        return obj -> g.apply((UpdateThingGroupsForThingRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateThingGroupsForThingRequest> {
        /**
         * <p>
         * The thing whose group memberships will be updated.
         * </p>
         * 
         * @param thingName
         *        The thing whose group memberships will be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingName(String thingName);

        /**
         * <p>
         * The groups to which the thing will be added.
         * </p>
         * 
         * @param thingGroupsToAdd
         *        The groups to which the thing will be added.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingGroupsToAdd(Collection<String> thingGroupsToAdd);

        /**
         * <p>
         * The groups to which the thing will be added.
         * </p>
         * 
         * @param thingGroupsToAdd
         *        The groups to which the thing will be added.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingGroupsToAdd(String... thingGroupsToAdd);

        /**
         * <p>
         * The groups from which the thing will be removed.
         * </p>
         * 
         * @param thingGroupsToRemove
         *        The groups from which the thing will be removed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingGroupsToRemove(Collection<String> thingGroupsToRemove);

        /**
         * <p>
         * The groups from which the thing will be removed.
         * </p>
         * 
         * @param thingGroupsToRemove
         *        The groups from which the thing will be removed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingGroupsToRemove(String... thingGroupsToRemove);

        /**
         * <p>
         * Override dynamic thing groups with static thing groups when 10-group limit is reached. If a thing belongs to
         * 10 thing groups, and one or more of those groups are dynamic thing groups, adding a thing to a static group
         * removes the thing from the last dynamic group.
         * </p>
         * 
         * @param overrideDynamicGroups
         *        Override dynamic thing groups with static thing groups when 10-group limit is reached. If a thing
         *        belongs to 10 thing groups, and one or more of those groups are dynamic thing groups, adding a thing
         *        to a static group removes the thing from the last dynamic group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder overrideDynamicGroups(Boolean overrideDynamicGroups);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String thingName;

        private List<String> thingGroupsToAdd = DefaultSdkAutoConstructList.getInstance();

        private List<String> thingGroupsToRemove = DefaultSdkAutoConstructList.getInstance();

        private Boolean overrideDynamicGroups;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateThingGroupsForThingRequest model) {
            super(model);
            thingName(model.thingName);
            thingGroupsToAdd(model.thingGroupsToAdd);
            thingGroupsToRemove(model.thingGroupsToRemove);
            overrideDynamicGroups(model.overrideDynamicGroups);
        }

        public final String getThingName() {
            return thingName;
        }

        public final void setThingName(String thingName) {
            this.thingName = thingName;
        }

        @Override
        public final Builder thingName(String thingName) {
            this.thingName = thingName;
            return this;
        }

        public final Collection<String> getThingGroupsToAdd() {
            if (thingGroupsToAdd instanceof SdkAutoConstructList) {
                return null;
            }
            return thingGroupsToAdd;
        }

        public final void setThingGroupsToAdd(Collection<String> thingGroupsToAdd) {
            this.thingGroupsToAdd = ThingGroupListCopier.copy(thingGroupsToAdd);
        }

        @Override
        public final Builder thingGroupsToAdd(Collection<String> thingGroupsToAdd) {
            this.thingGroupsToAdd = ThingGroupListCopier.copy(thingGroupsToAdd);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder thingGroupsToAdd(String... thingGroupsToAdd) {
            thingGroupsToAdd(Arrays.asList(thingGroupsToAdd));
            return this;
        }

        public final Collection<String> getThingGroupsToRemove() {
            if (thingGroupsToRemove instanceof SdkAutoConstructList) {
                return null;
            }
            return thingGroupsToRemove;
        }

        public final void setThingGroupsToRemove(Collection<String> thingGroupsToRemove) {
            this.thingGroupsToRemove = ThingGroupListCopier.copy(thingGroupsToRemove);
        }

        @Override
        public final Builder thingGroupsToRemove(Collection<String> thingGroupsToRemove) {
            this.thingGroupsToRemove = ThingGroupListCopier.copy(thingGroupsToRemove);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder thingGroupsToRemove(String... thingGroupsToRemove) {
            thingGroupsToRemove(Arrays.asList(thingGroupsToRemove));
            return this;
        }

        public final Boolean getOverrideDynamicGroups() {
            return overrideDynamicGroups;
        }

        public final void setOverrideDynamicGroups(Boolean overrideDynamicGroups) {
            this.overrideDynamicGroups = overrideDynamicGroups;
        }

        @Override
        public final Builder overrideDynamicGroups(Boolean overrideDynamicGroups) {
            this.overrideDynamicGroups = overrideDynamicGroups;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateThingGroupsForThingRequest build() {
            return new UpdateThingGroupsForThingRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
