/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output from the CreatePolicy operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreatePolicyResponse extends IotResponse implements
        ToCopyableBuilder<CreatePolicyResponse.Builder, CreatePolicyResponse> {
    private static final SdkField<String> POLICY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("policyName").getter(getter(CreatePolicyResponse::policyName)).setter(setter(Builder::policyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyName").build()).build();

    private static final SdkField<String> POLICY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("policyArn").getter(getter(CreatePolicyResponse::policyArn)).setter(setter(Builder::policyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyArn").build()).build();

    private static final SdkField<String> POLICY_DOCUMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("policyDocument").getter(getter(CreatePolicyResponse::policyDocument))
            .setter(setter(Builder::policyDocument))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyDocument").build()).build();

    private static final SdkField<String> POLICY_VERSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("policyVersionId").getter(getter(CreatePolicyResponse::policyVersionId))
            .setter(setter(Builder::policyVersionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyVersionId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_NAME_FIELD,
            POLICY_ARN_FIELD, POLICY_DOCUMENT_FIELD, POLICY_VERSION_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String policyName;

    private final String policyArn;

    private final String policyDocument;

    private final String policyVersionId;

    private CreatePolicyResponse(BuilderImpl builder) {
        super(builder);
        this.policyName = builder.policyName;
        this.policyArn = builder.policyArn;
        this.policyDocument = builder.policyDocument;
        this.policyVersionId = builder.policyVersionId;
    }

    /**
     * <p>
     * The policy name.
     * </p>
     * 
     * @return The policy name.
     */
    public final String policyName() {
        return policyName;
    }

    /**
     * <p>
     * The policy ARN.
     * </p>
     * 
     * @return The policy ARN.
     */
    public final String policyArn() {
        return policyArn;
    }

    /**
     * <p>
     * The JSON document that describes the policy.
     * </p>
     * 
     * @return The JSON document that describes the policy.
     */
    public final String policyDocument() {
        return policyDocument;
    }

    /**
     * <p>
     * The policy version ID.
     * </p>
     * 
     * @return The policy version ID.
     */
    public final String policyVersionId() {
        return policyVersionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(policyName());
        hashCode = 31 * hashCode + Objects.hashCode(policyArn());
        hashCode = 31 * hashCode + Objects.hashCode(policyDocument());
        hashCode = 31 * hashCode + Objects.hashCode(policyVersionId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePolicyResponse)) {
            return false;
        }
        CreatePolicyResponse other = (CreatePolicyResponse) obj;
        return Objects.equals(policyName(), other.policyName()) && Objects.equals(policyArn(), other.policyArn())
                && Objects.equals(policyDocument(), other.policyDocument())
                && Objects.equals(policyVersionId(), other.policyVersionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreatePolicyResponse").add("PolicyName", policyName()).add("PolicyArn", policyArn())
                .add("PolicyDocument", policyDocument()).add("PolicyVersionId", policyVersionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "policyName":
            return Optional.ofNullable(clazz.cast(policyName()));
        case "policyArn":
            return Optional.ofNullable(clazz.cast(policyArn()));
        case "policyDocument":
            return Optional.ofNullable(clazz.cast(policyDocument()));
        case "policyVersionId":
            return Optional.ofNullable(clazz.cast(policyVersionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("policyName", POLICY_NAME_FIELD);
        map.put("policyArn", POLICY_ARN_FIELD);
        map.put("policyDocument", POLICY_DOCUMENT_FIELD);
        map.put("policyVersionId", POLICY_VERSION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreatePolicyResponse, T> g) {
        return obj -> g.apply((CreatePolicyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreatePolicyResponse> {
        /**
         * <p>
         * The policy name.
         * </p>
         * 
         * @param policyName
         *        The policy name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyName(String policyName);

        /**
         * <p>
         * The policy ARN.
         * </p>
         * 
         * @param policyArn
         *        The policy ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyArn(String policyArn);

        /**
         * <p>
         * The JSON document that describes the policy.
         * </p>
         * 
         * @param policyDocument
         *        The JSON document that describes the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyDocument(String policyDocument);

        /**
         * <p>
         * The policy version ID.
         * </p>
         * 
         * @param policyVersionId
         *        The policy version ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyVersionId(String policyVersionId);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private String policyName;

        private String policyArn;

        private String policyDocument;

        private String policyVersionId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePolicyResponse model) {
            super(model);
            policyName(model.policyName);
            policyArn(model.policyArn);
            policyDocument(model.policyDocument);
            policyVersionId(model.policyVersionId);
        }

        public final String getPolicyName() {
            return policyName;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final String getPolicyArn() {
            return policyArn;
        }

        public final void setPolicyArn(String policyArn) {
            this.policyArn = policyArn;
        }

        @Override
        public final Builder policyArn(String policyArn) {
            this.policyArn = policyArn;
            return this;
        }

        public final String getPolicyDocument() {
            return policyDocument;
        }

        public final void setPolicyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
        }

        @Override
        public final Builder policyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        public final String getPolicyVersionId() {
            return policyVersionId;
        }

        public final void setPolicyVersionId(String policyVersionId) {
            this.policyVersionId = policyVersionId;
        }

        @Override
        public final Builder policyVersionId(String policyVersionId) {
            this.policyVersionId = policyVersionId;
            return this;
        }

        @Override
        public CreatePolicyResponse build() {
            return new CreatePolicyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
