/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCertificateProvidersRequest extends IotRequest implements
        ToCopyableBuilder<ListCertificateProvidersRequest.Builder, ListCertificateProvidersRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListCertificateProvidersRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<Boolean> ASCENDING_ORDER_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ascendingOrder").getter(getter(ListCertificateProvidersRequest::ascendingOrder))
            .setter(setter(Builder::ascendingOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("isAscendingOrder").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            ASCENDING_ORDER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final Boolean ascendingOrder;

    private ListCertificateProvidersRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.ascendingOrder = builder.ascendingOrder;
    }

    /**
     * <p>
     * The token for the next set of results, or <code>null</code> if there are no more results.
     * </p>
     * 
     * @return The token for the next set of results, or <code>null</code> if there are no more results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Returns the list of certificate providers in ascending alphabetical order.
     * </p>
     * 
     * @return Returns the list of certificate providers in ascending alphabetical order.
     */
    public final Boolean ascendingOrder() {
        return ascendingOrder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(ascendingOrder());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCertificateProvidersRequest)) {
            return false;
        }
        ListCertificateProvidersRequest other = (ListCertificateProvidersRequest) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(ascendingOrder(), other.ascendingOrder());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListCertificateProvidersRequest").add("NextToken", nextToken())
                .add("AscendingOrder", ascendingOrder()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "ascendingOrder":
            return Optional.ofNullable(clazz.cast(ascendingOrder()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("isAscendingOrder", ASCENDING_ORDER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCertificateProvidersRequest, T> g) {
        return obj -> g.apply((ListCertificateProvidersRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListCertificateProvidersRequest> {
        /**
         * <p>
         * The token for the next set of results, or <code>null</code> if there are no more results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results, or <code>null</code> if there are no more results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Returns the list of certificate providers in ascending alphabetical order.
         * </p>
         * 
         * @param ascendingOrder
         *        Returns the list of certificate providers in ascending alphabetical order.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ascendingOrder(Boolean ascendingOrder);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String nextToken;

        private Boolean ascendingOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCertificateProvidersRequest model) {
            super(model);
            nextToken(model.nextToken);
            ascendingOrder(model.ascendingOrder);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Boolean getAscendingOrder() {
            return ascendingOrder;
        }

        public final void setAscendingOrder(Boolean ascendingOrder) {
            this.ascendingOrder = ascendingOrder;
        }

        @Override
        public final Builder ascendingOrder(Boolean ascendingOrder) {
            this.ascendingOrder = ascendingOrder;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListCertificateProvidersRequest build() {
            return new ListCertificateProvidersRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
