/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSbomValidationResultsRequest extends IotRequest implements
        ToCopyableBuilder<ListSbomValidationResultsRequest.Builder, ListSbomValidationResultsRequest> {
    private static final SdkField<String> PACKAGE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("packageName").getter(getter(ListSbomValidationResultsRequest::packageName))
            .setter(setter(Builder::packageName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("packageName").build()).build();

    private static final SdkField<String> VERSION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("versionName").getter(getter(ListSbomValidationResultsRequest::versionName))
            .setter(setter(Builder::versionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("versionName").build()).build();

    private static final SdkField<String> VALIDATION_RESULT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("validationResult").getter(getter(ListSbomValidationResultsRequest::validationResultAsString))
            .setter(setter(Builder::validationResult))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("validationResult").build())
            .build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListSbomValidationResultsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListSbomValidationResultsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PACKAGE_NAME_FIELD,
            VERSION_NAME_FIELD, VALIDATION_RESULT_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String packageName;

    private final String versionName;

    private final String validationResult;

    private final Integer maxResults;

    private final String nextToken;

    private ListSbomValidationResultsRequest(BuilderImpl builder) {
        super(builder);
        this.packageName = builder.packageName;
        this.versionName = builder.versionName;
        this.validationResult = builder.validationResult;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The name of the new software package.
     * </p>
     * 
     * @return The name of the new software package.
     */
    public final String packageName() {
        return packageName;
    }

    /**
     * <p>
     * The name of the new package version.
     * </p>
     * 
     * @return The name of the new package version.
     */
    public final String versionName() {
        return versionName;
    }

    /**
     * <p>
     * The end result of the
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #validationResult}
     * will return {@link SbomValidationResult#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #validationResultAsString}.
     * </p>
     * 
     * @return The end result of the
     * @see SbomValidationResult
     */
    public final SbomValidationResult validationResult() {
        return SbomValidationResult.fromValue(validationResult);
    }

    /**
     * <p>
     * The end result of the
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #validationResult}
     * will return {@link SbomValidationResult#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #validationResultAsString}.
     * </p>
     * 
     * @return The end result of the
     * @see SbomValidationResult
     */
    public final String validationResultAsString() {
        return validationResult;
    }

    /**
     * <p>
     * The maximum number of results to return at one time.
     * </p>
     * 
     * @return The maximum number of results to return at one time.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * A token that can be used to retrieve the next set of results, or null if there are no additional results.
     * </p>
     * 
     * @return A token that can be used to retrieve the next set of results, or null if there are no additional results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(packageName());
        hashCode = 31 * hashCode + Objects.hashCode(versionName());
        hashCode = 31 * hashCode + Objects.hashCode(validationResultAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSbomValidationResultsRequest)) {
            return false;
        }
        ListSbomValidationResultsRequest other = (ListSbomValidationResultsRequest) obj;
        return Objects.equals(packageName(), other.packageName()) && Objects.equals(versionName(), other.versionName())
                && Objects.equals(validationResultAsString(), other.validationResultAsString())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListSbomValidationResultsRequest").add("PackageName", packageName())
                .add("VersionName", versionName()).add("ValidationResult", validationResultAsString())
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "packageName":
            return Optional.ofNullable(clazz.cast(packageName()));
        case "versionName":
            return Optional.ofNullable(clazz.cast(versionName()));
        case "validationResult":
            return Optional.ofNullable(clazz.cast(validationResultAsString()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("packageName", PACKAGE_NAME_FIELD);
        map.put("versionName", VERSION_NAME_FIELD);
        map.put("validationResult", VALIDATION_RESULT_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSbomValidationResultsRequest, T> g) {
        return obj -> g.apply((ListSbomValidationResultsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListSbomValidationResultsRequest> {
        /**
         * <p>
         * The name of the new software package.
         * </p>
         * 
         * @param packageName
         *        The name of the new software package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageName(String packageName);

        /**
         * <p>
         * The name of the new package version.
         * </p>
         * 
         * @param versionName
         *        The name of the new package version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionName(String versionName);

        /**
         * <p>
         * The end result of the
         * </p>
         * 
         * @param validationResult
         *        The end result of the
         * @see SbomValidationResult
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SbomValidationResult
         */
        Builder validationResult(String validationResult);

        /**
         * <p>
         * The end result of the
         * </p>
         * 
         * @param validationResult
         *        The end result of the
         * @see SbomValidationResult
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SbomValidationResult
         */
        Builder validationResult(SbomValidationResult validationResult);

        /**
         * <p>
         * The maximum number of results to return at one time.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return at one time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * A token that can be used to retrieve the next set of results, or null if there are no additional results.
         * </p>
         * 
         * @param nextToken
         *        A token that can be used to retrieve the next set of results, or null if there are no additional
         *        results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IotRequest.BuilderImpl implements Builder {
        private String packageName;

        private String versionName;

        private String validationResult;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSbomValidationResultsRequest model) {
            super(model);
            packageName(model.packageName);
            versionName(model.versionName);
            validationResult(model.validationResult);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getPackageName() {
            return packageName;
        }

        public final void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        @Override
        public final Builder packageName(String packageName) {
            this.packageName = packageName;
            return this;
        }

        public final String getVersionName() {
            return versionName;
        }

        public final void setVersionName(String versionName) {
            this.versionName = versionName;
        }

        @Override
        public final Builder versionName(String versionName) {
            this.versionName = versionName;
            return this;
        }

        public final String getValidationResult() {
            return validationResult;
        }

        public final void setValidationResult(String validationResult) {
            this.validationResult = validationResult;
        }

        @Override
        public final Builder validationResult(String validationResult) {
            this.validationResult = validationResult;
            return this;
        }

        @Override
        public final Builder validationResult(SbomValidationResult validationResult) {
            this.validationResult(validationResult == null ? null : validationResult.toString());
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListSbomValidationResultsRequest build() {
            return new ListSbomValidationResultsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
