/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDetectMitigationActionsTaskResponse extends IotResponse implements
        ToCopyableBuilder<DescribeDetectMitigationActionsTaskResponse.Builder, DescribeDetectMitigationActionsTaskResponse> {
    private static final SdkField<DetectMitigationActionsTaskSummary> TASK_SUMMARY_FIELD = SdkField
            .<DetectMitigationActionsTaskSummary> builder(MarshallingType.SDK_POJO).memberName("taskSummary")
            .getter(getter(DescribeDetectMitigationActionsTaskResponse::taskSummary)).setter(setter(Builder::taskSummary))
            .constructor(DetectMitigationActionsTaskSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskSummary").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TASK_SUMMARY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final DetectMitigationActionsTaskSummary taskSummary;

    private DescribeDetectMitigationActionsTaskResponse(BuilderImpl builder) {
        super(builder);
        this.taskSummary = builder.taskSummary;
    }

    /**
     * <p>
     * The description of a task.
     * </p>
     * 
     * @return The description of a task.
     */
    public final DetectMitigationActionsTaskSummary taskSummary() {
        return taskSummary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(taskSummary());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDetectMitigationActionsTaskResponse)) {
            return false;
        }
        DescribeDetectMitigationActionsTaskResponse other = (DescribeDetectMitigationActionsTaskResponse) obj;
        return Objects.equals(taskSummary(), other.taskSummary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDetectMitigationActionsTaskResponse").add("TaskSummary", taskSummary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "taskSummary":
            return Optional.ofNullable(clazz.cast(taskSummary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("taskSummary", TASK_SUMMARY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeDetectMitigationActionsTaskResponse, T> g) {
        return obj -> g.apply((DescribeDetectMitigationActionsTaskResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeDetectMitigationActionsTaskResponse> {
        /**
         * <p>
         * The description of a task.
         * </p>
         * 
         * @param taskSummary
         *        The description of a task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskSummary(DetectMitigationActionsTaskSummary taskSummary);

        /**
         * <p>
         * The description of a task.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link DetectMitigationActionsTaskSummary.Builder} avoiding the need to create one manually via
         * {@link DetectMitigationActionsTaskSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DetectMitigationActionsTaskSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #taskSummary(DetectMitigationActionsTaskSummary)}.
         * 
         * @param taskSummary
         *        a consumer that will call methods on {@link DetectMitigationActionsTaskSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #taskSummary(DetectMitigationActionsTaskSummary)
         */
        default Builder taskSummary(Consumer<DetectMitigationActionsTaskSummary.Builder> taskSummary) {
            return taskSummary(DetectMitigationActionsTaskSummary.builder().applyMutation(taskSummary).build());
        }
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private DetectMitigationActionsTaskSummary taskSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDetectMitigationActionsTaskResponse model) {
            super(model);
            taskSummary(model.taskSummary);
        }

        public final DetectMitigationActionsTaskSummary.Builder getTaskSummary() {
            return taskSummary != null ? taskSummary.toBuilder() : null;
        }

        public final void setTaskSummary(DetectMitigationActionsTaskSummary.BuilderImpl taskSummary) {
            this.taskSummary = taskSummary != null ? taskSummary.build() : null;
        }

        @Override
        public final Builder taskSummary(DetectMitigationActionsTaskSummary taskSummary) {
            this.taskSummary = taskSummary;
            return this;
        }

        @Override
        public DescribeDetectMitigationActionsTaskResponse build() {
            return new DescribeDetectMitigationActionsTaskResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
